# generated by datamodel-codegen:
#   filename:  swagger.yaml
#   timestamp: 2022-06-29T08:55:53+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union

from loguru import logger
from pydantic import AnyUrl, BaseModel, Extra, Field, root_validator


class Model(BaseModel):
    __root__: Any


class Error(BaseModel):
    code: Optional[str] = Field(None, description="The error code")
    message: Optional[str] = Field(None, description="The error message")


class SearchRepository(BaseModel):
    project_id: Optional[int] = Field(
        None, description="The ID of the project that the repository belongs to"
    )
    project_name: Optional[str] = Field(
        None, description="The name of the project that the repository belongs to"
    )
    project_public: Optional[bool] = Field(
        None,
        description="The flag to indicate the publicity of the project that the repository belongs to (1 is public, 0 is not)",
    )
    repository_name: Optional[str] = Field(
        None, description="The name of the repository"
    )
    pull_count: Optional[int] = Field(
        None, description="The count how many times the repository is pulled"
    )
    artifact_count: Optional[int] = Field(
        None, description="The count of artifacts in the repository"
    )


class ChartMetadata(BaseModel):
    name: str = Field(..., description="The name of the chart")
    home: Optional[str] = Field(
        None, description="The URL to the relevant project page"
    )
    sources: Optional[List[str]] = Field(
        None, description="The URL to the source code of chart"
    )
    version: str = Field(..., description="A SemVer 2 version of chart")
    description: Optional[str] = Field(
        None, description="A one-sentence description of chart"
    )
    keywords: Optional[List[str]] = Field(None, description="A list of string keywords")
    engine: str = Field(..., description="The name of template engine")
    icon: str = Field(..., description="The URL to an icon file")
    api_version: str = Field(
        ..., alias="apiVersion", description="The API version of this chart"
    )
    app_version: str = Field(
        ...,
        alias="appVersion",
        description="The version of the application enclosed in the chart",
    )
    deprecated: Optional[bool] = Field(
        None, description="Whether or not this chart is deprecated"
    )


class Repository(BaseModel):
    id: Optional[int] = Field(None, description="The ID of the repository")
    project_id: Optional[int] = Field(
        None, description="The ID of the project that the repository belongs to"
    )
    name: Optional[str] = Field(None, description="The name of the repository")
    description: Optional[str] = Field(
        None, description="The description of the repository"
    )
    artifact_count: Optional[int] = Field(
        None, description="The count of the artifacts inside the repository"
    )
    pull_count: Optional[int] = Field(
        None, description="The count that the artifact inside the repository pulled"
    )
    creation_time: Optional[datetime] = Field(
        None, description="The creation time of the repository"
    )
    update_time: Optional[datetime] = Field(
        None, description="The update time of the repository"
    )

    @property
    def base_name(self) -> Optional[str]:
        """The repository name without the project name

        Returns
        -------
        Optional[str]
            The basename of the repository name
        """
        s = self.split_name()
        return s[1] if s else None

    @property
    def project_name(self) -> Optional[str]:
        """The name of the project that the repository belongs to

        Returns
        -------
        Optional[str]
            The name of the project that the repository belongs to
        """
        s = self.split_name()
        return s[0] if s else None

    # TODO: cache?
    def split_name(self) -> Optional[List[str]]:
        """Split name into tuple of project and repository name

        Returns
        -------
        Optional[List[str]]
            The tuple of <project> and <repo>
        """
        if not self.name:
            return None
        components = self.name.split("/", 1)
        if len(components) == 1:  # no slash in name
            # Shouldn't happen, but we account for it anyway
            logger.warning(
                "Repository '{}' name is not in the format <project>/<repo>", self.name
            )
            return None
        return components


class Tag(BaseModel):
    id: Optional[int] = Field(None, description="The ID of the tag")
    repository_id: Optional[int] = Field(
        None, description="The ID of the repository that the tag belongs to"
    )
    artifact_id: Optional[int] = Field(
        None, description="The ID of the artifact that the tag attached to"
    )
    name: Optional[str] = Field(None, description="The name of the tag")
    push_time: Optional[datetime] = Field(None, description="The push time of the tag")
    pull_time: Optional[datetime] = Field(
        None, description="The latest pull time of the tag"
    )
    immutable: Optional[bool] = Field(
        None, description="The immutable status of the tag"
    )
    signed: Optional[bool] = Field(
        None, description="The attribute indicates whether the tag is signed or not"
    )


class ExtraAttrs(BaseModel):
    pass

    class Config:
        extra = Extra.allow


class Annotations(BaseModel):
    pass

    class Config:
        extra = Extra.allow


class AdditionLinks(BaseModel):
    pass

    class Config:
        extra = Extra.allow


class AdditionLink(BaseModel):
    href: Optional[str] = Field(None, description="The link of the addition")
    absolute: Optional[bool] = Field(
        None, description="Determine whether the link is an absolute URL or not"
    )


class Platform(BaseModel):
    architecture: Optional[str] = Field(
        None, description="The architecture that the artifact applys to"
    )
    os: Optional[str] = Field(None, description="The OS that the artifact applys to")
    _os_version_: Optional[str] = Field(
        None,
        alias="'os.version'",
        description="The version of the OS that the artifact applys to",
    )
    _os_features_: Optional[List[str]] = Field(
        None,
        alias="'os.features'",
        description="The features of the OS that the artifact applys to",
    )
    variant: Optional[str] = Field(None, description="The variant of the CPU")


class Label(BaseModel):
    id: Optional[int] = Field(None, description="The ID of the label")
    name: Optional[str] = Field(None, description="The name the label")
    description: Optional[str] = Field(None, description="The description the label")
    color: Optional[str] = Field(None, description="The color the label")
    scope: Optional[str] = Field(None, description="The scope the label")
    project_id: Optional[int] = Field(
        None, description="The ID of project that the label belongs to"
    )
    creation_time: Optional[datetime] = Field(
        None, description="The creation time the label"
    )
    update_time: Optional[datetime] = Field(
        None, description="The update time of the label"
    )


class Scanner(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of the scanner", example="Trivy"
    )
    vendor: Optional[str] = Field(
        None, description="Name of the scanner provider", example="Aqua Security"
    )
    version: Optional[str] = Field(
        None, description="Version of the scanner adapter", example="v0.9.1"
    )


class ScanOverview(BaseModel):
    """Constructs a scan overview from a dict of `mime_type:scan_overview`

    The API spec does not specify the contents of the scan overview, but from
    investigating the behavior of the API, it seems to return a dict that looks like this:

    ```py
    {
        "application/vnd.security.vulnerability.report; version=1.1": {
            # dict that conforms to NativeReportSummary spec
            ...
        }
    }
    ```

    The `__new__` method constructs a `NativeReportSummary` object and returns it
    if the MIME type is one of the two MIME types specified in the spec.

    If the MIME type is not recognized, `__new__` returns a `ScanOverview` object
    with the dict assigned as an extra attribute. This behavior is not specified.
    """

    # TODO: make this way less hacky
    def __new__(  # type: ignore # mypy doesn't like __new__ that returns different classes
        cls, *args: Any, **kwargs: Any
    ) -> Union["ScanOverview", NativeReportSummary]:
        mime_types = (
            "application/vnd.scanner.adapter.vuln.report.harbor+json; version=1.0",
            "application/vnd.security.vulnerability.report; version=1.1",
        )
        for k, v in kwargs.items():
            if k in mime_types:
                return NativeReportSummary(**v)
        # add logging call here
        return super().__new__(cls)

    class Config:
        extra = Extra.allow


class VulnerabilitySummary(BaseModel):
    total: Optional[int] = Field(
        None, description="The total number of the found vulnerabilities", example=500
    )
    fixable: Optional[int] = Field(
        None, description="The number of the fixable vulnerabilities", example=100
    )

    # These severity fields are not native to the API spec,
    # but are added to make the API more user friendly by making
    # the severity fields accessible directly instead of through the summary field.
    # See root validator for more details.
    critical: int = Field(
        0,
        alias="Critical",
        description="The number of critical vulnerabilities detected.",
    )
    high: int = Field(
        0, alias="High", description="The number of critical vulnerabilities detected."
    )
    medium: int = Field(
        0,
        alias="Medium",
        description="The number of critical vulnerabilities detected.",
    )
    low: int = Field(
        0, alias="Low", description="The number of critical vulnerabilities detected."
    )

    # The original summary field (prefer using the severity fields above)
    # The field is kept to not remove anything native to the API spec.
    summary: Optional[Dict[str, int]] = Field(
        None,
        description="Numbers of the vulnerabilities with different severity",
        example={"Critical": 5, "High": 5},
    )

    @root_validator(pre=True)
    def assign_severity_breakdown(cls, values: Dict[str, Any]) -> Dict[str, Any]:
        summary = values.get("summary", {})
        if not isinstance(summary, dict):
            raise ValueError("'summary' must be a dict")
        return {**values, **summary}


class AuditLog(BaseModel):
    id: Optional[int] = Field(None, description="The ID of the audit log entry.")
    username: Optional[str] = Field(
        None, description="Username of the user in this log entry."
    )
    resource: Optional[str] = Field(
        None, description="Name of the repository in this log entry."
    )
    resource_type: Optional[str] = Field(
        None, description="Tag of the repository in this log entry."
    )
    operation: Optional[str] = Field(
        None, description="The operation against the repository in this log entry."
    )
    op_time: Optional[datetime] = Field(
        None,
        description="The time when this operation is triggered.",
        example="2006-01-02T15:04:05Z",
    )


class Metadata(BaseModel):
    id: Optional[str] = Field(None, description="id")
    name: Optional[str] = Field(None, description="name")
    icon: Optional[str] = Field(None, description="icon")
    maintainers: Optional[List[str]] = Field(None, description="maintainers")
    version: Optional[str] = Field(None, description="version")
    source: Optional[str] = Field(None, description="source")


class Instance(BaseModel):
    id: Optional[int] = Field(None, description="Unique ID")
    name: Optional[str] = Field(None, description="Instance name")
    description: Optional[str] = Field(None, description="Description of instance")
    vendor: Optional[str] = Field(
        None, description="Based on which driver, identified by ID"
    )
    endpoint: Optional[str] = Field(
        None, description="The service endpoint of this instance"
    )
    auth_mode: Optional[str] = Field(
        None, description="The authentication way supported"
    )
    auth_info: Optional[Dict[str, str]] = Field(
        None, description="The auth credential data if exists"
    )
    status: Optional[str] = Field(None, description="The health status")
    enabled: Optional[bool] = Field(
        None, description="Whether the instance is activated or not"
    )
    default: Optional[bool] = Field(
        None, description="Whether the instance is default or not"
    )
    insecure: Optional[bool] = Field(
        None, description="Whether the instance endpoint is insecure or not"
    )
    setup_timestamp: Optional[int] = Field(
        None, description="The timestamp of instance setting up"
    )


class PreheatPolicy(BaseModel):
    id: Optional[int] = Field(None, description="The ID of preheat policy")
    name: Optional[str] = Field(None, description="The Name of preheat policy")
    description: Optional[str] = Field(
        None, description="The Description of preheat policy"
    )
    project_id: Optional[int] = Field(
        None, description="The ID of preheat policy project"
    )
    provider_id: Optional[int] = Field(
        None, description="The ID of preheat policy provider"
    )
    provider_name: Optional[str] = Field(
        None, description="The Name of preheat policy provider"
    )
    filters: Optional[str] = Field(None, description="The Filters of preheat policy")
    trigger: Optional[str] = Field(None, description="The Trigger of preheat policy")
    enabled: Optional[bool] = Field(
        None, description="Whether the preheat policy enabled"
    )
    creation_time: Optional[datetime] = Field(
        None, description="The Create Time of preheat policy"
    )
    update_time: Optional[datetime] = Field(
        None, description="The Update Time of preheat policy"
    )


class Metrics(BaseModel):
    task_count: Optional[int] = Field(None, description="The count of task")
    success_task_count: Optional[int] = Field(
        None, description="The count of success task"
    )
    error_task_count: Optional[int] = Field(None, description="The count of error task")
    pending_task_count: Optional[int] = Field(
        None, description="The count of pending task"
    )
    running_task_count: Optional[int] = Field(
        None, description="The count of running task"
    )
    scheduled_task_count: Optional[int] = Field(
        None, description="The count of scheduled task"
    )
    stopped_task_count: Optional[int] = Field(
        None, description="The count of stopped task"
    )


class Execution(BaseModel):
    id: Optional[int] = Field(None, description="The ID of execution")
    vendor_type: Optional[str] = Field(None, description="The vendor type of execution")
    vendor_id: Optional[int] = Field(None, description="The vendor id of execution")
    status: Optional[str] = Field(None, description="The status of execution")
    status_message: Optional[str] = Field(
        None, description="The status message of execution"
    )
    metrics: Optional[Metrics] = None
    trigger: Optional[str] = Field(None, description="The trigger of execution")
    extra_attrs: Optional[ExtraAttrs] = None
    start_time: Optional[str] = Field(None, description="The start time of execution")
    end_time: Optional[str] = Field(None, description="The end time of execution")


class Task(BaseModel):
    id: Optional[int] = Field(None, description="The ID of task")
    execution_id: Optional[int] = Field(None, description="The ID of task execution")
    status: Optional[str] = Field(None, description="The status of task")
    status_message: Optional[str] = Field(
        None, description="The status message of task"
    )
    run_count: Optional[int] = Field(None, description="The count of task run")
    extra_attrs: Optional[ExtraAttrs] = None
    creation_time: Optional[str] = Field(None, description="The creation time of task")
    update_time: Optional[str] = Field(None, description="The update time of task")
    start_time: Optional[str] = Field(None, description="The start time of task")
    end_time: Optional[str] = Field(None, description="The end time of task")


class ProviderUnderProject(BaseModel):
    id: Optional[int] = None
    provider: Optional[str] = None
    enabled: Optional[bool] = None
    default: Optional[bool] = None


class Icon(BaseModel):
    content_type: Optional[str] = Field(
        None, alias="content-type", description="The content type of the icon"
    )
    content: Optional[str] = Field(
        None, description="The base64 encoded content of the icon"
    )


class ProjectDeletable(BaseModel):
    deletable: Optional[bool] = Field(
        None, description="Whether the project can be deleted."
    )
    message: Optional[str] = Field(
        None, description="The detail message when the project can not be deleted."
    )


class ProjectMetadata(BaseModel):
    public: Optional[str] = Field(
        None,
        description='The public status of the project. The valid values are "true", "false".',
    )
    enable_content_trust: Optional[str] = Field(
        None,
        description='Whether content trust is enabled or not. If it is enabled, user can\'t pull unsigned images from this project. The valid values are "true", "false".',
    )
    enable_content_trust_cosign: Optional[str] = Field(
        None,
        description='Whether cosign content trust is enabled or not. If it is enabled, user can\'t pull images without cosign signature from this project. The valid values are "true", "false".',
    )
    prevent_vul: Optional[str] = Field(
        None,
        description='Whether prevent the vulnerable images from running. The valid values are "true", "false".',
    )
    severity: Optional[str] = Field(
        None,
        description='If the vulnerability is high than severity defined here, the images can\'t be pulled. The valid values are "none", "low", "medium", "high", "critical".',
    )
    auto_scan: Optional[str] = Field(
        None,
        description='Whether scan images automatically when pushing. The valid values are "true", "false".',
    )
    reuse_sys_cve_allowlist: Optional[str] = Field(
        None,
        description='Whether this project reuse the system level CVE allowlist as the allowlist of its own.  The valid values are "true", "false". If it is set to "true" the actual allowlist associate with this project, if any, will be ignored.',
    )
    retention_id: Optional[str] = Field(
        None, description="The ID of the tag retention policy for the project"
    )


class ProjectScanner(BaseModel):
    uuid: str = Field(..., description="The identifier of the scanner registration")


class CVEAllowlistItem(BaseModel):
    cve_id: Optional[str] = Field(
        None, description='The ID of the CVE, such as "CVE-2019-10164"'
    )


class ReplicationTriggerSettings(BaseModel):
    cron: Optional[str] = Field(
        None, description="The cron string for scheduled trigger"
    )


class ReplicationFilter(BaseModel):
    type: Optional[str] = Field(None, description="The replication policy filter type.")
    value: Optional[Dict[str, Any]] = Field(
        None, description="The value of replication policy filter."
    )
    decoration: Optional[str] = Field(
        None, description="matches or excludes the result"
    )


class RegistryCredential(BaseModel):
    type: Optional[str] = Field(
        None, description="Credential type, such as 'basic', 'oauth'."
    )
    access_key: Optional[str] = Field(
        None, description="Access key, e.g. user name when credential type is 'basic'."
    )
    access_secret: Optional[str] = Field(
        None,
        description="Access secret, e.g. password when credential type is 'basic'.",
    )


class Registry(BaseModel):
    id: Optional[int] = Field(None, description="The registry ID.")
    url: Optional[str] = Field(None, description="The registry URL string.")
    name: Optional[str] = Field(None, description="The registry name.")
    credential: Optional[RegistryCredential] = None
    type: Optional[str] = Field(
        None, description="Type of the registry, e.g. 'harbor'."
    )
    insecure: Optional[bool] = Field(
        None,
        description="Whether or not the certificate will be verified when Harbor tries to access the server.",
    )
    description: Optional[str] = Field(None, description="Description of the registry.")
    status: Optional[str] = Field(None, description="Health status of the registry.")
    creation_time: Optional[datetime] = Field(
        None, description="The create time of the policy."
    )
    update_time: Optional[datetime] = Field(
        None, description="The update time of the policy."
    )


class RegistryUpdate(BaseModel):
    name: Optional[str] = Field(None, description="The registry name.")
    description: Optional[str] = Field(None, description="Description of the registry.")
    url: Optional[str] = Field(None, description="The registry URL.")
    credential_type: Optional[str] = Field(
        None, description="Credential type of the registry, e.g. 'basic'."
    )
    access_key: Optional[str] = Field(None, description="The registry access key.")
    access_secret: Optional[str] = Field(
        None, description="The registry access secret."
    )
    insecure: Optional[bool] = Field(
        None,
        description="Whether or not the certificate will be verified when Harbor tries to access the server.",
    )


class RegistryPing(BaseModel):
    id: Optional[int] = Field(None, description="The registry ID.")
    type: Optional[str] = Field(
        None, description="Type of the registry, e.g. 'harbor'."
    )
    url: Optional[str] = Field(None, description="The registry URL.")
    credential_type: Optional[str] = Field(
        None, description="Credential type of the registry, e.g. 'basic'."
    )
    access_key: Optional[str] = Field(None, description="The registry access key.")
    access_secret: Optional[str] = Field(
        None, description="The registry access secret."
    )
    insecure: Optional[bool] = Field(
        None,
        description="Whether or not the certificate will be verified when Harbor tries to access the server.",
    )


class RegistryProviderCredentialPattern(BaseModel):
    access_key_type: Optional[str] = Field(None, description="The access key type")
    access_key_data: Optional[str] = Field(None, description="The access key data")
    access_secret_type: Optional[str] = Field(
        None, description="The access secret type"
    )
    access_secret_data: Optional[str] = Field(
        None, description="The access secret data"
    )


class RegistryEndpoint(BaseModel):
    key: Optional[str] = Field(None, description="The endpoint key")
    value: Optional[str] = Field(None, description="The endpoint value")


class FilterStyle(BaseModel):
    type: Optional[str] = Field(None, description="The filter type")
    style: Optional[str] = Field(None, description="The filter style")
    values: Optional[List[str]] = Field(None, description="The filter values")


class ResourceList(BaseModel):
    pass

    class Config:
        extra = Extra.allow


class ReplicationExecution(BaseModel):
    id: Optional[int] = Field(None, description="The ID of the execution")
    policy_id: Optional[int] = Field(
        None, description="The ID if the policy that the execution belongs to"
    )
    status: Optional[str] = Field(None, description="The status of the execution")
    trigger: Optional[str] = Field(None, description="The trigger mode")
    start_time: Optional[datetime] = Field(None, description="The start time")
    end_time: Optional[datetime] = Field(None, description="The end time")
    status_text: Optional[str] = Field(None, description="The status text")
    total: Optional[int] = Field(None, description="The total count of all executions")
    failed: Optional[int] = Field(None, description="The count of failed executions")
    succeed: Optional[int] = Field(None, description="The count of succeed executions")
    in_progress: Optional[int] = Field(
        None, description="The count of in_progress executions"
    )
    stopped: Optional[int] = Field(None, description="The count of stopped executions")


class StartReplicationExecution(BaseModel):
    policy_id: Optional[int] = Field(
        None, description="The ID of policy that the execution belongs to."
    )


class ReplicationTask(BaseModel):
    id: Optional[int] = Field(None, description="The ID of the task")
    execution_id: Optional[int] = Field(
        None, description="The ID of the execution that the task belongs to"
    )
    status: Optional[str] = Field(None, description="The status of the task")
    job_id: Optional[str] = Field(
        None, description="The ID of the underlying job that the task related to"
    )
    operation: Optional[str] = Field(None, description="The operation of the task")
    resource_type: Optional[str] = Field(
        None, description="The type of the resource that the task operates"
    )
    src_resource: Optional[str] = Field(
        None, description="The source resource that the task operates"
    )
    dst_resource: Optional[str] = Field(
        None, description="The destination resource that the task operates"
    )
    start_time: Optional[datetime] = Field(
        None, description="The start time of the task"
    )
    end_time: Optional[datetime] = Field(None, description="The end time of the task")


class RobotCreated(BaseModel):
    id: Optional[int] = Field(None, description="The ID of the robot")
    name: Optional[str] = Field(None, description="The name of the tag")
    secret: Optional[str] = Field(None, description="The secret of the robot")
    creation_time: Optional[datetime] = Field(
        None, description="The creation time of the robot."
    )
    expires_at: Optional[int] = Field(
        None, description="The expiration data of the robot"
    )


class RobotSec(BaseModel):
    secret: Optional[str] = Field(None, description="The secret of the robot")


class Access(BaseModel):
    resource: Optional[str] = Field(None, description="The resource of the access")
    action: Optional[str] = Field(None, description="The action of the access")
    effect: Optional[str] = Field(None, description="The effect of the access")


class RobotCreateV1(BaseModel):
    name: Optional[str] = Field(None, description="The name of robot account")
    description: Optional[str] = Field(
        None, description="The description of robot account"
    )
    expires_at: Optional[int] = Field(
        None,
        description="The expiration time on or after which the JWT MUST NOT be accepted for processing.",
    )
    access: Optional[List[Access]] = Field(
        None, description="The permission of robot account"
    )


class Storage(BaseModel):
    total: Optional[int] = Field(None, description="Total volume size.")
    free: Optional[int] = Field(None, description="Free volume size.")


class AuthproxySetting(BaseModel):
    endpoint: Optional[str] = Field(
        None,
        description="The fully qualified URI of login endpoint of authproxy, such as 'https://192.168.1.2:8443/login'",
    )
    tokenreivew_endpoint: Optional[str] = Field(
        None,
        description="The fully qualified URI of token review endpoint of authproxy, such as 'https://192.168.1.2:8443/tokenreview'",
    )
    skip_search: Optional[bool] = Field(
        None,
        description="The flag to determine whether Harbor can skip search the user/group when adding him as a member.",
    )
    verify_cert: Optional[bool] = Field(
        None,
        description="The flag to determine whether Harbor should verify the certificate when connecting to the auth proxy.",
    )
    server_certificate: Optional[str] = Field(
        None, description="The certificate to be pinned when connecting auth proxy."
    )


class SystemInfo(BaseModel):
    storage: Optional[List[Storage]] = Field(None, description="The storage of system.")


class Type(Enum):
    hourly = "Hourly"
    daily = "Daily"
    weekly = "Weekly"
    custom = "Custom"
    manual = "Manual"
    none = "None"


class ScheduleObj(BaseModel):
    type: Optional[Type] = Field(
        None,
        description="The schedule type. The valid values are 'Hourly', 'Daily', 'Weekly', 'Custom', 'Manual' and 'None'.\n'Manual' means to trigger it right away and 'None' means to cancel the schedule.\n",
    )
    cron: Optional[str] = Field(
        None, description="A cron expression, a time-based job scheduler."
    )
    next_scheduled_time: Optional[datetime] = Field(
        None, description="The next time to schedule to run the job."
    )


class Trigger(Enum):
    manual = "Manual"
    schedule = "Schedule"
    event = "Event"


class Stats(BaseModel):
    total: Optional[int] = Field(
        None,
        description="The total number of scan processes triggered by the scan all action",
        example=100,
    )
    completed: Optional[int] = Field(
        None,
        description="The number of the finished scan processes triggered by the scan all action",
        example=90,
    )
    metrics: Optional[Dict[str, int]] = Field(
        None,
        description="The metrics data for the each status",
        example={"Success": 5, "Error": 2, "Running": 3},
    )
    ongoing: Optional[bool] = Field(
        None, description="A flag indicating job status of scan all."
    )
    trigger: Optional[Trigger] = Field(
        None, description="The trigger of the scan all job."
    )


class RetentionRuleParamMetadata(BaseModel):
    type: Optional[str] = None
    unit: Optional[str] = None
    required: Optional[bool] = None


class RetentionSelectorMetadata(BaseModel):
    display_text: Optional[str] = None
    kind: Optional[str] = None
    decorations: Optional[List[str]] = None


class RetentionRuleTrigger(BaseModel):
    kind: Optional[str] = None
    settings: Optional[Dict[str, Any]] = None
    references: Optional[Dict[str, Any]] = None


class RetentionPolicyScope(BaseModel):
    level: Optional[str] = None
    ref: Optional[int] = None


class RetentionSelector(BaseModel):
    kind: Optional[str] = None
    decoration: Optional[str] = None
    pattern: Optional[str] = None
    extras: Optional[str] = None


class RetentionExecution(BaseModel):
    id: Optional[int] = None
    policy_id: Optional[int] = None
    start_time: Optional[str] = None
    end_time: Optional[str] = None
    status: Optional[str] = None
    trigger: Optional[str] = None
    dry_run: Optional[bool] = None


class RetentionExecutionTask(BaseModel):
    id: Optional[int] = None
    execution_id: Optional[int] = None
    repository: Optional[str] = None
    job_id: Optional[str] = None
    status: Optional[str] = None
    status_code: Optional[int] = None
    status_revision: Optional[int] = None
    start_time: Optional[str] = None
    end_time: Optional[str] = None
    total: Optional[int] = None
    retained: Optional[int] = None


class QuotaUpdateReq(BaseModel):
    hard: Optional[ResourceList] = Field(
        None, description="The new hard limits for the quota"
    )


class QuotaRefObject(BaseModel):
    pass

    class Config:
        extra = Extra.allow


class Quota(BaseModel):
    id: Optional[int] = Field(None, description="ID of the quota")
    ref: Optional[QuotaRefObject] = Field(
        None, description="The reference object of the quota"
    )
    hard: Optional[ResourceList] = Field(
        None, description="The hard limits of the quota"
    )
    used: Optional[ResourceList] = Field(
        None, description="The used status of the quota"
    )
    creation_time: Optional[datetime] = Field(
        None, description="the creation time of the quota"
    )
    update_time: Optional[datetime] = Field(
        None, description="the update time of the quota"
    )


class ScannerRegistration(BaseModel):
    uuid: Optional[str] = Field(
        None, description="The unique identifier of this registration."
    )
    name: Optional[str] = Field(
        None, description="The name of this registration.", example="Trivy"
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this registration.",
        example="A free-to-use tool that scans container images for package vulnerabilities.\n",
    )
    url: Optional[str] = Field(
        None,
        description="A base URL of the scanner adapter",
        example="http://harbor-scanner-trivy:8080",
    )
    disabled: Optional[bool] = Field(
        False, description="Indicate whether the registration is enabled or not"
    )
    is_default: Optional[bool] = Field(
        False,
        description="Indicate if the registration is set as the system default one",
    )
    auth: Optional[str] = Field(
        "",
        description='Specify what authentication approach is adopted for the HTTP communications.\nSupported types Basic", "Bearer" and api key header "X-ScannerAdapter-API-Key"\n',
        example="Bearer",
    )
    access_credential: Optional[str] = Field(
        None,
        description="An optional value of the HTTP Authorization header sent with each request to the Scanner Adapter API.\n",
        example="Bearer: JWTTOKENGOESHERE",
    )
    skip_cert_verify: Optional[bool] = Field(
        False,
        alias="skip_certVerify",
        description="Indicate if skip the certificate verification when sending HTTP requests",
    )
    use_internal_addr: Optional[bool] = Field(
        False,
        description="Indicate whether use internal registry addr for the scanner to pull content or not",
    )
    create_time: Optional[datetime] = Field(
        None, description="The creation time of this registration"
    )
    update_time: Optional[datetime] = Field(
        None, description="The update time of this registration"
    )
    adapter: Optional[str] = Field(
        None,
        description="Optional property to describe the name of the scanner registration",
        example="Trivy",
    )
    vendor: Optional[str] = Field(
        None,
        description="Optional property to describe the vendor of the scanner registration",
        example="CentOS",
    )
    version: Optional[str] = Field(
        None,
        description="Optional property to describe the version of the scanner registration",
        example="1.0.1",
    )
    health: Optional[str] = Field(
        "", description="Indicate the healthy of the registration", example="healthy"
    )


class ScannerRegistrationReq(BaseModel):
    name: str = Field(..., description="The name of this registration", example="Trivy")
    description: Optional[str] = Field(
        None,
        description="An optional description of this registration.",
        example="A free-to-use tool that scans container images for package vulnerabilities.\n",
    )
    url: AnyUrl = Field(
        ...,
        description="A base URL of the scanner adapter.",
        example="http://harbor-scanner-trivy:8080",
    )
    auth: Optional[str] = Field(
        None,
        description='Specify what authentication approach is adopted for the HTTP communications.\nSupported types Basic", "Bearer" and api key header "X-ScannerAdapter-API-Key"\n',
        example="Bearer",
    )
    access_credential: Optional[str] = Field(
        None,
        description="An optional value of the HTTP Authorization header sent with each request to the Scanner Adapter API.\n",
        example="Bearer: JWTTOKENGOESHERE",
    )
    skip_cert_verify: Optional[bool] = Field(
        False,
        alias="skip_certVerify",
        description="Indicate if skip the certificate verification when sending HTTP requests",
    )
    use_internal_addr: Optional[bool] = Field(
        False,
        description="Indicate whether use internal registry addr for the scanner to pull content or not",
    )
    disabled: Optional[bool] = Field(
        False, description="Indicate whether the registration is enabled or not"
    )


class ScannerRegistrationSettings(BaseModel):
    name: str = Field(..., description="The name of this registration", example="Trivy")
    url: AnyUrl = Field(
        ...,
        description="A base URL of the scanner adapter.",
        example="http://harbor-scanner-trivy:8080",
    )
    auth: Optional[str] = Field(
        "",
        description='Specify what authentication approach is adopted for the HTTP communications.\nSupported types Basic", "Bearer" and api key header "X-ScannerAdapter-API-Key"\n',
    )
    access_credential: Optional[str] = Field(
        None,
        description="An optional value of the HTTP Authorization header sent with each request to the Scanner Adapter API.\n",
        example="Bearer: JWTTOKENGOESHERE",
    )


class IsDefault(BaseModel):
    is_default: Optional[bool] = Field(
        None, description="A flag indicating whether a scanner registration is default."
    )


class ScannerCapability(BaseModel):
    consumes_mime_types: Optional[List[str]] = None
    produces_mime_types: Optional[List[str]] = None


class ScannerAdapterMetadata(BaseModel):
    scanner: Optional[Scanner] = None
    capabilities: Optional[List[ScannerCapability]] = None
    properties: Optional[Dict[str, str]] = Field(
        None, example={"harbor.scanner-adapter/registry-authorization-type": "Bearer"}
    )


class ImmutableSelector(BaseModel):
    kind: Optional[str] = None
    decoration: Optional[str] = None
    pattern: Optional[str] = None
    extras: Optional[str] = None


class LdapConf(BaseModel):
    ldap_url: Optional[str] = Field(None, description="The url of ldap service.")
    ldap_search_dn: Optional[str] = Field(
        None, description="The search dn of ldap service."
    )
    ldap_search_password: Optional[str] = Field(
        None, description="The search password of ldap service."
    )
    ldap_base_dn: Optional[str] = Field(
        None, description="The base dn of ldap service."
    )
    ldap_filter: Optional[str] = Field(
        None, description="The serach filter of ldap service."
    )
    ldap_uid: Optional[str] = Field(
        None, description="The serach uid from ldap service attributes."
    )
    ldap_scope: Optional[int] = Field(
        None, description="The serach scope of ldap service."
    )
    ldap_connection_timeout: Optional[int] = Field(
        None, description="The connect timeout of ldap service(second)."
    )
    ldap_verify_cert: Optional[bool] = Field(
        None, description="Verify Ldap server certificate."
    )


class LdapPingResult(BaseModel):
    success: Optional[bool] = Field(None, description="Test success")
    message: Optional[str] = Field(
        None, description="The ping operation output message."
    )


class LdapImportUsers(BaseModel):
    ldap_uid_list: Optional[List[str]] = Field(None, description="selected uid list")


class LdapFailedImportUser(BaseModel):
    uid: Optional[str] = Field(None, description="the uid can't add to system.")
    error: Optional[str] = Field(None, description="fail reason.")


class LdapUser(BaseModel):
    username: Optional[str] = Field(None, description="ldap username.")
    realname: Optional[str] = Field(
        None, description='The user realname from "uid" or "cn" attribute.'
    )
    email: Optional[str] = Field(
        None, description='The user email address from "mail" or "email" attribute.'
    )


class UserGroup(BaseModel):
    id: Optional[int] = Field(None, description="The ID of the user group")
    group_name: Optional[str] = Field(None, description="The name of the user group")
    group_type: Optional[int] = Field(
        None, description="The group type, 1 for LDAP group, 2 for HTTP group."
    )
    ldap_group_dn: Optional[str] = Field(
        None, description="The DN of the LDAP group if group type is 1 (LDAP group)."
    )


class UserGroupSearchItem(BaseModel):
    id: Optional[int] = Field(None, description="The ID of the user group")
    group_name: Optional[str] = Field(None, description="The name of the user group")
    group_type: Optional[int] = Field(
        None, description="The group type, 1 for LDAP group, 2 for HTTP group."
    )


class EventType(BaseModel):
    __root__: str = Field(
        ..., description="Webhook supportted event type.", example="pullImage"
    )


class NotifyType(BaseModel):
    __root__: str = Field(
        ..., description="Webhook supportted notify type.", example="http"
    )


class WebhookTargetObject(BaseModel):
    type: Optional[str] = Field(None, description="The webhook target notify type.")
    address: Optional[str] = Field(None, description="The webhook target address.")
    auth_header: Optional[str] = Field(None, description="The webhook auth header.")
    skip_cert_verify: Optional[bool] = Field(
        None, description="Whether or not to skip cert verify."
    )


class WebhookPolicy(BaseModel):
    id: Optional[int] = Field(None, description="The webhook policy ID.")
    name: Optional[str] = Field(None, description="The name of webhook policy.")
    description: Optional[str] = Field(
        None, description="The description of webhook policy."
    )
    project_id: Optional[int] = Field(
        None, description="The project ID of webhook policy."
    )
    targets: Optional[List[WebhookTargetObject]] = None
    event_types: Optional[List[str]] = None
    creator: Optional[str] = Field(
        None, description="The creator of the webhook policy."
    )
    creation_time: Optional[datetime] = Field(
        None, description="The create time of the webhook policy."
    )
    update_time: Optional[datetime] = Field(
        None, description="The update time of the webhook policy."
    )
    enabled: Optional[bool] = Field(
        None, description="Whether the webhook policy is enabled or not."
    )


class WebhookLastTrigger(BaseModel):
    policy_name: Optional[str] = Field(None, description="The webhook policy name.")
    event_type: Optional[str] = Field(None, description="The webhook event type.")
    enabled: Optional[bool] = Field(
        None, description="Whether or not the webhook policy enabled."
    )
    creation_time: Optional[datetime] = Field(
        None, description="The creation time of webhook policy."
    )
    last_trigger_time: Optional[datetime] = Field(
        None, description="The last trigger time of webhook policy."
    )


class WebhookJob(BaseModel):
    id: Optional[int] = Field(None, description="The webhook job ID.")
    policy_id: Optional[int] = Field(None, description="The webhook policy ID.")
    event_type: Optional[str] = Field(None, description="The webhook job event type.")
    notify_type: Optional[str] = Field(None, description="The webhook job notify type.")
    status: Optional[str] = Field(None, description="The webhook job status.")
    job_detail: Optional[str] = Field(
        None, description="The webhook job notify detailed data."
    )
    creation_time: Optional[datetime] = Field(
        None, description="The webhook job creation time."
    )
    update_time: Optional[datetime] = Field(
        None, description="The webhook job update time."
    )


class InternalConfigurationsResponse(BaseModel):
    pass

    class Config:
        extra = Extra.allow


class InternalConfigurationValue(BaseModel):
    value: Optional[Dict[str, Any]] = Field(
        None, description="The value of current config item"
    )
    editable: Optional[bool] = Field(
        None, description="The configure item can be updated or not"
    )


class Parameter(BaseModel):
    daily_time: Optional[int] = Field(
        None,
        description='The offset in seconds of UTC 0 o\'clock, only valid when the policy type is "daily"',
    )


class ScanAllPolicy(BaseModel):
    type: Optional[str] = Field(
        None,
        description='The type of scan all policy, currently the valid values are "none" and "daily"',
    )
    parameter: Optional[Parameter] = Field(
        None,
        description="The parameters of the policy, the values are dependent on the type of the policy.",
    )


class Configurations(BaseModel):
    auth_mode: Optional[str] = Field(
        None,
        description='The auth mode of current system, such as "db_auth", "ldap_auth", "oidc_auth"',
    )
    email_from: Optional[str] = Field(
        None, description="The sender name for Email notification."
    )
    email_host: Optional[str] = Field(
        None, description="The hostname of SMTP server that sends Email notification."
    )
    email_identity: Optional[str] = Field(
        None, description="By default it's empty so the email_username is picked"
    )
    email_insecure: Optional[bool] = Field(
        None,
        description="Whether or not the certificate will be verified when Harbor tries to access the email server.",
    )
    email_password: Optional[str] = Field(None, description="Email password")
    email_port: Optional[int] = Field(None, description="The port of SMTP server")
    email_ssl: Optional[bool] = Field(
        None,
        description="When it''s set to true the system will access Email server via TLS by default.  If it''s set to false, it still will handle \"STARTTLS\" from server side.",
    )
    email_username: Optional[str] = Field(
        None, description="The username for authenticate against SMTP server"
    )
    ldap_base_dn: Optional[str] = Field(
        None, description="The Base DN for LDAP binding."
    )
    ldap_filter: Optional[str] = Field(None, description="The filter for LDAP search")
    ldap_group_base_dn: Optional[str] = Field(
        None, description="The base DN to search LDAP group."
    )
    ldap_group_admin_dn: Optional[str] = Field(
        None,
        description="Specify the ldap group which have the same privilege with Harbor admin",
    )
    ldap_group_attribute_name: Optional[str] = Field(
        None,
        description="The attribute which is used as identity of the LDAP group, default is cn.'",
    )
    ldap_group_search_filter: Optional[str] = Field(
        None, description="The filter to search the ldap group"
    )
    ldap_group_search_scope: Optional[int] = Field(
        None,
        description="The scope to search ldap group. ''0-LDAP_SCOPE_BASE, 1-LDAP_SCOPE_ONELEVEL, 2-LDAP_SCOPE_SUBTREE''",
    )
    ldap_scope: Optional[int] = Field(
        None,
        description="The scope to search ldap users,'0-LDAP_SCOPE_BASE, 1-LDAP_SCOPE_ONELEVEL, 2-LDAP_SCOPE_SUBTREE'",
    )
    ldap_search_dn: Optional[str] = Field(
        None, description="The DN of the user to do the search."
    )
    ldap_search_password: Optional[str] = Field(
        None, description="The password of the ldap search dn"
    )
    ldap_timeout: Optional[int] = Field(
        None, description="Timeout in seconds for connection to LDAP server"
    )
    ldap_uid: Optional[str] = Field(
        None,
        description='The attribute which is used as identity for the LDAP binding, such as "CN" or "SAMAccountname"',
    )
    ldap_url: Optional[str] = Field(None, description="The URL of LDAP server")
    ldap_verify_cert: Optional[bool] = Field(
        None,
        description="Whether verify your OIDC server certificate, disable it if your OIDC server is hosted via self-hosted certificate.",
    )
    ldap_group_membership_attribute: Optional[str] = Field(
        None, description="The user attribute to identify the group membership"
    )
    project_creation_restriction: Optional[str] = Field(
        None,
        description="Indicate who can create projects, it could be ''adminonly'' or ''everyone''.",
    )
    read_only: Optional[bool] = Field(
        None, description="The flag to indicate whether Harbor is in readonly mode."
    )
    self_registration: Optional[bool] = Field(
        None,
        description="Whether the Harbor instance supports self-registration.  If it''s set to false, admin need to add user to the instance.",
    )
    token_expiration: Optional[int] = Field(
        None,
        description="The expiration time of the token for internal Registry, in minutes.",
    )
    uaa_client_id: Optional[str] = Field(None, description="The client id of UAA")
    uaa_client_secret: Optional[str] = Field(
        None, description="The client secret of the UAA"
    )
    uaa_endpoint: Optional[str] = Field(None, description="The endpoint of the UAA")
    uaa_verify_cert: Optional[bool] = Field(
        None, description="Verify the certificate in UAA server"
    )
    http_authproxy_endpoint: Optional[str] = Field(
        None, description="The endpoint of the HTTP auth"
    )
    http_authproxy_tokenreview_endpoint: Optional[str] = Field(
        None, description="The token review endpoint"
    )
    http_authproxy_admin_groups: Optional[str] = Field(
        None, description="The group which has the harbor admin privileges"
    )
    http_authproxy_admin_usernames: Optional[str] = Field(
        None, description="The username which has the harbor admin privileges"
    )
    http_authproxy_verify_cert: Optional[bool] = Field(
        None, description="Verify the HTTP auth provider's certificate"
    )
    http_authproxy_skip_search: Optional[bool] = Field(
        None, description="Search user before onboard"
    )
    http_authproxy_server_certificate: Optional[str] = Field(
        None, description="The certificate of the HTTP auth provider"
    )
    oidc_name: Optional[str] = Field(None, description="The OIDC provider name")
    oidc_endpoint: Optional[str] = Field(
        None, description="The endpoint of the OIDC provider"
    )
    oidc_client_id: Optional[str] = Field(
        None, description="The client ID of the OIDC provider"
    )
    oidc_client_secret: Optional[str] = Field(
        None, description="The OIDC provider secret"
    )
    oidc_groups_claim: Optional[str] = Field(
        None, description="The attribute claims the group name"
    )
    oidc_admin_group: Optional[str] = Field(
        None, description="The OIDC group which has the harbor admin privileges"
    )
    oidc_scope: Optional[str] = Field(
        None, description="The scope of the OIDC provider"
    )
    oidc_user_claim: Optional[str] = Field(
        None, description="The attribute claims the username"
    )
    oidc_verify_cert: Optional[bool] = Field(
        None, description="Verify the OIDC provider's certificate'"
    )
    oidc_auto_onboard: Optional[bool] = Field(
        None, description="Auto onboard the OIDC user"
    )
    oidc_extra_redirect_parms: Optional[str] = Field(
        None,
        description="Extra parameters to add when redirect request to OIDC provider",
    )
    robot_token_duration: Optional[int] = Field(
        None, description="The robot account token duration in days"
    )
    robot_name_prefix: Optional[str] = Field(
        None, description="The rebot account name prefix"
    )
    notification_enable: Optional[bool] = Field(None, description="Enable notification")
    quota_per_project_enable: Optional[bool] = Field(
        None, description="Enable quota per project"
    )
    storage_per_project: Optional[int] = Field(
        None, description="The storage quota per project"
    )
    audit_log_forward_endpoint: Optional[str] = Field(
        None, description="The audit log forward endpoint"
    )
    skip_audit_log_database: Optional[bool] = Field(
        None, description="Skip audit log database"
    )


class StringConfigItem(BaseModel):
    value: Optional[str] = Field(
        None, description="The string value of current config item"
    )
    editable: Optional[bool] = Field(
        None, description="The configure item can be updated or not"
    )


class BoolConfigItem(BaseModel):
    value: Optional[bool] = Field(
        None, description="The boolean value of current config item"
    )
    editable: Optional[bool] = Field(
        None, description="The configure item can be updated or not"
    )


class IntegerConfigItem(BaseModel):
    value: Optional[int] = Field(
        None, description="The integer value of current config item"
    )
    editable: Optional[bool] = Field(
        None, description="The configure item can be updated or not"
    )


class ProjectMemberEntity(BaseModel):
    id: Optional[int] = Field(None, description="the project member id")
    project_id: Optional[int] = Field(None, description="the project id")
    entity_name: Optional[str] = Field(
        None, description="the name of the group member."
    )
    role_name: Optional[str] = Field(None, description="the name of the role")
    role_id: Optional[int] = Field(None, description="the role id")
    entity_id: Optional[int] = Field(
        None,
        description="the id of entity, if the member is a user, it is user_id in user table. if the member is a user group, it is the user group's ID in user_group table.",
    )
    entity_type: Optional[str] = Field(
        None, description="the entity's type, u for user entity, g for group entity."
    )


class RoleRequest(BaseModel):
    role_id: Optional[int] = Field(
        None,
        description="The role id 1 for projectAdmin, 2 for developer, 3 for guest, 4 for maintainer",
    )


class UserEntity(BaseModel):
    user_id: Optional[int] = Field(None, description="The ID of the user.")
    username: Optional[str] = Field(None, description="The name of the user.")


class UserProfile(BaseModel):
    email: Optional[str] = None
    realname: Optional[str] = None
    comment: Optional[str] = None


class UserCreationReq(BaseModel):
    email: Optional[str] = Field(None, max_length=255)
    realname: Optional[str] = None
    comment: Optional[str] = None
    password: Optional[str] = None
    username: Optional[str] = Field(None, max_length=255)


class OIDCUserInfo(BaseModel):
    id: Optional[int] = Field(None, description="the ID of the OIDC info record")
    user_id: Optional[int] = Field(None, description="the ID of the user")
    subiss: Optional[str] = Field(
        None, description="the concatenation of sub and issuer in the ID token"
    )
    secret: Optional[str] = Field(
        None,
        description="the secret of the OIDC user that can be used for CLI to push/pull artifacts",
    )
    creation_time: Optional[datetime] = Field(
        None, description="The creation time of the OIDC user info record."
    )
    update_time: Optional[datetime] = Field(
        None, description="The update time of the OIDC user info record."
    )


class UserResp(BaseModel):
    email: Optional[str] = None
    realname: Optional[str] = None
    comment: Optional[str] = None
    user_id: Optional[int] = None
    username: Optional[str] = None
    sysadmin_flag: Optional[bool] = None
    admin_role_in_auth: Optional[bool] = Field(
        None,
        description="indicate the admin privilege is grant by authenticator (LDAP), is always false unless it is the current login user",
    )
    oidc_user_meta: Optional[OIDCUserInfo] = None
    creation_time: Optional[datetime] = Field(
        None, description="The creation time of the user."
    )
    update_time: Optional[datetime] = Field(
        None, description="The update time of the user."
    )


class UserSysAdminFlag(BaseModel):
    sysadmin_flag: Optional[bool] = Field(
        None, description="true-admin, false-not admin."
    )


class UserSearch(BaseModel):
    user_id: Optional[int] = Field(None, description="The ID of the user.")
    username: Optional[str] = None


class PasswordReq(BaseModel):
    old_password: Optional[str] = Field(
        None, description="The user's existing password."
    )
    new_password: Optional[str] = Field(
        None, description="New password for marking as to be updated."
    )


class UserSearchRespItem(BaseModel):
    user_id: Optional[int] = Field(None, description="The ID of the user.")
    username: Optional[str] = None


class Permission(BaseModel):
    resource: Optional[str] = Field(None, description="The permission resoruce")
    action: Optional[str] = Field(None, description="The permission action")


class OIDCCliSecretReq(BaseModel):
    secret: Optional[str] = Field(None, description="The new secret")


class ComponentHealthStatus(BaseModel):
    name: Optional[str] = Field(None, description="The component name")
    status: Optional[str] = Field(None, description="The health status of component")
    error: Optional[str] = Field(
        None, description='(optional) The error message when the status is "unhealthy"'
    )


class Statistic(BaseModel):
    private_project_count: Optional[int] = Field(
        None, description="The count of the private projects"
    )
    private_repo_count: Optional[int] = Field(
        None, description="The count of the private repositories"
    )
    public_project_count: Optional[int] = Field(
        None, description="The count of the public projects"
    )
    public_repo_count: Optional[int] = Field(
        None, description="The count of the public repositories"
    )
    total_project_count: Optional[int] = Field(
        None,
        description="The count of the total projects, only be seen by the system admin",
    )
    total_repo_count: Optional[int] = Field(
        None,
        description="The count of the total repositories, only be seen by the system admin",
    )
    total_storage_consumption: Optional[int] = Field(
        None,
        description="The total storage consumption of blobs, only be seen by the system admin",
    )


class Accessory(BaseModel):
    id: Optional[int] = Field(None, description="The ID of the accessory")
    artifact_id: Optional[int] = Field(
        None, description="The artifact id of the accessory"
    )
    subject_artifact_id: Optional[int] = Field(
        None, description="The subject artifact id of the accessory"
    )
    size: Optional[int] = Field(None, description="The artifact size of the accessory")
    digest: Optional[str] = Field(
        None, description="The artifact digest of the accessory"
    )
    type: Optional[str] = Field(None, description="The artifact size of the accessory")
    icon: Optional[str] = Field(None, description="The icon of the accessory")
    creation_time: Optional[datetime] = Field(
        None, description="The creation time of the accessory"
    )


class Errors(BaseModel):
    errors: Optional[List[Error]] = None


class ChartVersion(ChartMetadata):
    created: Optional[str] = Field(
        None, description="The created time of the chart entry"
    )
    removed: Optional[bool] = Field(
        None, description="A flag to indicate if the chart entry is removed"
    )
    digest: Optional[str] = Field(
        None, description="The digest value of the chart entry"
    )
    urls: Optional[List[str]] = Field(None, description="The urls of the chart entry")
    labels: Optional[List[Label]] = Field(None, description="A list of label")


class Reference(BaseModel):
    parent_id: Optional[int] = Field(None, description="The parent ID of the reference")
    child_id: Optional[int] = Field(None, description="The child ID of the reference")
    child_digest: Optional[str] = Field(
        None, description="The digest of the child artifact"
    )
    platform: Optional[Platform] = None
    annotations: Optional[Annotations] = None
    urls: Optional[List[str]] = Field(None, description="The download URLs")


class NativeReportSummary(BaseModel):
    report_id: Optional[str] = Field(
        None,
        description="id of the native scan report",
        example="5f62c830-f996-11e9-957f-0242c0a89008",
    )
    scan_status: Optional[str] = Field(
        None,
        description="The status of the report generating process",
        example="Success",
    )
    severity: Optional[str] = Field(
        None, description="The overall severity", example="High"
    )
    duration: Optional[int] = Field(
        None, description="The seconds spent for generating the report", example=300
    )
    summary: Optional[VulnerabilitySummary] = None
    start_time: Optional[datetime] = Field(
        None,
        description="The start time of the scan process that generating report",
        example="2006-01-02T14:04:05Z",
    )
    end_time: Optional[datetime] = Field(
        None,
        description="The end time of the scan process that generating report",
        example="2006-01-02T15:04:05Z",
    )
    complete_percent: Optional[int] = Field(
        None,
        description="The complete percent of the scanning which value is between 0 and 100",
        example=100,
    )
    scanner: Optional[Scanner] = None


class ProjectSummaryQuota(BaseModel):
    hard: Optional[ResourceList] = Field(
        None, description="The hard limits of the quota"
    )
    used: Optional[ResourceList] = Field(
        None, description="The used status of the quota"
    )


class CVEAllowlist(BaseModel):
    id: Optional[int] = Field(None, description="ID of the allowlist")
    project_id: Optional[int] = Field(
        None,
        description="ID of the project which the allowlist belongs to.  For system level allowlist this attribute is zero.",
    )
    expires_at: Optional[int] = Field(
        None,
        description="the time for expiration of the allowlist, in the form of seconds since epoch.  This is an optional attribute, if it's not set the CVE allowlist does not expire.",
    )
    items: Optional[List[CVEAllowlistItem]] = None
    creation_time: Optional[datetime] = Field(
        None, description="The creation time of the allowlist."
    )
    update_time: Optional[datetime] = Field(
        None, description="The update time of the allowlist."
    )


class ReplicationTrigger(BaseModel):
    type: Optional[str] = Field(
        None,
        description="The replication policy trigger type. The valid values are manual, event_based and scheduled.",
    )
    trigger_settings: Optional[ReplicationTriggerSettings] = None


class RegistryInfo(BaseModel):
    type: Optional[str] = Field(None, description="The registry type")
    description: Optional[str] = Field(None, description="The description")
    supported_resource_filters: Optional[List[FilterStyle]] = Field(
        None, description="The filters that the registry supports"
    )
    supported_triggers: Optional[List[str]] = Field(
        None, description="The triggers that the registry supports"
    )


class RegistryProviderEndpointPattern(BaseModel):
    endpoint_type: Optional[str] = Field(None, description="The endpoint type")
    endpoints: Optional[List[RegistryEndpoint]] = Field(
        None, description="The endpoint list"
    )


class RobotPermission(BaseModel):
    kind: Optional[str] = Field(None, description="The kind of the permission")
    namespace: Optional[str] = Field(
        None, description="The namespace of the permission"
    )
    access: Optional[List[Access]] = None


class GeneralInfo(BaseModel):
    current_time: Optional[datetime] = Field(
        None, description="The current time of the server."
    )
    with_notary: Optional[bool] = Field(
        None, description="If the Harbor instance is deployed with nested notary."
    )
    with_chartmuseum: Optional[bool] = Field(
        None, description="If the Harbor instance is deployed with nested chartmuseum."
    )
    registry_url: Optional[str] = Field(
        None,
        description="The url of registry against which the docker command should be issued.",
    )
    external_url: Optional[str] = Field(
        None, description="The external URL of Harbor, with protocol."
    )
    auth_mode: Optional[str] = Field(
        None, description="The auth mode of current Harbor instance."
    )
    project_creation_restriction: Optional[str] = Field(
        None,
        description="Indicate who can create projects, it could be 'adminonly' or 'everyone'.",
    )
    self_registration: Optional[bool] = Field(
        None,
        description="Indicate whether the Harbor instance enable user to register himself.",
    )
    has_ca_root: Optional[bool] = Field(
        None,
        description="Indicate whether there is a ca root cert file ready for download in the file system.",
    )
    harbor_version: Optional[str] = Field(
        None, description="The build version of Harbor."
    )
    registry_storage_provider_name: Optional[str] = Field(
        None, description="The storage provider's name of Harbor registry"
    )
    read_only: Optional[bool] = Field(
        None, description="The flag to indicate whether Harbor is in readonly mode."
    )
    notification_enable: Optional[bool] = Field(
        None,
        description="The flag to indicate whether notification mechanism is enabled on Harbor instance.",
    )
    authproxy_settings: Optional[AuthproxySetting] = Field(
        None,
        description="The setting of auth proxy this is only available when Harbor relies on authproxy for authentication.",
    )


class GCHistory(BaseModel):
    id: Optional[int] = Field(None, description="the id of gc job.")
    job_name: Optional[str] = Field(None, description="the job name of gc job.")
    job_kind: Optional[str] = Field(None, description="the job kind of gc job.")
    job_parameters: Optional[str] = Field(
        None, description="the job parameters of gc job."
    )
    schedule: Optional[ScheduleObj] = None
    job_status: Optional[str] = Field(None, description="the status of gc job.")
    deleted: Optional[bool] = Field(None, description="if gc job was deleted.")
    creation_time: Optional[datetime] = Field(
        None, description="the creation time of gc job."
    )
    update_time: Optional[datetime] = Field(
        None, description="the update time of gc job."
    )


class ExecHistory(BaseModel):
    id: Optional[int] = Field(None, description="the id of purge job.")
    job_name: Optional[str] = Field(None, description="the job name of purge job.")
    job_kind: Optional[str] = Field(None, description="the job kind of purge job.")
    job_parameters: Optional[str] = Field(
        None, description="the job parameters of purge job."
    )
    schedule: Optional[ScheduleObj] = None
    job_status: Optional[str] = Field(None, description="the status of purge job.")
    deleted: Optional[bool] = Field(None, description="if purge job was deleted.")
    creation_time: Optional[datetime] = Field(
        None, description="the creation time of purge job."
    )
    update_time: Optional[datetime] = Field(
        None, description="the update time of purge job."
    )


class Schedule(BaseModel):
    id: Optional[int] = Field(None, description="The id of the schedule.")
    status: Optional[str] = Field(None, description="The status of the schedule.")
    creation_time: Optional[datetime] = Field(
        None, description="the creation time of the schedule."
    )
    update_time: Optional[datetime] = Field(
        None, description="the update time of the schedule."
    )
    schedule: Optional[ScheduleObj] = None
    parameters: Optional[Dict[str, Dict[str, Any]]] = Field(
        None, description="The parameters of schedule job"
    )


class RetentionRuleMetadata(BaseModel):
    rule_template: Optional[str] = Field(None, description="rule id")
    display_text: Optional[str] = Field(None, description="rule display text")
    action: Optional[str] = Field(None, description="rule action")
    params: Optional[List[RetentionRuleParamMetadata]] = Field(
        None, description="rule params"
    )


class RetentionRule(BaseModel):
    id: Optional[int] = None
    priority: Optional[int] = None
    disabled: Optional[bool] = None
    action: Optional[str] = None
    template: Optional[str] = None
    params: Optional[Dict[str, Dict[str, Any]]] = None
    tag_selectors: Optional[List[RetentionSelector]] = None
    scope_selectors: Optional[Dict[str, List[RetentionSelector]]] = None


class ImmutableRule(BaseModel):
    id: Optional[int] = None
    priority: Optional[int] = None
    disabled: Optional[bool] = None
    action: Optional[str] = None
    template: Optional[str] = None
    params: Optional[Dict[str, Dict[str, Any]]] = None
    tag_selectors: Optional[List[ImmutableSelector]] = None
    scope_selectors: Optional[Dict[str, List[ImmutableSelector]]] = None


class SupportedWebhookEventTypes(BaseModel):
    event_type: Optional[List[EventType]] = None
    notify_type: Optional[List[NotifyType]] = None


class ConfigurationsResponse(BaseModel):
    auth_mode: Optional[StringConfigItem] = Field(
        None,
        description='The auth mode of current system, such as "db_auth", "ldap_auth", "oidc_auth"',
    )
    email_from: Optional[StringConfigItem] = Field(
        None, description="The sender name for Email notification."
    )
    email_host: Optional[StringConfigItem] = Field(
        None, description="The hostname of SMTP server that sends Email notification."
    )
    email_identity: Optional[StringConfigItem] = Field(
        None, description="By default it's empty so the email_username is picked"
    )
    email_insecure: Optional[BoolConfigItem] = Field(
        None,
        description="Whether or not the certificate will be verified when Harbor tries to access the email server.",
    )
    email_port: Optional[IntegerConfigItem] = Field(
        None, description="The port of SMTP server"
    )
    email_ssl: Optional[BoolConfigItem] = Field(
        None,
        description="When it''s set to true the system will access Email server via TLS by default.  If it''s set to false, it still will handle \"STARTTLS\" from server side.",
    )
    email_username: Optional[StringConfigItem] = Field(
        None, description="The username for authenticate against SMTP server"
    )
    ldap_base_dn: Optional[StringConfigItem] = Field(
        None, description="The Base DN for LDAP binding."
    )
    ldap_filter: Optional[StringConfigItem] = Field(
        None, description="The filter for LDAP search"
    )
    ldap_group_base_dn: Optional[StringConfigItem] = Field(
        None, description="The base DN to search LDAP group."
    )
    ldap_group_admin_dn: Optional[StringConfigItem] = Field(
        None,
        description="Specify the ldap group which have the same privilege with Harbor admin",
    )
    ldap_group_attribute_name: Optional[StringConfigItem] = Field(
        None,
        description="The attribute which is used as identity of the LDAP group, default is cn.'",
    )
    ldap_group_search_filter: Optional[StringConfigItem] = Field(
        None, description="The filter to search the ldap group"
    )
    ldap_group_search_scope: Optional[IntegerConfigItem] = Field(
        None,
        description="The scope to search ldap group. ''0-LDAP_SCOPE_BASE, 1-LDAP_SCOPE_ONELEVEL, 2-LDAP_SCOPE_SUBTREE''",
    )
    ldap_scope: Optional[IntegerConfigItem] = Field(
        None,
        description="The scope to search ldap users,'0-LDAP_SCOPE_BASE, 1-LDAP_SCOPE_ONELEVEL, 2-LDAP_SCOPE_SUBTREE'",
    )
    ldap_search_dn: Optional[StringConfigItem] = Field(
        None, description="The DN of the user to do the search."
    )
    ldap_timeout: Optional[IntegerConfigItem] = Field(
        None, description="Timeout in seconds for connection to LDAP server"
    )
    ldap_uid: Optional[StringConfigItem] = Field(
        None,
        description='The attribute which is used as identity for the LDAP binding, such as "CN" or "SAMAccountname"',
    )
    ldap_url: Optional[StringConfigItem] = Field(
        None, description="The URL of LDAP server"
    )
    ldap_verify_cert: Optional[BoolConfigItem] = Field(
        None,
        description="Whether verify your OIDC server certificate, disable it if your OIDC server is hosted via self-hosted certificate.",
    )
    ldap_group_membership_attribute: Optional[StringConfigItem] = Field(
        None, description="The user attribute to identify the group membership"
    )
    project_creation_restriction: Optional[StringConfigItem] = Field(
        None,
        description="Indicate who can create projects, it could be ''adminonly'' or ''everyone''.",
    )
    read_only: Optional[BoolConfigItem] = Field(
        None, description="The flag to indicate whether Harbor is in readonly mode."
    )
    self_registration: Optional[BoolConfigItem] = Field(
        None,
        description="Whether the Harbor instance supports self-registration.  If it''s set to false, admin need to add user to the instance.",
    )
    token_expiration: Optional[IntegerConfigItem] = Field(
        None,
        description="The expiration time of the token for internal Registry, in minutes.",
    )
    uaa_client_id: Optional[StringConfigItem] = Field(
        None, description="The client id of UAA"
    )
    uaa_client_secret: Optional[StringConfigItem] = Field(
        None, description="The client secret of the UAA"
    )
    uaa_endpoint: Optional[StringConfigItem] = Field(
        None, description="The endpoint of the UAA"
    )
    uaa_verify_cert: Optional[BoolConfigItem] = Field(
        None, description="Verify the certificate in UAA server"
    )
    http_authproxy_endpoint: Optional[StringConfigItem] = Field(
        None, description="The endpoint of the HTTP auth"
    )
    http_authproxy_tokenreview_endpoint: Optional[StringConfigItem] = Field(
        None, description="The token review endpoint"
    )
    http_authproxy_admin_groups: Optional[StringConfigItem] = Field(
        None, description="The group which has the harbor admin privileges"
    )
    http_authproxy_admin_usernames: Optional[StringConfigItem] = Field(
        None, description="The usernames which has the harbor admin privileges"
    )
    http_authproxy_verify_cert: Optional[BoolConfigItem] = Field(
        None, description="Verify the HTTP auth provider's certificate"
    )
    http_authproxy_skip_search: Optional[BoolConfigItem] = Field(
        None, description="Search user before onboard"
    )
    http_authproxy_server_certificate: Optional[StringConfigItem] = Field(
        None, description="The certificate of the HTTP auth provider"
    )
    oidc_name: Optional[StringConfigItem] = Field(
        None, description="The OIDC provider name"
    )
    oidc_endpoint: Optional[StringConfigItem] = Field(
        None, description="The endpoint of the OIDC provider"
    )
    oidc_client_id: Optional[StringConfigItem] = Field(
        None, description="The client ID of the OIDC provider"
    )
    oidc_groups_claim: Optional[StringConfigItem] = Field(
        None, description="The attribute claims the group name"
    )
    oidc_admin_group: Optional[StringConfigItem] = Field(
        None, description="The OIDC group which has the harbor admin privileges"
    )
    oidc_scope: Optional[StringConfigItem] = Field(
        None, description="The scope of the OIDC provider"
    )
    oidc_user_claim: Optional[StringConfigItem] = Field(
        None, description="The attribute claims the username"
    )
    oidc_verify_cert: Optional[BoolConfigItem] = Field(
        None, description="Verify the OIDC provider's certificate'"
    )
    oidc_auto_onboard: Optional[BoolConfigItem] = Field(
        None, description="Auto onboard the OIDC user"
    )
    oidc_extra_redirect_parms: Optional[StringConfigItem] = Field(
        None,
        description="Extra parameters to add when redirect request to OIDC provider",
    )
    robot_token_duration: Optional[IntegerConfigItem] = Field(
        None, description="The robot account token duration in days"
    )
    robot_name_prefix: Optional[StringConfigItem] = Field(
        None, description="The rebot account name prefix"
    )
    notification_enable: Optional[BoolConfigItem] = Field(
        None, description="Enable notification"
    )
    quota_per_project_enable: Optional[BoolConfigItem] = Field(
        None, description="Enable quota per project"
    )
    storage_per_project: Optional[IntegerConfigItem] = Field(
        None, description="The storage quota per project"
    )
    audit_log_forward_endpoint: Optional[StringConfigItem] = Field(
        None, description="The endpoint of the audit log forwarder"
    )
    skip_audit_log_database: Optional[BoolConfigItem] = Field(
        None, description="Whether skip the audit log in database"
    )
    scan_all_policy: Optional[ScanAllPolicy] = None


class ProjectMember(BaseModel):
    role_id: Optional[int] = Field(
        None,
        description="The role id 1 for projectAdmin, 2 for developer, 3 for guest, 4 for maintainer",
    )
    member_user: Optional[UserEntity] = None
    member_group: Optional[UserGroup] = None


class OverallHealthStatus(BaseModel):
    status: Optional[str] = Field(
        None,
        description='The overall health status. It is "healthy" only when all the components\' status are "healthy"',
    )
    components: Optional[List[ComponentHealthStatus]] = None


class SearchResult(BaseModel):
    name: Optional[str] = Field(
        None, alias="Name", description="The chart name with repo name"
    )
    score: Optional[int] = Field(None, alias="Score", description="The matched level")
    chart: Optional[ChartVersion] = Field(None, alias="Chart")


class Artifact(BaseModel):
    id: Optional[int] = Field(None, description="The ID of the artifact")
    type: Optional[str] = Field(
        None, description="The type of the artifact, e.g. image, chart, etc"
    )
    media_type: Optional[str] = Field(
        None, description="The media type of the artifact"
    )
    manifest_media_type: Optional[str] = Field(
        None, description="The manifest media type of the artifact"
    )
    project_id: Optional[int] = Field(
        None, description="The ID of the project that the artifact belongs to"
    )
    repository_id: Optional[int] = Field(
        None, description="The ID of the repository that the artifact belongs to"
    )
    digest: Optional[str] = Field(None, description="The digest of the artifact")
    size: Optional[int] = Field(None, description="The size of the artifact")
    icon: Optional[str] = Field(None, description="The digest of the icon")
    push_time: Optional[datetime] = Field(
        None, description="The push time of the artifact"
    )
    pull_time: Optional[datetime] = Field(
        None, description="The latest pull time of the artifact"
    )
    extra_attrs: Optional[ExtraAttrs] = None
    annotations: Optional[Annotations] = None
    references: Optional[List[Reference]] = None
    tags: Optional[List[Tag]] = None
    addition_links: Optional[AdditionLinks] = None
    labels: Optional[List[Label]] = None
    scan_overview: Optional[ScanOverview] = Field(
        None, description="The overview of the scan result."
    )  # TODO: change type to Optional[Union[ScanOverview, NativeReportSummary]]
    accessories: Optional[List[Accessory]] = None


class ProjectReq(BaseModel):
    project_name: Optional[str] = Field(
        None, description="The name of the project.", max_length=255
    )
    public: Optional[bool] = Field(
        None, description="deprecated, reserved for project creation in replication"
    )
    metadata: Optional[ProjectMetadata] = Field(
        None, description="The metadata of the project."
    )
    cve_allowlist: Optional[CVEAllowlist] = Field(
        None, description="The CVE allowlist of the project."
    )
    storage_limit: Optional[int] = Field(
        None, description="The storage quota of the project."
    )
    registry_id: Optional[int] = Field(
        None,
        description="The ID of referenced registry when creating the proxy cache project",
    )


class Project(BaseModel):
    project_id: Optional[int] = Field(None, description="Project ID")
    owner_id: Optional[int] = Field(
        None,
        description="The owner ID of the project always means the creator of the project.",
    )
    name: Optional[str] = Field(None, description="The name of the project.")
    registry_id: Optional[int] = Field(
        None,
        description="The ID of referenced registry when the project is a proxy cache project.",
    )
    creation_time: Optional[datetime] = Field(
        None, description="The creation time of the project."
    )
    update_time: Optional[datetime] = Field(
        None, description="The update time of the project."
    )
    deleted: Optional[bool] = Field(None, description="A deletion mark of the project.")
    owner_name: Optional[str] = Field(
        None, description="The owner name of the project."
    )
    togglable: Optional[bool] = Field(
        None,
        description="Correspond to the UI about whether the project's publicity is  updatable (for UI)",
    )
    current_user_role_id: Optional[int] = Field(
        None,
        description="The role ID with highest permission of the current user who triggered the API (for UI).  This attribute is deprecated and will be removed in future versions.",
    )
    current_user_role_ids: Optional[List[int]] = Field(
        None,
        description="The list of role ID of the current user who triggered the API (for UI)",
    )
    repo_count: Optional[int] = Field(
        None, description="The number of the repositories under this project."
    )
    chart_count: Optional[int] = Field(
        None, description="The total number of charts under this project."
    )
    metadata: Optional[ProjectMetadata] = Field(
        None, description="The metadata of the project."
    )
    cve_allowlist: Optional[CVEAllowlist] = Field(
        None, description="The CVE allowlist of this project."
    )


class ProjectSummary(BaseModel):
    repo_count: Optional[int] = Field(
        None, description="The number of the repositories under this project."
    )
    chart_count: Optional[int] = Field(
        None, description="The total number of charts under this project."
    )
    project_admin_count: Optional[int] = Field(
        None, description="The total number of project admin members."
    )
    maintainer_count: Optional[int] = Field(
        None, description="The total number of maintainer members."
    )
    developer_count: Optional[int] = Field(
        None, description="The total number of developer members."
    )
    guest_count: Optional[int] = Field(
        None, description="The total number of guest members."
    )
    limited_guest_count: Optional[int] = Field(
        None, description="The total number of limited guest members."
    )
    quota: Optional[ProjectSummaryQuota] = None
    registry: Optional[Registry] = None


class ReplicationPolicy(BaseModel):
    id: Optional[int] = Field(None, description="The policy ID.")
    name: Optional[str] = Field(None, description="The policy name.")
    description: Optional[str] = Field(
        None, description="The description of the policy."
    )
    src_registry: Optional[Registry] = Field(None, description="The source registry.")
    dest_registry: Optional[Registry] = Field(
        None, description="The destination registry."
    )
    dest_namespace: Optional[str] = Field(
        None, description="The destination namespace."
    )
    dest_namespace_replace_count: Optional[int] = Field(
        None,
        description="Specify how many path components will be replaced by the provided destination namespace.\nThe default value is -1 in which case the legacy mode will be applied.",
    )
    trigger: Optional[ReplicationTrigger] = None
    filters: Optional[List[ReplicationFilter]] = Field(
        None, description="The replication policy filter array."
    )
    replicate_deletion: Optional[bool] = Field(
        None, description="Whether to replicate the deletion operation."
    )
    deletion: Optional[bool] = Field(
        None,
        description='Deprecated, use "replicate_deletion" instead. Whether to replicate the deletion operation.',
    )
    override: Optional[bool] = Field(
        None,
        description="Whether to override the resources on the destination registry.",
    )
    enabled: Optional[bool] = Field(
        None, description="Whether the policy is enabled or not."
    )
    creation_time: Optional[datetime] = Field(
        None, description="The create time of the policy."
    )
    update_time: Optional[datetime] = Field(
        None, description="The update time of the policy."
    )
    speed: Optional[int] = Field(None, description="speed limit for each task")


class RegistryProviderInfo(BaseModel):
    endpoint_pattern: Optional[RegistryProviderEndpointPattern] = Field(
        None, description="The endpoint pattern"
    )
    credential_pattern: Optional[RegistryProviderCredentialPattern] = Field(
        None, description="The credential pattern"
    )


class Robot(BaseModel):
    id: Optional[int] = Field(None, description="The ID of the robot")
    name: Optional[str] = Field(None, description="The name of the tag")
    description: Optional[str] = Field(None, description="The description of the robot")
    secret: Optional[str] = Field(None, description="The secret of the robot")
    level: Optional[str] = Field(
        None, description="The level of the robot, project or system"
    )
    duration: Optional[int] = Field(
        None, description="The duration of the robot in days"
    )
    editable: Optional[bool] = Field(
        None, description="The editable status of the robot"
    )
    disable: Optional[bool] = Field(None, description="The disable status of the robot")
    expires_at: Optional[int] = Field(
        None, description="The expiration data of the robot"
    )
    permissions: Optional[List[RobotPermission]] = None
    creation_time: Optional[datetime] = Field(
        None, description="The creation time of the robot."
    )
    update_time: Optional[datetime] = Field(
        None, description="The update time of the robot."
    )


class RobotCreate(BaseModel):
    name: Optional[str] = Field(None, description="The name of the tag")
    description: Optional[str] = Field(None, description="The description of the robot")
    secret: Optional[str] = Field(None, description="The secret of the robot")
    level: Optional[str] = Field(
        None, description="The level of the robot, project or system"
    )
    disable: Optional[bool] = Field(None, description="The disable status of the robot")
    duration: Optional[int] = Field(
        None, description="The duration of the robot in days"
    )
    permissions: Optional[List[RobotPermission]] = None


class RetentionMetadata(BaseModel):
    templates: Optional[List[RetentionRuleMetadata]] = Field(
        None, description="templates"
    )
    scope_selectors: Optional[List[RetentionSelectorMetadata]] = Field(
        None, description="supported scope selectors"
    )
    tag_selectors: Optional[List[RetentionSelectorMetadata]] = Field(
        None, description="supported tag selectors"
    )


class RetentionPolicy(BaseModel):
    id: Optional[int] = None
    algorithm: Optional[str] = None
    rules: Optional[List[RetentionRule]] = None
    trigger: Optional[RetentionRuleTrigger] = None
    scope: Optional[RetentionPolicyScope] = None


class Search(BaseModel):
    project: Optional[List[Project]] = Field(
        None,
        description="Search results of the projects that matched the filter keywords.",
    )
    repository: Optional[List[SearchRepository]] = Field(
        None,
        description="Search results of the repositories that matched the filter keywords.",
    )
    chart: Optional[List[SearchResult]] = Field(
        None,
        description="Search results of the charts that macthed the filter keywords.",
    )
