from setuptools import setup, find_packages


setup(
    name='selenium-recaptcha-solver',
    version='1.0.9',
    license='MIT',
    author='Tomás Perestrelo',
    author_email='tomasperestrelo21@gmail.com',
    packages=find_packages(exclude=('tests*', 'testing*')),
    url='https://github.com/thicccat688/selenium-recaptcha-solver',
    download_url='https://pypi.org/project/selenium-recaptcha-solver',
    keywords='python, captcha, speech recognition, selenium, web automation',
    long_description=open('README.md', 'r').read(),
    long_description_content_type='text/markdown',
    install_requires=[
        'async-generator==1.10',
        'attrs==22.1.0',
        'blinker==1.5',
        'Brotli==1.0.9',
        'certifi==2022.12.7',
        'cffi==1.15.1',
        'charset-normalizer==2.1.1',
        'colorama==0.4.6',
        'exceptiongroup==1.0.4',
        'h11==0.14.0',
        'h2==4.1.0',
        'hpack==4.0.0',
        'hyperframe==6.0.1',
        'idna==3.4',
        'iniconfig==1.1.1',
        'kaitaistruct==0.10',
        'outcome==1.2.0',
        'packaging==22.0',
        'pluggy==1.0.0',
        'pyasn1==0.4.8',
        'pycparser==2.21',
        'pydivert==2.1.0',
        'pydub==0.25.1',
        'pyparsing==3.0.9',
        'PySocks==1.7.1',
        'python-dotenv==0.21.0',
        'requests==2.28.1',
        'selenium==4.6.0',
        'sniffio==1.3.0',
        'sortedcontainers==2.4.0',
        'SpeechRecognition==3.8.1',
        'tomli==2.0.1',
        'tqdm==4.64.1',
        'trio==0.22.0',
        'trio-websocket==0.9.2',
        'urllib3==1.26.12',
        'wsproto==1.2.0',
        'zstandard==0.19.0',
    ],
)
