# Generated by Django 2.1.5 on 2019-01-19 23:40

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import isc_common.fields.code_field
import isc_common.fields.description_field
import isc_common.fields.name_field
import isc_common.fields.related


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Messages',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted', models.BooleanField(db_index=True, default=False, verbose_name='Признак удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('checksum', isc_common.fields.code_field.CodeField(unique=True, verbose_name='Checksum MD5')),
                ('message', isc_common.fields.description_field.DescriptionField(verbose_name='Тело сообщения')),
            ],
            options={
                'verbose_name': 'Сообщения',
            },
        ),
        migrations.CreateModel(
            name='Messages_state',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted', models.BooleanField(db_index=True, default=False, verbose_name='Признак удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('code', isc_common.fields.code_field.CodeField()),
                ('name', isc_common.fields.name_field.NameField()),
                ('description', isc_common.fields.description_field.DescriptionField()),
            ],
            options={
                'verbose_name': 'Состояние сообщений',
            },
        ),
        migrations.CreateModel(
            name='Messages_theme',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted', models.BooleanField(db_index=True, default=False, verbose_name='Признак удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('code', isc_common.fields.code_field.CodeField()),
                ('name', isc_common.fields.name_field.NameField()),
                ('description', isc_common.fields.description_field.DescriptionField()),
                ('parent', isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='tracker.Messages_theme')),
            ],
            options={
                'verbose_name': 'Темы трекинга',
            },
        ),
        migrations.AddField(
            model_name='messages',
            name='state',
            field=isc_common.fields.related.ForeignKeyProtect(default=None, on_delete=django.db.models.deletion.PROTECT, to='tracker.Messages_state'),
        ),
        migrations.AddField(
            model_name='messages',
            name='theme',
            field=isc_common.fields.related.ForeignKeyProtect(default=None, on_delete=django.db.models.deletion.PROTECT, to='tracker.Messages_theme'),
        ),
        migrations.AddField(
            model_name='messages',
            name='user',
            field=isc_common.fields.related.ForeignKeyProtect(default=None, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL),
        ),
    ]
