# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['meritrank_python']

package_data = \
{'': ['*']}

install_requires = \
['networkx>=2.8.8,<3.0.0']

setup_kwargs = {
    'name': 'meritrank-python',
    'version': '0.1.1',
    'description': 'MeritRank decentralized, sybil-resistant, personalized ranking algorithm library',
    'long_description': 'Copyright: Vadim Bulavintsev (GPL v2)\n\n# MeritRank Python implementation\n\nThis repository contains the Python implementation for the incremental version of the MeritRank \nscoring system (which is inspired by personalized PageRank). The implementation is broken down into several modules,\nnamely:\n* `meritrank_python.rank`: incremental MeritRank with in-memory data structures\n* `meritrank_python.disk_persistence`: and `mdb`-based persistence layer for storing the rank state on disk\n* `meritrank_python.asgi`: a FastAPI-based API for the ranking system (persists data to disk by default)\n\n### Persistence\nTwo types of data are saved to disk on corresponding events:\n* edges - on `put_edge` event\n* the number of required walks for given nodes - on `put_walks_count` event\n\nOn restart, the API will load the edges data and the commands to redo the walks\nfor given nodes. Effectively, this will recompute the ranking and\nthe auxillary structures (e.g. bookkeeping for incremental ranks).\nThe logic here is that restarts occur rarely, and it is much easier and more efficient\nto persist just the edges and the walk-starting nodes.\nWith the default configuration, the persistence layer will persist data \ninto `meritrank_graph.dbm` in the working dir (the repo dir).\n\n## Usage example\n```python\nfrom meritrank_python.rank import IncrementalMeritRank\n\npr = IncrementalMeritRank()\n\npr.add_edge(0, 1, )\npr.add_edge(0, 2, weight=0.5)\npr.add_edge(1, 2, weight=2.0)\n\n# Initalize calculating rank from the standpoint of node "0"\npr.calculate(0)\n\n# Get the score for node "1" from the standpoint of the node "0" \nprint(pr.get_node_score(0, 1))\n\n# Add another edge: note that the scores are automatically recalculated\npr.add_edge(2, 1, weight=3.0)\nprint(pr.get_node_score(0, 1))\n\n```\n\n## HTTP API usage (ASGI)\nThe basic usage is covered in the test suite. \nTo run the FastAPI-based ASGI implementation:\n```commandline\npoetry install -G asgi\npoetry shell\nuvicorn meritrank_python.asgi:create_meritrank_app --reload --factory\n```\nIf all runs fine, you should be able to point your browser \nto `http://127.0.0.1:8000/docs`, see the autogenerated Swagger documentation\nand experiment with the API in-browser. Note the basic run options will persist the \ndatabase on disk \n\n## Known issues and limitations\n* The `NodeID` type is `int` - should be changed to something more general, e.g. `bytes`\n* No security/authorization with ASGI\n* The bookkeeping algorithm for the incremental \naddition-deletion of edges is pretty complex.  \nInitial tests show its results are equivalent to non-incremental version,\nat least for all possible transitions between all possible meaningful 3- and 4-nodes graphs.\nNonetheless, it is hard to predict how the thing will work in real-life scenarios.\n\n##\n* The next step in development should be adding some type of networking layer for gossip\n* At that point, we should add security in the form of signature verification',
    'author': 'V.G. Bulavintsev',
    'author_email': 'golem.md@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/ichorid/meritrank-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
