# SpecPulse Memory System

## 📁 Directory Structure

```
memory/
├── README.md                    # This file - system documentation
├── project/                     # Project-wide information
│   ├── overview.md              # Project summary and goals
│   ├── architecture.md          # Technical architecture decisions
│   ├── standards.md             # Coding standards and conventions
│   └── glossary.md              # Project-specific terminology
├── features/                    # Feature-specific memory
│   ├── 001-feature-name/
│   │   ├── decisions.md         # Feature-specific decisions
│   │   ├── patterns.md          # Reusable patterns
│   │   ├── constraints.md        # Technical constraints
│   │   ├── requirements.md      # Business requirements
│   │   └── retrospective.md      # Lessons learned
│   └── 002-another-feature/
│       └── ...
├── workflows/                   # Workflow management
│   ├── current.md               # Current workflow state
│   ├── history.md              # Workflow history
│   └── templates.md            # Workflow templates
└── system/                      # System-level memory
    ├── checkpoints.md          # Checkpoint registry
    ├── metrics.md               # Performance metrics
    └── configuration.md         # System configuration
```

## 🏗️ File Formats

### Project Files
- **overview.md**: Project goals, scope, stakeholders
- **architecture.md**: System architecture, tech stack, patterns
- **standards.md**: Coding standards, review processes
- **glossary.md**: Domain-specific terms and definitions

### Feature Files
- **decisions.md**: Why decisions were made, alternatives considered
- **patterns.md**: Reusable code patterns and solutions
- **constraints.md**: Technical and business constraints
- **requirements.md**: Functional and non-functional requirements
- **retrospective.md**: What went well, what could improve

### Workflow Files
- **current.md**: Current workflow state, active phases
- **history.md**: Completed workflows and transitions
- **templates.md**: Reusable workflow templates

## 🔄 Usage Guidelines

1. **Project-level memory**: For cross-cutting decisions
2. **Feature-level memory**: For feature-specific information
3. **Workflow memory**: For process improvements
4. **System memory**: For configuration and metrics

## 📝 Best Practices

- Keep entries concise and actionable
- Use clear headings and structure
- Update regularly to stay current
- Link related information across files
- Review and archive old entries