<a name="aea.helpers.transaction.base"></a>
# aea.helpers.transaction.base

This module contains terms related classes.

<a name="aea.helpers.transaction.base.RawTransaction"></a>
## RawTransaction Objects

```python
class RawTransaction()
```

This class represents an instance of RawTransaction.

<a name="aea.helpers.transaction.base.RawTransaction.__init__"></a>
#### `__`init`__`

```python
 | __init__(ledger_id: str, body: Any)
```

Initialise an instance of RawTransaction.

<a name="aea.helpers.transaction.base.RawTransaction.ledger_id"></a>
#### ledger`_`id

```python
 | @property
 | ledger_id() -> str
```

Get the id of the ledger on which the terms are to be settled.

<a name="aea.helpers.transaction.base.RawTransaction.body"></a>
#### body

```python
 | @property
 | body()
```

Get the body.

<a name="aea.helpers.transaction.base.RawTransaction.encode"></a>
#### encode

```python
 | @staticmethod
 | encode(raw_transaction_protobuf_object, raw_transaction_object: "RawTransaction") -> None
```

Encode an instance of this class into the protocol buffer object.

The protocol buffer object in the raw_transaction_protobuf_object argument must be matched with the instance of this class in the 'raw_transaction_object' argument.

**Arguments**:

- `raw_transaction_protobuf_object`: the protocol buffer object whose type corresponds with this class.
- `raw_transaction_object`: an instance of this class to be encoded in the protocol buffer object.

**Returns**:

None

<a name="aea.helpers.transaction.base.RawTransaction.decode"></a>
#### decode

```python
 | @classmethod
 | decode(cls, raw_transaction_protobuf_object) -> "RawTransaction"
```

Decode a protocol buffer object that corresponds with this class into an instance of this class.

A new instance of this class must be created that matches the protocol buffer object in the 'raw_transaction_protobuf_object' argument.

**Arguments**:

- `raw_transaction_protobuf_object`: the protocol buffer object whose type corresponds with this class.

**Returns**:

A new instance of this class that matches the protocol buffer object in the 'raw_transaction_protobuf_object' argument.

<a name="aea.helpers.transaction.base.RawMessage"></a>
## RawMessage Objects

```python
class RawMessage()
```

This class represents an instance of RawMessage.

<a name="aea.helpers.transaction.base.RawMessage.__init__"></a>
#### `__`init`__`

```python
 | __init__(ledger_id: str, body: bytes, is_deprecated_mode: bool = False)
```

Initialise an instance of RawMessage.

<a name="aea.helpers.transaction.base.RawMessage.ledger_id"></a>
#### ledger`_`id

```python
 | @property
 | ledger_id() -> str
```

Get the id of the ledger on which the terms are to be settled.

<a name="aea.helpers.transaction.base.RawMessage.body"></a>
#### body

```python
 | @property
 | body()
```

Get the body.

<a name="aea.helpers.transaction.base.RawMessage.is_deprecated_mode"></a>
#### is`_`deprecated`_`mode

```python
 | @property
 | is_deprecated_mode()
```

Get the is_deprecated_mode.

<a name="aea.helpers.transaction.base.RawMessage.encode"></a>
#### encode

```python
 | @staticmethod
 | encode(raw_message_protobuf_object, raw_message_object: "RawMessage") -> None
```

Encode an instance of this class into the protocol buffer object.

The protocol buffer object in the raw_message_protobuf_object argument must be matched with the instance of this class in the 'raw_message_object' argument.

**Arguments**:

- `raw_message_protobuf_object`: the protocol buffer object whose type corresponds with this class.
- `raw_message_object`: an instance of this class to be encoded in the protocol buffer object.

**Returns**:

None

<a name="aea.helpers.transaction.base.RawMessage.decode"></a>
#### decode

```python
 | @classmethod
 | decode(cls, raw_message_protobuf_object) -> "RawMessage"
```

Decode a protocol buffer object that corresponds with this class into an instance of this class.

A new instance of this class must be created that matches the protocol buffer object in the 'raw_message_protobuf_object' argument.

**Arguments**:

- `raw_message_protobuf_object`: the protocol buffer object whose type corresponds with this class.

**Returns**:

A new instance of this class that matches the protocol buffer object in the 'raw_message_protobuf_object' argument.

<a name="aea.helpers.transaction.base.SignedTransaction"></a>
## SignedTransaction Objects

```python
class SignedTransaction()
```

This class represents an instance of SignedTransaction.

<a name="aea.helpers.transaction.base.SignedTransaction.__init__"></a>
#### `__`init`__`

```python
 | __init__(ledger_id: str, body: Any)
```

Initialise an instance of SignedTransaction.

<a name="aea.helpers.transaction.base.SignedTransaction.ledger_id"></a>
#### ledger`_`id

```python
 | @property
 | ledger_id() -> str
```

Get the id of the ledger on which the terms are to be settled.

<a name="aea.helpers.transaction.base.SignedTransaction.body"></a>
#### body

```python
 | @property
 | body()
```

Get the body.

<a name="aea.helpers.transaction.base.SignedTransaction.encode"></a>
#### encode

```python
 | @staticmethod
 | encode(signed_transaction_protobuf_object, signed_transaction_object: "SignedTransaction") -> None
```

Encode an instance of this class into the protocol buffer object.

The protocol buffer object in the signed_transaction_protobuf_object argument must be matched with the instance of this class in the 'signed_transaction_object' argument.

**Arguments**:

- `signed_transaction_protobuf_object`: the protocol buffer object whose type corresponds with this class.
- `signed_transaction_object`: an instance of this class to be encoded in the protocol buffer object.

**Returns**:

None

<a name="aea.helpers.transaction.base.SignedTransaction.decode"></a>
#### decode

```python
 | @classmethod
 | decode(cls, signed_transaction_protobuf_object) -> "SignedTransaction"
```

Decode a protocol buffer object that corresponds with this class into an instance of this class.

A new instance of this class must be created that matches the protocol buffer object in the 'signed_transaction_protobuf_object' argument.

**Arguments**:

- `signed_transaction_protobuf_object`: the protocol buffer object whose type corresponds with this class.

**Returns**:

A new instance of this class that matches the protocol buffer object in the 'signed_transaction_protobuf_object' argument.

<a name="aea.helpers.transaction.base.SignedMessage"></a>
## SignedMessage Objects

```python
class SignedMessage()
```

This class represents an instance of RawMessage.

<a name="aea.helpers.transaction.base.SignedMessage.__init__"></a>
#### `__`init`__`

```python
 | __init__(ledger_id: str, body: str, is_deprecated_mode: bool = False)
```

Initialise an instance of SignedMessage.

<a name="aea.helpers.transaction.base.SignedMessage.ledger_id"></a>
#### ledger`_`id

```python
 | @property
 | ledger_id() -> str
```

Get the id of the ledger on which the terms are to be settled.

<a name="aea.helpers.transaction.base.SignedMessage.body"></a>
#### body

```python
 | @property
 | body()
```

Get the body.

<a name="aea.helpers.transaction.base.SignedMessage.is_deprecated_mode"></a>
#### is`_`deprecated`_`mode

```python
 | @property
 | is_deprecated_mode()
```

Get the is_deprecated_mode.

<a name="aea.helpers.transaction.base.SignedMessage.encode"></a>
#### encode

```python
 | @staticmethod
 | encode(signed_message_protobuf_object, signed_message_object: "SignedMessage") -> None
```

Encode an instance of this class into the protocol buffer object.

The protocol buffer object in the signed_message_protobuf_object argument must be matched with the instance of this class in the 'signed_message_object' argument.

**Arguments**:

- `signed_message_protobuf_object`: the protocol buffer object whose type corresponds with this class.
- `signed_message_object`: an instance of this class to be encoded in the protocol buffer object.

**Returns**:

None

<a name="aea.helpers.transaction.base.SignedMessage.decode"></a>
#### decode

```python
 | @classmethod
 | decode(cls, signed_message_protobuf_object) -> "SignedMessage"
```

Decode a protocol buffer object that corresponds with this class into an instance of this class.

A new instance of this class must be created that matches the protocol buffer object in the 'signed_message_protobuf_object' argument.

**Arguments**:

- `signed_message_protobuf_object`: the protocol buffer object whose type corresponds with this class.

**Returns**:

A new instance of this class that matches the protocol buffer object in the 'signed_message_protobuf_object' argument.

<a name="aea.helpers.transaction.base.State"></a>
## State Objects

```python
class State()
```

This class represents an instance of State.

<a name="aea.helpers.transaction.base.State.__init__"></a>
#### `__`init`__`

```python
 | __init__(ledger_id: str, body: bytes)
```

Initialise an instance of State.

<a name="aea.helpers.transaction.base.State.ledger_id"></a>
#### ledger`_`id

```python
 | @property
 | ledger_id() -> str
```

Get the id of the ledger on which the terms are to be settled.

<a name="aea.helpers.transaction.base.State.body"></a>
#### body

```python
 | @property
 | body()
```

Get the body.

<a name="aea.helpers.transaction.base.State.encode"></a>
#### encode

```python
 | @staticmethod
 | encode(state_protobuf_object, state_object: "State") -> None
```

Encode an instance of this class into the protocol buffer object.

The protocol buffer object in the state_protobuf_object argument must be matched with the instance of this class in the 'state_object' argument.

**Arguments**:

- `state_protobuf_object`: the protocol buffer object whose type corresponds with this class.
- `state_object`: an instance of this class to be encoded in the protocol buffer object.

**Returns**:

None

<a name="aea.helpers.transaction.base.State.decode"></a>
#### decode

```python
 | @classmethod
 | decode(cls, state_protobuf_object) -> "State"
```

Decode a protocol buffer object that corresponds with this class into an instance of this class.

A new instance of this class must be created that matches the protocol buffer object in the 'state_protobuf_object' argument.

**Arguments**:

- `state_protobuf_object`: the protocol buffer object whose type corresponds with this class.

**Returns**:

A new instance of this class that matches the protocol buffer object in the 'state_protobuf_object' argument.

<a name="aea.helpers.transaction.base.Terms"></a>
## Terms Objects

```python
class Terms()
```

Class to represent the terms of a multi-currency & multi-token ledger transaction.

<a name="aea.helpers.transaction.base.Terms.__init__"></a>
#### `__`init`__`

```python
 | __init__(ledger_id: str, sender_address: Address, counterparty_address: Address, amount_by_currency_id: Dict[str, int], quantities_by_good_id: Dict[str, int], is_sender_payable_tx_fee: bool, nonce: str, fee_by_currency_id: Optional[Dict[str, int]] = None, **kwargs, ,)
```

Instantiate terms.

**Arguments**:

- `ledger_id`: the ledger on which the terms are to be settled.
- `sender_address`: the sender address of the transaction.
- `counterparty_address`: the counterparty address of the transaction.
- `amount_by_currency_id`: the amount by the currency of the transaction.
- `quantities_by_good_id`: a map from good id to the quantity of that good involved in the transaction.
- `is_sender_payable_tx_fee`: whether the sender or counterparty pays the tx fee.
- `nonce`: nonce to be included in transaction to discriminate otherwise identical transactions.
- `fee_by_currency_id`: the fee associated with the transaction.

<a name="aea.helpers.transaction.base.Terms.ledger_id"></a>
#### ledger`_`id

```python
 | @property
 | ledger_id() -> str
```

Get the id of the ledger on which the terms are to be settled.

<a name="aea.helpers.transaction.base.Terms.sender_address"></a>
#### sender`_`address

```python
 | @property
 | sender_address() -> Address
```

Get the sender address.

<a name="aea.helpers.transaction.base.Terms.counterparty_address"></a>
#### counterparty`_`address

```python
 | @property
 | counterparty_address() -> Address
```

Get the counterparty address.

<a name="aea.helpers.transaction.base.Terms.counterparty_address"></a>
#### counterparty`_`address

```python
 | @counterparty_address.setter
 | counterparty_address(counterparty_address: Address) -> None
```

Set the counterparty address.

<a name="aea.helpers.transaction.base.Terms.amount_by_currency_id"></a>
#### amount`_`by`_`currency`_`id

```python
 | @property
 | amount_by_currency_id() -> Dict[str, int]
```

Get the amount by currency id.

<a name="aea.helpers.transaction.base.Terms.sender_payable_amount"></a>
#### sender`_`payable`_`amount

```python
 | @property
 | sender_payable_amount() -> int
```

Get the amount the sender must pay.

<a name="aea.helpers.transaction.base.Terms.counterparty_payable_amount"></a>
#### counterparty`_`payable`_`amount

```python
 | @property
 | counterparty_payable_amount() -> int
```

Get the amount the counterparty must pay.

<a name="aea.helpers.transaction.base.Terms.quantities_by_good_id"></a>
#### quantities`_`by`_`good`_`id

```python
 | @property
 | quantities_by_good_id() -> Dict[str, int]
```

Get the quantities by good id.

<a name="aea.helpers.transaction.base.Terms.is_sender_payable_tx_fee"></a>
#### is`_`sender`_`payable`_`tx`_`fee

```python
 | @property
 | is_sender_payable_tx_fee() -> bool
```

Bool indicating whether the tx fee is paid by sender or counterparty.

<a name="aea.helpers.transaction.base.Terms.nonce"></a>
#### nonce

```python
 | @property
 | nonce() -> str
```

Get the nonce.

<a name="aea.helpers.transaction.base.Terms.has_fee"></a>
#### has`_`fee

```python
 | @property
 | has_fee() -> bool
```

Check if fee is set.

<a name="aea.helpers.transaction.base.Terms.fee"></a>
#### fee

```python
 | @property
 | fee() -> int
```

Get the fee.

<a name="aea.helpers.transaction.base.Terms.fee_by_currency_id"></a>
#### fee`_`by`_`currency`_`id

```python
 | @property
 | fee_by_currency_id() -> Dict[str, int]
```

Get fee by currency.

<a name="aea.helpers.transaction.base.Terms.kwargs"></a>
#### kwargs

```python
 | @property
 | kwargs() -> Dict[str, Any]
```

Get the kwargs.

<a name="aea.helpers.transaction.base.Terms.encode"></a>
#### encode

```python
 | @staticmethod
 | encode(terms_protobuf_object, terms_object: "Terms") -> None
```

Encode an instance of this class into the protocol buffer object.

The protocol buffer object in the terms_protobuf_object argument must be matched with the instance of this class in the 'terms_object' argument.

**Arguments**:

- `terms_protobuf_object`: the protocol buffer object whose type corresponds with this class.
- `terms_object`: an instance of this class to be encoded in the protocol buffer object.

**Returns**:

None

<a name="aea.helpers.transaction.base.Terms.decode"></a>
#### decode

```python
 | @classmethod
 | decode(cls, terms_protobuf_object) -> "Terms"
```

Decode a protocol buffer object that corresponds with this class into an instance of this class.

A new instance of this class must be created that matches the protocol buffer object in the 'terms_protobuf_object' argument.

**Arguments**:

- `terms_protobuf_object`: the protocol buffer object whose type corresponds with this class.

**Returns**:

A new instance of this class that matches the protocol buffer object in the 'terms_protobuf_object' argument.

<a name="aea.helpers.transaction.base.TransactionDigest"></a>
## TransactionDigest Objects

```python
class TransactionDigest()
```

This class represents an instance of TransactionDigest.

<a name="aea.helpers.transaction.base.TransactionDigest.__init__"></a>
#### `__`init`__`

```python
 | __init__(ledger_id: str, body: Any)
```

Initialise an instance of TransactionDigest.

<a name="aea.helpers.transaction.base.TransactionDigest.ledger_id"></a>
#### ledger`_`id

```python
 | @property
 | ledger_id() -> str
```

Get the id of the ledger on which the terms are to be settled.

<a name="aea.helpers.transaction.base.TransactionDigest.body"></a>
#### body

```python
 | @property
 | body() -> Any
```

Get the receipt.

<a name="aea.helpers.transaction.base.TransactionDigest.encode"></a>
#### encode

```python
 | @staticmethod
 | encode(transaction_digest_protobuf_object, transaction_digest_object: "TransactionDigest") -> None
```

Encode an instance of this class into the protocol buffer object.

The protocol buffer object in the transaction_digest_protobuf_object argument must be matched with the instance of this class in the 'transaction_digest_object' argument.

**Arguments**:

- `transaction_digest_protobuf_object`: the protocol buffer object whose type corresponds with this class.
- `transaction_digest_object`: an instance of this class to be encoded in the protocol buffer object.

**Returns**:

None

<a name="aea.helpers.transaction.base.TransactionDigest.decode"></a>
#### decode

```python
 | @classmethod
 | decode(cls, transaction_digest_protobuf_object) -> "TransactionDigest"
```

Decode a protocol buffer object that corresponds with this class into an instance of this class.

A new instance of this class must be created that matches the protocol buffer object in the 'transaction_digest_protobuf_object' argument.

**Arguments**:

- `transaction_digest_protobuf_object`: the protocol buffer object whose type corresponds with this class.

**Returns**:

A new instance of this class that matches the protocol buffer object in the 'transaction_digest_protobuf_object' argument.

<a name="aea.helpers.transaction.base.TransactionReceipt"></a>
## TransactionReceipt Objects

```python
class TransactionReceipt()
```

This class represents an instance of TransactionReceipt.

<a name="aea.helpers.transaction.base.TransactionReceipt.__init__"></a>
#### `__`init`__`

```python
 | __init__(ledger_id: str, receipt: Any, transaction: Any)
```

Initialise an instance of TransactionReceipt.

<a name="aea.helpers.transaction.base.TransactionReceipt.ledger_id"></a>
#### ledger`_`id

```python
 | @property
 | ledger_id() -> str
```

Get the id of the ledger on which the terms are to be settled.

<a name="aea.helpers.transaction.base.TransactionReceipt.receipt"></a>
#### receipt

```python
 | @property
 | receipt() -> Any
```

Get the receipt.

<a name="aea.helpers.transaction.base.TransactionReceipt.transaction"></a>
#### transaction

```python
 | @property
 | transaction() -> Any
```

Get the transaction.

<a name="aea.helpers.transaction.base.TransactionReceipt.encode"></a>
#### encode

```python
 | @staticmethod
 | encode(transaction_receipt_protobuf_object, transaction_receipt_object: "TransactionReceipt") -> None
```

Encode an instance of this class into the protocol buffer object.

The protocol buffer object in the transaction_receipt_protobuf_object argument must be matched with the instance of this class in the 'transaction_receipt_object' argument.

**Arguments**:

- `transaction_receipt_protobuf_object`: the protocol buffer object whose type corresponds with this class.
- `transaction_receipt_object`: an instance of this class to be encoded in the protocol buffer object.

**Returns**:

None

<a name="aea.helpers.transaction.base.TransactionReceipt.decode"></a>
#### decode

```python
 | @classmethod
 | decode(cls, transaction_receipt_protobuf_object) -> "TransactionReceipt"
```

Decode a protocol buffer object that corresponds with this class into an instance of this class.

A new instance of this class must be created that matches the protocol buffer object in the 'transaction_receipt_protobuf_object' argument.

**Arguments**:

- `transaction_receipt_protobuf_object`: the protocol buffer object whose type corresponds with this class.

**Returns**:

A new instance of this class that matches the protocol buffer object in the 'transaction_receipt_protobuf_object' argument.

