# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['calcipy',
 'calcipy.cli',
 'calcipy.cli.controllers',
 'calcipy.cli.core',
 'calcipy.dev',
 'calcipy.doit_tasks']

package_data = \
{'': ['*'], 'calcipy.doit_tasks': ['templates/*']}

install_requires = \
['attrs>=21',
 'attrs_strict>=0.2.2',
 'beartype>=0.10.0',
 'cement>=3.0.6',
 'decorator>=5',
 'doit>=0.33',
 'loguru>=0.5',
 'pandas>=1.1',
 'pendulum>=2',
 'pre-commit>=2.15',
 'punq>=0.6.2',
 'pyrate_limiter>=2.4',
 'python-box>=5.4',
 'pyyaml',
 'requests',
 'returns>=0.18.0',
 'sty>=1.0.4',
 'tabulate>=0.8',
 'tomli>=2.0.0',
 'transitions>=0.8']

extras_require = \
{'commitizen_legacy': ['cz_legacy>=0.1.2'],
 'dev': ['better-exceptions>=0.3',
         'commitizen>=2',
         'mkdocs-git-revision-date-localized-plugin>=1.0',
         'mkdocs-material>=7.1',
         'livereload',
         'pdocs>=1.1',
         'pyupgrade>=2.19.1'],
 'dev:sys_platform != "win32" or python_version < "3.9"': ['pdbpp>=0.10'],
 'lint': ['absolufy-imports>=0.3.1',
          'add-trailing-comma>=2.1.0',
          'autoflake>=1.4',
          'autopep8>=1.5',
          'cohesion>=1',
          'darglint>=1.8',
          'dlint>=0.11',
          'flake8>=3.8.4',
          'flake8-2020>=1.6',
          'flake8-aaa>=0.12',
          'flake8-annotations>=2.6',
          'flake8-assertive>=1.3',
          'flake8-bandit>=2.1',
          'flake8-blind-except>=0.2',
          'flake8-breakpoint>=1.1',
          'flake8-broken-line>=0.3',
          'flake8-bugbear>=22.1.11',
          'flake8-builtins>=1.5',
          'flake8-cognitive-complexity>=0.1',
          'flake8-comprehensions>=3.5',
          'flake8-debugger>=4.0',
          'flake8-docstrings>=1.6',
          'flake8-eradicate>=1.0',
          'flake8-expression-complexity>=0.0.9',
          'flake8-fixme>=1.1',
          'flake8-functions>=0.0.6',
          'flake8-isort>=4.0',
          'flake8-logging-format>=0.6',
          'flake8-markdown>=0.2',
          'flake8-pep3101>=1.3',
          'flake8-plone-hasattr>=0.2',
          'flake8-print>=4.0',
          'flake8-printf-formatting>=1.1',
          'flake8-pytest-style>=1.4',
          'flake8-quotes>=3.2',
          'flake8-return>=1.1',
          'flake8-SQL>=0.4',
          'flake8-string-format>=0.3',
          'flake8-tuple>=0.4',
          'flake8-variables-names>=0.0.4',
          'hacking>=4',
          'isort>=5',
          'licensecheck[full]>=2022,<2023',
          'pandas-vet>=0.2',
          'pep8-naming>=0.11',
          'pip-check>=2.7',
          'proselint>=0.10',
          'pycln>=1.2.0',
          'pylint>=2.8',
          'vulture>=2.3',
          'xenon>=0.8',
          'yamllint>=1.26'],
 'test': ['coverage>=6',
          'diff-cover>=6.4',
          'hypothesis[cli]>=6.38.0',
          'lxml>=4.7.1',
          'mypy>=0.812',
          'nox-poetry>=0.8',
          'pytest>=6',
          'pytest-benchmark>=3.4.1',
          'pytest-cache-assert>=1.1.1',
          'pytest-html>=3.1',
          'pytest-randomly>=3.8',
          'pytest-recording>=0.11',
          'pytest-subprocess>=1.4.1',
          'pytest-watcher>=0.2']}

entry_points = \
{'console_scripts': ['calcipy = calcipy:run']}

setup_kwargs = {
    'name': 'calcipy',
    'version': '0.14.1',
    'description': 'Python package to simplify development. Includes functionality for task running, testing, linting, documenting, and more',
    'long_description': '# calcipy\n\n![./calcipy-banner-wide.svg](https://raw.githubusercontent.com/KyleKing/calcipy/main/docs/calcipy-banner-wide.svg)\n\n`calcipy` is a Python package that implements best practices such as code style (linting, auto-fixes), documentation, CI/CD, and logging. Like the calcium carbonate in hard coral, packages can be built on the `calcipy` foundation.\n\n`calcipy` has some configurability, but is tailored for my particular use cases. If you want the same sort of functionality, there are a number of alternatives to consider:\n\n- [pyscaffold](https://github.com/pyscaffold/pyscaffold) is a much more mature project that aims for the same goals, but with a slightly different approach and tech stack (tox vs. nox, cookiecutter vs. copier, etc.)\n- [tidypy](https://github.com/jayclassless/tidypy#features), [pylama](https://github.com/klen/pylama), and [codecheck](https://pypi.org/project/codecheck/) offer similar functionality of bundling and running static checkers, but makes far fewer assumptions\n- [pytoil](https://github.com/FollowTheProcess/pytoil) is a general CLI tool for developer automation\n- And many more such as [prospector](https://github.com/PyCQA/prospector), [wemake-python-styleguide](https://github.com/wemake-services/wemake-python-styleguide) / [cjolowicz/cookiecutter-hypermodern-python](https://github.com/cjolowicz/cookiecutter-hypermodern-python), etc.\n\n## Calcipy CLI\n\n`calcipy` can be run as a CLI application without adding the package as a dependency!\n\nQuick Start:\n\n```sh\npipx install calcipy\n\n# Use the Collect Code Tags command to write all code tags to a single file\ncalcipy collect-code-tags -h\ncalcipy collect-code-tags -b=~/Some/Project\n\n\n# See additional documentation from the CLI help\ncalcipy -h\n```\n\nTo utilize all of the functionality from `calcipy`, see the following sections on adding `calcipy` as a dependency\n\n## Calcipy Pre-Commit (beta!)\n\n`calcipy` can also be used as a `pre-commit` task by adding the below snippet to your `pre-commit` file:\n\n```yaml\nrepos:\n  - repo: https://github.com/KyleKing/calcipy\n    rev: main\n    hooks:\n      - id: calcipy-code-tags\n```\n\nThis is a beta-feature that will be expanded with additional functionality as the CLI features are extended\n\n## Calcipy Module Features\n\nThe core functionality of calcipy is the rich set of tasks run with `doit`\n\n- `poetry run doit --continue`: runs all default tasks. On CI (AppVeyor), this is a shorter list that should PASS, while locally the list is longer that are much more strict for linting and quality analysis\n\n  - The local default tasks include:\n    - **collect_code_tags**: Create a summary file with all of the found code tags. (i.e. TODO/FIXME, default output is [./docs/CODE_TAG_SUMMARY.md](./docs/CODE_TAG_SUMMARY.md))\n    - **cl_write**: Auto-generate the changelog based on commit history and tags.\n    - **lock**: Ensure poetry.lock and requirements.txt are up-to-date.\n    - **nox_coverage**: Run the coverage session in nox.\n    - **auto_format**: Format code with isort, autopep8, and others.\n    - **document**: Build the HTML documentation. (along with creating code diagrams!)\n    - **check_for_stale_packages**: Check for stale packages.\n    - **pre_commit_hooks**: Run the pre-commit hooks  on all files.\n    - **lint_project**: Lint all project files that can be checked. (py, yaml, json, etc.)\n    - **static_checks**: General static checkers (Inspection Tiger, etc.).\n    - **security_checks**: Use linting tools to identify possible security vulnerabilities.\n    - **check_types**: Run type annotation checks.\n\n- Additional tasks of not:\n\n  - **nox**/**test**/**coverage**: Tasks for running nox sessions, pytest in the local environment, and pytest coverage\n  - **ptw\\_\\***: Variations of tasks to run pytest watch\n  - **cl_bump** (**cl_bump_pre**):Bumps project version based on commits & settings in pyproject.toml.\n  - **deploy_docs**: Deploy docs to the Github `gh-pages` branch.\n  - **publish**: Build the distributable format(s) and publish.\n\n- Other additional tasks include:\n\n  - **check_license**: Check licenses for compatibility.\n  - **lint_critical_only**: Suppress non-critical linting errors. Great for gating PRs/commits.\n  - **lint_python**: Lint all Python files and create summary of errors.\n  - **open_docs**: Open the documentation files in the default browser.\n  - **open_test_docs**: Open the test and coverage files in default browser.\n  - **zip_release**: Zip up important information in the releases directory.\n\n- **calcipy** also provides a few additional nice features\n\n  - **dev.conftest**: some additional pytest configuration logic that outputs better HTML reports. Automatically implemented (imported to `tests/conftest.py`) when using `calcipy_template`\n  - **dev.noxfile**: nox functions that can be imported and run with or without the associated doit tasks. Also automatically configured when using `calcipy_template`\n  - **file_helpers**: some nice utilities for working with files, such as `sanitize_filename`, `tail_lines`, `delete_old_files`, etc. See documentation for most up-to-date documentation\n  - **log_heleprs**: where the most common use will be for `activate_debug_logging` or the more customizable `build_logger_config`\n  - **dot_dict**: has one function `ddict`, which is a light-weight wrapper around whatever is the most [maintained dotted-dictionary package in Python](https://pypi.org/search/?q=dot+accessible+dictionary&o=). Dotted dictionaries can sometimes improve code readability, but they aren\'t a one-size fits all solution. Sometimes `attr.s` or `dataclass` are more appropriate.\n    - The benefit of this wrapper is that there is a stable interface and you don\'t need to rewrite code as packages are born and die (i.e. [Bunch](https://pypi.org/project/bunch/) > [Chunk](https://pypi.org/project/chunk/) > [Munch](https://pypi.org/project/munch/) > [flexible-dotdict](https://pypi.org/project/flexible-dotdict/) > [Python-Box](https://pypi.org/project/python-box/) > ...)\n    - Note: if you need nested dotted dictionaries, check out [classy-json](https://pypi.org/project/classy-json/)\n\n**Tip**: For the full list of available tasks, run `poetry run doit list`\n\n## Calcipy Installation\n\nCalcipy needs a few static files managed using copier and a template project: [kyleking/calcipy_template](https://github.com/KyleKing/calcipy_template/)\n\nYou can quickly use the template to create a new project or add calcipy to an existing one:\n\n```sh\n# Install copier. Pipx is recommended\npipx install copier\n\n# To create a new project\ncopier copy gh:KyleKing/calcipy_template new_project\ncd new_project\n\n# Or update an existing one\ncd my_project\ncopier copy gh:KyleKing/calcipy_template .\n```\n\n## Usage\n\n1. Run `poetry install`\n1. Run `poetry run doit list` to see available tasks\n1. And try `poetry run doit --continue` to see if the default tasks work\n\nIf you have any questions, please [start a Discussion on Github](https://github.com/KyleKing/calcipy/discussions/) or [open an issue for feature requests or bug reports](https://github.com/KyleKing/calcipy/issues/)\n\nSee [./Advanced_Configuration.md](./Advanced_Configuration.md) for documentation on the configurable aspects of `calcipy`\n\nAdditionally, for more examples, see other projects that use `calcipy`:\n\n- [KyleKing/dash_charts](https://github.com/KyleKing/dash_charts) - *Active*\n- [KyleKing/recipes](https://github.com/KyleKing/recipes) - *Active*\n- [KyleKing/Goodreads_Library_Availability](https://github.com/KyleKing/Goodreads_Library_Availability) - *On Hold*\n- [KyleKing/cz_legacy](https://github.com/KyleKing/cz_legacy) - *Published*\n- See other [projects tagged with the topic "calcipy"](https://github.com/topics/calcipy)\n\n## Updating Calcipy\n\nReview the [./docs/CHANGELOG.md](./docs/CHANGELOG.md) before updating. Calcipy uses the year followed by standard semantic versioning to indicate major and minor changes. Note that this is a personal project and may change dramatically, but for the most part, the project should be relatively stable\n\n```sh\n# Update files\ncopier update\n# and update dependencies\npoetry update\n```\n\n## Roadmap\n\nSee the `Open Issues` and `Milestones` for current status and [./docs/CODE_TAG_SUMMARY.md](./docs/CODE_TAG_SUMMARY.md) for annotations in the source code.\n\nFor release history, see the [./docs/CHANGELOG.md](./docs/CHANGELOG.md)\n\n## Contributing\n\nSee the Developer Guide, Contribution Guidelines, etc\n\n- [./docs/DEVELOPER_GUIDE.md](./docs/DEVELOPER_GUIDE.md)\n- [./docs/STYLE_GUIDE.md](./docs/STYLE_GUIDE.md)\n- [./docs/CONTRIBUTING.md](./docs/CONTRIBUTING.md)\n- [./docs/CODE_OF_CONDUCT.md](./docs/CODE_OF_CONDUCT.md)\n- [./docs/SECURITY.md](./docs/SECURITY.md)\n\n## License\n\n[LICENSE](https://github.com/KyleKing/calcipy/tree/main/LICENSE)\n',
    'author': 'Kyle King',
    'author_email': 'dev.act.kyle@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kyleking/calcipy',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7.6,<4.0.0',
}


setup(**setup_kwargs)
