%
% plots ROC population analysis. 
%
% processes data generated by preparePopData_SingleCellMemory.m
%
%urut/aug13 original
%urut/march17 split out of original NO_popAnalysis_ROC.m
%urut/aug18 simplified for release
function NO_popAnalysis_ROC_plot_simple( cellStatsAll, sigCellListNO, bootstrapChanceLevels,randomizeHighLow, balanceNrTrials, highLowSplitDynamic, countWindow  )
errorHighOnly = 1;
sigCellList = sigCellListNO;

%% pre-compuate AUC metrics for all cells
cellsToProcess = cellStatsAll(sigCellList);

% run a number of bootstraps
if bootstrapChanceLevels
    randomizeHighLow_overwrite = 1;
    nrRuns=10;
    
    bootVals = []; % 
    for B=1:nrRuns
    
        [ROCstats_boot, All_AUCstats_boot] = NO_popAnalysis_ROC_eval(cellsToProcess, sigCellList, countWindow, highLowSplitDynamic, randomizeHighLow_overwrite, balanceNrTrials);
        
        % assemble bootstrap summary stats
        [slopesType0_b,slopesType1_b, AUCType0_b,AUCType0_high_b,AUCType0_low_b, AUCType0_errFN_b, AUCType0_errFNhigh_b, AUCType0_errFNlow_b, ...
            AUCType1_b,AUCType1_high_b,AUCType1_low_b, AUCType1_errFN_b, AUCType1_errFNhigh_b, AUCType1_errFNlow_b] = NO_popAnalysis_ROC_prepAUCvals( All_AUCstats_boot, ROCstats_boot );

        % 
        AUCType_high_all_b = [ AUCType1_high_b; AUCType0_high_b];
        AUCType_low_all_b = [ AUCType1_low_b; AUCType0_low_b];

        [mAUC_conf_all_b,sAUC_conf_all_b,seAUC_conf_all_b] = calcMeanSEOfSample( [AUCType_high_all_b AUCType_low_all_b] );

        %bootstrapped vals
        bootVals = [ bootVals; mAUC_conf_all_b];
    end
end

%==== compute the real metrics
if ~isempty(sigCellList)
    [ROCstats, All_AUCstats, mCounts,baselineRate_formCounts, All_AUC_high_TP,All_AUC_low_TP,All_AUC_high_FP,All_AUC_low_FP,cellStatsAll] = ...
    NO_popAnalysis_ROC_eval(cellStatsAll, cellsToProcess, sigCellList, countWindow, highLowSplitDynamic, randomizeHighLow, balanceNrTrials);
end

%% prepare population statistics plot
col_confHigh = [0.5 .1 .1];
col_confLow  = [0.1 .1 .5];
col_confError = [0.1 0.1 0.1];
barWidth=0.4;

[slopesType0,slopesType1, AUCType0,AUCType0_high,AUCType0_low, AUCType0_errFN, AUCType0_errFNhigh, AUCType0_errFNlow, ...
    AUCType1,AUCType1_high,AUCType1_low, AUCType1_errFN, AUCType1_errFNhigh, AUCType1_errFNlow, AUCType0_FN_vs_FP,AUCType1_FN_vs_FP,...
    AUCType0_errFP, AUCType1_errFP, AUCType0_errFPhigh, AUCType1_errFPhigh, AUCType0_errFPlow, AUCType1_errFPlow] = NO_popAnalysis_ROC_prepAUCvals( All_AUCstats, ROCstats );

[m0,s0]=calcMeanSEOfSample( slopesType0 );
[m1,s1]=calcMeanSEOfSample( slopesType1 );
[~,pSlopeComp]=ttest2(slopesType0,slopesType1);

%% population statistics - mean AUC high vs low of new>old and old>new MS cells
figure(1010);
subplot(4,3,1);
colCode={'or','ob'};
hs=[];
for k=1:2
    inds = find(ROCstats(:,4)==k-1)

    if isempty(inds)
        continue;
    end
    hTmp=plot( ROCstats(inds,6), ROCstats(inds,7), [colCode{k}]);
    hs(k)=hTmp(1);
    
    [m1,s1,se1]=calcMeanSEOfSample(  ROCstats(inds,6) );
    [m2,s2,se2]=calcMeanSEOfSample(  ROCstats(inds,7) );
    
    hold on;
    errorbar( m1, m2, se2, colCode{k},'linewidth',2);
end
hold off
xlim([0 1]);
ylim([0 1]);
line([0 1],[0 1],'color','k');
title('single neuron optimal decision points');

subplot(4,3,2);
hist( AUCType0);
[mAUC0,sAUC0,~,nAUC0]=calcMeanSEOfSample(AUCType0);
title(['AUC new>old AUC=' num2str(mAUC0) '\pm' num2str(sAUC0) ' n=' num2str(nAUC0) ]);
xlabel('AUC values');
ylabel('nr units');

subplot(4,3,3);
hist( AUCType1);
[mAUC1,sAUC1,~,nAUC1]=calcMeanSEOfSample(AUCType1);
title(['AUC old>new' num2str(mAUC1) '\pm' num2str(sAUC1) ' n=' num2str(nAUC1) ]);
xlabel('AUC values');
ylabel('nr units');

subplot(4,3,4);
[mAUC0_conf,sAUC0_conf,seAUC0_conf,nAUC0_conf] = calcMeanSEOfSample( [AUCType0_high AUCType0_low] );

if errorHighOnly
    [mAUC0_FN,sAUC0_FN,seAUC0_FN] = calcMeanSEOfSample( [AUCType0_errFNhigh] ); 
    [mAUC0_FP,sAUC0_FP,seAUC0_FP] = calcMeanSEOfSample( [AUCType0_errFPhigh],1 ); 
    [h,pFN]=ttest( AUCType0_errFNhigh, 0.5,[],'right' );
    [h,pFP]=ttest( AUCType0_errFPhigh, 0.5,[],'right' );
    grpLabels={'high','low','FN++','FP++'};
else
    [mAUC0_FN,sAUC0_FN,seAUC0_FN] = calcMeanSEOfSample( [AUCType0_errFN] ); 
    [mAUC0_FP,sAUC0_FP,seAUC0_FP] = calcMeanSEOfSample( [AUCType0_errFP] ); 
    [h,pFN]=ttest( AUCType0_errFN, 0.5,[],'right' );
    [h,pFP]=ttest( AUCType0_errFP, 0.5,[],'right' );
    grpLabels={'high','low','FN','FP'};
end
plotBar_customizedNO([1 1.5 2 2.5], [mAUC0_conf mAUC0_FN mAUC0_FP], [seAUC0_conf seAUC0_FN seAUC0_FP], {col_confHigh,col_confLow,col_confError,col_confError}, grpLabels, barWidth);
ylim([0.5 0.7]);
[h,p] = ttest( AUCType0_high, AUCType0_low,[], 'right' );
title(['N>O  pHL=' num2str(p) ' n=' num2str(nAUC0_conf)  ' pFN=' num2str(pFN) ' pFP=' num2str(pFP)]);

subplot(4,3,5);
[mAUC1_conf,sAUC1_conf,seAUC1_conf,nAUC1_conf] = calcMeanSEOfSample( [AUCType1_high AUCType1_low] );
if errorHighOnly
    [mAUC1_FN,sAUC1_FN,seAUC1_FN] = calcMeanSEOfSample( [AUCType1_errFNhigh],1 );
    [mAUC1_FP,sAUC1_FP,seAUC1_FP] = calcMeanSEOfSample( [AUCType1_errFPhigh],1 );
    
    [h,pFN]=ttest( AUCType1_errFNhigh, 0.5,[],'right' );
    [h,pFP]=ttest( AUCType1_errFPhigh, 0.5,[],'right' );
    grpLabels={'high','low','FN++','FP++'};
else
    [mAUC1_FN,sAUC1_FN,seAUC1_FN] = calcMeanSEOfSample( [AUCType1_errFN],1 );
    [mAUC1_FP,sAUC1_FP,seAUC1_FP] = calcMeanSEOfSample( [AUCType1_errFP],1 );
    
    [h,pFN]=ttest( AUCType1_errFN, 0.5,[],'right' )
    [h,pFP]=ttest( AUCType1_errFP, 0.5,[],'right' )
    grpLabels={'high','low','FN','FP'};
end
[h,p] = ttest( AUCType1_high, AUCType1_low, [],'right' );
plotBar_customizedNO([1 1.5 2 2.5], [mAUC1_conf mAUC1_FN mAUC1_FP],[ seAUC1_conf seAUC1_FN seAUC1_FP], {col_confHigh,col_confLow,col_confError,col_confError}, grpLabels, barWidth);
ylim([0.5 0.7]);
title(['O>N  pHL=' num2str(p) ' n=' num2str(nAUC1_conf) ' pFN=' num2str(pFN) ' pFP=' num2str(pFP)]);

% AUC for both types together
subplot(4,3,6);
AUCType_high_all = [ AUCType1_high; AUCType0_high];
AUCType_low_all = [ AUCType1_low; AUCType0_low];

if errorHighOnly
    %only high
    AUCType_errFN_high = [ AUCType1_errFNhigh; AUCType0_errFNhigh];
    AUCType_errFP_high = [ AUCType1_errFPhigh; AUCType0_errFPhigh];
    
    [mAUC_conf_FN,sAUC_conf_FN,seAUC_conf_FN] = calcMeanSEOfSample( [AUCType_errFN_high],1 );
    [mAUC_conf_FP,sAUC_conf_FP,seAUC_conf_FP] = calcMeanSEOfSample( [AUCType_errFP_high],1 );
    
    [~,pFN]=ttest( AUCType_errFN_high, 0.5,[],'right' );
    [~,pFP]=ttest( AUCType_errFP_high, 0.5,[],'right' );
    grpLabels={'high','low','FN++','FP++'};
else
    %high and low
    AUCType_errFN_all = [ AUCType1_errFN; AUCType0_errFN];
    AUCType_errFP_all = [ AUCType1_errFP; AUCType0_errFP];
    
    [mAUC_conf_FN,sAUC_conf_FN,seAUC_conf_FN] = calcMeanSEOfSample( [AUCType_errFN_all],1 );
    [mAUC_conf_FP,sAUC_conf_FP,seAUC_conf_FP] = calcMeanSEOfSample( [AUCType_errFP_all],1 );
    
    [~,pFN]=ttest( AUCType_errFN_all, 0.5,[],'right' );
    [~,pFP]=ttest( AUCType_errFP_all, 0.5,[],'right' );
    grpLabels={'high','low','FN','FP'};
end

[mAUC_conf_all,sAUC_conf_all,seAUC_conf_all] = calcMeanSEOfSample( [AUCType_high_all AUCType_low_all] );
[~,p] = ttest( AUCType_high_all, AUCType_low_all, [],'right' );

if length([mAUC_conf_all mAUC_conf_FN])==3   
    plotBar_customizedNO([1 1.5 2 2.5], [mAUC_conf_all mAUC_conf_FN mAUC_conf_FP], [seAUC_conf_all seAUC_conf_FN seAUC_conf_FP], {col_confHigh,col_confLow,col_confError,col_confError}, grpLabels, barWidth);
end
ylim([0.5 0.7]);
title(['AUC all  p=' num2str(p) ' n=' num2str(length(AUCType_high_all)) ' pFN=' num2str(pFN) ' pFP=' num2str(pFP)]);

%---- bootstraps of difference high vs low for different cells.
subplot(4,3,7)
Bruns=1000;
[pBoot,tBootNull,tOB] = bootstrapMeanEqualTestSimple(AUCType_high_all', AUCType_low_all', Bruns)
hist( tBootNull);
line([tOB tOB],[0 100],'color','r');
xlabel('mean AUC high-low');
ylabel('nr of runs');
title('AUC all');

subplot(4,3,8);
%stepsizeBins=0.025;
stepsizeBins=0.02;
bins=0:stepsizeBins:1;

% bootstrap test
B=1000;
[pBoot,tboot,tOB] = bootstrapMeanEqualTestSimple(AUCType_high_all',AUCType_low_all',B);

%histograms AUCs high/low
plotPairedMirrorHistogram(AUCType_high_all, AUCType_low_all, bins, col_confHigh, col_confLow)

line([0.5 0.5], [-30 30],'color','k'); % chance line
xlim([0.4 1.0]);
ylim([-12 12]);

xlabel('AUC');
ylabel('nr of units');
title(['mHigh=' num2str(mean(AUCType_high_all)) ' mLow=' num2str(mean(AUCType_low_all)) ' pB=' num2str(pBoot) ]);

%% population statistics - pairwise AUC plot and signtest
figure(1030);

subplot(3,3,1);
AUCType_high_all = [ AUCType1_high; AUCType0_high];
AUCType_low_all = [ AUCType1_low; AUCType0_low];
[mAUC_conf_all,sAUC_conf_all,seAUC_conf_all] = calcMeanSEOfSample( [AUCType_high_all AUCType_low_all] );
h1=plot( AUCType1_low, AUCType1_high, 'bo');
hold on
h2=plot( AUCType0_low, AUCType0_high, 'ro');
hold off
xlim([0 1]);
ylim([0 1]);
line([0 1],[0 1],'color','k');
ylabel('AUC high');
xlabel('AUC low');

if ~isempty(h1) & ~isempty(h2)
    legend([h1(1) h2(1)],{['old>new n=' num2str(length(AUCType1_high))],['new>old n=' num2str(length(AUCType0_high))]});
end
nrAbove = length(find(AUCType1_high>AUCType1_low))+length(find(AUCType0_high>AUCType0_low));
nrTot = length(AUCType1_high)+length(AUCType0_high);
title( [' nAbove=' num2str(nrAbove) ' out of ' num2str(nrTot)]);

subplot(3,3,2);
m = [ length(find( AUCType_high_all>=AUCType_low_all)) length(find( AUCType_high_all<AUCType_low_all)) ];
bar( 1:2, m);
set(gca,'XTick',[1 2]);
set(gca,'XTickLabel',{'high>low','low<high'});

p=signtest(AUCType_high_all,AUCType_low_all);
pType1=signtest(AUCType1_high,AUCType1_low);
pType0=signtest(AUCType0_high,AUCType0_low);
title(['p=' num2str(p) ' signtest']);

