; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{3E4D0CF3-9FBE-4F82-8F37-1CEF54D3C30D}
AppName=MatNWB
AppVersion=1.0
;AppVerName=MatNWB 1.0
AppPublisher=Vidrio Technologies Inc.
AppPublisherURL=https://vidriotechnologies.com
AppSupportURL=https://gitlab.com/Lancewiu/matnwb
AppUpdatesURL=https://gitlab.com/Lancewiu/matnwb
DefaultDirName={pf}\MatNWB
DefaultGroupName=MatNWB
AllowNoIcons=yes
OutputBaseFilename=setupNWB
Compression=lzma
SolidCompression=yes

[Setup]
ChangesEnvironment=yes

[Registry]
Root: HKCU; Subkey: "Environment"; ValueType:string; ValueName: "MATLABPATH"; ValueData: "{olddata};{app}"; Flags: preservestringtype createvalueifdoesntexist uninsdeletevalue; Check: ShouldAddToMATLABPath

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Files]
Source: "..\*"; Excludes: "\installer,\.gitignore,\+types\*.m,\testdata,\testoutput,\schema\extensions"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\{cm:UninstallProgram,MatNWB}"; Filename: "{uninstallexe}"

[Code]

var
  AddToMatlabPath: Boolean; { Should be defaulted to False }
  MatlabPathPage: TInputOptionWizardPage;

procedure InitializeWizard;
begin
  MatlabPathPage := CreateInputOptionPage(wpReady,
    'MATLAB Installation',
    'MATLAB is installed on your system.',
    'Would you like to add MatNWB to your MATLAB Path?', False, False);
  MatlabPathPage.Add('Yes, add MatNWB to MATLAB path');
  MatlabPathPage.Values[0] := False;
end;

function ShouldSkipPage(PageID: Integer): Boolean;
begin
  Result := False;
  if PageID = MatlabPathPage.ID then
    Result := FileSearch('matlab.exe', GetEnv('PATH')) = '';
end;

function NextButtonClick(CurPageID: Integer): Boolean;
begin
  Result := True;
  if CurPageID = MatlabPathPage.ID then AddToMatlabPath := MatlabPathPage.Values[0];
end;

function ShouldAddToMATLABPath(): Boolean;
begin
Result := AddToMatlabPath;
end;