classdef UnitTimesIOTest < tests.system.RoundTripTest
    methods
        function addContainer(~, file)
            vdata = rand(10,1);
            vd = types.core.VectorData('data', vdata, 'description', 'descr');
            
            spike_loc = '/units/spike_times';
            vd_ref = [...
                types.untyped.RegionView(spike_loc, 1),...
                types.untyped.RegionView(spike_loc, 2:5),...
                types.untyped.RegionView(spike_loc, 9:10)...
                ];
            vi = types.core.VectorIndex('data', vd_ref,...
                'target', types.untyped.ObjectView(spike_loc));
            ei = types.core.ElementIdentifiers('data', 1:3);
            file.units = types.core.Units(...
                'colnames', {'spike_times'},...
                'description', 'test Units',...
                'spike_times', vd, ...
                'spike_times_index', vi,...
                'id', ei);
        end
        
        function c = getContainer(~, file)
            c = file.units.spike_times;
        end
    end
end