classdef NWBFileIOTest < tests.system.PyNWBIOTest
  methods    
    function addContainer(testCase, file) %#ok<INUSL>
      ts = types.core.TimeSeries(...
        'data', int32(100:10:190) .', ...
        'data_unit', 'SIunit', ...
        'timestamps', (0:9) .', ...
        'data_resolution', 0.1);
      file.acquisition.set('test_timeseries', ts);
      clust = types.core.Clustering( ...
        'description', 'A fake Clustering interface', ...
        'num', [0, 1, 2, 0, 1, 2] .', ...
        'peak_over_rms', [100, 101, 102] .', ...
        'times', (10:10:60) .');
      mod = types.core.ProcessingModule( ...
        'description', 'a test module', ...
        'Clustering', clust);
      file.processing.set('test_module', mod);
    end
    
    function c = getContainer(testCase, file) %#ok<INUSL>
      c = file;
    end
  end
end

