classdef ImagingPlaneIOTest < tests.system.PyNWBIOTest
    methods
        function addContainer(testCase, file) %#ok<INUSL>
            dev = types.core.Device();
            oc = types.core.OpticalChannel( ...
                'description', 'a fake OpticalChannel', ...
                'emission_lambda', 3.14);
            ip = types.core.ImagingPlane( ...
                'description', 'a fake ImagingPlane', ...
                'optchan1', oc, ...
                'device', types.untyped.SoftLink('/general/devices/imaging_device_1'), ...
                'excitation_lambda', 6.28, ...
                'imaging_rate', 2.718, ...
                'indicator', 'GFP', ...
                'location', 'somewhere in the brain');
            file.general_devices.set('imaging_device_1', dev);
            file.general_optophysiology.set('imgpln1', ip);
        end
        
        function c = getContainer(testCase, file) %#ok<INUSL>
            c = file.general_optophysiology.get('imgpln1');
        end
    end
end