classdef ElectricalSeriesIOTest < tests.system.PyNWBIOTest
    
    methods
        function addContainer(testCase, file) %#ok<INUSL>
            devnm = 'dev1';
            egnm = 'tetrode1';
            esnm = 'test_eS';
            devBase = '/general/devices/';
            ephysBase = '/general/extracellular_ephys/';
            devlink = types.untyped.SoftLink([devBase devnm]);
            eglink = types.untyped.ObjectView([ephysBase egnm]);
            etReg = types.untyped.ObjectView([ephysBase 'electrodes']);
            dev = types.core.Device();
            file.general_devices.set(devnm, dev);
            eg = types.core.ElectrodeGroup( ...
                'description', 'tetrode description', ...
                'location', 'tetrode location', ...
                'device', devlink);
            
            ettable = types.core.DynamicTable(...
                'colnames', {'x', 'y', 'z', 'imp', 'location', 'filtering', 'group', 'group_name'},...
                'id', types.core.ElementIdentifiers('data', 1:4),...
                'x', types.core.VectorData('data', ones(4,1),...
                    'description', 'the x coordinate of the channel location'),...
                'y', types.core.VectorData('data', repmat(2, 4, 1),...
                    'description', 'the y coordinate of the channel location'),...
                'z', types.core.VectorData('data', repmat(3, 4, 1),...
                    'description', 'the z coordinate of the channel location'),...
                'imp', types.core.VectorData('data', ones(4,1),...
                    'description', 'the impedance of the channel'),...
                'location', types.core.VectorData('data', repmat({'CA1'},4,1),...
                    'description', 'the location of channel within the subject e.g. brain region'),...
                'filtering', types.core.VectorData('data', repmat({'none'},4,1),...
                    'description', 'description of hardware filtering'),...
                'group', types.core.VectorData('data', repmat(eglink,4,1),...
                    'description', 'a reference to the ElectrodeGroup this electrodes is a part of'),...
                'group_name', types.core.VectorData('data', repmat({egnm},4,1),...
                    'description', 'name of the ElectrodeGroup this electrode is a part of'),...
                'description', 'electrodes'...
                );
            
            file.general_extracellular_ephys_electrodes = ettable;
            file.general_extracellular_ephys.set(egnm, eg);
            es = types.core.ElectricalSeries( ...
                'data', [0:9;10:19], ...
                'timestamps', (0:9) .', ...
                'electrodes', ...
                types.core.DynamicTableRegion(...
                'data', [0;2],...
                'table', etReg,...
                'description', 'the first and third electrodes'));
            file.acquisition.set(esnm, es);
        end
        
        function c = getContainer(testCase, file) %#ok<INUSL>
            c = file.acquisition.get('test_eS');
        end
    end
end

