classdef DynamicTableTest < tests.system.RoundTripTest
    methods
        function addContainer(~, file)
            start_time = types.core.VectorData(...
                'description', 'start_time',...
                'data', 1:100);
            stop_time = types.core.VectorData(...
                'description', 'stop_time',...
                'data', 2:200);
            colnames = {'start_time', 'stop_time', 'randomvalues'};
            id = types.core.ElementIdentifiers(...
                'data', 1:100);
            
            randcol = types.core.VectorData(...
                'description', 'random data to be indexed into',...
                'data', rand(500,1));
            randidx = types.core.VectorIndex(...
                'target', types.untyped.ObjectView('/intervals/trials/randomvalues'),...
                'data', 5:5:500 - 1);
            
            file.intervals_trials = types.core.TimeIntervals(...
                'description', 'test dynamic table columns',...
                'id', id,...
                'start_time', start_time,...
                'stop_time', stop_time,...
                'colnames', colnames,...
                'randomvalues', randcol,...
                'randomvalues_index', randidx);
        end
        
        function c = getContainer(~, file)
            c = file.intervals_trials.vectordata.get('randomvalues');
        end
    end
end

