/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans.document;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlDocument;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlEntry;
import com.esotericsoftware.yamlbeans.document.YamlScalar;
import com.esotericsoftware.yamlbeans.emitter.Emitter;
import com.esotericsoftware.yamlbeans.emitter.EmitterException;
import com.esotericsoftware.yamlbeans.parser.Event;
import com.esotericsoftware.yamlbeans.parser.SequenceStartEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class YamlSequence
extends YamlElement
implements YamlDocument {
    List<YamlElement> elements = new LinkedList<YamlElement>();

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public void addElement(YamlElement yamlElement) {
        this.elements.add(yamlElement);
    }

    @Override
    public void deleteElement(int n) throws YamlException {
        this.elements.remove(n);
    }

    @Override
    public YamlElement getElement(int n) throws YamlException {
        return this.elements.get(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.anchor != null) {
            stringBuffer.append('&');
            stringBuffer.append(this.anchor);
            stringBuffer.append(' ');
        }
        if (this.tag != null) {
            stringBuffer.append(" !");
            stringBuffer.append(this.tag);
        }
        if (!this.elements.isEmpty()) {
            stringBuffer.append('[');
            for (YamlElement yamlElement : this.elements) {
                stringBuffer.append(yamlElement.toString());
                stringBuffer.append(',');
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    @Override
    public void emitEvent(Emitter emitter, YamlConfig.WriteConfig writeConfig) throws EmitterException, IOException {
        emitter.emit(new SequenceStartEvent(this.anchor, this.tag, this.tag == null, false));
        for (YamlElement yamlElement : this.elements) {
            yamlElement.emitEvent(emitter, writeConfig);
        }
        emitter.emit(Event.SEQUENCE_END);
    }

    @Override
    public YamlEntry getEntry(String string) throws YamlException {
        throw new YamlException("Can only get entry on mapping!");
    }

    @Override
    public YamlEntry getEntry(int n) throws YamlException {
        throw new YamlException("Can only get entry on mapping!");
    }

    @Override
    public boolean deleteEntry(String string) throws YamlException {
        throw new YamlException("Can only delete entry on mapping!");
    }

    @Override
    public void setEntry(String string, boolean bl) throws YamlException {
        throw new YamlException("Can only set entry on mapping!");
    }

    @Override
    public void setEntry(String string, Number number) throws YamlException {
        throw new YamlException("Can only set entry on mapping!");
    }

    @Override
    public void setEntry(String string, String string2) throws YamlException {
        throw new YamlException("Can only set entry on mapping!");
    }

    @Override
    public void setEntry(String string, YamlElement yamlElement) throws YamlException {
        throw new YamlException("Can only set entry on mapping!");
    }

    @Override
    public void setElement(int n, boolean bl) throws YamlException {
        this.elements.set(n, new YamlScalar(bl));
    }

    @Override
    public void setElement(int n, Number number) throws YamlException {
        this.elements.set(n, new YamlScalar(number));
    }

    @Override
    public void setElement(int n, String string) throws YamlException {
        this.elements.set(n, new YamlScalar(string));
    }

    @Override
    public void setElement(int n, YamlElement yamlElement) throws YamlException {
        this.elements.set(n, yamlElement);
    }

    @Override
    public void addElement(boolean bl) throws YamlException {
        this.elements.add(new YamlScalar(bl));
    }

    @Override
    public void addElement(Number number) throws YamlException {
        this.elements.add(new YamlScalar(number));
    }

    @Override
    public void addElement(String string) throws YamlException {
        this.elements.add(new YamlScalar(string));
    }
}

