/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans.document;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlDocument;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlEntry;
import com.esotericsoftware.yamlbeans.document.YamlScalar;
import com.esotericsoftware.yamlbeans.emitter.Emitter;
import com.esotericsoftware.yamlbeans.emitter.EmitterException;
import com.esotericsoftware.yamlbeans.parser.Event;
import com.esotericsoftware.yamlbeans.parser.MappingStartEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class YamlMapping
extends YamlElement
implements YamlDocument {
    List<YamlEntry> entries = new LinkedList<YamlEntry>();

    @Override
    public int size() {
        return this.entries.size();
    }

    public void addEntry(YamlEntry yamlEntry) {
        this.entries.add(yamlEntry);
    }

    @Override
    public boolean deleteEntry(String string) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!string.equals(this.entries.get(i).getKey().getValue())) continue;
            this.entries.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public YamlEntry getEntry(String string) throws YamlException {
        for (YamlEntry yamlEntry : this.entries) {
            if (!string.equals(yamlEntry.getKey().getValue())) continue;
            return yamlEntry;
        }
        return null;
    }

    @Override
    public YamlEntry getEntry(int n) throws YamlException {
        return this.entries.get(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.anchor != null) {
            stringBuffer.append('&');
            stringBuffer.append(this.anchor);
            stringBuffer.append(' ');
        }
        if (this.tag != null) {
            stringBuffer.append(" !");
            stringBuffer.append(this.tag);
        }
        if (!this.entries.isEmpty()) {
            stringBuffer.append('{');
            for (YamlEntry yamlEntry : this.entries) {
                stringBuffer.append(yamlEntry.toString());
                stringBuffer.append(',');
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append('}');
        }
        return stringBuffer.toString();
    }

    @Override
    public void emitEvent(Emitter emitter, YamlConfig.WriteConfig writeConfig) throws EmitterException, IOException {
        emitter.emit(new MappingStartEvent(this.anchor, this.tag, this.tag == null, false));
        for (YamlEntry yamlEntry : this.entries) {
            yamlEntry.emitEvent(emitter, writeConfig);
        }
        emitter.emit(Event.MAPPING_END);
    }

    @Override
    public void setEntry(String string, boolean bl) throws YamlException {
        this.setEntry(string, new YamlScalar(bl));
    }

    @Override
    public void setEntry(String string, Number number) throws YamlException {
        this.setEntry(string, new YamlScalar(number));
    }

    @Override
    public void setEntry(String string, String string2) throws YamlException {
        this.setEntry(string, new YamlScalar(string2));
    }

    @Override
    public void setEntry(String string, YamlElement yamlElement) throws YamlException {
        YamlEntry yamlEntry = this.getEntry(string);
        if (yamlEntry != null) {
            yamlEntry.setValue(yamlElement);
        } else {
            yamlEntry = new YamlEntry(new YamlScalar(string), yamlElement);
            this.addEntry(yamlEntry);
        }
    }

    @Override
    public YamlElement getElement(int n) throws YamlException {
        throw new YamlException("Can only get element on sequence!");
    }

    @Override
    public void deleteElement(int n) throws YamlException {
        throw new YamlException("Can only delete element on sequence!");
    }

    @Override
    public void setElement(int n, boolean bl) throws YamlException {
        throw new YamlException("Can only set element on sequence!");
    }

    @Override
    public void setElement(int n, Number number) throws YamlException {
        throw new YamlException("Can only set element on sequence!");
    }

    @Override
    public void setElement(int n, String string) throws YamlException {
        throw new YamlException("Can only set element on sequence!");
    }

    @Override
    public void setElement(int n, YamlElement yamlElement) throws YamlException {
        throw new YamlException("Can only set element on sequence!");
    }

    @Override
    public void addElement(boolean bl) throws YamlException {
        throw new YamlException("Can only add element on sequence!");
    }

    @Override
    public void addElement(Number number) throws YamlException {
        throw new YamlException("Can only add element on sequence!");
    }

    @Override
    public void addElement(String string) throws YamlException {
        throw new YamlException("Can only add element on sequence!");
    }

    @Override
    public void addElement(YamlElement yamlElement) throws YamlException {
        throw new YamlException("Can only add element on sequence!");
    }
}

