/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans;

import com.esotericsoftware.yamlbeans.Beans;
import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.emitter.Emitter;
import com.esotericsoftware.yamlbeans.emitter.EmitterException;
import com.esotericsoftware.yamlbeans.parser.AliasEvent;
import com.esotericsoftware.yamlbeans.parser.DocumentEndEvent;
import com.esotericsoftware.yamlbeans.parser.DocumentStartEvent;
import com.esotericsoftware.yamlbeans.parser.Event;
import com.esotericsoftware.yamlbeans.parser.MappingStartEvent;
import com.esotericsoftware.yamlbeans.parser.ScalarEvent;
import com.esotericsoftware.yamlbeans.parser.SequenceStartEvent;
import com.esotericsoftware.yamlbeans.scalar.ScalarSerializer;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class YamlWriter {
    private final YamlConfig config;
    private final Emitter emitter;
    private boolean started;
    private Map<Class, Object> defaultValuePrototypes = new IdentityHashMap<Class, Object>();
    private final List queuedObjects = new ArrayList();
    private final Map<Object, Integer> referenceCount = new IdentityHashMap<Object, Integer>();
    private final Map<Object, String> anchoredObjects = new HashMap<Object, String>();
    private int nextAnchor = 1;
    private boolean isRoot;

    public YamlWriter(Writer writer) {
        this(writer, new YamlConfig());
    }

    public YamlWriter(Writer writer, YamlConfig yamlConfig) {
        this.config = yamlConfig;
        this.emitter = new Emitter(writer, yamlConfig.writeConfig.emitterConfig);
    }

    public void setAlias(Object object, String string) {
        this.anchoredObjects.put(object, string);
    }

    public void write(Object object) throws YamlException {
        if (this.config.writeConfig.autoAnchor) {
            this.countObjectReferences(object);
            this.queuedObjects.add(object);
            return;
        }
        this.writeInternal(object);
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    private void writeInternal(Object object) throws YamlException {
        try {
            if (!this.started) {
                this.emitter.emit(Event.STREAM_START);
                this.started = true;
            }
            this.emitter.emit(new DocumentStartEvent(this.config.writeConfig.explicitFirstDocument, null, null));
            this.isRoot = true;
            this.writeValue(object, this.config.writeConfig.writeRootTags ? null : object.getClass(), null, null);
            this.emitter.emit(new DocumentEndEvent(this.config.writeConfig.explicitEndDocument));
        }
        catch (EmitterException emitterException) {
            throw new YamlException("Error writing YAML.", emitterException);
        }
        catch (IOException iOException) {
            throw new YamlException("Error writing YAML.", iOException);
        }
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    public void clearAnchors() throws YamlException {
        for (Object e : this.queuedObjects) {
            this.writeInternal(e);
        }
        this.queuedObjects.clear();
        this.referenceCount.clear();
        this.nextAnchor = 1;
    }

    public void close() throws YamlException {
        this.clearAnchors();
        this.defaultValuePrototypes.clear();
        try {
            this.emitter.emit(Event.STREAM_END);
            this.emitter.close();
        }
        catch (EmitterException emitterException) {
            throw new YamlException(emitterException);
        }
        catch (IOException iOException) {
            throw new YamlException(iOException);
        }
    }

    private void writeValue(Object object, Class clazz, Class clazz2, Class clazz3) throws EmitterException, IOException, YamlException {
        Object object2;
        Map.Entry<Class, ScalarSerializer> entry22;
        Object object3;
        boolean bl;
        boolean bl2 = this.isRoot;
        this.isRoot = false;
        if (object instanceof YamlElement) {
            ((YamlElement)object).emitEvent(this.emitter, this.config.writeConfig);
            return;
        }
        if (object == null) {
            this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, null, '\u0000'));
            return;
        }
        Class<?> clazz4 = object.getClass();
        boolean bl3 = bl = clazz == null;
        if (bl) {
            clazz = clazz4;
        }
        if (object instanceof Enum) {
            this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, ((Enum)object).name(), this.config.writeConfig.quote.c));
            return;
        }
        String string = null;
        if (!Beans.isScalar(clazz4)) {
            string = this.anchoredObjects.get(object);
            if (this.config.writeConfig.autoAnchor) {
                object3 = this.referenceCount.get(object);
                if (object3 == null) {
                    this.emitter.emit(new AliasEvent(this.anchoredObjects.get(object)));
                    return;
                }
                if ((Integer)object3 > 1) {
                    this.referenceCount.remove(object);
                    if (string == null) {
                        string = String.valueOf(this.nextAnchor++);
                        this.anchoredObjects.put(object, string);
                    }
                }
            }
        }
        object3 = null;
        boolean bl4 = false;
        if ((bl || clazz4 != clazz || this.config.writeConfig.writeClassName == YamlConfig.WriteClassName.ALWAYS) && this.config.writeConfig.writeClassName != YamlConfig.WriteClassName.NEVER) {
            bl4 = true;
            if ((bl || clazz == List.class) && clazz4 == ArrayList.class) {
                bl4 = false;
            }
            if ((bl || clazz == Map.class) && clazz4 == HashMap.class) {
                bl4 = false;
            }
            if (clazz == Set.class && clazz4 == HashSet.class) {
                bl4 = false;
            }
            if (clazz4 == clazz3) {
                bl4 = false;
            }
            if (bl4 && (object3 = this.config.classNameToTag.get(clazz4.getName())) == null) {
                object3 = clazz4.getName();
            }
        }
        for (Map.Entry<Class, ScalarSerializer> entry22 : this.config.scalarSerializers.entrySet()) {
            if (!entry22.getKey().isAssignableFrom(clazz4)) continue;
            ScalarSerializer scalarSerializer = (ScalarSerializer)entry22.getValue();
            this.emitter.emit(new ScalarEvent(null, (String)object3, new boolean[]{object3 == null, object3 == null}, scalarSerializer.write(object), '\u0000'));
            return;
        }
        if (Beans.isScalar(clazz4)) {
            char c = '\u0000';
            entry22 = String.valueOf(object);
            if (clazz4 == String.class) {
                try {
                    Float.parseFloat((String)((Object)entry22));
                    c = this.config.writeConfig.quote.c;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.emitter.emit(new ScalarEvent(null, (String)object3, new boolean[]{true, true}, (String)((Object)entry22), c));
            return;
        }
        if (object instanceof Collection) {
            this.emitter.emit(new SequenceStartEvent(string, (String)object3, !bl4, false));
            for (Map.Entry<Class, ScalarSerializer> entry22 : (Collection)object) {
                if (bl2 && !this.config.writeConfig.writeRootElementTags) {
                    clazz2 = entry22.getClass();
                }
                this.writeValue(entry22, clazz2, null, null);
            }
            this.emitter.emit(Event.SEQUENCE_END);
            return;
        }
        if (object instanceof Map) {
            this.emitter.emit(new MappingStartEvent(string, (String)object3, !bl4, false));
            object2 = (Map)object;
            for (Object e : object2.entrySet()) {
                Map.Entry entry3 = (Map.Entry)e;
                Object k = entry3.getKey();
                Object v = entry3.getValue();
                if (bl2 && !this.config.writeConfig.writeRootElementTags) {
                    clazz2 = v.getClass();
                }
                if (this.config.tagSuffix != null && k instanceof String) {
                    Object v2;
                    if (((String)k).endsWith(this.config.tagSuffix)) continue;
                    if (v instanceof String && (v2 = object2.get(k + this.config.tagSuffix)) instanceof String) {
                        String string2 = (String)v;
                        char c = '\u0000';
                        try {
                            Float.parseFloat(string2);
                            c = this.config.writeConfig.quote.c;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        this.writeValue(k, null, null, null);
                        this.emitter.emit(new ScalarEvent(null, (String)v2, new boolean[]{false, false}, string2, c));
                        continue;
                    }
                }
                this.writeValue(k, null, null, null);
                this.writeValue(v, clazz2, null, null);
            }
            this.emitter.emit(Event.MAPPING_END);
            return;
        }
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
            this.emitter.emit(new SequenceStartEvent(string, null, true, false));
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.writeValue(Array.get(object, i), clazz2, null, null);
            }
            this.emitter.emit(Event.SEQUENCE_END);
            return;
        }
        object2 = null;
        if (!this.config.writeConfig.writeDefaultValues && clazz4 != Class.class && (object2 = this.defaultValuePrototypes.get(clazz4)) == null && Beans.getDeferredConstruction(clazz4, this.config) == null) {
            try {
                object2 = Beans.createObject(clazz4, this.config.privateConstructors);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new YamlException("Error creating object prototype to determine default values.", invocationTargetException);
            }
            this.defaultValuePrototypes.put(clazz4, object2);
        }
        entry22 = Beans.getProperties(clazz4, this.config.beanProperties, this.config.privateFields, this.config);
        this.emitter.emit(new MappingStartEvent(string, (String)object3, !bl4, false));
        Iterator iterator = entry22.iterator();
        while (iterator.hasNext()) {
            Beans.Property property = (Beans.Property)iterator.next();
            try {
                Object object4;
                Object object5 = property.get(object);
                if (object2 != null) {
                    object4 = property.get(object2);
                    if (object5 == null && object4 == null || object5 != null && object4 != null && object4.equals(object5)) continue;
                }
                this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, property.getName(), this.config.writeConfig.quote.c));
                object4 = this.config.propertyToElementType.get(property);
                Class clazz5 = this.config.propertyToDefaultType.get(property);
                this.writeValue(object5, property.getType(), (Class)object4, clazz5);
            }
            catch (Exception exception) {
                throw new YamlException("Error getting property '" + property + "' on class: " + clazz4.getName(), exception);
            }
        }
        this.emitter.emit(Event.MAPPING_END);
    }

    private void countObjectReferences(Object object) throws YamlException {
        if (object == null || Beans.isScalar(object.getClass())) {
            return;
        }
        Integer n = this.referenceCount.get(object);
        if (n != null) {
            this.referenceCount.put(object, n + 1);
            return;
        }
        this.referenceCount.put(object, 1);
        if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                this.countObjectReferences(e);
            }
            return;
        }
        if (object instanceof Map) {
            for (Object v : ((Map)object).values()) {
                this.countObjectReferences(v);
            }
            return;
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            for (int i = 0; i < n2; ++i) {
                this.countObjectReferences(Array.get(object, i));
            }
            return;
        }
        Set<Beans.Property> set = Beans.getProperties(object.getClass(), this.config.beanProperties, this.config.privateFields, this.config);
        for (Beans.Property property : set) {
            Object object2;
            if (Beans.isScalar(property.getType())) continue;
            try {
                object2 = property.get(object);
            }
            catch (Exception exception) {
                throw new YamlException("Error getting property '" + property + "' on class: " + object.getClass().getName(), exception);
            }
            this.countObjectReferences(object2);
        }
    }
}

