/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans;

import com.esotericsoftware.yamlbeans.Beans;
import com.esotericsoftware.yamlbeans.DeferredConstruction;
import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.parser.AliasEvent;
import com.esotericsoftware.yamlbeans.parser.CollectionStartEvent;
import com.esotericsoftware.yamlbeans.parser.Event;
import com.esotericsoftware.yamlbeans.parser.EventType;
import com.esotericsoftware.yamlbeans.parser.Parser;
import com.esotericsoftware.yamlbeans.parser.ScalarEvent;
import com.esotericsoftware.yamlbeans.scalar.ScalarSerializer;
import com.esotericsoftware.yamlbeans.tokenizer.Tokenizer;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class YamlReader {
    private final YamlConfig config;
    Parser parser;
    private final Map<String, Object> anchors = new HashMap<String, Object>();

    public YamlReader(Reader reader) {
        this(reader, new YamlConfig());
    }

    public YamlReader(Reader reader, YamlConfig yamlConfig) {
        this.config = yamlConfig;
        this.parser = new Parser(reader, yamlConfig.readConfig.defaultVersion);
    }

    public YamlReader(String string) {
        this(new StringReader(string));
    }

    public YamlReader(String string, YamlConfig yamlConfig) {
        this(new StringReader(string), yamlConfig);
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    public Object get(String string) {
        return this.anchors.get(string);
    }

    public void close() throws IOException {
        this.parser.close();
        this.anchors.clear();
    }

    public Object read() throws YamlException {
        return this.read(null);
    }

    public <T> T read(Class<T> clazz) throws YamlException {
        return this.read(clazz, null);
    }

    public <T> T read(Class<T> clazz, Class clazz2) throws YamlException {
        try {
            Event event;
            do {
                if ((event = this.parser.getNextEvent()) == null) {
                    return null;
                }
                if (event.type != EventType.STREAM_END) continue;
                return null;
            } while (event.type != EventType.DOCUMENT_START);
            return (T)this.readValue(clazz, clazz2, null);
        }
        catch (Parser.ParserException parserException) {
            throw new YamlException("Error parsing YAML.", parserException);
        }
        catch (Tokenizer.TokenizerException tokenizerException) {
            throw new YamlException("Error tokenizing YAML.", tokenizerException);
        }
    }

    protected Object readValue(Class clazz, Class clazz2, Class clazz3) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
        String string = null;
        String string2 = null;
        Event event = this.parser.peekNextEvent();
        switch (event.type) {
            case ALIAS: {
                this.parser.getNextEvent();
                string2 = ((AliasEvent)event).anchor;
                Object object = this.anchors.get(string2);
                if (object == null) {
                    throw new YamlReaderException("Unknown anchor: " + string2);
                }
                return object;
            }
            case MAPPING_START: 
            case SEQUENCE_START: {
                string = ((CollectionStartEvent)event).tag;
                string2 = ((CollectionStartEvent)event).anchor;
                break;
            }
            case SCALAR: {
                string = ((ScalarEvent)event).tag;
                string2 = ((ScalarEvent)event).anchor;
                break;
            }
        }
        return this.readValueInternal(this.chooseType(string, clazz3, clazz), clazz2, string2);
    }

    private Class<?> chooseType(String string, Class<?> clazz, Class<?> clazz2) throws YamlReaderException {
        if (string != null && this.config.readConfig.classTags) {
            Class clazz3 = this.config.tagToClass.get(string);
            if (clazz3 != null) {
                return clazz3;
            }
            ClassLoader classLoader = this.config.readConfig.classLoader == null ? this.getClass().getClassLoader() : this.config.readConfig.classLoader;
            try {
                Class<?> clazz4 = this.findTagClass(string, classLoader);
                if (clazz4 != null) {
                    return clazz4;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new YamlReaderException("Unable to find class specified by tag: " + string);
            }
        }
        if (clazz != null) {
            return clazz;
        }
        return clazz2;
    }

    protected Class<?> findTagClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(string, true, classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private Object readValueInternal(Class clazz, Class clazz2, String string) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
        Object object2;
        if (clazz == null || clazz == Object.class) {
            object2 = this.parser.peekNextEvent();
            switch (((Event)object2).type) {
                case MAPPING_START: {
                    clazz = LinkedHashMap.class;
                    break;
                }
                case SCALAR: {
                    String object4;
                    if (this.config.readConfig.guessNumberTypes && (object4 = ((ScalarEvent)object2).value) != null) {
                        try {
                            Integer object8 = Integer.decode(object4);
                            if (string != null) {
                                this.anchors.put(string, object8);
                            }
                            this.parser.getNextEvent();
                            return object8;
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                Float f = Float.valueOf(object4);
                                if (string != null) {
                                    this.anchors.put(string, f);
                                }
                                this.parser.getNextEvent();
                                return f;
                            }
                            catch (NumberFormatException numberFormatException2) {
                                // empty catch block
                            }
                        }
                    }
                    clazz = String.class;
                    break;
                }
                case SEQUENCE_START: {
                    clazz = ArrayList.class;
                    break;
                }
                default: {
                    throw new YamlReaderException("Expected scalar, sequence, or mapping but found: " + (Object)((Object)((Event)object2).type));
                }
            }
        }
        if (clazz == String.class) {
            object2 = this.parser.getNextEvent();
            if (((Event)object2).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for String type but found: " + (Object)((Object)((Event)object2).type));
            }
            String string2 = ((ScalarEvent)object2).value;
            if (string != null) {
                this.anchors.put(string, string2);
            }
            return string2;
        }
        if (Beans.isScalar(clazz)) {
            object2 = this.parser.getNextEvent();
            if (((Event)object2).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for primitive type '" + clazz.getClass() + "' but found: " + (Object)((Object)((Event)object2).type));
            }
            String string3 = ((ScalarEvent)object2).value;
            try {
                Object object;
                if (clazz == String.class) {
                    object = string3;
                } else if (clazz == Integer.TYPE) {
                    object = string3.length() == 0 ? 0 : Integer.decode(string3);
                } else if (clazz == Integer.class) {
                    object = string3.length() == 0 ? null : Integer.decode(string3);
                } else if (clazz == Boolean.TYPE) {
                    object = string3.length() == 0 ? false : Boolean.valueOf(string3);
                } else if (clazz == Boolean.class) {
                    object = string3.length() == 0 ? null : Boolean.valueOf(string3);
                } else if (clazz == Float.TYPE) {
                    object = Float.valueOf(string3.length() == 0 ? 0.0f : Float.valueOf(string3).floatValue());
                } else if (clazz == Float.class) {
                    object = string3.length() == 0 ? null : Float.valueOf(string3);
                } else if (clazz == Double.TYPE) {
                    object = string3.length() == 0 ? 0.0 : Double.valueOf(string3);
                } else if (clazz == Double.class) {
                    object = string3.length() == 0 ? null : Double.valueOf(string3);
                } else if (clazz == Long.TYPE) {
                    object = string3.length() == 0 ? 0L : Long.decode(string3);
                } else if (clazz == Long.class) {
                    object = string3.length() == 0 ? null : Long.decode(string3);
                } else if (clazz == Short.TYPE) {
                    object = string3.length() == 0 ? (short)0 : Short.decode(string3);
                } else if (clazz == Short.class) {
                    object = string3.length() == 0 ? null : Short.decode(string3);
                } else if (clazz == Character.TYPE) {
                    object = Character.valueOf(string3.length() == 0 ? (char)'\u0000' : string3.charAt(0));
                } else if (clazz == Character.class) {
                    object = string3.length() == 0 ? null : Character.valueOf(string3.charAt(0));
                } else if (clazz == Byte.TYPE) {
                    object = string3.length() == 0 ? (byte)0 : Byte.decode(string3);
                } else if (clazz == Byte.class) {
                    object = string3.length() == 0 ? null : Byte.decode(string3);
                } else {
                    throw new YamlException("Unknown field type.");
                }
                if (string != null) {
                    this.anchors.put(string, object);
                }
                return object;
            }
            catch (Exception exception) {
                throw new YamlReaderException("Unable to convert value to required type \"" + clazz + "\": " + string3, exception);
            }
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            object2 = this.parser.getNextEvent();
            if (((Event)object2).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for enum type but found: " + (Object)((Object)((Event)object2).type));
            }
            String string4 = ((ScalarEvent)object2).value;
            if (string4.length() == 0) {
                return null;
            }
            try {
                return Enum.valueOf(clazz, string4);
            }
            catch (Exception exception) {
                throw new YamlReaderException("Unable to find enum value '" + string4 + "' for enum class: " + clazz.getName());
            }
        }
        for (Map.Entry entry : this.config.scalarSerializers.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(clazz)) continue;
            ScalarSerializer scalarSerializer = (ScalarSerializer)entry.getValue();
            Event event = this.parser.getNextEvent();
            if (event.type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for type '" + clazz + "' to be deserialized by scalar serializer '" + scalarSerializer.getClass().getName() + "' but found: " + (Object)((Object)event.type));
            }
            Object t = scalarSerializer.read(((ScalarEvent)event).value);
            if (string != null) {
                this.anchors.put(string, t);
            }
            return t;
        }
        object2 = this.parser.peekNextEvent();
        switch (((Event)object2).type) {
            case MAPPING_START: {
                void var5_13;
                Object object;
                object2 = this.parser.getNextEvent();
                try {
                    object = this.createObject(clazz);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new YamlReaderException("Error creating object.", invocationTargetException);
                }
                if (string != null) {
                    this.anchors.put(string, object);
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (true) {
                    Object object3;
                    if (this.parser.peekNextEvent().type == EventType.MAPPING_END) break;
                    Object object4 = this.readValue(null, null, null);
                    boolean bl = object4 instanceof Map;
                    Object object5 = null;
                    if (bl) {
                        object3 = ((Map)object4).entrySet().iterator().next();
                        object4 = object3.getKey();
                        object5 = object3.getValue();
                    }
                    if (object instanceof Map) {
                        if (this.config.tagSuffix != null) {
                            object3 = this.parser.peekNextEvent();
                            switch (((Event)object3).type) {
                                case MAPPING_START: 
                                case SEQUENCE_START: {
                                    ((Map)object).put(object4 + this.config.tagSuffix, ((CollectionStartEvent)object3).tag);
                                    break;
                                }
                                case SCALAR: {
                                    ((Map)object).put(object4 + this.config.tagSuffix, ((ScalarEvent)object3).tag);
                                }
                            }
                        }
                        if (!bl) {
                            object5 = this.readValue(clazz2, null, null);
                        }
                        if (!this.config.allowDuplicates && ((Map)object).containsKey(object4)) {
                            throw new YamlReaderException("Duplicate key found '" + object4 + "'");
                        }
                        if (this.config.readConfig.autoMerge && "<<".equals(object4) && object5 != null) {
                            this.mergeMap((Map)object, object5);
                            continue;
                        }
                        ((Map)object).put(object4, object5);
                        continue;
                    }
                    try {
                        if (!this.config.allowDuplicates && arrayList.contains(object4)) {
                            throw new YamlReaderException("Duplicate key found '" + object4 + "'");
                        }
                        arrayList.add(object4);
                        object3 = Beans.getProperty(clazz, (String)object4, this.config.beanProperties, this.config.privateFields, this.config);
                        if (object3 == null) {
                            if (this.config.readConfig.ignoreUnknownProperties) continue;
                            throw new YamlReaderException("Unable to find property '" + object4 + "' on class: " + clazz.getName());
                        }
                        Class clazz3 = this.config.propertyToElementType.get(object3);
                        if (clazz3 == null) {
                            clazz3 = ((Beans.Property)object3).getElementType();
                        }
                        Class clazz4 = this.config.propertyToDefaultType.get(object3);
                        if (!bl) {
                            object5 = this.readValue(((Beans.Property)object3).getType(), clazz3, clazz4);
                        }
                        ((Beans.Property)object3).set(object, object5);
                    }
                    catch (Exception exception) {
                        if (exception instanceof YamlReaderException) {
                            throw (YamlReaderException)exception;
                        }
                        throw new YamlReaderException("Error setting property '" + object4 + "' on class: " + clazz.getName(), exception);
                    }
                }
                this.parser.getNextEvent();
                if (object instanceof DeferredConstruction) {
                    try {
                        Object object6 = ((DeferredConstruction)object).construct();
                        if (string != null) {
                            this.anchors.put(string, object6);
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new YamlReaderException("Error creating object.", invocationTargetException);
                    }
                }
                return var5_13;
            }
            case SEQUENCE_START: {
                void var5_16;
                object2 = this.parser.getNextEvent();
                if (Collection.class.isAssignableFrom(clazz)) {
                    try {
                        Collection collection = (Collection)Beans.createObject(clazz, this.config.privateConstructors);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new YamlReaderException("Error creating object.", invocationTargetException);
                    }
                } else if (clazz.isArray()) {
                    ArrayList arrayList = new ArrayList();
                    clazz2 = clazz.getComponentType();
                } else {
                    throw new YamlReaderException("A sequence is not a valid value for the type: " + clazz.getName());
                }
                if (!clazz.isArray() && string != null) {
                    this.anchors.put(string, var5_16);
                }
                while (true) {
                    object2 = this.parser.peekNextEvent();
                    if (((Event)object2).type == EventType.SEQUENCE_END) break;
                    var5_16.add(this.readValue(clazz2, null, null));
                }
                this.parser.getNextEvent();
                if (!clazz.isArray()) {
                    return var5_16;
                }
                Object object = Array.newInstance(clazz2, var5_16.size());
                int n = 0;
                for (Object e : var5_16) {
                    Array.set(object, n++, e);
                }
                if (string != null) {
                    this.anchors.put(string, object);
                }
                return object;
            }
            case SCALAR: {
                if (((ScalarEvent)object2).value.length() != 0) break;
                object2 = this.parser.getNextEvent();
                return null;
            }
        }
        throw new YamlReaderException("Expected data for a " + clazz.getName() + " field but found: " + (Object)((Object)((Event)object2).type));
    }

    private void mergeMap(Map<String, Object> map, Object object) throws YamlReaderException {
        if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                this.mergeMap(map, e);
            }
        } else if (object instanceof Map) {
            Map map2 = (Map)object;
            for (Map.Entry entry : map2.entrySet()) {
                if (map.containsKey(entry.getKey())) continue;
                map.put((String)entry.getKey(), entry.getValue());
            }
        } else {
            throw new YamlReaderException("Expected a mapping or a sequence of mappings for a '<<' merge field but found: " + object.getClass().getSimpleName());
        }
    }

    protected Object createObject(Class clazz) throws InvocationTargetException {
        DeferredConstruction deferredConstruction = Beans.getDeferredConstruction(clazz, this.config);
        if (deferredConstruction != null) {
            return deferredConstruction;
        }
        return Beans.createObject(clazz, this.config.privateConstructors);
    }

    public static void main(String[] stringArray) throws Exception {
        YamlReader yamlReader = new YamlReader(new FileReader("test/test.yml"));
        System.out.println(yamlReader.read());
    }

    public class YamlReaderException
    extends YamlException {
        public YamlReaderException(String string, Throwable throwable) {
            super("Line " + YamlReader.this.parser.getLineNumber() + ", column " + YamlReader.this.parser.getColumn() + ": " + string, throwable);
        }

        public YamlReaderException(String string) {
            this(string, null);
        }
    }
}

