/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans;

import com.esotericsoftware.yamlbeans.Beans;
import com.esotericsoftware.yamlbeans.Version;
import com.esotericsoftware.yamlbeans.emitter.EmitterConfig;
import com.esotericsoftware.yamlbeans.scalar.DateSerializer;
import com.esotericsoftware.yamlbeans.scalar.ScalarSerializer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class YamlConfig {
    public final WriteConfig writeConfig = new WriteConfig();
    public final ReadConfig readConfig = new ReadConfig();
    final Map<String, String> classNameToTag = new HashMap<String, String>();
    final Map<String, Class> tagToClass = new HashMap<String, Class>();
    final Map<Class, ScalarSerializer> scalarSerializers = new IdentityHashMap<Class, ScalarSerializer>();
    final Map<Beans.Property, Class> propertyToElementType = new HashMap<Beans.Property, Class>();
    final Map<Beans.Property, Class> propertyToDefaultType = new HashMap<Beans.Property, Class>();
    boolean beanProperties = true;
    boolean privateFields;
    boolean privateConstructors = true;
    boolean allowDuplicates = true;
    String tagSuffix;

    public YamlConfig() {
        this.scalarSerializers.put(Date.class, new DateSerializer());
        this.tagToClass.put("tag:yaml.org,2002:str", String.class);
        this.tagToClass.put("tag:yaml.org,2002:int", Integer.class);
        this.tagToClass.put("tag:yaml.org,2002:seq", ArrayList.class);
        this.tagToClass.put("tag:yaml.org,2002:map", HashMap.class);
        this.tagToClass.put("tag:yaml.org,2002:float", Float.class);
    }

    public void setAllowDuplicates(boolean bl) {
        this.allowDuplicates = bl;
    }

    public void setClassTag(String string, Class clazz) {
        if (string == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.classNameToTag.put(clazz.getName(), string);
        this.tagToClass.put(string, clazz);
    }

    public void setScalarSerializer(Class clazz, ScalarSerializer scalarSerializer) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (scalarSerializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.scalarSerializers.put(clazz, scalarSerializer);
    }

    public void setPropertyElementType(Class clazz, String string, Class clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("propertyName cannot be null.");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("propertyType cannot be null.");
        }
        Beans.Property property = Beans.getProperty(clazz, string, this.beanProperties, this.privateFields, this);
        if (property == null) {
            throw new IllegalArgumentException("The class " + clazz.getName() + " does not have a property named: " + string);
        }
        if (!Collection.class.isAssignableFrom(property.getType()) && !Map.class.isAssignableFrom(property.getType())) {
            throw new IllegalArgumentException("The '" + string + "' property on the " + clazz.getName() + " class must be a Collection or Map: " + property.getType());
        }
        this.propertyToElementType.put(property, clazz2);
    }

    public void setPropertyDefaultType(Class clazz, String string, Class clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("propertyName cannot be null.");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("defaultType cannot be null.");
        }
        Beans.Property property = Beans.getProperty(clazz, string, this.beanProperties, this.privateFields, this);
        if (property == null) {
            throw new IllegalArgumentException("The class " + clazz.getName() + " does not have a property named: " + string);
        }
        this.propertyToDefaultType.put(property, clazz2);
    }

    public void setBeanProperties(boolean bl) {
        this.beanProperties = bl;
    }

    public void setPrivateFields(boolean bl) {
        this.privateFields = bl;
    }

    public void setPrivateConstructors(boolean bl) {
        this.privateConstructors = bl;
    }

    public void setTagSuffix(String string) {
        this.tagSuffix = string;
    }

    public static enum Quote {
        NONE('\u0000'),
        SINGLE('\''),
        DOUBLE('\"');

        char c;

        private Quote(char c) {
            this.c = c;
        }
    }

    public static enum WriteClassName {
        ALWAYS,
        NEVER,
        AUTO;

    }

    static class ConstructorParameters {
        public Constructor constructor;
        public String[] parameterNames;

        ConstructorParameters() {
        }
    }

    public static class ReadConfig {
        Version defaultVersion = new Version(1, 1);
        ClassLoader classLoader;
        final Map<Class, ConstructorParameters> constructorParameters = new IdentityHashMap<Class, ConstructorParameters>();
        boolean ignoreUnknownProperties;
        boolean autoMerge = true;
        boolean classTags = true;
        boolean guessNumberTypes;

        ReadConfig() {
        }

        public void setDefaultVersion(Version version) {
            if (version == null) {
                throw new IllegalArgumentException("defaultVersion cannot be null.");
            }
            this.defaultVersion = version;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public void setConstructorParameters(Class clazz, Class[] classArray, String[] stringArray) {
            if (clazz == null) {
                throw new IllegalArgumentException("type cannot be null.");
            }
            if (classArray == null) {
                throw new IllegalArgumentException("parameterTypes cannot be null.");
            }
            if (stringArray == null) {
                throw new IllegalArgumentException("parameterNames cannot be null.");
            }
            ConstructorParameters constructorParameters = new ConstructorParameters();
            try {
                constructorParameters.constructor = clazz.getConstructor(classArray);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Unable to find constructor: " + clazz.getName() + "(" + Arrays.toString(classArray) + ")", exception);
            }
            constructorParameters.parameterNames = stringArray;
            this.constructorParameters.put(clazz, constructorParameters);
        }

        public void setIgnoreUnknownProperties(boolean bl) {
            this.ignoreUnknownProperties = bl;
        }

        public void setClassTags(boolean bl) {
            this.classTags = bl;
        }

        public void setGuessNumberTypes(boolean bl) {
            this.guessNumberTypes = bl;
        }
    }

    public static class WriteConfig {
        boolean explicitFirstDocument = false;
        boolean explicitEndDocument = false;
        boolean writeDefaultValues = false;
        boolean writeRootTags = true;
        boolean writeRootElementTags = true;
        boolean autoAnchor = true;
        boolean keepBeanPropertyOrder = false;
        WriteClassName writeClassName = WriteClassName.AUTO;
        Quote quote = Quote.NONE;
        EmitterConfig emitterConfig = new EmitterConfig();

        WriteConfig() {
            this.emitterConfig.setUseVerbatimTags(false);
        }

        public void setExplicitFirstDocument(boolean bl) {
            this.explicitFirstDocument = bl;
        }

        public void setExplicitEndDocument(boolean bl) {
            this.explicitEndDocument = bl;
        }

        public void setWriteRootTags(boolean bl) {
            this.writeRootTags = bl;
        }

        public void setWriteRootElementTags(boolean bl) {
            this.writeRootElementTags = bl;
        }

        public void setWriteDefaultValues(boolean bl) {
            this.writeDefaultValues = bl;
        }

        public void setAutoAnchor(boolean bl) {
            this.autoAnchor = bl;
        }

        public void setKeepBeanPropertyOrder(boolean bl) {
            this.keepBeanPropertyOrder = bl;
        }

        public void setVersion(Version version) {
            this.emitterConfig.setVersion(version);
        }

        public void setCanonical(boolean bl) {
            this.emitterConfig.setCanonical(bl);
        }

        public void setIndentSize(int n) {
            this.emitterConfig.setIndentSize(n);
        }

        public void setWrapColumn(int n) {
            this.emitterConfig.setWrapColumn(n);
        }

        public void setUseVerbatimTags(boolean bl) {
            this.emitterConfig.setUseVerbatimTags(bl);
        }

        public void setEscapeUnicode(boolean bl) {
            this.emitterConfig.setEscapeUnicode(bl);
        }

        public void setWriteClassname(WriteClassName writeClassName) {
            this.writeClassName = writeClassName;
        }

        public void setQuoteChar(Quote quote) {
            this.quote = quote;
        }
    }
}

