# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gino_admin', 'gino_admin.routes']

package_data = \
{'': ['*'], 'gino_admin': ['static/*', 'templates/*', 'templates/modals/*']}

install_requires = \
['PyYAML>=5.3.1,<6.0.0',
 'Sanic-Jinja2==0.8.0',
 'aiofiles>=0.5.0,<0.6.0',
 'click>=7.1.2,<8.0.0',
 'dsnparse>=0.1.15,<0.2.0',
 'expiring-dict>=1.1.0,<2.0.0',
 'gino-sanic>=0.1.0,<0.2.0',
 'gino>=1.0.0,<2.0.0',
 'passlib>=1.7.4,<2.0.0',
 'pydantic>=1.5.1,<2.0.0',
 'sanic-jwt>=1.4.1,<2.0.0',
 'sqlalchemy_utils>=0.36.8,<0.37.0']

entry_points = \
{'console_scripts': ['gino-admin = gino_admin.cli:cli']}

setup_kwargs = {
    'name': 'gino-admin',
    'version': '0.2.1',
    'description': 'Admin Panel for PostgreSQL DB with Gino ORM',
    'long_description': '\nGino-Admin\n----------\n\n\n.. image:: img/logo/g_logo.svg\n   :target: img/logo/g_logo.svg\n   :alt: Gino-Admin Logo\n \n\nDocs (state: in process): `Gino-Admin docs <https://gino-admin.readthedocs.io/en/latest/ui_screens.html>`_\n\nPlay with Demo (current master 0.2.1) `>>>> Gino-Admin demo <<<< <http://www.xnu-im.space/gino_admin_demo/login>`_ (login: admin, pass: 1234)\n\n\n.. image:: https://img.shields.io/pypi/v/gino_admin\n   :target: https://img.shields.io/pypi/v/gino_admin\n   :alt: badge1\n \n.. image:: https://img.shields.io/pypi/l/gino_admin\n   :target: https://img.shields.io/pypi/l/gino_admin\n   :alt: badge2\n \n.. image:: https://img.shields.io/pypi/pyversions/gino_admin\n   :target: https://img.shields.io/pypi/pyversions/gino_admin\n   :alt: badge3\n \n\nAdmin Panel for PostgreSQL DB with Gino ORM and Sanic\n\n\n.. image:: img/table_view_new.png\n   :target: img/table_view_new.png\n   :alt: Table view\n\n\n.. image:: img/db_presets.png\n   :target: img/db_presets.png\n   :alt: Load Presets\n\n\nHow to install\n^^^^^^^^^^^^^^\n\n.. code-block:: bash\n\n\n       pip install gino-admin==0.2.1\n\nHow to use\n^^^^^^^^^^\n\nYou can find several code examples in `examples/ <examples/>`_ folder.\n\nUpdates in version 0.2.1 (current master):\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n\n#. Fixes:\n\n1.1 Dependencies - removed unnecessary packages and added one lost for cli. Cli now works correct. \n1.2 Login form now provide errors if you enter wrong user or passoword\n1.3 Wrong attepts to login in Admin panel are adding to History now\n\n\n#. Added possibility to customize UI colors with config. \n\nDefault colors schema also changed:\n\n\n.. image:: img/new_colors.png\n   :target: img/new_colors.png\n   :alt: Table view\n\n\nConfig object now has section \'ui\'. In UI section now exist \'colors\' where you can set up colors that will be used for:\n\n\n* Primary buttons. Property: buttons\n* Second buttons. Property: buttons_second\n* Alert buttons (actions that something remove/reset - deleted, drop db and etc). Property: buttons_alert\n* Tables headers. Property: table\n* Tables with Alert headers (like in Init DB). Property: table_alerts\n* Footer background. Property: footer\n* Header background. Property: header\n\nAdmin panel used SemanticUI as CSS Framework so all names of possible colors is described and showed here:\nhttps://semantic-ui.com/usage/theming.html \n\n(red: #B03060; orange #FE9A76; yellow: #FFD700; olive:  #32CD32 green:  #016936; teal :  #008080; blue :  #0E6EB8; violet: #EE82EE; purple: #B413EC; pink:  #FF1493; brown:  #A52A2A; grey :  #A0A0A0; black:  #000000;)\n\nTo change colors pass config as:\n\n.. code-block:: python\n\n\n   create_admin_app(\n           host="0.0.0.0",\n           port=os.getenv("PORT", 5000),\n           db=kkr_metadata.models.db,\n           db_models=db_models,\n           config={\n               "ui" : {\n                   "colors": \n                   {"buttons": "orange",\n                   "buttons_alert": "pink"}\n                   },\n               "db_uri": "postgresql://gino:gino@localhost:5432/gino"\n           },\n       )\n\nExample here: examples/colored_ui/\n\n\n#. \n   Added example how to add all models from file with one method (to avoid import each model separate) - palced in *examples/colored_ui/src/app.py* method - **create_models_list**\n\n#. \n   Added valid input for Text columns as Text Area\n\n   .. image:: img/text_area.png\n      :target: img/text_area.png\n      :alt: Text Area Inouts\n\n\nUpdates in version 0.2.0:\n^^^^^^^^^^^^^^^^^^^^^^^^^\n\n\n#. **UI fixes**\\ : \n\n\n* Data Picker was fixed, required fields now dispalayed with \'* required\' in UI.\n* Menu in header became scrollable, now you can see 20+ models without pain\n* Tables became scrollable horisontal - you can keep dozen columns and see them (hooray!)\n* in Add/edit forms now displayd the field type\n\n\n#. **Major changes**\\ : \n\n\n* **Limitation to have \'unique\' rows was removed**. Now you not need any unique keys to make possible work with table in Admin panel. Just keep in mind that if you edit row - you will also edit all full \'dublicated\' rows. So we try identify row by all fields. \n  But if you have several full duplicates in rows - edit action will edit all of them. \n\nLimits:\n\nDeepcopy does not available for tables without primary keys right now.\n\n\n* \n  **Primary keys** now also used to identify unique rows. Now Admin Panel don\'t expect only \'unique\' key in model. Now it firstly works with Primary Keys and only if primary key not exist in model - use \'unique\' fields to identify unique rows. Also it supports Composite Primary keys (2 and more fields) in all type of operations: delete/update/insert/deepcopy/copy.\n\n* \n  **Schemas support**\n\nNow if you work using the custom "schema" name - it\'s okay and supported by Admin Panel.  \n\n\n#. **Fixed in types support**\\ :\n\n\n* passing data as a string - now supported both Date & DateTime format (before correct work only DataTime format)\n* parsing lists (for fields with ARRAY type), also parsed type inside array\n\n\n#. **Types support improvement**\\ : \n\n\n* Added support for ARRAYS, TEXT, SmallInt, CHAR, Time\n\n\n#. **New features**\\ : \n\n\n* \n  Added Users to Admin Panel - now you can add multiple users for the panel to track history of changes correct and separate accesses\n\n* \n  URI to DB now can be passed as config parameter \'db_uri\' or with env variable \'DB_URI\',\n  for example, no need to setup SANIC variables:\n\n.. code-block:: python\n\n\n   create_admin_app(\n           host="0.0.0.0",\n           port=os.getenv("PORT", 5000),\n           db=kkr_metadata.models.db,\n           db_models=db_models,\n           config={\n               "presets_folder": os.path.join(current_path, "csv_to_upload"),\n               "db_uri": "postgresql://local:local@localhost:5432/gino_admin"\n           },\n       )\n\n\n#. **More fixes**\\ :\n\n\n* History works again\n\nSupported features\n^^^^^^^^^^^^^^^^^^\n\n\n* Auth by login/pass with cookie check\n* Create(Add new) item by one for the Model\n* Delete all rows/per element\n* Copy existed element (data table row)\n* Edit existed data (table row)\n* Search/sort in tables\n* Deepcopy element (recursive copy all rows/objects that depend on chosen as ForeignKey)\n* `Upload/export data from/to CSV <https://gino-admin.readthedocs.io/en/latest/csv_upload.html#upload-csv-files>`_\n* SQL-Runner (execute SQL-queries)\n* `Presets: Define order and Load to DB bunch of CSV-files <https://gino-admin.readthedocs.io/en/latest/presets.html>`_\n* Init DB (Full clean up behavior: Drop tables & Recreate)\n* `Composite CSV: Load multiple relative tables in one CSV-file <https://gino-admin.readthedocs.io/en/latest/csv_upload.html#composite-csv-to-upload>`_\n* History logs on changes (log for admin panel actions - edit, delete, add, init_db, load presets and etc)\n* Support multiple users for Admin panel (add, edit, remove users from \'Admin Users\' page)\n* UI Colors customizing\n\nTODO:\n^^^^^\n\n\n* Add possible to add new Presets from GUI\n* Select multiple rows for delete\n* Copy/deepcopy multiple items\n* Edit multiple items (?)\n* Roles for Admin Panel users (split accessess)\n* Filters in Table\'s columns\n* Other staff on `Gino Project Dashboard <https://github.com/xnuinside/gino-admin/projects/1>`_\n\nRun Admin Panel with Cli\n------------------------\n\n.. code-block:: bash\n\n\n       gino-admin run #module_name_with_models -d postgresql://%(DB_USER):%(DB_PASSWORD)@%(DB_HOST):%(DB_PORT)/%(DB)\n\n       gino-admin run --help # use to get cli help\n       Optional params:\n           -d --db\n               Expected format: postgresql://%(DB_USER):%(DB_PASSWORD)@%(DB_HOST):%(DB_PORT)/%(DB)\n               Example: postgresql://gino:gino@%gino:5432/gino (based on DB settings in examples/)\n               Notice: DB credentials can be set up as  env variables with \'SANIC_\' prefix\n           -h --host\n           -p --port\n           -c --config Example:  -c "presets_folder=examples/base_example/src/csv_to_upload;some_property=1"\n                       Notice: all fields that not supported in config will be ignored, like \'some_property\' in example\n           --no-auth  Run Admin Panel without Auth in UI\n           -u --user Admin User login & password\n               Expected format: login:password\n               Example: admin:1234\n               Notice: user also can be defined from env variable with \'SANIC_\' prefix - check Auth section example\n\nExample:\n\n.. code-block:: bash\n\n\n       gino-admin run examples/base_example/src/db.py --db postgresql://local:local@localhost:5432/kkr_metadata -u admin:1234\n\nAdd Admin Panel to existed Sanic application as \'/admin\' route\n--------------------------------------------------------------\n\nCreate in your project \'admin.py\' file and use ``add_admin_panel`` from from gino_admin import add_admin_panel\n\nCode example in:  examples/base_example\nHow to run example in: examples/base_example/how_to_run_example.txt\n\nExample:\n\n.. code-block:: python\n\n\n       from from gino_admin import add_admin_panel\n\n\n       # your app code\n\n\n       add_admin_panel(\n           app, db, [User, Place, City, GiftCard], custom_hash_method=custom_hash_method\n       )\n\nWhere:\n\n\n* \'app\': your Sanic application\n* \'db\' : from gino.ext.sanic import Gino; db = Gino() and\n* [User, Place, City, GiftCard] - list of models that you want to add in Admin Panel to maintain\n* custom_hash_method - optional parameter to define you own hash method to encrypt all \'_hash\' columns of your Models.\n\nIn admin panel _hash fields will be displayed without \'_hash\' prefix and fields values will be  hidden like \'\\ ******\\ \'\n\nRun Admin Panel as Standalone Sanic App\n--------------------------------------~\n\nNote: this method is a good approach if you use different frameworks as Main App\n\nYou can use Gino Admin as stand alone web app. Does not matter what Framework used for your main App.\n\nCode example in:  examples/use_with_any_framework_in_main_app/\nHow to run example in: examples/use_with_any_framework_in_main_app/how_to_run_example.txt\n\n\n#. In module where you define DB add \'if block\'.\n   We will use Fast API as main App in our example.\n\nWe have db.py where we import Gino as\n\n.. code-block::\n\n       from gino.ext.starlette import Gino\n\n       db = Gino(\n           dsn=\'postgresql://gino:gino@localhost:5432/gino\'\n       )\n\nBut if we use this module in Admin Panel we need to have initialisation like this:\n\n.. code-block::\n\n       from gino.ext.sanic import Gino\n       db = Gino()\n\nTo get this, we will add some flag and based on this flag module will init db in needed to as way:\n\n.. code-block::\n\n\n       if os.environ.get(\'GINO_ADMIN\'):\n           from gino.ext.sanic import Gino\n           db = Gino()\n       else:\n           from gino.ext.starlette import Gino\n           db = Gino(dsn=\'postgresql://gino:gino@localhost:5432/gino\')\n\nSo, if now \'db\' used by Gino Admin - we use init for Sanic apps, if not - we use for our Main application Framework\n\nNow, we need to create **admin.py** to run admin panel:\n\n.. code-block::\n\n       import os\n\n       from gino_admin import create_admin_app\n\n       os.environ["GINO_ADMIN"] = "1"\n\n       # gino admin uses Sanic as a framework, so you can define most params as environment variables with \'SANIC_\' prefix\n       # in example used this way to define DB credentials & login-password to admin panel\n\n       os.environ["SANIC_DB_HOST"] = "localhost"\n       os.environ["SANIC_DB_DATABASE"] = "gino"\n       os.environ["SANIC_DB_USER"] = "gino"\n       os.environ["SANIC_DB_PASSWORD"] = "gino"\n\n\n       os.environ["SANIC_ADMIN_USER"] = "admin"\n       os.environ["SANIC_ADMIN_PASSWORD"] = "1234"\n\n\n       if __name__ == "__main__":\n           # variable GINO_ADMIN must be set up before import db module, this is why we do import under if __name__\n           import db # noqa E402\n\n           # host & port - will be used to up on them admin app\n           # config - Gino Admin configuration,\n           # that allow set path to presets folder or custom_hash_method, optional parameter\n           # db_models - list of db.Models classes (tables) that you want to see in Admin Panel\n           create_admin_app(host="0.0.0.0", port=5000, db=db.db, db_models=[db.User, db.City, db.GiftCard])\n\nAll environment variables you can move to define in docker or .env files as you wish, they not needed to be define in \'.py\', this is just for example shortness.\n\nPresets\n^^^^^^^\n\nLoad multiple CSV to DB in order by one click. \nPresets described that CSV-s files and in that order need to be loaded in DB.\n\nRead the docs: `Presets <https://gino-admin.readthedocs.io/en/latest/presets.html>`_\n\nComposite CSV to Upload\n^^^^^^^^^^^^^^^^^^^^^^^\n\nComposite CSV - one file that contains data for several relative tables. \n\nRead the docs: `Composite CSV to Upload <https://gino-admin.readthedocs.io/en/latest/csv_upload.html#composite-csv-to-upload>`_\n\nConfig Gino Admin\n^^^^^^^^^^^^^^^^^\n\nRead the docs: `Config <https://gino-admin.readthedocs.io/en/latest/config.html>`_\n\nInit DB\n^^^^^^^\n\nInit DB feature used for doing full clean up DB - it drop all tables & create them after Drop for all models in Admin Panel.\n\nUpload from CSV\n^^^^^^^^^^^^^^^\n\nFiles-samples for example project can be found here: **examples/base_example/src/csv_to_upload**\n\nAuthorization\n^^^^^^^^^^^^^\n\nRead in docs: `Authorization <https://gino-admin.readthedocs.io/en/latest/authorization.html>`_\n\nLimitations\n^^^^^^^^^^^\n\nIn current version, for correct work of Deepcopy feature in Admin Panel model MUST contain at least one unique or primary_key Column (field).\n\nScreens:\n^^^^^^^^\n\nCheck in docs: `UI Screens <https://gino-admin.readthedocs.io/en/latest/ui_screens.html>`_\n',
    'author': 'xnuinside',
    'author_email': 'xnuinside@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/xnuinside/gino-admin',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
