# HyPyP 🐍〰️🐍

The **Hy**perscanning **Py**thon **P**ipeline

[![PyPI version shields.io](https://img.shields.io/pypi/v/hypyp.svg)](https://pypi.org/project/HyPyP/) <a href="https://travis-ci.org/GHFC/HyPyP"><img src="https://travis-ci.org/GHFC/HyPyP.svg?branch=master"></a> [![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause) [![Gitter](https://badges.gitter.im/GHFC/HyPyP.svg)](https://gitter.im/GHFC/HyPyP)

## Contributors
Florence BRUN, Anaël AYROLLES, Phoebe CHEN, Amir DJALOVSKI, Yann BEAUXIS, Suzanne DIKKER, Guillaume DUMAS

## Installation

```
pip install HyPyP
```

## Documentation

HyPyP documentation of all the API functions is available online at [hypyp.readthedocs.io](https://hypyp.readthedocs.io/)

For getting started with HyPyP, we have designed a little walkthrough: [getting_started.ipynb](https://github.com/GHFC/HyPyP/blob/master/tutorial/getting_started.ipynb)

## API

🛠 [io.py](https://github.com/GHFC/HyPyP/blob/master/hypyp/io.py) — Loaders (Florence, Anaël, Guillaume)

🧰 [utils.py](https://github.com/GHFC/HyPyP/blob/master/hypyp/utils.py) — Basic tools (Amir, Florence, Guilaume)

⚙️ [prep.py](https://github.com/GHFC/HyPyP/blob/master/hypyp/prep.py) — Preprocessing (ICA & AutoReject) (Anaël, Florence, Guillaume)

🔠 [analyses.py](https://github.com/GHFC/HyPyP/blob/master/hypyp/analyses.py) — Power spectral density and wide choice of connectivity measures (Phoebe, Suzanne, Florence, Guillaume)

📈 [stats.py](https://github.com/GHFC/HyPyP/blob/master/hypyp/stats.py) — Statistics (permutations & cluster statistics) (Florence, Guillaume)

🧠 [viz.py](https://github.com/GHFC/HyPyP/blob/master/hypyp/viz.py) — Inter-brain visualization (Anaël, Amir, Florence, Guillaume)

🎓 [Tutorials](https://github.com/GHFC/HyPyP/tree/master/tutorial) - Examples & documentation (Anaël, Florence, Yann, Guillaume)

## Roadmap

:warning: This is an alpha version and thus should be used with caution. While we have done our best to test all the functionalities, there is no guarantee that the pipeline is entirely bug-free. See Roadmap below for functionalities that will be implemented in the futur.

### Alpha [Spring 2020]

First public version with a basic demonstration of the pipeline.

Availabel functionalities:

[TABLE]

### Beta [Summer 2020]

Updated version with those functionalities:

[TABLE]

### Release [Fall/Winter 2020]

Full stable version, including functionalities:

[TABLE]
