
with Ada.Containers.Vectors;
with Ada.Exceptions;
with Ada.Unchecked_Deallocation;

with Langkit_Support.Diagnostics; use Langkit_Support.Diagnostics;
with Langkit_Support.Packrat;
with Langkit_Support.Slocs;       use Langkit_Support.Slocs;

pragma Warnings (Off, "referenced");
with Langkit_Support.Symbols; use Langkit_Support.Symbols;
pragma Warnings (On, "referenced");

with Langkit_Support.Text;        use Langkit_Support.Text;

with Librflxlang.Common;         use Librflxlang.Common;
with Librflxlang.Implementation; use Librflxlang.Implementation;
use Librflxlang.Implementation.Precomputed_Symbols;

pragma Warnings (Off, "referenced");
with Librflxlang.Private_Converters; use Librflxlang.Private_Converters;
pragma Warnings (On, "referenced");



package body Librflxlang.Parsers is
   pragma Warnings (Off, "use clause");
   use all type Langkit_Support.Symbols.Symbol_Type;
   pragma Warnings (On, "use clause");

   --  Prepare packrat instantiations: one per enum type and onefor each kind
   --  of node (including lists). Likewise for bump ptr. allocators, except
   --  we need them only for non-abstract AST nodes.

   pragma Warnings (Off, "is not referenced");
      package Bare_R_F_L_X_Node_Memos is new Langkit_Support.Packrat
        (Bare_R_F_L_X_Node, Token_Index);

      package Bare_Abstract_I_D_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_I_D, Token_Index);

      package Bare_I_D_Memos is new Langkit_Support.Packrat
        (Bare_I_D, Token_Index);

         
         subtype Subtype_For_I_D is
            Root_Node_Record (Rflx_I_D);
         type Access_To_Subtype_For_I_D is access all Subtype_For_I_D;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_I_D);
         package Bare_I_D_Alloc is new Alloc
           (Subtype_For_I_D, Access_To_Subtype_For_I_D);

         function Allocate_I_D
           (Pool : Bump_Ptr_Pool) return Bare_I_D;

         function Allocate_I_D
           (Pool : Bump_Ptr_Pool) return Bare_I_D
         is
            Result      : constant Access_To_Subtype_For_I_D := Bare_I_D_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_I_D;
            return Bare_I_D (Result);
         end Allocate_I_D;

      package Bare_Unqualified_I_D_Memos is new Langkit_Support.Packrat
        (Bare_Unqualified_I_D, Token_Index);

         
         subtype Subtype_For_Unqualified_I_D is
            Root_Node_Record (Rflx_Unqualified_I_D);
         type Access_To_Subtype_For_Unqualified_I_D is access all Subtype_For_Unqualified_I_D;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Unqualified_I_D);
         package Bare_Unqualified_I_D_Alloc is new Alloc
           (Subtype_For_Unqualified_I_D, Access_To_Subtype_For_Unqualified_I_D);

         function Allocate_Unqualified_I_D
           (Pool : Bump_Ptr_Pool) return Bare_Unqualified_I_D;

         function Allocate_Unqualified_I_D
           (Pool : Bump_Ptr_Pool) return Bare_Unqualified_I_D
         is
            Result      : constant Access_To_Subtype_For_Unqualified_I_D := Bare_Unqualified_I_D_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Unqualified_I_D;
            return Bare_Unqualified_I_D (Result);
         end Allocate_Unqualified_I_D;

      package Bare_Aspect_Memos is new Langkit_Support.Packrat
        (Bare_Aspect, Token_Index);

         
         subtype Subtype_For_Aspect is
            Root_Node_Record (Rflx_Aspect);
         type Access_To_Subtype_For_Aspect is access all Subtype_For_Aspect;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Aspect);
         package Bare_Aspect_Alloc is new Alloc
           (Subtype_For_Aspect, Access_To_Subtype_For_Aspect);

         function Allocate_Aspect
           (Pool : Bump_Ptr_Pool) return Bare_Aspect;

         function Allocate_Aspect
           (Pool : Bump_Ptr_Pool) return Bare_Aspect
         is
            Result      : constant Access_To_Subtype_For_Aspect := Bare_Aspect_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Aspect;
            return Bare_Aspect (Result);
         end Allocate_Aspect;

      package Bare_Attr_Memos is new Langkit_Support.Packrat
        (Bare_Attr, Token_Index);

      package Bare_Attr_First_Memos is new Langkit_Support.Packrat
        (Bare_Attr_First, Token_Index);

         
         subtype Subtype_For_Attr_First is
            Root_Node_Record (Rflx_Attr_First);
         type Access_To_Subtype_For_Attr_First is access all Subtype_For_Attr_First;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_First);
         package Bare_Attr_First_Alloc is new Alloc
           (Subtype_For_Attr_First, Access_To_Subtype_For_Attr_First);

         function Allocate_Attr_First
           (Pool : Bump_Ptr_Pool) return Bare_Attr_First;

         function Allocate_Attr_First
           (Pool : Bump_Ptr_Pool) return Bare_Attr_First
         is
            Result      : constant Access_To_Subtype_For_Attr_First := Bare_Attr_First_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_First;
            return Bare_Attr_First (Result);
         end Allocate_Attr_First;

      package Bare_Attr_Has_Data_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Has_Data, Token_Index);

         
         subtype Subtype_For_Attr_Has_Data is
            Root_Node_Record (Rflx_Attr_Has_Data);
         type Access_To_Subtype_For_Attr_Has_Data is access all Subtype_For_Attr_Has_Data;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_Has_Data);
         package Bare_Attr_Has_Data_Alloc is new Alloc
           (Subtype_For_Attr_Has_Data, Access_To_Subtype_For_Attr_Has_Data);

         function Allocate_Attr_Has_Data
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Has_Data;

         function Allocate_Attr_Has_Data
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Has_Data
         is
            Result      : constant Access_To_Subtype_For_Attr_Has_Data := Bare_Attr_Has_Data_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_Has_Data;
            return Bare_Attr_Has_Data (Result);
         end Allocate_Attr_Has_Data;

      package Bare_Attr_Head_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Head, Token_Index);

         
         subtype Subtype_For_Attr_Head is
            Root_Node_Record (Rflx_Attr_Head);
         type Access_To_Subtype_For_Attr_Head is access all Subtype_For_Attr_Head;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_Head);
         package Bare_Attr_Head_Alloc is new Alloc
           (Subtype_For_Attr_Head, Access_To_Subtype_For_Attr_Head);

         function Allocate_Attr_Head
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Head;

         function Allocate_Attr_Head
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Head
         is
            Result      : constant Access_To_Subtype_For_Attr_Head := Bare_Attr_Head_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_Head;
            return Bare_Attr_Head (Result);
         end Allocate_Attr_Head;

      package Bare_Attr_Last_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Last, Token_Index);

         
         subtype Subtype_For_Attr_Last is
            Root_Node_Record (Rflx_Attr_Last);
         type Access_To_Subtype_For_Attr_Last is access all Subtype_For_Attr_Last;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_Last);
         package Bare_Attr_Last_Alloc is new Alloc
           (Subtype_For_Attr_Last, Access_To_Subtype_For_Attr_Last);

         function Allocate_Attr_Last
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Last;

         function Allocate_Attr_Last
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Last
         is
            Result      : constant Access_To_Subtype_For_Attr_Last := Bare_Attr_Last_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_Last;
            return Bare_Attr_Last (Result);
         end Allocate_Attr_Last;

      package Bare_Attr_Opaque_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Opaque, Token_Index);

         
         subtype Subtype_For_Attr_Opaque is
            Root_Node_Record (Rflx_Attr_Opaque);
         type Access_To_Subtype_For_Attr_Opaque is access all Subtype_For_Attr_Opaque;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_Opaque);
         package Bare_Attr_Opaque_Alloc is new Alloc
           (Subtype_For_Attr_Opaque, Access_To_Subtype_For_Attr_Opaque);

         function Allocate_Attr_Opaque
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Opaque;

         function Allocate_Attr_Opaque
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Opaque
         is
            Result      : constant Access_To_Subtype_For_Attr_Opaque := Bare_Attr_Opaque_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_Opaque;
            return Bare_Attr_Opaque (Result);
         end Allocate_Attr_Opaque;

      package Bare_Attr_Present_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Present, Token_Index);

         
         subtype Subtype_For_Attr_Present is
            Root_Node_Record (Rflx_Attr_Present);
         type Access_To_Subtype_For_Attr_Present is access all Subtype_For_Attr_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_Present);
         package Bare_Attr_Present_Alloc is new Alloc
           (Subtype_For_Attr_Present, Access_To_Subtype_For_Attr_Present);

         function Allocate_Attr_Present
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Present;

         function Allocate_Attr_Present
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Present
         is
            Result      : constant Access_To_Subtype_For_Attr_Present := Bare_Attr_Present_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_Present;
            return Bare_Attr_Present (Result);
         end Allocate_Attr_Present;

      package Bare_Attr_Size_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Size, Token_Index);

         
         subtype Subtype_For_Attr_Size is
            Root_Node_Record (Rflx_Attr_Size);
         type Access_To_Subtype_For_Attr_Size is access all Subtype_For_Attr_Size;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_Size);
         package Bare_Attr_Size_Alloc is new Alloc
           (Subtype_For_Attr_Size, Access_To_Subtype_For_Attr_Size);

         function Allocate_Attr_Size
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Size;

         function Allocate_Attr_Size
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Size
         is
            Result      : constant Access_To_Subtype_For_Attr_Size := Bare_Attr_Size_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_Size;
            return Bare_Attr_Size (Result);
         end Allocate_Attr_Size;

      package Bare_Attr_Valid_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Valid, Token_Index);

         
         subtype Subtype_For_Attr_Valid is
            Root_Node_Record (Rflx_Attr_Valid);
         type Access_To_Subtype_For_Attr_Valid is access all Subtype_For_Attr_Valid;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_Valid);
         package Bare_Attr_Valid_Alloc is new Alloc
           (Subtype_For_Attr_Valid, Access_To_Subtype_For_Attr_Valid);

         function Allocate_Attr_Valid
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Valid;

         function Allocate_Attr_Valid
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Valid
         is
            Result      : constant Access_To_Subtype_For_Attr_Valid := Bare_Attr_Valid_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_Valid;
            return Bare_Attr_Valid (Result);
         end Allocate_Attr_Valid;

      package Bare_Attr_Valid_Checksum_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Valid_Checksum, Token_Index);

         
         subtype Subtype_For_Attr_Valid_Checksum is
            Root_Node_Record (Rflx_Attr_Valid_Checksum);
         type Access_To_Subtype_For_Attr_Valid_Checksum is access all Subtype_For_Attr_Valid_Checksum;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_Valid_Checksum);
         package Bare_Attr_Valid_Checksum_Alloc is new Alloc
           (Subtype_For_Attr_Valid_Checksum, Access_To_Subtype_For_Attr_Valid_Checksum);

         function Allocate_Attr_Valid_Checksum
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Valid_Checksum;

         function Allocate_Attr_Valid_Checksum
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Valid_Checksum
         is
            Result      : constant Access_To_Subtype_For_Attr_Valid_Checksum := Bare_Attr_Valid_Checksum_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_Valid_Checksum;
            return Bare_Attr_Valid_Checksum (Result);
         end Allocate_Attr_Valid_Checksum;

      package Bare_Attr_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Stmt, Token_Index);

      package Bare_Attr_Stmt_Append_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Stmt_Append, Token_Index);

         
         subtype Subtype_For_Attr_Stmt_Append is
            Root_Node_Record (Rflx_Attr_Stmt_Append);
         type Access_To_Subtype_For_Attr_Stmt_Append is access all Subtype_For_Attr_Stmt_Append;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_Stmt_Append);
         package Bare_Attr_Stmt_Append_Alloc is new Alloc
           (Subtype_For_Attr_Stmt_Append, Access_To_Subtype_For_Attr_Stmt_Append);

         function Allocate_Attr_Stmt_Append
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Append;

         function Allocate_Attr_Stmt_Append
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Append
         is
            Result      : constant Access_To_Subtype_For_Attr_Stmt_Append := Bare_Attr_Stmt_Append_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_Stmt_Append;
            return Bare_Attr_Stmt_Append (Result);
         end Allocate_Attr_Stmt_Append;

      package Bare_Attr_Stmt_Extend_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Stmt_Extend, Token_Index);

         
         subtype Subtype_For_Attr_Stmt_Extend is
            Root_Node_Record (Rflx_Attr_Stmt_Extend);
         type Access_To_Subtype_For_Attr_Stmt_Extend is access all Subtype_For_Attr_Stmt_Extend;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_Stmt_Extend);
         package Bare_Attr_Stmt_Extend_Alloc is new Alloc
           (Subtype_For_Attr_Stmt_Extend, Access_To_Subtype_For_Attr_Stmt_Extend);

         function Allocate_Attr_Stmt_Extend
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Extend;

         function Allocate_Attr_Stmt_Extend
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Extend
         is
            Result      : constant Access_To_Subtype_For_Attr_Stmt_Extend := Bare_Attr_Stmt_Extend_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_Stmt_Extend;
            return Bare_Attr_Stmt_Extend (Result);
         end Allocate_Attr_Stmt_Extend;

      package Bare_Attr_Stmt_Read_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Stmt_Read, Token_Index);

         
         subtype Subtype_For_Attr_Stmt_Read is
            Root_Node_Record (Rflx_Attr_Stmt_Read);
         type Access_To_Subtype_For_Attr_Stmt_Read is access all Subtype_For_Attr_Stmt_Read;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_Stmt_Read);
         package Bare_Attr_Stmt_Read_Alloc is new Alloc
           (Subtype_For_Attr_Stmt_Read, Access_To_Subtype_For_Attr_Stmt_Read);

         function Allocate_Attr_Stmt_Read
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Read;

         function Allocate_Attr_Stmt_Read
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Read
         is
            Result      : constant Access_To_Subtype_For_Attr_Stmt_Read := Bare_Attr_Stmt_Read_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_Stmt_Read;
            return Bare_Attr_Stmt_Read (Result);
         end Allocate_Attr_Stmt_Read;

      package Bare_Attr_Stmt_Write_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Stmt_Write, Token_Index);

         
         subtype Subtype_For_Attr_Stmt_Write is
            Root_Node_Record (Rflx_Attr_Stmt_Write);
         type Access_To_Subtype_For_Attr_Stmt_Write is access all Subtype_For_Attr_Stmt_Write;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attr_Stmt_Write);
         package Bare_Attr_Stmt_Write_Alloc is new Alloc
           (Subtype_For_Attr_Stmt_Write, Access_To_Subtype_For_Attr_Stmt_Write);

         function Allocate_Attr_Stmt_Write
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Write;

         function Allocate_Attr_Stmt_Write
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Write
         is
            Result      : constant Access_To_Subtype_For_Attr_Stmt_Write := Bare_Attr_Stmt_Write_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attr_Stmt_Write;
            return Bare_Attr_Stmt_Write (Result);
         end Allocate_Attr_Stmt_Write;

      package Bare_Base_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Base_Aggregate, Token_Index);

      package Bare_Message_Aggregate_Associations_Memos is new Langkit_Support.Packrat
        (Bare_Message_Aggregate_Associations, Token_Index);

         
         subtype Subtype_For_Message_Aggregate_Associations is
            Root_Node_Record (Rflx_Message_Aggregate_Associations);
         type Access_To_Subtype_For_Message_Aggregate_Associations is access all Subtype_For_Message_Aggregate_Associations;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Message_Aggregate_Associations);
         package Bare_Message_Aggregate_Associations_Alloc is new Alloc
           (Subtype_For_Message_Aggregate_Associations, Access_To_Subtype_For_Message_Aggregate_Associations);

         function Allocate_Message_Aggregate_Associations
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate_Associations;

         function Allocate_Message_Aggregate_Associations
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate_Associations
         is
            Result      : constant Access_To_Subtype_For_Message_Aggregate_Associations := Bare_Message_Aggregate_Associations_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Message_Aggregate_Associations;
            return Bare_Message_Aggregate_Associations (Result);
         end Allocate_Message_Aggregate_Associations;

      package Bare_Null_Message_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Null_Message_Aggregate, Token_Index);

         
         subtype Subtype_For_Null_Message_Aggregate is
            Root_Node_Record (Rflx_Null_Message_Aggregate);
         type Access_To_Subtype_For_Null_Message_Aggregate is access all Subtype_For_Null_Message_Aggregate;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Message_Aggregate);
         package Bare_Null_Message_Aggregate_Alloc is new Alloc
           (Subtype_For_Null_Message_Aggregate, Access_To_Subtype_For_Null_Message_Aggregate);

         function Allocate_Null_Message_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Null_Message_Aggregate;

         function Allocate_Null_Message_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Null_Message_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Null_Message_Aggregate := Bare_Null_Message_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Null_Message_Aggregate;
            return Bare_Null_Message_Aggregate (Result);
         end Allocate_Null_Message_Aggregate;

      package Bare_Base_Checksum_Val_Memos is new Langkit_Support.Packrat
        (Bare_Base_Checksum_Val, Token_Index);

      package Bare_Checksum_Val_Memos is new Langkit_Support.Packrat
        (Bare_Checksum_Val, Token_Index);

         
         subtype Subtype_For_Checksum_Val is
            Root_Node_Record (Rflx_Checksum_Val);
         type Access_To_Subtype_For_Checksum_Val is access all Subtype_For_Checksum_Val;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Checksum_Val);
         package Bare_Checksum_Val_Alloc is new Alloc
           (Subtype_For_Checksum_Val, Access_To_Subtype_For_Checksum_Val);

         function Allocate_Checksum_Val
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Val;

         function Allocate_Checksum_Val
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Val
         is
            Result      : constant Access_To_Subtype_For_Checksum_Val := Bare_Checksum_Val_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Checksum_Val;
            return Bare_Checksum_Val (Result);
         end Allocate_Checksum_Val;

      package Bare_Checksum_Value_Range_Memos is new Langkit_Support.Packrat
        (Bare_Checksum_Value_Range, Token_Index);

         
         subtype Subtype_For_Checksum_Value_Range is
            Root_Node_Record (Rflx_Checksum_Value_Range);
         type Access_To_Subtype_For_Checksum_Value_Range is access all Subtype_For_Checksum_Value_Range;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Checksum_Value_Range);
         package Bare_Checksum_Value_Range_Alloc is new Alloc
           (Subtype_For_Checksum_Value_Range, Access_To_Subtype_For_Checksum_Value_Range);

         function Allocate_Checksum_Value_Range
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Value_Range;

         function Allocate_Checksum_Value_Range
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Value_Range
         is
            Result      : constant Access_To_Subtype_For_Checksum_Value_Range := Bare_Checksum_Value_Range_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Checksum_Value_Range;
            return Bare_Checksum_Value_Range (Result);
         end Allocate_Checksum_Value_Range;

      package Bare_Byte_Order_Type_Memos is new Langkit_Support.Packrat
        (Bare_Byte_Order_Type, Token_Index);

      package Bare_Byte_Order_Type_Highorderfirst_Memos is new Langkit_Support.Packrat
        (Bare_Byte_Order_Type_Highorderfirst, Token_Index);

         
         subtype Subtype_For_Byte_Order_Type_Highorderfirst is
            Root_Node_Record (Rflx_Byte_Order_Type_Highorderfirst);
         type Access_To_Subtype_For_Byte_Order_Type_Highorderfirst is access all Subtype_For_Byte_Order_Type_Highorderfirst;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Byte_Order_Type_Highorderfirst);
         package Bare_Byte_Order_Type_Highorderfirst_Alloc is new Alloc
           (Subtype_For_Byte_Order_Type_Highorderfirst, Access_To_Subtype_For_Byte_Order_Type_Highorderfirst);

         function Allocate_Byte_Order_Type_Highorderfirst
           (Pool : Bump_Ptr_Pool) return Bare_Byte_Order_Type_Highorderfirst;

         function Allocate_Byte_Order_Type_Highorderfirst
           (Pool : Bump_Ptr_Pool) return Bare_Byte_Order_Type_Highorderfirst
         is
            Result      : constant Access_To_Subtype_For_Byte_Order_Type_Highorderfirst := Bare_Byte_Order_Type_Highorderfirst_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Byte_Order_Type_Highorderfirst;
            return Bare_Byte_Order_Type_Highorderfirst (Result);
         end Allocate_Byte_Order_Type_Highorderfirst;

      package Bare_Byte_Order_Type_Loworderfirst_Memos is new Langkit_Support.Packrat
        (Bare_Byte_Order_Type_Loworderfirst, Token_Index);

         
         subtype Subtype_For_Byte_Order_Type_Loworderfirst is
            Root_Node_Record (Rflx_Byte_Order_Type_Loworderfirst);
         type Access_To_Subtype_For_Byte_Order_Type_Loworderfirst is access all Subtype_For_Byte_Order_Type_Loworderfirst;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Byte_Order_Type_Loworderfirst);
         package Bare_Byte_Order_Type_Loworderfirst_Alloc is new Alloc
           (Subtype_For_Byte_Order_Type_Loworderfirst, Access_To_Subtype_For_Byte_Order_Type_Loworderfirst);

         function Allocate_Byte_Order_Type_Loworderfirst
           (Pool : Bump_Ptr_Pool) return Bare_Byte_Order_Type_Loworderfirst;

         function Allocate_Byte_Order_Type_Loworderfirst
           (Pool : Bump_Ptr_Pool) return Bare_Byte_Order_Type_Loworderfirst
         is
            Result      : constant Access_To_Subtype_For_Byte_Order_Type_Loworderfirst := Bare_Byte_Order_Type_Loworderfirst_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Byte_Order_Type_Loworderfirst;
            return Bare_Byte_Order_Type_Loworderfirst (Result);
         end Allocate_Byte_Order_Type_Loworderfirst;

      package Bare_Channel_Attribute_Memos is new Langkit_Support.Packrat
        (Bare_Channel_Attribute, Token_Index);

      package Bare_Readable_Memos is new Langkit_Support.Packrat
        (Bare_Readable, Token_Index);

         
         subtype Subtype_For_Readable is
            Root_Node_Record (Rflx_Readable);
         type Access_To_Subtype_For_Readable is access all Subtype_For_Readable;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Readable);
         package Bare_Readable_Alloc is new Alloc
           (Subtype_For_Readable, Access_To_Subtype_For_Readable);

         function Allocate_Readable
           (Pool : Bump_Ptr_Pool) return Bare_Readable;

         function Allocate_Readable
           (Pool : Bump_Ptr_Pool) return Bare_Readable
         is
            Result      : constant Access_To_Subtype_For_Readable := Bare_Readable_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Readable;
            return Bare_Readable (Result);
         end Allocate_Readable;

      package Bare_Writable_Memos is new Langkit_Support.Packrat
        (Bare_Writable, Token_Index);

         
         subtype Subtype_For_Writable is
            Root_Node_Record (Rflx_Writable);
         type Access_To_Subtype_For_Writable is access all Subtype_For_Writable;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Writable);
         package Bare_Writable_Alloc is new Alloc
           (Subtype_For_Writable, Access_To_Subtype_For_Writable);

         function Allocate_Writable
           (Pool : Bump_Ptr_Pool) return Bare_Writable;

         function Allocate_Writable
           (Pool : Bump_Ptr_Pool) return Bare_Writable
         is
            Result      : constant Access_To_Subtype_For_Writable := Bare_Writable_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Writable;
            return Bare_Writable (Result);
         end Allocate_Writable;

      package Bare_Checksum_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Checksum_Assoc, Token_Index);

         
         subtype Subtype_For_Checksum_Assoc is
            Root_Node_Record (Rflx_Checksum_Assoc);
         type Access_To_Subtype_For_Checksum_Assoc is access all Subtype_For_Checksum_Assoc;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Checksum_Assoc);
         package Bare_Checksum_Assoc_Alloc is new Alloc
           (Subtype_For_Checksum_Assoc, Access_To_Subtype_For_Checksum_Assoc);

         function Allocate_Checksum_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Assoc;

         function Allocate_Checksum_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Assoc
         is
            Result      : constant Access_To_Subtype_For_Checksum_Assoc := Bare_Checksum_Assoc_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Checksum_Assoc;
            return Bare_Checksum_Assoc (Result);
         end Allocate_Checksum_Assoc;

      package Bare_Declaration_Memos is new Langkit_Support.Packrat
        (Bare_Declaration, Token_Index);

      package Bare_Refinement_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Refinement_Decl, Token_Index);

         
         subtype Subtype_For_Refinement_Decl is
            Root_Node_Record (Rflx_Refinement_Decl);
         type Access_To_Subtype_For_Refinement_Decl is access all Subtype_For_Refinement_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Refinement_Decl);
         package Bare_Refinement_Decl_Alloc is new Alloc
           (Subtype_For_Refinement_Decl, Access_To_Subtype_For_Refinement_Decl);

         function Allocate_Refinement_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Refinement_Decl;

         function Allocate_Refinement_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Refinement_Decl
         is
            Result      : constant Access_To_Subtype_For_Refinement_Decl := Bare_Refinement_Decl_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Refinement_Decl;
            return Bare_Refinement_Decl (Result);
         end Allocate_Refinement_Decl;

      package Bare_Session_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Session_Decl, Token_Index);

         
         subtype Subtype_For_Session_Decl is
            Root_Node_Record (Rflx_Session_Decl);
         type Access_To_Subtype_For_Session_Decl is access all Subtype_For_Session_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Session_Decl);
         package Bare_Session_Decl_Alloc is new Alloc
           (Subtype_For_Session_Decl, Access_To_Subtype_For_Session_Decl);

         function Allocate_Session_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Session_Decl;

         function Allocate_Session_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Session_Decl
         is
            Result      : constant Access_To_Subtype_For_Session_Decl := Bare_Session_Decl_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Session_Decl;
            return Bare_Session_Decl (Result);
         end Allocate_Session_Decl;

      package Bare_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Type_Decl, Token_Index);

         
         subtype Subtype_For_Type_Decl is
            Root_Node_Record (Rflx_Type_Decl);
         type Access_To_Subtype_For_Type_Decl is access all Subtype_For_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Type_Decl);
         package Bare_Type_Decl_Alloc is new Alloc
           (Subtype_For_Type_Decl, Access_To_Subtype_For_Type_Decl);

         function Allocate_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Type_Decl;

         function Allocate_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Type_Decl := Bare_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Type_Decl;
            return Bare_Type_Decl (Result);
         end Allocate_Type_Decl;

      package Bare_Description_Memos is new Langkit_Support.Packrat
        (Bare_Description, Token_Index);

         
         subtype Subtype_For_Description is
            Root_Node_Record (Rflx_Description);
         type Access_To_Subtype_For_Description is access all Subtype_For_Description;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Description);
         package Bare_Description_Alloc is new Alloc
           (Subtype_For_Description, Access_To_Subtype_For_Description);

         function Allocate_Description
           (Pool : Bump_Ptr_Pool) return Bare_Description;

         function Allocate_Description
           (Pool : Bump_Ptr_Pool) return Bare_Description
         is
            Result      : constant Access_To_Subtype_For_Description := Bare_Description_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Description;
            return Bare_Description (Result);
         end Allocate_Description;

      package Bare_Element_Value_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Element_Value_Assoc, Token_Index);

         
         subtype Subtype_For_Element_Value_Assoc is
            Root_Node_Record (Rflx_Element_Value_Assoc);
         type Access_To_Subtype_For_Element_Value_Assoc is access all Subtype_For_Element_Value_Assoc;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Element_Value_Assoc);
         package Bare_Element_Value_Assoc_Alloc is new Alloc
           (Subtype_For_Element_Value_Assoc, Access_To_Subtype_For_Element_Value_Assoc);

         function Allocate_Element_Value_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Element_Value_Assoc;

         function Allocate_Element_Value_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Element_Value_Assoc
         is
            Result      : constant Access_To_Subtype_For_Element_Value_Assoc := Bare_Element_Value_Assoc_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Element_Value_Assoc;
            return Bare_Element_Value_Assoc (Result);
         end Allocate_Element_Value_Assoc;

      package Bare_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Expr, Token_Index);

      package Bare_Attribute_Memos is new Langkit_Support.Packrat
        (Bare_Attribute, Token_Index);

         
         subtype Subtype_For_Attribute is
            Root_Node_Record (Rflx_Attribute);
         type Access_To_Subtype_For_Attribute is access all Subtype_For_Attribute;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attribute);
         package Bare_Attribute_Alloc is new Alloc
           (Subtype_For_Attribute, Access_To_Subtype_For_Attribute);

         function Allocate_Attribute
           (Pool : Bump_Ptr_Pool) return Bare_Attribute;

         function Allocate_Attribute
           (Pool : Bump_Ptr_Pool) return Bare_Attribute
         is
            Result      : constant Access_To_Subtype_For_Attribute := Bare_Attribute_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attribute;
            return Bare_Attribute (Result);
         end Allocate_Attribute;

      package Bare_Bin_Op_Memos is new Langkit_Support.Packrat
        (Bare_Bin_Op, Token_Index);

         
         subtype Subtype_For_Bin_Op is
            Root_Node_Record (Rflx_Bin_Op);
         type Access_To_Subtype_For_Bin_Op is access all Subtype_For_Bin_Op;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Bin_Op);
         package Bare_Bin_Op_Alloc is new Alloc
           (Subtype_For_Bin_Op, Access_To_Subtype_For_Bin_Op);

         function Allocate_Bin_Op
           (Pool : Bump_Ptr_Pool) return Bare_Bin_Op;

         function Allocate_Bin_Op
           (Pool : Bump_Ptr_Pool) return Bare_Bin_Op
         is
            Result      : constant Access_To_Subtype_For_Bin_Op := Bare_Bin_Op_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Bin_Op;
            return Bare_Bin_Op (Result);
         end Allocate_Bin_Op;

      package Bare_Binding_Memos is new Langkit_Support.Packrat
        (Bare_Binding, Token_Index);

         
         subtype Subtype_For_Binding is
            Root_Node_Record (Rflx_Binding);
         type Access_To_Subtype_For_Binding is access all Subtype_For_Binding;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Binding);
         package Bare_Binding_Alloc is new Alloc
           (Subtype_For_Binding, Access_To_Subtype_For_Binding);

         function Allocate_Binding
           (Pool : Bump_Ptr_Pool) return Bare_Binding;

         function Allocate_Binding
           (Pool : Bump_Ptr_Pool) return Bare_Binding
         is
            Result      : constant Access_To_Subtype_For_Binding := Bare_Binding_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Binding;
            return Bare_Binding (Result);
         end Allocate_Binding;

      package Bare_Call_Memos is new Langkit_Support.Packrat
        (Bare_Call, Token_Index);

         
         subtype Subtype_For_Call is
            Root_Node_Record (Rflx_Call);
         type Access_To_Subtype_For_Call is access all Subtype_For_Call;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Call);
         package Bare_Call_Alloc is new Alloc
           (Subtype_For_Call, Access_To_Subtype_For_Call);

         function Allocate_Call
           (Pool : Bump_Ptr_Pool) return Bare_Call;

         function Allocate_Call
           (Pool : Bump_Ptr_Pool) return Bare_Call
         is
            Result      : constant Access_To_Subtype_For_Call := Bare_Call_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Call;
            return Bare_Call (Result);
         end Allocate_Call;

      package Bare_Case_Expression_Memos is new Langkit_Support.Packrat
        (Bare_Case_Expression, Token_Index);

         
         subtype Subtype_For_Case_Expression is
            Root_Node_Record (Rflx_Case_Expression);
         type Access_To_Subtype_For_Case_Expression is access all Subtype_For_Case_Expression;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Case_Expression);
         package Bare_Case_Expression_Alloc is new Alloc
           (Subtype_For_Case_Expression, Access_To_Subtype_For_Case_Expression);

         function Allocate_Case_Expression
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expression;

         function Allocate_Case_Expression
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expression
         is
            Result      : constant Access_To_Subtype_For_Case_Expression := Bare_Case_Expression_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Case_Expression;
            return Bare_Case_Expression (Result);
         end Allocate_Case_Expression;

      package Bare_Choice_Memos is new Langkit_Support.Packrat
        (Bare_Choice, Token_Index);

         
         subtype Subtype_For_Choice is
            Root_Node_Record (Rflx_Choice);
         type Access_To_Subtype_For_Choice is access all Subtype_For_Choice;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Choice);
         package Bare_Choice_Alloc is new Alloc
           (Subtype_For_Choice, Access_To_Subtype_For_Choice);

         function Allocate_Choice
           (Pool : Bump_Ptr_Pool) return Bare_Choice;

         function Allocate_Choice
           (Pool : Bump_Ptr_Pool) return Bare_Choice
         is
            Result      : constant Access_To_Subtype_For_Choice := Bare_Choice_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Choice;
            return Bare_Choice (Result);
         end Allocate_Choice;

      package Bare_Comprehension_Memos is new Langkit_Support.Packrat
        (Bare_Comprehension, Token_Index);

         
         subtype Subtype_For_Comprehension is
            Root_Node_Record (Rflx_Comprehension);
         type Access_To_Subtype_For_Comprehension is access all Subtype_For_Comprehension;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Comprehension);
         package Bare_Comprehension_Alloc is new Alloc
           (Subtype_For_Comprehension, Access_To_Subtype_For_Comprehension);

         function Allocate_Comprehension
           (Pool : Bump_Ptr_Pool) return Bare_Comprehension;

         function Allocate_Comprehension
           (Pool : Bump_Ptr_Pool) return Bare_Comprehension
         is
            Result      : constant Access_To_Subtype_For_Comprehension := Bare_Comprehension_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Comprehension;
            return Bare_Comprehension (Result);
         end Allocate_Comprehension;

      package Bare_Context_Item_Memos is new Langkit_Support.Packrat
        (Bare_Context_Item, Token_Index);

         
         subtype Subtype_For_Context_Item is
            Root_Node_Record (Rflx_Context_Item);
         type Access_To_Subtype_For_Context_Item is access all Subtype_For_Context_Item;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Context_Item);
         package Bare_Context_Item_Alloc is new Alloc
           (Subtype_For_Context_Item, Access_To_Subtype_For_Context_Item);

         function Allocate_Context_Item
           (Pool : Bump_Ptr_Pool) return Bare_Context_Item;

         function Allocate_Context_Item
           (Pool : Bump_Ptr_Pool) return Bare_Context_Item
         is
            Result      : constant Access_To_Subtype_For_Context_Item := Bare_Context_Item_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Context_Item;
            return Bare_Context_Item (Result);
         end Allocate_Context_Item;

      package Bare_Conversion_Memos is new Langkit_Support.Packrat
        (Bare_Conversion, Token_Index);

         
         subtype Subtype_For_Conversion is
            Root_Node_Record (Rflx_Conversion);
         type Access_To_Subtype_For_Conversion is access all Subtype_For_Conversion;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Conversion);
         package Bare_Conversion_Alloc is new Alloc
           (Subtype_For_Conversion, Access_To_Subtype_For_Conversion);

         function Allocate_Conversion
           (Pool : Bump_Ptr_Pool) return Bare_Conversion;

         function Allocate_Conversion
           (Pool : Bump_Ptr_Pool) return Bare_Conversion
         is
            Result      : constant Access_To_Subtype_For_Conversion := Bare_Conversion_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Conversion;
            return Bare_Conversion (Result);
         end Allocate_Conversion;

      package Bare_Message_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Message_Aggregate, Token_Index);

         
         subtype Subtype_For_Message_Aggregate is
            Root_Node_Record (Rflx_Message_Aggregate);
         type Access_To_Subtype_For_Message_Aggregate is access all Subtype_For_Message_Aggregate;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Message_Aggregate);
         package Bare_Message_Aggregate_Alloc is new Alloc
           (Subtype_For_Message_Aggregate, Access_To_Subtype_For_Message_Aggregate);

         function Allocate_Message_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate;

         function Allocate_Message_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Message_Aggregate := Bare_Message_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Message_Aggregate;
            return Bare_Message_Aggregate (Result);
         end Allocate_Message_Aggregate;

      package Bare_Negation_Memos is new Langkit_Support.Packrat
        (Bare_Negation, Token_Index);

         
         subtype Subtype_For_Negation is
            Root_Node_Record (Rflx_Negation);
         type Access_To_Subtype_For_Negation is access all Subtype_For_Negation;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Negation);
         package Bare_Negation_Alloc is new Alloc
           (Subtype_For_Negation, Access_To_Subtype_For_Negation);

         function Allocate_Negation
           (Pool : Bump_Ptr_Pool) return Bare_Negation;

         function Allocate_Negation
           (Pool : Bump_Ptr_Pool) return Bare_Negation
         is
            Result      : constant Access_To_Subtype_For_Negation := Bare_Negation_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Negation;
            return Bare_Negation (Result);
         end Allocate_Negation;

      package Bare_Numeric_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Numeric_Literal, Token_Index);

         
         subtype Subtype_For_Numeric_Literal is
            Root_Node_Record (Rflx_Numeric_Literal);
         type Access_To_Subtype_For_Numeric_Literal is access all Subtype_For_Numeric_Literal;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Numeric_Literal);
         package Bare_Numeric_Literal_Alloc is new Alloc
           (Subtype_For_Numeric_Literal, Access_To_Subtype_For_Numeric_Literal);

         function Allocate_Numeric_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Numeric_Literal;

         function Allocate_Numeric_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Numeric_Literal
         is
            Result      : constant Access_To_Subtype_For_Numeric_Literal := Bare_Numeric_Literal_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Numeric_Literal;
            return Bare_Numeric_Literal (Result);
         end Allocate_Numeric_Literal;

      package Bare_Paren_Expression_Memos is new Langkit_Support.Packrat
        (Bare_Paren_Expression, Token_Index);

         
         subtype Subtype_For_Paren_Expression is
            Root_Node_Record (Rflx_Paren_Expression);
         type Access_To_Subtype_For_Paren_Expression is access all Subtype_For_Paren_Expression;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Paren_Expression);
         package Bare_Paren_Expression_Alloc is new Alloc
           (Subtype_For_Paren_Expression, Access_To_Subtype_For_Paren_Expression);

         function Allocate_Paren_Expression
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Expression;

         function Allocate_Paren_Expression
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Expression
         is
            Result      : constant Access_To_Subtype_For_Paren_Expression := Bare_Paren_Expression_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Paren_Expression;
            return Bare_Paren_Expression (Result);
         end Allocate_Paren_Expression;

      package Bare_Quantified_Expression_Memos is new Langkit_Support.Packrat
        (Bare_Quantified_Expression, Token_Index);

         
         subtype Subtype_For_Quantified_Expression is
            Root_Node_Record (Rflx_Quantified_Expression);
         type Access_To_Subtype_For_Quantified_Expression is access all Subtype_For_Quantified_Expression;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Quantified_Expression);
         package Bare_Quantified_Expression_Alloc is new Alloc
           (Subtype_For_Quantified_Expression, Access_To_Subtype_For_Quantified_Expression);

         function Allocate_Quantified_Expression
           (Pool : Bump_Ptr_Pool) return Bare_Quantified_Expression;

         function Allocate_Quantified_Expression
           (Pool : Bump_Ptr_Pool) return Bare_Quantified_Expression
         is
            Result      : constant Access_To_Subtype_For_Quantified_Expression := Bare_Quantified_Expression_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Quantified_Expression;
            return Bare_Quantified_Expression (Result);
         end Allocate_Quantified_Expression;

      package Bare_Select_Node_Memos is new Langkit_Support.Packrat
        (Bare_Select_Node, Token_Index);

         
         subtype Subtype_For_Select_Node is
            Root_Node_Record (Rflx_Select_Node);
         type Access_To_Subtype_For_Select_Node is access all Subtype_For_Select_Node;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Select_Node);
         package Bare_Select_Node_Alloc is new Alloc
           (Subtype_For_Select_Node, Access_To_Subtype_For_Select_Node);

         function Allocate_Select_Node
           (Pool : Bump_Ptr_Pool) return Bare_Select_Node;

         function Allocate_Select_Node
           (Pool : Bump_Ptr_Pool) return Bare_Select_Node
         is
            Result      : constant Access_To_Subtype_For_Select_Node := Bare_Select_Node_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Select_Node;
            return Bare_Select_Node (Result);
         end Allocate_Select_Node;

      package Bare_Sequence_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Sequence_Literal, Token_Index);

      package Bare_Concatenation_Memos is new Langkit_Support.Packrat
        (Bare_Concatenation, Token_Index);

         
         subtype Subtype_For_Concatenation is
            Root_Node_Record (Rflx_Concatenation);
         type Access_To_Subtype_For_Concatenation is access all Subtype_For_Concatenation;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Concatenation);
         package Bare_Concatenation_Alloc is new Alloc
           (Subtype_For_Concatenation, Access_To_Subtype_For_Concatenation);

         function Allocate_Concatenation
           (Pool : Bump_Ptr_Pool) return Bare_Concatenation;

         function Allocate_Concatenation
           (Pool : Bump_Ptr_Pool) return Bare_Concatenation
         is
            Result      : constant Access_To_Subtype_For_Concatenation := Bare_Concatenation_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Concatenation;
            return Bare_Concatenation (Result);
         end Allocate_Concatenation;

      package Bare_Sequence_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Sequence_Aggregate, Token_Index);

         
         subtype Subtype_For_Sequence_Aggregate is
            Root_Node_Record (Rflx_Sequence_Aggregate);
         type Access_To_Subtype_For_Sequence_Aggregate is access all Subtype_For_Sequence_Aggregate;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Sequence_Aggregate);
         package Bare_Sequence_Aggregate_Alloc is new Alloc
           (Subtype_For_Sequence_Aggregate, Access_To_Subtype_For_Sequence_Aggregate);

         function Allocate_Sequence_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Sequence_Aggregate;

         function Allocate_Sequence_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Sequence_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Sequence_Aggregate := Bare_Sequence_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Sequence_Aggregate;
            return Bare_Sequence_Aggregate (Result);
         end Allocate_Sequence_Aggregate;

      package Bare_String_Literal_Memos is new Langkit_Support.Packrat
        (Bare_String_Literal, Token_Index);

         
         subtype Subtype_For_String_Literal is
            Root_Node_Record (Rflx_String_Literal);
         type Access_To_Subtype_For_String_Literal is access all Subtype_For_String_Literal;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_String_Literal);
         package Bare_String_Literal_Alloc is new Alloc
           (Subtype_For_String_Literal, Access_To_Subtype_For_String_Literal);

         function Allocate_String_Literal
           (Pool : Bump_Ptr_Pool) return Bare_String_Literal;

         function Allocate_String_Literal
           (Pool : Bump_Ptr_Pool) return Bare_String_Literal
         is
            Result      : constant Access_To_Subtype_For_String_Literal := Bare_String_Literal_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_String_Literal;
            return Bare_String_Literal (Result);
         end Allocate_String_Literal;

      package Bare_Variable_Memos is new Langkit_Support.Packrat
        (Bare_Variable, Token_Index);

         
         subtype Subtype_For_Variable is
            Root_Node_Record (Rflx_Variable);
         type Access_To_Subtype_For_Variable is access all Subtype_For_Variable;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Variable);
         package Bare_Variable_Alloc is new Alloc
           (Subtype_For_Variable, Access_To_Subtype_For_Variable);

         function Allocate_Variable
           (Pool : Bump_Ptr_Pool) return Bare_Variable;

         function Allocate_Variable
           (Pool : Bump_Ptr_Pool) return Bare_Variable
         is
            Result      : constant Access_To_Subtype_For_Variable := Bare_Variable_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Variable;
            return Bare_Variable (Result);
         end Allocate_Variable;

      package Bare_Formal_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Decl, Token_Index);

      package Bare_Formal_Channel_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Channel_Decl, Token_Index);

         
         subtype Subtype_For_Formal_Channel_Decl is
            Root_Node_Record (Rflx_Formal_Channel_Decl);
         type Access_To_Subtype_For_Formal_Channel_Decl is access all Subtype_For_Formal_Channel_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Formal_Channel_Decl);
         package Bare_Formal_Channel_Decl_Alloc is new Alloc
           (Subtype_For_Formal_Channel_Decl, Access_To_Subtype_For_Formal_Channel_Decl);

         function Allocate_Formal_Channel_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Channel_Decl;

         function Allocate_Formal_Channel_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Channel_Decl
         is
            Result      : constant Access_To_Subtype_For_Formal_Channel_Decl := Bare_Formal_Channel_Decl_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Formal_Channel_Decl;
            return Bare_Formal_Channel_Decl (Result);
         end Allocate_Formal_Channel_Decl;

      package Bare_Formal_Function_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Function_Decl, Token_Index);

         
         subtype Subtype_For_Formal_Function_Decl is
            Root_Node_Record (Rflx_Formal_Function_Decl);
         type Access_To_Subtype_For_Formal_Function_Decl is access all Subtype_For_Formal_Function_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Formal_Function_Decl);
         package Bare_Formal_Function_Decl_Alloc is new Alloc
           (Subtype_For_Formal_Function_Decl, Access_To_Subtype_For_Formal_Function_Decl);

         function Allocate_Formal_Function_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Function_Decl;

         function Allocate_Formal_Function_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Function_Decl
         is
            Result      : constant Access_To_Subtype_For_Formal_Function_Decl := Bare_Formal_Function_Decl_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Formal_Function_Decl;
            return Bare_Formal_Function_Decl (Result);
         end Allocate_Formal_Function_Decl;

      package Bare_Local_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Local_Decl, Token_Index);

      package Bare_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Renaming_Decl, Token_Index);

         
         subtype Subtype_For_Renaming_Decl is
            Root_Node_Record (Rflx_Renaming_Decl);
         type Access_To_Subtype_For_Renaming_Decl is access all Subtype_For_Renaming_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Renaming_Decl);
         package Bare_Renaming_Decl_Alloc is new Alloc
           (Subtype_For_Renaming_Decl, Access_To_Subtype_For_Renaming_Decl);

         function Allocate_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Renaming_Decl;

         function Allocate_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Renaming_Decl
         is
            Result      : constant Access_To_Subtype_For_Renaming_Decl := Bare_Renaming_Decl_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Renaming_Decl;
            return Bare_Renaming_Decl (Result);
         end Allocate_Renaming_Decl;

      package Bare_Variable_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Variable_Decl, Token_Index);

         
         subtype Subtype_For_Variable_Decl is
            Root_Node_Record (Rflx_Variable_Decl);
         type Access_To_Subtype_For_Variable_Decl is access all Subtype_For_Variable_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Variable_Decl);
         package Bare_Variable_Decl_Alloc is new Alloc
           (Subtype_For_Variable_Decl, Access_To_Subtype_For_Variable_Decl);

         function Allocate_Variable_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Variable_Decl;

         function Allocate_Variable_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Variable_Decl
         is
            Result      : constant Access_To_Subtype_For_Variable_Decl := Bare_Variable_Decl_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Variable_Decl;
            return Bare_Variable_Decl (Result);
         end Allocate_Variable_Decl;

      package Bare_Message_Aggregate_Association_Memos is new Langkit_Support.Packrat
        (Bare_Message_Aggregate_Association, Token_Index);

         
         subtype Subtype_For_Message_Aggregate_Association is
            Root_Node_Record (Rflx_Message_Aggregate_Association);
         type Access_To_Subtype_For_Message_Aggregate_Association is access all Subtype_For_Message_Aggregate_Association;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Message_Aggregate_Association);
         package Bare_Message_Aggregate_Association_Alloc is new Alloc
           (Subtype_For_Message_Aggregate_Association, Access_To_Subtype_For_Message_Aggregate_Association);

         function Allocate_Message_Aggregate_Association
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate_Association;

         function Allocate_Message_Aggregate_Association
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate_Association
         is
            Result      : constant Access_To_Subtype_For_Message_Aggregate_Association := Bare_Message_Aggregate_Association_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Message_Aggregate_Association;
            return Bare_Message_Aggregate_Association (Result);
         end Allocate_Message_Aggregate_Association;

      package Bare_Message_Aspect_Memos is new Langkit_Support.Packrat
        (Bare_Message_Aspect, Token_Index);

      package Bare_Byte_Order_Aspect_Memos is new Langkit_Support.Packrat
        (Bare_Byte_Order_Aspect, Token_Index);

         
         subtype Subtype_For_Byte_Order_Aspect is
            Root_Node_Record (Rflx_Byte_Order_Aspect);
         type Access_To_Subtype_For_Byte_Order_Aspect is access all Subtype_For_Byte_Order_Aspect;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Byte_Order_Aspect);
         package Bare_Byte_Order_Aspect_Alloc is new Alloc
           (Subtype_For_Byte_Order_Aspect, Access_To_Subtype_For_Byte_Order_Aspect);

         function Allocate_Byte_Order_Aspect
           (Pool : Bump_Ptr_Pool) return Bare_Byte_Order_Aspect;

         function Allocate_Byte_Order_Aspect
           (Pool : Bump_Ptr_Pool) return Bare_Byte_Order_Aspect
         is
            Result      : constant Access_To_Subtype_For_Byte_Order_Aspect := Bare_Byte_Order_Aspect_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Byte_Order_Aspect;
            return Bare_Byte_Order_Aspect (Result);
         end Allocate_Byte_Order_Aspect;

      package Bare_Checksum_Aspect_Memos is new Langkit_Support.Packrat
        (Bare_Checksum_Aspect, Token_Index);

         
         subtype Subtype_For_Checksum_Aspect is
            Root_Node_Record (Rflx_Checksum_Aspect);
         type Access_To_Subtype_For_Checksum_Aspect is access all Subtype_For_Checksum_Aspect;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Checksum_Aspect);
         package Bare_Checksum_Aspect_Alloc is new Alloc
           (Subtype_For_Checksum_Aspect, Access_To_Subtype_For_Checksum_Aspect);

         function Allocate_Checksum_Aspect
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Aspect;

         function Allocate_Checksum_Aspect
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Aspect
         is
            Result      : constant Access_To_Subtype_For_Checksum_Aspect := Bare_Checksum_Aspect_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Checksum_Aspect;
            return Bare_Checksum_Aspect (Result);
         end Allocate_Checksum_Aspect;

      package Bare_Message_Field_Memos is new Langkit_Support.Packrat
        (Bare_Message_Field, Token_Index);

         
         subtype Subtype_For_Message_Field is
            Root_Node_Record (Rflx_Message_Field);
         type Access_To_Subtype_For_Message_Field is access all Subtype_For_Message_Field;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Message_Field);
         package Bare_Message_Field_Alloc is new Alloc
           (Subtype_For_Message_Field, Access_To_Subtype_For_Message_Field);

         function Allocate_Message_Field
           (Pool : Bump_Ptr_Pool) return Bare_Message_Field;

         function Allocate_Message_Field
           (Pool : Bump_Ptr_Pool) return Bare_Message_Field
         is
            Result      : constant Access_To_Subtype_For_Message_Field := Bare_Message_Field_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Message_Field;
            return Bare_Message_Field (Result);
         end Allocate_Message_Field;

      package Bare_Message_Fields_Memos is new Langkit_Support.Packrat
        (Bare_Message_Fields, Token_Index);

         
         subtype Subtype_For_Message_Fields is
            Root_Node_Record (Rflx_Message_Fields);
         type Access_To_Subtype_For_Message_Fields is access all Subtype_For_Message_Fields;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Message_Fields);
         package Bare_Message_Fields_Alloc is new Alloc
           (Subtype_For_Message_Fields, Access_To_Subtype_For_Message_Fields);

         function Allocate_Message_Fields
           (Pool : Bump_Ptr_Pool) return Bare_Message_Fields;

         function Allocate_Message_Fields
           (Pool : Bump_Ptr_Pool) return Bare_Message_Fields
         is
            Result      : constant Access_To_Subtype_For_Message_Fields := Bare_Message_Fields_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Message_Fields;
            return Bare_Message_Fields (Result);
         end Allocate_Message_Fields;

      package Bare_Null_Message_Field_Memos is new Langkit_Support.Packrat
        (Bare_Null_Message_Field, Token_Index);

         
         subtype Subtype_For_Null_Message_Field is
            Root_Node_Record (Rflx_Null_Message_Field);
         type Access_To_Subtype_For_Null_Message_Field is access all Subtype_For_Null_Message_Field;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Message_Field);
         package Bare_Null_Message_Field_Alloc is new Alloc
           (Subtype_For_Null_Message_Field, Access_To_Subtype_For_Null_Message_Field);

         function Allocate_Null_Message_Field
           (Pool : Bump_Ptr_Pool) return Bare_Null_Message_Field;

         function Allocate_Null_Message_Field
           (Pool : Bump_Ptr_Pool) return Bare_Null_Message_Field
         is
            Result      : constant Access_To_Subtype_For_Null_Message_Field := Bare_Null_Message_Field_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Null_Message_Field;
            return Bare_Null_Message_Field (Result);
         end Allocate_Null_Message_Field;

      package Bare_Op_Memos is new Langkit_Support.Packrat
        (Bare_Op, Token_Index);

      package Bare_Op_Add_Memos is new Langkit_Support.Packrat
        (Bare_Op_Add, Token_Index);

         
         subtype Subtype_For_Op_Add is
            Root_Node_Record (Rflx_Op_Add);
         type Access_To_Subtype_For_Op_Add is access all Subtype_For_Op_Add;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Add);
         package Bare_Op_Add_Alloc is new Alloc
           (Subtype_For_Op_Add, Access_To_Subtype_For_Op_Add);

         function Allocate_Op_Add
           (Pool : Bump_Ptr_Pool) return Bare_Op_Add;

         function Allocate_Op_Add
           (Pool : Bump_Ptr_Pool) return Bare_Op_Add
         is
            Result      : constant Access_To_Subtype_For_Op_Add := Bare_Op_Add_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Add;
            return Bare_Op_Add (Result);
         end Allocate_Op_Add;

      package Bare_Op_And_Memos is new Langkit_Support.Packrat
        (Bare_Op_And, Token_Index);

         
         subtype Subtype_For_Op_And is
            Root_Node_Record (Rflx_Op_And);
         type Access_To_Subtype_For_Op_And is access all Subtype_For_Op_And;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_And);
         package Bare_Op_And_Alloc is new Alloc
           (Subtype_For_Op_And, Access_To_Subtype_For_Op_And);

         function Allocate_Op_And
           (Pool : Bump_Ptr_Pool) return Bare_Op_And;

         function Allocate_Op_And
           (Pool : Bump_Ptr_Pool) return Bare_Op_And
         is
            Result      : constant Access_To_Subtype_For_Op_And := Bare_Op_And_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_And;
            return Bare_Op_And (Result);
         end Allocate_Op_And;

      package Bare_Op_Div_Memos is new Langkit_Support.Packrat
        (Bare_Op_Div, Token_Index);

         
         subtype Subtype_For_Op_Div is
            Root_Node_Record (Rflx_Op_Div);
         type Access_To_Subtype_For_Op_Div is access all Subtype_For_Op_Div;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Div);
         package Bare_Op_Div_Alloc is new Alloc
           (Subtype_For_Op_Div, Access_To_Subtype_For_Op_Div);

         function Allocate_Op_Div
           (Pool : Bump_Ptr_Pool) return Bare_Op_Div;

         function Allocate_Op_Div
           (Pool : Bump_Ptr_Pool) return Bare_Op_Div
         is
            Result      : constant Access_To_Subtype_For_Op_Div := Bare_Op_Div_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Div;
            return Bare_Op_Div (Result);
         end Allocate_Op_Div;

      package Bare_Op_Eq_Memos is new Langkit_Support.Packrat
        (Bare_Op_Eq, Token_Index);

         
         subtype Subtype_For_Op_Eq is
            Root_Node_Record (Rflx_Op_Eq);
         type Access_To_Subtype_For_Op_Eq is access all Subtype_For_Op_Eq;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Eq);
         package Bare_Op_Eq_Alloc is new Alloc
           (Subtype_For_Op_Eq, Access_To_Subtype_For_Op_Eq);

         function Allocate_Op_Eq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Eq;

         function Allocate_Op_Eq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Eq
         is
            Result      : constant Access_To_Subtype_For_Op_Eq := Bare_Op_Eq_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Eq;
            return Bare_Op_Eq (Result);
         end Allocate_Op_Eq;

      package Bare_Op_Ge_Memos is new Langkit_Support.Packrat
        (Bare_Op_Ge, Token_Index);

         
         subtype Subtype_For_Op_Ge is
            Root_Node_Record (Rflx_Op_Ge);
         type Access_To_Subtype_For_Op_Ge is access all Subtype_For_Op_Ge;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Ge);
         package Bare_Op_Ge_Alloc is new Alloc
           (Subtype_For_Op_Ge, Access_To_Subtype_For_Op_Ge);

         function Allocate_Op_Ge
           (Pool : Bump_Ptr_Pool) return Bare_Op_Ge;

         function Allocate_Op_Ge
           (Pool : Bump_Ptr_Pool) return Bare_Op_Ge
         is
            Result      : constant Access_To_Subtype_For_Op_Ge := Bare_Op_Ge_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Ge;
            return Bare_Op_Ge (Result);
         end Allocate_Op_Ge;

      package Bare_Op_Gt_Memos is new Langkit_Support.Packrat
        (Bare_Op_Gt, Token_Index);

         
         subtype Subtype_For_Op_Gt is
            Root_Node_Record (Rflx_Op_Gt);
         type Access_To_Subtype_For_Op_Gt is access all Subtype_For_Op_Gt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Gt);
         package Bare_Op_Gt_Alloc is new Alloc
           (Subtype_For_Op_Gt, Access_To_Subtype_For_Op_Gt);

         function Allocate_Op_Gt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gt;

         function Allocate_Op_Gt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gt
         is
            Result      : constant Access_To_Subtype_For_Op_Gt := Bare_Op_Gt_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Gt;
            return Bare_Op_Gt (Result);
         end Allocate_Op_Gt;

      package Bare_Op_In_Memos is new Langkit_Support.Packrat
        (Bare_Op_In, Token_Index);

         
         subtype Subtype_For_Op_In is
            Root_Node_Record (Rflx_Op_In);
         type Access_To_Subtype_For_Op_In is access all Subtype_For_Op_In;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_In);
         package Bare_Op_In_Alloc is new Alloc
           (Subtype_For_Op_In, Access_To_Subtype_For_Op_In);

         function Allocate_Op_In
           (Pool : Bump_Ptr_Pool) return Bare_Op_In;

         function Allocate_Op_In
           (Pool : Bump_Ptr_Pool) return Bare_Op_In
         is
            Result      : constant Access_To_Subtype_For_Op_In := Bare_Op_In_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_In;
            return Bare_Op_In (Result);
         end Allocate_Op_In;

      package Bare_Op_Le_Memos is new Langkit_Support.Packrat
        (Bare_Op_Le, Token_Index);

         
         subtype Subtype_For_Op_Le is
            Root_Node_Record (Rflx_Op_Le);
         type Access_To_Subtype_For_Op_Le is access all Subtype_For_Op_Le;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Le);
         package Bare_Op_Le_Alloc is new Alloc
           (Subtype_For_Op_Le, Access_To_Subtype_For_Op_Le);

         function Allocate_Op_Le
           (Pool : Bump_Ptr_Pool) return Bare_Op_Le;

         function Allocate_Op_Le
           (Pool : Bump_Ptr_Pool) return Bare_Op_Le
         is
            Result      : constant Access_To_Subtype_For_Op_Le := Bare_Op_Le_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Le;
            return Bare_Op_Le (Result);
         end Allocate_Op_Le;

      package Bare_Op_Lt_Memos is new Langkit_Support.Packrat
        (Bare_Op_Lt, Token_Index);

         
         subtype Subtype_For_Op_Lt is
            Root_Node_Record (Rflx_Op_Lt);
         type Access_To_Subtype_For_Op_Lt is access all Subtype_For_Op_Lt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Lt);
         package Bare_Op_Lt_Alloc is new Alloc
           (Subtype_For_Op_Lt, Access_To_Subtype_For_Op_Lt);

         function Allocate_Op_Lt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lt;

         function Allocate_Op_Lt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lt
         is
            Result      : constant Access_To_Subtype_For_Op_Lt := Bare_Op_Lt_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Lt;
            return Bare_Op_Lt (Result);
         end Allocate_Op_Lt;

      package Bare_Op_Mod_Memos is new Langkit_Support.Packrat
        (Bare_Op_Mod, Token_Index);

         
         subtype Subtype_For_Op_Mod is
            Root_Node_Record (Rflx_Op_Mod);
         type Access_To_Subtype_For_Op_Mod is access all Subtype_For_Op_Mod;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Mod);
         package Bare_Op_Mod_Alloc is new Alloc
           (Subtype_For_Op_Mod, Access_To_Subtype_For_Op_Mod);

         function Allocate_Op_Mod
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mod;

         function Allocate_Op_Mod
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mod
         is
            Result      : constant Access_To_Subtype_For_Op_Mod := Bare_Op_Mod_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Mod;
            return Bare_Op_Mod (Result);
         end Allocate_Op_Mod;

      package Bare_Op_Mul_Memos is new Langkit_Support.Packrat
        (Bare_Op_Mul, Token_Index);

         
         subtype Subtype_For_Op_Mul is
            Root_Node_Record (Rflx_Op_Mul);
         type Access_To_Subtype_For_Op_Mul is access all Subtype_For_Op_Mul;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Mul);
         package Bare_Op_Mul_Alloc is new Alloc
           (Subtype_For_Op_Mul, Access_To_Subtype_For_Op_Mul);

         function Allocate_Op_Mul
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mul;

         function Allocate_Op_Mul
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mul
         is
            Result      : constant Access_To_Subtype_For_Op_Mul := Bare_Op_Mul_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Mul;
            return Bare_Op_Mul (Result);
         end Allocate_Op_Mul;

      package Bare_Op_Neq_Memos is new Langkit_Support.Packrat
        (Bare_Op_Neq, Token_Index);

         
         subtype Subtype_For_Op_Neq is
            Root_Node_Record (Rflx_Op_Neq);
         type Access_To_Subtype_For_Op_Neq is access all Subtype_For_Op_Neq;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Neq);
         package Bare_Op_Neq_Alloc is new Alloc
           (Subtype_For_Op_Neq, Access_To_Subtype_For_Op_Neq);

         function Allocate_Op_Neq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Neq;

         function Allocate_Op_Neq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Neq
         is
            Result      : constant Access_To_Subtype_For_Op_Neq := Bare_Op_Neq_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Neq;
            return Bare_Op_Neq (Result);
         end Allocate_Op_Neq;

      package Bare_Op_Notin_Memos is new Langkit_Support.Packrat
        (Bare_Op_Notin, Token_Index);

         
         subtype Subtype_For_Op_Notin is
            Root_Node_Record (Rflx_Op_Notin);
         type Access_To_Subtype_For_Op_Notin is access all Subtype_For_Op_Notin;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Notin);
         package Bare_Op_Notin_Alloc is new Alloc
           (Subtype_For_Op_Notin, Access_To_Subtype_For_Op_Notin);

         function Allocate_Op_Notin
           (Pool : Bump_Ptr_Pool) return Bare_Op_Notin;

         function Allocate_Op_Notin
           (Pool : Bump_Ptr_Pool) return Bare_Op_Notin
         is
            Result      : constant Access_To_Subtype_For_Op_Notin := Bare_Op_Notin_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Notin;
            return Bare_Op_Notin (Result);
         end Allocate_Op_Notin;

      package Bare_Op_Or_Memos is new Langkit_Support.Packrat
        (Bare_Op_Or, Token_Index);

         
         subtype Subtype_For_Op_Or is
            Root_Node_Record (Rflx_Op_Or);
         type Access_To_Subtype_For_Op_Or is access all Subtype_For_Op_Or;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Or);
         package Bare_Op_Or_Alloc is new Alloc
           (Subtype_For_Op_Or, Access_To_Subtype_For_Op_Or);

         function Allocate_Op_Or
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or;

         function Allocate_Op_Or
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or
         is
            Result      : constant Access_To_Subtype_For_Op_Or := Bare_Op_Or_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Or;
            return Bare_Op_Or (Result);
         end Allocate_Op_Or;

      package Bare_Op_Pow_Memos is new Langkit_Support.Packrat
        (Bare_Op_Pow, Token_Index);

         
         subtype Subtype_For_Op_Pow is
            Root_Node_Record (Rflx_Op_Pow);
         type Access_To_Subtype_For_Op_Pow is access all Subtype_For_Op_Pow;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Pow);
         package Bare_Op_Pow_Alloc is new Alloc
           (Subtype_For_Op_Pow, Access_To_Subtype_For_Op_Pow);

         function Allocate_Op_Pow
           (Pool : Bump_Ptr_Pool) return Bare_Op_Pow;

         function Allocate_Op_Pow
           (Pool : Bump_Ptr_Pool) return Bare_Op_Pow
         is
            Result      : constant Access_To_Subtype_For_Op_Pow := Bare_Op_Pow_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Pow;
            return Bare_Op_Pow (Result);
         end Allocate_Op_Pow;

      package Bare_Op_Sub_Memos is new Langkit_Support.Packrat
        (Bare_Op_Sub, Token_Index);

         
         subtype Subtype_For_Op_Sub is
            Root_Node_Record (Rflx_Op_Sub);
         type Access_To_Subtype_For_Op_Sub is access all Subtype_For_Op_Sub;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Sub);
         package Bare_Op_Sub_Alloc is new Alloc
           (Subtype_For_Op_Sub, Access_To_Subtype_For_Op_Sub);

         function Allocate_Op_Sub
           (Pool : Bump_Ptr_Pool) return Bare_Op_Sub;

         function Allocate_Op_Sub
           (Pool : Bump_Ptr_Pool) return Bare_Op_Sub
         is
            Result      : constant Access_To_Subtype_For_Op_Sub := Bare_Op_Sub_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Op_Sub;
            return Bare_Op_Sub (Result);
         end Allocate_Op_Sub;

      package Bare_Package_Node_Memos is new Langkit_Support.Packrat
        (Bare_Package_Node, Token_Index);

         
         subtype Subtype_For_Package_Node is
            Root_Node_Record (Rflx_Package_Node);
         type Access_To_Subtype_For_Package_Node is access all Subtype_For_Package_Node;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Package_Node);
         package Bare_Package_Node_Alloc is new Alloc
           (Subtype_For_Package_Node, Access_To_Subtype_For_Package_Node);

         function Allocate_Package_Node
           (Pool : Bump_Ptr_Pool) return Bare_Package_Node;

         function Allocate_Package_Node
           (Pool : Bump_Ptr_Pool) return Bare_Package_Node
         is
            Result      : constant Access_To_Subtype_For_Package_Node := Bare_Package_Node_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Package_Node;
            return Bare_Package_Node (Result);
         end Allocate_Package_Node;

      package Bare_Parameter_Memos is new Langkit_Support.Packrat
        (Bare_Parameter, Token_Index);

         
         subtype Subtype_For_Parameter is
            Root_Node_Record (Rflx_Parameter);
         type Access_To_Subtype_For_Parameter is access all Subtype_For_Parameter;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Parameter);
         package Bare_Parameter_Alloc is new Alloc
           (Subtype_For_Parameter, Access_To_Subtype_For_Parameter);

         function Allocate_Parameter
           (Pool : Bump_Ptr_Pool) return Bare_Parameter;

         function Allocate_Parameter
           (Pool : Bump_Ptr_Pool) return Bare_Parameter
         is
            Result      : constant Access_To_Subtype_For_Parameter := Bare_Parameter_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Parameter;
            return Bare_Parameter (Result);
         end Allocate_Parameter;

      package Bare_Parameters_Memos is new Langkit_Support.Packrat
        (Bare_Parameters, Token_Index);

         
         subtype Subtype_For_Parameters is
            Root_Node_Record (Rflx_Parameters);
         type Access_To_Subtype_For_Parameters is access all Subtype_For_Parameters;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Parameters);
         package Bare_Parameters_Alloc is new Alloc
           (Subtype_For_Parameters, Access_To_Subtype_For_Parameters);

         function Allocate_Parameters
           (Pool : Bump_Ptr_Pool) return Bare_Parameters;

         function Allocate_Parameters
           (Pool : Bump_Ptr_Pool) return Bare_Parameters
         is
            Result      : constant Access_To_Subtype_For_Parameters := Bare_Parameters_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Parameters;
            return Bare_Parameters (Result);
         end Allocate_Parameters;

      package Bare_Quantifier_Memos is new Langkit_Support.Packrat
        (Bare_Quantifier, Token_Index);

      package Bare_Quantifier_All_Memos is new Langkit_Support.Packrat
        (Bare_Quantifier_All, Token_Index);

         
         subtype Subtype_For_Quantifier_All is
            Root_Node_Record (Rflx_Quantifier_All);
         type Access_To_Subtype_For_Quantifier_All is access all Subtype_For_Quantifier_All;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Quantifier_All);
         package Bare_Quantifier_All_Alloc is new Alloc
           (Subtype_For_Quantifier_All, Access_To_Subtype_For_Quantifier_All);

         function Allocate_Quantifier_All
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_All;

         function Allocate_Quantifier_All
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_All
         is
            Result      : constant Access_To_Subtype_For_Quantifier_All := Bare_Quantifier_All_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Quantifier_All;
            return Bare_Quantifier_All (Result);
         end Allocate_Quantifier_All;

      package Bare_Quantifier_Some_Memos is new Langkit_Support.Packrat
        (Bare_Quantifier_Some, Token_Index);

         
         subtype Subtype_For_Quantifier_Some is
            Root_Node_Record (Rflx_Quantifier_Some);
         type Access_To_Subtype_For_Quantifier_Some is access all Subtype_For_Quantifier_Some;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Quantifier_Some);
         package Bare_Quantifier_Some_Alloc is new Alloc
           (Subtype_For_Quantifier_Some, Access_To_Subtype_For_Quantifier_Some);

         function Allocate_Quantifier_Some
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_Some;

         function Allocate_Quantifier_Some
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_Some
         is
            Result      : constant Access_To_Subtype_For_Quantifier_Some := Bare_Quantifier_Some_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Quantifier_Some;
            return Bare_Quantifier_Some (Result);
         end Allocate_Quantifier_Some;

      package Bare_R_F_L_X_Node_Base_List_Memos is new Langkit_Support.Packrat
        (Bare_R_F_L_X_Node_Base_List, Token_Index);

      package Bare_Aspect_List_Memos is new Langkit_Support.Packrat
        (Bare_Aspect_List, Token_Index);

         
         subtype Subtype_For_Aspect_List is
            Root_Node_Record (Rflx_Aspect_List);
         type Access_To_Subtype_For_Aspect_List is access all Subtype_For_Aspect_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Aspect_List);
         package Bare_Aspect_List_Alloc is new Alloc
           (Subtype_For_Aspect_List, Access_To_Subtype_For_Aspect_List);

         function Allocate_Aspect_List
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_List;

         function Allocate_Aspect_List
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_List
         is
            Result      : constant Access_To_Subtype_For_Aspect_List := Bare_Aspect_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Aspect_List;
            return Bare_Aspect_List (Result);
         end Allocate_Aspect_List;

      package Bare_Base_Checksum_Val_List_Memos is new Langkit_Support.Packrat
        (Bare_Base_Checksum_Val_List, Token_Index);

         
         subtype Subtype_For_Base_Checksum_Val_List is
            Root_Node_Record (Rflx_Base_Checksum_Val_List);
         type Access_To_Subtype_For_Base_Checksum_Val_List is access all Subtype_For_Base_Checksum_Val_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Base_Checksum_Val_List);
         package Bare_Base_Checksum_Val_List_Alloc is new Alloc
           (Subtype_For_Base_Checksum_Val_List, Access_To_Subtype_For_Base_Checksum_Val_List);

         function Allocate_Base_Checksum_Val_List
           (Pool : Bump_Ptr_Pool) return Bare_Base_Checksum_Val_List;

         function Allocate_Base_Checksum_Val_List
           (Pool : Bump_Ptr_Pool) return Bare_Base_Checksum_Val_List
         is
            Result      : constant Access_To_Subtype_For_Base_Checksum_Val_List := Bare_Base_Checksum_Val_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Base_Checksum_Val_List;
            return Bare_Base_Checksum_Val_List (Result);
         end Allocate_Base_Checksum_Val_List;

      package Bare_Channel_Attribute_List_Memos is new Langkit_Support.Packrat
        (Bare_Channel_Attribute_List, Token_Index);

         
         subtype Subtype_For_Channel_Attribute_List is
            Root_Node_Record (Rflx_Channel_Attribute_List);
         type Access_To_Subtype_For_Channel_Attribute_List is access all Subtype_For_Channel_Attribute_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Channel_Attribute_List);
         package Bare_Channel_Attribute_List_Alloc is new Alloc
           (Subtype_For_Channel_Attribute_List, Access_To_Subtype_For_Channel_Attribute_List);

         function Allocate_Channel_Attribute_List
           (Pool : Bump_Ptr_Pool) return Bare_Channel_Attribute_List;

         function Allocate_Channel_Attribute_List
           (Pool : Bump_Ptr_Pool) return Bare_Channel_Attribute_List
         is
            Result      : constant Access_To_Subtype_For_Channel_Attribute_List := Bare_Channel_Attribute_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Channel_Attribute_List;
            return Bare_Channel_Attribute_List (Result);
         end Allocate_Channel_Attribute_List;

      package Bare_Checksum_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Checksum_Assoc_List, Token_Index);

         
         subtype Subtype_For_Checksum_Assoc_List is
            Root_Node_Record (Rflx_Checksum_Assoc_List);
         type Access_To_Subtype_For_Checksum_Assoc_List is access all Subtype_For_Checksum_Assoc_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Checksum_Assoc_List);
         package Bare_Checksum_Assoc_List_Alloc is new Alloc
           (Subtype_For_Checksum_Assoc_List, Access_To_Subtype_For_Checksum_Assoc_List);

         function Allocate_Checksum_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Assoc_List;

         function Allocate_Checksum_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Checksum_Assoc_List := Bare_Checksum_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Checksum_Assoc_List;
            return Bare_Checksum_Assoc_List (Result);
         end Allocate_Checksum_Assoc_List;

      package Bare_Choice_List_Memos is new Langkit_Support.Packrat
        (Bare_Choice_List, Token_Index);

         
         subtype Subtype_For_Choice_List is
            Root_Node_Record (Rflx_Choice_List);
         type Access_To_Subtype_For_Choice_List is access all Subtype_For_Choice_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Choice_List);
         package Bare_Choice_List_Alloc is new Alloc
           (Subtype_For_Choice_List, Access_To_Subtype_For_Choice_List);

         function Allocate_Choice_List
           (Pool : Bump_Ptr_Pool) return Bare_Choice_List;

         function Allocate_Choice_List
           (Pool : Bump_Ptr_Pool) return Bare_Choice_List
         is
            Result      : constant Access_To_Subtype_For_Choice_List := Bare_Choice_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Choice_List;
            return Bare_Choice_List (Result);
         end Allocate_Choice_List;

      package Bare_Conditional_Transition_List_Memos is new Langkit_Support.Packrat
        (Bare_Conditional_Transition_List, Token_Index);

         
         subtype Subtype_For_Conditional_Transition_List is
            Root_Node_Record (Rflx_Conditional_Transition_List);
         type Access_To_Subtype_For_Conditional_Transition_List is access all Subtype_For_Conditional_Transition_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Conditional_Transition_List);
         package Bare_Conditional_Transition_List_Alloc is new Alloc
           (Subtype_For_Conditional_Transition_List, Access_To_Subtype_For_Conditional_Transition_List);

         function Allocate_Conditional_Transition_List
           (Pool : Bump_Ptr_Pool) return Bare_Conditional_Transition_List;

         function Allocate_Conditional_Transition_List
           (Pool : Bump_Ptr_Pool) return Bare_Conditional_Transition_List
         is
            Result      : constant Access_To_Subtype_For_Conditional_Transition_List := Bare_Conditional_Transition_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Conditional_Transition_List;
            return Bare_Conditional_Transition_List (Result);
         end Allocate_Conditional_Transition_List;

      package Bare_Context_Item_List_Memos is new Langkit_Support.Packrat
        (Bare_Context_Item_List, Token_Index);

         
         subtype Subtype_For_Context_Item_List is
            Root_Node_Record (Rflx_Context_Item_List);
         type Access_To_Subtype_For_Context_Item_List is access all Subtype_For_Context_Item_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Context_Item_List);
         package Bare_Context_Item_List_Alloc is new Alloc
           (Subtype_For_Context_Item_List, Access_To_Subtype_For_Context_Item_List);

         function Allocate_Context_Item_List
           (Pool : Bump_Ptr_Pool) return Bare_Context_Item_List;

         function Allocate_Context_Item_List
           (Pool : Bump_Ptr_Pool) return Bare_Context_Item_List
         is
            Result      : constant Access_To_Subtype_For_Context_Item_List := Bare_Context_Item_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Context_Item_List;
            return Bare_Context_Item_List (Result);
         end Allocate_Context_Item_List;

      package Bare_Declaration_List_Memos is new Langkit_Support.Packrat
        (Bare_Declaration_List, Token_Index);

         
         subtype Subtype_For_Declaration_List is
            Root_Node_Record (Rflx_Declaration_List);
         type Access_To_Subtype_For_Declaration_List is access all Subtype_For_Declaration_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Declaration_List);
         package Bare_Declaration_List_Alloc is new Alloc
           (Subtype_For_Declaration_List, Access_To_Subtype_For_Declaration_List);

         function Allocate_Declaration_List
           (Pool : Bump_Ptr_Pool) return Bare_Declaration_List;

         function Allocate_Declaration_List
           (Pool : Bump_Ptr_Pool) return Bare_Declaration_List
         is
            Result      : constant Access_To_Subtype_For_Declaration_List := Bare_Declaration_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Declaration_List;
            return Bare_Declaration_List (Result);
         end Allocate_Declaration_List;

      package Bare_Element_Value_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Element_Value_Assoc_List, Token_Index);

         
         subtype Subtype_For_Element_Value_Assoc_List is
            Root_Node_Record (Rflx_Element_Value_Assoc_List);
         type Access_To_Subtype_For_Element_Value_Assoc_List is access all Subtype_For_Element_Value_Assoc_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Element_Value_Assoc_List);
         package Bare_Element_Value_Assoc_List_Alloc is new Alloc
           (Subtype_For_Element_Value_Assoc_List, Access_To_Subtype_For_Element_Value_Assoc_List);

         function Allocate_Element_Value_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Element_Value_Assoc_List;

         function Allocate_Element_Value_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Element_Value_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Element_Value_Assoc_List := Bare_Element_Value_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Element_Value_Assoc_List;
            return Bare_Element_Value_Assoc_List (Result);
         end Allocate_Element_Value_Assoc_List;

      package Bare_Expr_List_Memos is new Langkit_Support.Packrat
        (Bare_Expr_List, Token_Index);

         
         subtype Subtype_For_Expr_List is
            Root_Node_Record (Rflx_Expr_List);
         type Access_To_Subtype_For_Expr_List is access all Subtype_For_Expr_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Expr_List);
         package Bare_Expr_List_Alloc is new Alloc
           (Subtype_For_Expr_List, Access_To_Subtype_For_Expr_List);

         function Allocate_Expr_List
           (Pool : Bump_Ptr_Pool) return Bare_Expr_List;

         function Allocate_Expr_List
           (Pool : Bump_Ptr_Pool) return Bare_Expr_List
         is
            Result      : constant Access_To_Subtype_For_Expr_List := Bare_Expr_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Expr_List;
            return Bare_Expr_List (Result);
         end Allocate_Expr_List;

      package Bare_Formal_Decl_List_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Decl_List, Token_Index);

         
         subtype Subtype_For_Formal_Decl_List is
            Root_Node_Record (Rflx_Formal_Decl_List);
         type Access_To_Subtype_For_Formal_Decl_List is access all Subtype_For_Formal_Decl_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Formal_Decl_List);
         package Bare_Formal_Decl_List_Alloc is new Alloc
           (Subtype_For_Formal_Decl_List, Access_To_Subtype_For_Formal_Decl_List);

         function Allocate_Formal_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Decl_List;

         function Allocate_Formal_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Formal_Decl_List := Bare_Formal_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Formal_Decl_List;
            return Bare_Formal_Decl_List (Result);
         end Allocate_Formal_Decl_List;

      package Bare_Local_Decl_List_Memos is new Langkit_Support.Packrat
        (Bare_Local_Decl_List, Token_Index);

         
         subtype Subtype_For_Local_Decl_List is
            Root_Node_Record (Rflx_Local_Decl_List);
         type Access_To_Subtype_For_Local_Decl_List is access all Subtype_For_Local_Decl_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Local_Decl_List);
         package Bare_Local_Decl_List_Alloc is new Alloc
           (Subtype_For_Local_Decl_List, Access_To_Subtype_For_Local_Decl_List);

         function Allocate_Local_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Local_Decl_List;

         function Allocate_Local_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Local_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Local_Decl_List := Bare_Local_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Local_Decl_List;
            return Bare_Local_Decl_List (Result);
         end Allocate_Local_Decl_List;

      package Bare_Message_Aggregate_Association_List_Memos is new Langkit_Support.Packrat
        (Bare_Message_Aggregate_Association_List, Token_Index);

         
         subtype Subtype_For_Message_Aggregate_Association_List is
            Root_Node_Record (Rflx_Message_Aggregate_Association_List);
         type Access_To_Subtype_For_Message_Aggregate_Association_List is access all Subtype_For_Message_Aggregate_Association_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Message_Aggregate_Association_List);
         package Bare_Message_Aggregate_Association_List_Alloc is new Alloc
           (Subtype_For_Message_Aggregate_Association_List, Access_To_Subtype_For_Message_Aggregate_Association_List);

         function Allocate_Message_Aggregate_Association_List
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate_Association_List;

         function Allocate_Message_Aggregate_Association_List
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate_Association_List
         is
            Result      : constant Access_To_Subtype_For_Message_Aggregate_Association_List := Bare_Message_Aggregate_Association_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Message_Aggregate_Association_List;
            return Bare_Message_Aggregate_Association_List (Result);
         end Allocate_Message_Aggregate_Association_List;

      package Bare_Message_Aspect_List_Memos is new Langkit_Support.Packrat
        (Bare_Message_Aspect_List, Token_Index);

         
         subtype Subtype_For_Message_Aspect_List is
            Root_Node_Record (Rflx_Message_Aspect_List);
         type Access_To_Subtype_For_Message_Aspect_List is access all Subtype_For_Message_Aspect_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Message_Aspect_List);
         package Bare_Message_Aspect_List_Alloc is new Alloc
           (Subtype_For_Message_Aspect_List, Access_To_Subtype_For_Message_Aspect_List);

         function Allocate_Message_Aspect_List
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aspect_List;

         function Allocate_Message_Aspect_List
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aspect_List
         is
            Result      : constant Access_To_Subtype_For_Message_Aspect_List := Bare_Message_Aspect_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Message_Aspect_List;
            return Bare_Message_Aspect_List (Result);
         end Allocate_Message_Aspect_List;

      package Bare_Message_Field_List_Memos is new Langkit_Support.Packrat
        (Bare_Message_Field_List, Token_Index);

         
         subtype Subtype_For_Message_Field_List is
            Root_Node_Record (Rflx_Message_Field_List);
         type Access_To_Subtype_For_Message_Field_List is access all Subtype_For_Message_Field_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Message_Field_List);
         package Bare_Message_Field_List_Alloc is new Alloc
           (Subtype_For_Message_Field_List, Access_To_Subtype_For_Message_Field_List);

         function Allocate_Message_Field_List
           (Pool : Bump_Ptr_Pool) return Bare_Message_Field_List;

         function Allocate_Message_Field_List
           (Pool : Bump_Ptr_Pool) return Bare_Message_Field_List
         is
            Result      : constant Access_To_Subtype_For_Message_Field_List := Bare_Message_Field_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Message_Field_List;
            return Bare_Message_Field_List (Result);
         end Allocate_Message_Field_List;

      package Bare_Numeric_Literal_List_Memos is new Langkit_Support.Packrat
        (Bare_Numeric_Literal_List, Token_Index);

         
         subtype Subtype_For_Numeric_Literal_List is
            Root_Node_Record (Rflx_Numeric_Literal_List);
         type Access_To_Subtype_For_Numeric_Literal_List is access all Subtype_For_Numeric_Literal_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Numeric_Literal_List);
         package Bare_Numeric_Literal_List_Alloc is new Alloc
           (Subtype_For_Numeric_Literal_List, Access_To_Subtype_For_Numeric_Literal_List);

         function Allocate_Numeric_Literal_List
           (Pool : Bump_Ptr_Pool) return Bare_Numeric_Literal_List;

         function Allocate_Numeric_Literal_List
           (Pool : Bump_Ptr_Pool) return Bare_Numeric_Literal_List
         is
            Result      : constant Access_To_Subtype_For_Numeric_Literal_List := Bare_Numeric_Literal_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Numeric_Literal_List;
            return Bare_Numeric_Literal_List (Result);
         end Allocate_Numeric_Literal_List;

      package Bare_Parameter_List_Memos is new Langkit_Support.Packrat
        (Bare_Parameter_List, Token_Index);

         
         subtype Subtype_For_Parameter_List is
            Root_Node_Record (Rflx_Parameter_List);
         type Access_To_Subtype_For_Parameter_List is access all Subtype_For_Parameter_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Parameter_List);
         package Bare_Parameter_List_Alloc is new Alloc
           (Subtype_For_Parameter_List, Access_To_Subtype_For_Parameter_List);

         function Allocate_Parameter_List
           (Pool : Bump_Ptr_Pool) return Bare_Parameter_List;

         function Allocate_Parameter_List
           (Pool : Bump_Ptr_Pool) return Bare_Parameter_List
         is
            Result      : constant Access_To_Subtype_For_Parameter_List := Bare_Parameter_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Parameter_List;
            return Bare_Parameter_List (Result);
         end Allocate_Parameter_List;

      package Bare_R_F_L_X_Node_List_Memos is new Langkit_Support.Packrat
        (Bare_R_F_L_X_Node_List, Token_Index);

         
         subtype Subtype_For_R_F_L_X_Node_List is
            Root_Node_Record (Rflx_R_F_L_X_Node_List);
         type Access_To_Subtype_For_R_F_L_X_Node_List is access all Subtype_For_R_F_L_X_Node_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_R_F_L_X_Node_List);
         package Bare_R_F_L_X_Node_List_Alloc is new Alloc
           (Subtype_For_R_F_L_X_Node_List, Access_To_Subtype_For_R_F_L_X_Node_List);

         function Allocate_R_F_L_X_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_R_F_L_X_Node_List;

         function Allocate_R_F_L_X_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_R_F_L_X_Node_List
         is
            Result      : constant Access_To_Subtype_For_R_F_L_X_Node_List := Bare_R_F_L_X_Node_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_R_F_L_X_Node_List;
            return Bare_R_F_L_X_Node_List (Result);
         end Allocate_R_F_L_X_Node_List;

      package Bare_State_List_Memos is new Langkit_Support.Packrat
        (Bare_State_List, Token_Index);

         
         subtype Subtype_For_State_List is
            Root_Node_Record (Rflx_State_List);
         type Access_To_Subtype_For_State_List is access all Subtype_For_State_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_State_List);
         package Bare_State_List_Alloc is new Alloc
           (Subtype_For_State_List, Access_To_Subtype_For_State_List);

         function Allocate_State_List
           (Pool : Bump_Ptr_Pool) return Bare_State_List;

         function Allocate_State_List
           (Pool : Bump_Ptr_Pool) return Bare_State_List
         is
            Result      : constant Access_To_Subtype_For_State_List := Bare_State_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_State_List;
            return Bare_State_List (Result);
         end Allocate_State_List;

      package Bare_Statement_List_Memos is new Langkit_Support.Packrat
        (Bare_Statement_List, Token_Index);

         
         subtype Subtype_For_Statement_List is
            Root_Node_Record (Rflx_Statement_List);
         type Access_To_Subtype_For_Statement_List is access all Subtype_For_Statement_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Statement_List);
         package Bare_Statement_List_Alloc is new Alloc
           (Subtype_For_Statement_List, Access_To_Subtype_For_Statement_List);

         function Allocate_Statement_List
           (Pool : Bump_Ptr_Pool) return Bare_Statement_List;

         function Allocate_Statement_List
           (Pool : Bump_Ptr_Pool) return Bare_Statement_List
         is
            Result      : constant Access_To_Subtype_For_Statement_List := Bare_Statement_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Statement_List;
            return Bare_Statement_List (Result);
         end Allocate_Statement_List;

      package Bare_Term_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Term_Assoc_List, Token_Index);

         
         subtype Subtype_For_Term_Assoc_List is
            Root_Node_Record (Rflx_Term_Assoc_List);
         type Access_To_Subtype_For_Term_Assoc_List is access all Subtype_For_Term_Assoc_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Term_Assoc_List);
         package Bare_Term_Assoc_List_Alloc is new Alloc
           (Subtype_For_Term_Assoc_List, Access_To_Subtype_For_Term_Assoc_List);

         function Allocate_Term_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Term_Assoc_List;

         function Allocate_Term_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Term_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Term_Assoc_List := Bare_Term_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Term_Assoc_List;
            return Bare_Term_Assoc_List (Result);
         end Allocate_Term_Assoc_List;

      package Bare_Then_Node_List_Memos is new Langkit_Support.Packrat
        (Bare_Then_Node_List, Token_Index);

         
         subtype Subtype_For_Then_Node_List is
            Root_Node_Record (Rflx_Then_Node_List);
         type Access_To_Subtype_For_Then_Node_List is access all Subtype_For_Then_Node_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Then_Node_List);
         package Bare_Then_Node_List_Alloc is new Alloc
           (Subtype_For_Then_Node_List, Access_To_Subtype_For_Then_Node_List);

         function Allocate_Then_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Then_Node_List;

         function Allocate_Then_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Then_Node_List
         is
            Result      : constant Access_To_Subtype_For_Then_Node_List := Bare_Then_Node_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Then_Node_List;
            return Bare_Then_Node_List (Result);
         end Allocate_Then_Node_List;

      package Bare_Type_Argument_List_Memos is new Langkit_Support.Packrat
        (Bare_Type_Argument_List, Token_Index);

         
         subtype Subtype_For_Type_Argument_List is
            Root_Node_Record (Rflx_Type_Argument_List);
         type Access_To_Subtype_For_Type_Argument_List is access all Subtype_For_Type_Argument_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Type_Argument_List);
         package Bare_Type_Argument_List_Alloc is new Alloc
           (Subtype_For_Type_Argument_List, Access_To_Subtype_For_Type_Argument_List);

         function Allocate_Type_Argument_List
           (Pool : Bump_Ptr_Pool) return Bare_Type_Argument_List;

         function Allocate_Type_Argument_List
           (Pool : Bump_Ptr_Pool) return Bare_Type_Argument_List
         is
            Result      : constant Access_To_Subtype_For_Type_Argument_List := Bare_Type_Argument_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Type_Argument_List;
            return Bare_Type_Argument_List (Result);
         end Allocate_Type_Argument_List;

      package Bare_Unqualified_I_D_List_Memos is new Langkit_Support.Packrat
        (Bare_Unqualified_I_D_List, Token_Index);

         
         subtype Subtype_For_Unqualified_I_D_List is
            Root_Node_Record (Rflx_Unqualified_I_D_List);
         type Access_To_Subtype_For_Unqualified_I_D_List is access all Subtype_For_Unqualified_I_D_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Unqualified_I_D_List);
         package Bare_Unqualified_I_D_List_Alloc is new Alloc
           (Subtype_For_Unqualified_I_D_List, Access_To_Subtype_For_Unqualified_I_D_List);

         function Allocate_Unqualified_I_D_List
           (Pool : Bump_Ptr_Pool) return Bare_Unqualified_I_D_List;

         function Allocate_Unqualified_I_D_List
           (Pool : Bump_Ptr_Pool) return Bare_Unqualified_I_D_List
         is
            Result      : constant Access_To_Subtype_For_Unqualified_I_D_List := Bare_Unqualified_I_D_List_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Unqualified_I_D_List;
            return Bare_Unqualified_I_D_List (Result);
         end Allocate_Unqualified_I_D_List;

      package Bare_Specification_Memos is new Langkit_Support.Packrat
        (Bare_Specification, Token_Index);

         
         subtype Subtype_For_Specification is
            Root_Node_Record (Rflx_Specification);
         type Access_To_Subtype_For_Specification is access all Subtype_For_Specification;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Specification);
         package Bare_Specification_Alloc is new Alloc
           (Subtype_For_Specification, Access_To_Subtype_For_Specification);

         function Allocate_Specification
           (Pool : Bump_Ptr_Pool) return Bare_Specification;

         function Allocate_Specification
           (Pool : Bump_Ptr_Pool) return Bare_Specification
         is
            Result      : constant Access_To_Subtype_For_Specification := Bare_Specification_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Specification;
            return Bare_Specification (Result);
         end Allocate_Specification;

      package Bare_State_Memos is new Langkit_Support.Packrat
        (Bare_State, Token_Index);

         
         subtype Subtype_For_State is
            Root_Node_Record (Rflx_State);
         type Access_To_Subtype_For_State is access all Subtype_For_State;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_State);
         package Bare_State_Alloc is new Alloc
           (Subtype_For_State, Access_To_Subtype_For_State);

         function Allocate_State
           (Pool : Bump_Ptr_Pool) return Bare_State;

         function Allocate_State
           (Pool : Bump_Ptr_Pool) return Bare_State
         is
            Result      : constant Access_To_Subtype_For_State := Bare_State_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_State;
            return Bare_State (Result);
         end Allocate_State;

      package Bare_State_Body_Memos is new Langkit_Support.Packrat
        (Bare_State_Body, Token_Index);

         
         subtype Subtype_For_State_Body is
            Root_Node_Record (Rflx_State_Body);
         type Access_To_Subtype_For_State_Body is access all Subtype_For_State_Body;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_State_Body);
         package Bare_State_Body_Alloc is new Alloc
           (Subtype_For_State_Body, Access_To_Subtype_For_State_Body);

         function Allocate_State_Body
           (Pool : Bump_Ptr_Pool) return Bare_State_Body;

         function Allocate_State_Body
           (Pool : Bump_Ptr_Pool) return Bare_State_Body
         is
            Result      : constant Access_To_Subtype_For_State_Body := Bare_State_Body_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_State_Body;
            return Bare_State_Body (Result);
         end Allocate_State_Body;

      package Bare_Statement_Memos is new Langkit_Support.Packrat
        (Bare_Statement, Token_Index);

      package Bare_Assignment_Memos is new Langkit_Support.Packrat
        (Bare_Assignment, Token_Index);

         
         subtype Subtype_For_Assignment is
            Root_Node_Record (Rflx_Assignment);
         type Access_To_Subtype_For_Assignment is access all Subtype_For_Assignment;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Assignment);
         package Bare_Assignment_Alloc is new Alloc
           (Subtype_For_Assignment, Access_To_Subtype_For_Assignment);

         function Allocate_Assignment
           (Pool : Bump_Ptr_Pool) return Bare_Assignment;

         function Allocate_Assignment
           (Pool : Bump_Ptr_Pool) return Bare_Assignment
         is
            Result      : constant Access_To_Subtype_For_Assignment := Bare_Assignment_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Assignment;
            return Bare_Assignment (Result);
         end Allocate_Assignment;

      package Bare_Attribute_Statement_Memos is new Langkit_Support.Packrat
        (Bare_Attribute_Statement, Token_Index);

         
         subtype Subtype_For_Attribute_Statement is
            Root_Node_Record (Rflx_Attribute_Statement);
         type Access_To_Subtype_For_Attribute_Statement is access all Subtype_For_Attribute_Statement;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attribute_Statement);
         package Bare_Attribute_Statement_Alloc is new Alloc
           (Subtype_For_Attribute_Statement, Access_To_Subtype_For_Attribute_Statement);

         function Allocate_Attribute_Statement
           (Pool : Bump_Ptr_Pool) return Bare_Attribute_Statement;

         function Allocate_Attribute_Statement
           (Pool : Bump_Ptr_Pool) return Bare_Attribute_Statement
         is
            Result      : constant Access_To_Subtype_For_Attribute_Statement := Bare_Attribute_Statement_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Attribute_Statement;
            return Bare_Attribute_Statement (Result);
         end Allocate_Attribute_Statement;

      package Bare_Message_Field_Assignment_Memos is new Langkit_Support.Packrat
        (Bare_Message_Field_Assignment, Token_Index);

         
         subtype Subtype_For_Message_Field_Assignment is
            Root_Node_Record (Rflx_Message_Field_Assignment);
         type Access_To_Subtype_For_Message_Field_Assignment is access all Subtype_For_Message_Field_Assignment;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Message_Field_Assignment);
         package Bare_Message_Field_Assignment_Alloc is new Alloc
           (Subtype_For_Message_Field_Assignment, Access_To_Subtype_For_Message_Field_Assignment);

         function Allocate_Message_Field_Assignment
           (Pool : Bump_Ptr_Pool) return Bare_Message_Field_Assignment;

         function Allocate_Message_Field_Assignment
           (Pool : Bump_Ptr_Pool) return Bare_Message_Field_Assignment
         is
            Result      : constant Access_To_Subtype_For_Message_Field_Assignment := Bare_Message_Field_Assignment_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Message_Field_Assignment;
            return Bare_Message_Field_Assignment (Result);
         end Allocate_Message_Field_Assignment;

      package Bare_Reset_Memos is new Langkit_Support.Packrat
        (Bare_Reset, Token_Index);

         
         subtype Subtype_For_Reset is
            Root_Node_Record (Rflx_Reset);
         type Access_To_Subtype_For_Reset is access all Subtype_For_Reset;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Reset);
         package Bare_Reset_Alloc is new Alloc
           (Subtype_For_Reset, Access_To_Subtype_For_Reset);

         function Allocate_Reset
           (Pool : Bump_Ptr_Pool) return Bare_Reset;

         function Allocate_Reset
           (Pool : Bump_Ptr_Pool) return Bare_Reset
         is
            Result      : constant Access_To_Subtype_For_Reset := Bare_Reset_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Reset;
            return Bare_Reset (Result);
         end Allocate_Reset;

      package Bare_Term_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Term_Assoc, Token_Index);

         
         subtype Subtype_For_Term_Assoc is
            Root_Node_Record (Rflx_Term_Assoc);
         type Access_To_Subtype_For_Term_Assoc is access all Subtype_For_Term_Assoc;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Term_Assoc);
         package Bare_Term_Assoc_Alloc is new Alloc
           (Subtype_For_Term_Assoc, Access_To_Subtype_For_Term_Assoc);

         function Allocate_Term_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Term_Assoc;

         function Allocate_Term_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Term_Assoc
         is
            Result      : constant Access_To_Subtype_For_Term_Assoc := Bare_Term_Assoc_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Term_Assoc;
            return Bare_Term_Assoc (Result);
         end Allocate_Term_Assoc;

      package Bare_Then_Node_Memos is new Langkit_Support.Packrat
        (Bare_Then_Node, Token_Index);

         
         subtype Subtype_For_Then_Node is
            Root_Node_Record (Rflx_Then_Node);
         type Access_To_Subtype_For_Then_Node is access all Subtype_For_Then_Node;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Then_Node);
         package Bare_Then_Node_Alloc is new Alloc
           (Subtype_For_Then_Node, Access_To_Subtype_For_Then_Node);

         function Allocate_Then_Node
           (Pool : Bump_Ptr_Pool) return Bare_Then_Node;

         function Allocate_Then_Node
           (Pool : Bump_Ptr_Pool) return Bare_Then_Node
         is
            Result      : constant Access_To_Subtype_For_Then_Node := Bare_Then_Node_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Then_Node;
            return Bare_Then_Node (Result);
         end Allocate_Then_Node;

      package Bare_Transition_Memos is new Langkit_Support.Packrat
        (Bare_Transition, Token_Index);

         
         subtype Subtype_For_Transition is
            Root_Node_Record (Rflx_Transition);
         type Access_To_Subtype_For_Transition is access all Subtype_For_Transition;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Transition);
         package Bare_Transition_Alloc is new Alloc
           (Subtype_For_Transition, Access_To_Subtype_For_Transition);

         function Allocate_Transition
           (Pool : Bump_Ptr_Pool) return Bare_Transition;

         function Allocate_Transition
           (Pool : Bump_Ptr_Pool) return Bare_Transition
         is
            Result      : constant Access_To_Subtype_For_Transition := Bare_Transition_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Transition;
            return Bare_Transition (Result);
         end Allocate_Transition;

      package Bare_Conditional_Transition_Memos is new Langkit_Support.Packrat
        (Bare_Conditional_Transition, Token_Index);

         
         subtype Subtype_For_Conditional_Transition is
            Root_Node_Record (Rflx_Conditional_Transition);
         type Access_To_Subtype_For_Conditional_Transition is access all Subtype_For_Conditional_Transition;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Conditional_Transition);
         package Bare_Conditional_Transition_Alloc is new Alloc
           (Subtype_For_Conditional_Transition, Access_To_Subtype_For_Conditional_Transition);

         function Allocate_Conditional_Transition
           (Pool : Bump_Ptr_Pool) return Bare_Conditional_Transition;

         function Allocate_Conditional_Transition
           (Pool : Bump_Ptr_Pool) return Bare_Conditional_Transition
         is
            Result      : constant Access_To_Subtype_For_Conditional_Transition := Bare_Conditional_Transition_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Conditional_Transition;
            return Bare_Conditional_Transition (Result);
         end Allocate_Conditional_Transition;

      package Bare_Type_Argument_Memos is new Langkit_Support.Packrat
        (Bare_Type_Argument, Token_Index);

         
         subtype Subtype_For_Type_Argument is
            Root_Node_Record (Rflx_Type_Argument);
         type Access_To_Subtype_For_Type_Argument is access all Subtype_For_Type_Argument;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Type_Argument);
         package Bare_Type_Argument_Alloc is new Alloc
           (Subtype_For_Type_Argument, Access_To_Subtype_For_Type_Argument);

         function Allocate_Type_Argument
           (Pool : Bump_Ptr_Pool) return Bare_Type_Argument;

         function Allocate_Type_Argument
           (Pool : Bump_Ptr_Pool) return Bare_Type_Argument
         is
            Result      : constant Access_To_Subtype_For_Type_Argument := Bare_Type_Argument_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Type_Argument;
            return Bare_Type_Argument (Result);
         end Allocate_Type_Argument;

      package Bare_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Type_Def, Token_Index);

      package Bare_Abstract_Message_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_Message_Type_Def, Token_Index);

      package Bare_Message_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Message_Type_Def, Token_Index);

         
         subtype Subtype_For_Message_Type_Def is
            Root_Node_Record (Rflx_Message_Type_Def);
         type Access_To_Subtype_For_Message_Type_Def is access all Subtype_For_Message_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Message_Type_Def);
         package Bare_Message_Type_Def_Alloc is new Alloc
           (Subtype_For_Message_Type_Def, Access_To_Subtype_For_Message_Type_Def);

         function Allocate_Message_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Message_Type_Def;

         function Allocate_Message_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Message_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Message_Type_Def := Bare_Message_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Message_Type_Def;
            return Bare_Message_Type_Def (Result);
         end Allocate_Message_Type_Def;

      package Bare_Null_Message_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Null_Message_Type_Def, Token_Index);

         
         subtype Subtype_For_Null_Message_Type_Def is
            Root_Node_Record (Rflx_Null_Message_Type_Def);
         type Access_To_Subtype_For_Null_Message_Type_Def is access all Subtype_For_Null_Message_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Message_Type_Def);
         package Bare_Null_Message_Type_Def_Alloc is new Alloc
           (Subtype_For_Null_Message_Type_Def, Access_To_Subtype_For_Null_Message_Type_Def);

         function Allocate_Null_Message_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Null_Message_Type_Def;

         function Allocate_Null_Message_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Null_Message_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Null_Message_Type_Def := Bare_Null_Message_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Null_Message_Type_Def;
            return Bare_Null_Message_Type_Def (Result);
         end Allocate_Null_Message_Type_Def;

      package Bare_Enumeration_Def_Memos is new Langkit_Support.Packrat
        (Bare_Enumeration_Def, Token_Index);

      package Bare_Named_Enumeration_Def_Memos is new Langkit_Support.Packrat
        (Bare_Named_Enumeration_Def, Token_Index);

         
         subtype Subtype_For_Named_Enumeration_Def is
            Root_Node_Record (Rflx_Named_Enumeration_Def);
         type Access_To_Subtype_For_Named_Enumeration_Def is access all Subtype_For_Named_Enumeration_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Named_Enumeration_Def);
         package Bare_Named_Enumeration_Def_Alloc is new Alloc
           (Subtype_For_Named_Enumeration_Def, Access_To_Subtype_For_Named_Enumeration_Def);

         function Allocate_Named_Enumeration_Def
           (Pool : Bump_Ptr_Pool) return Bare_Named_Enumeration_Def;

         function Allocate_Named_Enumeration_Def
           (Pool : Bump_Ptr_Pool) return Bare_Named_Enumeration_Def
         is
            Result      : constant Access_To_Subtype_For_Named_Enumeration_Def := Bare_Named_Enumeration_Def_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Named_Enumeration_Def;
            return Bare_Named_Enumeration_Def (Result);
         end Allocate_Named_Enumeration_Def;

      package Bare_Positional_Enumeration_Def_Memos is new Langkit_Support.Packrat
        (Bare_Positional_Enumeration_Def, Token_Index);

         
         subtype Subtype_For_Positional_Enumeration_Def is
            Root_Node_Record (Rflx_Positional_Enumeration_Def);
         type Access_To_Subtype_For_Positional_Enumeration_Def is access all Subtype_For_Positional_Enumeration_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Positional_Enumeration_Def);
         package Bare_Positional_Enumeration_Def_Alloc is new Alloc
           (Subtype_For_Positional_Enumeration_Def, Access_To_Subtype_For_Positional_Enumeration_Def);

         function Allocate_Positional_Enumeration_Def
           (Pool : Bump_Ptr_Pool) return Bare_Positional_Enumeration_Def;

         function Allocate_Positional_Enumeration_Def
           (Pool : Bump_Ptr_Pool) return Bare_Positional_Enumeration_Def
         is
            Result      : constant Access_To_Subtype_For_Positional_Enumeration_Def := Bare_Positional_Enumeration_Def_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Positional_Enumeration_Def;
            return Bare_Positional_Enumeration_Def (Result);
         end Allocate_Positional_Enumeration_Def;

      package Bare_Enumeration_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Enumeration_Type_Def, Token_Index);

         
         subtype Subtype_For_Enumeration_Type_Def is
            Root_Node_Record (Rflx_Enumeration_Type_Def);
         type Access_To_Subtype_For_Enumeration_Type_Def is access all Subtype_For_Enumeration_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enumeration_Type_Def);
         package Bare_Enumeration_Type_Def_Alloc is new Alloc
           (Subtype_For_Enumeration_Type_Def, Access_To_Subtype_For_Enumeration_Type_Def);

         function Allocate_Enumeration_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Enumeration_Type_Def;

         function Allocate_Enumeration_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Enumeration_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Enumeration_Type_Def := Bare_Enumeration_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Enumeration_Type_Def;
            return Bare_Enumeration_Type_Def (Result);
         end Allocate_Enumeration_Type_Def;

      package Bare_Integer_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Integer_Type_Def, Token_Index);

      package Bare_Modular_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Modular_Type_Def, Token_Index);

         
         subtype Subtype_For_Modular_Type_Def is
            Root_Node_Record (Rflx_Modular_Type_Def);
         type Access_To_Subtype_For_Modular_Type_Def is access all Subtype_For_Modular_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Modular_Type_Def);
         package Bare_Modular_Type_Def_Alloc is new Alloc
           (Subtype_For_Modular_Type_Def, Access_To_Subtype_For_Modular_Type_Def);

         function Allocate_Modular_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Modular_Type_Def;

         function Allocate_Modular_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Modular_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Modular_Type_Def := Bare_Modular_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Modular_Type_Def;
            return Bare_Modular_Type_Def (Result);
         end Allocate_Modular_Type_Def;

      package Bare_Range_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Range_Type_Def, Token_Index);

         
         subtype Subtype_For_Range_Type_Def is
            Root_Node_Record (Rflx_Range_Type_Def);
         type Access_To_Subtype_For_Range_Type_Def is access all Subtype_For_Range_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Range_Type_Def);
         package Bare_Range_Type_Def_Alloc is new Alloc
           (Subtype_For_Range_Type_Def, Access_To_Subtype_For_Range_Type_Def);

         function Allocate_Range_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Range_Type_Def;

         function Allocate_Range_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Range_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Range_Type_Def := Bare_Range_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Range_Type_Def;
            return Bare_Range_Type_Def (Result);
         end Allocate_Range_Type_Def;

      package Bare_Sequence_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Sequence_Type_Def, Token_Index);

         
         subtype Subtype_For_Sequence_Type_Def is
            Root_Node_Record (Rflx_Sequence_Type_Def);
         type Access_To_Subtype_For_Sequence_Type_Def is access all Subtype_For_Sequence_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Sequence_Type_Def);
         package Bare_Sequence_Type_Def_Alloc is new Alloc
           (Subtype_For_Sequence_Type_Def, Access_To_Subtype_For_Sequence_Type_Def);

         function Allocate_Sequence_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Sequence_Type_Def;

         function Allocate_Sequence_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Sequence_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Sequence_Type_Def := Bare_Sequence_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Sequence_Type_Def;
            return Bare_Sequence_Type_Def (Result);
         end Allocate_Sequence_Type_Def;

      package Bare_Type_Derivation_Def_Memos is new Langkit_Support.Packrat
        (Bare_Type_Derivation_Def, Token_Index);

         
         subtype Subtype_For_Type_Derivation_Def is
            Root_Node_Record (Rflx_Type_Derivation_Def);
         type Access_To_Subtype_For_Type_Derivation_Def is access all Subtype_For_Type_Derivation_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Type_Derivation_Def);
         package Bare_Type_Derivation_Def_Alloc is new Alloc
           (Subtype_For_Type_Derivation_Def, Access_To_Subtype_For_Type_Derivation_Def);

         function Allocate_Type_Derivation_Def
           (Pool : Bump_Ptr_Pool) return Bare_Type_Derivation_Def;

         function Allocate_Type_Derivation_Def
           (Pool : Bump_Ptr_Pool) return Bare_Type_Derivation_Def
         is
            Result      : constant Access_To_Subtype_For_Type_Derivation_Def := Bare_Type_Derivation_Def_Alloc.Alloc (Pool);
            Result_Kind : R_F_L_X_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Rflx_Type_Derivation_Def;
            return Bare_Type_Derivation_Def (Result);
         end Allocate_Type_Derivation_Def;

   pragma Warnings (On, "is not referenced");

   type Dontskip_Parser_Function is access function
     (Parser : in out Parser_Type;
      Pos    : Token_Index) return Bare_R_F_L_X_Node;

   package Dont_Skip_Fn_Vectors
   is new Ada.Containers.Vectors (Natural, Dontskip_Parser_Function);

   type Free_Parse_List_Record;
   type Free_Parse_List is access all Free_Parse_List_Record;
   --  Cache of temporary lists of AST nodes used in List parsers

   type Free_Parse_List_Record is record
      Nodes : Bare_R_F_L_X_Node_Vectors.Vector;
      Next  : Free_Parse_List;
   end record;

   type Parser_Private_Part_Type is record
      Parse_Lists : Free_Parse_List;

      
      Action_Or_Parse0_Memo : Bare_Statement_Memos.Memo_Type;
      
      Aspect_Transform_Parse0_Memo : Bare_Aspect_Memos.Memo_Type;
      
      Assignment_Statement_Transform_Parse0_Memo : Bare_Assignment_Memos.Memo_Type;
      
      Attribute_Statement_Or_Parse0_Memo : Bare_Statement_Memos.Memo_Type;
      
      Basic_Declaration_Or_Parse0_Memo : Bare_Declaration_Memos.Memo_Type;
      
      Basic_Declarations_Extract_Parse0_Memo : Bare_Declaration_List_Memos.Memo_Type;
      
      Byte_Order_Aspect_Transform_Parse2_Memo : Bare_Byte_Order_Aspect_Memos.Memo_Type;
      
      Call_Transform_Parse0_Memo : Bare_Call_Memos.Memo_Type;
      
      Channel_Declaration_Transform_Parse2_Memo : Bare_Formal_Channel_Decl_Memos.Memo_Type;
      
      Checksum_Aspect_Transform_Parse0_Memo : Bare_Checksum_Aspect_Memos.Memo_Type;
      
      Checksum_Association_Transform_Parse1_Memo : Bare_Checksum_Assoc_Memos.Memo_Type;
      
      Comprehension_Transform_Parse0_Memo : Bare_Comprehension_Memos.Memo_Type;
      
      Concatenation_Or_Parse2_Memo : Bare_Sequence_Literal_Memos.Memo_Type;
      
      Conditional_Transition_Transform_Parse0_Memo : Bare_Conditional_Transition_Memos.Memo_Type;
      
      Context_Clause_List_Parse0_Memo : Bare_Context_Item_List_Memos.Memo_Type;
      
      Context_Item_Transform_Parse0_Memo : Bare_Context_Item_Memos.Memo_Type;
      
      Conversion_Transform_Parse0_Memo : Bare_Conversion_Memos.Memo_Type;
      
      Declaration_Or_Parse0_Memo : Bare_Local_Decl_Memos.Memo_Type;
      
      Description_Aspect_Transform_Parse0_Memo : Bare_Description_Memos.Memo_Type;
      
      Element_Value_Association_Transform_Parse0_Memo : Bare_Element_Value_Assoc_Memos.Memo_Type;
      
      Enumeration_Aspects_List_Parse0_Memo : Bare_Aspect_List_Memos.Memo_Type;
      
      Enumeration_Type_Definition_Transform_Parse0_Memo : Bare_Enumeration_Type_Def_Memos.Memo_Type;
      
      Expression_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Case_Expression_Transform_Parse0_Memo : Bare_Case_Expression_Memos.Memo_Type;
      
      Extended_Choice_List_List_Parse0_Memo : Bare_R_F_L_X_Node_List_Memos.Memo_Type;
      
      Extended_Choices_Transform_Parse0_Memo : Bare_Choice_Memos.Memo_Type;
      
      Extended_Expression_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Factor_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_If_Condition_Extract_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Paren_Expression_Transform_Parse0_Memo : Bare_Paren_Expression_Memos.Memo_Type;
      
      Extended_Primary_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Relation_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Simple_Expr_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Suffix_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Term_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Unop_Term_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Factor_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Formal_Function_Declaration_Transform_Parse0_Memo : Bare_Formal_Function_Decl_Memos.Memo_Type;
      
      If_Condition_Extract_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Integer_Type_Definition_Or_Parse0_Memo : Bare_Integer_Type_Def_Memos.Memo_Type;
      
      List_Attribute_Transform_Parse4_Memo : Bare_Attribute_Statement_Memos.Memo_Type;
      
      Main_Rule_Defer_Parse0_Memo : Bare_Specification_Memos.Memo_Type;
      
      Message_Aggregate_Association_List_Transform_Parse0_Memo : Bare_Message_Aggregate_Associations_Memos.Memo_Type;
      
      Message_Aggregate_Association_Transform_Parse0_Memo : Bare_Message_Aggregate_Association_Memos.Memo_Type;
      
      Message_Aggregate_Transform_Parse0_Memo : Bare_Message_Aggregate_Memos.Memo_Type;
      
      Message_Aspect_List_List_Parse0_Memo : Bare_Message_Aspect_List_Memos.Memo_Type;
      
      Message_Field_Assignment_Statement_Transform_Parse0_Memo : Bare_Message_Field_Assignment_Memos.Memo_Type;
      
      Message_Field_List_Transform_Parse0_Memo : Bare_Message_Fields_Memos.Memo_Type;
      
      Message_Field_Transform_Parse0_Memo : Bare_Message_Field_Memos.Memo_Type;
      
      Message_Type_Definition_Or_Parse0_Memo : Bare_Abstract_Message_Type_Def_Memos.Memo_Type;
      
      Modular_Type_Definition_Transform_Parse0_Memo : Bare_Modular_Type_Def_Memos.Memo_Type;
      
      Named_Enumeration_Transform_Parse0_Memo : Bare_Named_Enumeration_Def_Memos.Memo_Type;
      
      Null_Message_Aggregate_Transform_Parse0_Memo : Bare_Null_Message_Aggregate_Memos.Memo_Type;
      
      Null_Message_Field_Transform_Parse0_Memo : Bare_Null_Message_Field_Memos.Memo_Type;
      
      Numeric_Literal_Transform_Parse0_Memo : Bare_Numeric_Literal_Memos.Memo_Type;
      
      Package_Declaration_Transform_Parse0_Memo : Bare_Package_Node_Memos.Memo_Type;
      
      Parameter_List_Transform_Parse0_Memo : Bare_Parameters_Memos.Memo_Type;
      
      Parameter_Transform_Parse0_Memo : Bare_Parameter_Memos.Memo_Type;
      
      Paren_Expression_Transform_Parse0_Memo : Bare_Paren_Expression_Memos.Memo_Type;
      
      Positional_Enumeration_Transform_Parse0_Memo : Bare_Positional_Enumeration_Def_Memos.Memo_Type;
      
      Primary_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Qualified_Identifier_Transform_Parse0_Memo : Bare_I_D_Memos.Memo_Type;
      
      Quantified_Expression_Transform_Parse2_Memo : Bare_Quantified_Expression_Memos.Memo_Type;
      
      Range_Type_Definition_Transform_Parse0_Memo : Bare_Range_Type_Def_Memos.Memo_Type;
      
      Relation_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Renaming_Declaration_Transform_Parse0_Memo : Bare_Renaming_Decl_Memos.Memo_Type;
      
      Reset_Transform_Parse0_Memo : Bare_Reset_Memos.Memo_Type;
      
      Sequence_Aggregate_Transform_Parse0_Memo : Bare_Sequence_Aggregate_Memos.Memo_Type;
      
      Sequence_Type_Definition_Transform_Parse0_Memo : Bare_Sequence_Type_Def_Memos.Memo_Type;
      
      Session_Declaration_Transform_Parse0_Memo : Bare_Session_Decl_Memos.Memo_Type;
      
      Session_Parameter_Or_Parse0_Memo : Bare_Formal_Decl_Memos.Memo_Type;
      
      Simple_Expr_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Specification_Transform_Parse0_Memo : Bare_Specification_Memos.Memo_Type;
      
      State_Body_Transform_Parse0_Memo : Bare_State_Body_Memos.Memo_Type;
      
      State_Transform_Parse0_Memo : Bare_State_Memos.Memo_Type;
      
      String_Literal_Transform_Parse0_Memo : Bare_String_Literal_Memos.Memo_Type;
      
      Suffix_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Term_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Then_Transform_Parse0_Memo : Bare_Then_Node_Memos.Memo_Type;
      
      Transition_Transform_Parse0_Memo : Bare_Transition_Memos.Memo_Type;
      
      Type_Argument_Transform_Parse0_Memo : Bare_Type_Argument_Memos.Memo_Type;
      
      Type_Declaration_Transform_Parse0_Memo : Bare_Type_Decl_Memos.Memo_Type;
      
      Type_Derivation_Definition_Transform_Parse0_Memo : Bare_Type_Derivation_Def_Memos.Memo_Type;
      
      Type_Refinement_Transform_Parse0_Memo : Bare_Refinement_Decl_Memos.Memo_Type;
      
      Unop_Term_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Unqualified_Identifier_Transform_Parse0_Memo : Bare_Unqualified_I_D_Memos.Memo_Type;
      
      Value_Range_Transform_Parse0_Memo : Bare_Checksum_Value_Range_Memos.Memo_Type;
      
      Variable_Declaration_Transform_Parse0_Memo : Bare_Variable_Decl_Memos.Memo_Type;
      
      Variable_Transform_Parse0_Memo : Bare_Variable_Memos.Memo_Type;

      Dont_Skip : Dont_Skip_Fn_Vectors.Vector;
   end record;

   
function Action_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Statement;

   
function Aspect_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect;

   
function Assignment_Statement_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Assignment;

   
function Attribute_Statement_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Statement;

   
function Basic_Declaration_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Declaration;

   
function Basic_Declarations_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Declaration_List;

   
function Byte_Order_Aspect_Transform_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Byte_Order_Aspect;

   
function Call_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Call;

   
function Channel_Declaration_Transform_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Channel_Decl;

   
function Checksum_Aspect_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Checksum_Aspect;

   
function Checksum_Association_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Checksum_Assoc;

   
function Comprehension_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Comprehension;

   
function Concatenation_Or_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Sequence_Literal;

   
function Conditional_Transition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Conditional_Transition;

   
function Context_Clause_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Context_Item_List;

   
function Context_Item_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Context_Item;

   
function Conversion_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Conversion;

   
function Declaration_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Local_Decl;

   
function Description_Aspect_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Description;

   
function Element_Value_Association_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Element_Value_Assoc;

   
function Enumeration_Aspects_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_List;

   
function Enumeration_Type_Definition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Enumeration_Type_Def;

   
function Expression_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Case_Expression_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Expression;

   
function Extended_Choice_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_R_F_L_X_Node_List;

   
function Extended_Choices_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Choice;

   
function Extended_Expression_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Factor_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_If_Condition_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Paren_Expression_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Paren_Expression;

   
function Extended_Primary_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Relation_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Simple_Expr_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Suffix_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Term_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Unop_Term_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Factor_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Formal_Function_Declaration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Function_Decl;

   
function If_Condition_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Integer_Type_Definition_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Integer_Type_Def;

   
function List_Attribute_Transform_Parse4
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Attribute_Statement;

   
function Main_Rule_Defer_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Specification;

   
function Message_Aggregate_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aggregate;

   
function Message_Aggregate_Association_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aggregate_Association;

   
function Message_Aggregate_Association_List_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aggregate_Associations;

   
function Message_Aspect_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aspect_List;

   
function Message_Field_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Field;

   
function Message_Field_Assignment_Statement_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Field_Assignment;

   
function Message_Field_List_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Fields;

   
function Message_Type_Definition_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Abstract_Message_Type_Def;

   
function Modular_Type_Definition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Modular_Type_Def;

   
function Named_Enumeration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Named_Enumeration_Def;

   
function Null_Message_Aggregate_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Message_Aggregate;

   
function Null_Message_Field_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Message_Field;

   
function Numeric_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Numeric_Literal;

   
function Package_Declaration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Package_Node;

   
function Parameter_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Parameter;

   
function Parameter_List_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Parameters;

   
function Paren_Expression_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Paren_Expression;

   
function Positional_Enumeration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Positional_Enumeration_Def;

   
function Primary_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Qualified_Identifier_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_I_D;

   
function Quantified_Expression_Transform_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Quantified_Expression;

   
function Range_Type_Definition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Range_Type_Def;

   
function Relation_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Renaming_Declaration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Renaming_Decl;

   
function Reset_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Reset;

   
function Sequence_Aggregate_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Sequence_Aggregate;

   
function Sequence_Type_Definition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Sequence_Type_Def;

   
function Session_Declaration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Session_Decl;

   
function Session_Parameter_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Decl;

   
function Simple_Expr_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Specification_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Specification;

   
function State_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_State;

   
function State_Body_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_State_Body;

   
function String_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_String_Literal;

   
function Suffix_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Term_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Then_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Then_Node;

   
function Transition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Transition;

   
function Type_Argument_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Argument;

   
function Type_Declaration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Decl;

   
function Type_Derivation_Definition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Derivation_Def;

   
function Type_Refinement_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Refinement_Decl;

   
function Unop_Term_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Unqualified_Identifier_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Unqualified_I_D;

   
function Value_Range_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Checksum_Value_Range;

   
function Variable_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Variable;

   
function Variable_Declaration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Variable_Decl;


   procedure Process_Parsing_Error
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True);
   --  Helper for the user parsing function, to be called after a low-level
   --  parsing function. Check_Complete has the same semantics as in Parse. If
   --  the parsing failed (Parser.Current_Pos = No_Token_Index), append
   --  corresponding diagnostics to Parser.Diagnostics, do nothing instead.

   procedure Add_Last_Fail_Diagnostic (Parser : in out Parser_Type);
   --  Add a diagnostic for the last fail position of the parser

   pragma Warnings (Off, "is not referenced");

   function Get_Parse_List (Parser : Parser_Type) return Free_Parse_List;
   --  Get a free parse list, or allocate one if there is no free parse list in
   --  Parser. When done with the result, the caller must invoke
   --  Release_Parse_List.

   procedure Release_Parse_List
     (Parser : Parser_Type; List : in out Free_Parse_List);
   --  Release a parse list, putting it in Parsers' free list. Set List to
   --  null.

   procedure Initialize_List
     (Self   : Bare_R_F_L_X_Node_Base_List;
      Parser : Parser_Type;
      Count  : Natural);
   --  Helper for parsers, to initialize the list of children in a freshly
   --  allocated list node.

   pragma Warnings (On, "is not referenced");

   ---------------------
   -- Initialize_List --
   ---------------------

   procedure Initialize_List
     (Self   : Bare_R_F_L_X_Node_Base_List;
      Parser : Parser_Type;
      Count  : Natural) is
   begin
      Self.Count := Count;
      Self.Nodes := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, 0);
   end Initialize_List;

   -----------------
   -- Init_Parser --
   -----------------

   procedure Init_Parser
     (Input       : Internal_Lexer_Input;
      With_Trivia : Boolean;
      Unit        : access Implementation.Analysis_Unit_Type;
      TDH         : Token_Data_Handler_Access;
      Parser      : in out Parser_Type)
   is
      --  Never try to use file readers for internal units: these are generally
      --  not actual source files, and file readers, which are external users
      --  of the generated library, have no reason to be aware of them.

      FR : constant Internal_File_Reader_Access :=
        (if Unit.Is_Internal
         then null
         else Unit.Context.File_Reader);
   begin
      Reset (Parser);
      Extract_Tokens (Input, With_Trivia, FR, TDH.all, Parser.Diagnostics);
      Parser.Unit := Unit;
      Parser.TDH := TDH;
   end Init_Parser;

   ------------------------------
   -- Add_Last_Fail_Diagnostic --
   ------------------------------

   procedure Add_Last_Fail_Diagnostic (Parser : in out Parser_Type)
   is
      Last_Token : Stored_Token_Data renames
         Get_Token (Parser.TDH.all, Parser.Last_Fail.Pos);
      D : constant Diagnostic :=
        (if Parser.Last_Fail.Kind = Token_Fail then
          Create (Sloc_Range (Parser.TDH.all, Last_Token), To_Text
            ("Expected "
             & Token_Error_Image (Parser.Last_Fail.Expected_Token_Id)
             & ", got "
             & Token_Error_Image (Parser.Last_Fail.Found_Token_Id)))
         else
           Create (Sloc_Range (Parser.TDH.all, Last_Token),
                   To_Text (Parser.Last_Fail.Custom_Message.all)));
   begin
      Parser.Diagnostics.Append (D);
   end Add_Last_Fail_Diagnostic;

   ---------------------------
   -- Process_Parsing_Error --
   ---------------------------

   procedure Process_Parsing_Error
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True) is
   begin

      if Parser.Current_Pos = No_Token_Index then
         Add_Last_Fail_Diagnostic (Parser);
      elsif Check_Complete
        and then Parser.Current_Pos /= Last_Token (Parser.TDH.all)
      then
         --  If the fail pos is the current position of the parser or after,
         --  it means that the longest parse is the correct result, and that we
         --  have some garbage afterwards.
         if Parser.Current_Pos >= Parser.Last_Fail.Pos then
            declare
               First_Garbage_Token : Stored_Token_Data renames
                  Get_Token (Parser.TDH.all, Parser.Current_Pos);
            begin
               Append
                 (Parser.Diagnostics,
                  Sloc_Range (Parser.TDH.all, First_Garbage_Token),
                  To_Text
                    ("End of input expected, got """
                     & Token_Kind_Name
                         (To_Token_Kind (First_Garbage_Token.Kind))
                     & """"));
            end;

         --  Else, the last fail pos is further down the line, and we want to
         --  have the diagnostic of what exactly failed.
         else
            Add_Last_Fail_Diagnostic (Parser);
         end if;
      end if;

   end Process_Parsing_Error;

   -----------
   -- Parse --
   -----------

   function Parse
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True;
      Rule           : Grammar_Rule) return Parsed_Node
   is
      Result : Bare_R_F_L_X_Node;
   begin
      case Rule is
         when Main_Rule_Rule =>
            Result := Main_Rule_Defer_Parse0
              (Parser, First_Token_Index);
         when Unqualified_Identifier_Rule =>
            Result := Unqualified_Identifier_Transform_Parse0
              (Parser, First_Token_Index);
         when Qualified_Identifier_Rule =>
            Result := Qualified_Identifier_Transform_Parse0
              (Parser, First_Token_Index);
         when Numeric_Literal_Rule =>
            Result := Numeric_Literal_Transform_Parse0
              (Parser, First_Token_Index);
         when Variable_Rule =>
            Result := Variable_Transform_Parse0
              (Parser, First_Token_Index);
         when Sequence_Aggregate_Rule =>
            Result := Sequence_Aggregate_Transform_Parse0
              (Parser, First_Token_Index);
         when String_Literal_Rule =>
            Result := String_Literal_Transform_Parse0
              (Parser, First_Token_Index);
         when Concatenation_Rule =>
            Result := Concatenation_Or_Parse2
              (Parser, First_Token_Index);
         when Primary_Rule =>
            Result := Primary_Or_Parse0
              (Parser, First_Token_Index);
         when Paren_Expression_Rule =>
            Result := Paren_Expression_Transform_Parse0
              (Parser, First_Token_Index);
         when Suffix_Rule =>
            Result := Suffix_Or_Parse1
              (Parser, First_Token_Index);
         when Factor_Rule =>
            Result := Factor_Or_Parse0
              (Parser, First_Token_Index);
         when Term_Rule =>
            Result := Term_Or_Parse1
              (Parser, First_Token_Index);
         when Unop_Term_Rule =>
            Result := Unop_Term_Or_Parse0
              (Parser, First_Token_Index);
         when Simple_Expr_Rule =>
            Result := Simple_Expr_Or_Parse1
              (Parser, First_Token_Index);
         when Relation_Rule =>
            Result := Relation_Or_Parse1
              (Parser, First_Token_Index);
         when Expression_Rule =>
            Result := Expression_Or_Parse1
              (Parser, First_Token_Index);
         when Quantified_Expression_Rule =>
            Result := Quantified_Expression_Transform_Parse2
              (Parser, First_Token_Index);
         when Comprehension_Rule =>
            Result := Comprehension_Transform_Parse0
              (Parser, First_Token_Index);
         when Call_Rule =>
            Result := Call_Transform_Parse0
              (Parser, First_Token_Index);
         when Conversion_Rule =>
            Result := Conversion_Transform_Parse0
              (Parser, First_Token_Index);
         when Null_Message_Aggregate_Rule =>
            Result := Null_Message_Aggregate_Transform_Parse0
              (Parser, First_Token_Index);
         when Message_Aggregate_Association_Rule =>
            Result := Message_Aggregate_Association_Transform_Parse0
              (Parser, First_Token_Index);
         when Message_Aggregate_Association_List_Rule =>
            Result := Message_Aggregate_Association_List_Transform_Parse0
              (Parser, First_Token_Index);
         when Message_Aggregate_Rule =>
            Result := Message_Aggregate_Transform_Parse0
              (Parser, First_Token_Index);
         when Extended_Primary_Rule =>
            Result := Extended_Primary_Or_Parse0
              (Parser, First_Token_Index);
         when Extended_Paren_Expression_Rule =>
            Result := Extended_Paren_Expression_Transform_Parse0
              (Parser, First_Token_Index);
         when Extended_Choice_List_Rule =>
            Result := Extended_Choice_List_List_Parse0
              (Parser, First_Token_Index);
         when Extended_Choices_Rule =>
            Result := Extended_Choices_Transform_Parse0
              (Parser, First_Token_Index);
         when Extended_Case_Expression_Rule =>
            Result := Extended_Case_Expression_Transform_Parse0
              (Parser, First_Token_Index);
         when Extended_Suffix_Rule =>
            Result := Extended_Suffix_Or_Parse1
              (Parser, First_Token_Index);
         when Extended_Factor_Rule =>
            Result := Extended_Factor_Or_Parse1
              (Parser, First_Token_Index);
         when Extended_Term_Rule =>
            Result := Extended_Term_Or_Parse1
              (Parser, First_Token_Index);
         when Extended_Unop_Term_Rule =>
            Result := Extended_Unop_Term_Or_Parse0
              (Parser, First_Token_Index);
         when Extended_Simple_Expr_Rule =>
            Result := Extended_Simple_Expr_Or_Parse1
              (Parser, First_Token_Index);
         when Extended_Relation_Rule =>
            Result := Extended_Relation_Or_Parse1
              (Parser, First_Token_Index);
         when Extended_Expression_Rule =>
            Result := Extended_Expression_Or_Parse1
              (Parser, First_Token_Index);
         when Aspect_Rule =>
            Result := Aspect_Transform_Parse0
              (Parser, First_Token_Index);
         when Range_Type_Definition_Rule =>
            Result := Range_Type_Definition_Transform_Parse0
              (Parser, First_Token_Index);
         when Modular_Type_Definition_Rule =>
            Result := Modular_Type_Definition_Transform_Parse0
              (Parser, First_Token_Index);
         when Integer_Type_Definition_Rule =>
            Result := Integer_Type_Definition_Or_Parse0
              (Parser, First_Token_Index);
         when If_Condition_Rule =>
            Result := If_Condition_Extract_Parse0
              (Parser, First_Token_Index);
         when Extended_If_Condition_Rule =>
            Result := Extended_If_Condition_Extract_Parse0
              (Parser, First_Token_Index);
         when Then_Rule =>
            Result := Then_Transform_Parse0
              (Parser, First_Token_Index);
         when Type_Argument_Rule =>
            Result := Type_Argument_Transform_Parse0
              (Parser, First_Token_Index);
         when Null_Message_Field_Rule =>
            Result := Null_Message_Field_Transform_Parse0
              (Parser, First_Token_Index);
         when Message_Field_Rule =>
            Result := Message_Field_Transform_Parse0
              (Parser, First_Token_Index);
         when Message_Field_List_Rule =>
            Result := Message_Field_List_Transform_Parse0
              (Parser, First_Token_Index);
         when Value_Range_Rule =>
            Result := Value_Range_Transform_Parse0
              (Parser, First_Token_Index);
         when Checksum_Association_Rule =>
            Result := Checksum_Association_Transform_Parse1
              (Parser, First_Token_Index);
         when Checksum_Aspect_Rule =>
            Result := Checksum_Aspect_Transform_Parse0
              (Parser, First_Token_Index);
         when Byte_Order_Aspect_Rule =>
            Result := Byte_Order_Aspect_Transform_Parse2
              (Parser, First_Token_Index);
         when Message_Aspect_List_Rule =>
            Result := Message_Aspect_List_List_Parse0
              (Parser, First_Token_Index);
         when Message_Type_Definition_Rule =>
            Result := Message_Type_Definition_Or_Parse0
              (Parser, First_Token_Index);
         when Positional_Enumeration_Rule =>
            Result := Positional_Enumeration_Transform_Parse0
              (Parser, First_Token_Index);
         when Element_Value_Association_Rule =>
            Result := Element_Value_Association_Transform_Parse0
              (Parser, First_Token_Index);
         when Named_Enumeration_Rule =>
            Result := Named_Enumeration_Transform_Parse0
              (Parser, First_Token_Index);
         when Enumeration_Aspects_Rule =>
            Result := Enumeration_Aspects_List_Parse0
              (Parser, First_Token_Index);
         when Enumeration_Type_Definition_Rule =>
            Result := Enumeration_Type_Definition_Transform_Parse0
              (Parser, First_Token_Index);
         when Type_Derivation_Definition_Rule =>
            Result := Type_Derivation_Definition_Transform_Parse0
              (Parser, First_Token_Index);
         when Sequence_Type_Definition_Rule =>
            Result := Sequence_Type_Definition_Transform_Parse0
              (Parser, First_Token_Index);
         when Type_Declaration_Rule =>
            Result := Type_Declaration_Transform_Parse0
              (Parser, First_Token_Index);
         when Type_Refinement_Rule =>
            Result := Type_Refinement_Transform_Parse0
              (Parser, First_Token_Index);
         when Parameter_Rule =>
            Result := Parameter_Transform_Parse0
              (Parser, First_Token_Index);
         when Parameter_List_Rule =>
            Result := Parameter_List_Transform_Parse0
              (Parser, First_Token_Index);
         when Formal_Function_Declaration_Rule =>
            Result := Formal_Function_Declaration_Transform_Parse0
              (Parser, First_Token_Index);
         when Channel_Declaration_Rule =>
            Result := Channel_Declaration_Transform_Parse2
              (Parser, First_Token_Index);
         when Session_Parameter_Rule =>
            Result := Session_Parameter_Or_Parse0
              (Parser, First_Token_Index);
         when Renaming_Declaration_Rule =>
            Result := Renaming_Declaration_Transform_Parse0
              (Parser, First_Token_Index);
         when Variable_Declaration_Rule =>
            Result := Variable_Declaration_Transform_Parse0
              (Parser, First_Token_Index);
         when Declaration_Rule =>
            Result := Declaration_Or_Parse0
              (Parser, First_Token_Index);
         when Description_Aspect_Rule =>
            Result := Description_Aspect_Transform_Parse0
              (Parser, First_Token_Index);
         when Assignment_Statement_Rule =>
            Result := Assignment_Statement_Transform_Parse0
              (Parser, First_Token_Index);
         when Message_Field_Assignment_Statement_Rule =>
            Result := Message_Field_Assignment_Statement_Transform_Parse0
              (Parser, First_Token_Index);
         when List_Attribute_Rule =>
            Result := List_Attribute_Transform_Parse4
              (Parser, First_Token_Index);
         when Reset_Rule =>
            Result := Reset_Transform_Parse0
              (Parser, First_Token_Index);
         when Attribute_Statement_Rule =>
            Result := Attribute_Statement_Or_Parse0
              (Parser, First_Token_Index);
         when Action_Rule =>
            Result := Action_Or_Parse0
              (Parser, First_Token_Index);
         when Conditional_Transition_Rule =>
            Result := Conditional_Transition_Transform_Parse0
              (Parser, First_Token_Index);
         when Transition_Rule =>
            Result := Transition_Transform_Parse0
              (Parser, First_Token_Index);
         when State_Body_Rule =>
            Result := State_Body_Transform_Parse0
              (Parser, First_Token_Index);
         when State_Rule =>
            Result := State_Transform_Parse0
              (Parser, First_Token_Index);
         when Session_Declaration_Rule =>
            Result := Session_Declaration_Transform_Parse0
              (Parser, First_Token_Index);
         when Basic_Declaration_Rule =>
            Result := Basic_Declaration_Or_Parse0
              (Parser, First_Token_Index);
         when Basic_Declarations_Rule =>
            Result := Basic_Declarations_Extract_Parse0
              (Parser, First_Token_Index);
         when Package_Declaration_Rule =>
            Result := Package_Declaration_Transform_Parse0
              (Parser, First_Token_Index);
         when Context_Item_Rule =>
            Result := Context_Item_Transform_Parse0
              (Parser, First_Token_Index);
         when Context_Clause_Rule =>
            Result := Context_Clause_List_Parse0
              (Parser, First_Token_Index);
         when Specification_Rule =>
            Result := Specification_Transform_Parse0
              (Parser, First_Token_Index);
      end case;
      Process_Parsing_Error (Parser, Check_Complete);
      Set_Parents (Result, null);
      return Parsed_Node (Result);
   exception
      when Exc : Property_Error =>
         Append
           (Parser.Diagnostics,
            No_Source_Location_Range,
            To_Text ("Error during parsing: "
                     & Ada.Exceptions.Exception_Message (Exc)));
         return Parsed_Node (No_Bare_R_F_L_X_Node);
   end Parse;

   


function Action_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Statement
is
   use Bare_Statement_Memos;

      Defer_Pos0 :
            Token_Index
               := No_Token_Index;
      Defer_Res0 :
            Bare_Assignment
               := No_Bare_R_F_L_X_Node;
      Defer_Pos1 :
            Token_Index
               := No_Token_Index;
      Defer_Res1 :
            Bare_Message_Field_Assignment
               := No_Bare_R_F_L_X_Node;
      Defer_Pos2 :
            Token_Index
               := No_Token_Index;
      Defer_Res2 :
            Bare_Statement
               := No_Bare_R_F_L_X_Node;
      Or_Pos0 :
            Token_Index
               := No_Token_Index;
      Or_Res0 :
            Bare_Statement
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Action_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res0 := M.Instance;
      return Or_Res0;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res0;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos0 := No_Token_Index;
Or_Res0 := No_Bare_R_F_L_X_Node;
    
Defer_Res0 :=
   Assignment_Statement_Transform_Parse0 (Parser, Pos);
Defer_Pos0 := Parser.Current_Pos;

    if Defer_Pos0 /= No_Token_Index then
        Or_Pos0 := Defer_Pos0;
        Or_Res0 := Defer_Res0;
        goto Exit_Or0;
    end if;
    
Defer_Res1 :=
   Message_Field_Assignment_Statement_Transform_Parse0 (Parser, Pos);
Defer_Pos1 := Parser.Current_Pos;

    if Defer_Pos1 /= No_Token_Index then
        Or_Pos0 := Defer_Pos1;
        Or_Res0 := Defer_Res1;
        goto Exit_Or0;
    end if;
    
Defer_Res2 :=
   Attribute_Statement_Or_Parse0 (Parser, Pos);
Defer_Pos2 := Parser.Current_Pos;

    if Defer_Pos2 /= No_Token_Index then
        Or_Pos0 := Defer_Pos2;
        Or_Res0 := Defer_Res2;
        goto Exit_Or0;
    end if;
<<Exit_Or0>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Action_Or_Parse0_Memo,
      Or_Pos0 /= No_Token_Index,
      Or_Res0,
      Pos,
      Or_Pos0);


   Parser.Current_Pos := Or_Pos0;

   return Or_Res0;
end Action_Or_Parse0;

   


function Aspect_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect
is
   use Bare_Aspect_Memos;

      Row_Pos0 :
            Token_Index
               := No_Token_Index;
      Defer_Pos3 :
            Token_Index
               := No_Token_Index;
      Defer_Res3 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Row_Pos1 :
            Token_Index
               := No_Token_Index;
      Token_Pos0 :
            Token_Index
               := No_Token_Index;
      Token_Res0 :
            Token_Index
               := No_Token_Index;
      Defer_Pos4 :
            Token_Index
               := No_Token_Index;
      Defer_Res4 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res0 :
            Bare_Aspect
               := No_Bare_R_F_L_X_Node;
      Transform_Diags0 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Aspect_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res0 := M.Instance;
      return Transform_Res0;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res0;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags0 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos0 := Pos;



Defer_Res3 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos0);
Defer_Pos3 := Parser.Current_Pos;




if Defer_Pos3 /= No_Token_Index then

   Row_Pos0 := Defer_Pos3;

else
   Row_Pos0 := No_Token_Index;
   goto Exit_Row0_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos1 := Row_Pos0;



--  Start tok_code

Token_Res0 := Row_Pos1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res0));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Arrow)
   then
       Token_Pos0 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos1,
             Expected_Token_Id => Rflx_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos0 := Row_Pos1 + 1;
   end if;
end;

--  End tok_code




if Token_Pos0 /= No_Token_Index then

   Row_Pos1 := Token_Pos0;

else
   Row_Pos1 := No_Token_Index;
   goto Exit_Row1_0;

end if;


Defer_Res4 :=
   Expression_Or_Parse1 (Parser, Row_Pos1);
Defer_Pos4 := Parser.Current_Pos;




if Defer_Pos4 /= No_Token_Index then

   Row_Pos1 := Defer_Pos4;

else
   Row_Pos1 := No_Token_Index;
   goto Exit_Row1_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row1_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos1 = No_Token_Index then

         
   Defer_Res4 := No_Bare_R_F_L_X_Node;



       
   Row_Pos1 := Row_Pos0;



end if;

--  End opt_code




if Row_Pos1 /= No_Token_Index then

   Row_Pos0 := Row_Pos1;

else
   Row_Pos0 := No_Token_Index;
   goto Exit_Row0_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row0_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos0 /= No_Token_Index then

   Transform_Res0 := Allocate_Aspect (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res0,
      Kind => Rflx_Aspect,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos0 = Pos
                            then No_Token_Index
                            else Row_Pos0 - 1));

      Initialize_Fields_For_Aspect
        (Self => Transform_Res0, Aspect_F_Identifier => Defer_Res3, Aspect_F_Value => Defer_Res4);

         if Defer_Res3 /= null and then Is_Incomplete (Defer_Res3) then
            Transform_Res0.Last_Attempted_Child := 0;
         elsif Defer_Res3 /= null and then not Is_Ghost (Defer_Res3) then
            Transform_Res0.Last_Attempted_Child := -1;
         end if;
         if Defer_Res4 /= null and then Is_Incomplete (Defer_Res4) then
            Transform_Res0.Last_Attempted_Child := 0;
         elsif Defer_Res4 /= null and then not Is_Ghost (Defer_Res4) then
            Transform_Res0.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos0 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags0);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Aspect_Transform_Parse0_Memo,
      Row_Pos0 /= No_Token_Index,
      Transform_Res0,
      Pos,
      Row_Pos0);


   Parser.Current_Pos := Row_Pos0;

   return Transform_Res0;
end Aspect_Transform_Parse0;

   


function Assignment_Statement_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Assignment
is
   use Bare_Assignment_Memos;

      Row_Pos2 :
            Token_Index
               := No_Token_Index;
      Defer_Pos5 :
            Token_Index
               := No_Token_Index;
      Defer_Res5 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos1 :
            Token_Index
               := No_Token_Index;
      Token_Res1 :
            Token_Index
               := No_Token_Index;
      Defer_Pos6 :
            Token_Index
               := No_Token_Index;
      Defer_Res6 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res1 :
            Bare_Assignment
               := No_Bare_R_F_L_X_Node;
      Transform_Diags1 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Assignment_Statement_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res1 := M.Instance;
      return Transform_Res1;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res1;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags1 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos2 := Pos;



Defer_Res5 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos2);
Defer_Pos5 := Parser.Current_Pos;




if Defer_Pos5 /= No_Token_Index then

   Row_Pos2 := Defer_Pos5;

else
   Row_Pos2 := No_Token_Index;
   goto Exit_Row2_0;

end if;


--  Start tok_code

Token_Res1 := Row_Pos2;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res1));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Assignment)
   then
       Token_Pos1 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos2 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos2,
             Expected_Token_Id => Rflx_Assignment,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos1 := Row_Pos2 + 1;
   end if;
end;

--  End tok_code




if Token_Pos1 /= No_Token_Index then

   Row_Pos2 := Token_Pos1;

else
   Row_Pos2 := No_Token_Index;
   goto Exit_Row2_0;

end if;


Defer_Res6 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos2);
Defer_Pos6 := Parser.Current_Pos;




if Defer_Pos6 /= No_Token_Index then

   Row_Pos2 := Defer_Pos6;

else
   Row_Pos2 := No_Token_Index;
   goto Exit_Row2_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row2_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos2 /= No_Token_Index then

   Transform_Res1 := Allocate_Assignment (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res1,
      Kind => Rflx_Assignment,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos2 = Pos
                            then No_Token_Index
                            else Row_Pos2 - 1));

      Initialize_Fields_For_Assignment
        (Self => Transform_Res1, Assignment_F_Identifier => Defer_Res5, Assignment_F_Expression => Defer_Res6);

         if Defer_Res5 /= null and then Is_Incomplete (Defer_Res5) then
            Transform_Res1.Last_Attempted_Child := 0;
         elsif Defer_Res5 /= null and then not Is_Ghost (Defer_Res5) then
            Transform_Res1.Last_Attempted_Child := -1;
         end if;
         if Defer_Res6 /= null and then Is_Incomplete (Defer_Res6) then
            Transform_Res1.Last_Attempted_Child := 0;
         elsif Defer_Res6 /= null and then not Is_Ghost (Defer_Res6) then
            Transform_Res1.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos2 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags1);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Assignment_Statement_Transform_Parse0_Memo,
      Row_Pos2 /= No_Token_Index,
      Transform_Res1,
      Pos,
      Row_Pos2);


   Parser.Current_Pos := Row_Pos2;

   return Transform_Res1;
end Assignment_Statement_Transform_Parse0;

   


function Attribute_Statement_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Statement
is
   use Bare_Statement_Memos;

      Defer_Pos7 :
            Token_Index
               := No_Token_Index;
      Defer_Res7 :
            Bare_Attribute_Statement
               := No_Bare_R_F_L_X_Node;
      Defer_Pos8 :
            Token_Index
               := No_Token_Index;
      Defer_Res8 :
            Bare_Reset
               := No_Bare_R_F_L_X_Node;
      Or_Pos1 :
            Token_Index
               := No_Token_Index;
      Or_Res1 :
            Bare_Statement
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Attribute_Statement_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res1 := M.Instance;
      return Or_Res1;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res1;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos1 := No_Token_Index;
Or_Res1 := No_Bare_R_F_L_X_Node;
    
Defer_Res7 :=
   List_Attribute_Transform_Parse4 (Parser, Pos);
Defer_Pos7 := Parser.Current_Pos;

    if Defer_Pos7 /= No_Token_Index then
        Or_Pos1 := Defer_Pos7;
        Or_Res1 := Defer_Res7;
        goto Exit_Or1;
    end if;
    
Defer_Res8 :=
   Reset_Transform_Parse0 (Parser, Pos);
Defer_Pos8 := Parser.Current_Pos;

    if Defer_Pos8 /= No_Token_Index then
        Or_Pos1 := Defer_Pos8;
        Or_Res1 := Defer_Res8;
        goto Exit_Or1;
    end if;
<<Exit_Or1>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Attribute_Statement_Or_Parse0_Memo,
      Or_Pos1 /= No_Token_Index,
      Or_Res1,
      Pos,
      Or_Pos1);


   Parser.Current_Pos := Or_Pos1;

   return Or_Res1;
end Attribute_Statement_Or_Parse0;

   


function Basic_Declaration_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Declaration
is
   use Bare_Declaration_Memos;

      Defer_Pos9 :
            Token_Index
               := No_Token_Index;
      Defer_Res9 :
            Bare_Type_Decl
               := No_Bare_R_F_L_X_Node;
      Defer_Pos10 :
            Token_Index
               := No_Token_Index;
      Defer_Res10 :
            Bare_Refinement_Decl
               := No_Bare_R_F_L_X_Node;
      Defer_Pos11 :
            Token_Index
               := No_Token_Index;
      Defer_Res11 :
            Bare_Session_Decl
               := No_Bare_R_F_L_X_Node;
      Or_Pos2 :
            Token_Index
               := No_Token_Index;
      Or_Res2 :
            Bare_Declaration
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Basic_Declaration_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res2 := M.Instance;
      return Or_Res2;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res2;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos2 := No_Token_Index;
Or_Res2 := No_Bare_R_F_L_X_Node;
    
Defer_Res9 :=
   Type_Declaration_Transform_Parse0 (Parser, Pos);
Defer_Pos9 := Parser.Current_Pos;

    if Defer_Pos9 /= No_Token_Index then
        Or_Pos2 := Defer_Pos9;
        Or_Res2 := Defer_Res9;
        goto Exit_Or2;
    end if;
    
Defer_Res10 :=
   Type_Refinement_Transform_Parse0 (Parser, Pos);
Defer_Pos10 := Parser.Current_Pos;

    if Defer_Pos10 /= No_Token_Index then
        Or_Pos2 := Defer_Pos10;
        Or_Res2 := Defer_Res10;
        goto Exit_Or2;
    end if;
    
Defer_Res11 :=
   Session_Declaration_Transform_Parse0 (Parser, Pos);
Defer_Pos11 := Parser.Current_Pos;

    if Defer_Pos11 /= No_Token_Index then
        Or_Pos2 := Defer_Pos11;
        Or_Res2 := Defer_Res11;
        goto Exit_Or2;
    end if;
<<Exit_Or2>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Basic_Declaration_Or_Parse0_Memo,
      Or_Pos2 /= No_Token_Index,
      Or_Res2,
      Pos,
      Or_Pos2);


   Parser.Current_Pos := Or_Pos2;

   return Or_Res2;
end Basic_Declaration_Or_Parse0;

   


function Basic_Declarations_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Declaration_List
is
   use Bare_Declaration_List_Memos;

      Row_Pos3 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos0 :
            Token_Index
               := No_Token_Index;
      Tmp_List0 :
            Free_Parse_List;
      Defer_Pos12 :
            Token_Index
               := No_Token_Index;
      Defer_Res12 :
            Bare_Declaration
               := No_Bare_R_F_L_X_Node;
      Token_Pos2 :
            Token_Index
               := No_Token_Index;
      Token_Res2 :
            Token_Index
               := No_Token_Index;
      List_Pos0 :
            Token_Index
               := No_Token_Index;
      List_Res0 :
            Bare_Declaration_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos3 :
            Token_Index
               := No_Token_Index;
      Token_Res3 :
            Token_Index
               := No_Token_Index;


   M : Memo_Entry := Get (Parser.Private_Part.Basic_Declarations_Extract_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res0 := M.Instance;
      return List_Res0;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res0;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start row_code

Row_Pos3 := Pos;



--  Start list_code

    List_Pos0 := No_Token_Index;



Lst_Cpos0 := Row_Pos3;
Tmp_List0 := Get_Parse_List (Parser);

loop
   
Defer_Res12 :=
   Basic_Declaration_Or_Parse0 (Parser, Lst_Cpos0);
Defer_Pos12 := Parser.Current_Pos;


   exit when Defer_Pos12 = No_Token_Index;

   List_Pos0 := Defer_Pos12;
   Lst_Cpos0 := List_Pos0;

   Tmp_List0.Nodes.Append (Defer_Res12);

      
--  Start tok_code

Token_Res2 := Lst_Cpos0;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res2));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos2 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos0 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos0,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos2 := Lst_Cpos0 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos2 /= No_Token_Index then
          Lst_Cpos0 := Token_Pos2;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List0.Nodes.Length;
begin
   List_Res0 :=
      Allocate_Declaration_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos3;
      Token_End := (if Lst_Cpos0 = Row_Pos3
                    then Row_Pos3
                    else Lst_Cpos0 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos3, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res0,
      Kind              => Rflx_Declaration_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res0,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List0.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res0.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List0);

--  End list_code




if List_Pos0 /= No_Token_Index then

   Row_Pos3 := List_Pos0;

else
   Row_Pos3 := No_Token_Index;
   goto Exit_Row3_0;

end if;


--  Start tok_code

Token_Res3 := Row_Pos3;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res3));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos3 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos3 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos3,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos3 := Row_Pos3 + 1;
   end if;
end;

--  End tok_code




if Token_Pos3 /= No_Token_Index then

   Row_Pos3 := Token_Pos3;

else
   Row_Pos3 := No_Token_Index;
   goto Exit_Row3_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row3_0>>
pragma Warnings (On, "referenced");

--  End row_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Basic_Declarations_Extract_Parse0_Memo,
      Row_Pos3 /= No_Token_Index,
      List_Res0,
      Pos,
      Row_Pos3);


   Parser.Current_Pos := Row_Pos3;

   return List_Res0;
end Basic_Declarations_Extract_Parse0;

   


function Byte_Order_Aspect_Transform_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Byte_Order_Aspect
is
   use Bare_Byte_Order_Aspect_Memos;

      Row_Pos4 :
            Token_Index
               := No_Token_Index;
      Token_Pos4 :
            Token_Index
               := No_Token_Index;
      Token_Res4 :
            Token_Index
               := No_Token_Index;
      Token_Pos5 :
            Token_Index
               := No_Token_Index;
      Token_Res5 :
            Token_Index
               := No_Token_Index;
      Row_Pos5 :
            Token_Index
               := No_Token_Index;
      Token_Pos6 :
            Token_Index
               := No_Token_Index;
      Token_Res6 :
            Token_Index
               := No_Token_Index;
      Transform_Res2 :
            Bare_Byte_Order_Type_Highorderfirst
               := No_Bare_R_F_L_X_Node;
      Transform_Diags2 :
            Ada.Containers.Count_Type;
      Row_Pos6 :
            Token_Index
               := No_Token_Index;
      Token_Pos7 :
            Token_Index
               := No_Token_Index;
      Token_Res7 :
            Token_Index
               := No_Token_Index;
      Transform_Res3 :
            Bare_Byte_Order_Type_Loworderfirst
               := No_Bare_R_F_L_X_Node;
      Transform_Diags3 :
            Ada.Containers.Count_Type;
      Or_Pos3 :
            Token_Index
               := No_Token_Index;
      Or_Res3 :
            Bare_Byte_Order_Type
               := No_Bare_R_F_L_X_Node;
      Transform_Res4 :
            Bare_Byte_Order_Aspect
               := No_Bare_R_F_L_X_Node;
      Transform_Diags4 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Byte_Order_Aspect_Transform_Parse2_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res4 := M.Instance;
      return Transform_Res4;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res4;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags4 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos4 := Pos;



--  Start tok_code

Token_Res4 := Row_Pos4;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res4));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Byte_Order)
   then
       Token_Pos4 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos4 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos4,
             Expected_Token_Id => Rflx_Byte_Order,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos4 := Row_Pos4 + 1;
   end if;
end;

--  End tok_code




if Token_Pos4 /= No_Token_Index then

   Row_Pos4 := Token_Pos4;

else
   Row_Pos4 := No_Token_Index;
   goto Exit_Row4_0;

end if;


--  Start tok_code

Token_Res5 := Row_Pos4;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res5));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Arrow)
   then
       Token_Pos5 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos4 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos4,
             Expected_Token_Id => Rflx_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos5 := Row_Pos4 + 1;
   end if;
end;

--  End tok_code




if Token_Pos5 /= No_Token_Index then

   Row_Pos4 := Token_Pos5;

else
   Row_Pos4 := No_Token_Index;
   goto Exit_Row4_0;

end if;


--  Start or_code

Or_Pos3 := No_Token_Index;
Or_Res3 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags2 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos5 := Row_Pos4;



--  Start tok_code

Token_Res6 := Row_Pos5;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res6));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_High_Order_First)
   then
       Token_Pos6 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos5 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos5,
             Expected_Token_Id => Rflx_High_Order_First,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos6 := Row_Pos5 + 1;
   end if;
end;

--  End tok_code




if Token_Pos6 /= No_Token_Index then

   Row_Pos5 := Token_Pos6;

else
   Row_Pos5 := No_Token_Index;
   goto Exit_Row5_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row5_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos5 /= No_Token_Index then

   Transform_Res2 := Allocate_Byte_Order_Type_Highorderfirst (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res2,
      Kind => Rflx_Byte_Order_Type_Highorderfirst,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos4,
      Token_End_Index   => (if Row_Pos5 = Row_Pos4
                            then No_Token_Index
                            else Row_Pos5 - 1));




elsif Row_Pos5 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags2);
end if;

--  End transform_code

    if Row_Pos5 /= No_Token_Index then
        Or_Pos3 := Row_Pos5;
        Or_Res3 := Transform_Res2;
        goto Exit_Or3;
    end if;
    
--  Start transform_code

Transform_Diags3 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos6 := Row_Pos4;



--  Start tok_code

Token_Res7 := Row_Pos6;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res7));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Low_Order_First)
   then
       Token_Pos7 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos6 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos6,
             Expected_Token_Id => Rflx_Low_Order_First,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos7 := Row_Pos6 + 1;
   end if;
end;

--  End tok_code




if Token_Pos7 /= No_Token_Index then

   Row_Pos6 := Token_Pos7;

else
   Row_Pos6 := No_Token_Index;
   goto Exit_Row6_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row6_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos6 /= No_Token_Index then

   Transform_Res3 := Allocate_Byte_Order_Type_Loworderfirst (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res3,
      Kind => Rflx_Byte_Order_Type_Loworderfirst,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos4,
      Token_End_Index   => (if Row_Pos6 = Row_Pos4
                            then No_Token_Index
                            else Row_Pos6 - 1));




elsif Row_Pos6 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags3);
end if;

--  End transform_code

    if Row_Pos6 /= No_Token_Index then
        Or_Pos3 := Row_Pos6;
        Or_Res3 := Transform_Res3;
        goto Exit_Or3;
    end if;
<<Exit_Or3>>

--  End or_code




if Or_Pos3 /= No_Token_Index then

   Row_Pos4 := Or_Pos3;

else
   Row_Pos4 := No_Token_Index;
   goto Exit_Row4_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row4_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos4 /= No_Token_Index then

   Transform_Res4 := Allocate_Byte_Order_Aspect (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res4,
      Kind => Rflx_Byte_Order_Aspect,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos4 = Pos
                            then No_Token_Index
                            else Row_Pos4 - 1));

      Initialize_Fields_For_Byte_Order_Aspect
        (Self => Transform_Res4, Byte_Order_Aspect_F_Byte_Order => Or_Res3);

         if Or_Res3 /= null and then Is_Incomplete (Or_Res3) then
            Transform_Res4.Last_Attempted_Child := 0;
         elsif Or_Res3 /= null and then not Is_Ghost (Or_Res3) then
            Transform_Res4.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos4 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags4);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Byte_Order_Aspect_Transform_Parse2_Memo,
      Row_Pos4 /= No_Token_Index,
      Transform_Res4,
      Pos,
      Row_Pos4);


   Parser.Current_Pos := Row_Pos4;

   return Transform_Res4;
end Byte_Order_Aspect_Transform_Parse2;

   


function Call_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Call
is
   use Bare_Call_Memos;

      Row_Pos7 :
            Token_Index
               := No_Token_Index;
      Defer_Pos13 :
            Token_Index
               := No_Token_Index;
      Defer_Res13 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos8 :
            Token_Index
               := No_Token_Index;
      Token_Res8 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos1 :
            Token_Index
               := No_Token_Index;
      Tmp_List1 :
            Free_Parse_List;
      Defer_Pos14 :
            Token_Index
               := No_Token_Index;
      Defer_Res14 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos9 :
            Token_Index
               := No_Token_Index;
      Token_Res9 :
            Token_Index
               := No_Token_Index;
      List_Pos1 :
            Token_Index
               := No_Token_Index;
      List_Res1 :
            Bare_Expr_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos10 :
            Token_Index
               := No_Token_Index;
      Token_Res10 :
            Token_Index
               := No_Token_Index;
      Transform_Res5 :
            Bare_Call
               := No_Bare_R_F_L_X_Node;
      Transform_Diags5 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Call_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res5 := M.Instance;
      return Transform_Res5;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res5;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags5 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos7 := Pos;



Defer_Res13 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos7);
Defer_Pos13 := Parser.Current_Pos;




if Defer_Pos13 /= No_Token_Index then

   Row_Pos7 := Defer_Pos13;

else
   Row_Pos7 := No_Token_Index;
   goto Exit_Row7_0;

end if;


--  Start tok_code

Token_Res8 := Row_Pos7;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res8));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos8 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos7 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos7,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos8 := Row_Pos7 + 1;
   end if;
end;

--  End tok_code




if Token_Pos8 /= No_Token_Index then

   Row_Pos7 := Token_Pos8;

else
   Row_Pos7 := No_Token_Index;
   goto Exit_Row7_0;

end if;


--  Start list_code

    List_Pos1 := No_Token_Index;



Lst_Cpos1 := Row_Pos7;
Tmp_List1 := Get_Parse_List (Parser);

loop
   
Defer_Res14 :=
   Extended_Expression_Or_Parse1 (Parser, Lst_Cpos1);
Defer_Pos14 := Parser.Current_Pos;


   exit when Defer_Pos14 = No_Token_Index;

   List_Pos1 := Defer_Pos14;
   Lst_Cpos1 := List_Pos1;

   Tmp_List1.Nodes.Append (Defer_Res14);

      
--  Start tok_code

Token_Res9 := Lst_Cpos1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res9));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos9 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos1,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos9 := Lst_Cpos1 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos9 /= No_Token_Index then
          Lst_Cpos1 := Token_Pos9;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List1.Nodes.Length;
begin
   List_Res1 :=
      Allocate_Expr_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos7;
      Token_End := (if Lst_Cpos1 = Row_Pos7
                    then Row_Pos7
                    else Lst_Cpos1 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos7, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res1,
      Kind              => Rflx_Expr_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res1,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List1.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res1.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List1);

--  End list_code




if List_Pos1 /= No_Token_Index then

   Row_Pos7 := List_Pos1;

else
   Row_Pos7 := No_Token_Index;
   goto Exit_Row7_0;

end if;


--  Start tok_code

Token_Res10 := Row_Pos7;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res10));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos10 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos7 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos7,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos10 := Row_Pos7 + 1;
   end if;
end;

--  End tok_code




if Token_Pos10 /= No_Token_Index then

   Row_Pos7 := Token_Pos10;

else
   Row_Pos7 := No_Token_Index;
   goto Exit_Row7_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row7_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos7 /= No_Token_Index then

   Transform_Res5 := Allocate_Call (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res5,
      Kind => Rflx_Call,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos7 = Pos
                            then No_Token_Index
                            else Row_Pos7 - 1));

      Initialize_Fields_For_Call
        (Self => Transform_Res5, Call_F_Identifier => Defer_Res13, Call_F_Arguments => List_Res1);

         if Defer_Res13 /= null and then Is_Incomplete (Defer_Res13) then
            Transform_Res5.Last_Attempted_Child := 0;
         elsif Defer_Res13 /= null and then not Is_Ghost (Defer_Res13) then
            Transform_Res5.Last_Attempted_Child := -1;
         end if;
         if List_Res1 /= null and then Is_Incomplete (List_Res1) then
            Transform_Res5.Last_Attempted_Child := 0;
         elsif List_Res1 /= null and then not Is_Ghost (List_Res1) then
            Transform_Res5.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos7 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags5);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Call_Transform_Parse0_Memo,
      Row_Pos7 /= No_Token_Index,
      Transform_Res5,
      Pos,
      Row_Pos7);


   Parser.Current_Pos := Row_Pos7;

   return Transform_Res5;
end Call_Transform_Parse0;

   


function Channel_Declaration_Transform_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Channel_Decl
is
   use Bare_Formal_Channel_Decl_Memos;

      Row_Pos8 :
            Token_Index
               := No_Token_Index;
      Defer_Pos15 :
            Token_Index
               := No_Token_Index;
      Defer_Res15 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos11 :
            Token_Index
               := No_Token_Index;
      Token_Res11 :
            Token_Index
               := No_Token_Index;
      Token_Pos12 :
            Token_Index
               := No_Token_Index;
      Token_Res12 :
            Token_Index
               := No_Token_Index;
      Token_Pos13 :
            Token_Index
               := No_Token_Index;
      Token_Res13 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos2 :
            Token_Index
               := No_Token_Index;
      Tmp_List2 :
            Free_Parse_List;
      Row_Pos9 :
            Token_Index
               := No_Token_Index;
      Token_Pos14 :
            Token_Index
               := No_Token_Index;
      Token_Res14 :
            Token_Index
               := No_Token_Index;
      Transform_Res6 :
            Bare_Readable
               := No_Bare_R_F_L_X_Node;
      Transform_Diags6 :
            Ada.Containers.Count_Type;
      Row_Pos10 :
            Token_Index
               := No_Token_Index;
      Token_Pos15 :
            Token_Index
               := No_Token_Index;
      Token_Res15 :
            Token_Index
               := No_Token_Index;
      Transform_Res7 :
            Bare_Writable
               := No_Bare_R_F_L_X_Node;
      Transform_Diags7 :
            Ada.Containers.Count_Type;
      Or_Pos4 :
            Token_Index
               := No_Token_Index;
      Or_Res4 :
            Bare_Channel_Attribute
               := No_Bare_R_F_L_X_Node;
      Token_Pos16 :
            Token_Index
               := No_Token_Index;
      Token_Res16 :
            Token_Index
               := No_Token_Index;
      List_Pos2 :
            Token_Index
               := No_Token_Index;
      List_Res2 :
            Bare_Channel_Attribute_List
               := No_Bare_R_F_L_X_Node;
      Transform_Res8 :
            Bare_Formal_Channel_Decl
               := No_Bare_R_F_L_X_Node;
      Transform_Diags8 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Channel_Declaration_Transform_Parse2_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res8 := M.Instance;
      return Transform_Res8;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res8;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags8 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos8 := Pos;



Defer_Res15 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos8);
Defer_Pos15 := Parser.Current_Pos;




if Defer_Pos15 /= No_Token_Index then

   Row_Pos8 := Defer_Pos15;

else
   Row_Pos8 := No_Token_Index;
   goto Exit_Row8_0;

end if;


--  Start tok_code

Token_Res11 := Row_Pos8;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res11));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Colon)
   then
       Token_Pos11 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos8 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos8,
             Expected_Token_Id => Rflx_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos11 := Row_Pos8 + 1;
   end if;
end;

--  End tok_code




if Token_Pos11 /= No_Token_Index then

   Row_Pos8 := Token_Pos11;

else
   Row_Pos8 := No_Token_Index;
   goto Exit_Row8_0;

end if;


--  Start tok_code

Token_Res12 := Row_Pos8;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res12));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Channel)
   then
       Token_Pos12 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos8 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos8,
             Expected_Token_Id => Rflx_Channel,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos12 := Row_Pos8 + 1;
   end if;
end;

--  End tok_code




if Token_Pos12 /= No_Token_Index then

   Row_Pos8 := Token_Pos12;

else
   Row_Pos8 := No_Token_Index;
   goto Exit_Row8_0;

end if;


--  Start tok_code

Token_Res13 := Row_Pos8;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res13));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_With)
   then
       Token_Pos13 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos8 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos8,
             Expected_Token_Id => Rflx_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos13 := Row_Pos8 + 1;
   end if;
end;

--  End tok_code




if Token_Pos13 /= No_Token_Index then

   Row_Pos8 := Token_Pos13;

else
   Row_Pos8 := No_Token_Index;
   goto Exit_Row8_0;

end if;


--  Start list_code

    List_Pos2 := No_Token_Index;



Lst_Cpos2 := Row_Pos8;
Tmp_List2 := Get_Parse_List (Parser);

loop
   
--  Start or_code

Or_Pos4 := No_Token_Index;
Or_Res4 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags6 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos9 := Lst_Cpos2;



--  Start tok_code

Token_Res14 := Row_Pos9;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res14));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Readable)
   then
       Token_Pos14 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos9 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos9,
             Expected_Token_Id => Rflx_Readable,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos14 := Row_Pos9 + 1;
   end if;
end;

--  End tok_code




if Token_Pos14 /= No_Token_Index then

   Row_Pos9 := Token_Pos14;

else
   Row_Pos9 := No_Token_Index;
   goto Exit_Row9_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row9_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos9 /= No_Token_Index then

   Transform_Res6 := Allocate_Readable (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res6,
      Kind => Rflx_Readable,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos2,
      Token_End_Index   => (if Row_Pos9 = Lst_Cpos2
                            then No_Token_Index
                            else Row_Pos9 - 1));




elsif Row_Pos9 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags6);
end if;

--  End transform_code

    if Row_Pos9 /= No_Token_Index then
        Or_Pos4 := Row_Pos9;
        Or_Res4 := Transform_Res6;
        goto Exit_Or4;
    end if;
    
--  Start transform_code

Transform_Diags7 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos10 := Lst_Cpos2;



--  Start tok_code

Token_Res15 := Row_Pos10;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res15));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Writable)
   then
       Token_Pos15 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos10 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos10,
             Expected_Token_Id => Rflx_Writable,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos15 := Row_Pos10 + 1;
   end if;
end;

--  End tok_code




if Token_Pos15 /= No_Token_Index then

   Row_Pos10 := Token_Pos15;

else
   Row_Pos10 := No_Token_Index;
   goto Exit_Row10_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row10_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos10 /= No_Token_Index then

   Transform_Res7 := Allocate_Writable (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res7,
      Kind => Rflx_Writable,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos2,
      Token_End_Index   => (if Row_Pos10 = Lst_Cpos2
                            then No_Token_Index
                            else Row_Pos10 - 1));




elsif Row_Pos10 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags7);
end if;

--  End transform_code

    if Row_Pos10 /= No_Token_Index then
        Or_Pos4 := Row_Pos10;
        Or_Res4 := Transform_Res7;
        goto Exit_Or4;
    end if;
<<Exit_Or4>>

--  End or_code


   exit when Or_Pos4 = No_Token_Index;

   List_Pos2 := Or_Pos4;
   Lst_Cpos2 := List_Pos2;

   Tmp_List2.Nodes.Append (Or_Res4);

      
--  Start tok_code

Token_Res16 := Lst_Cpos2;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res16));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos16 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos2 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos2,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos16 := Lst_Cpos2 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos16 /= No_Token_Index then
          Lst_Cpos2 := Token_Pos16;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List2.Nodes.Length;
begin
   List_Res2 :=
      Allocate_Channel_Attribute_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos8;
      Token_End := (if Lst_Cpos2 = Row_Pos8
                    then Row_Pos8
                    else Lst_Cpos2 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos8, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res2,
      Kind              => Rflx_Channel_Attribute_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res2,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List2.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res2.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List2);

--  End list_code




if List_Pos2 /= No_Token_Index then

   Row_Pos8 := List_Pos2;

else
   Row_Pos8 := No_Token_Index;
   goto Exit_Row8_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row8_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos8 /= No_Token_Index then

   Transform_Res8 := Allocate_Formal_Channel_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res8,
      Kind => Rflx_Formal_Channel_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos8 = Pos
                            then No_Token_Index
                            else Row_Pos8 - 1));

      Initialize_Fields_For_Formal_Channel_Decl
        (Self => Transform_Res8, Formal_Channel_Decl_F_Identifier => Defer_Res15, Formal_Channel_Decl_F_Parameters => List_Res2);

         if Defer_Res15 /= null and then Is_Incomplete (Defer_Res15) then
            Transform_Res8.Last_Attempted_Child := 0;
         elsif Defer_Res15 /= null and then not Is_Ghost (Defer_Res15) then
            Transform_Res8.Last_Attempted_Child := -1;
         end if;
         if List_Res2 /= null and then Is_Incomplete (List_Res2) then
            Transform_Res8.Last_Attempted_Child := 0;
         elsif List_Res2 /= null and then not Is_Ghost (List_Res2) then
            Transform_Res8.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos8 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags8);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Channel_Declaration_Transform_Parse2_Memo,
      Row_Pos8 /= No_Token_Index,
      Transform_Res8,
      Pos,
      Row_Pos8);


   Parser.Current_Pos := Row_Pos8;

   return Transform_Res8;
end Channel_Declaration_Transform_Parse2;

   


function Checksum_Aspect_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Checksum_Aspect
is
   use Bare_Checksum_Aspect_Memos;

      Row_Pos11 :
            Token_Index
               := No_Token_Index;
      Token_Pos17 :
            Token_Index
               := No_Token_Index;
      Token_Res17 :
            Token_Index
               := No_Token_Index;
      Token_Pos18 :
            Token_Index
               := No_Token_Index;
      Token_Res18 :
            Token_Index
               := No_Token_Index;
      Token_Pos19 :
            Token_Index
               := No_Token_Index;
      Token_Res19 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos3 :
            Token_Index
               := No_Token_Index;
      Tmp_List3 :
            Free_Parse_List;
      Defer_Pos16 :
            Token_Index
               := No_Token_Index;
      Defer_Res16 :
            Bare_Checksum_Assoc
               := No_Bare_R_F_L_X_Node;
      Token_Pos20 :
            Token_Index
               := No_Token_Index;
      Token_Res20 :
            Token_Index
               := No_Token_Index;
      List_Pos3 :
            Token_Index
               := No_Token_Index;
      List_Res3 :
            Bare_Checksum_Assoc_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos21 :
            Token_Index
               := No_Token_Index;
      Token_Res21 :
            Token_Index
               := No_Token_Index;
      Transform_Res9 :
            Bare_Checksum_Aspect
               := No_Bare_R_F_L_X_Node;
      Transform_Diags9 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Checksum_Aspect_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res9 := M.Instance;
      return Transform_Res9;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res9;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags9 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos11 := Pos;



--  Start tok_code

Token_Res17 := Row_Pos11;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res17));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Checksum)
   then
       Token_Pos17 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos11 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos11,
             Expected_Token_Id => Rflx_Checksum,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos17 := Row_Pos11 + 1;
   end if;
end;

--  End tok_code




if Token_Pos17 /= No_Token_Index then

   Row_Pos11 := Token_Pos17;

else
   Row_Pos11 := No_Token_Index;
   goto Exit_Row11_0;

end if;


--  Start tok_code

Token_Res18 := Row_Pos11;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res18));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Arrow)
   then
       Token_Pos18 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos11 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos11,
             Expected_Token_Id => Rflx_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos18 := Row_Pos11 + 1;
   end if;
end;

--  End tok_code




if Token_Pos18 /= No_Token_Index then

   Row_Pos11 := Token_Pos18;

else
   Row_Pos11 := No_Token_Index;
   goto Exit_Row11_0;

end if;


--  Start tok_code

Token_Res19 := Row_Pos11;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res19));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos19 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos11 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos11,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos19 := Row_Pos11 + 1;
   end if;
end;

--  End tok_code




if Token_Pos19 /= No_Token_Index then

   Row_Pos11 := Token_Pos19;

else
   Row_Pos11 := No_Token_Index;
   goto Exit_Row11_0;

end if;


--  Start list_code

    List_Pos3 := No_Token_Index;



Lst_Cpos3 := Row_Pos11;
Tmp_List3 := Get_Parse_List (Parser);

loop
   
Defer_Res16 :=
   Checksum_Association_Transform_Parse1 (Parser, Lst_Cpos3);
Defer_Pos16 := Parser.Current_Pos;


   exit when Defer_Pos16 = No_Token_Index;

   List_Pos3 := Defer_Pos16;
   Lst_Cpos3 := List_Pos3;

   Tmp_List3.Nodes.Append (Defer_Res16);

      
--  Start tok_code

Token_Res20 := Lst_Cpos3;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res20));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos20 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos3 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos3,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos20 := Lst_Cpos3 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos20 /= No_Token_Index then
          Lst_Cpos3 := Token_Pos20;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List3.Nodes.Length;
begin
   List_Res3 :=
      Allocate_Checksum_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos11;
      Token_End := (if Lst_Cpos3 = Row_Pos11
                    then Row_Pos11
                    else Lst_Cpos3 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos11, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res3,
      Kind              => Rflx_Checksum_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res3,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List3.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res3.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List3);

--  End list_code




if List_Pos3 /= No_Token_Index then

   Row_Pos11 := List_Pos3;

else
   Row_Pos11 := No_Token_Index;
   goto Exit_Row11_0;

end if;


--  Start tok_code

Token_Res21 := Row_Pos11;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res21));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos21 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos11 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos11,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos21 := Row_Pos11 + 1;
   end if;
end;

--  End tok_code




if Token_Pos21 /= No_Token_Index then

   Row_Pos11 := Token_Pos21;

else
   Row_Pos11 := No_Token_Index;
   goto Exit_Row11_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row11_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos11 /= No_Token_Index then

   Transform_Res9 := Allocate_Checksum_Aspect (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res9,
      Kind => Rflx_Checksum_Aspect,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos11 = Pos
                            then No_Token_Index
                            else Row_Pos11 - 1));

      Initialize_Fields_For_Checksum_Aspect
        (Self => Transform_Res9, Checksum_Aspect_F_Associations => List_Res3);

         if List_Res3 /= null and then Is_Incomplete (List_Res3) then
            Transform_Res9.Last_Attempted_Child := 0;
         elsif List_Res3 /= null and then not Is_Ghost (List_Res3) then
            Transform_Res9.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos11 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags9);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Checksum_Aspect_Transform_Parse0_Memo,
      Row_Pos11 /= No_Token_Index,
      Transform_Res9,
      Pos,
      Row_Pos11);


   Parser.Current_Pos := Row_Pos11;

   return Transform_Res9;
end Checksum_Aspect_Transform_Parse0;

   


function Checksum_Association_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Checksum_Assoc
is
   use Bare_Checksum_Assoc_Memos;

      Row_Pos12 :
            Token_Index
               := No_Token_Index;
      Defer_Pos17 :
            Token_Index
               := No_Token_Index;
      Defer_Res17 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos22 :
            Token_Index
               := No_Token_Index;
      Token_Res22 :
            Token_Index
               := No_Token_Index;
      Token_Pos23 :
            Token_Index
               := No_Token_Index;
      Token_Res23 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos4 :
            Token_Index
               := No_Token_Index;
      Tmp_List4 :
            Free_Parse_List;
      Defer_Pos18 :
            Token_Index
               := No_Token_Index;
      Defer_Res18 :
            Bare_Checksum_Value_Range
               := No_Bare_R_F_L_X_Node;
      Row_Pos13 :
            Token_Index
               := No_Token_Index;
      Defer_Pos19 :
            Token_Index
               := No_Token_Index;
      Defer_Res19 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res10 :
            Bare_Checksum_Val
               := No_Bare_R_F_L_X_Node;
      Transform_Diags10 :
            Ada.Containers.Count_Type;
      Or_Pos5 :
            Token_Index
               := No_Token_Index;
      Or_Res5 :
            Bare_Base_Checksum_Val
               := No_Bare_R_F_L_X_Node;
      Token_Pos24 :
            Token_Index
               := No_Token_Index;
      Token_Res24 :
            Token_Index
               := No_Token_Index;
      List_Pos4 :
            Token_Index
               := No_Token_Index;
      List_Res4 :
            Bare_Base_Checksum_Val_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos25 :
            Token_Index
               := No_Token_Index;
      Token_Res25 :
            Token_Index
               := No_Token_Index;
      Transform_Res11 :
            Bare_Checksum_Assoc
               := No_Bare_R_F_L_X_Node;
      Transform_Diags11 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Checksum_Association_Transform_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res11 := M.Instance;
      return Transform_Res11;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res11;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags11 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos12 := Pos;



Defer_Res17 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos12);
Defer_Pos17 := Parser.Current_Pos;




if Defer_Pos17 /= No_Token_Index then

   Row_Pos12 := Defer_Pos17;

else
   Row_Pos12 := No_Token_Index;
   goto Exit_Row12_0;

end if;


--  Start tok_code

Token_Res22 := Row_Pos12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res22));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Arrow)
   then
       Token_Pos22 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos12,
             Expected_Token_Id => Rflx_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos22 := Row_Pos12 + 1;
   end if;
end;

--  End tok_code




if Token_Pos22 /= No_Token_Index then

   Row_Pos12 := Token_Pos22;

else
   Row_Pos12 := No_Token_Index;
   goto Exit_Row12_0;

end if;


--  Start tok_code

Token_Res23 := Row_Pos12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res23));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos23 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos12,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos23 := Row_Pos12 + 1;
   end if;
end;

--  End tok_code




if Token_Pos23 /= No_Token_Index then

   Row_Pos12 := Token_Pos23;

else
   Row_Pos12 := No_Token_Index;
   goto Exit_Row12_0;

end if;


--  Start list_code

    List_Pos4 := No_Token_Index;



Lst_Cpos4 := Row_Pos12;
Tmp_List4 := Get_Parse_List (Parser);

loop
   
--  Start or_code

Or_Pos5 := No_Token_Index;
Or_Res5 := No_Bare_R_F_L_X_Node;
    
Defer_Res18 :=
   Value_Range_Transform_Parse0 (Parser, Lst_Cpos4);
Defer_Pos18 := Parser.Current_Pos;

    if Defer_Pos18 /= No_Token_Index then
        Or_Pos5 := Defer_Pos18;
        Or_Res5 := Defer_Res18;
        goto Exit_Or5;
    end if;
    
--  Start transform_code

Transform_Diags10 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos13 := Lst_Cpos4;



Defer_Res19 :=
   Expression_Or_Parse1 (Parser, Row_Pos13);
Defer_Pos19 := Parser.Current_Pos;




if Defer_Pos19 /= No_Token_Index then

   Row_Pos13 := Defer_Pos19;

else
   Row_Pos13 := No_Token_Index;
   goto Exit_Row13_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row13_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos13 /= No_Token_Index then

   Transform_Res10 := Allocate_Checksum_Val (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res10,
      Kind => Rflx_Checksum_Val,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos4,
      Token_End_Index   => (if Row_Pos13 = Lst_Cpos4
                            then No_Token_Index
                            else Row_Pos13 - 1));

      Initialize_Fields_For_Checksum_Val
        (Self => Transform_Res10, Checksum_Val_F_Data => Defer_Res19);

         if Defer_Res19 /= null and then Is_Incomplete (Defer_Res19) then
            Transform_Res10.Last_Attempted_Child := 0;
         elsif Defer_Res19 /= null and then not Is_Ghost (Defer_Res19) then
            Transform_Res10.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos13 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags10);
end if;

--  End transform_code

    if Row_Pos13 /= No_Token_Index then
        Or_Pos5 := Row_Pos13;
        Or_Res5 := Transform_Res10;
        goto Exit_Or5;
    end if;
<<Exit_Or5>>

--  End or_code


   exit when Or_Pos5 = No_Token_Index;

   List_Pos4 := Or_Pos5;
   Lst_Cpos4 := List_Pos4;

   Tmp_List4.Nodes.Append (Or_Res5);

      
--  Start tok_code

Token_Res24 := Lst_Cpos4;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res24));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos24 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos4 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos4,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos24 := Lst_Cpos4 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos24 /= No_Token_Index then
          Lst_Cpos4 := Token_Pos24;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List4.Nodes.Length;
begin
   List_Res4 :=
      Allocate_Base_Checksum_Val_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos12;
      Token_End := (if Lst_Cpos4 = Row_Pos12
                    then Row_Pos12
                    else Lst_Cpos4 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos12, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res4,
      Kind              => Rflx_Base_Checksum_Val_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res4,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List4.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res4.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List4);

--  End list_code




if List_Pos4 /= No_Token_Index then

   Row_Pos12 := List_Pos4;

else
   Row_Pos12 := No_Token_Index;
   goto Exit_Row12_0;

end if;


--  Start tok_code

Token_Res25 := Row_Pos12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res25));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos25 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos12,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos25 := Row_Pos12 + 1;
   end if;
end;

--  End tok_code




if Token_Pos25 /= No_Token_Index then

   Row_Pos12 := Token_Pos25;

else
   Row_Pos12 := No_Token_Index;
   goto Exit_Row12_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row12_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos12 /= No_Token_Index then

   Transform_Res11 := Allocate_Checksum_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res11,
      Kind => Rflx_Checksum_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos12 = Pos
                            then No_Token_Index
                            else Row_Pos12 - 1));

      Initialize_Fields_For_Checksum_Assoc
        (Self => Transform_Res11, Checksum_Assoc_F_Identifier => Defer_Res17, Checksum_Assoc_F_Covered_Fields => List_Res4);

         if Defer_Res17 /= null and then Is_Incomplete (Defer_Res17) then
            Transform_Res11.Last_Attempted_Child := 0;
         elsif Defer_Res17 /= null and then not Is_Ghost (Defer_Res17) then
            Transform_Res11.Last_Attempted_Child := -1;
         end if;
         if List_Res4 /= null and then Is_Incomplete (List_Res4) then
            Transform_Res11.Last_Attempted_Child := 0;
         elsif List_Res4 /= null and then not Is_Ghost (List_Res4) then
            Transform_Res11.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos12 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags11);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Checksum_Association_Transform_Parse1_Memo,
      Row_Pos12 /= No_Token_Index,
      Transform_Res11,
      Pos,
      Row_Pos12);


   Parser.Current_Pos := Row_Pos12;

   return Transform_Res11;
end Checksum_Association_Transform_Parse1;

   


function Comprehension_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Comprehension
is
   use Bare_Comprehension_Memos;

      Row_Pos14 :
            Token_Index
               := No_Token_Index;
      Token_Pos26 :
            Token_Index
               := No_Token_Index;
      Token_Res26 :
            Token_Index
               := No_Token_Index;
      Token_Pos27 :
            Token_Index
               := No_Token_Index;
      Token_Res27 :
            Token_Index
               := No_Token_Index;
      Defer_Pos20 :
            Token_Index
               := No_Token_Index;
      Defer_Res20 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos28 :
            Token_Index
               := No_Token_Index;
      Token_Res28 :
            Token_Index
               := No_Token_Index;
      Defer_Pos21 :
            Token_Index
               := No_Token_Index;
      Defer_Res21 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Pos15 :
            Token_Index
               := No_Token_Index;
      Token_Pos29 :
            Token_Index
               := No_Token_Index;
      Token_Res29 :
            Token_Index
               := No_Token_Index;
      Defer_Pos22 :
            Token_Index
               := No_Token_Index;
      Defer_Res22 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos30 :
            Token_Index
               := No_Token_Index;
      Token_Res30 :
            Token_Index
               := No_Token_Index;
      Defer_Pos23 :
            Token_Index
               := No_Token_Index;
      Defer_Res23 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos31 :
            Token_Index
               := No_Token_Index;
      Token_Res31 :
            Token_Index
               := No_Token_Index;
      Transform_Res12 :
            Bare_Comprehension
               := No_Bare_R_F_L_X_Node;
      Transform_Diags12 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Comprehension_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res12 := M.Instance;
      return Transform_Res12;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res12;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags12 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos14 := Pos;



--  Start tok_code

Token_Res26 := Row_Pos14;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res26));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Brack)
   then
       Token_Pos26 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos14 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos14,
             Expected_Token_Id => Rflx_L_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos26 := Row_Pos14 + 1;
   end if;
end;

--  End tok_code




if Token_Pos26 /= No_Token_Index then

   Row_Pos14 := Token_Pos26;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;


--  Start tok_code

Token_Res27 := Row_Pos14;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res27));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_For)
   then
       Token_Pos27 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos14 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos14,
             Expected_Token_Id => Rflx_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos27 := Row_Pos14 + 1;
   end if;
end;

--  End tok_code




if Token_Pos27 /= No_Token_Index then

   Row_Pos14 := Token_Pos27;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;


Defer_Res20 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos14);
Defer_Pos20 := Parser.Current_Pos;




if Defer_Pos20 /= No_Token_Index then

   Row_Pos14 := Defer_Pos20;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;


--  Start tok_code

Token_Res28 := Row_Pos14;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res28));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_In)
   then
       Token_Pos28 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos14 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos14,
             Expected_Token_Id => Rflx_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos28 := Row_Pos14 + 1;
   end if;
end;

--  End tok_code




if Token_Pos28 /= No_Token_Index then

   Row_Pos14 := Token_Pos28;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;


Defer_Res21 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos14);
Defer_Pos21 := Parser.Current_Pos;




if Defer_Pos21 /= No_Token_Index then

   Row_Pos14 := Defer_Pos21;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos15 := Row_Pos14;



--  Start tok_code

Token_Res29 := Row_Pos15;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res29));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_If)
   then
       Token_Pos29 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos15 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos15,
             Expected_Token_Id => Rflx_If,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos29 := Row_Pos15 + 1;
   end if;
end;

--  End tok_code




if Token_Pos29 /= No_Token_Index then

   Row_Pos15 := Token_Pos29;

else
   Row_Pos15 := No_Token_Index;
   goto Exit_Row15_0;

end if;


Defer_Res22 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos15);
Defer_Pos22 := Parser.Current_Pos;




if Defer_Pos22 /= No_Token_Index then

   Row_Pos15 := Defer_Pos22;

else
   Row_Pos15 := No_Token_Index;
   goto Exit_Row15_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row15_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos15 = No_Token_Index then

         
   Defer_Res22 := No_Bare_R_F_L_X_Node;



       
   Row_Pos15 := Row_Pos14;



end if;

--  End opt_code




if Row_Pos15 /= No_Token_Index then

   Row_Pos14 := Row_Pos15;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;


--  Start tok_code

Token_Res30 := Row_Pos14;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res30));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Arrow)
   then
       Token_Pos30 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos14 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos14,
             Expected_Token_Id => Rflx_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos30 := Row_Pos14 + 1;
   end if;
end;

--  End tok_code




if Token_Pos30 /= No_Token_Index then

   Row_Pos14 := Token_Pos30;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;


Defer_Res23 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos14);
Defer_Pos23 := Parser.Current_Pos;




if Defer_Pos23 /= No_Token_Index then

   Row_Pos14 := Defer_Pos23;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;


--  Start tok_code

Token_Res31 := Row_Pos14;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res31));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Brack)
   then
       Token_Pos31 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos14 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos14,
             Expected_Token_Id => Rflx_R_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos31 := Row_Pos14 + 1;
   end if;
end;

--  End tok_code




if Token_Pos31 /= No_Token_Index then

   Row_Pos14 := Token_Pos31;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row14_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos14 /= No_Token_Index then

   Transform_Res12 := Allocate_Comprehension (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res12,
      Kind => Rflx_Comprehension,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos14 = Pos
                            then No_Token_Index
                            else Row_Pos14 - 1));

      Initialize_Fields_For_Comprehension
        (Self => Transform_Res12, Comprehension_F_Iterator => Defer_Res20, Comprehension_F_Sequence => Defer_Res21, Comprehension_F_Condition => Defer_Res22, Comprehension_F_Selector => Defer_Res23);

         if Defer_Res20 /= null and then Is_Incomplete (Defer_Res20) then
            Transform_Res12.Last_Attempted_Child := 0;
         elsif Defer_Res20 /= null and then not Is_Ghost (Defer_Res20) then
            Transform_Res12.Last_Attempted_Child := -1;
         end if;
         if Defer_Res21 /= null and then Is_Incomplete (Defer_Res21) then
            Transform_Res12.Last_Attempted_Child := 0;
         elsif Defer_Res21 /= null and then not Is_Ghost (Defer_Res21) then
            Transform_Res12.Last_Attempted_Child := -1;
         end if;
         if Defer_Res22 /= null and then Is_Incomplete (Defer_Res22) then
            Transform_Res12.Last_Attempted_Child := 0;
         elsif Defer_Res22 /= null and then not Is_Ghost (Defer_Res22) then
            Transform_Res12.Last_Attempted_Child := -1;
         end if;
         if Defer_Res23 /= null and then Is_Incomplete (Defer_Res23) then
            Transform_Res12.Last_Attempted_Child := 0;
         elsif Defer_Res23 /= null and then not Is_Ghost (Defer_Res23) then
            Transform_Res12.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos14 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags12);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Comprehension_Transform_Parse0_Memo,
      Row_Pos14 /= No_Token_Index,
      Transform_Res12,
      Pos,
      Row_Pos14);


   Parser.Current_Pos := Row_Pos14;

   return Transform_Res12;
end Comprehension_Transform_Parse0;

   


function Concatenation_Or_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Sequence_Literal
is
   use Bare_Sequence_Literal_Memos;

      Nobt0 :
            Boolean
               := False;
      Row_Pos16 :
            Token_Index
               := No_Token_Index;
      Defer_Pos24 :
            Token_Index
               := No_Token_Index;
      Defer_Res24 :
            Bare_Sequence_Literal
               := No_Bare_R_F_L_X_Node;
      Token_Pos32 :
            Token_Index
               := No_Token_Index;
      Token_Res32 :
            Token_Index
               := No_Token_Index;
      Defer_Pos25 :
            Token_Index
               := No_Token_Index;
      Defer_Res25 :
            Bare_Sequence_Aggregate
               := No_Bare_R_F_L_X_Node;
      Defer_Pos26 :
            Token_Index
               := No_Token_Index;
      Defer_Res26 :
            Bare_String_Literal
               := No_Bare_R_F_L_X_Node;
      Or_Pos6 :
            Token_Index
               := No_Token_Index;
      Or_Res6 :
            Bare_Sequence_Literal
               := No_Bare_R_F_L_X_Node;
      Row_Progress0 :
            Integer
               := 0;
      Transform_Res13 :
            Bare_Concatenation
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed0 :
            Boolean
               := False;
      Transform_Diags13 :
            Ada.Containers.Count_Type;
      Defer_Pos27 :
            Token_Index
               := No_Token_Index;
      Defer_Res27 :
            Bare_Sequence_Aggregate
               := No_Bare_R_F_L_X_Node;
      Defer_Pos28 :
            Token_Index
               := No_Token_Index;
      Defer_Res28 :
            Bare_String_Literal
               := No_Bare_R_F_L_X_Node;
      Or_Pos7 :
            Token_Index
               := No_Token_Index;
      Or_Res7 :
            Bare_Sequence_Literal
               := No_Bare_R_F_L_X_Node;
      Or_Pos8 :
            Token_Index
               := No_Token_Index;
      Or_Res8 :
            Bare_Sequence_Literal
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Sequence_Literal := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Concatenation_Or_Parse2_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res8 := M.Instance;
      return Or_Res8;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res8;
   end if;

       Set (Parser.Private_Part.Concatenation_Or_Parse2_Memo, False, Or_Res8, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt0 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos8 := No_Token_Index;
Or_Res8 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags13 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos16 := Pos;



Defer_Res24 :=
   Concatenation_Or_Parse2 (Parser, Row_Pos16);
Defer_Pos24 := Parser.Current_Pos;



Row_Progress0 := 1;

if Defer_Pos24 /= No_Token_Index then

   Row_Pos16 := Defer_Pos24;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;


--  Start tok_code

Token_Res32 := Row_Pos16;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res32));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Ampersand)
   then
       Token_Pos32 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos16 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos16,
             Expected_Token_Id => Rflx_Ampersand,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos32 := Row_Pos16 + 1;
   end if;
end;

--  End tok_code



Row_Progress0 := 2;

if Token_Pos32 /= No_Token_Index then

   Row_Pos16 := Token_Pos32;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;

Nobt0 := True;

   Nobt0 := Nobt0;

Row_Progress0 := 3;

if Row_Pos16 /= No_Token_Index then

   Row_Pos16 := Row_Pos16;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;


--  Start or_code

Or_Pos6 := No_Token_Index;
Or_Res6 := No_Bare_R_F_L_X_Node;
    
Defer_Res25 :=
   Sequence_Aggregate_Transform_Parse0 (Parser, Row_Pos16);
Defer_Pos25 := Parser.Current_Pos;

    if Defer_Pos25 /= No_Token_Index then
        Or_Pos6 := Defer_Pos25;
        Or_Res6 := Defer_Res25;
        goto Exit_Or7;
    end if;
    
Defer_Res26 :=
   String_Literal_Transform_Parse0 (Parser, Row_Pos16);
Defer_Pos26 := Parser.Current_Pos;

    if Defer_Pos26 /= No_Token_Index then
        Or_Pos6 := Defer_Pos26;
        Or_Res6 := Defer_Res26;
        goto Exit_Or7;
    end if;
<<Exit_Or7>>

--  End or_code



Row_Progress0 := 4;

if Or_Pos6 /= No_Token_Index then

   Row_Pos16 := Or_Pos6;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row16_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos16 = No_Token_Index and then Nobt0 then

   Row_Pos16 := Parser.Last_Fail.Pos;

   Transform_Has_Failed0 := True;
end if;

if Row_Pos16 /= No_Token_Index then

   Transform_Res13 := Allocate_Concatenation (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res13,
      Kind => Rflx_Concatenation,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos16 = Pos
                            then No_Token_Index
                            else Row_Pos16 - 1));

      Initialize_Fields_For_Concatenation
        (Self => Transform_Res13, Concatenation_F_Left => Defer_Res24, Concatenation_F_Right => Or_Res6);

         if Defer_Res24 /= null and then Is_Incomplete (Defer_Res24) then
            Transform_Res13.Last_Attempted_Child := 0;
         elsif Defer_Res24 /= null and then not Is_Ghost (Defer_Res24) then
            Transform_Res13.Last_Attempted_Child := -1;
         end if;
         if Or_Res6 /= null and then Is_Incomplete (Or_Res6) then
            Transform_Res13.Last_Attempted_Child := 0;
         elsif Or_Res6 /= null and then not Is_Ghost (Or_Res6) then
            Transform_Res13.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed0 then
      Transform_Res13.Last_Attempted_Child :=
         Row_Progress0;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <concatenation>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos16 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags13);
end if;

--  End transform_code

    if Row_Pos16 /= No_Token_Index then
        Or_Pos8 := Row_Pos16;
        Or_Res8 := Transform_Res13;
        goto Exit_Or6;
    end if;
    
--  Start or_code

Or_Pos7 := No_Token_Index;
Or_Res7 := No_Bare_R_F_L_X_Node;
    
Defer_Res27 :=
   Sequence_Aggregate_Transform_Parse0 (Parser, Pos);
Defer_Pos27 := Parser.Current_Pos;

    if Defer_Pos27 /= No_Token_Index then
        Or_Pos7 := Defer_Pos27;
        Or_Res7 := Defer_Res27;
        goto Exit_Or8;
    end if;
    
Defer_Res28 :=
   String_Literal_Transform_Parse0 (Parser, Pos);
Defer_Pos28 := Parser.Current_Pos;

    if Defer_Pos28 /= No_Token_Index then
        Or_Pos7 := Defer_Pos28;
        Or_Res7 := Defer_Res28;
        goto Exit_Or8;
    end if;
<<Exit_Or8>>

--  End or_code

    if Or_Pos7 /= No_Token_Index then
        Or_Pos8 := Or_Pos7;
        Or_Res8 := Or_Res7;
        goto Exit_Or6;
    end if;
<<Exit_Or6>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos8 > Mem_Pos then
         Mem_Pos := Or_Pos8;
         Mem_Res := Or_Res8;
         Set
           (Parser.Private_Part.Concatenation_Or_Parse2_Memo,
            Or_Pos8 /= No_Token_Index,
            Or_Res8,
            Pos,
            Or_Pos8);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res8 := Mem_Res;
         Or_Pos8 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Concatenation_Or_Parse2_Memo,
      Or_Pos8 /= No_Token_Index,
      Or_Res8,
      Pos,
      Or_Pos8);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos8;

   return Or_Res8;
end Concatenation_Or_Parse2;

   


function Conditional_Transition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Conditional_Transition
is
   use Bare_Conditional_Transition_Memos;

      Row_Pos17 :
            Token_Index
               := No_Token_Index;
      Token_Pos33 :
            Token_Index
               := No_Token_Index;
      Token_Res33 :
            Token_Index
               := No_Token_Index;
      Defer_Pos29 :
            Token_Index
               := No_Token_Index;
      Defer_Res29 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Row_Pos18 :
            Token_Index
               := No_Token_Index;
      Token_Pos34 :
            Token_Index
               := No_Token_Index;
      Token_Res34 :
            Token_Index
               := No_Token_Index;
      Defer_Pos30 :
            Token_Index
               := No_Token_Index;
      Defer_Res30 :
            Bare_Description
               := No_Bare_R_F_L_X_Node;
      Defer_Pos31 :
            Token_Index
               := No_Token_Index;
      Defer_Res31 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res14 :
            Bare_Conditional_Transition
               := No_Bare_R_F_L_X_Node;
      Transform_Diags14 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Conditional_Transition_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res14 := M.Instance;
      return Transform_Res14;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res14;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags14 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos17 := Pos;



--  Start tok_code

Token_Res33 := Row_Pos17;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res33));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Goto)
   then
       Token_Pos33 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos17 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos17,
             Expected_Token_Id => Rflx_Goto,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos33 := Row_Pos17 + 1;
   end if;
end;

--  End tok_code




if Token_Pos33 /= No_Token_Index then

   Row_Pos17 := Token_Pos33;

else
   Row_Pos17 := No_Token_Index;
   goto Exit_Row17_0;

end if;


Defer_Res29 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos17);
Defer_Pos29 := Parser.Current_Pos;




if Defer_Pos29 /= No_Token_Index then

   Row_Pos17 := Defer_Pos29;

else
   Row_Pos17 := No_Token_Index;
   goto Exit_Row17_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos18 := Row_Pos17;



--  Start tok_code

Token_Res34 := Row_Pos18;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res34));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_With)
   then
       Token_Pos34 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos18 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos18,
             Expected_Token_Id => Rflx_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos34 := Row_Pos18 + 1;
   end if;
end;

--  End tok_code




if Token_Pos34 /= No_Token_Index then

   Row_Pos18 := Token_Pos34;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;


Defer_Res30 :=
   Description_Aspect_Transform_Parse0 (Parser, Row_Pos18);
Defer_Pos30 := Parser.Current_Pos;




if Defer_Pos30 /= No_Token_Index then

   Row_Pos18 := Defer_Pos30;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row18_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos18 = No_Token_Index then

         
   Defer_Res30 := No_Bare_R_F_L_X_Node;



       
   Row_Pos18 := Row_Pos17;



end if;

--  End opt_code




if Row_Pos18 /= No_Token_Index then

   Row_Pos17 := Row_Pos18;

else
   Row_Pos17 := No_Token_Index;
   goto Exit_Row17_0;

end if;


Defer_Res31 :=
   Extended_If_Condition_Extract_Parse0 (Parser, Row_Pos17);
Defer_Pos31 := Parser.Current_Pos;




if Defer_Pos31 /= No_Token_Index then

   Row_Pos17 := Defer_Pos31;

else
   Row_Pos17 := No_Token_Index;
   goto Exit_Row17_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row17_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos17 /= No_Token_Index then

   Transform_Res14 := Allocate_Conditional_Transition (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res14,
      Kind => Rflx_Conditional_Transition,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos17 = Pos
                            then No_Token_Index
                            else Row_Pos17 - 1));

      Initialize_Fields_For_Conditional_Transition
        (Self => Transform_Res14, Transition_F_Target => Defer_Res29, Transition_F_Description => Defer_Res30, Conditional_Transition_F_Condition => Defer_Res31);

         if Defer_Res29 /= null and then Is_Incomplete (Defer_Res29) then
            Transform_Res14.Last_Attempted_Child := 0;
         elsif Defer_Res29 /= null and then not Is_Ghost (Defer_Res29) then
            Transform_Res14.Last_Attempted_Child := -1;
         end if;
         if Defer_Res30 /= null and then Is_Incomplete (Defer_Res30) then
            Transform_Res14.Last_Attempted_Child := 0;
         elsif Defer_Res30 /= null and then not Is_Ghost (Defer_Res30) then
            Transform_Res14.Last_Attempted_Child := -1;
         end if;
         if Defer_Res31 /= null and then Is_Incomplete (Defer_Res31) then
            Transform_Res14.Last_Attempted_Child := 0;
         elsif Defer_Res31 /= null and then not Is_Ghost (Defer_Res31) then
            Transform_Res14.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos17 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags14);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Conditional_Transition_Transform_Parse0_Memo,
      Row_Pos17 /= No_Token_Index,
      Transform_Res14,
      Pos,
      Row_Pos17);


   Parser.Current_Pos := Row_Pos17;

   return Transform_Res14;
end Conditional_Transition_Transform_Parse0;

   


function Context_Clause_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Context_Item_List
is
   use Bare_Context_Item_List_Memos;

      Lst_Cpos5 :
            Token_Index
               := No_Token_Index;
      Tmp_List5 :
            Free_Parse_List;
      Defer_Pos32 :
            Token_Index
               := No_Token_Index;
      Defer_Res32 :
            Bare_Context_Item
               := No_Bare_R_F_L_X_Node;
      List_Pos5 :
            Token_Index
               := No_Token_Index;
      List_Res5 :
            Bare_Context_Item_List
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Context_Clause_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res5 := M.Instance;
      return List_Res5;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res5;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos5 := Pos;



Lst_Cpos5 := Pos;
Tmp_List5 := Get_Parse_List (Parser);

loop
   
Defer_Res32 :=
   Context_Item_Transform_Parse0 (Parser, Lst_Cpos5);
Defer_Pos32 := Parser.Current_Pos;


   exit when Defer_Pos32 = No_Token_Index;

   List_Pos5 := Defer_Pos32;
   Lst_Cpos5 := List_Pos5;

   Tmp_List5.Nodes.Append (Defer_Res32);


end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List5.Nodes.Length;
begin
   List_Res5 :=
      Allocate_Context_Item_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos5 = Pos
                    then Pos
                    else Lst_Cpos5 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res5,
      Kind              => Rflx_Context_Item_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res5,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List5.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res5.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List5);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Context_Clause_List_Parse0_Memo,
      List_Pos5 /= No_Token_Index,
      List_Res5,
      Pos,
      List_Pos5);


   Parser.Current_Pos := List_Pos5;

   return List_Res5;
end Context_Clause_List_Parse0;

   


function Context_Item_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Context_Item
is
   use Bare_Context_Item_Memos;

      Row_Pos19 :
            Token_Index
               := No_Token_Index;
      Token_Pos35 :
            Token_Index
               := No_Token_Index;
      Token_Res35 :
            Token_Index
               := No_Token_Index;
      Defer_Pos33 :
            Token_Index
               := No_Token_Index;
      Defer_Res33 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos36 :
            Token_Index
               := No_Token_Index;
      Token_Res36 :
            Token_Index
               := No_Token_Index;
      Transform_Res15 :
            Bare_Context_Item
               := No_Bare_R_F_L_X_Node;
      Transform_Diags15 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Context_Item_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res15 := M.Instance;
      return Transform_Res15;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res15;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags15 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos19 := Pos;



--  Start tok_code

Token_Res35 := Row_Pos19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res35));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_With)
   then
       Token_Pos35 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos19,
             Expected_Token_Id => Rflx_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos35 := Row_Pos19 + 1;
   end if;
end;

--  End tok_code




if Token_Pos35 /= No_Token_Index then

   Row_Pos19 := Token_Pos35;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;


Defer_Res33 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos19);
Defer_Pos33 := Parser.Current_Pos;




if Defer_Pos33 /= No_Token_Index then

   Row_Pos19 := Defer_Pos33;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;


--  Start tok_code

Token_Res36 := Row_Pos19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res36));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos36 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos19,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos36 := Row_Pos19 + 1;
   end if;
end;

--  End tok_code




if Token_Pos36 /= No_Token_Index then

   Row_Pos19 := Token_Pos36;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row19_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos19 /= No_Token_Index then

   Transform_Res15 := Allocate_Context_Item (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res15,
      Kind => Rflx_Context_Item,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos19 = Pos
                            then No_Token_Index
                            else Row_Pos19 - 1));

      Initialize_Fields_For_Context_Item
        (Self => Transform_Res15, Context_Item_F_Item => Defer_Res33);

         if Defer_Res33 /= null and then Is_Incomplete (Defer_Res33) then
            Transform_Res15.Last_Attempted_Child := 0;
         elsif Defer_Res33 /= null and then not Is_Ghost (Defer_Res33) then
            Transform_Res15.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos19 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags15);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Context_Item_Transform_Parse0_Memo,
      Row_Pos19 /= No_Token_Index,
      Transform_Res15,
      Pos,
      Row_Pos19);


   Parser.Current_Pos := Row_Pos19;

   return Transform_Res15;
end Context_Item_Transform_Parse0;

   


function Conversion_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Conversion
is
   use Bare_Conversion_Memos;

      Row_Pos20 :
            Token_Index
               := No_Token_Index;
      Defer_Pos34 :
            Token_Index
               := No_Token_Index;
      Defer_Res34 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos37 :
            Token_Index
               := No_Token_Index;
      Token_Res37 :
            Token_Index
               := No_Token_Index;
      Defer_Pos35 :
            Token_Index
               := No_Token_Index;
      Defer_Res35 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos38 :
            Token_Index
               := No_Token_Index;
      Token_Res38 :
            Token_Index
               := No_Token_Index;
      Transform_Res16 :
            Bare_Conversion
               := No_Bare_R_F_L_X_Node;
      Transform_Diags16 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Conversion_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res16 := M.Instance;
      return Transform_Res16;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res16;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags16 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos20 := Pos;



Defer_Res34 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Row_Pos20);
Defer_Pos34 := Parser.Current_Pos;




if Defer_Pos34 /= No_Token_Index then

   Row_Pos20 := Defer_Pos34;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;


--  Start tok_code

Token_Res37 := Row_Pos20;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res37));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos37 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos20 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos20,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos37 := Row_Pos20 + 1;
   end if;
end;

--  End tok_code




if Token_Pos37 /= No_Token_Index then

   Row_Pos20 := Token_Pos37;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;


Defer_Res35 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos20);
Defer_Pos35 := Parser.Current_Pos;




if Defer_Pos35 /= No_Token_Index then

   Row_Pos20 := Defer_Pos35;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;


--  Start tok_code

Token_Res38 := Row_Pos20;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res38));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos38 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos20 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos20,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos38 := Row_Pos20 + 1;
   end if;
end;

--  End tok_code




if Token_Pos38 /= No_Token_Index then

   Row_Pos20 := Token_Pos38;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row20_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos20 /= No_Token_Index then

   Transform_Res16 := Allocate_Conversion (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res16,
      Kind => Rflx_Conversion,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos20 = Pos
                            then No_Token_Index
                            else Row_Pos20 - 1));

      Initialize_Fields_For_Conversion
        (Self => Transform_Res16, Conversion_F_Target_Identifier => Defer_Res34, Conversion_F_Argument => Defer_Res35);

         if Defer_Res34 /= null and then Is_Incomplete (Defer_Res34) then
            Transform_Res16.Last_Attempted_Child := 0;
         elsif Defer_Res34 /= null and then not Is_Ghost (Defer_Res34) then
            Transform_Res16.Last_Attempted_Child := -1;
         end if;
         if Defer_Res35 /= null and then Is_Incomplete (Defer_Res35) then
            Transform_Res16.Last_Attempted_Child := 0;
         elsif Defer_Res35 /= null and then not Is_Ghost (Defer_Res35) then
            Transform_Res16.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos20 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags16);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Conversion_Transform_Parse0_Memo,
      Row_Pos20 /= No_Token_Index,
      Transform_Res16,
      Pos,
      Row_Pos20);


   Parser.Current_Pos := Row_Pos20;

   return Transform_Res16;
end Conversion_Transform_Parse0;

   


function Declaration_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Local_Decl
is
   use Bare_Local_Decl_Memos;

      Defer_Pos36 :
            Token_Index
               := No_Token_Index;
      Defer_Res36 :
            Bare_Renaming_Decl
               := No_Bare_R_F_L_X_Node;
      Defer_Pos37 :
            Token_Index
               := No_Token_Index;
      Defer_Res37 :
            Bare_Variable_Decl
               := No_Bare_R_F_L_X_Node;
      Or_Pos9 :
            Token_Index
               := No_Token_Index;
      Or_Res9 :
            Bare_Local_Decl
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Declaration_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res9 := M.Instance;
      return Or_Res9;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res9;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos9 := No_Token_Index;
Or_Res9 := No_Bare_R_F_L_X_Node;
    
Defer_Res36 :=
   Renaming_Declaration_Transform_Parse0 (Parser, Pos);
Defer_Pos36 := Parser.Current_Pos;

    if Defer_Pos36 /= No_Token_Index then
        Or_Pos9 := Defer_Pos36;
        Or_Res9 := Defer_Res36;
        goto Exit_Or9;
    end if;
    
Defer_Res37 :=
   Variable_Declaration_Transform_Parse0 (Parser, Pos);
Defer_Pos37 := Parser.Current_Pos;

    if Defer_Pos37 /= No_Token_Index then
        Or_Pos9 := Defer_Pos37;
        Or_Res9 := Defer_Res37;
        goto Exit_Or9;
    end if;
<<Exit_Or9>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Declaration_Or_Parse0_Memo,
      Or_Pos9 /= No_Token_Index,
      Or_Res9,
      Pos,
      Or_Pos9);


   Parser.Current_Pos := Or_Pos9;

   return Or_Res9;
end Declaration_Or_Parse0;

   


function Description_Aspect_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Description
is
   use Bare_Description_Memos;

      Row_Pos21 :
            Token_Index
               := No_Token_Index;
      Token_Pos39 :
            Token_Index
               := No_Token_Index;
      Token_Res39 :
            Token_Index
               := No_Token_Index;
      Token_Pos40 :
            Token_Index
               := No_Token_Index;
      Token_Res40 :
            Token_Index
               := No_Token_Index;
      Defer_Pos38 :
            Token_Index
               := No_Token_Index;
      Defer_Res38 :
            Bare_String_Literal
               := No_Bare_R_F_L_X_Node;
      Transform_Res17 :
            Bare_Description
               := No_Bare_R_F_L_X_Node;
      Transform_Diags17 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Description_Aspect_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res17 := M.Instance;
      return Transform_Res17;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res17;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags17 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos21 := Pos;



--  Start tok_code

Token_Res39 := Row_Pos21;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res39));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Desc)
   then
       Token_Pos39 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos21 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos21,
             Expected_Token_Id => Rflx_Desc,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos39 := Row_Pos21 + 1;
   end if;
end;

--  End tok_code




if Token_Pos39 /= No_Token_Index then

   Row_Pos21 := Token_Pos39;

else
   Row_Pos21 := No_Token_Index;
   goto Exit_Row21_0;

end if;


--  Start tok_code

Token_Res40 := Row_Pos21;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res40));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Arrow)
   then
       Token_Pos40 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos21 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos21,
             Expected_Token_Id => Rflx_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos40 := Row_Pos21 + 1;
   end if;
end;

--  End tok_code




if Token_Pos40 /= No_Token_Index then

   Row_Pos21 := Token_Pos40;

else
   Row_Pos21 := No_Token_Index;
   goto Exit_Row21_0;

end if;


Defer_Res38 :=
   String_Literal_Transform_Parse0 (Parser, Row_Pos21);
Defer_Pos38 := Parser.Current_Pos;




if Defer_Pos38 /= No_Token_Index then

   Row_Pos21 := Defer_Pos38;

else
   Row_Pos21 := No_Token_Index;
   goto Exit_Row21_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row21_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos21 /= No_Token_Index then

   Transform_Res17 := Allocate_Description (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res17,
      Kind => Rflx_Description,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos21 = Pos
                            then No_Token_Index
                            else Row_Pos21 - 1));

      Initialize_Fields_For_Description
        (Self => Transform_Res17, Description_F_Content => Defer_Res38);

         if Defer_Res38 /= null and then Is_Incomplete (Defer_Res38) then
            Transform_Res17.Last_Attempted_Child := 0;
         elsif Defer_Res38 /= null and then not Is_Ghost (Defer_Res38) then
            Transform_Res17.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos21 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags17);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Description_Aspect_Transform_Parse0_Memo,
      Row_Pos21 /= No_Token_Index,
      Transform_Res17,
      Pos,
      Row_Pos21);


   Parser.Current_Pos := Row_Pos21;

   return Transform_Res17;
end Description_Aspect_Transform_Parse0;

   


function Element_Value_Association_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Element_Value_Assoc
is
   use Bare_Element_Value_Assoc_Memos;

      Row_Pos22 :
            Token_Index
               := No_Token_Index;
      Defer_Pos39 :
            Token_Index
               := No_Token_Index;
      Defer_Res39 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos41 :
            Token_Index
               := No_Token_Index;
      Token_Res41 :
            Token_Index
               := No_Token_Index;
      Defer_Pos40 :
            Token_Index
               := No_Token_Index;
      Defer_Res40 :
            Bare_Numeric_Literal
               := No_Bare_R_F_L_X_Node;
      Transform_Res18 :
            Bare_Element_Value_Assoc
               := No_Bare_R_F_L_X_Node;
      Transform_Diags18 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Element_Value_Association_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res18 := M.Instance;
      return Transform_Res18;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res18;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags18 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos22 := Pos;



Defer_Res39 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos22);
Defer_Pos39 := Parser.Current_Pos;




if Defer_Pos39 /= No_Token_Index then

   Row_Pos22 := Defer_Pos39;

else
   Row_Pos22 := No_Token_Index;
   goto Exit_Row22_0;

end if;


--  Start tok_code

Token_Res41 := Row_Pos22;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res41));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Arrow)
   then
       Token_Pos41 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos22 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos22,
             Expected_Token_Id => Rflx_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos41 := Row_Pos22 + 1;
   end if;
end;

--  End tok_code




if Token_Pos41 /= No_Token_Index then

   Row_Pos22 := Token_Pos41;

else
   Row_Pos22 := No_Token_Index;
   goto Exit_Row22_0;

end if;


Defer_Res40 :=
   Numeric_Literal_Transform_Parse0 (Parser, Row_Pos22);
Defer_Pos40 := Parser.Current_Pos;




if Defer_Pos40 /= No_Token_Index then

   Row_Pos22 := Defer_Pos40;

else
   Row_Pos22 := No_Token_Index;
   goto Exit_Row22_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row22_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos22 /= No_Token_Index then

   Transform_Res18 := Allocate_Element_Value_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res18,
      Kind => Rflx_Element_Value_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos22 = Pos
                            then No_Token_Index
                            else Row_Pos22 - 1));

      Initialize_Fields_For_Element_Value_Assoc
        (Self => Transform_Res18, Element_Value_Assoc_F_Identifier => Defer_Res39, Element_Value_Assoc_F_Literal => Defer_Res40);

         if Defer_Res39 /= null and then Is_Incomplete (Defer_Res39) then
            Transform_Res18.Last_Attempted_Child := 0;
         elsif Defer_Res39 /= null and then not Is_Ghost (Defer_Res39) then
            Transform_Res18.Last_Attempted_Child := -1;
         end if;
         if Defer_Res40 /= null and then Is_Incomplete (Defer_Res40) then
            Transform_Res18.Last_Attempted_Child := 0;
         elsif Defer_Res40 /= null and then not Is_Ghost (Defer_Res40) then
            Transform_Res18.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos22 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags18);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Element_Value_Association_Transform_Parse0_Memo,
      Row_Pos22 /= No_Token_Index,
      Transform_Res18,
      Pos,
      Row_Pos22);


   Parser.Current_Pos := Row_Pos22;

   return Transform_Res18;
end Element_Value_Association_Transform_Parse0;

   


function Enumeration_Aspects_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_List
is
   use Bare_Aspect_List_Memos;

      Lst_Cpos6 :
            Token_Index
               := No_Token_Index;
      Tmp_List6 :
            Free_Parse_List;
      Defer_Pos41 :
            Token_Index
               := No_Token_Index;
      Defer_Res41 :
            Bare_Aspect
               := No_Bare_R_F_L_X_Node;
      Defer_Pos42 :
            Token_Index
               := No_Token_Index;
      Defer_Res42 :
            Bare_Aspect
               := No_Bare_R_F_L_X_Node;
      Or_Pos10 :
            Token_Index
               := No_Token_Index;
      Or_Res10 :
            Bare_Aspect
               := No_Bare_R_F_L_X_Node;
      Token_Pos42 :
            Token_Index
               := No_Token_Index;
      Token_Res42 :
            Token_Index
               := No_Token_Index;
      List_Pos6 :
            Token_Index
               := No_Token_Index;
      List_Res6 :
            Bare_Aspect_List
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Enumeration_Aspects_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res6 := M.Instance;
      return List_Res6;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res6;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos6 := No_Token_Index;



Lst_Cpos6 := Pos;
Tmp_List6 := Get_Parse_List (Parser);

loop
   
--  Start or_code

Or_Pos10 := No_Token_Index;
Or_Res10 := No_Bare_R_F_L_X_Node;
    
Defer_Res41 :=
   Aspect_Transform_Parse0 (Parser, Lst_Cpos6);
Defer_Pos41 := Parser.Current_Pos;

    if Defer_Pos41 /= No_Token_Index then
        Or_Pos10 := Defer_Pos41;
        Or_Res10 := Defer_Res41;
        goto Exit_Or10;
    end if;
    
Defer_Res42 :=
   Aspect_Transform_Parse0 (Parser, Lst_Cpos6);
Defer_Pos42 := Parser.Current_Pos;

    if Defer_Pos42 /= No_Token_Index then
        Or_Pos10 := Defer_Pos42;
        Or_Res10 := Defer_Res42;
        goto Exit_Or10;
    end if;
<<Exit_Or10>>

--  End or_code


   exit when Or_Pos10 = No_Token_Index;

   List_Pos6 := Or_Pos10;
   Lst_Cpos6 := List_Pos6;

   Tmp_List6.Nodes.Append (Or_Res10);

      
--  Start tok_code

Token_Res42 := Lst_Cpos6;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res42));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos42 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos6 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos6,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos42 := Lst_Cpos6 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos42 /= No_Token_Index then
          Lst_Cpos6 := Token_Pos42;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List6.Nodes.Length;
begin
   List_Res6 :=
      Allocate_Aspect_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos6 = Pos
                    then Pos
                    else Lst_Cpos6 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res6,
      Kind              => Rflx_Aspect_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res6,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List6.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res6.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List6);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Enumeration_Aspects_List_Parse0_Memo,
      List_Pos6 /= No_Token_Index,
      List_Res6,
      Pos,
      List_Pos6);


   Parser.Current_Pos := List_Pos6;

   return List_Res6;
end Enumeration_Aspects_List_Parse0;

   


function Enumeration_Type_Definition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Enumeration_Type_Def
is
   use Bare_Enumeration_Type_Def_Memos;

      Row_Pos23 :
            Token_Index
               := No_Token_Index;
      Token_Pos43 :
            Token_Index
               := No_Token_Index;
      Token_Res43 :
            Token_Index
               := No_Token_Index;
      Defer_Pos43 :
            Token_Index
               := No_Token_Index;
      Defer_Res43 :
            Bare_Named_Enumeration_Def
               := No_Bare_R_F_L_X_Node;
      Defer_Pos44 :
            Token_Index
               := No_Token_Index;
      Defer_Res44 :
            Bare_Positional_Enumeration_Def
               := No_Bare_R_F_L_X_Node;
      Or_Pos11 :
            Token_Index
               := No_Token_Index;
      Or_Res11 :
            Bare_Enumeration_Def
               := No_Bare_R_F_L_X_Node;
      Token_Pos44 :
            Token_Index
               := No_Token_Index;
      Token_Res44 :
            Token_Index
               := No_Token_Index;
      Token_Pos45 :
            Token_Index
               := No_Token_Index;
      Token_Res45 :
            Token_Index
               := No_Token_Index;
      Defer_Pos45 :
            Token_Index
               := No_Token_Index;
      Defer_Res45 :
            Bare_Aspect_List
               := No_Bare_R_F_L_X_Node;
      Transform_Res19 :
            Bare_Enumeration_Type_Def
               := No_Bare_R_F_L_X_Node;
      Transform_Diags19 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Enumeration_Type_Definition_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res19 := M.Instance;
      return Transform_Res19;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res19;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags19 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos23 := Pos;



--  Start tok_code

Token_Res43 := Row_Pos23;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res43));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos43 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos23 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos23,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos43 := Row_Pos23 + 1;
   end if;
end;

--  End tok_code




if Token_Pos43 /= No_Token_Index then

   Row_Pos23 := Token_Pos43;

else
   Row_Pos23 := No_Token_Index;
   goto Exit_Row23_0;

end if;


--  Start or_code

Or_Pos11 := No_Token_Index;
Or_Res11 := No_Bare_R_F_L_X_Node;
    
Defer_Res43 :=
   Named_Enumeration_Transform_Parse0 (Parser, Row_Pos23);
Defer_Pos43 := Parser.Current_Pos;

    if Defer_Pos43 /= No_Token_Index then
        Or_Pos11 := Defer_Pos43;
        Or_Res11 := Defer_Res43;
        goto Exit_Or11;
    end if;
    
Defer_Res44 :=
   Positional_Enumeration_Transform_Parse0 (Parser, Row_Pos23);
Defer_Pos44 := Parser.Current_Pos;

    if Defer_Pos44 /= No_Token_Index then
        Or_Pos11 := Defer_Pos44;
        Or_Res11 := Defer_Res44;
        goto Exit_Or11;
    end if;
<<Exit_Or11>>

--  End or_code




if Or_Pos11 /= No_Token_Index then

   Row_Pos23 := Or_Pos11;

else
   Row_Pos23 := No_Token_Index;
   goto Exit_Row23_0;

end if;


--  Start tok_code

Token_Res44 := Row_Pos23;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res44));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos44 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos23 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos23,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos44 := Row_Pos23 + 1;
   end if;
end;

--  End tok_code




if Token_Pos44 /= No_Token_Index then

   Row_Pos23 := Token_Pos44;

else
   Row_Pos23 := No_Token_Index;
   goto Exit_Row23_0;

end if;


--  Start tok_code

Token_Res45 := Row_Pos23;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res45));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_With)
   then
       Token_Pos45 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos23 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos23,
             Expected_Token_Id => Rflx_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos45 := Row_Pos23 + 1;
   end if;
end;

--  End tok_code




if Token_Pos45 /= No_Token_Index then

   Row_Pos23 := Token_Pos45;

else
   Row_Pos23 := No_Token_Index;
   goto Exit_Row23_0;

end if;


Defer_Res45 :=
   Enumeration_Aspects_List_Parse0 (Parser, Row_Pos23);
Defer_Pos45 := Parser.Current_Pos;




if Defer_Pos45 /= No_Token_Index then

   Row_Pos23 := Defer_Pos45;

else
   Row_Pos23 := No_Token_Index;
   goto Exit_Row23_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row23_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos23 /= No_Token_Index then

   Transform_Res19 := Allocate_Enumeration_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res19,
      Kind => Rflx_Enumeration_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos23 = Pos
                            then No_Token_Index
                            else Row_Pos23 - 1));

      Initialize_Fields_For_Enumeration_Type_Def
        (Self => Transform_Res19, Enumeration_Type_Def_F_Elements => Or_Res11, Enumeration_Type_Def_F_Aspects => Defer_Res45);

         if Or_Res11 /= null and then Is_Incomplete (Or_Res11) then
            Transform_Res19.Last_Attempted_Child := 0;
         elsif Or_Res11 /= null and then not Is_Ghost (Or_Res11) then
            Transform_Res19.Last_Attempted_Child := -1;
         end if;
         if Defer_Res45 /= null and then Is_Incomplete (Defer_Res45) then
            Transform_Res19.Last_Attempted_Child := 0;
         elsif Defer_Res45 /= null and then not Is_Ghost (Defer_Res45) then
            Transform_Res19.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos23 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags19);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Enumeration_Type_Definition_Transform_Parse0_Memo,
      Row_Pos23 /= No_Token_Index,
      Transform_Res19,
      Pos,
      Row_Pos23);


   Parser.Current_Pos := Row_Pos23;

   return Transform_Res19;
end Enumeration_Type_Definition_Transform_Parse0;

   


function Expression_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt1 :
            Boolean
               := False;
      Row_Pos24 :
            Token_Index
               := No_Token_Index;
      Defer_Pos46 :
            Token_Index
               := No_Token_Index;
      Defer_Res46 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Pos25 :
            Token_Index
               := No_Token_Index;
      Token_Pos46 :
            Token_Index
               := No_Token_Index;
      Token_Res46 :
            Token_Index
               := No_Token_Index;
      Transform_Res20 :
            Bare_Op_And
               := No_Bare_R_F_L_X_Node;
      Transform_Diags20 :
            Ada.Containers.Count_Type;
      Row_Pos26 :
            Token_Index
               := No_Token_Index;
      Token_Pos47 :
            Token_Index
               := No_Token_Index;
      Token_Res47 :
            Token_Index
               := No_Token_Index;
      Transform_Res21 :
            Bare_Op_Or
               := No_Bare_R_F_L_X_Node;
      Transform_Diags21 :
            Ada.Containers.Count_Type;
      Or_Pos12 :
            Token_Index
               := No_Token_Index;
      Or_Res12 :
            Bare_Op
               := No_Bare_R_F_L_X_Node;
      Defer_Pos47 :
            Token_Index
               := No_Token_Index;
      Defer_Res47 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Progress1 :
            Integer
               := 0;
      Transform_Res22 :
            Bare_Bin_Op
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed1 :
            Boolean
               := False;
      Transform_Diags22 :
            Ada.Containers.Count_Type;
      Defer_Pos48 :
            Token_Index
               := No_Token_Index;
      Defer_Res48 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos13 :
            Token_Index
               := No_Token_Index;
      Or_Res13 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Expression_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res13 := M.Instance;
      return Or_Res13;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res13;
   end if;

       Set (Parser.Private_Part.Expression_Or_Parse1_Memo, False, Or_Res13, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt1 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos13 := No_Token_Index;
Or_Res13 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags22 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos24 := Pos;



Defer_Res46 :=
   Expression_Or_Parse1 (Parser, Row_Pos24);
Defer_Pos46 := Parser.Current_Pos;



Row_Progress1 := 1;

if Defer_Pos46 /= No_Token_Index then

   Row_Pos24 := Defer_Pos46;

else
   Row_Pos24 := No_Token_Index;
   goto Exit_Row24_0;

end if;


--  Start or_code

Or_Pos12 := No_Token_Index;
Or_Res12 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags20 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos25 := Row_Pos24;



--  Start tok_code

Token_Res46 := Row_Pos25;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res46));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_And)
   then
       Token_Pos46 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos25 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos25,
             Expected_Token_Id => Rflx_And,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos46 := Row_Pos25 + 1;
   end if;
end;

--  End tok_code




if Token_Pos46 /= No_Token_Index then

   Row_Pos25 := Token_Pos46;

else
   Row_Pos25 := No_Token_Index;
   goto Exit_Row25_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row25_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos25 /= No_Token_Index then

   Transform_Res20 := Allocate_Op_And (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res20,
      Kind => Rflx_Op_And,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos24,
      Token_End_Index   => (if Row_Pos25 = Row_Pos24
                            then No_Token_Index
                            else Row_Pos25 - 1));




elsif Row_Pos25 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags20);
end if;

--  End transform_code

    if Row_Pos25 /= No_Token_Index then
        Or_Pos12 := Row_Pos25;
        Or_Res12 := Transform_Res20;
        goto Exit_Or13;
    end if;
    
--  Start transform_code

Transform_Diags21 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos26 := Row_Pos24;



--  Start tok_code

Token_Res47 := Row_Pos26;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res47));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Or)
   then
       Token_Pos47 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos26 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos26,
             Expected_Token_Id => Rflx_Or,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos47 := Row_Pos26 + 1;
   end if;
end;

--  End tok_code




if Token_Pos47 /= No_Token_Index then

   Row_Pos26 := Token_Pos47;

else
   Row_Pos26 := No_Token_Index;
   goto Exit_Row26_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row26_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos26 /= No_Token_Index then

   Transform_Res21 := Allocate_Op_Or (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res21,
      Kind => Rflx_Op_Or,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos24,
      Token_End_Index   => (if Row_Pos26 = Row_Pos24
                            then No_Token_Index
                            else Row_Pos26 - 1));




elsif Row_Pos26 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags21);
end if;

--  End transform_code

    if Row_Pos26 /= No_Token_Index then
        Or_Pos12 := Row_Pos26;
        Or_Res12 := Transform_Res21;
        goto Exit_Or13;
    end if;
<<Exit_Or13>>

--  End or_code



Row_Progress1 := 2;

if Or_Pos12 /= No_Token_Index then

   Row_Pos24 := Or_Pos12;

else
   Row_Pos24 := No_Token_Index;
   goto Exit_Row24_0;

end if;

Nobt1 := True;

   Nobt1 := Nobt1;

Row_Progress1 := 3;

if Row_Pos24 /= No_Token_Index then

   Row_Pos24 := Row_Pos24;

else
   Row_Pos24 := No_Token_Index;
   goto Exit_Row24_0;

end if;


Defer_Res47 :=
   Relation_Or_Parse1 (Parser, Row_Pos24);
Defer_Pos47 := Parser.Current_Pos;



Row_Progress1 := 4;

if Defer_Pos47 /= No_Token_Index then

   Row_Pos24 := Defer_Pos47;

else
   Row_Pos24 := No_Token_Index;
   goto Exit_Row24_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row24_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos24 = No_Token_Index and then Nobt1 then

   Row_Pos24 := Parser.Last_Fail.Pos;

   Transform_Has_Failed1 := True;
end if;

if Row_Pos24 /= No_Token_Index then

   Transform_Res22 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res22,
      Kind => Rflx_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos24 = Pos
                            then No_Token_Index
                            else Row_Pos24 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res22, Bin_Op_F_Left => Defer_Res46, Bin_Op_F_Op => Or_Res12, Bin_Op_F_Right => Defer_Res47);

         if Defer_Res46 /= null and then Is_Incomplete (Defer_Res46) then
            Transform_Res22.Last_Attempted_Child := 0;
         elsif Defer_Res46 /= null and then not Is_Ghost (Defer_Res46) then
            Transform_Res22.Last_Attempted_Child := -1;
         end if;
         if Or_Res12 /= null and then Is_Incomplete (Or_Res12) then
            Transform_Res22.Last_Attempted_Child := 0;
         elsif Or_Res12 /= null and then not Is_Ghost (Or_Res12) then
            Transform_Res22.Last_Attempted_Child := -1;
         end if;
         if Defer_Res47 /= null and then Is_Incomplete (Defer_Res47) then
            Transform_Res22.Last_Attempted_Child := 0;
         elsif Defer_Res47 /= null and then not Is_Ghost (Defer_Res47) then
            Transform_Res22.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed1 then
      Transform_Res22.Last_Attempted_Child :=
         Row_Progress1;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <expression>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos24 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags22);
end if;

--  End transform_code

    if Row_Pos24 /= No_Token_Index then
        Or_Pos13 := Row_Pos24;
        Or_Res13 := Transform_Res22;
        goto Exit_Or12;
    end if;
    
Defer_Res48 :=
   Relation_Or_Parse1 (Parser, Pos);
Defer_Pos48 := Parser.Current_Pos;

    if Defer_Pos48 /= No_Token_Index then
        Or_Pos13 := Defer_Pos48;
        Or_Res13 := Defer_Res48;
        goto Exit_Or12;
    end if;
<<Exit_Or12>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos13 > Mem_Pos then
         Mem_Pos := Or_Pos13;
         Mem_Res := Or_Res13;
         Set
           (Parser.Private_Part.Expression_Or_Parse1_Memo,
            Or_Pos13 /= No_Token_Index,
            Or_Res13,
            Pos,
            Or_Pos13);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res13 := Mem_Res;
         Or_Pos13 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Expression_Or_Parse1_Memo,
      Or_Pos13 /= No_Token_Index,
      Or_Res13,
      Pos,
      Or_Pos13);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos13;

   return Or_Res13;
end Expression_Or_Parse1;

   


function Extended_Case_Expression_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Expression
is
   use Bare_Case_Expression_Memos;

      Row_Pos27 :
            Token_Index
               := No_Token_Index;
      Token_Pos48 :
            Token_Index
               := No_Token_Index;
      Token_Res48 :
            Token_Index
               := No_Token_Index;
      Token_Pos49 :
            Token_Index
               := No_Token_Index;
      Token_Res49 :
            Token_Index
               := No_Token_Index;
      Defer_Pos49 :
            Token_Index
               := No_Token_Index;
      Defer_Res49 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos50 :
            Token_Index
               := No_Token_Index;
      Token_Res50 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos7 :
            Token_Index
               := No_Token_Index;
      Tmp_List7 :
            Free_Parse_List;
      Defer_Pos50 :
            Token_Index
               := No_Token_Index;
      Defer_Res50 :
            Bare_Choice
               := No_Bare_R_F_L_X_Node;
      Token_Pos51 :
            Token_Index
               := No_Token_Index;
      Token_Res51 :
            Token_Index
               := No_Token_Index;
      List_Pos7 :
            Token_Index
               := No_Token_Index;
      List_Res7 :
            Bare_Choice_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos52 :
            Token_Index
               := No_Token_Index;
      Token_Res52 :
            Token_Index
               := No_Token_Index;
      Transform_Res23 :
            Bare_Case_Expression
               := No_Bare_R_F_L_X_Node;
      Transform_Diags23 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_Case_Expression_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res23 := M.Instance;
      return Transform_Res23;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res23;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags23 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos27 := Pos;



--  Start tok_code

Token_Res48 := Row_Pos27;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res48));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos48 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos27 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos27,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos48 := Row_Pos27 + 1;
   end if;
end;

--  End tok_code




if Token_Pos48 /= No_Token_Index then

   Row_Pos27 := Token_Pos48;

else
   Row_Pos27 := No_Token_Index;
   goto Exit_Row27_0;

end if;


--  Start tok_code

Token_Res49 := Row_Pos27;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res49));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Case)
   then
       Token_Pos49 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos27 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos27,
             Expected_Token_Id => Rflx_Case,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos49 := Row_Pos27 + 1;
   end if;
end;

--  End tok_code




if Token_Pos49 /= No_Token_Index then

   Row_Pos27 := Token_Pos49;

else
   Row_Pos27 := No_Token_Index;
   goto Exit_Row27_0;

end if;


Defer_Res49 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos27);
Defer_Pos49 := Parser.Current_Pos;




if Defer_Pos49 /= No_Token_Index then

   Row_Pos27 := Defer_Pos49;

else
   Row_Pos27 := No_Token_Index;
   goto Exit_Row27_0;

end if;


--  Start tok_code

Token_Res50 := Row_Pos27;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res50));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Is)
   then
       Token_Pos50 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos27 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos27,
             Expected_Token_Id => Rflx_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos50 := Row_Pos27 + 1;
   end if;
end;

--  End tok_code




if Token_Pos50 /= No_Token_Index then

   Row_Pos27 := Token_Pos50;

else
   Row_Pos27 := No_Token_Index;
   goto Exit_Row27_0;

end if;


--  Start list_code

    List_Pos7 := No_Token_Index;



Lst_Cpos7 := Row_Pos27;
Tmp_List7 := Get_Parse_List (Parser);

loop
   
Defer_Res50 :=
   Extended_Choices_Transform_Parse0 (Parser, Lst_Cpos7);
Defer_Pos50 := Parser.Current_Pos;


   exit when Defer_Pos50 = No_Token_Index;

   List_Pos7 := Defer_Pos50;
   Lst_Cpos7 := List_Pos7;

   Tmp_List7.Nodes.Append (Defer_Res50);

      
--  Start tok_code

Token_Res51 := Lst_Cpos7;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res51));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos51 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos7 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos7,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos51 := Lst_Cpos7 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos51 /= No_Token_Index then
          Lst_Cpos7 := Token_Pos51;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List7.Nodes.Length;
begin
   List_Res7 :=
      Allocate_Choice_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos27;
      Token_End := (if Lst_Cpos7 = Row_Pos27
                    then Row_Pos27
                    else Lst_Cpos7 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos27, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res7,
      Kind              => Rflx_Choice_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res7,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List7.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res7.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List7);

--  End list_code




if List_Pos7 /= No_Token_Index then

   Row_Pos27 := List_Pos7;

else
   Row_Pos27 := No_Token_Index;
   goto Exit_Row27_0;

end if;


--  Start tok_code

Token_Res52 := Row_Pos27;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res52));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos52 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos27 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos27,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos52 := Row_Pos27 + 1;
   end if;
end;

--  End tok_code




if Token_Pos52 /= No_Token_Index then

   Row_Pos27 := Token_Pos52;

else
   Row_Pos27 := No_Token_Index;
   goto Exit_Row27_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row27_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos27 /= No_Token_Index then

   Transform_Res23 := Allocate_Case_Expression (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res23,
      Kind => Rflx_Case_Expression,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos27 = Pos
                            then No_Token_Index
                            else Row_Pos27 - 1));

      Initialize_Fields_For_Case_Expression
        (Self => Transform_Res23, Case_Expression_F_Expression => Defer_Res49, Case_Expression_F_Choices => List_Res7);

         if Defer_Res49 /= null and then Is_Incomplete (Defer_Res49) then
            Transform_Res23.Last_Attempted_Child := 0;
         elsif Defer_Res49 /= null and then not Is_Ghost (Defer_Res49) then
            Transform_Res23.Last_Attempted_Child := -1;
         end if;
         if List_Res7 /= null and then Is_Incomplete (List_Res7) then
            Transform_Res23.Last_Attempted_Child := 0;
         elsif List_Res7 /= null and then not Is_Ghost (List_Res7) then
            Transform_Res23.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos27 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags23);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_Case_Expression_Transform_Parse0_Memo,
      Row_Pos27 /= No_Token_Index,
      Transform_Res23,
      Pos,
      Row_Pos27);


   Parser.Current_Pos := Row_Pos27;

   return Transform_Res23;
end Extended_Case_Expression_Transform_Parse0;

   


function Extended_Choice_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_R_F_L_X_Node_List
is
   use Bare_R_F_L_X_Node_List_Memos;

      Lst_Cpos8 :
            Token_Index
               := No_Token_Index;
      Tmp_List8 :
            Free_Parse_List;
      Defer_Pos51 :
            Token_Index
               := No_Token_Index;
      Defer_Res51 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Defer_Pos52 :
            Token_Index
               := No_Token_Index;
      Defer_Res52 :
            Bare_Numeric_Literal
               := No_Bare_R_F_L_X_Node;
      Or_Pos14 :
            Token_Index
               := No_Token_Index;
      Or_Res14 :
            Bare_R_F_L_X_Node
               := No_Bare_R_F_L_X_Node;
      Token_Pos53 :
            Token_Index
               := No_Token_Index;
      Token_Res53 :
            Token_Index
               := No_Token_Index;
      List_Pos8 :
            Token_Index
               := No_Token_Index;
      List_Res8 :
            Bare_R_F_L_X_Node_List
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_Choice_List_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res8 := M.Instance;
      return List_Res8;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res8;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos8 := No_Token_Index;



Lst_Cpos8 := Pos;
Tmp_List8 := Get_Parse_List (Parser);

loop
   
--  Start or_code

Or_Pos14 := No_Token_Index;
Or_Res14 := No_Bare_R_F_L_X_Node;
    
Defer_Res51 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Lst_Cpos8);
Defer_Pos51 := Parser.Current_Pos;

    if Defer_Pos51 /= No_Token_Index then
        Or_Pos14 := Defer_Pos51;
        Or_Res14 := Defer_Res51;
        goto Exit_Or14;
    end if;
    
Defer_Res52 :=
   Numeric_Literal_Transform_Parse0 (Parser, Lst_Cpos8);
Defer_Pos52 := Parser.Current_Pos;

    if Defer_Pos52 /= No_Token_Index then
        Or_Pos14 := Defer_Pos52;
        Or_Res14 := Defer_Res52;
        goto Exit_Or14;
    end if;
<<Exit_Or14>>

--  End or_code


   exit when Or_Pos14 = No_Token_Index;

   List_Pos8 := Or_Pos14;
   Lst_Cpos8 := List_Pos8;

   Tmp_List8.Nodes.Append (Or_Res14);

      
--  Start tok_code

Token_Res53 := Lst_Cpos8;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res53));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Pipe)
   then
       Token_Pos53 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos8 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos8,
             Expected_Token_Id => Rflx_Pipe,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos53 := Lst_Cpos8 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos53 /= No_Token_Index then
          Lst_Cpos8 := Token_Pos53;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List8.Nodes.Length;
begin
   List_Res8 :=
      Allocate_R_F_L_X_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos8 = Pos
                    then Pos
                    else Lst_Cpos8 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res8,
      Kind              => Rflx_R_F_L_X_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res8,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List8.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res8.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List8);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_Choice_List_List_Parse0_Memo,
      List_Pos8 /= No_Token_Index,
      List_Res8,
      Pos,
      List_Pos8);


   Parser.Current_Pos := List_Pos8;

   return List_Res8;
end Extended_Choice_List_List_Parse0;

   


function Extended_Choices_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Choice
is
   use Bare_Choice_Memos;

      Row_Pos28 :
            Token_Index
               := No_Token_Index;
      Token_Pos54 :
            Token_Index
               := No_Token_Index;
      Token_Res54 :
            Token_Index
               := No_Token_Index;
      Defer_Pos53 :
            Token_Index
               := No_Token_Index;
      Defer_Res53 :
            Bare_R_F_L_X_Node_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos55 :
            Token_Index
               := No_Token_Index;
      Token_Res55 :
            Token_Index
               := No_Token_Index;
      Defer_Pos54 :
            Token_Index
               := No_Token_Index;
      Defer_Res54 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res24 :
            Bare_Choice
               := No_Bare_R_F_L_X_Node;
      Transform_Diags24 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_Choices_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res24 := M.Instance;
      return Transform_Res24;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res24;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags24 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos28 := Pos;



--  Start tok_code

Token_Res54 := Row_Pos28;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res54));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_When)
   then
       Token_Pos54 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos28 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos28,
             Expected_Token_Id => Rflx_When,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos54 := Row_Pos28 + 1;
   end if;
end;

--  End tok_code




if Token_Pos54 /= No_Token_Index then

   Row_Pos28 := Token_Pos54;

else
   Row_Pos28 := No_Token_Index;
   goto Exit_Row28_0;

end if;


Defer_Res53 :=
   Extended_Choice_List_List_Parse0 (Parser, Row_Pos28);
Defer_Pos53 := Parser.Current_Pos;




if Defer_Pos53 /= No_Token_Index then

   Row_Pos28 := Defer_Pos53;

else
   Row_Pos28 := No_Token_Index;
   goto Exit_Row28_0;

end if;


--  Start tok_code

Token_Res55 := Row_Pos28;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res55));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Arrow)
   then
       Token_Pos55 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos28 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos28,
             Expected_Token_Id => Rflx_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos55 := Row_Pos28 + 1;
   end if;
end;

--  End tok_code




if Token_Pos55 /= No_Token_Index then

   Row_Pos28 := Token_Pos55;

else
   Row_Pos28 := No_Token_Index;
   goto Exit_Row28_0;

end if;


Defer_Res54 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos28);
Defer_Pos54 := Parser.Current_Pos;




if Defer_Pos54 /= No_Token_Index then

   Row_Pos28 := Defer_Pos54;

else
   Row_Pos28 := No_Token_Index;
   goto Exit_Row28_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row28_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos28 /= No_Token_Index then

   Transform_Res24 := Allocate_Choice (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res24,
      Kind => Rflx_Choice,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos28 = Pos
                            then No_Token_Index
                            else Row_Pos28 - 1));

      Initialize_Fields_For_Choice
        (Self => Transform_Res24, Choice_F_Selectors => Defer_Res53, Choice_F_Expression => Defer_Res54);

         if Defer_Res53 /= null and then Is_Incomplete (Defer_Res53) then
            Transform_Res24.Last_Attempted_Child := 0;
         elsif Defer_Res53 /= null and then not Is_Ghost (Defer_Res53) then
            Transform_Res24.Last_Attempted_Child := -1;
         end if;
         if Defer_Res54 /= null and then Is_Incomplete (Defer_Res54) then
            Transform_Res24.Last_Attempted_Child := 0;
         elsif Defer_Res54 /= null and then not Is_Ghost (Defer_Res54) then
            Transform_Res24.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos28 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags24);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_Choices_Transform_Parse0_Memo,
      Row_Pos28 /= No_Token_Index,
      Transform_Res24,
      Pos,
      Row_Pos28);


   Parser.Current_Pos := Row_Pos28;

   return Transform_Res24;
end Extended_Choices_Transform_Parse0;

   


function Extended_Expression_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt2 :
            Boolean
               := False;
      Row_Pos29 :
            Token_Index
               := No_Token_Index;
      Defer_Pos55 :
            Token_Index
               := No_Token_Index;
      Defer_Res55 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Pos30 :
            Token_Index
               := No_Token_Index;
      Token_Pos56 :
            Token_Index
               := No_Token_Index;
      Token_Res56 :
            Token_Index
               := No_Token_Index;
      Transform_Res25 :
            Bare_Op_And
               := No_Bare_R_F_L_X_Node;
      Transform_Diags25 :
            Ada.Containers.Count_Type;
      Row_Pos31 :
            Token_Index
               := No_Token_Index;
      Token_Pos57 :
            Token_Index
               := No_Token_Index;
      Token_Res57 :
            Token_Index
               := No_Token_Index;
      Transform_Res26 :
            Bare_Op_Or
               := No_Bare_R_F_L_X_Node;
      Transform_Diags26 :
            Ada.Containers.Count_Type;
      Or_Pos15 :
            Token_Index
               := No_Token_Index;
      Or_Res15 :
            Bare_Op
               := No_Bare_R_F_L_X_Node;
      Defer_Pos56 :
            Token_Index
               := No_Token_Index;
      Defer_Res56 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Progress2 :
            Integer
               := 0;
      Transform_Res27 :
            Bare_Bin_Op
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed2 :
            Boolean
               := False;
      Transform_Diags27 :
            Ada.Containers.Count_Type;
      Defer_Pos57 :
            Token_Index
               := No_Token_Index;
      Defer_Res57 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos16 :
            Token_Index
               := No_Token_Index;
      Or_Res16 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Extended_Expression_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res16 := M.Instance;
      return Or_Res16;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res16;
   end if;

       Set (Parser.Private_Part.Extended_Expression_Or_Parse1_Memo, False, Or_Res16, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt2 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos16 := No_Token_Index;
Or_Res16 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags27 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos29 := Pos;



Defer_Res55 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos29);
Defer_Pos55 := Parser.Current_Pos;



Row_Progress2 := 1;

if Defer_Pos55 /= No_Token_Index then

   Row_Pos29 := Defer_Pos55;

else
   Row_Pos29 := No_Token_Index;
   goto Exit_Row29_0;

end if;


--  Start or_code

Or_Pos15 := No_Token_Index;
Or_Res15 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags25 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos30 := Row_Pos29;



--  Start tok_code

Token_Res56 := Row_Pos30;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res56));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_And)
   then
       Token_Pos56 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos30 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos30,
             Expected_Token_Id => Rflx_And,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos56 := Row_Pos30 + 1;
   end if;
end;

--  End tok_code




if Token_Pos56 /= No_Token_Index then

   Row_Pos30 := Token_Pos56;

else
   Row_Pos30 := No_Token_Index;
   goto Exit_Row30_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row30_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos30 /= No_Token_Index then

   Transform_Res25 := Allocate_Op_And (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res25,
      Kind => Rflx_Op_And,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos29,
      Token_End_Index   => (if Row_Pos30 = Row_Pos29
                            then No_Token_Index
                            else Row_Pos30 - 1));




elsif Row_Pos30 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags25);
end if;

--  End transform_code

    if Row_Pos30 /= No_Token_Index then
        Or_Pos15 := Row_Pos30;
        Or_Res15 := Transform_Res25;
        goto Exit_Or16;
    end if;
    
--  Start transform_code

Transform_Diags26 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos31 := Row_Pos29;



--  Start tok_code

Token_Res57 := Row_Pos31;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res57));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Or)
   then
       Token_Pos57 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos31 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos31,
             Expected_Token_Id => Rflx_Or,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos57 := Row_Pos31 + 1;
   end if;
end;

--  End tok_code




if Token_Pos57 /= No_Token_Index then

   Row_Pos31 := Token_Pos57;

else
   Row_Pos31 := No_Token_Index;
   goto Exit_Row31_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row31_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos31 /= No_Token_Index then

   Transform_Res26 := Allocate_Op_Or (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res26,
      Kind => Rflx_Op_Or,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos29,
      Token_End_Index   => (if Row_Pos31 = Row_Pos29
                            then No_Token_Index
                            else Row_Pos31 - 1));




elsif Row_Pos31 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags26);
end if;

--  End transform_code

    if Row_Pos31 /= No_Token_Index then
        Or_Pos15 := Row_Pos31;
        Or_Res15 := Transform_Res26;
        goto Exit_Or16;
    end if;
<<Exit_Or16>>

--  End or_code



Row_Progress2 := 2;

if Or_Pos15 /= No_Token_Index then

   Row_Pos29 := Or_Pos15;

else
   Row_Pos29 := No_Token_Index;
   goto Exit_Row29_0;

end if;

Nobt2 := True;

   Nobt2 := Nobt2;

Row_Progress2 := 3;

if Row_Pos29 /= No_Token_Index then

   Row_Pos29 := Row_Pos29;

else
   Row_Pos29 := No_Token_Index;
   goto Exit_Row29_0;

end if;


Defer_Res56 :=
   Extended_Relation_Or_Parse1 (Parser, Row_Pos29);
Defer_Pos56 := Parser.Current_Pos;



Row_Progress2 := 4;

if Defer_Pos56 /= No_Token_Index then

   Row_Pos29 := Defer_Pos56;

else
   Row_Pos29 := No_Token_Index;
   goto Exit_Row29_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row29_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos29 = No_Token_Index and then Nobt2 then

   Row_Pos29 := Parser.Last_Fail.Pos;

   Transform_Has_Failed2 := True;
end if;

if Row_Pos29 /= No_Token_Index then

   Transform_Res27 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res27,
      Kind => Rflx_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos29 = Pos
                            then No_Token_Index
                            else Row_Pos29 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res27, Bin_Op_F_Left => Defer_Res55, Bin_Op_F_Op => Or_Res15, Bin_Op_F_Right => Defer_Res56);

         if Defer_Res55 /= null and then Is_Incomplete (Defer_Res55) then
            Transform_Res27.Last_Attempted_Child := 0;
         elsif Defer_Res55 /= null and then not Is_Ghost (Defer_Res55) then
            Transform_Res27.Last_Attempted_Child := -1;
         end if;
         if Or_Res15 /= null and then Is_Incomplete (Or_Res15) then
            Transform_Res27.Last_Attempted_Child := 0;
         elsif Or_Res15 /= null and then not Is_Ghost (Or_Res15) then
            Transform_Res27.Last_Attempted_Child := -1;
         end if;
         if Defer_Res56 /= null and then Is_Incomplete (Defer_Res56) then
            Transform_Res27.Last_Attempted_Child := 0;
         elsif Defer_Res56 /= null and then not Is_Ghost (Defer_Res56) then
            Transform_Res27.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed2 then
      Transform_Res27.Last_Attempted_Child :=
         Row_Progress2;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_expression>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos29 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags27);
end if;

--  End transform_code

    if Row_Pos29 /= No_Token_Index then
        Or_Pos16 := Row_Pos29;
        Or_Res16 := Transform_Res27;
        goto Exit_Or15;
    end if;
    
Defer_Res57 :=
   Extended_Relation_Or_Parse1 (Parser, Pos);
Defer_Pos57 := Parser.Current_Pos;

    if Defer_Pos57 /= No_Token_Index then
        Or_Pos16 := Defer_Pos57;
        Or_Res16 := Defer_Res57;
        goto Exit_Or15;
    end if;
<<Exit_Or15>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos16 > Mem_Pos then
         Mem_Pos := Or_Pos16;
         Mem_Res := Or_Res16;
         Set
           (Parser.Private_Part.Extended_Expression_Or_Parse1_Memo,
            Or_Pos16 /= No_Token_Index,
            Or_Res16,
            Pos,
            Or_Pos16);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res16 := Mem_Res;
         Or_Pos16 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Extended_Expression_Or_Parse1_Memo,
      Or_Pos16 /= No_Token_Index,
      Or_Res16,
      Pos,
      Or_Pos16);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos16;

   return Or_Res16;
end Extended_Expression_Or_Parse1;

   


function Extended_Factor_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt3 :
            Boolean
               := False;
      Row_Pos32 :
            Token_Index
               := No_Token_Index;
      Defer_Pos58 :
            Token_Index
               := No_Token_Index;
      Defer_Res58 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Pos33 :
            Token_Index
               := No_Token_Index;
      Token_Pos58 :
            Token_Index
               := No_Token_Index;
      Token_Res58 :
            Token_Index
               := No_Token_Index;
      Transform_Res28 :
            Bare_Op_Pow
               := No_Bare_R_F_L_X_Node;
      Transform_Diags28 :
            Ada.Containers.Count_Type;
      Or_Pos17 :
            Token_Index
               := No_Token_Index;
      Or_Res17 :
            Bare_Op_Pow
               := No_Bare_R_F_L_X_Node;
      Defer_Pos59 :
            Token_Index
               := No_Token_Index;
      Defer_Res59 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Progress3 :
            Integer
               := 0;
      Transform_Res29 :
            Bare_Bin_Op
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed3 :
            Boolean
               := False;
      Transform_Diags29 :
            Ada.Containers.Count_Type;
      Defer_Pos60 :
            Token_Index
               := No_Token_Index;
      Defer_Res60 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos18 :
            Token_Index
               := No_Token_Index;
      Or_Res18 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Extended_Factor_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res18 := M.Instance;
      return Or_Res18;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res18;
   end if;

       Set (Parser.Private_Part.Extended_Factor_Or_Parse1_Memo, False, Or_Res18, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt3 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos18 := No_Token_Index;
Or_Res18 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags29 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos32 := Pos;



Defer_Res58 :=
   Extended_Factor_Or_Parse1 (Parser, Row_Pos32);
Defer_Pos58 := Parser.Current_Pos;



Row_Progress3 := 1;

if Defer_Pos58 /= No_Token_Index then

   Row_Pos32 := Defer_Pos58;

else
   Row_Pos32 := No_Token_Index;
   goto Exit_Row32_0;

end if;


--  Start or_code

Or_Pos17 := No_Token_Index;
Or_Res17 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags28 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos33 := Row_Pos32;



--  Start tok_code

Token_Res58 := Row_Pos33;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res58));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Exp)
   then
       Token_Pos58 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos33 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos33,
             Expected_Token_Id => Rflx_Exp,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos58 := Row_Pos33 + 1;
   end if;
end;

--  End tok_code




if Token_Pos58 /= No_Token_Index then

   Row_Pos33 := Token_Pos58;

else
   Row_Pos33 := No_Token_Index;
   goto Exit_Row33_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row33_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos33 /= No_Token_Index then

   Transform_Res28 := Allocate_Op_Pow (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res28,
      Kind => Rflx_Op_Pow,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos32,
      Token_End_Index   => (if Row_Pos33 = Row_Pos32
                            then No_Token_Index
                            else Row_Pos33 - 1));




elsif Row_Pos33 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags28);
end if;

--  End transform_code

    if Row_Pos33 /= No_Token_Index then
        Or_Pos17 := Row_Pos33;
        Or_Res17 := Transform_Res28;
        goto Exit_Or18;
    end if;
<<Exit_Or18>>

--  End or_code



Row_Progress3 := 2;

if Or_Pos17 /= No_Token_Index then

   Row_Pos32 := Or_Pos17;

else
   Row_Pos32 := No_Token_Index;
   goto Exit_Row32_0;

end if;

Nobt3 := True;

   Nobt3 := Nobt3;

Row_Progress3 := 3;

if Row_Pos32 /= No_Token_Index then

   Row_Pos32 := Row_Pos32;

else
   Row_Pos32 := No_Token_Index;
   goto Exit_Row32_0;

end if;


Defer_Res59 :=
   Extended_Suffix_Or_Parse1 (Parser, Row_Pos32);
Defer_Pos59 := Parser.Current_Pos;



Row_Progress3 := 4;

if Defer_Pos59 /= No_Token_Index then

   Row_Pos32 := Defer_Pos59;

else
   Row_Pos32 := No_Token_Index;
   goto Exit_Row32_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row32_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos32 = No_Token_Index and then Nobt3 then

   Row_Pos32 := Parser.Last_Fail.Pos;

   Transform_Has_Failed3 := True;
end if;

if Row_Pos32 /= No_Token_Index then

   Transform_Res29 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res29,
      Kind => Rflx_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos32 = Pos
                            then No_Token_Index
                            else Row_Pos32 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res29, Bin_Op_F_Left => Defer_Res58, Bin_Op_F_Op => Or_Res17, Bin_Op_F_Right => Defer_Res59);

         if Defer_Res58 /= null and then Is_Incomplete (Defer_Res58) then
            Transform_Res29.Last_Attempted_Child := 0;
         elsif Defer_Res58 /= null and then not Is_Ghost (Defer_Res58) then
            Transform_Res29.Last_Attempted_Child := -1;
         end if;
         if Or_Res17 /= null and then Is_Incomplete (Or_Res17) then
            Transform_Res29.Last_Attempted_Child := 0;
         elsif Or_Res17 /= null and then not Is_Ghost (Or_Res17) then
            Transform_Res29.Last_Attempted_Child := -1;
         end if;
         if Defer_Res59 /= null and then Is_Incomplete (Defer_Res59) then
            Transform_Res29.Last_Attempted_Child := 0;
         elsif Defer_Res59 /= null and then not Is_Ghost (Defer_Res59) then
            Transform_Res29.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed3 then
      Transform_Res29.Last_Attempted_Child :=
         Row_Progress3;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_factor>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos32 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags29);
end if;

--  End transform_code

    if Row_Pos32 /= No_Token_Index then
        Or_Pos18 := Row_Pos32;
        Or_Res18 := Transform_Res29;
        goto Exit_Or17;
    end if;
    
Defer_Res60 :=
   Extended_Suffix_Or_Parse1 (Parser, Pos);
Defer_Pos60 := Parser.Current_Pos;

    if Defer_Pos60 /= No_Token_Index then
        Or_Pos18 := Defer_Pos60;
        Or_Res18 := Defer_Res60;
        goto Exit_Or17;
    end if;
<<Exit_Or17>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos18 > Mem_Pos then
         Mem_Pos := Or_Pos18;
         Mem_Res := Or_Res18;
         Set
           (Parser.Private_Part.Extended_Factor_Or_Parse1_Memo,
            Or_Pos18 /= No_Token_Index,
            Or_Res18,
            Pos,
            Or_Pos18);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res18 := Mem_Res;
         Or_Pos18 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Extended_Factor_Or_Parse1_Memo,
      Or_Pos18 /= No_Token_Index,
      Or_Res18,
      Pos,
      Or_Pos18);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos18;

   return Or_Res18;
end Extended_Factor_Or_Parse1;

   


function Extended_If_Condition_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Row_Pos34 :
            Token_Index
               := No_Token_Index;
      Token_Pos59 :
            Token_Index
               := No_Token_Index;
      Token_Res59 :
            Token_Index
               := No_Token_Index;
      Defer_Pos61 :
            Token_Index
               := No_Token_Index;
      Defer_Res61 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_If_Condition_Extract_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Defer_Res61 := M.Instance;
      return Defer_Res61;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Defer_Res61;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start row_code

Row_Pos34 := Pos;



--  Start tok_code

Token_Res59 := Row_Pos34;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res59));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_If)
   then
       Token_Pos59 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos34 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos34,
             Expected_Token_Id => Rflx_If,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos59 := Row_Pos34 + 1;
   end if;
end;

--  End tok_code




if Token_Pos59 /= No_Token_Index then

   Row_Pos34 := Token_Pos59;

else
   Row_Pos34 := No_Token_Index;
   goto Exit_Row34_0;

end if;


Defer_Res61 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos34);
Defer_Pos61 := Parser.Current_Pos;




if Defer_Pos61 /= No_Token_Index then

   Row_Pos34 := Defer_Pos61;

else
   Row_Pos34 := No_Token_Index;
   goto Exit_Row34_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row34_0>>
pragma Warnings (On, "referenced");

--  End row_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_If_Condition_Extract_Parse0_Memo,
      Row_Pos34 /= No_Token_Index,
      Defer_Res61,
      Pos,
      Row_Pos34);


   Parser.Current_Pos := Row_Pos34;

   return Defer_Res61;
end Extended_If_Condition_Extract_Parse0;

   


function Extended_Paren_Expression_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Paren_Expression
is
   use Bare_Paren_Expression_Memos;

      Row_Pos35 :
            Token_Index
               := No_Token_Index;
      Token_Pos60 :
            Token_Index
               := No_Token_Index;
      Token_Res60 :
            Token_Index
               := No_Token_Index;
      Defer_Pos62 :
            Token_Index
               := No_Token_Index;
      Defer_Res62 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos61 :
            Token_Index
               := No_Token_Index;
      Token_Res61 :
            Token_Index
               := No_Token_Index;
      Transform_Res30 :
            Bare_Paren_Expression
               := No_Bare_R_F_L_X_Node;
      Transform_Diags30 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_Paren_Expression_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res30 := M.Instance;
      return Transform_Res30;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res30;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags30 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos35 := Pos;



--  Start tok_code

Token_Res60 := Row_Pos35;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res60));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos60 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos35 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos35,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos60 := Row_Pos35 + 1;
   end if;
end;

--  End tok_code




if Token_Pos60 /= No_Token_Index then

   Row_Pos35 := Token_Pos60;

else
   Row_Pos35 := No_Token_Index;
   goto Exit_Row35_0;

end if;


Defer_Res62 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos35);
Defer_Pos62 := Parser.Current_Pos;




if Defer_Pos62 /= No_Token_Index then

   Row_Pos35 := Defer_Pos62;

else
   Row_Pos35 := No_Token_Index;
   goto Exit_Row35_0;

end if;


--  Start tok_code

Token_Res61 := Row_Pos35;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res61));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos61 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos35 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos35,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos61 := Row_Pos35 + 1;
   end if;
end;

--  End tok_code




if Token_Pos61 /= No_Token_Index then

   Row_Pos35 := Token_Pos61;

else
   Row_Pos35 := No_Token_Index;
   goto Exit_Row35_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row35_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos35 /= No_Token_Index then

   Transform_Res30 := Allocate_Paren_Expression (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res30,
      Kind => Rflx_Paren_Expression,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos35 = Pos
                            then No_Token_Index
                            else Row_Pos35 - 1));

      Initialize_Fields_For_Paren_Expression
        (Self => Transform_Res30, Paren_Expression_F_Data => Defer_Res62);

         if Defer_Res62 /= null and then Is_Incomplete (Defer_Res62) then
            Transform_Res30.Last_Attempted_Child := 0;
         elsif Defer_Res62 /= null and then not Is_Ghost (Defer_Res62) then
            Transform_Res30.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos35 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags30);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_Paren_Expression_Transform_Parse0_Memo,
      Row_Pos35 /= No_Token_Index,
      Transform_Res30,
      Pos,
      Row_Pos35);


   Parser.Current_Pos := Row_Pos35;

   return Transform_Res30;
end Extended_Paren_Expression_Transform_Parse0;

   


function Extended_Primary_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Defer_Pos63 :
            Token_Index
               := No_Token_Index;
      Defer_Res63 :
            Bare_Sequence_Literal
               := No_Bare_R_F_L_X_Node;
      Defer_Pos64 :
            Token_Index
               := No_Token_Index;
      Defer_Res64 :
            Bare_Numeric_Literal
               := No_Bare_R_F_L_X_Node;
      Defer_Pos65 :
            Token_Index
               := No_Token_Index;
      Defer_Res65 :
            Bare_String_Literal
               := No_Bare_R_F_L_X_Node;
      Defer_Pos66 :
            Token_Index
               := No_Token_Index;
      Defer_Res66 :
            Bare_Quantified_Expression
               := No_Bare_R_F_L_X_Node;
      Defer_Pos67 :
            Token_Index
               := No_Token_Index;
      Defer_Res67 :
            Bare_Comprehension
               := No_Bare_R_F_L_X_Node;
      Defer_Pos68 :
            Token_Index
               := No_Token_Index;
      Defer_Res68 :
            Bare_Call
               := No_Bare_R_F_L_X_Node;
      Defer_Pos69 :
            Token_Index
               := No_Token_Index;
      Defer_Res69 :
            Bare_Conversion
               := No_Bare_R_F_L_X_Node;
      Defer_Pos70 :
            Token_Index
               := No_Token_Index;
      Defer_Res70 :
            Bare_Message_Aggregate
               := No_Bare_R_F_L_X_Node;
      Defer_Pos71 :
            Token_Index
               := No_Token_Index;
      Defer_Res71 :
            Bare_Variable
               := No_Bare_R_F_L_X_Node;
      Defer_Pos72 :
            Token_Index
               := No_Token_Index;
      Defer_Res72 :
            Bare_Paren_Expression
               := No_Bare_R_F_L_X_Node;
      Defer_Pos73 :
            Token_Index
               := No_Token_Index;
      Defer_Res73 :
            Bare_Case_Expression
               := No_Bare_R_F_L_X_Node;
      Or_Pos19 :
            Token_Index
               := No_Token_Index;
      Or_Res19 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_Primary_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res19 := M.Instance;
      return Or_Res19;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res19;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos19 := No_Token_Index;
Or_Res19 := No_Bare_R_F_L_X_Node;
    
Defer_Res63 :=
   Concatenation_Or_Parse2 (Parser, Pos);
Defer_Pos63 := Parser.Current_Pos;

    if Defer_Pos63 /= No_Token_Index then
        Or_Pos19 := Defer_Pos63;
        Or_Res19 := Defer_Res63;
        goto Exit_Or19;
    end if;
    
Defer_Res64 :=
   Numeric_Literal_Transform_Parse0 (Parser, Pos);
Defer_Pos64 := Parser.Current_Pos;

    if Defer_Pos64 /= No_Token_Index then
        Or_Pos19 := Defer_Pos64;
        Or_Res19 := Defer_Res64;
        goto Exit_Or19;
    end if;
    
Defer_Res65 :=
   String_Literal_Transform_Parse0 (Parser, Pos);
Defer_Pos65 := Parser.Current_Pos;

    if Defer_Pos65 /= No_Token_Index then
        Or_Pos19 := Defer_Pos65;
        Or_Res19 := Defer_Res65;
        goto Exit_Or19;
    end if;
    
Defer_Res66 :=
   Quantified_Expression_Transform_Parse2 (Parser, Pos);
Defer_Pos66 := Parser.Current_Pos;

    if Defer_Pos66 /= No_Token_Index then
        Or_Pos19 := Defer_Pos66;
        Or_Res19 := Defer_Res66;
        goto Exit_Or19;
    end if;
    
Defer_Res67 :=
   Comprehension_Transform_Parse0 (Parser, Pos);
Defer_Pos67 := Parser.Current_Pos;

    if Defer_Pos67 /= No_Token_Index then
        Or_Pos19 := Defer_Pos67;
        Or_Res19 := Defer_Res67;
        goto Exit_Or19;
    end if;
    
Defer_Res68 :=
   Call_Transform_Parse0 (Parser, Pos);
Defer_Pos68 := Parser.Current_Pos;

    if Defer_Pos68 /= No_Token_Index then
        Or_Pos19 := Defer_Pos68;
        Or_Res19 := Defer_Res68;
        goto Exit_Or19;
    end if;
    
Defer_Res69 :=
   Conversion_Transform_Parse0 (Parser, Pos);
Defer_Pos69 := Parser.Current_Pos;

    if Defer_Pos69 /= No_Token_Index then
        Or_Pos19 := Defer_Pos69;
        Or_Res19 := Defer_Res69;
        goto Exit_Or19;
    end if;
    
Defer_Res70 :=
   Message_Aggregate_Transform_Parse0 (Parser, Pos);
Defer_Pos70 := Parser.Current_Pos;

    if Defer_Pos70 /= No_Token_Index then
        Or_Pos19 := Defer_Pos70;
        Or_Res19 := Defer_Res70;
        goto Exit_Or19;
    end if;
    
Defer_Res71 :=
   Variable_Transform_Parse0 (Parser, Pos);
Defer_Pos71 := Parser.Current_Pos;

    if Defer_Pos71 /= No_Token_Index then
        Or_Pos19 := Defer_Pos71;
        Or_Res19 := Defer_Res71;
        goto Exit_Or19;
    end if;
    
Defer_Res72 :=
   Extended_Paren_Expression_Transform_Parse0 (Parser, Pos);
Defer_Pos72 := Parser.Current_Pos;

    if Defer_Pos72 /= No_Token_Index then
        Or_Pos19 := Defer_Pos72;
        Or_Res19 := Defer_Res72;
        goto Exit_Or19;
    end if;
    
Defer_Res73 :=
   Extended_Case_Expression_Transform_Parse0 (Parser, Pos);
Defer_Pos73 := Parser.Current_Pos;

    if Defer_Pos73 /= No_Token_Index then
        Or_Pos19 := Defer_Pos73;
        Or_Res19 := Defer_Res73;
        goto Exit_Or19;
    end if;
<<Exit_Or19>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_Primary_Or_Parse0_Memo,
      Or_Pos19 /= No_Token_Index,
      Or_Res19,
      Pos,
      Or_Pos19);


   Parser.Current_Pos := Or_Pos19;

   return Or_Res19;
end Extended_Primary_Or_Parse0;

   


function Extended_Relation_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt4 :
            Boolean
               := False;
      Row_Pos36 :
            Token_Index
               := No_Token_Index;
      Defer_Pos74 :
            Token_Index
               := No_Token_Index;
      Defer_Res74 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Pos37 :
            Token_Index
               := No_Token_Index;
      Token_Pos62 :
            Token_Index
               := No_Token_Index;
      Token_Res62 :
            Token_Index
               := No_Token_Index;
      Transform_Res31 :
            Bare_Op_Eq
               := No_Bare_R_F_L_X_Node;
      Transform_Diags31 :
            Ada.Containers.Count_Type;
      Row_Pos38 :
            Token_Index
               := No_Token_Index;
      Token_Pos63 :
            Token_Index
               := No_Token_Index;
      Token_Res63 :
            Token_Index
               := No_Token_Index;
      Transform_Res32 :
            Bare_Op_Neq
               := No_Bare_R_F_L_X_Node;
      Transform_Diags32 :
            Ada.Containers.Count_Type;
      Row_Pos39 :
            Token_Index
               := No_Token_Index;
      Token_Pos64 :
            Token_Index
               := No_Token_Index;
      Token_Res64 :
            Token_Index
               := No_Token_Index;
      Transform_Res33 :
            Bare_Op_Le
               := No_Bare_R_F_L_X_Node;
      Transform_Diags33 :
            Ada.Containers.Count_Type;
      Row_Pos40 :
            Token_Index
               := No_Token_Index;
      Token_Pos65 :
            Token_Index
               := No_Token_Index;
      Token_Res65 :
            Token_Index
               := No_Token_Index;
      Transform_Res34 :
            Bare_Op_Lt
               := No_Bare_R_F_L_X_Node;
      Transform_Diags34 :
            Ada.Containers.Count_Type;
      Row_Pos41 :
            Token_Index
               := No_Token_Index;
      Token_Pos66 :
            Token_Index
               := No_Token_Index;
      Token_Res66 :
            Token_Index
               := No_Token_Index;
      Transform_Res35 :
            Bare_Op_Ge
               := No_Bare_R_F_L_X_Node;
      Transform_Diags35 :
            Ada.Containers.Count_Type;
      Row_Pos42 :
            Token_Index
               := No_Token_Index;
      Token_Pos67 :
            Token_Index
               := No_Token_Index;
      Token_Res67 :
            Token_Index
               := No_Token_Index;
      Transform_Res36 :
            Bare_Op_Gt
               := No_Bare_R_F_L_X_Node;
      Transform_Diags36 :
            Ada.Containers.Count_Type;
      Row_Pos43 :
            Token_Index
               := No_Token_Index;
      Token_Pos68 :
            Token_Index
               := No_Token_Index;
      Token_Res68 :
            Token_Index
               := No_Token_Index;
      Transform_Res37 :
            Bare_Op_In
               := No_Bare_R_F_L_X_Node;
      Transform_Diags37 :
            Ada.Containers.Count_Type;
      Row_Pos44 :
            Token_Index
               := No_Token_Index;
      Token_Pos69 :
            Token_Index
               := No_Token_Index;
      Token_Res69 :
            Token_Index
               := No_Token_Index;
      Token_Pos70 :
            Token_Index
               := No_Token_Index;
      Token_Res70 :
            Token_Index
               := No_Token_Index;
      Transform_Res38 :
            Bare_Op_Notin
               := No_Bare_R_F_L_X_Node;
      Transform_Diags38 :
            Ada.Containers.Count_Type;
      Or_Pos20 :
            Token_Index
               := No_Token_Index;
      Or_Res20 :
            Bare_Op
               := No_Bare_R_F_L_X_Node;
      Defer_Pos75 :
            Token_Index
               := No_Token_Index;
      Defer_Res75 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Progress4 :
            Integer
               := 0;
      Transform_Res39 :
            Bare_Bin_Op
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed4 :
            Boolean
               := False;
      Transform_Diags39 :
            Ada.Containers.Count_Type;
      Defer_Pos76 :
            Token_Index
               := No_Token_Index;
      Defer_Res76 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos21 :
            Token_Index
               := No_Token_Index;
      Or_Res21 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Extended_Relation_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res21 := M.Instance;
      return Or_Res21;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res21;
   end if;

       Set (Parser.Private_Part.Extended_Relation_Or_Parse1_Memo, False, Or_Res21, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt4 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos21 := No_Token_Index;
Or_Res21 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags39 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos36 := Pos;



Defer_Res74 :=
   Extended_Relation_Or_Parse1 (Parser, Row_Pos36);
Defer_Pos74 := Parser.Current_Pos;



Row_Progress4 := 1;

if Defer_Pos74 /= No_Token_Index then

   Row_Pos36 := Defer_Pos74;

else
   Row_Pos36 := No_Token_Index;
   goto Exit_Row36_0;

end if;


--  Start or_code

Or_Pos20 := No_Token_Index;
Or_Res20 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags31 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos37 := Row_Pos36;



--  Start tok_code

Token_Res62 := Row_Pos37;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res62));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Eq)
   then
       Token_Pos62 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos37 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos37,
             Expected_Token_Id => Rflx_Eq,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos62 := Row_Pos37 + 1;
   end if;
end;

--  End tok_code




if Token_Pos62 /= No_Token_Index then

   Row_Pos37 := Token_Pos62;

else
   Row_Pos37 := No_Token_Index;
   goto Exit_Row37_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row37_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos37 /= No_Token_Index then

   Transform_Res31 := Allocate_Op_Eq (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res31,
      Kind => Rflx_Op_Eq,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos36,
      Token_End_Index   => (if Row_Pos37 = Row_Pos36
                            then No_Token_Index
                            else Row_Pos37 - 1));




elsif Row_Pos37 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags31);
end if;

--  End transform_code

    if Row_Pos37 /= No_Token_Index then
        Or_Pos20 := Row_Pos37;
        Or_Res20 := Transform_Res31;
        goto Exit_Or21;
    end if;
    
--  Start transform_code

Transform_Diags32 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos38 := Row_Pos36;



--  Start tok_code

Token_Res63 := Row_Pos38;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res63));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Neq)
   then
       Token_Pos63 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos38 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos38,
             Expected_Token_Id => Rflx_Neq,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos63 := Row_Pos38 + 1;
   end if;
end;

--  End tok_code




if Token_Pos63 /= No_Token_Index then

   Row_Pos38 := Token_Pos63;

else
   Row_Pos38 := No_Token_Index;
   goto Exit_Row38_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row38_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos38 /= No_Token_Index then

   Transform_Res32 := Allocate_Op_Neq (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res32,
      Kind => Rflx_Op_Neq,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos36,
      Token_End_Index   => (if Row_Pos38 = Row_Pos36
                            then No_Token_Index
                            else Row_Pos38 - 1));




elsif Row_Pos38 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags32);
end if;

--  End transform_code

    if Row_Pos38 /= No_Token_Index then
        Or_Pos20 := Row_Pos38;
        Or_Res20 := Transform_Res32;
        goto Exit_Or21;
    end if;
    
--  Start transform_code

Transform_Diags33 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos39 := Row_Pos36;



--  Start tok_code

Token_Res64 := Row_Pos39;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res64));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Le)
   then
       Token_Pos64 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos39 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos39,
             Expected_Token_Id => Rflx_Le,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos64 := Row_Pos39 + 1;
   end if;
end;

--  End tok_code




if Token_Pos64 /= No_Token_Index then

   Row_Pos39 := Token_Pos64;

else
   Row_Pos39 := No_Token_Index;
   goto Exit_Row39_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row39_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos39 /= No_Token_Index then

   Transform_Res33 := Allocate_Op_Le (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res33,
      Kind => Rflx_Op_Le,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos36,
      Token_End_Index   => (if Row_Pos39 = Row_Pos36
                            then No_Token_Index
                            else Row_Pos39 - 1));




elsif Row_Pos39 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags33);
end if;

--  End transform_code

    if Row_Pos39 /= No_Token_Index then
        Or_Pos20 := Row_Pos39;
        Or_Res20 := Transform_Res33;
        goto Exit_Or21;
    end if;
    
--  Start transform_code

Transform_Diags34 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos40 := Row_Pos36;



--  Start tok_code

Token_Res65 := Row_Pos40;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res65));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Lt)
   then
       Token_Pos65 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos40 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos40,
             Expected_Token_Id => Rflx_Lt,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos65 := Row_Pos40 + 1;
   end if;
end;

--  End tok_code




if Token_Pos65 /= No_Token_Index then

   Row_Pos40 := Token_Pos65;

else
   Row_Pos40 := No_Token_Index;
   goto Exit_Row40_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row40_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos40 /= No_Token_Index then

   Transform_Res34 := Allocate_Op_Lt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res34,
      Kind => Rflx_Op_Lt,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos36,
      Token_End_Index   => (if Row_Pos40 = Row_Pos36
                            then No_Token_Index
                            else Row_Pos40 - 1));




elsif Row_Pos40 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags34);
end if;

--  End transform_code

    if Row_Pos40 /= No_Token_Index then
        Or_Pos20 := Row_Pos40;
        Or_Res20 := Transform_Res34;
        goto Exit_Or21;
    end if;
    
--  Start transform_code

Transform_Diags35 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos41 := Row_Pos36;



--  Start tok_code

Token_Res66 := Row_Pos41;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res66));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Ge)
   then
       Token_Pos66 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos41 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos41,
             Expected_Token_Id => Rflx_Ge,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos66 := Row_Pos41 + 1;
   end if;
end;

--  End tok_code




if Token_Pos66 /= No_Token_Index then

   Row_Pos41 := Token_Pos66;

else
   Row_Pos41 := No_Token_Index;
   goto Exit_Row41_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row41_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos41 /= No_Token_Index then

   Transform_Res35 := Allocate_Op_Ge (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res35,
      Kind => Rflx_Op_Ge,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos36,
      Token_End_Index   => (if Row_Pos41 = Row_Pos36
                            then No_Token_Index
                            else Row_Pos41 - 1));




elsif Row_Pos41 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags35);
end if;

--  End transform_code

    if Row_Pos41 /= No_Token_Index then
        Or_Pos20 := Row_Pos41;
        Or_Res20 := Transform_Res35;
        goto Exit_Or21;
    end if;
    
--  Start transform_code

Transform_Diags36 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos42 := Row_Pos36;



--  Start tok_code

Token_Res67 := Row_Pos42;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res67));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Gt)
   then
       Token_Pos67 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos42 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos42,
             Expected_Token_Id => Rflx_Gt,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos67 := Row_Pos42 + 1;
   end if;
end;

--  End tok_code




if Token_Pos67 /= No_Token_Index then

   Row_Pos42 := Token_Pos67;

else
   Row_Pos42 := No_Token_Index;
   goto Exit_Row42_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row42_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos42 /= No_Token_Index then

   Transform_Res36 := Allocate_Op_Gt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res36,
      Kind => Rflx_Op_Gt,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos36,
      Token_End_Index   => (if Row_Pos42 = Row_Pos36
                            then No_Token_Index
                            else Row_Pos42 - 1));




elsif Row_Pos42 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags36);
end if;

--  End transform_code

    if Row_Pos42 /= No_Token_Index then
        Or_Pos20 := Row_Pos42;
        Or_Res20 := Transform_Res36;
        goto Exit_Or21;
    end if;
    
--  Start transform_code

Transform_Diags37 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos43 := Row_Pos36;



--  Start tok_code

Token_Res68 := Row_Pos43;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res68));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_In)
   then
       Token_Pos68 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos43 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos43,
             Expected_Token_Id => Rflx_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos68 := Row_Pos43 + 1;
   end if;
end;

--  End tok_code




if Token_Pos68 /= No_Token_Index then

   Row_Pos43 := Token_Pos68;

else
   Row_Pos43 := No_Token_Index;
   goto Exit_Row43_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row43_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos43 /= No_Token_Index then

   Transform_Res37 := Allocate_Op_In (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res37,
      Kind => Rflx_Op_In,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos36,
      Token_End_Index   => (if Row_Pos43 = Row_Pos36
                            then No_Token_Index
                            else Row_Pos43 - 1));




elsif Row_Pos43 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags37);
end if;

--  End transform_code

    if Row_Pos43 /= No_Token_Index then
        Or_Pos20 := Row_Pos43;
        Or_Res20 := Transform_Res37;
        goto Exit_Or21;
    end if;
    
--  Start transform_code

Transform_Diags38 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos44 := Row_Pos36;



--  Start tok_code

Token_Res69 := Row_Pos44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res69));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Not)
   then
       Token_Pos69 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos44,
             Expected_Token_Id => Rflx_Not,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos69 := Row_Pos44 + 1;
   end if;
end;

--  End tok_code




if Token_Pos69 /= No_Token_Index then

   Row_Pos44 := Token_Pos69;

else
   Row_Pos44 := No_Token_Index;
   goto Exit_Row44_0;

end if;


--  Start tok_code

Token_Res70 := Row_Pos44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res70));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_In)
   then
       Token_Pos70 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos44,
             Expected_Token_Id => Rflx_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos70 := Row_Pos44 + 1;
   end if;
end;

--  End tok_code




if Token_Pos70 /= No_Token_Index then

   Row_Pos44 := Token_Pos70;

else
   Row_Pos44 := No_Token_Index;
   goto Exit_Row44_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row44_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos44 /= No_Token_Index then

   Transform_Res38 := Allocate_Op_Notin (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res38,
      Kind => Rflx_Op_Notin,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos36,
      Token_End_Index   => (if Row_Pos44 = Row_Pos36
                            then No_Token_Index
                            else Row_Pos44 - 1));




elsif Row_Pos44 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags38);
end if;

--  End transform_code

    if Row_Pos44 /= No_Token_Index then
        Or_Pos20 := Row_Pos44;
        Or_Res20 := Transform_Res38;
        goto Exit_Or21;
    end if;
<<Exit_Or21>>

--  End or_code



Row_Progress4 := 2;

if Or_Pos20 /= No_Token_Index then

   Row_Pos36 := Or_Pos20;

else
   Row_Pos36 := No_Token_Index;
   goto Exit_Row36_0;

end if;

Nobt4 := True;

   Nobt4 := Nobt4;

Row_Progress4 := 3;

if Row_Pos36 /= No_Token_Index then

   Row_Pos36 := Row_Pos36;

else
   Row_Pos36 := No_Token_Index;
   goto Exit_Row36_0;

end if;


Defer_Res75 :=
   Extended_Simple_Expr_Or_Parse1 (Parser, Row_Pos36);
Defer_Pos75 := Parser.Current_Pos;



Row_Progress4 := 4;

if Defer_Pos75 /= No_Token_Index then

   Row_Pos36 := Defer_Pos75;

else
   Row_Pos36 := No_Token_Index;
   goto Exit_Row36_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row36_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos36 = No_Token_Index and then Nobt4 then

   Row_Pos36 := Parser.Last_Fail.Pos;

   Transform_Has_Failed4 := True;
end if;

if Row_Pos36 /= No_Token_Index then

   Transform_Res39 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res39,
      Kind => Rflx_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos36 = Pos
                            then No_Token_Index
                            else Row_Pos36 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res39, Bin_Op_F_Left => Defer_Res74, Bin_Op_F_Op => Or_Res20, Bin_Op_F_Right => Defer_Res75);

         if Defer_Res74 /= null and then Is_Incomplete (Defer_Res74) then
            Transform_Res39.Last_Attempted_Child := 0;
         elsif Defer_Res74 /= null and then not Is_Ghost (Defer_Res74) then
            Transform_Res39.Last_Attempted_Child := -1;
         end if;
         if Or_Res20 /= null and then Is_Incomplete (Or_Res20) then
            Transform_Res39.Last_Attempted_Child := 0;
         elsif Or_Res20 /= null and then not Is_Ghost (Or_Res20) then
            Transform_Res39.Last_Attempted_Child := -1;
         end if;
         if Defer_Res75 /= null and then Is_Incomplete (Defer_Res75) then
            Transform_Res39.Last_Attempted_Child := 0;
         elsif Defer_Res75 /= null and then not Is_Ghost (Defer_Res75) then
            Transform_Res39.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed4 then
      Transform_Res39.Last_Attempted_Child :=
         Row_Progress4;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_relation>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos36 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags39);
end if;

--  End transform_code

    if Row_Pos36 /= No_Token_Index then
        Or_Pos21 := Row_Pos36;
        Or_Res21 := Transform_Res39;
        goto Exit_Or20;
    end if;
    
Defer_Res76 :=
   Extended_Simple_Expr_Or_Parse1 (Parser, Pos);
Defer_Pos76 := Parser.Current_Pos;

    if Defer_Pos76 /= No_Token_Index then
        Or_Pos21 := Defer_Pos76;
        Or_Res21 := Defer_Res76;
        goto Exit_Or20;
    end if;
<<Exit_Or20>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos21 > Mem_Pos then
         Mem_Pos := Or_Pos21;
         Mem_Res := Or_Res21;
         Set
           (Parser.Private_Part.Extended_Relation_Or_Parse1_Memo,
            Or_Pos21 /= No_Token_Index,
            Or_Res21,
            Pos,
            Or_Pos21);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res21 := Mem_Res;
         Or_Pos21 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Extended_Relation_Or_Parse1_Memo,
      Or_Pos21 /= No_Token_Index,
      Or_Res21,
      Pos,
      Or_Pos21);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos21;

   return Or_Res21;
end Extended_Relation_Or_Parse1;

   


function Extended_Simple_Expr_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt5 :
            Boolean
               := False;
      Row_Pos45 :
            Token_Index
               := No_Token_Index;
      Defer_Pos77 :
            Token_Index
               := No_Token_Index;
      Defer_Res77 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Pos46 :
            Token_Index
               := No_Token_Index;
      Token_Pos71 :
            Token_Index
               := No_Token_Index;
      Token_Res71 :
            Token_Index
               := No_Token_Index;
      Transform_Res40 :
            Bare_Op_Add
               := No_Bare_R_F_L_X_Node;
      Transform_Diags40 :
            Ada.Containers.Count_Type;
      Row_Pos47 :
            Token_Index
               := No_Token_Index;
      Token_Pos72 :
            Token_Index
               := No_Token_Index;
      Token_Res72 :
            Token_Index
               := No_Token_Index;
      Transform_Res41 :
            Bare_Op_Sub
               := No_Bare_R_F_L_X_Node;
      Transform_Diags41 :
            Ada.Containers.Count_Type;
      Or_Pos22 :
            Token_Index
               := No_Token_Index;
      Or_Res22 :
            Bare_Op
               := No_Bare_R_F_L_X_Node;
      Defer_Pos78 :
            Token_Index
               := No_Token_Index;
      Defer_Res78 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Progress5 :
            Integer
               := 0;
      Transform_Res42 :
            Bare_Bin_Op
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed5 :
            Boolean
               := False;
      Transform_Diags42 :
            Ada.Containers.Count_Type;
      Defer_Pos79 :
            Token_Index
               := No_Token_Index;
      Defer_Res79 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos23 :
            Token_Index
               := No_Token_Index;
      Or_Res23 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Extended_Simple_Expr_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res23 := M.Instance;
      return Or_Res23;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res23;
   end if;

       Set (Parser.Private_Part.Extended_Simple_Expr_Or_Parse1_Memo, False, Or_Res23, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt5 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos23 := No_Token_Index;
Or_Res23 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags42 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos45 := Pos;



Defer_Res77 :=
   Extended_Simple_Expr_Or_Parse1 (Parser, Row_Pos45);
Defer_Pos77 := Parser.Current_Pos;



Row_Progress5 := 1;

if Defer_Pos77 /= No_Token_Index then

   Row_Pos45 := Defer_Pos77;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;


--  Start or_code

Or_Pos22 := No_Token_Index;
Or_Res22 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags40 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos46 := Row_Pos45;



--  Start tok_code

Token_Res71 := Row_Pos46;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res71));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Add)
   then
       Token_Pos71 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos46 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos46,
             Expected_Token_Id => Rflx_Add,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos71 := Row_Pos46 + 1;
   end if;
end;

--  End tok_code




if Token_Pos71 /= No_Token_Index then

   Row_Pos46 := Token_Pos71;

else
   Row_Pos46 := No_Token_Index;
   goto Exit_Row46_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row46_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos46 /= No_Token_Index then

   Transform_Res40 := Allocate_Op_Add (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res40,
      Kind => Rflx_Op_Add,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos45,
      Token_End_Index   => (if Row_Pos46 = Row_Pos45
                            then No_Token_Index
                            else Row_Pos46 - 1));




elsif Row_Pos46 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags40);
end if;

--  End transform_code

    if Row_Pos46 /= No_Token_Index then
        Or_Pos22 := Row_Pos46;
        Or_Res22 := Transform_Res40;
        goto Exit_Or23;
    end if;
    
--  Start transform_code

Transform_Diags41 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos47 := Row_Pos45;



--  Start tok_code

Token_Res72 := Row_Pos47;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res72));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Sub)
   then
       Token_Pos72 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos47 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos47,
             Expected_Token_Id => Rflx_Sub,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos72 := Row_Pos47 + 1;
   end if;
end;

--  End tok_code




if Token_Pos72 /= No_Token_Index then

   Row_Pos47 := Token_Pos72;

else
   Row_Pos47 := No_Token_Index;
   goto Exit_Row47_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row47_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos47 /= No_Token_Index then

   Transform_Res41 := Allocate_Op_Sub (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res41,
      Kind => Rflx_Op_Sub,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos45,
      Token_End_Index   => (if Row_Pos47 = Row_Pos45
                            then No_Token_Index
                            else Row_Pos47 - 1));




elsif Row_Pos47 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags41);
end if;

--  End transform_code

    if Row_Pos47 /= No_Token_Index then
        Or_Pos22 := Row_Pos47;
        Or_Res22 := Transform_Res41;
        goto Exit_Or23;
    end if;
<<Exit_Or23>>

--  End or_code



Row_Progress5 := 2;

if Or_Pos22 /= No_Token_Index then

   Row_Pos45 := Or_Pos22;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;

Nobt5 := True;

   Nobt5 := Nobt5;

Row_Progress5 := 3;

if Row_Pos45 /= No_Token_Index then

   Row_Pos45 := Row_Pos45;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;


Defer_Res78 :=
   Extended_Unop_Term_Or_Parse0 (Parser, Row_Pos45);
Defer_Pos78 := Parser.Current_Pos;



Row_Progress5 := 4;

if Defer_Pos78 /= No_Token_Index then

   Row_Pos45 := Defer_Pos78;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row45_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos45 = No_Token_Index and then Nobt5 then

   Row_Pos45 := Parser.Last_Fail.Pos;

   Transform_Has_Failed5 := True;
end if;

if Row_Pos45 /= No_Token_Index then

   Transform_Res42 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res42,
      Kind => Rflx_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos45 = Pos
                            then No_Token_Index
                            else Row_Pos45 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res42, Bin_Op_F_Left => Defer_Res77, Bin_Op_F_Op => Or_Res22, Bin_Op_F_Right => Defer_Res78);

         if Defer_Res77 /= null and then Is_Incomplete (Defer_Res77) then
            Transform_Res42.Last_Attempted_Child := 0;
         elsif Defer_Res77 /= null and then not Is_Ghost (Defer_Res77) then
            Transform_Res42.Last_Attempted_Child := -1;
         end if;
         if Or_Res22 /= null and then Is_Incomplete (Or_Res22) then
            Transform_Res42.Last_Attempted_Child := 0;
         elsif Or_Res22 /= null and then not Is_Ghost (Or_Res22) then
            Transform_Res42.Last_Attempted_Child := -1;
         end if;
         if Defer_Res78 /= null and then Is_Incomplete (Defer_Res78) then
            Transform_Res42.Last_Attempted_Child := 0;
         elsif Defer_Res78 /= null and then not Is_Ghost (Defer_Res78) then
            Transform_Res42.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed5 then
      Transform_Res42.Last_Attempted_Child :=
         Row_Progress5;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_simple_expr>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos45 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags42);
end if;

--  End transform_code

    if Row_Pos45 /= No_Token_Index then
        Or_Pos23 := Row_Pos45;
        Or_Res23 := Transform_Res42;
        goto Exit_Or22;
    end if;
    
Defer_Res79 :=
   Extended_Unop_Term_Or_Parse0 (Parser, Pos);
Defer_Pos79 := Parser.Current_Pos;

    if Defer_Pos79 /= No_Token_Index then
        Or_Pos23 := Defer_Pos79;
        Or_Res23 := Defer_Res79;
        goto Exit_Or22;
    end if;
<<Exit_Or22>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos23 > Mem_Pos then
         Mem_Pos := Or_Pos23;
         Mem_Res := Or_Res23;
         Set
           (Parser.Private_Part.Extended_Simple_Expr_Or_Parse1_Memo,
            Or_Pos23 /= No_Token_Index,
            Or_Res23,
            Pos,
            Or_Pos23);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res23 := Mem_Res;
         Or_Pos23 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Extended_Simple_Expr_Or_Parse1_Memo,
      Or_Pos23 /= No_Token_Index,
      Or_Res23,
      Pos,
      Or_Pos23);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos23;

   return Or_Res23;
end Extended_Simple_Expr_Or_Parse1;

   


function Extended_Suffix_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt6 :
            Boolean
               := False;
      Row_Pos48 :
            Token_Index
               := No_Token_Index;
      Defer_Pos80 :
            Token_Index
               := No_Token_Index;
      Defer_Res80 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos73 :
            Token_Index
               := No_Token_Index;
      Token_Res73 :
            Token_Index
               := No_Token_Index;
      Defer_Pos81 :
            Token_Index
               := No_Token_Index;
      Defer_Res81 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Row_Progress6 :
            Integer
               := 0;
      Transform_Res43 :
            Bare_Select_Node
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed6 :
            Boolean
               := False;
      Transform_Diags43 :
            Ada.Containers.Count_Type;
      Row_Pos49 :
            Token_Index
               := No_Token_Index;
      Defer_Pos82 :
            Token_Index
               := No_Token_Index;
      Defer_Res82 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos74 :
            Token_Index
               := No_Token_Index;
      Token_Res74 :
            Token_Index
               := No_Token_Index;
      Row_Pos50 :
            Token_Index
               := No_Token_Index;
      Token_Pos75 :
            Token_Index
               := No_Token_Index;
      Token_Res75 :
            Token_Index
               := No_Token_Index;
      Transform_Res44 :
            Bare_Attr_First
               := No_Bare_R_F_L_X_Node;
      Transform_Diags44 :
            Ada.Containers.Count_Type;
      Row_Pos51 :
            Token_Index
               := No_Token_Index;
      Token_Pos76 :
            Token_Index
               := No_Token_Index;
      Token_Res76 :
            Token_Index
               := No_Token_Index;
      Transform_Res45 :
            Bare_Attr_Size
               := No_Bare_R_F_L_X_Node;
      Transform_Diags45 :
            Ada.Containers.Count_Type;
      Row_Pos52 :
            Token_Index
               := No_Token_Index;
      Token_Pos77 :
            Token_Index
               := No_Token_Index;
      Token_Res77 :
            Token_Index
               := No_Token_Index;
      Transform_Res46 :
            Bare_Attr_Last
               := No_Bare_R_F_L_X_Node;
      Transform_Diags46 :
            Ada.Containers.Count_Type;
      Row_Pos53 :
            Token_Index
               := No_Token_Index;
      Token_Pos78 :
            Token_Index
               := No_Token_Index;
      Token_Res78 :
            Token_Index
               := No_Token_Index;
      Transform_Res47 :
            Bare_Attr_Valid_Checksum
               := No_Bare_R_F_L_X_Node;
      Transform_Diags47 :
            Ada.Containers.Count_Type;
      Row_Pos54 :
            Token_Index
               := No_Token_Index;
      Token_Pos79 :
            Token_Index
               := No_Token_Index;
      Token_Res79 :
            Token_Index
               := No_Token_Index;
      Transform_Res48 :
            Bare_Attr_Has_Data
               := No_Bare_R_F_L_X_Node;
      Transform_Diags48 :
            Ada.Containers.Count_Type;
      Row_Pos55 :
            Token_Index
               := No_Token_Index;
      Token_Pos80 :
            Token_Index
               := No_Token_Index;
      Token_Res80 :
            Token_Index
               := No_Token_Index;
      Transform_Res49 :
            Bare_Attr_Head
               := No_Bare_R_F_L_X_Node;
      Transform_Diags49 :
            Ada.Containers.Count_Type;
      Row_Pos56 :
            Token_Index
               := No_Token_Index;
      Token_Pos81 :
            Token_Index
               := No_Token_Index;
      Token_Res81 :
            Token_Index
               := No_Token_Index;
      Transform_Res50 :
            Bare_Attr_Opaque
               := No_Bare_R_F_L_X_Node;
      Transform_Diags50 :
            Ada.Containers.Count_Type;
      Row_Pos57 :
            Token_Index
               := No_Token_Index;
      Token_Pos82 :
            Token_Index
               := No_Token_Index;
      Token_Res82 :
            Token_Index
               := No_Token_Index;
      Transform_Res51 :
            Bare_Attr_Present
               := No_Bare_R_F_L_X_Node;
      Transform_Diags51 :
            Ada.Containers.Count_Type;
      Row_Pos58 :
            Token_Index
               := No_Token_Index;
      Token_Pos83 :
            Token_Index
               := No_Token_Index;
      Token_Res83 :
            Token_Index
               := No_Token_Index;
      Transform_Res52 :
            Bare_Attr_Valid
               := No_Bare_R_F_L_X_Node;
      Transform_Diags52 :
            Ada.Containers.Count_Type;
      Or_Pos24 :
            Token_Index
               := No_Token_Index;
      Or_Res24 :
            Bare_Attr
               := No_Bare_R_F_L_X_Node;
      Transform_Res53 :
            Bare_Attribute
               := No_Bare_R_F_L_X_Node;
      Transform_Diags53 :
            Ada.Containers.Count_Type;
      Row_Pos59 :
            Token_Index
               := No_Token_Index;
      Defer_Pos83 :
            Token_Index
               := No_Token_Index;
      Defer_Res83 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos84 :
            Token_Index
               := No_Token_Index;
      Token_Res84 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos9 :
            Token_Index
               := No_Token_Index;
      Tmp_List9 :
            Free_Parse_List;
      Row_Pos60 :
            Token_Index
               := No_Token_Index;
      Defer_Pos84 :
            Token_Index
               := No_Token_Index;
      Defer_Res84 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos85 :
            Token_Index
               := No_Token_Index;
      Token_Res85 :
            Token_Index
               := No_Token_Index;
      Defer_Pos85 :
            Token_Index
               := No_Token_Index;
      Defer_Res85 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res54 :
            Bare_Term_Assoc
               := No_Bare_R_F_L_X_Node;
      Transform_Diags54 :
            Ada.Containers.Count_Type;
      Token_Pos86 :
            Token_Index
               := No_Token_Index;
      Token_Res86 :
            Token_Index
               := No_Token_Index;
      List_Pos9 :
            Token_Index
               := No_Token_Index;
      List_Res9 :
            Bare_Term_Assoc_List
               := No_Bare_R_F_L_X_Node;
      Transform_Res55 :
            Bare_Binding
               := No_Bare_R_F_L_X_Node;
      Transform_Diags55 :
            Ada.Containers.Count_Type;
      Defer_Pos86 :
            Token_Index
               := No_Token_Index;
      Defer_Res86 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos25 :
            Token_Index
               := No_Token_Index;
      Or_Res25 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Extended_Suffix_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res25 := M.Instance;
      return Or_Res25;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res25;
   end if;

       Set (Parser.Private_Part.Extended_Suffix_Or_Parse1_Memo, False, Or_Res25, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt6 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos25 := No_Token_Index;
Or_Res25 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags43 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos48 := Pos;



Defer_Res80 :=
   Extended_Suffix_Or_Parse1 (Parser, Row_Pos48);
Defer_Pos80 := Parser.Current_Pos;



Row_Progress6 := 1;

if Defer_Pos80 /= No_Token_Index then

   Row_Pos48 := Defer_Pos80;

else
   Row_Pos48 := No_Token_Index;
   goto Exit_Row48_0;

end if;


--  Start tok_code

Token_Res73 := Row_Pos48;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res73));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Dot)
   then
       Token_Pos73 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos48 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos48,
             Expected_Token_Id => Rflx_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos73 := Row_Pos48 + 1;
   end if;
end;

--  End tok_code



Row_Progress6 := 2;

if Token_Pos73 /= No_Token_Index then

   Row_Pos48 := Token_Pos73;

else
   Row_Pos48 := No_Token_Index;
   goto Exit_Row48_0;

end if;

Nobt6 := True;

   Nobt6 := Nobt6;

Row_Progress6 := 3;

if Row_Pos48 /= No_Token_Index then

   Row_Pos48 := Row_Pos48;

else
   Row_Pos48 := No_Token_Index;
   goto Exit_Row48_0;

end if;


Defer_Res81 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos48);
Defer_Pos81 := Parser.Current_Pos;



Row_Progress6 := 4;

if Defer_Pos81 /= No_Token_Index then

   Row_Pos48 := Defer_Pos81;

else
   Row_Pos48 := No_Token_Index;
   goto Exit_Row48_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row48_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos48 = No_Token_Index and then Nobt6 then

   Row_Pos48 := Parser.Last_Fail.Pos;

   Transform_Has_Failed6 := True;
end if;

if Row_Pos48 /= No_Token_Index then

   Transform_Res43 := Allocate_Select_Node (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res43,
      Kind => Rflx_Select_Node,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos48 = Pos
                            then No_Token_Index
                            else Row_Pos48 - 1));

      Initialize_Fields_For_Select_Node
        (Self => Transform_Res43, Select_Node_F_Expression => Defer_Res80, Select_Node_F_Selector => Defer_Res81);

         if Defer_Res80 /= null and then Is_Incomplete (Defer_Res80) then
            Transform_Res43.Last_Attempted_Child := 0;
         elsif Defer_Res80 /= null and then not Is_Ghost (Defer_Res80) then
            Transform_Res43.Last_Attempted_Child := -1;
         end if;
         if Defer_Res81 /= null and then Is_Incomplete (Defer_Res81) then
            Transform_Res43.Last_Attempted_Child := 0;
         elsif Defer_Res81 /= null and then not Is_Ghost (Defer_Res81) then
            Transform_Res43.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed6 then
      Transform_Res43.Last_Attempted_Child :=
         Row_Progress6;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_suffix>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos48 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags43);
end if;

--  End transform_code

    if Row_Pos48 /= No_Token_Index then
        Or_Pos25 := Row_Pos48;
        Or_Res25 := Transform_Res43;
        goto Exit_Or24;
    end if;
    
--  Start transform_code

Transform_Diags53 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos49 := Pos;



Defer_Res82 :=
   Extended_Suffix_Or_Parse1 (Parser, Row_Pos49);
Defer_Pos82 := Parser.Current_Pos;




if Defer_Pos82 /= No_Token_Index then

   Row_Pos49 := Defer_Pos82;

else
   Row_Pos49 := No_Token_Index;
   goto Exit_Row49_0;

end if;


--  Start tok_code

Token_Res74 := Row_Pos49;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res74));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Tick)
   then
       Token_Pos74 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos49 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos49,
             Expected_Token_Id => Rflx_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos74 := Row_Pos49 + 1;
   end if;
end;

--  End tok_code




if Token_Pos74 /= No_Token_Index then

   Row_Pos49 := Token_Pos74;

else
   Row_Pos49 := No_Token_Index;
   goto Exit_Row49_0;

end if;


--  Start or_code

Or_Pos24 := No_Token_Index;
Or_Res24 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags44 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos50 := Row_Pos49;



--  Start tok_code

Token_Res75 := Row_Pos50;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res75));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_First)
   then
       Token_Pos75 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos50 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos50,
             Expected_Token_Id => Rflx_First,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos75 := Row_Pos50 + 1;
   end if;
end;

--  End tok_code




if Token_Pos75 /= No_Token_Index then

   Row_Pos50 := Token_Pos75;

else
   Row_Pos50 := No_Token_Index;
   goto Exit_Row50_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row50_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos50 /= No_Token_Index then

   Transform_Res44 := Allocate_Attr_First (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res44,
      Kind => Rflx_Attr_First,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos50 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos50 - 1));




elsif Row_Pos50 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags44);
end if;

--  End transform_code

    if Row_Pos50 /= No_Token_Index then
        Or_Pos24 := Row_Pos50;
        Or_Res24 := Transform_Res44;
        goto Exit_Or25;
    end if;
    
--  Start transform_code

Transform_Diags45 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos51 := Row_Pos49;



--  Start tok_code

Token_Res76 := Row_Pos51;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res76));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Size)
   then
       Token_Pos76 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos51 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos51,
             Expected_Token_Id => Rflx_Size,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos76 := Row_Pos51 + 1;
   end if;
end;

--  End tok_code




if Token_Pos76 /= No_Token_Index then

   Row_Pos51 := Token_Pos76;

else
   Row_Pos51 := No_Token_Index;
   goto Exit_Row51_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row51_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos51 /= No_Token_Index then

   Transform_Res45 := Allocate_Attr_Size (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res45,
      Kind => Rflx_Attr_Size,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos51 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos51 - 1));




elsif Row_Pos51 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags45);
end if;

--  End transform_code

    if Row_Pos51 /= No_Token_Index then
        Or_Pos24 := Row_Pos51;
        Or_Res24 := Transform_Res45;
        goto Exit_Or25;
    end if;
    
--  Start transform_code

Transform_Diags46 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos52 := Row_Pos49;



--  Start tok_code

Token_Res77 := Row_Pos52;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res77));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Last)
   then
       Token_Pos77 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos52 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos52,
             Expected_Token_Id => Rflx_Last,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos77 := Row_Pos52 + 1;
   end if;
end;

--  End tok_code




if Token_Pos77 /= No_Token_Index then

   Row_Pos52 := Token_Pos77;

else
   Row_Pos52 := No_Token_Index;
   goto Exit_Row52_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row52_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos52 /= No_Token_Index then

   Transform_Res46 := Allocate_Attr_Last (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res46,
      Kind => Rflx_Attr_Last,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos52 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos52 - 1));




elsif Row_Pos52 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags46);
end if;

--  End transform_code

    if Row_Pos52 /= No_Token_Index then
        Or_Pos24 := Row_Pos52;
        Or_Res24 := Transform_Res46;
        goto Exit_Or25;
    end if;
    
--  Start transform_code

Transform_Diags47 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos53 := Row_Pos49;



--  Start tok_code

Token_Res78 := Row_Pos53;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res78));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Valid_Checksum)
   then
       Token_Pos78 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos53 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos53,
             Expected_Token_Id => Rflx_Valid_Checksum,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos78 := Row_Pos53 + 1;
   end if;
end;

--  End tok_code




if Token_Pos78 /= No_Token_Index then

   Row_Pos53 := Token_Pos78;

else
   Row_Pos53 := No_Token_Index;
   goto Exit_Row53_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row53_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos53 /= No_Token_Index then

   Transform_Res47 := Allocate_Attr_Valid_Checksum (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res47,
      Kind => Rflx_Attr_Valid_Checksum,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos53 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos53 - 1));




elsif Row_Pos53 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags47);
end if;

--  End transform_code

    if Row_Pos53 /= No_Token_Index then
        Or_Pos24 := Row_Pos53;
        Or_Res24 := Transform_Res47;
        goto Exit_Or25;
    end if;
    
--  Start transform_code

Transform_Diags48 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos54 := Row_Pos49;



--  Start tok_code

Token_Res79 := Row_Pos54;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res79));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Has_Data)
   then
       Token_Pos79 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos54 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos54,
             Expected_Token_Id => Rflx_Has_Data,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos79 := Row_Pos54 + 1;
   end if;
end;

--  End tok_code




if Token_Pos79 /= No_Token_Index then

   Row_Pos54 := Token_Pos79;

else
   Row_Pos54 := No_Token_Index;
   goto Exit_Row54_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row54_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos54 /= No_Token_Index then

   Transform_Res48 := Allocate_Attr_Has_Data (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res48,
      Kind => Rflx_Attr_Has_Data,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos54 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos54 - 1));




elsif Row_Pos54 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags48);
end if;

--  End transform_code

    if Row_Pos54 /= No_Token_Index then
        Or_Pos24 := Row_Pos54;
        Or_Res24 := Transform_Res48;
        goto Exit_Or25;
    end if;
    
--  Start transform_code

Transform_Diags49 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos55 := Row_Pos49;



--  Start tok_code

Token_Res80 := Row_Pos55;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res80));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Head)
   then
       Token_Pos80 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos55 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos55,
             Expected_Token_Id => Rflx_Head,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos80 := Row_Pos55 + 1;
   end if;
end;

--  End tok_code




if Token_Pos80 /= No_Token_Index then

   Row_Pos55 := Token_Pos80;

else
   Row_Pos55 := No_Token_Index;
   goto Exit_Row55_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row55_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos55 /= No_Token_Index then

   Transform_Res49 := Allocate_Attr_Head (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res49,
      Kind => Rflx_Attr_Head,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos55 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos55 - 1));




elsif Row_Pos55 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags49);
end if;

--  End transform_code

    if Row_Pos55 /= No_Token_Index then
        Or_Pos24 := Row_Pos55;
        Or_Res24 := Transform_Res49;
        goto Exit_Or25;
    end if;
    
--  Start transform_code

Transform_Diags50 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos56 := Row_Pos49;



--  Start tok_code

Token_Res81 := Row_Pos56;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res81));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Opaque)
   then
       Token_Pos81 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos56 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos56,
             Expected_Token_Id => Rflx_Opaque,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos81 := Row_Pos56 + 1;
   end if;
end;

--  End tok_code




if Token_Pos81 /= No_Token_Index then

   Row_Pos56 := Token_Pos81;

else
   Row_Pos56 := No_Token_Index;
   goto Exit_Row56_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row56_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos56 /= No_Token_Index then

   Transform_Res50 := Allocate_Attr_Opaque (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res50,
      Kind => Rflx_Attr_Opaque,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos56 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos56 - 1));




elsif Row_Pos56 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags50);
end if;

--  End transform_code

    if Row_Pos56 /= No_Token_Index then
        Or_Pos24 := Row_Pos56;
        Or_Res24 := Transform_Res50;
        goto Exit_Or25;
    end if;
    
--  Start transform_code

Transform_Diags51 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos57 := Row_Pos49;



--  Start tok_code

Token_Res82 := Row_Pos57;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res82));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Present)
   then
       Token_Pos82 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos57 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos57,
             Expected_Token_Id => Rflx_Present,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos82 := Row_Pos57 + 1;
   end if;
end;

--  End tok_code




if Token_Pos82 /= No_Token_Index then

   Row_Pos57 := Token_Pos82;

else
   Row_Pos57 := No_Token_Index;
   goto Exit_Row57_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row57_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos57 /= No_Token_Index then

   Transform_Res51 := Allocate_Attr_Present (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res51,
      Kind => Rflx_Attr_Present,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos57 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos57 - 1));




elsif Row_Pos57 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags51);
end if;

--  End transform_code

    if Row_Pos57 /= No_Token_Index then
        Or_Pos24 := Row_Pos57;
        Or_Res24 := Transform_Res51;
        goto Exit_Or25;
    end if;
    
--  Start transform_code

Transform_Diags52 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos58 := Row_Pos49;



--  Start tok_code

Token_Res83 := Row_Pos58;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res83));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Valid)
   then
       Token_Pos83 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos58 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos58,
             Expected_Token_Id => Rflx_Valid,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos83 := Row_Pos58 + 1;
   end if;
end;

--  End tok_code




if Token_Pos83 /= No_Token_Index then

   Row_Pos58 := Token_Pos83;

else
   Row_Pos58 := No_Token_Index;
   goto Exit_Row58_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row58_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos58 /= No_Token_Index then

   Transform_Res52 := Allocate_Attr_Valid (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res52,
      Kind => Rflx_Attr_Valid,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos58 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos58 - 1));




elsif Row_Pos58 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags52);
end if;

--  End transform_code

    if Row_Pos58 /= No_Token_Index then
        Or_Pos24 := Row_Pos58;
        Or_Res24 := Transform_Res52;
        goto Exit_Or25;
    end if;
<<Exit_Or25>>

--  End or_code




if Or_Pos24 /= No_Token_Index then

   Row_Pos49 := Or_Pos24;

else
   Row_Pos49 := No_Token_Index;
   goto Exit_Row49_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row49_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos49 /= No_Token_Index then

   Transform_Res53 := Allocate_Attribute (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res53,
      Kind => Rflx_Attribute,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos49 = Pos
                            then No_Token_Index
                            else Row_Pos49 - 1));

      Initialize_Fields_For_Attribute
        (Self => Transform_Res53, Attribute_F_Expression => Defer_Res82, Attribute_F_Kind => Or_Res24);

         if Defer_Res82 /= null and then Is_Incomplete (Defer_Res82) then
            Transform_Res53.Last_Attempted_Child := 0;
         elsif Defer_Res82 /= null and then not Is_Ghost (Defer_Res82) then
            Transform_Res53.Last_Attempted_Child := -1;
         end if;
         if Or_Res24 /= null and then Is_Incomplete (Or_Res24) then
            Transform_Res53.Last_Attempted_Child := 0;
         elsif Or_Res24 /= null and then not Is_Ghost (Or_Res24) then
            Transform_Res53.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos49 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags53);
end if;

--  End transform_code

    if Row_Pos49 /= No_Token_Index then
        Or_Pos25 := Row_Pos49;
        Or_Res25 := Transform_Res53;
        goto Exit_Or24;
    end if;
    
--  Start transform_code

Transform_Diags55 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos59 := Pos;



Defer_Res83 :=
   Extended_Suffix_Or_Parse1 (Parser, Row_Pos59);
Defer_Pos83 := Parser.Current_Pos;




if Defer_Pos83 /= No_Token_Index then

   Row_Pos59 := Defer_Pos83;

else
   Row_Pos59 := No_Token_Index;
   goto Exit_Row59_0;

end if;


--  Start tok_code

Token_Res84 := Row_Pos59;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res84));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Where)
   then
       Token_Pos84 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos59 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos59,
             Expected_Token_Id => Rflx_Where,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos84 := Row_Pos59 + 1;
   end if;
end;

--  End tok_code




if Token_Pos84 /= No_Token_Index then

   Row_Pos59 := Token_Pos84;

else
   Row_Pos59 := No_Token_Index;
   goto Exit_Row59_0;

end if;


--  Start list_code

    List_Pos9 := No_Token_Index;



Lst_Cpos9 := Row_Pos59;
Tmp_List9 := Get_Parse_List (Parser);

loop
   
--  Start transform_code

Transform_Diags54 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos60 := Lst_Cpos9;



Defer_Res84 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos60);
Defer_Pos84 := Parser.Current_Pos;




if Defer_Pos84 /= No_Token_Index then

   Row_Pos60 := Defer_Pos84;

else
   Row_Pos60 := No_Token_Index;
   goto Exit_Row60_0;

end if;


--  Start tok_code

Token_Res85 := Row_Pos60;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res85));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Eq)
   then
       Token_Pos85 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos60 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos60,
             Expected_Token_Id => Rflx_Eq,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos85 := Row_Pos60 + 1;
   end if;
end;

--  End tok_code




if Token_Pos85 /= No_Token_Index then

   Row_Pos60 := Token_Pos85;

else
   Row_Pos60 := No_Token_Index;
   goto Exit_Row60_0;

end if;


Defer_Res85 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos60);
Defer_Pos85 := Parser.Current_Pos;




if Defer_Pos85 /= No_Token_Index then

   Row_Pos60 := Defer_Pos85;

else
   Row_Pos60 := No_Token_Index;
   goto Exit_Row60_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row60_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos60 /= No_Token_Index then

   Transform_Res54 := Allocate_Term_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res54,
      Kind => Rflx_Term_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos9,
      Token_End_Index   => (if Row_Pos60 = Lst_Cpos9
                            then No_Token_Index
                            else Row_Pos60 - 1));

      Initialize_Fields_For_Term_Assoc
        (Self => Transform_Res54, Term_Assoc_F_Identifier => Defer_Res84, Term_Assoc_F_Expression => Defer_Res85);

         if Defer_Res84 /= null and then Is_Incomplete (Defer_Res84) then
            Transform_Res54.Last_Attempted_Child := 0;
         elsif Defer_Res84 /= null and then not Is_Ghost (Defer_Res84) then
            Transform_Res54.Last_Attempted_Child := -1;
         end if;
         if Defer_Res85 /= null and then Is_Incomplete (Defer_Res85) then
            Transform_Res54.Last_Attempted_Child := 0;
         elsif Defer_Res85 /= null and then not Is_Ghost (Defer_Res85) then
            Transform_Res54.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos60 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags54);
end if;

--  End transform_code


   exit when Row_Pos60 = No_Token_Index;

   List_Pos9 := Row_Pos60;
   Lst_Cpos9 := List_Pos9;

   Tmp_List9.Nodes.Append (Transform_Res54);

      
--  Start tok_code

Token_Res86 := Lst_Cpos9;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res86));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos86 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos9 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos9,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos86 := Lst_Cpos9 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos86 /= No_Token_Index then
          Lst_Cpos9 := Token_Pos86;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List9.Nodes.Length;
begin
   List_Res9 :=
      Allocate_Term_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos59;
      Token_End := (if Lst_Cpos9 = Row_Pos59
                    then Row_Pos59
                    else Lst_Cpos9 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos59, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res9,
      Kind              => Rflx_Term_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res9,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List9.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res9.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List9);

--  End list_code




if List_Pos9 /= No_Token_Index then

   Row_Pos59 := List_Pos9;

else
   Row_Pos59 := No_Token_Index;
   goto Exit_Row59_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row59_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos59 /= No_Token_Index then

   Transform_Res55 := Allocate_Binding (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res55,
      Kind => Rflx_Binding,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos59 = Pos
                            then No_Token_Index
                            else Row_Pos59 - 1));

      Initialize_Fields_For_Binding
        (Self => Transform_Res55, Binding_F_Expression => Defer_Res83, Binding_F_Bindings => List_Res9);

         if Defer_Res83 /= null and then Is_Incomplete (Defer_Res83) then
            Transform_Res55.Last_Attempted_Child := 0;
         elsif Defer_Res83 /= null and then not Is_Ghost (Defer_Res83) then
            Transform_Res55.Last_Attempted_Child := -1;
         end if;
         if List_Res9 /= null and then Is_Incomplete (List_Res9) then
            Transform_Res55.Last_Attempted_Child := 0;
         elsif List_Res9 /= null and then not Is_Ghost (List_Res9) then
            Transform_Res55.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos59 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags55);
end if;

--  End transform_code

    if Row_Pos59 /= No_Token_Index then
        Or_Pos25 := Row_Pos59;
        Or_Res25 := Transform_Res55;
        goto Exit_Or24;
    end if;
    
Defer_Res86 :=
   Extended_Primary_Or_Parse0 (Parser, Pos);
Defer_Pos86 := Parser.Current_Pos;

    if Defer_Pos86 /= No_Token_Index then
        Or_Pos25 := Defer_Pos86;
        Or_Res25 := Defer_Res86;
        goto Exit_Or24;
    end if;
<<Exit_Or24>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos25 > Mem_Pos then
         Mem_Pos := Or_Pos25;
         Mem_Res := Or_Res25;
         Set
           (Parser.Private_Part.Extended_Suffix_Or_Parse1_Memo,
            Or_Pos25 /= No_Token_Index,
            Or_Res25,
            Pos,
            Or_Pos25);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res25 := Mem_Res;
         Or_Pos25 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Extended_Suffix_Or_Parse1_Memo,
      Or_Pos25 /= No_Token_Index,
      Or_Res25,
      Pos,
      Or_Pos25);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos25;

   return Or_Res25;
end Extended_Suffix_Or_Parse1;

   


function Extended_Term_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt7 :
            Boolean
               := False;
      Row_Pos61 :
            Token_Index
               := No_Token_Index;
      Defer_Pos87 :
            Token_Index
               := No_Token_Index;
      Defer_Res87 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Pos62 :
            Token_Index
               := No_Token_Index;
      Token_Pos87 :
            Token_Index
               := No_Token_Index;
      Token_Res87 :
            Token_Index
               := No_Token_Index;
      Transform_Res56 :
            Bare_Op_Mul
               := No_Bare_R_F_L_X_Node;
      Transform_Diags56 :
            Ada.Containers.Count_Type;
      Row_Pos63 :
            Token_Index
               := No_Token_Index;
      Token_Pos88 :
            Token_Index
               := No_Token_Index;
      Token_Res88 :
            Token_Index
               := No_Token_Index;
      Transform_Res57 :
            Bare_Op_Div
               := No_Bare_R_F_L_X_Node;
      Transform_Diags57 :
            Ada.Containers.Count_Type;
      Row_Pos64 :
            Token_Index
               := No_Token_Index;
      Token_Pos89 :
            Token_Index
               := No_Token_Index;
      Token_Res89 :
            Token_Index
               := No_Token_Index;
      Transform_Res58 :
            Bare_Op_Mod
               := No_Bare_R_F_L_X_Node;
      Transform_Diags58 :
            Ada.Containers.Count_Type;
      Or_Pos26 :
            Token_Index
               := No_Token_Index;
      Or_Res26 :
            Bare_Op
               := No_Bare_R_F_L_X_Node;
      Defer_Pos88 :
            Token_Index
               := No_Token_Index;
      Defer_Res88 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Progress7 :
            Integer
               := 0;
      Transform_Res59 :
            Bare_Bin_Op
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed7 :
            Boolean
               := False;
      Transform_Diags59 :
            Ada.Containers.Count_Type;
      Defer_Pos89 :
            Token_Index
               := No_Token_Index;
      Defer_Res89 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos27 :
            Token_Index
               := No_Token_Index;
      Or_Res27 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Extended_Term_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res27 := M.Instance;
      return Or_Res27;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res27;
   end if;

       Set (Parser.Private_Part.Extended_Term_Or_Parse1_Memo, False, Or_Res27, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt7 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos27 := No_Token_Index;
Or_Res27 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags59 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos61 := Pos;



Defer_Res87 :=
   Extended_Term_Or_Parse1 (Parser, Row_Pos61);
Defer_Pos87 := Parser.Current_Pos;



Row_Progress7 := 1;

if Defer_Pos87 /= No_Token_Index then

   Row_Pos61 := Defer_Pos87;

else
   Row_Pos61 := No_Token_Index;
   goto Exit_Row61_0;

end if;


--  Start or_code

Or_Pos26 := No_Token_Index;
Or_Res26 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags56 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos62 := Row_Pos61;



--  Start tok_code

Token_Res87 := Row_Pos62;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res87));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Mul)
   then
       Token_Pos87 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos62 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos62,
             Expected_Token_Id => Rflx_Mul,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos87 := Row_Pos62 + 1;
   end if;
end;

--  End tok_code




if Token_Pos87 /= No_Token_Index then

   Row_Pos62 := Token_Pos87;

else
   Row_Pos62 := No_Token_Index;
   goto Exit_Row62_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row62_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos62 /= No_Token_Index then

   Transform_Res56 := Allocate_Op_Mul (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res56,
      Kind => Rflx_Op_Mul,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos61,
      Token_End_Index   => (if Row_Pos62 = Row_Pos61
                            then No_Token_Index
                            else Row_Pos62 - 1));




elsif Row_Pos62 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags56);
end if;

--  End transform_code

    if Row_Pos62 /= No_Token_Index then
        Or_Pos26 := Row_Pos62;
        Or_Res26 := Transform_Res56;
        goto Exit_Or27;
    end if;
    
--  Start transform_code

Transform_Diags57 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos63 := Row_Pos61;



--  Start tok_code

Token_Res88 := Row_Pos63;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res88));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Div)
   then
       Token_Pos88 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos63 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos63,
             Expected_Token_Id => Rflx_Div,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos88 := Row_Pos63 + 1;
   end if;
end;

--  End tok_code




if Token_Pos88 /= No_Token_Index then

   Row_Pos63 := Token_Pos88;

else
   Row_Pos63 := No_Token_Index;
   goto Exit_Row63_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row63_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos63 /= No_Token_Index then

   Transform_Res57 := Allocate_Op_Div (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res57,
      Kind => Rflx_Op_Div,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos61,
      Token_End_Index   => (if Row_Pos63 = Row_Pos61
                            then No_Token_Index
                            else Row_Pos63 - 1));




elsif Row_Pos63 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags57);
end if;

--  End transform_code

    if Row_Pos63 /= No_Token_Index then
        Or_Pos26 := Row_Pos63;
        Or_Res26 := Transform_Res57;
        goto Exit_Or27;
    end if;
    
--  Start transform_code

Transform_Diags58 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos64 := Row_Pos61;



--  Start tok_code

Token_Res89 := Row_Pos64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res89));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Mod)
   then
       Token_Pos89 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos64,
             Expected_Token_Id => Rflx_Mod,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos89 := Row_Pos64 + 1;
   end if;
end;

--  End tok_code




if Token_Pos89 /= No_Token_Index then

   Row_Pos64 := Token_Pos89;

else
   Row_Pos64 := No_Token_Index;
   goto Exit_Row64_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row64_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos64 /= No_Token_Index then

   Transform_Res58 := Allocate_Op_Mod (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res58,
      Kind => Rflx_Op_Mod,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos61,
      Token_End_Index   => (if Row_Pos64 = Row_Pos61
                            then No_Token_Index
                            else Row_Pos64 - 1));




elsif Row_Pos64 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags58);
end if;

--  End transform_code

    if Row_Pos64 /= No_Token_Index then
        Or_Pos26 := Row_Pos64;
        Or_Res26 := Transform_Res58;
        goto Exit_Or27;
    end if;
<<Exit_Or27>>

--  End or_code



Row_Progress7 := 2;

if Or_Pos26 /= No_Token_Index then

   Row_Pos61 := Or_Pos26;

else
   Row_Pos61 := No_Token_Index;
   goto Exit_Row61_0;

end if;

Nobt7 := True;

   Nobt7 := Nobt7;

Row_Progress7 := 3;

if Row_Pos61 /= No_Token_Index then

   Row_Pos61 := Row_Pos61;

else
   Row_Pos61 := No_Token_Index;
   goto Exit_Row61_0;

end if;


Defer_Res88 :=
   Extended_Factor_Or_Parse1 (Parser, Row_Pos61);
Defer_Pos88 := Parser.Current_Pos;



Row_Progress7 := 4;

if Defer_Pos88 /= No_Token_Index then

   Row_Pos61 := Defer_Pos88;

else
   Row_Pos61 := No_Token_Index;
   goto Exit_Row61_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row61_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos61 = No_Token_Index and then Nobt7 then

   Row_Pos61 := Parser.Last_Fail.Pos;

   Transform_Has_Failed7 := True;
end if;

if Row_Pos61 /= No_Token_Index then

   Transform_Res59 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res59,
      Kind => Rflx_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos61 = Pos
                            then No_Token_Index
                            else Row_Pos61 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res59, Bin_Op_F_Left => Defer_Res87, Bin_Op_F_Op => Or_Res26, Bin_Op_F_Right => Defer_Res88);

         if Defer_Res87 /= null and then Is_Incomplete (Defer_Res87) then
            Transform_Res59.Last_Attempted_Child := 0;
         elsif Defer_Res87 /= null and then not Is_Ghost (Defer_Res87) then
            Transform_Res59.Last_Attempted_Child := -1;
         end if;
         if Or_Res26 /= null and then Is_Incomplete (Or_Res26) then
            Transform_Res59.Last_Attempted_Child := 0;
         elsif Or_Res26 /= null and then not Is_Ghost (Or_Res26) then
            Transform_Res59.Last_Attempted_Child := -1;
         end if;
         if Defer_Res88 /= null and then Is_Incomplete (Defer_Res88) then
            Transform_Res59.Last_Attempted_Child := 0;
         elsif Defer_Res88 /= null and then not Is_Ghost (Defer_Res88) then
            Transform_Res59.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed7 then
      Transform_Res59.Last_Attempted_Child :=
         Row_Progress7;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_term>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos61 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags59);
end if;

--  End transform_code

    if Row_Pos61 /= No_Token_Index then
        Or_Pos27 := Row_Pos61;
        Or_Res27 := Transform_Res59;
        goto Exit_Or26;
    end if;
    
Defer_Res89 :=
   Extended_Factor_Or_Parse1 (Parser, Pos);
Defer_Pos89 := Parser.Current_Pos;

    if Defer_Pos89 /= No_Token_Index then
        Or_Pos27 := Defer_Pos89;
        Or_Res27 := Defer_Res89;
        goto Exit_Or26;
    end if;
<<Exit_Or26>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos27 > Mem_Pos then
         Mem_Pos := Or_Pos27;
         Mem_Res := Or_Res27;
         Set
           (Parser.Private_Part.Extended_Term_Or_Parse1_Memo,
            Or_Pos27 /= No_Token_Index,
            Or_Res27,
            Pos,
            Or_Pos27);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res27 := Mem_Res;
         Or_Pos27 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Extended_Term_Or_Parse1_Memo,
      Or_Pos27 /= No_Token_Index,
      Or_Res27,
      Pos,
      Or_Pos27);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos27;

   return Or_Res27;
end Extended_Term_Or_Parse1;

   


function Extended_Unop_Term_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt8 :
            Boolean
               := False;
      Row_Pos65 :
            Token_Index
               := No_Token_Index;
      Token_Pos90 :
            Token_Index
               := No_Token_Index;
      Token_Res90 :
            Token_Index
               := No_Token_Index;
      Defer_Pos90 :
            Token_Index
               := No_Token_Index;
      Defer_Res90 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Progress8 :
            Integer
               := 0;
      Transform_Res60 :
            Bare_Negation
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed8 :
            Boolean
               := False;
      Transform_Diags60 :
            Ada.Containers.Count_Type;
      Defer_Pos91 :
            Token_Index
               := No_Token_Index;
      Defer_Res91 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos28 :
            Token_Index
               := No_Token_Index;
      Or_Res28 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_Unop_Term_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res28 := M.Instance;
      return Or_Res28;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res28;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos28 := No_Token_Index;
Or_Res28 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags60 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos65 := Pos;



--  Start tok_code

Token_Res90 := Row_Pos65;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res90));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Sub)
   then
       Token_Pos90 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos65 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos65,
             Expected_Token_Id => Rflx_Sub,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos90 := Row_Pos65 + 1;
   end if;
end;

--  End tok_code



Row_Progress8 := 1;

if Token_Pos90 /= No_Token_Index then

   Row_Pos65 := Token_Pos90;

else
   Row_Pos65 := No_Token_Index;
   goto Exit_Row65_0;

end if;

Nobt8 := True;

   Nobt8 := Nobt8;

Row_Progress8 := 2;

if Row_Pos65 /= No_Token_Index then

   Row_Pos65 := Row_Pos65;

else
   Row_Pos65 := No_Token_Index;
   goto Exit_Row65_0;

end if;


Defer_Res90 :=
   Extended_Term_Or_Parse1 (Parser, Row_Pos65);
Defer_Pos90 := Parser.Current_Pos;



Row_Progress8 := 3;

if Defer_Pos90 /= No_Token_Index then

   Row_Pos65 := Defer_Pos90;

else
   Row_Pos65 := No_Token_Index;
   goto Exit_Row65_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row65_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos65 = No_Token_Index and then Nobt8 then

   Row_Pos65 := Parser.Last_Fail.Pos;

   Transform_Has_Failed8 := True;
end if;

if Row_Pos65 /= No_Token_Index then

   Transform_Res60 := Allocate_Negation (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res60,
      Kind => Rflx_Negation,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos65 = Pos
                            then No_Token_Index
                            else Row_Pos65 - 1));

      Initialize_Fields_For_Negation
        (Self => Transform_Res60, Negation_F_Data => Defer_Res90);

         if Defer_Res90 /= null and then Is_Incomplete (Defer_Res90) then
            Transform_Res60.Last_Attempted_Child := 0;
         elsif Defer_Res90 /= null and then not Is_Ghost (Defer_Res90) then
            Transform_Res60.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed8 then
      Transform_Res60.Last_Attempted_Child :=
         Row_Progress8;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_unop_term>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos65 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags60);
end if;

--  End transform_code

    if Row_Pos65 /= No_Token_Index then
        Or_Pos28 := Row_Pos65;
        Or_Res28 := Transform_Res60;
        goto Exit_Or28;
    end if;
    
Defer_Res91 :=
   Extended_Term_Or_Parse1 (Parser, Pos);
Defer_Pos91 := Parser.Current_Pos;

    if Defer_Pos91 /= No_Token_Index then
        Or_Pos28 := Defer_Pos91;
        Or_Res28 := Defer_Res91;
        goto Exit_Or28;
    end if;
<<Exit_Or28>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_Unop_Term_Or_Parse0_Memo,
      Or_Pos28 /= No_Token_Index,
      Or_Res28,
      Pos,
      Or_Pos28);


   Parser.Current_Pos := Or_Pos28;

   return Or_Res28;
end Extended_Unop_Term_Or_Parse0;

   


function Factor_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt9 :
            Boolean
               := False;
      Row_Pos66 :
            Token_Index
               := No_Token_Index;
      Defer_Pos92 :
            Token_Index
               := No_Token_Index;
      Defer_Res92 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Pos67 :
            Token_Index
               := No_Token_Index;
      Token_Pos91 :
            Token_Index
               := No_Token_Index;
      Token_Res91 :
            Token_Index
               := No_Token_Index;
      Transform_Res61 :
            Bare_Op_Pow
               := No_Bare_R_F_L_X_Node;
      Transform_Diags61 :
            Ada.Containers.Count_Type;
      Defer_Pos93 :
            Token_Index
               := No_Token_Index;
      Defer_Res93 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Progress9 :
            Integer
               := 0;
      Transform_Res62 :
            Bare_Bin_Op
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed9 :
            Boolean
               := False;
      Transform_Diags62 :
            Ada.Containers.Count_Type;
      Defer_Pos94 :
            Token_Index
               := No_Token_Index;
      Defer_Res94 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos29 :
            Token_Index
               := No_Token_Index;
      Or_Res29 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Factor_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res29 := M.Instance;
      return Or_Res29;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res29;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos29 := No_Token_Index;
Or_Res29 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags62 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos66 := Pos;



Defer_Res92 :=
   Primary_Or_Parse0 (Parser, Row_Pos66);
Defer_Pos92 := Parser.Current_Pos;



Row_Progress9 := 1;

if Defer_Pos92 /= No_Token_Index then

   Row_Pos66 := Defer_Pos92;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;


--  Start transform_code

Transform_Diags61 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos67 := Row_Pos66;



--  Start tok_code

Token_Res91 := Row_Pos67;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res91));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Exp)
   then
       Token_Pos91 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos67 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos67,
             Expected_Token_Id => Rflx_Exp,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos91 := Row_Pos67 + 1;
   end if;
end;

--  End tok_code




if Token_Pos91 /= No_Token_Index then

   Row_Pos67 := Token_Pos91;

else
   Row_Pos67 := No_Token_Index;
   goto Exit_Row67_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row67_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos67 /= No_Token_Index then

   Transform_Res61 := Allocate_Op_Pow (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res61,
      Kind => Rflx_Op_Pow,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos66,
      Token_End_Index   => (if Row_Pos67 = Row_Pos66
                            then No_Token_Index
                            else Row_Pos67 - 1));




elsif Row_Pos67 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags61);
end if;

--  End transform_code



Row_Progress9 := 2;

if Row_Pos67 /= No_Token_Index then

   Row_Pos66 := Row_Pos67;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;

Nobt9 := True;

   Nobt9 := Nobt9;

Row_Progress9 := 3;

if Row_Pos66 /= No_Token_Index then

   Row_Pos66 := Row_Pos66;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;


Defer_Res93 :=
   Primary_Or_Parse0 (Parser, Row_Pos66);
Defer_Pos93 := Parser.Current_Pos;



Row_Progress9 := 4;

if Defer_Pos93 /= No_Token_Index then

   Row_Pos66 := Defer_Pos93;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row66_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos66 = No_Token_Index and then Nobt9 then

   Row_Pos66 := Parser.Last_Fail.Pos;

   Transform_Has_Failed9 := True;
end if;

if Row_Pos66 /= No_Token_Index then

   Transform_Res62 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res62,
      Kind => Rflx_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos66 = Pos
                            then No_Token_Index
                            else Row_Pos66 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res62, Bin_Op_F_Left => Defer_Res92, Bin_Op_F_Op => Transform_Res61, Bin_Op_F_Right => Defer_Res93);

         if Defer_Res92 /= null and then Is_Incomplete (Defer_Res92) then
            Transform_Res62.Last_Attempted_Child := 0;
         elsif Defer_Res92 /= null and then not Is_Ghost (Defer_Res92) then
            Transform_Res62.Last_Attempted_Child := -1;
         end if;
         if Transform_Res61 /= null and then Is_Incomplete (Transform_Res61) then
            Transform_Res62.Last_Attempted_Child := 0;
         elsif Transform_Res61 /= null and then not Is_Ghost (Transform_Res61) then
            Transform_Res62.Last_Attempted_Child := -1;
         end if;
         if Defer_Res93 /= null and then Is_Incomplete (Defer_Res93) then
            Transform_Res62.Last_Attempted_Child := 0;
         elsif Defer_Res93 /= null and then not Is_Ghost (Defer_Res93) then
            Transform_Res62.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed9 then
      Transform_Res62.Last_Attempted_Child :=
         Row_Progress9;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <factor>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos66 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags62);
end if;

--  End transform_code

    if Row_Pos66 /= No_Token_Index then
        Or_Pos29 := Row_Pos66;
        Or_Res29 := Transform_Res62;
        goto Exit_Or29;
    end if;
    
Defer_Res94 :=
   Suffix_Or_Parse1 (Parser, Pos);
Defer_Pos94 := Parser.Current_Pos;

    if Defer_Pos94 /= No_Token_Index then
        Or_Pos29 := Defer_Pos94;
        Or_Res29 := Defer_Res94;
        goto Exit_Or29;
    end if;
<<Exit_Or29>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Factor_Or_Parse0_Memo,
      Or_Pos29 /= No_Token_Index,
      Or_Res29,
      Pos,
      Or_Pos29);


   Parser.Current_Pos := Or_Pos29;

   return Or_Res29;
end Factor_Or_Parse0;

   


function Formal_Function_Declaration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Function_Decl
is
   use Bare_Formal_Function_Decl_Memos;

      Row_Pos68 :
            Token_Index
               := No_Token_Index;
      Token_Pos92 :
            Token_Index
               := No_Token_Index;
      Token_Res92 :
            Token_Index
               := No_Token_Index;
      Token_Pos93 :
            Token_Index
               := No_Token_Index;
      Token_Res93 :
            Token_Index
               := No_Token_Index;
      Defer_Pos95 :
            Token_Index
               := No_Token_Index;
      Defer_Res95 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Defer_Pos96 :
            Token_Index
               := No_Token_Index;
      Defer_Res96 :
            Bare_Parameters
               := No_Bare_R_F_L_X_Node;
      Token_Pos94 :
            Token_Index
               := No_Token_Index;
      Token_Res94 :
            Token_Index
               := No_Token_Index;
      Defer_Pos97 :
            Token_Index
               := No_Token_Index;
      Defer_Res97 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Transform_Res63 :
            Bare_Formal_Function_Decl
               := No_Bare_R_F_L_X_Node;
      Transform_Diags63 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Formal_Function_Declaration_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res63 := M.Instance;
      return Transform_Res63;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res63;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags63 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos68 := Pos;



--  Start tok_code

Token_Res92 := Row_Pos68;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res92));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_With)
   then
       Token_Pos92 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos68 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos68,
             Expected_Token_Id => Rflx_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos92 := Row_Pos68 + 1;
   end if;
end;

--  End tok_code




if Token_Pos92 /= No_Token_Index then

   Row_Pos68 := Token_Pos92;

else
   Row_Pos68 := No_Token_Index;
   goto Exit_Row68_0;

end if;


--  Start tok_code

Token_Res93 := Row_Pos68;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res93));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Function)
   then
       Token_Pos93 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos68 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos68,
             Expected_Token_Id => Rflx_Function,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos93 := Row_Pos68 + 1;
   end if;
end;

--  End tok_code




if Token_Pos93 /= No_Token_Index then

   Row_Pos68 := Token_Pos93;

else
   Row_Pos68 := No_Token_Index;
   goto Exit_Row68_0;

end if;


Defer_Res95 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos68);
Defer_Pos95 := Parser.Current_Pos;




if Defer_Pos95 /= No_Token_Index then

   Row_Pos68 := Defer_Pos95;

else
   Row_Pos68 := No_Token_Index;
   goto Exit_Row68_0;

end if;


--  Start opt_code












Defer_Res96 :=
   Parameter_List_Transform_Parse0 (Parser, Row_Pos68);
Defer_Pos96 := Parser.Current_Pos;


if Defer_Pos96 = No_Token_Index then

         
   Defer_Res96 := No_Bare_R_F_L_X_Node;



       
   Defer_Pos96 := Row_Pos68;



end if;

--  End opt_code




if Defer_Pos96 /= No_Token_Index then

   Row_Pos68 := Defer_Pos96;

else
   Row_Pos68 := No_Token_Index;
   goto Exit_Row68_0;

end if;


--  Start tok_code

Token_Res94 := Row_Pos68;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res94));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Return)
   then
       Token_Pos94 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos68 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos68,
             Expected_Token_Id => Rflx_Return,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos94 := Row_Pos68 + 1;
   end if;
end;

--  End tok_code




if Token_Pos94 /= No_Token_Index then

   Row_Pos68 := Token_Pos94;

else
   Row_Pos68 := No_Token_Index;
   goto Exit_Row68_0;

end if;


Defer_Res97 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Row_Pos68);
Defer_Pos97 := Parser.Current_Pos;




if Defer_Pos97 /= No_Token_Index then

   Row_Pos68 := Defer_Pos97;

else
   Row_Pos68 := No_Token_Index;
   goto Exit_Row68_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row68_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos68 /= No_Token_Index then

   Transform_Res63 := Allocate_Formal_Function_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res63,
      Kind => Rflx_Formal_Function_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos68 = Pos
                            then No_Token_Index
                            else Row_Pos68 - 1));

      Initialize_Fields_For_Formal_Function_Decl
        (Self => Transform_Res63, Formal_Function_Decl_F_Identifier => Defer_Res95, Formal_Function_Decl_F_Parameters => Defer_Res96, Formal_Function_Decl_F_Return_Type_Identifier => Defer_Res97);

         if Defer_Res95 /= null and then Is_Incomplete (Defer_Res95) then
            Transform_Res63.Last_Attempted_Child := 0;
         elsif Defer_Res95 /= null and then not Is_Ghost (Defer_Res95) then
            Transform_Res63.Last_Attempted_Child := -1;
         end if;
         if Defer_Res96 /= null and then Is_Incomplete (Defer_Res96) then
            Transform_Res63.Last_Attempted_Child := 0;
         elsif Defer_Res96 /= null and then not Is_Ghost (Defer_Res96) then
            Transform_Res63.Last_Attempted_Child := -1;
         end if;
         if Defer_Res97 /= null and then Is_Incomplete (Defer_Res97) then
            Transform_Res63.Last_Attempted_Child := 0;
         elsif Defer_Res97 /= null and then not Is_Ghost (Defer_Res97) then
            Transform_Res63.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos68 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags63);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Formal_Function_Declaration_Transform_Parse0_Memo,
      Row_Pos68 /= No_Token_Index,
      Transform_Res63,
      Pos,
      Row_Pos68);


   Parser.Current_Pos := Row_Pos68;

   return Transform_Res63;
end Formal_Function_Declaration_Transform_Parse0;

   


function If_Condition_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Row_Pos69 :
            Token_Index
               := No_Token_Index;
      Token_Pos95 :
            Token_Index
               := No_Token_Index;
      Token_Res95 :
            Token_Index
               := No_Token_Index;
      Defer_Pos98 :
            Token_Index
               := No_Token_Index;
      Defer_Res98 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.If_Condition_Extract_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Defer_Res98 := M.Instance;
      return Defer_Res98;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Defer_Res98;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start row_code

Row_Pos69 := Pos;



--  Start tok_code

Token_Res95 := Row_Pos69;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res95));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_If)
   then
       Token_Pos95 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos69 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos69,
             Expected_Token_Id => Rflx_If,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos95 := Row_Pos69 + 1;
   end if;
end;

--  End tok_code




if Token_Pos95 /= No_Token_Index then

   Row_Pos69 := Token_Pos95;

else
   Row_Pos69 := No_Token_Index;
   goto Exit_Row69_0;

end if;


Defer_Res98 :=
   Expression_Or_Parse1 (Parser, Row_Pos69);
Defer_Pos98 := Parser.Current_Pos;




if Defer_Pos98 /= No_Token_Index then

   Row_Pos69 := Defer_Pos98;

else
   Row_Pos69 := No_Token_Index;
   goto Exit_Row69_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row69_0>>
pragma Warnings (On, "referenced");

--  End row_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.If_Condition_Extract_Parse0_Memo,
      Row_Pos69 /= No_Token_Index,
      Defer_Res98,
      Pos,
      Row_Pos69);


   Parser.Current_Pos := Row_Pos69;

   return Defer_Res98;
end If_Condition_Extract_Parse0;

   


function Integer_Type_Definition_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Integer_Type_Def
is
   use Bare_Integer_Type_Def_Memos;

      Defer_Pos99 :
            Token_Index
               := No_Token_Index;
      Defer_Res99 :
            Bare_Range_Type_Def
               := No_Bare_R_F_L_X_Node;
      Defer_Pos100 :
            Token_Index
               := No_Token_Index;
      Defer_Res100 :
            Bare_Modular_Type_Def
               := No_Bare_R_F_L_X_Node;
      Or_Pos30 :
            Token_Index
               := No_Token_Index;
      Or_Res30 :
            Bare_Integer_Type_Def
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Integer_Type_Definition_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res30 := M.Instance;
      return Or_Res30;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res30;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos30 := No_Token_Index;
Or_Res30 := No_Bare_R_F_L_X_Node;
    
Defer_Res99 :=
   Range_Type_Definition_Transform_Parse0 (Parser, Pos);
Defer_Pos99 := Parser.Current_Pos;

    if Defer_Pos99 /= No_Token_Index then
        Or_Pos30 := Defer_Pos99;
        Or_Res30 := Defer_Res99;
        goto Exit_Or30;
    end if;
    
Defer_Res100 :=
   Modular_Type_Definition_Transform_Parse0 (Parser, Pos);
Defer_Pos100 := Parser.Current_Pos;

    if Defer_Pos100 /= No_Token_Index then
        Or_Pos30 := Defer_Pos100;
        Or_Res30 := Defer_Res100;
        goto Exit_Or30;
    end if;
<<Exit_Or30>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Integer_Type_Definition_Or_Parse0_Memo,
      Or_Pos30 /= No_Token_Index,
      Or_Res30,
      Pos,
      Or_Pos30);


   Parser.Current_Pos := Or_Pos30;

   return Or_Res30;
end Integer_Type_Definition_Or_Parse0;

   


function List_Attribute_Transform_Parse4
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Attribute_Statement
is
   use Bare_Attribute_Statement_Memos;

      Row_Pos70 :
            Token_Index
               := No_Token_Index;
      Defer_Pos101 :
            Token_Index
               := No_Token_Index;
      Defer_Res101 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos96 :
            Token_Index
               := No_Token_Index;
      Token_Res96 :
            Token_Index
               := No_Token_Index;
      Row_Pos71 :
            Token_Index
               := No_Token_Index;
      Token_Pos97 :
            Token_Index
               := No_Token_Index;
      Token_Res97 :
            Token_Index
               := No_Token_Index;
      Transform_Res64 :
            Bare_Attr_Stmt_Append
               := No_Bare_R_F_L_X_Node;
      Transform_Diags64 :
            Ada.Containers.Count_Type;
      Row_Pos72 :
            Token_Index
               := No_Token_Index;
      Token_Pos98 :
            Token_Index
               := No_Token_Index;
      Token_Res98 :
            Token_Index
               := No_Token_Index;
      Transform_Res65 :
            Bare_Attr_Stmt_Extend
               := No_Bare_R_F_L_X_Node;
      Transform_Diags65 :
            Ada.Containers.Count_Type;
      Row_Pos73 :
            Token_Index
               := No_Token_Index;
      Token_Pos99 :
            Token_Index
               := No_Token_Index;
      Token_Res99 :
            Token_Index
               := No_Token_Index;
      Transform_Res66 :
            Bare_Attr_Stmt_Read
               := No_Bare_R_F_L_X_Node;
      Transform_Diags66 :
            Ada.Containers.Count_Type;
      Row_Pos74 :
            Token_Index
               := No_Token_Index;
      Token_Pos100 :
            Token_Index
               := No_Token_Index;
      Token_Res100 :
            Token_Index
               := No_Token_Index;
      Transform_Res67 :
            Bare_Attr_Stmt_Write
               := No_Bare_R_F_L_X_Node;
      Transform_Diags67 :
            Ada.Containers.Count_Type;
      Or_Pos31 :
            Token_Index
               := No_Token_Index;
      Or_Res31 :
            Bare_Attr_Stmt
               := No_Bare_R_F_L_X_Node;
      Token_Pos101 :
            Token_Index
               := No_Token_Index;
      Token_Res101 :
            Token_Index
               := No_Token_Index;
      Defer_Pos102 :
            Token_Index
               := No_Token_Index;
      Defer_Res102 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos102 :
            Token_Index
               := No_Token_Index;
      Token_Res102 :
            Token_Index
               := No_Token_Index;
      Transform_Res68 :
            Bare_Attribute_Statement
               := No_Bare_R_F_L_X_Node;
      Transform_Diags68 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.List_Attribute_Transform_Parse4_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res68 := M.Instance;
      return Transform_Res68;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res68;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags68 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos70 := Pos;



Defer_Res101 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos70);
Defer_Pos101 := Parser.Current_Pos;




if Defer_Pos101 /= No_Token_Index then

   Row_Pos70 := Defer_Pos101;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;


--  Start tok_code

Token_Res96 := Row_Pos70;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res96));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Tick)
   then
       Token_Pos96 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos70 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos70,
             Expected_Token_Id => Rflx_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos96 := Row_Pos70 + 1;
   end if;
end;

--  End tok_code




if Token_Pos96 /= No_Token_Index then

   Row_Pos70 := Token_Pos96;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;


--  Start or_code

Or_Pos31 := No_Token_Index;
Or_Res31 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags64 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos71 := Row_Pos70;



--  Start tok_code

Token_Res97 := Row_Pos71;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res97));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Append)
   then
       Token_Pos97 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos71 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos71,
             Expected_Token_Id => Rflx_Append,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos97 := Row_Pos71 + 1;
   end if;
end;

--  End tok_code




if Token_Pos97 /= No_Token_Index then

   Row_Pos71 := Token_Pos97;

else
   Row_Pos71 := No_Token_Index;
   goto Exit_Row71_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row71_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos71 /= No_Token_Index then

   Transform_Res64 := Allocate_Attr_Stmt_Append (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res64,
      Kind => Rflx_Attr_Stmt_Append,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos70,
      Token_End_Index   => (if Row_Pos71 = Row_Pos70
                            then No_Token_Index
                            else Row_Pos71 - 1));




elsif Row_Pos71 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags64);
end if;

--  End transform_code

    if Row_Pos71 /= No_Token_Index then
        Or_Pos31 := Row_Pos71;
        Or_Res31 := Transform_Res64;
        goto Exit_Or31;
    end if;
    
--  Start transform_code

Transform_Diags65 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos72 := Row_Pos70;



--  Start tok_code

Token_Res98 := Row_Pos72;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res98));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Extend)
   then
       Token_Pos98 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos72 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos72,
             Expected_Token_Id => Rflx_Extend,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos98 := Row_Pos72 + 1;
   end if;
end;

--  End tok_code




if Token_Pos98 /= No_Token_Index then

   Row_Pos72 := Token_Pos98;

else
   Row_Pos72 := No_Token_Index;
   goto Exit_Row72_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row72_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos72 /= No_Token_Index then

   Transform_Res65 := Allocate_Attr_Stmt_Extend (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res65,
      Kind => Rflx_Attr_Stmt_Extend,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos70,
      Token_End_Index   => (if Row_Pos72 = Row_Pos70
                            then No_Token_Index
                            else Row_Pos72 - 1));




elsif Row_Pos72 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags65);
end if;

--  End transform_code

    if Row_Pos72 /= No_Token_Index then
        Or_Pos31 := Row_Pos72;
        Or_Res31 := Transform_Res65;
        goto Exit_Or31;
    end if;
    
--  Start transform_code

Transform_Diags66 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos73 := Row_Pos70;



--  Start tok_code

Token_Res99 := Row_Pos73;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res99));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Read)
   then
       Token_Pos99 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos73 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos73,
             Expected_Token_Id => Rflx_Read,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos99 := Row_Pos73 + 1;
   end if;
end;

--  End tok_code




if Token_Pos99 /= No_Token_Index then

   Row_Pos73 := Token_Pos99;

else
   Row_Pos73 := No_Token_Index;
   goto Exit_Row73_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row73_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos73 /= No_Token_Index then

   Transform_Res66 := Allocate_Attr_Stmt_Read (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res66,
      Kind => Rflx_Attr_Stmt_Read,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos70,
      Token_End_Index   => (if Row_Pos73 = Row_Pos70
                            then No_Token_Index
                            else Row_Pos73 - 1));




elsif Row_Pos73 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags66);
end if;

--  End transform_code

    if Row_Pos73 /= No_Token_Index then
        Or_Pos31 := Row_Pos73;
        Or_Res31 := Transform_Res66;
        goto Exit_Or31;
    end if;
    
--  Start transform_code

Transform_Diags67 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos74 := Row_Pos70;



--  Start tok_code

Token_Res100 := Row_Pos74;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res100));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Write)
   then
       Token_Pos100 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos74 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos74,
             Expected_Token_Id => Rflx_Write,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos100 := Row_Pos74 + 1;
   end if;
end;

--  End tok_code




if Token_Pos100 /= No_Token_Index then

   Row_Pos74 := Token_Pos100;

else
   Row_Pos74 := No_Token_Index;
   goto Exit_Row74_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row74_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos74 /= No_Token_Index then

   Transform_Res67 := Allocate_Attr_Stmt_Write (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res67,
      Kind => Rflx_Attr_Stmt_Write,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos70,
      Token_End_Index   => (if Row_Pos74 = Row_Pos70
                            then No_Token_Index
                            else Row_Pos74 - 1));




elsif Row_Pos74 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags67);
end if;

--  End transform_code

    if Row_Pos74 /= No_Token_Index then
        Or_Pos31 := Row_Pos74;
        Or_Res31 := Transform_Res67;
        goto Exit_Or31;
    end if;
<<Exit_Or31>>

--  End or_code




if Or_Pos31 /= No_Token_Index then

   Row_Pos70 := Or_Pos31;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;


--  Start tok_code

Token_Res101 := Row_Pos70;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res101));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos101 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos70 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos70,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos101 := Row_Pos70 + 1;
   end if;
end;

--  End tok_code




if Token_Pos101 /= No_Token_Index then

   Row_Pos70 := Token_Pos101;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;


Defer_Res102 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos70);
Defer_Pos102 := Parser.Current_Pos;




if Defer_Pos102 /= No_Token_Index then

   Row_Pos70 := Defer_Pos102;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;


--  Start tok_code

Token_Res102 := Row_Pos70;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res102));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos102 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos70 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos70,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos102 := Row_Pos70 + 1;
   end if;
end;

--  End tok_code




if Token_Pos102 /= No_Token_Index then

   Row_Pos70 := Token_Pos102;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row70_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos70 /= No_Token_Index then

   Transform_Res68 := Allocate_Attribute_Statement (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res68,
      Kind => Rflx_Attribute_Statement,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos70 = Pos
                            then No_Token_Index
                            else Row_Pos70 - 1));

      Initialize_Fields_For_Attribute_Statement
        (Self => Transform_Res68, Attribute_Statement_F_Identifier => Defer_Res101, Attribute_Statement_F_Attr => Or_Res31, Attribute_Statement_F_Expression => Defer_Res102);

         if Defer_Res101 /= null and then Is_Incomplete (Defer_Res101) then
            Transform_Res68.Last_Attempted_Child := 0;
         elsif Defer_Res101 /= null and then not Is_Ghost (Defer_Res101) then
            Transform_Res68.Last_Attempted_Child := -1;
         end if;
         if Or_Res31 /= null and then Is_Incomplete (Or_Res31) then
            Transform_Res68.Last_Attempted_Child := 0;
         elsif Or_Res31 /= null and then not Is_Ghost (Or_Res31) then
            Transform_Res68.Last_Attempted_Child := -1;
         end if;
         if Defer_Res102 /= null and then Is_Incomplete (Defer_Res102) then
            Transform_Res68.Last_Attempted_Child := 0;
         elsif Defer_Res102 /= null and then not Is_Ghost (Defer_Res102) then
            Transform_Res68.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos70 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags68);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.List_Attribute_Transform_Parse4_Memo,
      Row_Pos70 /= No_Token_Index,
      Transform_Res68,
      Pos,
      Row_Pos70);


   Parser.Current_Pos := Row_Pos70;

   return Transform_Res68;
end List_Attribute_Transform_Parse4;

   


function Main_Rule_Defer_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Specification
is
   use Bare_Specification_Memos;

      Defer_Pos103 :
            Token_Index
               := No_Token_Index;
      Defer_Res103 :
            Bare_Specification
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Specification := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Main_Rule_Defer_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Defer_Res103 := M.Instance;
      return Defer_Res103;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Defer_Res103;
   end if;

       Set (Parser.Private_Part.Main_Rule_Defer_Parse0_Memo, False, Defer_Res103, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
Defer_Res103 :=
   Specification_Transform_Parse0 (Parser, Pos);
Defer_Pos103 := Parser.Current_Pos;


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Defer_Pos103 > Mem_Pos then
         Mem_Pos := Defer_Pos103;
         Mem_Res := Defer_Res103;
         Set
           (Parser.Private_Part.Main_Rule_Defer_Parse0_Memo,
            Defer_Pos103 /= No_Token_Index,
            Defer_Res103,
            Pos,
            Defer_Pos103);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Defer_Res103 := Mem_Res;
         Defer_Pos103 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Main_Rule_Defer_Parse0_Memo,
      Defer_Pos103 /= No_Token_Index,
      Defer_Res103,
      Pos,
      Defer_Pos103);

       <<No_Memo>>

   Parser.Current_Pos := Defer_Pos103;

   return Defer_Res103;
end Main_Rule_Defer_Parse0;

   


function Message_Aggregate_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aggregate
is
   use Bare_Message_Aggregate_Memos;

      Row_Pos75 :
            Token_Index
               := No_Token_Index;
      Defer_Pos104 :
            Token_Index
               := No_Token_Index;
      Defer_Res104 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos103 :
            Token_Index
               := No_Token_Index;
      Token_Res103 :
            Token_Index
               := No_Token_Index;
      Token_Pos104 :
            Token_Index
               := No_Token_Index;
      Token_Res104 :
            Token_Index
               := No_Token_Index;
      Defer_Pos105 :
            Token_Index
               := No_Token_Index;
      Defer_Res105 :
            Bare_Null_Message_Aggregate
               := No_Bare_R_F_L_X_Node;
      Defer_Pos106 :
            Token_Index
               := No_Token_Index;
      Defer_Res106 :
            Bare_Message_Aggregate_Associations
               := No_Bare_R_F_L_X_Node;
      Or_Pos32 :
            Token_Index
               := No_Token_Index;
      Or_Res32 :
            Bare_Base_Aggregate
               := No_Bare_R_F_L_X_Node;
      Token_Pos105 :
            Token_Index
               := No_Token_Index;
      Token_Res105 :
            Token_Index
               := No_Token_Index;
      Transform_Res69 :
            Bare_Message_Aggregate
               := No_Bare_R_F_L_X_Node;
      Transform_Diags69 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Aggregate_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res69 := M.Instance;
      return Transform_Res69;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res69;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags69 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos75 := Pos;



Defer_Res104 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Row_Pos75);
Defer_Pos104 := Parser.Current_Pos;




if Defer_Pos104 /= No_Token_Index then

   Row_Pos75 := Defer_Pos104;

else
   Row_Pos75 := No_Token_Index;
   goto Exit_Row75_0;

end if;


--  Start tok_code

Token_Res103 := Row_Pos75;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res103));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Tick)
   then
       Token_Pos103 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos75 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos75,
             Expected_Token_Id => Rflx_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos103 := Row_Pos75 + 1;
   end if;
end;

--  End tok_code




if Token_Pos103 /= No_Token_Index then

   Row_Pos75 := Token_Pos103;

else
   Row_Pos75 := No_Token_Index;
   goto Exit_Row75_0;

end if;


--  Start tok_code

Token_Res104 := Row_Pos75;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res104));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos104 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos75 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos75,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos104 := Row_Pos75 + 1;
   end if;
end;

--  End tok_code




if Token_Pos104 /= No_Token_Index then

   Row_Pos75 := Token_Pos104;

else
   Row_Pos75 := No_Token_Index;
   goto Exit_Row75_0;

end if;


--  Start or_code

Or_Pos32 := No_Token_Index;
Or_Res32 := No_Bare_R_F_L_X_Node;
    
Defer_Res105 :=
   Null_Message_Aggregate_Transform_Parse0 (Parser, Row_Pos75);
Defer_Pos105 := Parser.Current_Pos;

    if Defer_Pos105 /= No_Token_Index then
        Or_Pos32 := Defer_Pos105;
        Or_Res32 := Defer_Res105;
        goto Exit_Or32;
    end if;
    
Defer_Res106 :=
   Message_Aggregate_Association_List_Transform_Parse0 (Parser, Row_Pos75);
Defer_Pos106 := Parser.Current_Pos;

    if Defer_Pos106 /= No_Token_Index then
        Or_Pos32 := Defer_Pos106;
        Or_Res32 := Defer_Res106;
        goto Exit_Or32;
    end if;
<<Exit_Or32>>

--  End or_code




if Or_Pos32 /= No_Token_Index then

   Row_Pos75 := Or_Pos32;

else
   Row_Pos75 := No_Token_Index;
   goto Exit_Row75_0;

end if;


--  Start tok_code

Token_Res105 := Row_Pos75;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res105));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos105 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos75 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos75,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos105 := Row_Pos75 + 1;
   end if;
end;

--  End tok_code




if Token_Pos105 /= No_Token_Index then

   Row_Pos75 := Token_Pos105;

else
   Row_Pos75 := No_Token_Index;
   goto Exit_Row75_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row75_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos75 /= No_Token_Index then

   Transform_Res69 := Allocate_Message_Aggregate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res69,
      Kind => Rflx_Message_Aggregate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos75 = Pos
                            then No_Token_Index
                            else Row_Pos75 - 1));

      Initialize_Fields_For_Message_Aggregate
        (Self => Transform_Res69, Message_Aggregate_F_Identifier => Defer_Res104, Message_Aggregate_F_Values => Or_Res32);

         if Defer_Res104 /= null and then Is_Incomplete (Defer_Res104) then
            Transform_Res69.Last_Attempted_Child := 0;
         elsif Defer_Res104 /= null and then not Is_Ghost (Defer_Res104) then
            Transform_Res69.Last_Attempted_Child := -1;
         end if;
         if Or_Res32 /= null and then Is_Incomplete (Or_Res32) then
            Transform_Res69.Last_Attempted_Child := 0;
         elsif Or_Res32 /= null and then not Is_Ghost (Or_Res32) then
            Transform_Res69.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos75 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags69);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Aggregate_Transform_Parse0_Memo,
      Row_Pos75 /= No_Token_Index,
      Transform_Res69,
      Pos,
      Row_Pos75);


   Parser.Current_Pos := Row_Pos75;

   return Transform_Res69;
end Message_Aggregate_Transform_Parse0;

   


function Message_Aggregate_Association_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aggregate_Association
is
   use Bare_Message_Aggregate_Association_Memos;

      Row_Pos76 :
            Token_Index
               := No_Token_Index;
      Defer_Pos107 :
            Token_Index
               := No_Token_Index;
      Defer_Res107 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos106 :
            Token_Index
               := No_Token_Index;
      Token_Res106 :
            Token_Index
               := No_Token_Index;
      Defer_Pos108 :
            Token_Index
               := No_Token_Index;
      Defer_Res108 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res70 :
            Bare_Message_Aggregate_Association
               := No_Bare_R_F_L_X_Node;
      Transform_Diags70 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Aggregate_Association_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res70 := M.Instance;
      return Transform_Res70;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res70;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags70 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos76 := Pos;



Defer_Res107 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos76);
Defer_Pos107 := Parser.Current_Pos;




if Defer_Pos107 /= No_Token_Index then

   Row_Pos76 := Defer_Pos107;

else
   Row_Pos76 := No_Token_Index;
   goto Exit_Row76_0;

end if;


--  Start tok_code

Token_Res106 := Row_Pos76;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res106));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Arrow)
   then
       Token_Pos106 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos76 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos76,
             Expected_Token_Id => Rflx_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos106 := Row_Pos76 + 1;
   end if;
end;

--  End tok_code




if Token_Pos106 /= No_Token_Index then

   Row_Pos76 := Token_Pos106;

else
   Row_Pos76 := No_Token_Index;
   goto Exit_Row76_0;

end if;


Defer_Res108 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos76);
Defer_Pos108 := Parser.Current_Pos;




if Defer_Pos108 /= No_Token_Index then

   Row_Pos76 := Defer_Pos108;

else
   Row_Pos76 := No_Token_Index;
   goto Exit_Row76_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row76_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos76 /= No_Token_Index then

   Transform_Res70 := Allocate_Message_Aggregate_Association (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res70,
      Kind => Rflx_Message_Aggregate_Association,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos76 = Pos
                            then No_Token_Index
                            else Row_Pos76 - 1));

      Initialize_Fields_For_Message_Aggregate_Association
        (Self => Transform_Res70, Message_Aggregate_Association_F_Identifier => Defer_Res107, Message_Aggregate_Association_F_Expression => Defer_Res108);

         if Defer_Res107 /= null and then Is_Incomplete (Defer_Res107) then
            Transform_Res70.Last_Attempted_Child := 0;
         elsif Defer_Res107 /= null and then not Is_Ghost (Defer_Res107) then
            Transform_Res70.Last_Attempted_Child := -1;
         end if;
         if Defer_Res108 /= null and then Is_Incomplete (Defer_Res108) then
            Transform_Res70.Last_Attempted_Child := 0;
         elsif Defer_Res108 /= null and then not Is_Ghost (Defer_Res108) then
            Transform_Res70.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos76 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags70);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Aggregate_Association_Transform_Parse0_Memo,
      Row_Pos76 /= No_Token_Index,
      Transform_Res70,
      Pos,
      Row_Pos76);


   Parser.Current_Pos := Row_Pos76;

   return Transform_Res70;
end Message_Aggregate_Association_Transform_Parse0;

   


function Message_Aggregate_Association_List_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aggregate_Associations
is
   use Bare_Message_Aggregate_Associations_Memos;

      Row_Pos77 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos10 :
            Token_Index
               := No_Token_Index;
      Tmp_List10 :
            Free_Parse_List;
      Defer_Pos109 :
            Token_Index
               := No_Token_Index;
      Defer_Res109 :
            Bare_Message_Aggregate_Association
               := No_Bare_R_F_L_X_Node;
      Token_Pos107 :
            Token_Index
               := No_Token_Index;
      Token_Res107 :
            Token_Index
               := No_Token_Index;
      List_Pos10 :
            Token_Index
               := No_Token_Index;
      List_Res10 :
            Bare_Message_Aggregate_Association_List
               := No_Bare_R_F_L_X_Node;
      Transform_Res71 :
            Bare_Message_Aggregate_Associations
               := No_Bare_R_F_L_X_Node;
      Transform_Diags71 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Aggregate_Association_List_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res71 := M.Instance;
      return Transform_Res71;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res71;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags71 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos77 := Pos;



--  Start list_code

    List_Pos10 := No_Token_Index;



Lst_Cpos10 := Row_Pos77;
Tmp_List10 := Get_Parse_List (Parser);

loop
   
Defer_Res109 :=
   Message_Aggregate_Association_Transform_Parse0 (Parser, Lst_Cpos10);
Defer_Pos109 := Parser.Current_Pos;


   exit when Defer_Pos109 = No_Token_Index;

   List_Pos10 := Defer_Pos109;
   Lst_Cpos10 := List_Pos10;

   Tmp_List10.Nodes.Append (Defer_Res109);

      
--  Start tok_code

Token_Res107 := Lst_Cpos10;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res107));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos107 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos10 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos10,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos107 := Lst_Cpos10 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos107 /= No_Token_Index then
          Lst_Cpos10 := Token_Pos107;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List10.Nodes.Length;
begin
   List_Res10 :=
      Allocate_Message_Aggregate_Association_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos77;
      Token_End := (if Lst_Cpos10 = Row_Pos77
                    then Row_Pos77
                    else Lst_Cpos10 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos77, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res10,
      Kind              => Rflx_Message_Aggregate_Association_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res10,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List10.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res10.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List10);

--  End list_code




if List_Pos10 /= No_Token_Index then

   Row_Pos77 := List_Pos10;

else
   Row_Pos77 := No_Token_Index;
   goto Exit_Row77_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row77_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos77 /= No_Token_Index then

   Transform_Res71 := Allocate_Message_Aggregate_Associations (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res71,
      Kind => Rflx_Message_Aggregate_Associations,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos77 = Pos
                            then No_Token_Index
                            else Row_Pos77 - 1));

      Initialize_Fields_For_Message_Aggregate_Associations
        (Self => Transform_Res71, Message_Aggregate_Associations_F_Associations => List_Res10);

         if List_Res10 /= null and then Is_Incomplete (List_Res10) then
            Transform_Res71.Last_Attempted_Child := 0;
         elsif List_Res10 /= null and then not Is_Ghost (List_Res10) then
            Transform_Res71.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos77 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags71);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Aggregate_Association_List_Transform_Parse0_Memo,
      Row_Pos77 /= No_Token_Index,
      Transform_Res71,
      Pos,
      Row_Pos77);


   Parser.Current_Pos := Row_Pos77;

   return Transform_Res71;
end Message_Aggregate_Association_List_Transform_Parse0;

   


function Message_Aspect_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aspect_List
is
   use Bare_Message_Aspect_List_Memos;

      Lst_Cpos11 :
            Token_Index
               := No_Token_Index;
      Tmp_List11 :
            Free_Parse_List;
      Defer_Pos110 :
            Token_Index
               := No_Token_Index;
      Defer_Res110 :
            Bare_Checksum_Aspect
               := No_Bare_R_F_L_X_Node;
      Defer_Pos111 :
            Token_Index
               := No_Token_Index;
      Defer_Res111 :
            Bare_Byte_Order_Aspect
               := No_Bare_R_F_L_X_Node;
      Or_Pos33 :
            Token_Index
               := No_Token_Index;
      Or_Res33 :
            Bare_Message_Aspect
               := No_Bare_R_F_L_X_Node;
      Token_Pos108 :
            Token_Index
               := No_Token_Index;
      Token_Res108 :
            Token_Index
               := No_Token_Index;
      List_Pos11 :
            Token_Index
               := No_Token_Index;
      List_Res11 :
            Bare_Message_Aspect_List
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Aspect_List_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res11 := M.Instance;
      return List_Res11;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res11;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos11 := No_Token_Index;



Lst_Cpos11 := Pos;
Tmp_List11 := Get_Parse_List (Parser);

loop
   
--  Start or_code

Or_Pos33 := No_Token_Index;
Or_Res33 := No_Bare_R_F_L_X_Node;
    
Defer_Res110 :=
   Checksum_Aspect_Transform_Parse0 (Parser, Lst_Cpos11);
Defer_Pos110 := Parser.Current_Pos;

    if Defer_Pos110 /= No_Token_Index then
        Or_Pos33 := Defer_Pos110;
        Or_Res33 := Defer_Res110;
        goto Exit_Or33;
    end if;
    
Defer_Res111 :=
   Byte_Order_Aspect_Transform_Parse2 (Parser, Lst_Cpos11);
Defer_Pos111 := Parser.Current_Pos;

    if Defer_Pos111 /= No_Token_Index then
        Or_Pos33 := Defer_Pos111;
        Or_Res33 := Defer_Res111;
        goto Exit_Or33;
    end if;
<<Exit_Or33>>

--  End or_code


   exit when Or_Pos33 = No_Token_Index;

   List_Pos11 := Or_Pos33;
   Lst_Cpos11 := List_Pos11;

   Tmp_List11.Nodes.Append (Or_Res33);

      
--  Start tok_code

Token_Res108 := Lst_Cpos11;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res108));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos108 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos11 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos11,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos108 := Lst_Cpos11 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos108 /= No_Token_Index then
          Lst_Cpos11 := Token_Pos108;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List11.Nodes.Length;
begin
   List_Res11 :=
      Allocate_Message_Aspect_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos11 = Pos
                    then Pos
                    else Lst_Cpos11 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res11,
      Kind              => Rflx_Message_Aspect_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res11,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List11.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res11.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List11);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Aspect_List_List_Parse0_Memo,
      List_Pos11 /= No_Token_Index,
      List_Res11,
      Pos,
      List_Pos11);


   Parser.Current_Pos := List_Pos11;

   return List_Res11;
end Message_Aspect_List_List_Parse0;

   


function Message_Field_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Field
is
   use Bare_Message_Field_Memos;

      Row_Pos78 :
            Token_Index
               := No_Token_Index;
      Defer_Pos112 :
            Token_Index
               := No_Token_Index;
      Defer_Res112 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos109 :
            Token_Index
               := No_Token_Index;
      Token_Res109 :
            Token_Index
               := No_Token_Index;
      Defer_Pos113 :
            Token_Index
               := No_Token_Index;
      Defer_Res113 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Row_Pos79 :
            Token_Index
               := No_Token_Index;
      Token_Pos110 :
            Token_Index
               := No_Token_Index;
      Token_Res110 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos12 :
            Token_Index
               := No_Token_Index;
      Tmp_List12 :
            Free_Parse_List;
      Defer_Pos114 :
            Token_Index
               := No_Token_Index;
      Defer_Res114 :
            Bare_Type_Argument
               := No_Bare_R_F_L_X_Node;
      Token_Pos111 :
            Token_Index
               := No_Token_Index;
      Token_Res111 :
            Token_Index
               := No_Token_Index;
      List_Pos12 :
            Token_Index
               := No_Token_Index;
      List_Res12 :
            Bare_Type_Argument_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos112 :
            Token_Index
               := No_Token_Index;
      Token_Res112 :
            Token_Index
               := No_Token_Index;
      Row_Pos80 :
            Token_Index
               := No_Token_Index;
      Token_Pos113 :
            Token_Index
               := No_Token_Index;
      Token_Res113 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos13 :
            Token_Index
               := No_Token_Index;
      Tmp_List13 :
            Free_Parse_List;
      Defer_Pos115 :
            Token_Index
               := No_Token_Index;
      Defer_Res115 :
            Bare_Aspect
               := No_Bare_R_F_L_X_Node;
      Token_Pos114 :
            Token_Index
               := No_Token_Index;
      Token_Res114 :
            Token_Index
               := No_Token_Index;
      List_Pos13 :
            Token_Index
               := No_Token_Index;
      List_Res13 :
            Bare_Aspect_List
               := No_Bare_R_F_L_X_Node;
      Defer_Pos116 :
            Token_Index
               := No_Token_Index;
      Defer_Res116 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Lst_Cpos14 :
            Token_Index
               := No_Token_Index;
      Tmp_List14 :
            Free_Parse_List;
      Defer_Pos117 :
            Token_Index
               := No_Token_Index;
      Defer_Res117 :
            Bare_Then_Node
               := No_Bare_R_F_L_X_Node;
      List_Pos14 :
            Token_Index
               := No_Token_Index;
      List_Res14 :
            Bare_Then_Node_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos115 :
            Token_Index
               := No_Token_Index;
      Token_Res115 :
            Token_Index
               := No_Token_Index;
      Transform_Res72 :
            Bare_Message_Field
               := No_Bare_R_F_L_X_Node;
      Transform_Diags72 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Field_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res72 := M.Instance;
      return Transform_Res72;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res72;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags72 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos78 := Pos;



Defer_Res112 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos78);
Defer_Pos112 := Parser.Current_Pos;




if Defer_Pos112 /= No_Token_Index then

   Row_Pos78 := Defer_Pos112;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


--  Start tok_code

Token_Res109 := Row_Pos78;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res109));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Colon)
   then
       Token_Pos109 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos78 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos78,
             Expected_Token_Id => Rflx_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos109 := Row_Pos78 + 1;
   end if;
end;

--  End tok_code




if Token_Pos109 /= No_Token_Index then

   Row_Pos78 := Token_Pos109;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


Defer_Res113 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Row_Pos78);
Defer_Pos113 := Parser.Current_Pos;




if Defer_Pos113 /= No_Token_Index then

   Row_Pos78 := Defer_Pos113;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos79 := Row_Pos78;



--  Start tok_code

Token_Res110 := Row_Pos79;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res110));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos110 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos79 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos79,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos110 := Row_Pos79 + 1;
   end if;
end;

--  End tok_code




if Token_Pos110 /= No_Token_Index then

   Row_Pos79 := Token_Pos110;

else
   Row_Pos79 := No_Token_Index;
   goto Exit_Row79_0;

end if;


--  Start list_code

    List_Pos12 := No_Token_Index;



Lst_Cpos12 := Row_Pos79;
Tmp_List12 := Get_Parse_List (Parser);

loop
   
Defer_Res114 :=
   Type_Argument_Transform_Parse0 (Parser, Lst_Cpos12);
Defer_Pos114 := Parser.Current_Pos;


   exit when Defer_Pos114 = No_Token_Index;

   List_Pos12 := Defer_Pos114;
   Lst_Cpos12 := List_Pos12;

   Tmp_List12.Nodes.Append (Defer_Res114);

      
--  Start tok_code

Token_Res111 := Lst_Cpos12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res111));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos111 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos12,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos111 := Lst_Cpos12 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos111 /= No_Token_Index then
          Lst_Cpos12 := Token_Pos111;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List12.Nodes.Length;
begin
   List_Res12 :=
      Allocate_Type_Argument_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos79;
      Token_End := (if Lst_Cpos12 = Row_Pos79
                    then Row_Pos79
                    else Lst_Cpos12 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos79, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res12,
      Kind              => Rflx_Type_Argument_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res12,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List12.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res12.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List12);

--  End list_code




if List_Pos12 /= No_Token_Index then

   Row_Pos79 := List_Pos12;

else
   Row_Pos79 := No_Token_Index;
   goto Exit_Row79_0;

end if;


--  Start tok_code

Token_Res112 := Row_Pos79;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res112));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos112 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos79 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos79,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos112 := Row_Pos79 + 1;
   end if;
end;

--  End tok_code




if Token_Pos112 /= No_Token_Index then

   Row_Pos79 := Token_Pos112;

else
   Row_Pos79 := No_Token_Index;
   goto Exit_Row79_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row79_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos79 = No_Token_Index then

         
   List_Res12 :=
     Allocate_Type_Argument_List (Parser.Mem_Pool);
   Initialize
     (Self              => List_Res12,
      Kind              => Rflx_Type_Argument_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos78 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => List_Res12,
      Parser => Parser,
      Count  => 0);



       
   Row_Pos79 := Row_Pos78;



end if;

--  End opt_code




if Row_Pos79 /= No_Token_Index then

   Row_Pos78 := Row_Pos79;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos80 := Row_Pos78;



--  Start tok_code

Token_Res113 := Row_Pos80;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res113));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_With)
   then
       Token_Pos113 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos80 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos80,
             Expected_Token_Id => Rflx_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos113 := Row_Pos80 + 1;
   end if;
end;

--  End tok_code




if Token_Pos113 /= No_Token_Index then

   Row_Pos80 := Token_Pos113;

else
   Row_Pos80 := No_Token_Index;
   goto Exit_Row80_0;

end if;


--  Start list_code

    List_Pos13 := No_Token_Index;



Lst_Cpos13 := Row_Pos80;
Tmp_List13 := Get_Parse_List (Parser);

loop
   
Defer_Res115 :=
   Aspect_Transform_Parse0 (Parser, Lst_Cpos13);
Defer_Pos115 := Parser.Current_Pos;


   exit when Defer_Pos115 = No_Token_Index;

   List_Pos13 := Defer_Pos115;
   Lst_Cpos13 := List_Pos13;

   Tmp_List13.Nodes.Append (Defer_Res115);

      
--  Start tok_code

Token_Res114 := Lst_Cpos13;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res114));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos114 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos13 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos13,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos114 := Lst_Cpos13 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos114 /= No_Token_Index then
          Lst_Cpos13 := Token_Pos114;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List13.Nodes.Length;
begin
   List_Res13 :=
      Allocate_Aspect_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos80;
      Token_End := (if Lst_Cpos13 = Row_Pos80
                    then Row_Pos80
                    else Lst_Cpos13 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos80, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res13,
      Kind              => Rflx_Aspect_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res13,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List13.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res13.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List13);

--  End list_code




if List_Pos13 /= No_Token_Index then

   Row_Pos80 := List_Pos13;

else
   Row_Pos80 := No_Token_Index;
   goto Exit_Row80_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row80_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos80 = No_Token_Index then

         
   List_Res13 :=
     Allocate_Aspect_List (Parser.Mem_Pool);
   Initialize
     (Self              => List_Res13,
      Kind              => Rflx_Aspect_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos78 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => List_Res13,
      Parser => Parser,
      Count  => 0);



       
   Row_Pos80 := Row_Pos78;



end if;

--  End opt_code




if Row_Pos80 /= No_Token_Index then

   Row_Pos78 := Row_Pos80;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


--  Start opt_code












Defer_Res116 :=
   If_Condition_Extract_Parse0 (Parser, Row_Pos78);
Defer_Pos116 := Parser.Current_Pos;


if Defer_Pos116 = No_Token_Index then

         
   Defer_Res116 := No_Bare_R_F_L_X_Node;



       
   Defer_Pos116 := Row_Pos78;



end if;

--  End opt_code




if Defer_Pos116 /= No_Token_Index then

   Row_Pos78 := Defer_Pos116;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


--  Start list_code

    List_Pos14 := Row_Pos78;



Lst_Cpos14 := Row_Pos78;
Tmp_List14 := Get_Parse_List (Parser);

loop
   
Defer_Res117 :=
   Then_Transform_Parse0 (Parser, Lst_Cpos14);
Defer_Pos117 := Parser.Current_Pos;


   exit when Defer_Pos117 = No_Token_Index;

   List_Pos14 := Defer_Pos117;
   Lst_Cpos14 := List_Pos14;

   Tmp_List14.Nodes.Append (Defer_Res117);


end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List14.Nodes.Length;
begin
   List_Res14 :=
      Allocate_Then_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos78;
      Token_End := (if Lst_Cpos14 = Row_Pos78
                    then Row_Pos78
                    else Lst_Cpos14 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos78, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res14,
      Kind              => Rflx_Then_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res14,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List14.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res14.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List14);

--  End list_code




if List_Pos14 /= No_Token_Index then

   Row_Pos78 := List_Pos14;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


--  Start tok_code

Token_Res115 := Row_Pos78;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res115));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos115 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos78 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos78,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos115 := Row_Pos78 + 1;
   end if;
end;

--  End tok_code




if Token_Pos115 /= No_Token_Index then

   Row_Pos78 := Token_Pos115;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row78_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos78 /= No_Token_Index then

   Transform_Res72 := Allocate_Message_Field (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res72,
      Kind => Rflx_Message_Field,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos78 = Pos
                            then No_Token_Index
                            else Row_Pos78 - 1));

      Initialize_Fields_For_Message_Field
        (Self => Transform_Res72, Message_Field_F_Identifier => Defer_Res112, Message_Field_F_Type_Identifier => Defer_Res113, Message_Field_F_Type_Arguments => List_Res12, Message_Field_F_Aspects => List_Res13, Message_Field_F_Condition => Defer_Res116, Message_Field_F_Thens => List_Res14);

         if Defer_Res112 /= null and then Is_Incomplete (Defer_Res112) then
            Transform_Res72.Last_Attempted_Child := 0;
         elsif Defer_Res112 /= null and then not Is_Ghost (Defer_Res112) then
            Transform_Res72.Last_Attempted_Child := -1;
         end if;
         if Defer_Res113 /= null and then Is_Incomplete (Defer_Res113) then
            Transform_Res72.Last_Attempted_Child := 0;
         elsif Defer_Res113 /= null and then not Is_Ghost (Defer_Res113) then
            Transform_Res72.Last_Attempted_Child := -1;
         end if;
         if List_Res12 /= null and then Is_Incomplete (List_Res12) then
            Transform_Res72.Last_Attempted_Child := 0;
         elsif List_Res12 /= null and then not Is_Ghost (List_Res12) then
            Transform_Res72.Last_Attempted_Child := -1;
         end if;
         if List_Res13 /= null and then Is_Incomplete (List_Res13) then
            Transform_Res72.Last_Attempted_Child := 0;
         elsif List_Res13 /= null and then not Is_Ghost (List_Res13) then
            Transform_Res72.Last_Attempted_Child := -1;
         end if;
         if Defer_Res116 /= null and then Is_Incomplete (Defer_Res116) then
            Transform_Res72.Last_Attempted_Child := 0;
         elsif Defer_Res116 /= null and then not Is_Ghost (Defer_Res116) then
            Transform_Res72.Last_Attempted_Child := -1;
         end if;
         if List_Res14 /= null and then Is_Incomplete (List_Res14) then
            Transform_Res72.Last_Attempted_Child := 0;
         elsif List_Res14 /= null and then not Is_Ghost (List_Res14) then
            Transform_Res72.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos78 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags72);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Field_Transform_Parse0_Memo,
      Row_Pos78 /= No_Token_Index,
      Transform_Res72,
      Pos,
      Row_Pos78);


   Parser.Current_Pos := Row_Pos78;

   return Transform_Res72;
end Message_Field_Transform_Parse0;

   


function Message_Field_Assignment_Statement_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Field_Assignment
is
   use Bare_Message_Field_Assignment_Memos;

      Row_Pos81 :
            Token_Index
               := No_Token_Index;
      Defer_Pos118 :
            Token_Index
               := No_Token_Index;
      Defer_Res118 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos116 :
            Token_Index
               := No_Token_Index;
      Token_Res116 :
            Token_Index
               := No_Token_Index;
      Defer_Pos119 :
            Token_Index
               := No_Token_Index;
      Defer_Res119 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos117 :
            Token_Index
               := No_Token_Index;
      Token_Res117 :
            Token_Index
               := No_Token_Index;
      Defer_Pos120 :
            Token_Index
               := No_Token_Index;
      Defer_Res120 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res73 :
            Bare_Message_Field_Assignment
               := No_Bare_R_F_L_X_Node;
      Transform_Diags73 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Field_Assignment_Statement_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res73 := M.Instance;
      return Transform_Res73;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res73;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags73 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos81 := Pos;



Defer_Res118 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos81);
Defer_Pos118 := Parser.Current_Pos;




if Defer_Pos118 /= No_Token_Index then

   Row_Pos81 := Defer_Pos118;

else
   Row_Pos81 := No_Token_Index;
   goto Exit_Row81_0;

end if;


--  Start tok_code

Token_Res116 := Row_Pos81;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res116));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Dot)
   then
       Token_Pos116 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos81 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos81,
             Expected_Token_Id => Rflx_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos116 := Row_Pos81 + 1;
   end if;
end;

--  End tok_code




if Token_Pos116 /= No_Token_Index then

   Row_Pos81 := Token_Pos116;

else
   Row_Pos81 := No_Token_Index;
   goto Exit_Row81_0;

end if;


Defer_Res119 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos81);
Defer_Pos119 := Parser.Current_Pos;




if Defer_Pos119 /= No_Token_Index then

   Row_Pos81 := Defer_Pos119;

else
   Row_Pos81 := No_Token_Index;
   goto Exit_Row81_0;

end if;


--  Start tok_code

Token_Res117 := Row_Pos81;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res117));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Assignment)
   then
       Token_Pos117 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos81 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos81,
             Expected_Token_Id => Rflx_Assignment,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos117 := Row_Pos81 + 1;
   end if;
end;

--  End tok_code




if Token_Pos117 /= No_Token_Index then

   Row_Pos81 := Token_Pos117;

else
   Row_Pos81 := No_Token_Index;
   goto Exit_Row81_0;

end if;


Defer_Res120 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos81);
Defer_Pos120 := Parser.Current_Pos;




if Defer_Pos120 /= No_Token_Index then

   Row_Pos81 := Defer_Pos120;

else
   Row_Pos81 := No_Token_Index;
   goto Exit_Row81_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row81_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos81 /= No_Token_Index then

   Transform_Res73 := Allocate_Message_Field_Assignment (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res73,
      Kind => Rflx_Message_Field_Assignment,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos81 = Pos
                            then No_Token_Index
                            else Row_Pos81 - 1));

      Initialize_Fields_For_Message_Field_Assignment
        (Self => Transform_Res73, Message_Field_Assignment_F_Message => Defer_Res118, Message_Field_Assignment_F_Field => Defer_Res119, Message_Field_Assignment_F_Expression => Defer_Res120);

         if Defer_Res118 /= null and then Is_Incomplete (Defer_Res118) then
            Transform_Res73.Last_Attempted_Child := 0;
         elsif Defer_Res118 /= null and then not Is_Ghost (Defer_Res118) then
            Transform_Res73.Last_Attempted_Child := -1;
         end if;
         if Defer_Res119 /= null and then Is_Incomplete (Defer_Res119) then
            Transform_Res73.Last_Attempted_Child := 0;
         elsif Defer_Res119 /= null and then not Is_Ghost (Defer_Res119) then
            Transform_Res73.Last_Attempted_Child := -1;
         end if;
         if Defer_Res120 /= null and then Is_Incomplete (Defer_Res120) then
            Transform_Res73.Last_Attempted_Child := 0;
         elsif Defer_Res120 /= null and then not Is_Ghost (Defer_Res120) then
            Transform_Res73.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos81 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags73);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Field_Assignment_Statement_Transform_Parse0_Memo,
      Row_Pos81 /= No_Token_Index,
      Transform_Res73,
      Pos,
      Row_Pos81);


   Parser.Current_Pos := Row_Pos81;

   return Transform_Res73;
end Message_Field_Assignment_Statement_Transform_Parse0;

   


function Message_Field_List_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Fields
is
   use Bare_Message_Fields_Memos;

      Row_Pos82 :
            Token_Index
               := No_Token_Index;
      Defer_Pos121 :
            Token_Index
               := No_Token_Index;
      Defer_Res121 :
            Bare_Null_Message_Field
               := No_Bare_R_F_L_X_Node;
      Lst_Cpos15 :
            Token_Index
               := No_Token_Index;
      Tmp_List15 :
            Free_Parse_List;
      Defer_Pos122 :
            Token_Index
               := No_Token_Index;
      Defer_Res122 :
            Bare_Message_Field
               := No_Bare_R_F_L_X_Node;
      List_Pos15 :
            Token_Index
               := No_Token_Index;
      List_Res15 :
            Bare_Message_Field_List
               := No_Bare_R_F_L_X_Node;
      Transform_Res74 :
            Bare_Message_Fields
               := No_Bare_R_F_L_X_Node;
      Transform_Diags74 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Field_List_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res74 := M.Instance;
      return Transform_Res74;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res74;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags74 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos82 := Pos;



--  Start opt_code












Defer_Res121 :=
   Null_Message_Field_Transform_Parse0 (Parser, Row_Pos82);
Defer_Pos121 := Parser.Current_Pos;


if Defer_Pos121 = No_Token_Index then

         
   Defer_Res121 := No_Bare_R_F_L_X_Node;



       
   Defer_Pos121 := Row_Pos82;



end if;

--  End opt_code




if Defer_Pos121 /= No_Token_Index then

   Row_Pos82 := Defer_Pos121;

else
   Row_Pos82 := No_Token_Index;
   goto Exit_Row82_0;

end if;


--  Start list_code

    List_Pos15 := No_Token_Index;



Lst_Cpos15 := Row_Pos82;
Tmp_List15 := Get_Parse_List (Parser);

loop
   
Defer_Res122 :=
   Message_Field_Transform_Parse0 (Parser, Lst_Cpos15);
Defer_Pos122 := Parser.Current_Pos;


   exit when Defer_Pos122 = No_Token_Index;

   List_Pos15 := Defer_Pos122;
   Lst_Cpos15 := List_Pos15;

   Tmp_List15.Nodes.Append (Defer_Res122);


end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List15.Nodes.Length;
begin
   List_Res15 :=
      Allocate_Message_Field_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos82;
      Token_End := (if Lst_Cpos15 = Row_Pos82
                    then Row_Pos82
                    else Lst_Cpos15 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos82, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res15,
      Kind              => Rflx_Message_Field_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res15,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List15.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res15.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List15);

--  End list_code




if List_Pos15 /= No_Token_Index then

   Row_Pos82 := List_Pos15;

else
   Row_Pos82 := No_Token_Index;
   goto Exit_Row82_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row82_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos82 /= No_Token_Index then

   Transform_Res74 := Allocate_Message_Fields (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res74,
      Kind => Rflx_Message_Fields,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos82 = Pos
                            then No_Token_Index
                            else Row_Pos82 - 1));

      Initialize_Fields_For_Message_Fields
        (Self => Transform_Res74, Message_Fields_F_Initial_Field => Defer_Res121, Message_Fields_F_Fields => List_Res15);

         if Defer_Res121 /= null and then Is_Incomplete (Defer_Res121) then
            Transform_Res74.Last_Attempted_Child := 0;
         elsif Defer_Res121 /= null and then not Is_Ghost (Defer_Res121) then
            Transform_Res74.Last_Attempted_Child := -1;
         end if;
         if List_Res15 /= null and then Is_Incomplete (List_Res15) then
            Transform_Res74.Last_Attempted_Child := 0;
         elsif List_Res15 /= null and then not Is_Ghost (List_Res15) then
            Transform_Res74.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos82 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags74);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Field_List_Transform_Parse0_Memo,
      Row_Pos82 /= No_Token_Index,
      Transform_Res74,
      Pos,
      Row_Pos82);


   Parser.Current_Pos := Row_Pos82;

   return Transform_Res74;
end Message_Field_List_Transform_Parse0;

   


function Message_Type_Definition_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Abstract_Message_Type_Def
is
   use Bare_Abstract_Message_Type_Def_Memos;

      Row_Pos83 :
            Token_Index
               := No_Token_Index;
      Token_Pos118 :
            Token_Index
               := No_Token_Index;
      Token_Res118 :
            Token_Index
               := No_Token_Index;
      Defer_Pos123 :
            Token_Index
               := No_Token_Index;
      Defer_Res123 :
            Bare_Message_Fields
               := No_Bare_R_F_L_X_Node;
      Token_Pos119 :
            Token_Index
               := No_Token_Index;
      Token_Res119 :
            Token_Index
               := No_Token_Index;
      Token_Pos120 :
            Token_Index
               := No_Token_Index;
      Token_Res120 :
            Token_Index
               := No_Token_Index;
      Row_Pos84 :
            Token_Index
               := No_Token_Index;
      Token_Pos121 :
            Token_Index
               := No_Token_Index;
      Token_Res121 :
            Token_Index
               := No_Token_Index;
      Defer_Pos124 :
            Token_Index
               := No_Token_Index;
      Defer_Res124 :
            Bare_Message_Aspect_List
               := No_Bare_R_F_L_X_Node;
      Transform_Res75 :
            Bare_Message_Type_Def
               := No_Bare_R_F_L_X_Node;
      Transform_Diags75 :
            Ada.Containers.Count_Type;
      Row_Pos85 :
            Token_Index
               := No_Token_Index;
      Token_Pos122 :
            Token_Index
               := No_Token_Index;
      Token_Res122 :
            Token_Index
               := No_Token_Index;
      Token_Pos123 :
            Token_Index
               := No_Token_Index;
      Token_Res123 :
            Token_Index
               := No_Token_Index;
      Transform_Res76 :
            Bare_Null_Message_Type_Def
               := No_Bare_R_F_L_X_Node;
      Transform_Diags76 :
            Ada.Containers.Count_Type;
      Or_Pos34 :
            Token_Index
               := No_Token_Index;
      Or_Res34 :
            Bare_Abstract_Message_Type_Def
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Type_Definition_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res34 := M.Instance;
      return Or_Res34;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res34;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos34 := No_Token_Index;
Or_Res34 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags75 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos83 := Pos;



--  Start tok_code

Token_Res118 := Row_Pos83;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res118));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Message)
   then
       Token_Pos118 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos83 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos83,
             Expected_Token_Id => Rflx_Message,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos118 := Row_Pos83 + 1;
   end if;
end;

--  End tok_code




if Token_Pos118 /= No_Token_Index then

   Row_Pos83 := Token_Pos118;

else
   Row_Pos83 := No_Token_Index;
   goto Exit_Row83_0;

end if;


Defer_Res123 :=
   Message_Field_List_Transform_Parse0 (Parser, Row_Pos83);
Defer_Pos123 := Parser.Current_Pos;




if Defer_Pos123 /= No_Token_Index then

   Row_Pos83 := Defer_Pos123;

else
   Row_Pos83 := No_Token_Index;
   goto Exit_Row83_0;

end if;


--  Start tok_code

Token_Res119 := Row_Pos83;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res119));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_End)
   then
       Token_Pos119 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos83 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos83,
             Expected_Token_Id => Rflx_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos119 := Row_Pos83 + 1;
   end if;
end;

--  End tok_code




if Token_Pos119 /= No_Token_Index then

   Row_Pos83 := Token_Pos119;

else
   Row_Pos83 := No_Token_Index;
   goto Exit_Row83_0;

end if;


--  Start tok_code

Token_Res120 := Row_Pos83;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res120));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Message)
   then
       Token_Pos120 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos83 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos83,
             Expected_Token_Id => Rflx_Message,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos120 := Row_Pos83 + 1;
   end if;
end;

--  End tok_code




if Token_Pos120 /= No_Token_Index then

   Row_Pos83 := Token_Pos120;

else
   Row_Pos83 := No_Token_Index;
   goto Exit_Row83_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos84 := Row_Pos83;



--  Start tok_code

Token_Res121 := Row_Pos84;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res121));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_With)
   then
       Token_Pos121 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos84 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos84,
             Expected_Token_Id => Rflx_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos121 := Row_Pos84 + 1;
   end if;
end;

--  End tok_code




if Token_Pos121 /= No_Token_Index then

   Row_Pos84 := Token_Pos121;

else
   Row_Pos84 := No_Token_Index;
   goto Exit_Row84_0;

end if;


Defer_Res124 :=
   Message_Aspect_List_List_Parse0 (Parser, Row_Pos84);
Defer_Pos124 := Parser.Current_Pos;




if Defer_Pos124 /= No_Token_Index then

   Row_Pos84 := Defer_Pos124;

else
   Row_Pos84 := No_Token_Index;
   goto Exit_Row84_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row84_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos84 = No_Token_Index then

         
   Defer_Res124 :=
     Allocate_Message_Aspect_List (Parser.Mem_Pool);
   Initialize
     (Self              => Defer_Res124,
      Kind              => Rflx_Message_Aspect_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos83 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => Defer_Res124,
      Parser => Parser,
      Count  => 0);



       
   Row_Pos84 := Row_Pos83;



end if;

--  End opt_code




if Row_Pos84 /= No_Token_Index then

   Row_Pos83 := Row_Pos84;

else
   Row_Pos83 := No_Token_Index;
   goto Exit_Row83_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row83_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos83 /= No_Token_Index then

   Transform_Res75 := Allocate_Message_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res75,
      Kind => Rflx_Message_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos83 = Pos
                            then No_Token_Index
                            else Row_Pos83 - 1));

      Initialize_Fields_For_Message_Type_Def
        (Self => Transform_Res75, Message_Type_Def_F_Message_Fields => Defer_Res123, Message_Type_Def_F_Aspects => Defer_Res124);

         if Defer_Res123 /= null and then Is_Incomplete (Defer_Res123) then
            Transform_Res75.Last_Attempted_Child := 0;
         elsif Defer_Res123 /= null and then not Is_Ghost (Defer_Res123) then
            Transform_Res75.Last_Attempted_Child := -1;
         end if;
         if Defer_Res124 /= null and then Is_Incomplete (Defer_Res124) then
            Transform_Res75.Last_Attempted_Child := 0;
         elsif Defer_Res124 /= null and then not Is_Ghost (Defer_Res124) then
            Transform_Res75.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos83 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags75);
end if;

--  End transform_code

    if Row_Pos83 /= No_Token_Index then
        Or_Pos34 := Row_Pos83;
        Or_Res34 := Transform_Res75;
        goto Exit_Or34;
    end if;
    
--  Start transform_code

Transform_Diags76 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos85 := Pos;



--  Start tok_code

Token_Res122 := Row_Pos85;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res122));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Null)
   then
       Token_Pos122 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos85 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos85,
             Expected_Token_Id => Rflx_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos122 := Row_Pos85 + 1;
   end if;
end;

--  End tok_code




if Token_Pos122 /= No_Token_Index then

   Row_Pos85 := Token_Pos122;

else
   Row_Pos85 := No_Token_Index;
   goto Exit_Row85_0;

end if;


--  Start tok_code

Token_Res123 := Row_Pos85;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res123));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Message)
   then
       Token_Pos123 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos85 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos85,
             Expected_Token_Id => Rflx_Message,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos123 := Row_Pos85 + 1;
   end if;
end;

--  End tok_code




if Token_Pos123 /= No_Token_Index then

   Row_Pos85 := Token_Pos123;

else
   Row_Pos85 := No_Token_Index;
   goto Exit_Row85_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row85_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos85 /= No_Token_Index then

   Transform_Res76 := Allocate_Null_Message_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res76,
      Kind => Rflx_Null_Message_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos85 = Pos
                            then No_Token_Index
                            else Row_Pos85 - 1));




elsif Row_Pos85 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags76);
end if;

--  End transform_code

    if Row_Pos85 /= No_Token_Index then
        Or_Pos34 := Row_Pos85;
        Or_Res34 := Transform_Res76;
        goto Exit_Or34;
    end if;
<<Exit_Or34>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Type_Definition_Or_Parse0_Memo,
      Or_Pos34 /= No_Token_Index,
      Or_Res34,
      Pos,
      Or_Pos34);


   Parser.Current_Pos := Or_Pos34;

   return Or_Res34;
end Message_Type_Definition_Or_Parse0;

   


function Modular_Type_Definition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Modular_Type_Def
is
   use Bare_Modular_Type_Def_Memos;

      Row_Pos86 :
            Token_Index
               := No_Token_Index;
      Token_Pos124 :
            Token_Index
               := No_Token_Index;
      Token_Res124 :
            Token_Index
               := No_Token_Index;
      Defer_Pos125 :
            Token_Index
               := No_Token_Index;
      Defer_Res125 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res77 :
            Bare_Modular_Type_Def
               := No_Bare_R_F_L_X_Node;
      Transform_Diags77 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Modular_Type_Definition_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res77 := M.Instance;
      return Transform_Res77;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res77;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags77 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos86 := Pos;



--  Start tok_code

Token_Res124 := Row_Pos86;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res124));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Mod)
   then
       Token_Pos124 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos86 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos86,
             Expected_Token_Id => Rflx_Mod,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos124 := Row_Pos86 + 1;
   end if;
end;

--  End tok_code




if Token_Pos124 /= No_Token_Index then

   Row_Pos86 := Token_Pos124;

else
   Row_Pos86 := No_Token_Index;
   goto Exit_Row86_0;

end if;


Defer_Res125 :=
   Expression_Or_Parse1 (Parser, Row_Pos86);
Defer_Pos125 := Parser.Current_Pos;




if Defer_Pos125 /= No_Token_Index then

   Row_Pos86 := Defer_Pos125;

else
   Row_Pos86 := No_Token_Index;
   goto Exit_Row86_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row86_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos86 /= No_Token_Index then

   Transform_Res77 := Allocate_Modular_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res77,
      Kind => Rflx_Modular_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos86 = Pos
                            then No_Token_Index
                            else Row_Pos86 - 1));

      Initialize_Fields_For_Modular_Type_Def
        (Self => Transform_Res77, Modular_Type_Def_F_Mod => Defer_Res125);

         if Defer_Res125 /= null and then Is_Incomplete (Defer_Res125) then
            Transform_Res77.Last_Attempted_Child := 0;
         elsif Defer_Res125 /= null and then not Is_Ghost (Defer_Res125) then
            Transform_Res77.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos86 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags77);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Modular_Type_Definition_Transform_Parse0_Memo,
      Row_Pos86 /= No_Token_Index,
      Transform_Res77,
      Pos,
      Row_Pos86);


   Parser.Current_Pos := Row_Pos86;

   return Transform_Res77;
end Modular_Type_Definition_Transform_Parse0;

   


function Named_Enumeration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Named_Enumeration_Def
is
   use Bare_Named_Enumeration_Def_Memos;

      Row_Pos87 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos16 :
            Token_Index
               := No_Token_Index;
      Tmp_List16 :
            Free_Parse_List;
      Defer_Pos126 :
            Token_Index
               := No_Token_Index;
      Defer_Res126 :
            Bare_Element_Value_Assoc
               := No_Bare_R_F_L_X_Node;
      Token_Pos125 :
            Token_Index
               := No_Token_Index;
      Token_Res125 :
            Token_Index
               := No_Token_Index;
      List_Pos16 :
            Token_Index
               := No_Token_Index;
      List_Res16 :
            Bare_Element_Value_Assoc_List
               := No_Bare_R_F_L_X_Node;
      Transform_Res78 :
            Bare_Named_Enumeration_Def
               := No_Bare_R_F_L_X_Node;
      Transform_Diags78 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Named_Enumeration_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res78 := M.Instance;
      return Transform_Res78;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res78;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags78 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos87 := Pos;



--  Start list_code

    List_Pos16 := No_Token_Index;



Lst_Cpos16 := Row_Pos87;
Tmp_List16 := Get_Parse_List (Parser);

loop
   
Defer_Res126 :=
   Element_Value_Association_Transform_Parse0 (Parser, Lst_Cpos16);
Defer_Pos126 := Parser.Current_Pos;


   exit when Defer_Pos126 = No_Token_Index;

   List_Pos16 := Defer_Pos126;
   Lst_Cpos16 := List_Pos16;

   Tmp_List16.Nodes.Append (Defer_Res126);

      
--  Start tok_code

Token_Res125 := Lst_Cpos16;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res125));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos125 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos16 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos16,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos125 := Lst_Cpos16 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos125 /= No_Token_Index then
          Lst_Cpos16 := Token_Pos125;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List16.Nodes.Length;
begin
   List_Res16 :=
      Allocate_Element_Value_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos87;
      Token_End := (if Lst_Cpos16 = Row_Pos87
                    then Row_Pos87
                    else Lst_Cpos16 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos87, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res16,
      Kind              => Rflx_Element_Value_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res16,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List16.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res16.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List16);

--  End list_code




if List_Pos16 /= No_Token_Index then

   Row_Pos87 := List_Pos16;

else
   Row_Pos87 := No_Token_Index;
   goto Exit_Row87_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row87_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos87 /= No_Token_Index then

   Transform_Res78 := Allocate_Named_Enumeration_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res78,
      Kind => Rflx_Named_Enumeration_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos87 = Pos
                            then No_Token_Index
                            else Row_Pos87 - 1));

      Initialize_Fields_For_Named_Enumeration_Def
        (Self => Transform_Res78, Named_Enumeration_Def_F_Elements => List_Res16);

         if List_Res16 /= null and then Is_Incomplete (List_Res16) then
            Transform_Res78.Last_Attempted_Child := 0;
         elsif List_Res16 /= null and then not Is_Ghost (List_Res16) then
            Transform_Res78.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos87 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags78);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Named_Enumeration_Transform_Parse0_Memo,
      Row_Pos87 /= No_Token_Index,
      Transform_Res78,
      Pos,
      Row_Pos87);


   Parser.Current_Pos := Row_Pos87;

   return Transform_Res78;
end Named_Enumeration_Transform_Parse0;

   


function Null_Message_Aggregate_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Message_Aggregate
is
   use Bare_Null_Message_Aggregate_Memos;

      Row_Pos88 :
            Token_Index
               := No_Token_Index;
      Token_Pos126 :
            Token_Index
               := No_Token_Index;
      Token_Res126 :
            Token_Index
               := No_Token_Index;
      Token_Pos127 :
            Token_Index
               := No_Token_Index;
      Token_Res127 :
            Token_Index
               := No_Token_Index;
      Transform_Res79 :
            Bare_Null_Message_Aggregate
               := No_Bare_R_F_L_X_Node;
      Transform_Diags79 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Null_Message_Aggregate_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res79 := M.Instance;
      return Transform_Res79;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res79;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags79 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos88 := Pos;



--  Start tok_code

Token_Res126 := Row_Pos88;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res126));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Null)
   then
       Token_Pos126 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos88 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos88,
             Expected_Token_Id => Rflx_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos126 := Row_Pos88 + 1;
   end if;
end;

--  End tok_code




if Token_Pos126 /= No_Token_Index then

   Row_Pos88 := Token_Pos126;

else
   Row_Pos88 := No_Token_Index;
   goto Exit_Row88_0;

end if;


--  Start tok_code

Token_Res127 := Row_Pos88;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res127));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Message)
   then
       Token_Pos127 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos88 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos88,
             Expected_Token_Id => Rflx_Message,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos127 := Row_Pos88 + 1;
   end if;
end;

--  End tok_code




if Token_Pos127 /= No_Token_Index then

   Row_Pos88 := Token_Pos127;

else
   Row_Pos88 := No_Token_Index;
   goto Exit_Row88_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row88_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos88 /= No_Token_Index then

   Transform_Res79 := Allocate_Null_Message_Aggregate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res79,
      Kind => Rflx_Null_Message_Aggregate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos88 = Pos
                            then No_Token_Index
                            else Row_Pos88 - 1));




elsif Row_Pos88 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags79);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Null_Message_Aggregate_Transform_Parse0_Memo,
      Row_Pos88 /= No_Token_Index,
      Transform_Res79,
      Pos,
      Row_Pos88);


   Parser.Current_Pos := Row_Pos88;

   return Transform_Res79;
end Null_Message_Aggregate_Transform_Parse0;

   


function Null_Message_Field_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Message_Field
is
   use Bare_Null_Message_Field_Memos;

      Row_Pos89 :
            Token_Index
               := No_Token_Index;
      Token_Pos128 :
            Token_Index
               := No_Token_Index;
      Token_Res128 :
            Token_Index
               := No_Token_Index;
      Defer_Pos127 :
            Token_Index
               := No_Token_Index;
      Defer_Res127 :
            Bare_Then_Node
               := No_Bare_R_F_L_X_Node;
      Token_Pos129 :
            Token_Index
               := No_Token_Index;
      Token_Res129 :
            Token_Index
               := No_Token_Index;
      Transform_Res80 :
            Bare_Null_Message_Field
               := No_Bare_R_F_L_X_Node;
      Transform_Diags80 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Null_Message_Field_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res80 := M.Instance;
      return Transform_Res80;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res80;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags80 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos89 := Pos;



--  Start tok_code

Token_Res128 := Row_Pos89;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res128));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Null)
   then
       Token_Pos128 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos89 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos89,
             Expected_Token_Id => Rflx_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos128 := Row_Pos89 + 1;
   end if;
end;

--  End tok_code




if Token_Pos128 /= No_Token_Index then

   Row_Pos89 := Token_Pos128;

else
   Row_Pos89 := No_Token_Index;
   goto Exit_Row89_0;

end if;


Defer_Res127 :=
   Then_Transform_Parse0 (Parser, Row_Pos89);
Defer_Pos127 := Parser.Current_Pos;




if Defer_Pos127 /= No_Token_Index then

   Row_Pos89 := Defer_Pos127;

else
   Row_Pos89 := No_Token_Index;
   goto Exit_Row89_0;

end if;


--  Start tok_code

Token_Res129 := Row_Pos89;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res129));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos129 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos89 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos89,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos129 := Row_Pos89 + 1;
   end if;
end;

--  End tok_code




if Token_Pos129 /= No_Token_Index then

   Row_Pos89 := Token_Pos129;

else
   Row_Pos89 := No_Token_Index;
   goto Exit_Row89_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row89_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos89 /= No_Token_Index then

   Transform_Res80 := Allocate_Null_Message_Field (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res80,
      Kind => Rflx_Null_Message_Field,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos89 = Pos
                            then No_Token_Index
                            else Row_Pos89 - 1));

      Initialize_Fields_For_Null_Message_Field
        (Self => Transform_Res80, Null_Message_Field_F_Then => Defer_Res127);

         if Defer_Res127 /= null and then Is_Incomplete (Defer_Res127) then
            Transform_Res80.Last_Attempted_Child := 0;
         elsif Defer_Res127 /= null and then not Is_Ghost (Defer_Res127) then
            Transform_Res80.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos89 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags80);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Null_Message_Field_Transform_Parse0_Memo,
      Row_Pos89 /= No_Token_Index,
      Transform_Res80,
      Pos,
      Row_Pos89);


   Parser.Current_Pos := Row_Pos89;

   return Transform_Res80;
end Null_Message_Field_Transform_Parse0;

   


function Numeric_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Numeric_Literal
is
   use Bare_Numeric_Literal_Memos;

      Row_Pos90 :
            Token_Index
               := No_Token_Index;
      Token_Pos130 :
            Token_Index
               := No_Token_Index;
      Token_Res130 :
            Token_Index
               := No_Token_Index;
      Transform_Res81 :
            Bare_Numeric_Literal
               := No_Bare_R_F_L_X_Node;
      Transform_Diags81 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Numeric_Literal_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res81 := M.Instance;
      return Transform_Res81;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res81;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags81 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos90 := Pos;



--  Start tok_code

Token_Res130 := Row_Pos90;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res130));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Numeral)
   then
       Token_Pos130 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos90 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos90,
             Expected_Token_Id => Rflx_Numeral,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos130 := Row_Pos90 + 1;
   end if;
end;

--  End tok_code




if Token_Pos130 /= No_Token_Index then

   Row_Pos90 := Token_Pos130;

else
   Row_Pos90 := No_Token_Index;
   goto Exit_Row90_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row90_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos90 /= No_Token_Index then

   Transform_Res81 := Allocate_Numeric_Literal (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res81,
      Kind => Rflx_Numeric_Literal,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos90 = Pos
                            then No_Token_Index
                            else Row_Pos90 - 1));




elsif Row_Pos90 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags81);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Numeric_Literal_Transform_Parse0_Memo,
      Row_Pos90 /= No_Token_Index,
      Transform_Res81,
      Pos,
      Row_Pos90);


   Parser.Current_Pos := Row_Pos90;

   return Transform_Res81;
end Numeric_Literal_Transform_Parse0;

   


function Package_Declaration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Package_Node
is
   use Bare_Package_Node_Memos;

      Row_Pos91 :
            Token_Index
               := No_Token_Index;
      Token_Pos131 :
            Token_Index
               := No_Token_Index;
      Token_Res131 :
            Token_Index
               := No_Token_Index;
      Defer_Pos128 :
            Token_Index
               := No_Token_Index;
      Defer_Res128 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos132 :
            Token_Index
               := No_Token_Index;
      Token_Res132 :
            Token_Index
               := No_Token_Index;
      Defer_Pos129 :
            Token_Index
               := No_Token_Index;
      Defer_Res129 :
            Bare_Declaration_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos133 :
            Token_Index
               := No_Token_Index;
      Token_Res133 :
            Token_Index
               := No_Token_Index;
      Defer_Pos130 :
            Token_Index
               := No_Token_Index;
      Defer_Res130 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos134 :
            Token_Index
               := No_Token_Index;
      Token_Res134 :
            Token_Index
               := No_Token_Index;
      Transform_Res82 :
            Bare_Package_Node
               := No_Bare_R_F_L_X_Node;
      Transform_Diags82 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Package_Declaration_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res82 := M.Instance;
      return Transform_Res82;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res82;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags82 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos91 := Pos;



--  Start tok_code

Token_Res131 := Row_Pos91;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res131));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Package)
   then
       Token_Pos131 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos91 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos91,
             Expected_Token_Id => Rflx_Package,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos131 := Row_Pos91 + 1;
   end if;
end;

--  End tok_code




if Token_Pos131 /= No_Token_Index then

   Row_Pos91 := Token_Pos131;

else
   Row_Pos91 := No_Token_Index;
   goto Exit_Row91_0;

end if;


Defer_Res128 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos91);
Defer_Pos128 := Parser.Current_Pos;




if Defer_Pos128 /= No_Token_Index then

   Row_Pos91 := Defer_Pos128;

else
   Row_Pos91 := No_Token_Index;
   goto Exit_Row91_0;

end if;


--  Start tok_code

Token_Res132 := Row_Pos91;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res132));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Is)
   then
       Token_Pos132 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos91 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos91,
             Expected_Token_Id => Rflx_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos132 := Row_Pos91 + 1;
   end if;
end;

--  End tok_code




if Token_Pos132 /= No_Token_Index then

   Row_Pos91 := Token_Pos132;

else
   Row_Pos91 := No_Token_Index;
   goto Exit_Row91_0;

end if;


--  Start opt_code












Defer_Res129 :=
   Basic_Declarations_Extract_Parse0 (Parser, Row_Pos91);
Defer_Pos129 := Parser.Current_Pos;


if Defer_Pos129 = No_Token_Index then

         
   Defer_Res129 :=
     Allocate_Declaration_List (Parser.Mem_Pool);
   Initialize
     (Self              => Defer_Res129,
      Kind              => Rflx_Declaration_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos91 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => Defer_Res129,
      Parser => Parser,
      Count  => 0);



       
   Defer_Pos129 := Row_Pos91;



end if;

--  End opt_code




if Defer_Pos129 /= No_Token_Index then

   Row_Pos91 := Defer_Pos129;

else
   Row_Pos91 := No_Token_Index;
   goto Exit_Row91_0;

end if;


--  Start tok_code

Token_Res133 := Row_Pos91;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res133));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_End)
   then
       Token_Pos133 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos91 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos91,
             Expected_Token_Id => Rflx_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos133 := Row_Pos91 + 1;
   end if;
end;

--  End tok_code




if Token_Pos133 /= No_Token_Index then

   Row_Pos91 := Token_Pos133;

else
   Row_Pos91 := No_Token_Index;
   goto Exit_Row91_0;

end if;


Defer_Res130 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos91);
Defer_Pos130 := Parser.Current_Pos;




if Defer_Pos130 /= No_Token_Index then

   Row_Pos91 := Defer_Pos130;

else
   Row_Pos91 := No_Token_Index;
   goto Exit_Row91_0;

end if;


--  Start tok_code

Token_Res134 := Row_Pos91;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res134));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos134 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos91 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos91,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos134 := Row_Pos91 + 1;
   end if;
end;

--  End tok_code




if Token_Pos134 /= No_Token_Index then

   Row_Pos91 := Token_Pos134;

else
   Row_Pos91 := No_Token_Index;
   goto Exit_Row91_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row91_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos91 /= No_Token_Index then

   Transform_Res82 := Allocate_Package_Node (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res82,
      Kind => Rflx_Package_Node,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos91 = Pos
                            then No_Token_Index
                            else Row_Pos91 - 1));

      Initialize_Fields_For_Package_Node
        (Self => Transform_Res82, Package_Node_F_Identifier => Defer_Res128, Package_Node_F_Declarations => Defer_Res129, Package_Node_F_End_Identifier => Defer_Res130);

         if Defer_Res128 /= null and then Is_Incomplete (Defer_Res128) then
            Transform_Res82.Last_Attempted_Child := 0;
         elsif Defer_Res128 /= null and then not Is_Ghost (Defer_Res128) then
            Transform_Res82.Last_Attempted_Child := -1;
         end if;
         if Defer_Res129 /= null and then Is_Incomplete (Defer_Res129) then
            Transform_Res82.Last_Attempted_Child := 0;
         elsif Defer_Res129 /= null and then not Is_Ghost (Defer_Res129) then
            Transform_Res82.Last_Attempted_Child := -1;
         end if;
         if Defer_Res130 /= null and then Is_Incomplete (Defer_Res130) then
            Transform_Res82.Last_Attempted_Child := 0;
         elsif Defer_Res130 /= null and then not Is_Ghost (Defer_Res130) then
            Transform_Res82.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos91 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags82);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Package_Declaration_Transform_Parse0_Memo,
      Row_Pos91 /= No_Token_Index,
      Transform_Res82,
      Pos,
      Row_Pos91);


   Parser.Current_Pos := Row_Pos91;

   return Transform_Res82;
end Package_Declaration_Transform_Parse0;

   


function Parameter_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Parameter
is
   use Bare_Parameter_Memos;

      Row_Pos92 :
            Token_Index
               := No_Token_Index;
      Defer_Pos131 :
            Token_Index
               := No_Token_Index;
      Defer_Res131 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos135 :
            Token_Index
               := No_Token_Index;
      Token_Res135 :
            Token_Index
               := No_Token_Index;
      Defer_Pos132 :
            Token_Index
               := No_Token_Index;
      Defer_Res132 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Transform_Res83 :
            Bare_Parameter
               := No_Bare_R_F_L_X_Node;
      Transform_Diags83 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Parameter_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res83 := M.Instance;
      return Transform_Res83;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res83;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags83 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos92 := Pos;



Defer_Res131 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos92);
Defer_Pos131 := Parser.Current_Pos;




if Defer_Pos131 /= No_Token_Index then

   Row_Pos92 := Defer_Pos131;

else
   Row_Pos92 := No_Token_Index;
   goto Exit_Row92_0;

end if;


--  Start tok_code

Token_Res135 := Row_Pos92;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res135));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Colon)
   then
       Token_Pos135 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos92 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos92,
             Expected_Token_Id => Rflx_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos135 := Row_Pos92 + 1;
   end if;
end;

--  End tok_code




if Token_Pos135 /= No_Token_Index then

   Row_Pos92 := Token_Pos135;

else
   Row_Pos92 := No_Token_Index;
   goto Exit_Row92_0;

end if;


Defer_Res132 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Row_Pos92);
Defer_Pos132 := Parser.Current_Pos;




if Defer_Pos132 /= No_Token_Index then

   Row_Pos92 := Defer_Pos132;

else
   Row_Pos92 := No_Token_Index;
   goto Exit_Row92_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row92_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos92 /= No_Token_Index then

   Transform_Res83 := Allocate_Parameter (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res83,
      Kind => Rflx_Parameter,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos92 = Pos
                            then No_Token_Index
                            else Row_Pos92 - 1));

      Initialize_Fields_For_Parameter
        (Self => Transform_Res83, Parameter_F_Identifier => Defer_Res131, Parameter_F_Type_Identifier => Defer_Res132);

         if Defer_Res131 /= null and then Is_Incomplete (Defer_Res131) then
            Transform_Res83.Last_Attempted_Child := 0;
         elsif Defer_Res131 /= null and then not Is_Ghost (Defer_Res131) then
            Transform_Res83.Last_Attempted_Child := -1;
         end if;
         if Defer_Res132 /= null and then Is_Incomplete (Defer_Res132) then
            Transform_Res83.Last_Attempted_Child := 0;
         elsif Defer_Res132 /= null and then not Is_Ghost (Defer_Res132) then
            Transform_Res83.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos92 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags83);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Parameter_Transform_Parse0_Memo,
      Row_Pos92 /= No_Token_Index,
      Transform_Res83,
      Pos,
      Row_Pos92);


   Parser.Current_Pos := Row_Pos92;

   return Transform_Res83;
end Parameter_Transform_Parse0;

   


function Parameter_List_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Parameters
is
   use Bare_Parameters_Memos;

      Row_Pos93 :
            Token_Index
               := No_Token_Index;
      Token_Pos136 :
            Token_Index
               := No_Token_Index;
      Token_Res136 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos17 :
            Token_Index
               := No_Token_Index;
      Tmp_List17 :
            Free_Parse_List;
      Defer_Pos133 :
            Token_Index
               := No_Token_Index;
      Defer_Res133 :
            Bare_Parameter
               := No_Bare_R_F_L_X_Node;
      Token_Pos137 :
            Token_Index
               := No_Token_Index;
      Token_Res137 :
            Token_Index
               := No_Token_Index;
      List_Pos17 :
            Token_Index
               := No_Token_Index;
      List_Res17 :
            Bare_Parameter_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos138 :
            Token_Index
               := No_Token_Index;
      Token_Res138 :
            Token_Index
               := No_Token_Index;
      Transform_Res84 :
            Bare_Parameters
               := No_Bare_R_F_L_X_Node;
      Transform_Diags84 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Parameter_List_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res84 := M.Instance;
      return Transform_Res84;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res84;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags84 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos93 := Pos;



--  Start tok_code

Token_Res136 := Row_Pos93;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res136));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos136 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos93 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos93,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos136 := Row_Pos93 + 1;
   end if;
end;

--  End tok_code




if Token_Pos136 /= No_Token_Index then

   Row_Pos93 := Token_Pos136;

else
   Row_Pos93 := No_Token_Index;
   goto Exit_Row93_0;

end if;


--  Start list_code

    List_Pos17 := No_Token_Index;



Lst_Cpos17 := Row_Pos93;
Tmp_List17 := Get_Parse_List (Parser);

loop
   
Defer_Res133 :=
   Parameter_Transform_Parse0 (Parser, Lst_Cpos17);
Defer_Pos133 := Parser.Current_Pos;


   exit when Defer_Pos133 = No_Token_Index;

   List_Pos17 := Defer_Pos133;
   Lst_Cpos17 := List_Pos17;

   Tmp_List17.Nodes.Append (Defer_Res133);

      
--  Start tok_code

Token_Res137 := Lst_Cpos17;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res137));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos137 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos17 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos17,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos137 := Lst_Cpos17 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos137 /= No_Token_Index then
          Lst_Cpos17 := Token_Pos137;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List17.Nodes.Length;
begin
   List_Res17 :=
      Allocate_Parameter_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos93;
      Token_End := (if Lst_Cpos17 = Row_Pos93
                    then Row_Pos93
                    else Lst_Cpos17 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos93, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res17,
      Kind              => Rflx_Parameter_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res17,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List17.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res17.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List17);

--  End list_code




if List_Pos17 /= No_Token_Index then

   Row_Pos93 := List_Pos17;

else
   Row_Pos93 := No_Token_Index;
   goto Exit_Row93_0;

end if;


--  Start tok_code

Token_Res138 := Row_Pos93;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res138));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos138 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos93 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos93,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos138 := Row_Pos93 + 1;
   end if;
end;

--  End tok_code




if Token_Pos138 /= No_Token_Index then

   Row_Pos93 := Token_Pos138;

else
   Row_Pos93 := No_Token_Index;
   goto Exit_Row93_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row93_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos93 /= No_Token_Index then

   Transform_Res84 := Allocate_Parameters (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res84,
      Kind => Rflx_Parameters,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos93 = Pos
                            then No_Token_Index
                            else Row_Pos93 - 1));

      Initialize_Fields_For_Parameters
        (Self => Transform_Res84, Parameters_F_Parameters => List_Res17);

         if List_Res17 /= null and then Is_Incomplete (List_Res17) then
            Transform_Res84.Last_Attempted_Child := 0;
         elsif List_Res17 /= null and then not Is_Ghost (List_Res17) then
            Transform_Res84.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos93 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags84);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Parameter_List_Transform_Parse0_Memo,
      Row_Pos93 /= No_Token_Index,
      Transform_Res84,
      Pos,
      Row_Pos93);


   Parser.Current_Pos := Row_Pos93;

   return Transform_Res84;
end Parameter_List_Transform_Parse0;

   


function Paren_Expression_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Paren_Expression
is
   use Bare_Paren_Expression_Memos;

      Row_Pos94 :
            Token_Index
               := No_Token_Index;
      Token_Pos139 :
            Token_Index
               := No_Token_Index;
      Token_Res139 :
            Token_Index
               := No_Token_Index;
      Defer_Pos134 :
            Token_Index
               := No_Token_Index;
      Defer_Res134 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos140 :
            Token_Index
               := No_Token_Index;
      Token_Res140 :
            Token_Index
               := No_Token_Index;
      Transform_Res85 :
            Bare_Paren_Expression
               := No_Bare_R_F_L_X_Node;
      Transform_Diags85 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Paren_Expression_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res85 := M.Instance;
      return Transform_Res85;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res85;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags85 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos94 := Pos;



--  Start tok_code

Token_Res139 := Row_Pos94;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res139));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos139 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos94 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos94,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos139 := Row_Pos94 + 1;
   end if;
end;

--  End tok_code




if Token_Pos139 /= No_Token_Index then

   Row_Pos94 := Token_Pos139;

else
   Row_Pos94 := No_Token_Index;
   goto Exit_Row94_0;

end if;


Defer_Res134 :=
   Expression_Or_Parse1 (Parser, Row_Pos94);
Defer_Pos134 := Parser.Current_Pos;




if Defer_Pos134 /= No_Token_Index then

   Row_Pos94 := Defer_Pos134;

else
   Row_Pos94 := No_Token_Index;
   goto Exit_Row94_0;

end if;


--  Start tok_code

Token_Res140 := Row_Pos94;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res140));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos140 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos94 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos94,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos140 := Row_Pos94 + 1;
   end if;
end;

--  End tok_code




if Token_Pos140 /= No_Token_Index then

   Row_Pos94 := Token_Pos140;

else
   Row_Pos94 := No_Token_Index;
   goto Exit_Row94_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row94_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos94 /= No_Token_Index then

   Transform_Res85 := Allocate_Paren_Expression (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res85,
      Kind => Rflx_Paren_Expression,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos94 = Pos
                            then No_Token_Index
                            else Row_Pos94 - 1));

      Initialize_Fields_For_Paren_Expression
        (Self => Transform_Res85, Paren_Expression_F_Data => Defer_Res134);

         if Defer_Res134 /= null and then Is_Incomplete (Defer_Res134) then
            Transform_Res85.Last_Attempted_Child := 0;
         elsif Defer_Res134 /= null and then not Is_Ghost (Defer_Res134) then
            Transform_Res85.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos94 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags85);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Paren_Expression_Transform_Parse0_Memo,
      Row_Pos94 /= No_Token_Index,
      Transform_Res85,
      Pos,
      Row_Pos94);


   Parser.Current_Pos := Row_Pos94;

   return Transform_Res85;
end Paren_Expression_Transform_Parse0;

   


function Positional_Enumeration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Positional_Enumeration_Def
is
   use Bare_Positional_Enumeration_Def_Memos;

      Row_Pos95 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos18 :
            Token_Index
               := No_Token_Index;
      Tmp_List18 :
            Free_Parse_List;
      Defer_Pos135 :
            Token_Index
               := No_Token_Index;
      Defer_Res135 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos141 :
            Token_Index
               := No_Token_Index;
      Token_Res141 :
            Token_Index
               := No_Token_Index;
      List_Pos18 :
            Token_Index
               := No_Token_Index;
      List_Res18 :
            Bare_Unqualified_I_D_List
               := No_Bare_R_F_L_X_Node;
      Transform_Res86 :
            Bare_Positional_Enumeration_Def
               := No_Bare_R_F_L_X_Node;
      Transform_Diags86 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Positional_Enumeration_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res86 := M.Instance;
      return Transform_Res86;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res86;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags86 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos95 := Pos;



--  Start list_code

    List_Pos18 := No_Token_Index;



Lst_Cpos18 := Row_Pos95;
Tmp_List18 := Get_Parse_List (Parser);

loop
   
Defer_Res135 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Lst_Cpos18);
Defer_Pos135 := Parser.Current_Pos;


   exit when Defer_Pos135 = No_Token_Index;

   List_Pos18 := Defer_Pos135;
   Lst_Cpos18 := List_Pos18;

   Tmp_List18.Nodes.Append (Defer_Res135);

      
--  Start tok_code

Token_Res141 := Lst_Cpos18;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res141));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos141 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos18 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos18,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos141 := Lst_Cpos18 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos141 /= No_Token_Index then
          Lst_Cpos18 := Token_Pos141;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List18.Nodes.Length;
begin
   List_Res18 :=
      Allocate_Unqualified_I_D_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos95;
      Token_End := (if Lst_Cpos18 = Row_Pos95
                    then Row_Pos95
                    else Lst_Cpos18 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos95, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res18,
      Kind              => Rflx_Unqualified_I_D_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res18,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List18.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res18.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List18);

--  End list_code




if List_Pos18 /= No_Token_Index then

   Row_Pos95 := List_Pos18;

else
   Row_Pos95 := No_Token_Index;
   goto Exit_Row95_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row95_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos95 /= No_Token_Index then

   Transform_Res86 := Allocate_Positional_Enumeration_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res86,
      Kind => Rflx_Positional_Enumeration_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos95 = Pos
                            then No_Token_Index
                            else Row_Pos95 - 1));

      Initialize_Fields_For_Positional_Enumeration_Def
        (Self => Transform_Res86, Positional_Enumeration_Def_F_Elements => List_Res18);

         if List_Res18 /= null and then Is_Incomplete (List_Res18) then
            Transform_Res86.Last_Attempted_Child := 0;
         elsif List_Res18 /= null and then not Is_Ghost (List_Res18) then
            Transform_Res86.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos95 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags86);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Positional_Enumeration_Transform_Parse0_Memo,
      Row_Pos95 /= No_Token_Index,
      Transform_Res86,
      Pos,
      Row_Pos95);


   Parser.Current_Pos := Row_Pos95;

   return Transform_Res86;
end Positional_Enumeration_Transform_Parse0;

   


function Primary_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Defer_Pos136 :
            Token_Index
               := No_Token_Index;
      Defer_Res136 :
            Bare_Sequence_Literal
               := No_Bare_R_F_L_X_Node;
      Defer_Pos137 :
            Token_Index
               := No_Token_Index;
      Defer_Res137 :
            Bare_Numeric_Literal
               := No_Bare_R_F_L_X_Node;
      Defer_Pos138 :
            Token_Index
               := No_Token_Index;
      Defer_Res138 :
            Bare_String_Literal
               := No_Bare_R_F_L_X_Node;
      Defer_Pos139 :
            Token_Index
               := No_Token_Index;
      Defer_Res139 :
            Bare_Variable
               := No_Bare_R_F_L_X_Node;
      Defer_Pos140 :
            Token_Index
               := No_Token_Index;
      Defer_Res140 :
            Bare_Paren_Expression
               := No_Bare_R_F_L_X_Node;
      Or_Pos35 :
            Token_Index
               := No_Token_Index;
      Or_Res35 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Primary_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res35 := M.Instance;
      return Or_Res35;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res35;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos35 := No_Token_Index;
Or_Res35 := No_Bare_R_F_L_X_Node;
    
Defer_Res136 :=
   Concatenation_Or_Parse2 (Parser, Pos);
Defer_Pos136 := Parser.Current_Pos;

    if Defer_Pos136 /= No_Token_Index then
        Or_Pos35 := Defer_Pos136;
        Or_Res35 := Defer_Res136;
        goto Exit_Or35;
    end if;
    
Defer_Res137 :=
   Numeric_Literal_Transform_Parse0 (Parser, Pos);
Defer_Pos137 := Parser.Current_Pos;

    if Defer_Pos137 /= No_Token_Index then
        Or_Pos35 := Defer_Pos137;
        Or_Res35 := Defer_Res137;
        goto Exit_Or35;
    end if;
    
Defer_Res138 :=
   String_Literal_Transform_Parse0 (Parser, Pos);
Defer_Pos138 := Parser.Current_Pos;

    if Defer_Pos138 /= No_Token_Index then
        Or_Pos35 := Defer_Pos138;
        Or_Res35 := Defer_Res138;
        goto Exit_Or35;
    end if;
    
Defer_Res139 :=
   Variable_Transform_Parse0 (Parser, Pos);
Defer_Pos139 := Parser.Current_Pos;

    if Defer_Pos139 /= No_Token_Index then
        Or_Pos35 := Defer_Pos139;
        Or_Res35 := Defer_Res139;
        goto Exit_Or35;
    end if;
    
Defer_Res140 :=
   Paren_Expression_Transform_Parse0 (Parser, Pos);
Defer_Pos140 := Parser.Current_Pos;

    if Defer_Pos140 /= No_Token_Index then
        Or_Pos35 := Defer_Pos140;
        Or_Res35 := Defer_Res140;
        goto Exit_Or35;
    end if;
<<Exit_Or35>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Primary_Or_Parse0_Memo,
      Or_Pos35 /= No_Token_Index,
      Or_Res35,
      Pos,
      Or_Pos35);


   Parser.Current_Pos := Or_Pos35;

   return Or_Res35;
end Primary_Or_Parse0;

   


function Qualified_Identifier_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_I_D
is
   use Bare_I_D_Memos;

      Row_Pos96 :
            Token_Index
               := No_Token_Index;
      Row_Pos97 :
            Token_Index
               := No_Token_Index;
      Defer_Pos141 :
            Token_Index
               := No_Token_Index;
      Defer_Res141 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos142 :
            Token_Index
               := No_Token_Index;
      Token_Res142 :
            Token_Index
               := No_Token_Index;
      Defer_Pos142 :
            Token_Index
               := No_Token_Index;
      Defer_Res142 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Transform_Res87 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Transform_Diags87 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Qualified_Identifier_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res87 := M.Instance;
      return Transform_Res87;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res87;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags87 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos96 := Pos;



--  Start opt_code












--  Start row_code

Row_Pos97 := Row_Pos96;



Defer_Res141 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos97);
Defer_Pos141 := Parser.Current_Pos;




if Defer_Pos141 /= No_Token_Index then

   Row_Pos97 := Defer_Pos141;

else
   Row_Pos97 := No_Token_Index;
   goto Exit_Row97_0;

end if;


--  Start tok_code

Token_Res142 := Row_Pos97;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res142));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Double_Colon)
   then
       Token_Pos142 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos97 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos97,
             Expected_Token_Id => Rflx_Double_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos142 := Row_Pos97 + 1;
   end if;
end;

--  End tok_code




if Token_Pos142 /= No_Token_Index then

   Row_Pos97 := Token_Pos142;

else
   Row_Pos97 := No_Token_Index;
   goto Exit_Row97_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row97_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos97 = No_Token_Index then

         
   Defer_Res141 := No_Bare_R_F_L_X_Node;



       
   Row_Pos97 := Row_Pos96;



end if;

--  End opt_code




if Row_Pos97 /= No_Token_Index then

   Row_Pos96 := Row_Pos97;

else
   Row_Pos96 := No_Token_Index;
   goto Exit_Row96_0;

end if;


Defer_Res142 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos96);
Defer_Pos142 := Parser.Current_Pos;




if Defer_Pos142 /= No_Token_Index then

   Row_Pos96 := Defer_Pos142;

else
   Row_Pos96 := No_Token_Index;
   goto Exit_Row96_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row96_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos96 /= No_Token_Index then

   Transform_Res87 := Allocate_I_D (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res87,
      Kind => Rflx_I_D,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos96 = Pos
                            then No_Token_Index
                            else Row_Pos96 - 1));

      Initialize_Fields_For_I_D
        (Self => Transform_Res87, I_D_F_Package => Defer_Res141, I_D_F_Name => Defer_Res142);

         if Defer_Res141 /= null and then Is_Incomplete (Defer_Res141) then
            Transform_Res87.Last_Attempted_Child := 0;
         elsif Defer_Res141 /= null and then not Is_Ghost (Defer_Res141) then
            Transform_Res87.Last_Attempted_Child := -1;
         end if;
         if Defer_Res142 /= null and then Is_Incomplete (Defer_Res142) then
            Transform_Res87.Last_Attempted_Child := 0;
         elsif Defer_Res142 /= null and then not Is_Ghost (Defer_Res142) then
            Transform_Res87.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos96 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags87);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Qualified_Identifier_Transform_Parse0_Memo,
      Row_Pos96 /= No_Token_Index,
      Transform_Res87,
      Pos,
      Row_Pos96);


   Parser.Current_Pos := Row_Pos96;

   return Transform_Res87;
end Qualified_Identifier_Transform_Parse0;

   


function Quantified_Expression_Transform_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Quantified_Expression
is
   use Bare_Quantified_Expression_Memos;

      Row_Pos98 :
            Token_Index
               := No_Token_Index;
      Token_Pos143 :
            Token_Index
               := No_Token_Index;
      Token_Res143 :
            Token_Index
               := No_Token_Index;
      Row_Pos99 :
            Token_Index
               := No_Token_Index;
      Token_Pos144 :
            Token_Index
               := No_Token_Index;
      Token_Res144 :
            Token_Index
               := No_Token_Index;
      Transform_Res88 :
            Bare_Quantifier_All
               := No_Bare_R_F_L_X_Node;
      Transform_Diags88 :
            Ada.Containers.Count_Type;
      Row_Pos100 :
            Token_Index
               := No_Token_Index;
      Token_Pos145 :
            Token_Index
               := No_Token_Index;
      Token_Res145 :
            Token_Index
               := No_Token_Index;
      Transform_Res89 :
            Bare_Quantifier_Some
               := No_Bare_R_F_L_X_Node;
      Transform_Diags89 :
            Ada.Containers.Count_Type;
      Or_Pos36 :
            Token_Index
               := No_Token_Index;
      Or_Res36 :
            Bare_Quantifier
               := No_Bare_R_F_L_X_Node;
      Defer_Pos143 :
            Token_Index
               := No_Token_Index;
      Defer_Res143 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos146 :
            Token_Index
               := No_Token_Index;
      Token_Res146 :
            Token_Index
               := No_Token_Index;
      Defer_Pos144 :
            Token_Index
               := No_Token_Index;
      Defer_Res144 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos147 :
            Token_Index
               := No_Token_Index;
      Token_Res147 :
            Token_Index
               := No_Token_Index;
      Defer_Pos145 :
            Token_Index
               := No_Token_Index;
      Defer_Res145 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res90 :
            Bare_Quantified_Expression
               := No_Bare_R_F_L_X_Node;
      Transform_Diags90 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Quantified_Expression_Transform_Parse2_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res90 := M.Instance;
      return Transform_Res90;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res90;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags90 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos98 := Pos;



--  Start tok_code

Token_Res143 := Row_Pos98;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res143));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_For)
   then
       Token_Pos143 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos98 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos98,
             Expected_Token_Id => Rflx_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos143 := Row_Pos98 + 1;
   end if;
end;

--  End tok_code




if Token_Pos143 /= No_Token_Index then

   Row_Pos98 := Token_Pos143;

else
   Row_Pos98 := No_Token_Index;
   goto Exit_Row98_0;

end if;


--  Start or_code

Or_Pos36 := No_Token_Index;
Or_Res36 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags88 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos99 := Row_Pos98;



--  Start tok_code

Token_Res144 := Row_Pos99;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res144));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_All)
   then
       Token_Pos144 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos99 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos99,
             Expected_Token_Id => Rflx_All,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos144 := Row_Pos99 + 1;
   end if;
end;

--  End tok_code




if Token_Pos144 /= No_Token_Index then

   Row_Pos99 := Token_Pos144;

else
   Row_Pos99 := No_Token_Index;
   goto Exit_Row99_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row99_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos99 /= No_Token_Index then

   Transform_Res88 := Allocate_Quantifier_All (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res88,
      Kind => Rflx_Quantifier_All,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos98,
      Token_End_Index   => (if Row_Pos99 = Row_Pos98
                            then No_Token_Index
                            else Row_Pos99 - 1));




elsif Row_Pos99 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags88);
end if;

--  End transform_code

    if Row_Pos99 /= No_Token_Index then
        Or_Pos36 := Row_Pos99;
        Or_Res36 := Transform_Res88;
        goto Exit_Or36;
    end if;
    
--  Start transform_code

Transform_Diags89 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos100 := Row_Pos98;



--  Start tok_code

Token_Res145 := Row_Pos100;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res145));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Some)
   then
       Token_Pos145 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos100 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos100,
             Expected_Token_Id => Rflx_Some,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos145 := Row_Pos100 + 1;
   end if;
end;

--  End tok_code




if Token_Pos145 /= No_Token_Index then

   Row_Pos100 := Token_Pos145;

else
   Row_Pos100 := No_Token_Index;
   goto Exit_Row100_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row100_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos100 /= No_Token_Index then

   Transform_Res89 := Allocate_Quantifier_Some (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res89,
      Kind => Rflx_Quantifier_Some,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos98,
      Token_End_Index   => (if Row_Pos100 = Row_Pos98
                            then No_Token_Index
                            else Row_Pos100 - 1));




elsif Row_Pos100 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags89);
end if;

--  End transform_code

    if Row_Pos100 /= No_Token_Index then
        Or_Pos36 := Row_Pos100;
        Or_Res36 := Transform_Res89;
        goto Exit_Or36;
    end if;
<<Exit_Or36>>

--  End or_code




if Or_Pos36 /= No_Token_Index then

   Row_Pos98 := Or_Pos36;

else
   Row_Pos98 := No_Token_Index;
   goto Exit_Row98_0;

end if;


Defer_Res143 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos98);
Defer_Pos143 := Parser.Current_Pos;




if Defer_Pos143 /= No_Token_Index then

   Row_Pos98 := Defer_Pos143;

else
   Row_Pos98 := No_Token_Index;
   goto Exit_Row98_0;

end if;


--  Start tok_code

Token_Res146 := Row_Pos98;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res146));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_In)
   then
       Token_Pos146 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos98 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos98,
             Expected_Token_Id => Rflx_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos146 := Row_Pos98 + 1;
   end if;
end;

--  End tok_code




if Token_Pos146 /= No_Token_Index then

   Row_Pos98 := Token_Pos146;

else
   Row_Pos98 := No_Token_Index;
   goto Exit_Row98_0;

end if;


Defer_Res144 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos98);
Defer_Pos144 := Parser.Current_Pos;




if Defer_Pos144 /= No_Token_Index then

   Row_Pos98 := Defer_Pos144;

else
   Row_Pos98 := No_Token_Index;
   goto Exit_Row98_0;

end if;


--  Start tok_code

Token_Res147 := Row_Pos98;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res147));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Arrow)
   then
       Token_Pos147 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos98 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos98,
             Expected_Token_Id => Rflx_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos147 := Row_Pos98 + 1;
   end if;
end;

--  End tok_code




if Token_Pos147 /= No_Token_Index then

   Row_Pos98 := Token_Pos147;

else
   Row_Pos98 := No_Token_Index;
   goto Exit_Row98_0;

end if;


Defer_Res145 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos98);
Defer_Pos145 := Parser.Current_Pos;




if Defer_Pos145 /= No_Token_Index then

   Row_Pos98 := Defer_Pos145;

else
   Row_Pos98 := No_Token_Index;
   goto Exit_Row98_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row98_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos98 /= No_Token_Index then

   Transform_Res90 := Allocate_Quantified_Expression (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res90,
      Kind => Rflx_Quantified_Expression,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos98 = Pos
                            then No_Token_Index
                            else Row_Pos98 - 1));

      Initialize_Fields_For_Quantified_Expression
        (Self => Transform_Res90, Quantified_Expression_F_Operation => Or_Res36, Quantified_Expression_F_Parameter_Identifier => Defer_Res143, Quantified_Expression_F_Iterable => Defer_Res144, Quantified_Expression_F_Predicate => Defer_Res145);

         if Or_Res36 /= null and then Is_Incomplete (Or_Res36) then
            Transform_Res90.Last_Attempted_Child := 0;
         elsif Or_Res36 /= null and then not Is_Ghost (Or_Res36) then
            Transform_Res90.Last_Attempted_Child := -1;
         end if;
         if Defer_Res143 /= null and then Is_Incomplete (Defer_Res143) then
            Transform_Res90.Last_Attempted_Child := 0;
         elsif Defer_Res143 /= null and then not Is_Ghost (Defer_Res143) then
            Transform_Res90.Last_Attempted_Child := -1;
         end if;
         if Defer_Res144 /= null and then Is_Incomplete (Defer_Res144) then
            Transform_Res90.Last_Attempted_Child := 0;
         elsif Defer_Res144 /= null and then not Is_Ghost (Defer_Res144) then
            Transform_Res90.Last_Attempted_Child := -1;
         end if;
         if Defer_Res145 /= null and then Is_Incomplete (Defer_Res145) then
            Transform_Res90.Last_Attempted_Child := 0;
         elsif Defer_Res145 /= null and then not Is_Ghost (Defer_Res145) then
            Transform_Res90.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos98 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags90);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Quantified_Expression_Transform_Parse2_Memo,
      Row_Pos98 /= No_Token_Index,
      Transform_Res90,
      Pos,
      Row_Pos98);


   Parser.Current_Pos := Row_Pos98;

   return Transform_Res90;
end Quantified_Expression_Transform_Parse2;

   


function Range_Type_Definition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Range_Type_Def
is
   use Bare_Range_Type_Def_Memos;

      Row_Pos101 :
            Token_Index
               := No_Token_Index;
      Token_Pos148 :
            Token_Index
               := No_Token_Index;
      Token_Res148 :
            Token_Index
               := No_Token_Index;
      Defer_Pos146 :
            Token_Index
               := No_Token_Index;
      Defer_Res146 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos149 :
            Token_Index
               := No_Token_Index;
      Token_Res149 :
            Token_Index
               := No_Token_Index;
      Defer_Pos147 :
            Token_Index
               := No_Token_Index;
      Defer_Res147 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos150 :
            Token_Index
               := No_Token_Index;
      Token_Res150 :
            Token_Index
               := No_Token_Index;
      Defer_Pos148 :
            Token_Index
               := No_Token_Index;
      Defer_Res148 :
            Bare_Aspect
               := No_Bare_R_F_L_X_Node;
      Transform_Res91 :
            Bare_Range_Type_Def
               := No_Bare_R_F_L_X_Node;
      Transform_Diags91 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Range_Type_Definition_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res91 := M.Instance;
      return Transform_Res91;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res91;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags91 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos101 := Pos;



--  Start tok_code

Token_Res148 := Row_Pos101;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res148));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Range)
   then
       Token_Pos148 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos101 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos101,
             Expected_Token_Id => Rflx_Range,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos148 := Row_Pos101 + 1;
   end if;
end;

--  End tok_code




if Token_Pos148 /= No_Token_Index then

   Row_Pos101 := Token_Pos148;

else
   Row_Pos101 := No_Token_Index;
   goto Exit_Row101_0;

end if;


Defer_Res146 :=
   Expression_Or_Parse1 (Parser, Row_Pos101);
Defer_Pos146 := Parser.Current_Pos;




if Defer_Pos146 /= No_Token_Index then

   Row_Pos101 := Defer_Pos146;

else
   Row_Pos101 := No_Token_Index;
   goto Exit_Row101_0;

end if;


--  Start tok_code

Token_Res149 := Row_Pos101;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res149));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Double_Dot)
   then
       Token_Pos149 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos101 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos101,
             Expected_Token_Id => Rflx_Double_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos149 := Row_Pos101 + 1;
   end if;
end;

--  End tok_code




if Token_Pos149 /= No_Token_Index then

   Row_Pos101 := Token_Pos149;

else
   Row_Pos101 := No_Token_Index;
   goto Exit_Row101_0;

end if;


Defer_Res147 :=
   Expression_Or_Parse1 (Parser, Row_Pos101);
Defer_Pos147 := Parser.Current_Pos;




if Defer_Pos147 /= No_Token_Index then

   Row_Pos101 := Defer_Pos147;

else
   Row_Pos101 := No_Token_Index;
   goto Exit_Row101_0;

end if;


--  Start tok_code

Token_Res150 := Row_Pos101;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res150));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_With)
   then
       Token_Pos150 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos101 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos101,
             Expected_Token_Id => Rflx_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos150 := Row_Pos101 + 1;
   end if;
end;

--  End tok_code




if Token_Pos150 /= No_Token_Index then

   Row_Pos101 := Token_Pos150;

else
   Row_Pos101 := No_Token_Index;
   goto Exit_Row101_0;

end if;


Defer_Res148 :=
   Aspect_Transform_Parse0 (Parser, Row_Pos101);
Defer_Pos148 := Parser.Current_Pos;




if Defer_Pos148 /= No_Token_Index then

   Row_Pos101 := Defer_Pos148;

else
   Row_Pos101 := No_Token_Index;
   goto Exit_Row101_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row101_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos101 /= No_Token_Index then

   Transform_Res91 := Allocate_Range_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res91,
      Kind => Rflx_Range_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos101 = Pos
                            then No_Token_Index
                            else Row_Pos101 - 1));

      Initialize_Fields_For_Range_Type_Def
        (Self => Transform_Res91, Range_Type_Def_F_First => Defer_Res146, Range_Type_Def_F_Last => Defer_Res147, Range_Type_Def_F_Size => Defer_Res148);

         if Defer_Res146 /= null and then Is_Incomplete (Defer_Res146) then
            Transform_Res91.Last_Attempted_Child := 0;
         elsif Defer_Res146 /= null and then not Is_Ghost (Defer_Res146) then
            Transform_Res91.Last_Attempted_Child := -1;
         end if;
         if Defer_Res147 /= null and then Is_Incomplete (Defer_Res147) then
            Transform_Res91.Last_Attempted_Child := 0;
         elsif Defer_Res147 /= null and then not Is_Ghost (Defer_Res147) then
            Transform_Res91.Last_Attempted_Child := -1;
         end if;
         if Defer_Res148 /= null and then Is_Incomplete (Defer_Res148) then
            Transform_Res91.Last_Attempted_Child := 0;
         elsif Defer_Res148 /= null and then not Is_Ghost (Defer_Res148) then
            Transform_Res91.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos101 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags91);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Range_Type_Definition_Transform_Parse0_Memo,
      Row_Pos101 /= No_Token_Index,
      Transform_Res91,
      Pos,
      Row_Pos101);


   Parser.Current_Pos := Row_Pos101;

   return Transform_Res91;
end Range_Type_Definition_Transform_Parse0;

   


function Relation_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt10 :
            Boolean
               := False;
      Row_Pos102 :
            Token_Index
               := No_Token_Index;
      Defer_Pos149 :
            Token_Index
               := No_Token_Index;
      Defer_Res149 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Pos103 :
            Token_Index
               := No_Token_Index;
      Token_Pos151 :
            Token_Index
               := No_Token_Index;
      Token_Res151 :
            Token_Index
               := No_Token_Index;
      Transform_Res92 :
            Bare_Op_Eq
               := No_Bare_R_F_L_X_Node;
      Transform_Diags92 :
            Ada.Containers.Count_Type;
      Row_Pos104 :
            Token_Index
               := No_Token_Index;
      Token_Pos152 :
            Token_Index
               := No_Token_Index;
      Token_Res152 :
            Token_Index
               := No_Token_Index;
      Transform_Res93 :
            Bare_Op_Neq
               := No_Bare_R_F_L_X_Node;
      Transform_Diags93 :
            Ada.Containers.Count_Type;
      Row_Pos105 :
            Token_Index
               := No_Token_Index;
      Token_Pos153 :
            Token_Index
               := No_Token_Index;
      Token_Res153 :
            Token_Index
               := No_Token_Index;
      Transform_Res94 :
            Bare_Op_Le
               := No_Bare_R_F_L_X_Node;
      Transform_Diags94 :
            Ada.Containers.Count_Type;
      Row_Pos106 :
            Token_Index
               := No_Token_Index;
      Token_Pos154 :
            Token_Index
               := No_Token_Index;
      Token_Res154 :
            Token_Index
               := No_Token_Index;
      Transform_Res95 :
            Bare_Op_Lt
               := No_Bare_R_F_L_X_Node;
      Transform_Diags95 :
            Ada.Containers.Count_Type;
      Row_Pos107 :
            Token_Index
               := No_Token_Index;
      Token_Pos155 :
            Token_Index
               := No_Token_Index;
      Token_Res155 :
            Token_Index
               := No_Token_Index;
      Transform_Res96 :
            Bare_Op_Ge
               := No_Bare_R_F_L_X_Node;
      Transform_Diags96 :
            Ada.Containers.Count_Type;
      Row_Pos108 :
            Token_Index
               := No_Token_Index;
      Token_Pos156 :
            Token_Index
               := No_Token_Index;
      Token_Res156 :
            Token_Index
               := No_Token_Index;
      Transform_Res97 :
            Bare_Op_Gt
               := No_Bare_R_F_L_X_Node;
      Transform_Diags97 :
            Ada.Containers.Count_Type;
      Or_Pos37 :
            Token_Index
               := No_Token_Index;
      Or_Res37 :
            Bare_Op
               := No_Bare_R_F_L_X_Node;
      Defer_Pos150 :
            Token_Index
               := No_Token_Index;
      Defer_Res150 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Progress10 :
            Integer
               := 0;
      Transform_Res98 :
            Bare_Bin_Op
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed10 :
            Boolean
               := False;
      Transform_Diags98 :
            Ada.Containers.Count_Type;
      Defer_Pos151 :
            Token_Index
               := No_Token_Index;
      Defer_Res151 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos38 :
            Token_Index
               := No_Token_Index;
      Or_Res38 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Relation_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res38 := M.Instance;
      return Or_Res38;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res38;
   end if;

       Set (Parser.Private_Part.Relation_Or_Parse1_Memo, False, Or_Res38, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt10 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos38 := No_Token_Index;
Or_Res38 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags98 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos102 := Pos;



Defer_Res149 :=
   Relation_Or_Parse1 (Parser, Row_Pos102);
Defer_Pos149 := Parser.Current_Pos;



Row_Progress10 := 1;

if Defer_Pos149 /= No_Token_Index then

   Row_Pos102 := Defer_Pos149;

else
   Row_Pos102 := No_Token_Index;
   goto Exit_Row102_0;

end if;


--  Start or_code

Or_Pos37 := No_Token_Index;
Or_Res37 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags92 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos103 := Row_Pos102;



--  Start tok_code

Token_Res151 := Row_Pos103;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res151));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Eq)
   then
       Token_Pos151 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos103 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos103,
             Expected_Token_Id => Rflx_Eq,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos151 := Row_Pos103 + 1;
   end if;
end;

--  End tok_code




if Token_Pos151 /= No_Token_Index then

   Row_Pos103 := Token_Pos151;

else
   Row_Pos103 := No_Token_Index;
   goto Exit_Row103_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row103_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos103 /= No_Token_Index then

   Transform_Res92 := Allocate_Op_Eq (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res92,
      Kind => Rflx_Op_Eq,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos102,
      Token_End_Index   => (if Row_Pos103 = Row_Pos102
                            then No_Token_Index
                            else Row_Pos103 - 1));




elsif Row_Pos103 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags92);
end if;

--  End transform_code

    if Row_Pos103 /= No_Token_Index then
        Or_Pos37 := Row_Pos103;
        Or_Res37 := Transform_Res92;
        goto Exit_Or38;
    end if;
    
--  Start transform_code

Transform_Diags93 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos104 := Row_Pos102;



--  Start tok_code

Token_Res152 := Row_Pos104;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res152));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Neq)
   then
       Token_Pos152 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos104 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos104,
             Expected_Token_Id => Rflx_Neq,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos152 := Row_Pos104 + 1;
   end if;
end;

--  End tok_code




if Token_Pos152 /= No_Token_Index then

   Row_Pos104 := Token_Pos152;

else
   Row_Pos104 := No_Token_Index;
   goto Exit_Row104_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row104_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos104 /= No_Token_Index then

   Transform_Res93 := Allocate_Op_Neq (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res93,
      Kind => Rflx_Op_Neq,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos102,
      Token_End_Index   => (if Row_Pos104 = Row_Pos102
                            then No_Token_Index
                            else Row_Pos104 - 1));




elsif Row_Pos104 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags93);
end if;

--  End transform_code

    if Row_Pos104 /= No_Token_Index then
        Or_Pos37 := Row_Pos104;
        Or_Res37 := Transform_Res93;
        goto Exit_Or38;
    end if;
    
--  Start transform_code

Transform_Diags94 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos105 := Row_Pos102;



--  Start tok_code

Token_Res153 := Row_Pos105;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res153));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Le)
   then
       Token_Pos153 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos105 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos105,
             Expected_Token_Id => Rflx_Le,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos153 := Row_Pos105 + 1;
   end if;
end;

--  End tok_code




if Token_Pos153 /= No_Token_Index then

   Row_Pos105 := Token_Pos153;

else
   Row_Pos105 := No_Token_Index;
   goto Exit_Row105_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row105_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos105 /= No_Token_Index then

   Transform_Res94 := Allocate_Op_Le (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res94,
      Kind => Rflx_Op_Le,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos102,
      Token_End_Index   => (if Row_Pos105 = Row_Pos102
                            then No_Token_Index
                            else Row_Pos105 - 1));




elsif Row_Pos105 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags94);
end if;

--  End transform_code

    if Row_Pos105 /= No_Token_Index then
        Or_Pos37 := Row_Pos105;
        Or_Res37 := Transform_Res94;
        goto Exit_Or38;
    end if;
    
--  Start transform_code

Transform_Diags95 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos106 := Row_Pos102;



--  Start tok_code

Token_Res154 := Row_Pos106;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res154));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Lt)
   then
       Token_Pos154 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos106 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos106,
             Expected_Token_Id => Rflx_Lt,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos154 := Row_Pos106 + 1;
   end if;
end;

--  End tok_code




if Token_Pos154 /= No_Token_Index then

   Row_Pos106 := Token_Pos154;

else
   Row_Pos106 := No_Token_Index;
   goto Exit_Row106_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row106_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos106 /= No_Token_Index then

   Transform_Res95 := Allocate_Op_Lt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res95,
      Kind => Rflx_Op_Lt,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos102,
      Token_End_Index   => (if Row_Pos106 = Row_Pos102
                            then No_Token_Index
                            else Row_Pos106 - 1));




elsif Row_Pos106 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags95);
end if;

--  End transform_code

    if Row_Pos106 /= No_Token_Index then
        Or_Pos37 := Row_Pos106;
        Or_Res37 := Transform_Res95;
        goto Exit_Or38;
    end if;
    
--  Start transform_code

Transform_Diags96 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos107 := Row_Pos102;



--  Start tok_code

Token_Res155 := Row_Pos107;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res155));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Ge)
   then
       Token_Pos155 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos107 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos107,
             Expected_Token_Id => Rflx_Ge,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos155 := Row_Pos107 + 1;
   end if;
end;

--  End tok_code




if Token_Pos155 /= No_Token_Index then

   Row_Pos107 := Token_Pos155;

else
   Row_Pos107 := No_Token_Index;
   goto Exit_Row107_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row107_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos107 /= No_Token_Index then

   Transform_Res96 := Allocate_Op_Ge (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res96,
      Kind => Rflx_Op_Ge,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos102,
      Token_End_Index   => (if Row_Pos107 = Row_Pos102
                            then No_Token_Index
                            else Row_Pos107 - 1));




elsif Row_Pos107 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags96);
end if;

--  End transform_code

    if Row_Pos107 /= No_Token_Index then
        Or_Pos37 := Row_Pos107;
        Or_Res37 := Transform_Res96;
        goto Exit_Or38;
    end if;
    
--  Start transform_code

Transform_Diags97 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos108 := Row_Pos102;



--  Start tok_code

Token_Res156 := Row_Pos108;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res156));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Gt)
   then
       Token_Pos156 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos108 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos108,
             Expected_Token_Id => Rflx_Gt,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos156 := Row_Pos108 + 1;
   end if;
end;

--  End tok_code




if Token_Pos156 /= No_Token_Index then

   Row_Pos108 := Token_Pos156;

else
   Row_Pos108 := No_Token_Index;
   goto Exit_Row108_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row108_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos108 /= No_Token_Index then

   Transform_Res97 := Allocate_Op_Gt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res97,
      Kind => Rflx_Op_Gt,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos102,
      Token_End_Index   => (if Row_Pos108 = Row_Pos102
                            then No_Token_Index
                            else Row_Pos108 - 1));




elsif Row_Pos108 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags97);
end if;

--  End transform_code

    if Row_Pos108 /= No_Token_Index then
        Or_Pos37 := Row_Pos108;
        Or_Res37 := Transform_Res97;
        goto Exit_Or38;
    end if;
<<Exit_Or38>>

--  End or_code



Row_Progress10 := 2;

if Or_Pos37 /= No_Token_Index then

   Row_Pos102 := Or_Pos37;

else
   Row_Pos102 := No_Token_Index;
   goto Exit_Row102_0;

end if;

Nobt10 := True;

   Nobt10 := Nobt10;

Row_Progress10 := 3;

if Row_Pos102 /= No_Token_Index then

   Row_Pos102 := Row_Pos102;

else
   Row_Pos102 := No_Token_Index;
   goto Exit_Row102_0;

end if;


Defer_Res150 :=
   Simple_Expr_Or_Parse1 (Parser, Row_Pos102);
Defer_Pos150 := Parser.Current_Pos;



Row_Progress10 := 4;

if Defer_Pos150 /= No_Token_Index then

   Row_Pos102 := Defer_Pos150;

else
   Row_Pos102 := No_Token_Index;
   goto Exit_Row102_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row102_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos102 = No_Token_Index and then Nobt10 then

   Row_Pos102 := Parser.Last_Fail.Pos;

   Transform_Has_Failed10 := True;
end if;

if Row_Pos102 /= No_Token_Index then

   Transform_Res98 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res98,
      Kind => Rflx_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos102 = Pos
                            then No_Token_Index
                            else Row_Pos102 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res98, Bin_Op_F_Left => Defer_Res149, Bin_Op_F_Op => Or_Res37, Bin_Op_F_Right => Defer_Res150);

         if Defer_Res149 /= null and then Is_Incomplete (Defer_Res149) then
            Transform_Res98.Last_Attempted_Child := 0;
         elsif Defer_Res149 /= null and then not Is_Ghost (Defer_Res149) then
            Transform_Res98.Last_Attempted_Child := -1;
         end if;
         if Or_Res37 /= null and then Is_Incomplete (Or_Res37) then
            Transform_Res98.Last_Attempted_Child := 0;
         elsif Or_Res37 /= null and then not Is_Ghost (Or_Res37) then
            Transform_Res98.Last_Attempted_Child := -1;
         end if;
         if Defer_Res150 /= null and then Is_Incomplete (Defer_Res150) then
            Transform_Res98.Last_Attempted_Child := 0;
         elsif Defer_Res150 /= null and then not Is_Ghost (Defer_Res150) then
            Transform_Res98.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed10 then
      Transform_Res98.Last_Attempted_Child :=
         Row_Progress10;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <relation>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos102 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags98);
end if;

--  End transform_code

    if Row_Pos102 /= No_Token_Index then
        Or_Pos38 := Row_Pos102;
        Or_Res38 := Transform_Res98;
        goto Exit_Or37;
    end if;
    
Defer_Res151 :=
   Simple_Expr_Or_Parse1 (Parser, Pos);
Defer_Pos151 := Parser.Current_Pos;

    if Defer_Pos151 /= No_Token_Index then
        Or_Pos38 := Defer_Pos151;
        Or_Res38 := Defer_Res151;
        goto Exit_Or37;
    end if;
<<Exit_Or37>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos38 > Mem_Pos then
         Mem_Pos := Or_Pos38;
         Mem_Res := Or_Res38;
         Set
           (Parser.Private_Part.Relation_Or_Parse1_Memo,
            Or_Pos38 /= No_Token_Index,
            Or_Res38,
            Pos,
            Or_Pos38);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res38 := Mem_Res;
         Or_Pos38 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Relation_Or_Parse1_Memo,
      Or_Pos38 /= No_Token_Index,
      Or_Res38,
      Pos,
      Or_Pos38);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos38;

   return Or_Res38;
end Relation_Or_Parse1;

   


function Renaming_Declaration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Renaming_Decl
is
   use Bare_Renaming_Decl_Memos;

      Row_Pos109 :
            Token_Index
               := No_Token_Index;
      Defer_Pos152 :
            Token_Index
               := No_Token_Index;
      Defer_Res152 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos157 :
            Token_Index
               := No_Token_Index;
      Token_Res157 :
            Token_Index
               := No_Token_Index;
      Defer_Pos153 :
            Token_Index
               := No_Token_Index;
      Defer_Res153 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos158 :
            Token_Index
               := No_Token_Index;
      Token_Res158 :
            Token_Index
               := No_Token_Index;
      Defer_Pos154 :
            Token_Index
               := No_Token_Index;
      Defer_Res154 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res99 :
            Bare_Renaming_Decl
               := No_Bare_R_F_L_X_Node;
      Transform_Diags99 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Renaming_Declaration_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res99 := M.Instance;
      return Transform_Res99;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res99;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags99 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos109 := Pos;



Defer_Res152 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos109);
Defer_Pos152 := Parser.Current_Pos;




if Defer_Pos152 /= No_Token_Index then

   Row_Pos109 := Defer_Pos152;

else
   Row_Pos109 := No_Token_Index;
   goto Exit_Row109_0;

end if;


--  Start tok_code

Token_Res157 := Row_Pos109;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res157));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Colon)
   then
       Token_Pos157 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos109 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos109,
             Expected_Token_Id => Rflx_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos157 := Row_Pos109 + 1;
   end if;
end;

--  End tok_code




if Token_Pos157 /= No_Token_Index then

   Row_Pos109 := Token_Pos157;

else
   Row_Pos109 := No_Token_Index;
   goto Exit_Row109_0;

end if;


Defer_Res153 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Row_Pos109);
Defer_Pos153 := Parser.Current_Pos;




if Defer_Pos153 /= No_Token_Index then

   Row_Pos109 := Defer_Pos153;

else
   Row_Pos109 := No_Token_Index;
   goto Exit_Row109_0;

end if;


--  Start tok_code

Token_Res158 := Row_Pos109;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res158));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Renames)
   then
       Token_Pos158 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos109 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos109,
             Expected_Token_Id => Rflx_Renames,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos158 := Row_Pos109 + 1;
   end if;
end;

--  End tok_code




if Token_Pos158 /= No_Token_Index then

   Row_Pos109 := Token_Pos158;

else
   Row_Pos109 := No_Token_Index;
   goto Exit_Row109_0;

end if;


Defer_Res154 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos109);
Defer_Pos154 := Parser.Current_Pos;




if Defer_Pos154 /= No_Token_Index then

   Row_Pos109 := Defer_Pos154;

else
   Row_Pos109 := No_Token_Index;
   goto Exit_Row109_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row109_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos109 /= No_Token_Index then

   Transform_Res99 := Allocate_Renaming_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res99,
      Kind => Rflx_Renaming_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos109 = Pos
                            then No_Token_Index
                            else Row_Pos109 - 1));

      Initialize_Fields_For_Renaming_Decl
        (Self => Transform_Res99, Renaming_Decl_F_Identifier => Defer_Res152, Renaming_Decl_F_Type_Identifier => Defer_Res153, Renaming_Decl_F_Expression => Defer_Res154);

         if Defer_Res152 /= null and then Is_Incomplete (Defer_Res152) then
            Transform_Res99.Last_Attempted_Child := 0;
         elsif Defer_Res152 /= null and then not Is_Ghost (Defer_Res152) then
            Transform_Res99.Last_Attempted_Child := -1;
         end if;
         if Defer_Res153 /= null and then Is_Incomplete (Defer_Res153) then
            Transform_Res99.Last_Attempted_Child := 0;
         elsif Defer_Res153 /= null and then not Is_Ghost (Defer_Res153) then
            Transform_Res99.Last_Attempted_Child := -1;
         end if;
         if Defer_Res154 /= null and then Is_Incomplete (Defer_Res154) then
            Transform_Res99.Last_Attempted_Child := 0;
         elsif Defer_Res154 /= null and then not Is_Ghost (Defer_Res154) then
            Transform_Res99.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos109 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags99);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Renaming_Declaration_Transform_Parse0_Memo,
      Row_Pos109 /= No_Token_Index,
      Transform_Res99,
      Pos,
      Row_Pos109);


   Parser.Current_Pos := Row_Pos109;

   return Transform_Res99;
end Renaming_Declaration_Transform_Parse0;

   


function Reset_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Reset
is
   use Bare_Reset_Memos;

      Row_Pos110 :
            Token_Index
               := No_Token_Index;
      Defer_Pos155 :
            Token_Index
               := No_Token_Index;
      Defer_Res155 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos159 :
            Token_Index
               := No_Token_Index;
      Token_Res159 :
            Token_Index
               := No_Token_Index;
      Token_Pos160 :
            Token_Index
               := No_Token_Index;
      Token_Res160 :
            Token_Index
               := No_Token_Index;
      Row_Pos111 :
            Token_Index
               := No_Token_Index;
      Token_Pos161 :
            Token_Index
               := No_Token_Index;
      Token_Res161 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos19 :
            Token_Index
               := No_Token_Index;
      Tmp_List19 :
            Free_Parse_List;
      Defer_Pos156 :
            Token_Index
               := No_Token_Index;
      Defer_Res156 :
            Bare_Message_Aggregate_Association
               := No_Bare_R_F_L_X_Node;
      Token_Pos162 :
            Token_Index
               := No_Token_Index;
      Token_Res162 :
            Token_Index
               := No_Token_Index;
      List_Pos19 :
            Token_Index
               := No_Token_Index;
      List_Res19 :
            Bare_Message_Aggregate_Association_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos163 :
            Token_Index
               := No_Token_Index;
      Token_Res163 :
            Token_Index
               := No_Token_Index;
      Transform_Res100 :
            Bare_Reset
               := No_Bare_R_F_L_X_Node;
      Transform_Diags100 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Reset_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res100 := M.Instance;
      return Transform_Res100;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res100;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags100 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos110 := Pos;



Defer_Res155 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos110);
Defer_Pos155 := Parser.Current_Pos;




if Defer_Pos155 /= No_Token_Index then

   Row_Pos110 := Defer_Pos155;

else
   Row_Pos110 := No_Token_Index;
   goto Exit_Row110_0;

end if;


--  Start tok_code

Token_Res159 := Row_Pos110;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res159));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Tick)
   then
       Token_Pos159 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos110 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos110,
             Expected_Token_Id => Rflx_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos159 := Row_Pos110 + 1;
   end if;
end;

--  End tok_code




if Token_Pos159 /= No_Token_Index then

   Row_Pos110 := Token_Pos159;

else
   Row_Pos110 := No_Token_Index;
   goto Exit_Row110_0;

end if;


--  Start tok_code

Token_Res160 := Row_Pos110;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res160));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Reset)
   then
       Token_Pos160 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos110 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos110,
             Expected_Token_Id => Rflx_Reset,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos160 := Row_Pos110 + 1;
   end if;
end;

--  End tok_code




if Token_Pos160 /= No_Token_Index then

   Row_Pos110 := Token_Pos160;

else
   Row_Pos110 := No_Token_Index;
   goto Exit_Row110_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos111 := Row_Pos110;



--  Start tok_code

Token_Res161 := Row_Pos111;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res161));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos161 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos111 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos111,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos161 := Row_Pos111 + 1;
   end if;
end;

--  End tok_code




if Token_Pos161 /= No_Token_Index then

   Row_Pos111 := Token_Pos161;

else
   Row_Pos111 := No_Token_Index;
   goto Exit_Row111_0;

end if;


--  Start list_code

    List_Pos19 := No_Token_Index;



Lst_Cpos19 := Row_Pos111;
Tmp_List19 := Get_Parse_List (Parser);

loop
   
Defer_Res156 :=
   Message_Aggregate_Association_Transform_Parse0 (Parser, Lst_Cpos19);
Defer_Pos156 := Parser.Current_Pos;


   exit when Defer_Pos156 = No_Token_Index;

   List_Pos19 := Defer_Pos156;
   Lst_Cpos19 := List_Pos19;

   Tmp_List19.Nodes.Append (Defer_Res156);

      
--  Start tok_code

Token_Res162 := Lst_Cpos19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res162));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos162 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos19,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos162 := Lst_Cpos19 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos162 /= No_Token_Index then
          Lst_Cpos19 := Token_Pos162;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List19.Nodes.Length;
begin
   List_Res19 :=
      Allocate_Message_Aggregate_Association_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos111;
      Token_End := (if Lst_Cpos19 = Row_Pos111
                    then Row_Pos111
                    else Lst_Cpos19 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos111, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res19,
      Kind              => Rflx_Message_Aggregate_Association_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res19,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List19.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res19.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List19);

--  End list_code




if List_Pos19 /= No_Token_Index then

   Row_Pos111 := List_Pos19;

else
   Row_Pos111 := No_Token_Index;
   goto Exit_Row111_0;

end if;


--  Start tok_code

Token_Res163 := Row_Pos111;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res163));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos163 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos111 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos111,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos163 := Row_Pos111 + 1;
   end if;
end;

--  End tok_code




if Token_Pos163 /= No_Token_Index then

   Row_Pos111 := Token_Pos163;

else
   Row_Pos111 := No_Token_Index;
   goto Exit_Row111_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row111_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos111 = No_Token_Index then

         
   List_Res19 :=
     Allocate_Message_Aggregate_Association_List (Parser.Mem_Pool);
   Initialize
     (Self              => List_Res19,
      Kind              => Rflx_Message_Aggregate_Association_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos110 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => List_Res19,
      Parser => Parser,
      Count  => 0);



       
   Row_Pos111 := Row_Pos110;



end if;

--  End opt_code




if Row_Pos111 /= No_Token_Index then

   Row_Pos110 := Row_Pos111;

else
   Row_Pos110 := No_Token_Index;
   goto Exit_Row110_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row110_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos110 /= No_Token_Index then

   Transform_Res100 := Allocate_Reset (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res100,
      Kind => Rflx_Reset,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos110 = Pos
                            then No_Token_Index
                            else Row_Pos110 - 1));

      Initialize_Fields_For_Reset
        (Self => Transform_Res100, Reset_F_Identifier => Defer_Res155, Reset_F_Associations => List_Res19);

         if Defer_Res155 /= null and then Is_Incomplete (Defer_Res155) then
            Transform_Res100.Last_Attempted_Child := 0;
         elsif Defer_Res155 /= null and then not Is_Ghost (Defer_Res155) then
            Transform_Res100.Last_Attempted_Child := -1;
         end if;
         if List_Res19 /= null and then Is_Incomplete (List_Res19) then
            Transform_Res100.Last_Attempted_Child := 0;
         elsif List_Res19 /= null and then not Is_Ghost (List_Res19) then
            Transform_Res100.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos110 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags100);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Reset_Transform_Parse0_Memo,
      Row_Pos110 /= No_Token_Index,
      Transform_Res100,
      Pos,
      Row_Pos110);


   Parser.Current_Pos := Row_Pos110;

   return Transform_Res100;
end Reset_Transform_Parse0;

   


function Sequence_Aggregate_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Sequence_Aggregate
is
   use Bare_Sequence_Aggregate_Memos;

      Row_Pos112 :
            Token_Index
               := No_Token_Index;
      Token_Pos164 :
            Token_Index
               := No_Token_Index;
      Token_Res164 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos20 :
            Token_Index
               := No_Token_Index;
      Tmp_List20 :
            Free_Parse_List;
      Defer_Pos157 :
            Token_Index
               := No_Token_Index;
      Defer_Res157 :
            Bare_Numeric_Literal
               := No_Bare_R_F_L_X_Node;
      Token_Pos165 :
            Token_Index
               := No_Token_Index;
      Token_Res165 :
            Token_Index
               := No_Token_Index;
      List_Pos20 :
            Token_Index
               := No_Token_Index;
      List_Res20 :
            Bare_Numeric_Literal_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos166 :
            Token_Index
               := No_Token_Index;
      Token_Res166 :
            Token_Index
               := No_Token_Index;
      Transform_Res101 :
            Bare_Sequence_Aggregate
               := No_Bare_R_F_L_X_Node;
      Transform_Diags101 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Sequence_Aggregate_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res101 := M.Instance;
      return Transform_Res101;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res101;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags101 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos112 := Pos;



--  Start tok_code

Token_Res164 := Row_Pos112;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res164));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Brack)
   then
       Token_Pos164 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos112 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos112,
             Expected_Token_Id => Rflx_L_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos164 := Row_Pos112 + 1;
   end if;
end;

--  End tok_code




if Token_Pos164 /= No_Token_Index then

   Row_Pos112 := Token_Pos164;

else
   Row_Pos112 := No_Token_Index;
   goto Exit_Row112_0;

end if;


--  Start list_code

    List_Pos20 := Row_Pos112;



Lst_Cpos20 := Row_Pos112;
Tmp_List20 := Get_Parse_List (Parser);

loop
   
Defer_Res157 :=
   Numeric_Literal_Transform_Parse0 (Parser, Lst_Cpos20);
Defer_Pos157 := Parser.Current_Pos;


   exit when Defer_Pos157 = No_Token_Index;

   List_Pos20 := Defer_Pos157;
   Lst_Cpos20 := List_Pos20;

   Tmp_List20.Nodes.Append (Defer_Res157);

      
--  Start tok_code

Token_Res165 := Lst_Cpos20;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res165));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos165 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos20 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos20,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos165 := Lst_Cpos20 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos165 /= No_Token_Index then
          Lst_Cpos20 := Token_Pos165;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List20.Nodes.Length;
begin
   List_Res20 :=
      Allocate_Numeric_Literal_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos112;
      Token_End := (if Lst_Cpos20 = Row_Pos112
                    then Row_Pos112
                    else Lst_Cpos20 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos112, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res20,
      Kind              => Rflx_Numeric_Literal_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res20,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List20.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res20.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List20);

--  End list_code




if List_Pos20 /= No_Token_Index then

   Row_Pos112 := List_Pos20;

else
   Row_Pos112 := No_Token_Index;
   goto Exit_Row112_0;

end if;


--  Start tok_code

Token_Res166 := Row_Pos112;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res166));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Brack)
   then
       Token_Pos166 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos112 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos112,
             Expected_Token_Id => Rflx_R_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos166 := Row_Pos112 + 1;
   end if;
end;

--  End tok_code




if Token_Pos166 /= No_Token_Index then

   Row_Pos112 := Token_Pos166;

else
   Row_Pos112 := No_Token_Index;
   goto Exit_Row112_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row112_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos112 /= No_Token_Index then

   Transform_Res101 := Allocate_Sequence_Aggregate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res101,
      Kind => Rflx_Sequence_Aggregate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos112 = Pos
                            then No_Token_Index
                            else Row_Pos112 - 1));

      Initialize_Fields_For_Sequence_Aggregate
        (Self => Transform_Res101, Sequence_Aggregate_F_Values => List_Res20);

         if List_Res20 /= null and then Is_Incomplete (List_Res20) then
            Transform_Res101.Last_Attempted_Child := 0;
         elsif List_Res20 /= null and then not Is_Ghost (List_Res20) then
            Transform_Res101.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos112 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags101);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Sequence_Aggregate_Transform_Parse0_Memo,
      Row_Pos112 /= No_Token_Index,
      Transform_Res101,
      Pos,
      Row_Pos112);


   Parser.Current_Pos := Row_Pos112;

   return Transform_Res101;
end Sequence_Aggregate_Transform_Parse0;

   


function Sequence_Type_Definition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Sequence_Type_Def
is
   use Bare_Sequence_Type_Def_Memos;

      Row_Pos113 :
            Token_Index
               := No_Token_Index;
      Token_Pos167 :
            Token_Index
               := No_Token_Index;
      Token_Res167 :
            Token_Index
               := No_Token_Index;
      Token_Pos168 :
            Token_Index
               := No_Token_Index;
      Token_Res168 :
            Token_Index
               := No_Token_Index;
      Defer_Pos158 :
            Token_Index
               := No_Token_Index;
      Defer_Res158 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Transform_Res102 :
            Bare_Sequence_Type_Def
               := No_Bare_R_F_L_X_Node;
      Transform_Diags102 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Sequence_Type_Definition_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res102 := M.Instance;
      return Transform_Res102;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res102;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags102 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos113 := Pos;



--  Start tok_code

Token_Res167 := Row_Pos113;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res167));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Sequence)
   then
       Token_Pos167 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos113 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos113,
             Expected_Token_Id => Rflx_Sequence,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos167 := Row_Pos113 + 1;
   end if;
end;

--  End tok_code




if Token_Pos167 /= No_Token_Index then

   Row_Pos113 := Token_Pos167;

else
   Row_Pos113 := No_Token_Index;
   goto Exit_Row113_0;

end if;


--  Start tok_code

Token_Res168 := Row_Pos113;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res168));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Of)
   then
       Token_Pos168 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos113 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos113,
             Expected_Token_Id => Rflx_Of,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos168 := Row_Pos113 + 1;
   end if;
end;

--  End tok_code




if Token_Pos168 /= No_Token_Index then

   Row_Pos113 := Token_Pos168;

else
   Row_Pos113 := No_Token_Index;
   goto Exit_Row113_0;

end if;


Defer_Res158 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Row_Pos113);
Defer_Pos158 := Parser.Current_Pos;




if Defer_Pos158 /= No_Token_Index then

   Row_Pos113 := Defer_Pos158;

else
   Row_Pos113 := No_Token_Index;
   goto Exit_Row113_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row113_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos113 /= No_Token_Index then

   Transform_Res102 := Allocate_Sequence_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res102,
      Kind => Rflx_Sequence_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos113 = Pos
                            then No_Token_Index
                            else Row_Pos113 - 1));

      Initialize_Fields_For_Sequence_Type_Def
        (Self => Transform_Res102, Sequence_Type_Def_F_Element_Type => Defer_Res158);

         if Defer_Res158 /= null and then Is_Incomplete (Defer_Res158) then
            Transform_Res102.Last_Attempted_Child := 0;
         elsif Defer_Res158 /= null and then not Is_Ghost (Defer_Res158) then
            Transform_Res102.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos113 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags102);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Sequence_Type_Definition_Transform_Parse0_Memo,
      Row_Pos113 /= No_Token_Index,
      Transform_Res102,
      Pos,
      Row_Pos113);


   Parser.Current_Pos := Row_Pos113;

   return Transform_Res102;
end Sequence_Type_Definition_Transform_Parse0;

   


function Session_Declaration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Session_Decl
is
   use Bare_Session_Decl_Memos;

      Row_Pos114 :
            Token_Index
               := No_Token_Index;
      Token_Pos169 :
            Token_Index
               := No_Token_Index;
      Token_Res169 :
            Token_Index
               := No_Token_Index;
      Row_Pos115 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos21 :
            Token_Index
               := No_Token_Index;
      Tmp_List21 :
            Free_Parse_List;
      Defer_Pos159 :
            Token_Index
               := No_Token_Index;
      Defer_Res159 :
            Bare_Formal_Decl
               := No_Bare_R_F_L_X_Node;
      Token_Pos170 :
            Token_Index
               := No_Token_Index;
      Token_Res170 :
            Token_Index
               := No_Token_Index;
      List_Pos21 :
            Token_Index
               := No_Token_Index;
      List_Res21 :
            Bare_Formal_Decl_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos171 :
            Token_Index
               := No_Token_Index;
      Token_Res171 :
            Token_Index
               := No_Token_Index;
      Token_Pos172 :
            Token_Index
               := No_Token_Index;
      Token_Res172 :
            Token_Index
               := No_Token_Index;
      Defer_Pos160 :
            Token_Index
               := No_Token_Index;
      Defer_Res160 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos173 :
            Token_Index
               := No_Token_Index;
      Token_Res173 :
            Token_Index
               := No_Token_Index;
      Row_Pos116 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos22 :
            Token_Index
               := No_Token_Index;
      Tmp_List22 :
            Free_Parse_List;
      Defer_Pos161 :
            Token_Index
               := No_Token_Index;
      Defer_Res161 :
            Bare_Local_Decl
               := No_Bare_R_F_L_X_Node;
      Token_Pos174 :
            Token_Index
               := No_Token_Index;
      Token_Res174 :
            Token_Index
               := No_Token_Index;
      List_Pos22 :
            Token_Index
               := No_Token_Index;
      List_Res22 :
            Bare_Local_Decl_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos175 :
            Token_Index
               := No_Token_Index;
      Token_Res175 :
            Token_Index
               := No_Token_Index;
      Token_Pos176 :
            Token_Index
               := No_Token_Index;
      Token_Res176 :
            Token_Index
               := No_Token_Index;
      Row_Pos117 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos23 :
            Token_Index
               := No_Token_Index;
      Tmp_List23 :
            Free_Parse_List;
      Defer_Pos162 :
            Token_Index
               := No_Token_Index;
      Defer_Res162 :
            Bare_State
               := No_Bare_R_F_L_X_Node;
      Token_Pos177 :
            Token_Index
               := No_Token_Index;
      Token_Res177 :
            Token_Index
               := No_Token_Index;
      List_Pos23 :
            Token_Index
               := No_Token_Index;
      List_Res23 :
            Bare_State_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos178 :
            Token_Index
               := No_Token_Index;
      Token_Res178 :
            Token_Index
               := No_Token_Index;
      Token_Pos179 :
            Token_Index
               := No_Token_Index;
      Token_Res179 :
            Token_Index
               := No_Token_Index;
      Defer_Pos163 :
            Token_Index
               := No_Token_Index;
      Defer_Res163 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Transform_Res103 :
            Bare_Session_Decl
               := No_Bare_R_F_L_X_Node;
      Transform_Diags103 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Session_Declaration_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res103 := M.Instance;
      return Transform_Res103;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res103;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags103 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos114 := Pos;



--  Start tok_code

Token_Res169 := Row_Pos114;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res169));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Generic)
   then
       Token_Pos169 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos114 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos114,
             Expected_Token_Id => Rflx_Generic,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos169 := Row_Pos114 + 1;
   end if;
end;

--  End tok_code




if Token_Pos169 /= No_Token_Index then

   Row_Pos114 := Token_Pos169;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos115 := Row_Pos114;



--  Start list_code

    List_Pos21 := No_Token_Index;



Lst_Cpos21 := Row_Pos115;
Tmp_List21 := Get_Parse_List (Parser);

loop
   
Defer_Res159 :=
   Session_Parameter_Or_Parse0 (Parser, Lst_Cpos21);
Defer_Pos159 := Parser.Current_Pos;


   exit when Defer_Pos159 = No_Token_Index;

   List_Pos21 := Defer_Pos159;
   Lst_Cpos21 := List_Pos21;

   Tmp_List21.Nodes.Append (Defer_Res159);

      
--  Start tok_code

Token_Res170 := Lst_Cpos21;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res170));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos170 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos21 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos21,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos170 := Lst_Cpos21 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos170 /= No_Token_Index then
          Lst_Cpos21 := Token_Pos170;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List21.Nodes.Length;
begin
   List_Res21 :=
      Allocate_Formal_Decl_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos115;
      Token_End := (if Lst_Cpos21 = Row_Pos115
                    then Row_Pos115
                    else Lst_Cpos21 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos115, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res21,
      Kind              => Rflx_Formal_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res21,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List21.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res21.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List21);

--  End list_code




if List_Pos21 /= No_Token_Index then

   Row_Pos115 := List_Pos21;

else
   Row_Pos115 := No_Token_Index;
   goto Exit_Row115_0;

end if;


--  Start tok_code

Token_Res171 := Row_Pos115;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res171));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos171 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos115 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos115,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos171 := Row_Pos115 + 1;
   end if;
end;

--  End tok_code




if Token_Pos171 /= No_Token_Index then

   Row_Pos115 := Token_Pos171;

else
   Row_Pos115 := No_Token_Index;
   goto Exit_Row115_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row115_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos115 = No_Token_Index then

         
   List_Res21 :=
     Allocate_Formal_Decl_List (Parser.Mem_Pool);
   Initialize
     (Self              => List_Res21,
      Kind              => Rflx_Formal_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos114 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => List_Res21,
      Parser => Parser,
      Count  => 0);



       
   Row_Pos115 := Row_Pos114;



end if;

--  End opt_code




if Row_Pos115 /= No_Token_Index then

   Row_Pos114 := Row_Pos115;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;


--  Start tok_code

Token_Res172 := Row_Pos114;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res172));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Session)
   then
       Token_Pos172 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos114 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos114,
             Expected_Token_Id => Rflx_Session,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos172 := Row_Pos114 + 1;
   end if;
end;

--  End tok_code




if Token_Pos172 /= No_Token_Index then

   Row_Pos114 := Token_Pos172;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;


Defer_Res160 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos114);
Defer_Pos160 := Parser.Current_Pos;




if Defer_Pos160 /= No_Token_Index then

   Row_Pos114 := Defer_Pos160;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;


--  Start tok_code

Token_Res173 := Row_Pos114;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res173));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Is)
   then
       Token_Pos173 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos114 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos114,
             Expected_Token_Id => Rflx_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos173 := Row_Pos114 + 1;
   end if;
end;

--  End tok_code




if Token_Pos173 /= No_Token_Index then

   Row_Pos114 := Token_Pos173;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos116 := Row_Pos114;



--  Start list_code

    List_Pos22 := No_Token_Index;



Lst_Cpos22 := Row_Pos116;
Tmp_List22 := Get_Parse_List (Parser);

loop
   
Defer_Res161 :=
   Declaration_Or_Parse0 (Parser, Lst_Cpos22);
Defer_Pos161 := Parser.Current_Pos;


   exit when Defer_Pos161 = No_Token_Index;

   List_Pos22 := Defer_Pos161;
   Lst_Cpos22 := List_Pos22;

   Tmp_List22.Nodes.Append (Defer_Res161);

      
--  Start tok_code

Token_Res174 := Lst_Cpos22;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res174));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos174 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos22 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos22,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos174 := Lst_Cpos22 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos174 /= No_Token_Index then
          Lst_Cpos22 := Token_Pos174;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List22.Nodes.Length;
begin
   List_Res22 :=
      Allocate_Local_Decl_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos116;
      Token_End := (if Lst_Cpos22 = Row_Pos116
                    then Row_Pos116
                    else Lst_Cpos22 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos116, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res22,
      Kind              => Rflx_Local_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res22,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List22.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res22.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List22);

--  End list_code




if List_Pos22 /= No_Token_Index then

   Row_Pos116 := List_Pos22;

else
   Row_Pos116 := No_Token_Index;
   goto Exit_Row116_0;

end if;


--  Start tok_code

Token_Res175 := Row_Pos116;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res175));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos175 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos116 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos116,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos175 := Row_Pos116 + 1;
   end if;
end;

--  End tok_code




if Token_Pos175 /= No_Token_Index then

   Row_Pos116 := Token_Pos175;

else
   Row_Pos116 := No_Token_Index;
   goto Exit_Row116_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row116_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos116 = No_Token_Index then

         
   List_Res22 :=
     Allocate_Local_Decl_List (Parser.Mem_Pool);
   Initialize
     (Self              => List_Res22,
      Kind              => Rflx_Local_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos114 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => List_Res22,
      Parser => Parser,
      Count  => 0);



       
   Row_Pos116 := Row_Pos114;



end if;

--  End opt_code




if Row_Pos116 /= No_Token_Index then

   Row_Pos114 := Row_Pos116;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;


--  Start tok_code

Token_Res176 := Row_Pos114;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res176));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Begin)
   then
       Token_Pos176 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos114 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos114,
             Expected_Token_Id => Rflx_Begin,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos176 := Row_Pos114 + 1;
   end if;
end;

--  End tok_code




if Token_Pos176 /= No_Token_Index then

   Row_Pos114 := Token_Pos176;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos117 := Row_Pos114;



--  Start list_code

    List_Pos23 := No_Token_Index;



Lst_Cpos23 := Row_Pos117;
Tmp_List23 := Get_Parse_List (Parser);

loop
   
Defer_Res162 :=
   State_Transform_Parse0 (Parser, Lst_Cpos23);
Defer_Pos162 := Parser.Current_Pos;


   exit when Defer_Pos162 = No_Token_Index;

   List_Pos23 := Defer_Pos162;
   Lst_Cpos23 := List_Pos23;

   Tmp_List23.Nodes.Append (Defer_Res162);

      
--  Start tok_code

Token_Res177 := Lst_Cpos23;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res177));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos177 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos23 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos23,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos177 := Lst_Cpos23 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos177 /= No_Token_Index then
          Lst_Cpos23 := Token_Pos177;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List23.Nodes.Length;
begin
   List_Res23 :=
      Allocate_State_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos117;
      Token_End := (if Lst_Cpos23 = Row_Pos117
                    then Row_Pos117
                    else Lst_Cpos23 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos117, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res23,
      Kind              => Rflx_State_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res23,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List23.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res23.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List23);

--  End list_code




if List_Pos23 /= No_Token_Index then

   Row_Pos117 := List_Pos23;

else
   Row_Pos117 := No_Token_Index;
   goto Exit_Row117_0;

end if;


--  Start tok_code

Token_Res178 := Row_Pos117;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res178));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos178 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos117 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos117,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos178 := Row_Pos117 + 1;
   end if;
end;

--  End tok_code




if Token_Pos178 /= No_Token_Index then

   Row_Pos117 := Token_Pos178;

else
   Row_Pos117 := No_Token_Index;
   goto Exit_Row117_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row117_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos117 = No_Token_Index then

         
   List_Res23 :=
     Allocate_State_List (Parser.Mem_Pool);
   Initialize
     (Self              => List_Res23,
      Kind              => Rflx_State_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos114 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => List_Res23,
      Parser => Parser,
      Count  => 0);



       
   Row_Pos117 := Row_Pos114;



end if;

--  End opt_code




if Row_Pos117 /= No_Token_Index then

   Row_Pos114 := Row_Pos117;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;


--  Start tok_code

Token_Res179 := Row_Pos114;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res179));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_End)
   then
       Token_Pos179 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos114 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos114,
             Expected_Token_Id => Rflx_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos179 := Row_Pos114 + 1;
   end if;
end;

--  End tok_code




if Token_Pos179 /= No_Token_Index then

   Row_Pos114 := Token_Pos179;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;


Defer_Res163 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos114);
Defer_Pos163 := Parser.Current_Pos;




if Defer_Pos163 /= No_Token_Index then

   Row_Pos114 := Defer_Pos163;

else
   Row_Pos114 := No_Token_Index;
   goto Exit_Row114_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row114_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos114 /= No_Token_Index then

   Transform_Res103 := Allocate_Session_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res103,
      Kind => Rflx_Session_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos114 = Pos
                            then No_Token_Index
                            else Row_Pos114 - 1));

      Initialize_Fields_For_Session_Decl
        (Self => Transform_Res103, Session_Decl_F_Parameters => List_Res21, Session_Decl_F_Identifier => Defer_Res160, Session_Decl_F_Declarations => List_Res22, Session_Decl_F_States => List_Res23, Session_Decl_F_End_Identifier => Defer_Res163);

         if List_Res21 /= null and then Is_Incomplete (List_Res21) then
            Transform_Res103.Last_Attempted_Child := 0;
         elsif List_Res21 /= null and then not Is_Ghost (List_Res21) then
            Transform_Res103.Last_Attempted_Child := -1;
         end if;
         if Defer_Res160 /= null and then Is_Incomplete (Defer_Res160) then
            Transform_Res103.Last_Attempted_Child := 0;
         elsif Defer_Res160 /= null and then not Is_Ghost (Defer_Res160) then
            Transform_Res103.Last_Attempted_Child := -1;
         end if;
         if List_Res22 /= null and then Is_Incomplete (List_Res22) then
            Transform_Res103.Last_Attempted_Child := 0;
         elsif List_Res22 /= null and then not Is_Ghost (List_Res22) then
            Transform_Res103.Last_Attempted_Child := -1;
         end if;
         if List_Res23 /= null and then Is_Incomplete (List_Res23) then
            Transform_Res103.Last_Attempted_Child := 0;
         elsif List_Res23 /= null and then not Is_Ghost (List_Res23) then
            Transform_Res103.Last_Attempted_Child := -1;
         end if;
         if Defer_Res163 /= null and then Is_Incomplete (Defer_Res163) then
            Transform_Res103.Last_Attempted_Child := 0;
         elsif Defer_Res163 /= null and then not Is_Ghost (Defer_Res163) then
            Transform_Res103.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos114 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags103);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Session_Declaration_Transform_Parse0_Memo,
      Row_Pos114 /= No_Token_Index,
      Transform_Res103,
      Pos,
      Row_Pos114);


   Parser.Current_Pos := Row_Pos114;

   return Transform_Res103;
end Session_Declaration_Transform_Parse0;

   


function Session_Parameter_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Decl
is
   use Bare_Formal_Decl_Memos;

      Defer_Pos164 :
            Token_Index
               := No_Token_Index;
      Defer_Res164 :
            Bare_Formal_Function_Decl
               := No_Bare_R_F_L_X_Node;
      Defer_Pos165 :
            Token_Index
               := No_Token_Index;
      Defer_Res165 :
            Bare_Formal_Channel_Decl
               := No_Bare_R_F_L_X_Node;
      Or_Pos39 :
            Token_Index
               := No_Token_Index;
      Or_Res39 :
            Bare_Formal_Decl
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Session_Parameter_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res39 := M.Instance;
      return Or_Res39;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res39;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos39 := No_Token_Index;
Or_Res39 := No_Bare_R_F_L_X_Node;
    
Defer_Res164 :=
   Formal_Function_Declaration_Transform_Parse0 (Parser, Pos);
Defer_Pos164 := Parser.Current_Pos;

    if Defer_Pos164 /= No_Token_Index then
        Or_Pos39 := Defer_Pos164;
        Or_Res39 := Defer_Res164;
        goto Exit_Or39;
    end if;
    
Defer_Res165 :=
   Channel_Declaration_Transform_Parse2 (Parser, Pos);
Defer_Pos165 := Parser.Current_Pos;

    if Defer_Pos165 /= No_Token_Index then
        Or_Pos39 := Defer_Pos165;
        Or_Res39 := Defer_Res165;
        goto Exit_Or39;
    end if;
<<Exit_Or39>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Session_Parameter_Or_Parse0_Memo,
      Or_Pos39 /= No_Token_Index,
      Or_Res39,
      Pos,
      Or_Pos39);


   Parser.Current_Pos := Or_Pos39;

   return Or_Res39;
end Session_Parameter_Or_Parse0;

   


function Simple_Expr_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt11 :
            Boolean
               := False;
      Row_Pos118 :
            Token_Index
               := No_Token_Index;
      Defer_Pos166 :
            Token_Index
               := No_Token_Index;
      Defer_Res166 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Pos119 :
            Token_Index
               := No_Token_Index;
      Token_Pos180 :
            Token_Index
               := No_Token_Index;
      Token_Res180 :
            Token_Index
               := No_Token_Index;
      Transform_Res104 :
            Bare_Op_Add
               := No_Bare_R_F_L_X_Node;
      Transform_Diags104 :
            Ada.Containers.Count_Type;
      Row_Pos120 :
            Token_Index
               := No_Token_Index;
      Token_Pos181 :
            Token_Index
               := No_Token_Index;
      Token_Res181 :
            Token_Index
               := No_Token_Index;
      Transform_Res105 :
            Bare_Op_Sub
               := No_Bare_R_F_L_X_Node;
      Transform_Diags105 :
            Ada.Containers.Count_Type;
      Or_Pos40 :
            Token_Index
               := No_Token_Index;
      Or_Res40 :
            Bare_Op
               := No_Bare_R_F_L_X_Node;
      Defer_Pos167 :
            Token_Index
               := No_Token_Index;
      Defer_Res167 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Progress11 :
            Integer
               := 0;
      Transform_Res106 :
            Bare_Bin_Op
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed11 :
            Boolean
               := False;
      Transform_Diags106 :
            Ada.Containers.Count_Type;
      Defer_Pos168 :
            Token_Index
               := No_Token_Index;
      Defer_Res168 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos41 :
            Token_Index
               := No_Token_Index;
      Or_Res41 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Simple_Expr_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res41 := M.Instance;
      return Or_Res41;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res41;
   end if;

       Set (Parser.Private_Part.Simple_Expr_Or_Parse1_Memo, False, Or_Res41, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt11 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos41 := No_Token_Index;
Or_Res41 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags106 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos118 := Pos;



Defer_Res166 :=
   Simple_Expr_Or_Parse1 (Parser, Row_Pos118);
Defer_Pos166 := Parser.Current_Pos;



Row_Progress11 := 1;

if Defer_Pos166 /= No_Token_Index then

   Row_Pos118 := Defer_Pos166;

else
   Row_Pos118 := No_Token_Index;
   goto Exit_Row118_0;

end if;


--  Start or_code

Or_Pos40 := No_Token_Index;
Or_Res40 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags104 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos119 := Row_Pos118;



--  Start tok_code

Token_Res180 := Row_Pos119;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res180));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Add)
   then
       Token_Pos180 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos119 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos119,
             Expected_Token_Id => Rflx_Add,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos180 := Row_Pos119 + 1;
   end if;
end;

--  End tok_code




if Token_Pos180 /= No_Token_Index then

   Row_Pos119 := Token_Pos180;

else
   Row_Pos119 := No_Token_Index;
   goto Exit_Row119_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row119_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos119 /= No_Token_Index then

   Transform_Res104 := Allocate_Op_Add (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res104,
      Kind => Rflx_Op_Add,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos118,
      Token_End_Index   => (if Row_Pos119 = Row_Pos118
                            then No_Token_Index
                            else Row_Pos119 - 1));




elsif Row_Pos119 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags104);
end if;

--  End transform_code

    if Row_Pos119 /= No_Token_Index then
        Or_Pos40 := Row_Pos119;
        Or_Res40 := Transform_Res104;
        goto Exit_Or41;
    end if;
    
--  Start transform_code

Transform_Diags105 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos120 := Row_Pos118;



--  Start tok_code

Token_Res181 := Row_Pos120;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res181));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Sub)
   then
       Token_Pos181 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos120 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos120,
             Expected_Token_Id => Rflx_Sub,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos181 := Row_Pos120 + 1;
   end if;
end;

--  End tok_code




if Token_Pos181 /= No_Token_Index then

   Row_Pos120 := Token_Pos181;

else
   Row_Pos120 := No_Token_Index;
   goto Exit_Row120_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row120_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos120 /= No_Token_Index then

   Transform_Res105 := Allocate_Op_Sub (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res105,
      Kind => Rflx_Op_Sub,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos118,
      Token_End_Index   => (if Row_Pos120 = Row_Pos118
                            then No_Token_Index
                            else Row_Pos120 - 1));




elsif Row_Pos120 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags105);
end if;

--  End transform_code

    if Row_Pos120 /= No_Token_Index then
        Or_Pos40 := Row_Pos120;
        Or_Res40 := Transform_Res105;
        goto Exit_Or41;
    end if;
<<Exit_Or41>>

--  End or_code



Row_Progress11 := 2;

if Or_Pos40 /= No_Token_Index then

   Row_Pos118 := Or_Pos40;

else
   Row_Pos118 := No_Token_Index;
   goto Exit_Row118_0;

end if;

Nobt11 := True;

   Nobt11 := Nobt11;

Row_Progress11 := 3;

if Row_Pos118 /= No_Token_Index then

   Row_Pos118 := Row_Pos118;

else
   Row_Pos118 := No_Token_Index;
   goto Exit_Row118_0;

end if;


Defer_Res167 :=
   Unop_Term_Or_Parse0 (Parser, Row_Pos118);
Defer_Pos167 := Parser.Current_Pos;



Row_Progress11 := 4;

if Defer_Pos167 /= No_Token_Index then

   Row_Pos118 := Defer_Pos167;

else
   Row_Pos118 := No_Token_Index;
   goto Exit_Row118_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row118_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos118 = No_Token_Index and then Nobt11 then

   Row_Pos118 := Parser.Last_Fail.Pos;

   Transform_Has_Failed11 := True;
end if;

if Row_Pos118 /= No_Token_Index then

   Transform_Res106 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res106,
      Kind => Rflx_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos118 = Pos
                            then No_Token_Index
                            else Row_Pos118 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res106, Bin_Op_F_Left => Defer_Res166, Bin_Op_F_Op => Or_Res40, Bin_Op_F_Right => Defer_Res167);

         if Defer_Res166 /= null and then Is_Incomplete (Defer_Res166) then
            Transform_Res106.Last_Attempted_Child := 0;
         elsif Defer_Res166 /= null and then not Is_Ghost (Defer_Res166) then
            Transform_Res106.Last_Attempted_Child := -1;
         end if;
         if Or_Res40 /= null and then Is_Incomplete (Or_Res40) then
            Transform_Res106.Last_Attempted_Child := 0;
         elsif Or_Res40 /= null and then not Is_Ghost (Or_Res40) then
            Transform_Res106.Last_Attempted_Child := -1;
         end if;
         if Defer_Res167 /= null and then Is_Incomplete (Defer_Res167) then
            Transform_Res106.Last_Attempted_Child := 0;
         elsif Defer_Res167 /= null and then not Is_Ghost (Defer_Res167) then
            Transform_Res106.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed11 then
      Transform_Res106.Last_Attempted_Child :=
         Row_Progress11;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <simple_expr>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos118 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags106);
end if;

--  End transform_code

    if Row_Pos118 /= No_Token_Index then
        Or_Pos41 := Row_Pos118;
        Or_Res41 := Transform_Res106;
        goto Exit_Or40;
    end if;
    
Defer_Res168 :=
   Unop_Term_Or_Parse0 (Parser, Pos);
Defer_Pos168 := Parser.Current_Pos;

    if Defer_Pos168 /= No_Token_Index then
        Or_Pos41 := Defer_Pos168;
        Or_Res41 := Defer_Res168;
        goto Exit_Or40;
    end if;
<<Exit_Or40>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos41 > Mem_Pos then
         Mem_Pos := Or_Pos41;
         Mem_Res := Or_Res41;
         Set
           (Parser.Private_Part.Simple_Expr_Or_Parse1_Memo,
            Or_Pos41 /= No_Token_Index,
            Or_Res41,
            Pos,
            Or_Pos41);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res41 := Mem_Res;
         Or_Pos41 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Simple_Expr_Or_Parse1_Memo,
      Or_Pos41 /= No_Token_Index,
      Or_Res41,
      Pos,
      Or_Pos41);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos41;

   return Or_Res41;
end Simple_Expr_Or_Parse1;

   


function Specification_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Specification
is
   use Bare_Specification_Memos;

      Row_Pos121 :
            Token_Index
               := No_Token_Index;
      Defer_Pos169 :
            Token_Index
               := No_Token_Index;
      Defer_Res169 :
            Bare_Context_Item_List
               := No_Bare_R_F_L_X_Node;
      Defer_Pos170 :
            Token_Index
               := No_Token_Index;
      Defer_Res170 :
            Bare_Package_Node
               := No_Bare_R_F_L_X_Node;
      Transform_Res107 :
            Bare_Specification
               := No_Bare_R_F_L_X_Node;
      Transform_Diags107 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Specification_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res107 := M.Instance;
      return Transform_Res107;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res107;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags107 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos121 := Pos;



Defer_Res169 :=
   Context_Clause_List_Parse0 (Parser, Row_Pos121);
Defer_Pos169 := Parser.Current_Pos;




if Defer_Pos169 /= No_Token_Index then

   Row_Pos121 := Defer_Pos169;

else
   Row_Pos121 := No_Token_Index;
   goto Exit_Row121_0;

end if;


Defer_Res170 :=
   Package_Declaration_Transform_Parse0 (Parser, Row_Pos121);
Defer_Pos170 := Parser.Current_Pos;




if Defer_Pos170 /= No_Token_Index then

   Row_Pos121 := Defer_Pos170;

else
   Row_Pos121 := No_Token_Index;
   goto Exit_Row121_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row121_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos121 /= No_Token_Index then

   Transform_Res107 := Allocate_Specification (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res107,
      Kind => Rflx_Specification,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos121 = Pos
                            then No_Token_Index
                            else Row_Pos121 - 1));

      Initialize_Fields_For_Specification
        (Self => Transform_Res107, Specification_F_Context_Clause => Defer_Res169, Specification_F_Package_Declaration => Defer_Res170);

         if Defer_Res169 /= null and then Is_Incomplete (Defer_Res169) then
            Transform_Res107.Last_Attempted_Child := 0;
         elsif Defer_Res169 /= null and then not Is_Ghost (Defer_Res169) then
            Transform_Res107.Last_Attempted_Child := -1;
         end if;
         if Defer_Res170 /= null and then Is_Incomplete (Defer_Res170) then
            Transform_Res107.Last_Attempted_Child := 0;
         elsif Defer_Res170 /= null and then not Is_Ghost (Defer_Res170) then
            Transform_Res107.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos121 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags107);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Specification_Transform_Parse0_Memo,
      Row_Pos121 /= No_Token_Index,
      Transform_Res107,
      Pos,
      Row_Pos121);


   Parser.Current_Pos := Row_Pos121;

   return Transform_Res107;
end Specification_Transform_Parse0;

   


function State_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_State
is
   use Bare_State_Memos;

      Row_Pos122 :
            Token_Index
               := No_Token_Index;
      Token_Pos182 :
            Token_Index
               := No_Token_Index;
      Token_Res182 :
            Token_Index
               := No_Token_Index;
      Defer_Pos171 :
            Token_Index
               := No_Token_Index;
      Defer_Res171 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Row_Pos123 :
            Token_Index
               := No_Token_Index;
      Token_Pos183 :
            Token_Index
               := No_Token_Index;
      Token_Res183 :
            Token_Index
               := No_Token_Index;
      Defer_Pos172 :
            Token_Index
               := No_Token_Index;
      Defer_Res172 :
            Bare_Description
               := No_Bare_R_F_L_X_Node;
      Token_Pos184 :
            Token_Index
               := No_Token_Index;
      Token_Res184 :
            Token_Index
               := No_Token_Index;
      Defer_Pos173 :
            Token_Index
               := No_Token_Index;
      Defer_Res173 :
            Bare_State_Body
               := No_Bare_R_F_L_X_Node;
      Transform_Res108 :
            Bare_State
               := No_Bare_R_F_L_X_Node;
      Transform_Diags108 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.State_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res108 := M.Instance;
      return Transform_Res108;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res108;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags108 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos122 := Pos;



--  Start tok_code

Token_Res182 := Row_Pos122;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res182));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_State)
   then
       Token_Pos182 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos122 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos122,
             Expected_Token_Id => Rflx_State,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos182 := Row_Pos122 + 1;
   end if;
end;

--  End tok_code




if Token_Pos182 /= No_Token_Index then

   Row_Pos122 := Token_Pos182;

else
   Row_Pos122 := No_Token_Index;
   goto Exit_Row122_0;

end if;


Defer_Res171 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos122);
Defer_Pos171 := Parser.Current_Pos;




if Defer_Pos171 /= No_Token_Index then

   Row_Pos122 := Defer_Pos171;

else
   Row_Pos122 := No_Token_Index;
   goto Exit_Row122_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos123 := Row_Pos122;



--  Start tok_code

Token_Res183 := Row_Pos123;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res183));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_With)
   then
       Token_Pos183 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos123 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos123,
             Expected_Token_Id => Rflx_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos183 := Row_Pos123 + 1;
   end if;
end;

--  End tok_code




if Token_Pos183 /= No_Token_Index then

   Row_Pos123 := Token_Pos183;

else
   Row_Pos123 := No_Token_Index;
   goto Exit_Row123_0;

end if;


Defer_Res172 :=
   Description_Aspect_Transform_Parse0 (Parser, Row_Pos123);
Defer_Pos172 := Parser.Current_Pos;




if Defer_Pos172 /= No_Token_Index then

   Row_Pos123 := Defer_Pos172;

else
   Row_Pos123 := No_Token_Index;
   goto Exit_Row123_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row123_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos123 = No_Token_Index then

         
   Defer_Res172 := No_Bare_R_F_L_X_Node;



       
   Row_Pos123 := Row_Pos122;



end if;

--  End opt_code




if Row_Pos123 /= No_Token_Index then

   Row_Pos122 := Row_Pos123;

else
   Row_Pos122 := No_Token_Index;
   goto Exit_Row122_0;

end if;


--  Start tok_code

Token_Res184 := Row_Pos122;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res184));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Is)
   then
       Token_Pos184 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos122 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos122,
             Expected_Token_Id => Rflx_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos184 := Row_Pos122 + 1;
   end if;
end;

--  End tok_code




if Token_Pos184 /= No_Token_Index then

   Row_Pos122 := Token_Pos184;

else
   Row_Pos122 := No_Token_Index;
   goto Exit_Row122_0;

end if;


Defer_Res173 :=
   State_Body_Transform_Parse0 (Parser, Row_Pos122);
Defer_Pos173 := Parser.Current_Pos;




if Defer_Pos173 /= No_Token_Index then

   Row_Pos122 := Defer_Pos173;

else
   Row_Pos122 := No_Token_Index;
   goto Exit_Row122_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row122_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos122 /= No_Token_Index then

   Transform_Res108 := Allocate_State (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res108,
      Kind => Rflx_State,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos122 = Pos
                            then No_Token_Index
                            else Row_Pos122 - 1));

      Initialize_Fields_For_State
        (Self => Transform_Res108, State_F_Identifier => Defer_Res171, State_F_Description => Defer_Res172, State_F_Body => Defer_Res173);

         if Defer_Res171 /= null and then Is_Incomplete (Defer_Res171) then
            Transform_Res108.Last_Attempted_Child := 0;
         elsif Defer_Res171 /= null and then not Is_Ghost (Defer_Res171) then
            Transform_Res108.Last_Attempted_Child := -1;
         end if;
         if Defer_Res172 /= null and then Is_Incomplete (Defer_Res172) then
            Transform_Res108.Last_Attempted_Child := 0;
         elsif Defer_Res172 /= null and then not Is_Ghost (Defer_Res172) then
            Transform_Res108.Last_Attempted_Child := -1;
         end if;
         if Defer_Res173 /= null and then Is_Incomplete (Defer_Res173) then
            Transform_Res108.Last_Attempted_Child := 0;
         elsif Defer_Res173 /= null and then not Is_Ghost (Defer_Res173) then
            Transform_Res108.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos122 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags108);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.State_Transform_Parse0_Memo,
      Row_Pos122 /= No_Token_Index,
      Transform_Res108,
      Pos,
      Row_Pos122);


   Parser.Current_Pos := Row_Pos122;

   return Transform_Res108;
end State_Transform_Parse0;

   


function State_Body_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_State_Body
is
   use Bare_State_Body_Memos;

      Row_Pos124 :
            Token_Index
               := No_Token_Index;
      Row_Pos125 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos24 :
            Token_Index
               := No_Token_Index;
      Tmp_List24 :
            Free_Parse_List;
      Defer_Pos174 :
            Token_Index
               := No_Token_Index;
      Defer_Res174 :
            Bare_Local_Decl
               := No_Bare_R_F_L_X_Node;
      Token_Pos185 :
            Token_Index
               := No_Token_Index;
      Token_Res185 :
            Token_Index
               := No_Token_Index;
      List_Pos24 :
            Token_Index
               := No_Token_Index;
      List_Res24 :
            Bare_Local_Decl_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos186 :
            Token_Index
               := No_Token_Index;
      Token_Res186 :
            Token_Index
               := No_Token_Index;
      Token_Pos187 :
            Token_Index
               := No_Token_Index;
      Token_Res187 :
            Token_Index
               := No_Token_Index;
      Row_Pos126 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos25 :
            Token_Index
               := No_Token_Index;
      Tmp_List25 :
            Free_Parse_List;
      Defer_Pos175 :
            Token_Index
               := No_Token_Index;
      Defer_Res175 :
            Bare_Statement
               := No_Bare_R_F_L_X_Node;
      Token_Pos188 :
            Token_Index
               := No_Token_Index;
      Token_Res188 :
            Token_Index
               := No_Token_Index;
      List_Pos25 :
            Token_Index
               := No_Token_Index;
      List_Res25 :
            Bare_Statement_List
               := No_Bare_R_F_L_X_Node;
      Token_Pos189 :
            Token_Index
               := No_Token_Index;
      Token_Res189 :
            Token_Index
               := No_Token_Index;
      Token_Pos190 :
            Token_Index
               := No_Token_Index;
      Token_Res190 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos26 :
            Token_Index
               := No_Token_Index;
      Tmp_List26 :
            Free_Parse_List;
      Defer_Pos176 :
            Token_Index
               := No_Token_Index;
      Defer_Res176 :
            Bare_Conditional_Transition
               := No_Bare_R_F_L_X_Node;
      List_Pos26 :
            Token_Index
               := No_Token_Index;
      List_Res26 :
            Bare_Conditional_Transition_List
               := No_Bare_R_F_L_X_Node;
      Defer_Pos177 :
            Token_Index
               := No_Token_Index;
      Defer_Res177 :
            Bare_Transition
               := No_Bare_R_F_L_X_Node;
      Row_Pos127 :
            Token_Index
               := No_Token_Index;
      Token_Pos191 :
            Token_Index
               := No_Token_Index;
      Token_Res191 :
            Token_Index
               := No_Token_Index;
      Defer_Pos178 :
            Token_Index
               := No_Token_Index;
      Defer_Res178 :
            Bare_Transition
               := No_Bare_R_F_L_X_Node;
      Token_Pos192 :
            Token_Index
               := No_Token_Index;
      Token_Res192 :
            Token_Index
               := No_Token_Index;
      Defer_Pos179 :
            Token_Index
               := No_Token_Index;
      Defer_Res179 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Transform_Res109 :
            Bare_State_Body
               := No_Bare_R_F_L_X_Node;
      Transform_Diags109 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.State_Body_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res109 := M.Instance;
      return Transform_Res109;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res109;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags109 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos124 := Pos;



--  Start opt_code












--  Start row_code

Row_Pos125 := Row_Pos124;



--  Start list_code

    List_Pos24 := No_Token_Index;



Lst_Cpos24 := Row_Pos125;
Tmp_List24 := Get_Parse_List (Parser);

loop
   
Defer_Res174 :=
   Declaration_Or_Parse0 (Parser, Lst_Cpos24);
Defer_Pos174 := Parser.Current_Pos;


   exit when Defer_Pos174 = No_Token_Index;

   List_Pos24 := Defer_Pos174;
   Lst_Cpos24 := List_Pos24;

   Tmp_List24.Nodes.Append (Defer_Res174);

      
--  Start tok_code

Token_Res185 := Lst_Cpos24;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res185));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos185 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos24 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos24,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos185 := Lst_Cpos24 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos185 /= No_Token_Index then
          Lst_Cpos24 := Token_Pos185;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List24.Nodes.Length;
begin
   List_Res24 :=
      Allocate_Local_Decl_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos125;
      Token_End := (if Lst_Cpos24 = Row_Pos125
                    then Row_Pos125
                    else Lst_Cpos24 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos125, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res24,
      Kind              => Rflx_Local_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res24,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List24.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res24.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List24);

--  End list_code




if List_Pos24 /= No_Token_Index then

   Row_Pos125 := List_Pos24;

else
   Row_Pos125 := No_Token_Index;
   goto Exit_Row125_0;

end if;


--  Start tok_code

Token_Res186 := Row_Pos125;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res186));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos186 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos125 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos125,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos186 := Row_Pos125 + 1;
   end if;
end;

--  End tok_code




if Token_Pos186 /= No_Token_Index then

   Row_Pos125 := Token_Pos186;

else
   Row_Pos125 := No_Token_Index;
   goto Exit_Row125_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row125_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos125 = No_Token_Index then

         
   List_Res24 :=
     Allocate_Local_Decl_List (Parser.Mem_Pool);
   Initialize
     (Self              => List_Res24,
      Kind              => Rflx_Local_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos124 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => List_Res24,
      Parser => Parser,
      Count  => 0);



       
   Row_Pos125 := Row_Pos124;



end if;

--  End opt_code




if Row_Pos125 /= No_Token_Index then

   Row_Pos124 := Row_Pos125;

else
   Row_Pos124 := No_Token_Index;
   goto Exit_Row124_0;

end if;


--  Start tok_code

Token_Res187 := Row_Pos124;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res187));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Begin)
   then
       Token_Pos187 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos124 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos124,
             Expected_Token_Id => Rflx_Begin,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos187 := Row_Pos124 + 1;
   end if;
end;

--  End tok_code




if Token_Pos187 /= No_Token_Index then

   Row_Pos124 := Token_Pos187;

else
   Row_Pos124 := No_Token_Index;
   goto Exit_Row124_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos126 := Row_Pos124;



--  Start list_code

    List_Pos25 := No_Token_Index;



Lst_Cpos25 := Row_Pos126;
Tmp_List25 := Get_Parse_List (Parser);

loop
   
Defer_Res175 :=
   Action_Or_Parse0 (Parser, Lst_Cpos25);
Defer_Pos175 := Parser.Current_Pos;


   exit when Defer_Pos175 = No_Token_Index;

   List_Pos25 := Defer_Pos175;
   Lst_Cpos25 := List_Pos25;

   Tmp_List25.Nodes.Append (Defer_Res175);

      
--  Start tok_code

Token_Res188 := Lst_Cpos25;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res188));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos188 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos25 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos25,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos188 := Lst_Cpos25 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos188 /= No_Token_Index then
          Lst_Cpos25 := Token_Pos188;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List25.Nodes.Length;
begin
   List_Res25 :=
      Allocate_Statement_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos126;
      Token_End := (if Lst_Cpos25 = Row_Pos126
                    then Row_Pos126
                    else Lst_Cpos25 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos126, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res25,
      Kind              => Rflx_Statement_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res25,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List25.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res25.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List25);

--  End list_code




if List_Pos25 /= No_Token_Index then

   Row_Pos126 := List_Pos25;

else
   Row_Pos126 := No_Token_Index;
   goto Exit_Row126_0;

end if;


--  Start tok_code

Token_Res189 := Row_Pos126;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res189));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Semicolon)
   then
       Token_Pos189 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos126 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos126,
             Expected_Token_Id => Rflx_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos189 := Row_Pos126 + 1;
   end if;
end;

--  End tok_code




if Token_Pos189 /= No_Token_Index then

   Row_Pos126 := Token_Pos189;

else
   Row_Pos126 := No_Token_Index;
   goto Exit_Row126_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row126_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos126 = No_Token_Index then

         
   List_Res25 :=
     Allocate_Statement_List (Parser.Mem_Pool);
   Initialize
     (Self              => List_Res25,
      Kind              => Rflx_Statement_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos124 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => List_Res25,
      Parser => Parser,
      Count  => 0);



       
   Row_Pos126 := Row_Pos124;



end if;

--  End opt_code




if Row_Pos126 /= No_Token_Index then

   Row_Pos124 := Row_Pos126;

else
   Row_Pos124 := No_Token_Index;
   goto Exit_Row124_0;

end if;


--  Start tok_code

Token_Res190 := Row_Pos124;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res190));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Transition)
   then
       Token_Pos190 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos124 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos124,
             Expected_Token_Id => Rflx_Transition,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos190 := Row_Pos124 + 1;
   end if;
end;

--  End tok_code




if Token_Pos190 /= No_Token_Index then

   Row_Pos124 := Token_Pos190;

else
   Row_Pos124 := No_Token_Index;
   goto Exit_Row124_0;

end if;


--  Start list_code

    List_Pos26 := Row_Pos124;



Lst_Cpos26 := Row_Pos124;
Tmp_List26 := Get_Parse_List (Parser);

loop
   
Defer_Res176 :=
   Conditional_Transition_Transform_Parse0 (Parser, Lst_Cpos26);
Defer_Pos176 := Parser.Current_Pos;


   exit when Defer_Pos176 = No_Token_Index;

   List_Pos26 := Defer_Pos176;
   Lst_Cpos26 := List_Pos26;

   Tmp_List26.Nodes.Append (Defer_Res176);


end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List26.Nodes.Length;
begin
   List_Res26 :=
      Allocate_Conditional_Transition_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos124;
      Token_End := (if Lst_Cpos26 = Row_Pos124
                    then Row_Pos124
                    else Lst_Cpos26 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos124, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res26,
      Kind              => Rflx_Conditional_Transition_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res26,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List26.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res26.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List26);

--  End list_code




if List_Pos26 /= No_Token_Index then

   Row_Pos124 := List_Pos26;

else
   Row_Pos124 := No_Token_Index;
   goto Exit_Row124_0;

end if;


Defer_Res177 :=
   Transition_Transform_Parse0 (Parser, Row_Pos124);
Defer_Pos177 := Parser.Current_Pos;




if Defer_Pos177 /= No_Token_Index then

   Row_Pos124 := Defer_Pos177;

else
   Row_Pos124 := No_Token_Index;
   goto Exit_Row124_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos127 := Row_Pos124;



--  Start tok_code

Token_Res191 := Row_Pos127;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res191));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Exception)
   then
       Token_Pos191 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos127 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos127,
             Expected_Token_Id => Rflx_Exception,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos191 := Row_Pos127 + 1;
   end if;
end;

--  End tok_code




if Token_Pos191 /= No_Token_Index then

   Row_Pos127 := Token_Pos191;

else
   Row_Pos127 := No_Token_Index;
   goto Exit_Row127_0;

end if;


Defer_Res178 :=
   Transition_Transform_Parse0 (Parser, Row_Pos127);
Defer_Pos178 := Parser.Current_Pos;




if Defer_Pos178 /= No_Token_Index then

   Row_Pos127 := Defer_Pos178;

else
   Row_Pos127 := No_Token_Index;
   goto Exit_Row127_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row127_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos127 = No_Token_Index then

         
   Defer_Res178 := No_Bare_R_F_L_X_Node;



       
   Row_Pos127 := Row_Pos124;



end if;

--  End opt_code




if Row_Pos127 /= No_Token_Index then

   Row_Pos124 := Row_Pos127;

else
   Row_Pos124 := No_Token_Index;
   goto Exit_Row124_0;

end if;


--  Start tok_code

Token_Res192 := Row_Pos124;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res192));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_End)
   then
       Token_Pos192 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos124 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos124,
             Expected_Token_Id => Rflx_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos192 := Row_Pos124 + 1;
   end if;
end;

--  End tok_code




if Token_Pos192 /= No_Token_Index then

   Row_Pos124 := Token_Pos192;

else
   Row_Pos124 := No_Token_Index;
   goto Exit_Row124_0;

end if;


Defer_Res179 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos124);
Defer_Pos179 := Parser.Current_Pos;




if Defer_Pos179 /= No_Token_Index then

   Row_Pos124 := Defer_Pos179;

else
   Row_Pos124 := No_Token_Index;
   goto Exit_Row124_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row124_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos124 /= No_Token_Index then

   Transform_Res109 := Allocate_State_Body (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res109,
      Kind => Rflx_State_Body,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos124 = Pos
                            then No_Token_Index
                            else Row_Pos124 - 1));

      Initialize_Fields_For_State_Body
        (Self => Transform_Res109, State_Body_F_Declarations => List_Res24, State_Body_F_Actions => List_Res25, State_Body_F_Conditional_Transitions => List_Res26, State_Body_F_Final_Transition => Defer_Res177, State_Body_F_Exception_Transition => Defer_Res178, State_Body_F_End_Identifier => Defer_Res179);

         if List_Res24 /= null and then Is_Incomplete (List_Res24) then
            Transform_Res109.Last_Attempted_Child := 0;
         elsif List_Res24 /= null and then not Is_Ghost (List_Res24) then
            Transform_Res109.Last_Attempted_Child := -1;
         end if;
         if List_Res25 /= null and then Is_Incomplete (List_Res25) then
            Transform_Res109.Last_Attempted_Child := 0;
         elsif List_Res25 /= null and then not Is_Ghost (List_Res25) then
            Transform_Res109.Last_Attempted_Child := -1;
         end if;
         if List_Res26 /= null and then Is_Incomplete (List_Res26) then
            Transform_Res109.Last_Attempted_Child := 0;
         elsif List_Res26 /= null and then not Is_Ghost (List_Res26) then
            Transform_Res109.Last_Attempted_Child := -1;
         end if;
         if Defer_Res177 /= null and then Is_Incomplete (Defer_Res177) then
            Transform_Res109.Last_Attempted_Child := 0;
         elsif Defer_Res177 /= null and then not Is_Ghost (Defer_Res177) then
            Transform_Res109.Last_Attempted_Child := -1;
         end if;
         if Defer_Res178 /= null and then Is_Incomplete (Defer_Res178) then
            Transform_Res109.Last_Attempted_Child := 0;
         elsif Defer_Res178 /= null and then not Is_Ghost (Defer_Res178) then
            Transform_Res109.Last_Attempted_Child := -1;
         end if;
         if Defer_Res179 /= null and then Is_Incomplete (Defer_Res179) then
            Transform_Res109.Last_Attempted_Child := 0;
         elsif Defer_Res179 /= null and then not Is_Ghost (Defer_Res179) then
            Transform_Res109.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos124 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags109);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.State_Body_Transform_Parse0_Memo,
      Row_Pos124 /= No_Token_Index,
      Transform_Res109,
      Pos,
      Row_Pos124);


   Parser.Current_Pos := Row_Pos124;

   return Transform_Res109;
end State_Body_Transform_Parse0;

   


function String_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_String_Literal
is
   use Bare_String_Literal_Memos;

      Row_Pos128 :
            Token_Index
               := No_Token_Index;
      Token_Pos193 :
            Token_Index
               := No_Token_Index;
      Token_Res193 :
            Token_Index
               := No_Token_Index;
      Transform_Res110 :
            Bare_String_Literal
               := No_Bare_R_F_L_X_Node;
      Transform_Diags110 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.String_Literal_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res110 := M.Instance;
      return Transform_Res110;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res110;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags110 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos128 := Pos;



--  Start tok_code

Token_Res193 := Row_Pos128;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res193));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_String_Literal)
   then
       Token_Pos193 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos128 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos128,
             Expected_Token_Id => Rflx_String_Literal,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos193 := Row_Pos128 + 1;
   end if;
end;

--  End tok_code




if Token_Pos193 /= No_Token_Index then

   Row_Pos128 := Token_Pos193;

else
   Row_Pos128 := No_Token_Index;
   goto Exit_Row128_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row128_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos128 /= No_Token_Index then

   Transform_Res110 := Allocate_String_Literal (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res110,
      Kind => Rflx_String_Literal,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos128 = Pos
                            then No_Token_Index
                            else Row_Pos128 - 1));




elsif Row_Pos128 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags110);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.String_Literal_Transform_Parse0_Memo,
      Row_Pos128 /= No_Token_Index,
      Transform_Res110,
      Pos,
      Row_Pos128);


   Parser.Current_Pos := Row_Pos128;

   return Transform_Res110;
end String_Literal_Transform_Parse0;

   


function Suffix_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Row_Pos129 :
            Token_Index
               := No_Token_Index;
      Defer_Pos180 :
            Token_Index
               := No_Token_Index;
      Defer_Res180 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos194 :
            Token_Index
               := No_Token_Index;
      Token_Res194 :
            Token_Index
               := No_Token_Index;
      Row_Pos130 :
            Token_Index
               := No_Token_Index;
      Token_Pos195 :
            Token_Index
               := No_Token_Index;
      Token_Res195 :
            Token_Index
               := No_Token_Index;
      Transform_Res111 :
            Bare_Attr_First
               := No_Bare_R_F_L_X_Node;
      Transform_Diags111 :
            Ada.Containers.Count_Type;
      Row_Pos131 :
            Token_Index
               := No_Token_Index;
      Token_Pos196 :
            Token_Index
               := No_Token_Index;
      Token_Res196 :
            Token_Index
               := No_Token_Index;
      Transform_Res112 :
            Bare_Attr_Size
               := No_Bare_R_F_L_X_Node;
      Transform_Diags112 :
            Ada.Containers.Count_Type;
      Row_Pos132 :
            Token_Index
               := No_Token_Index;
      Token_Pos197 :
            Token_Index
               := No_Token_Index;
      Token_Res197 :
            Token_Index
               := No_Token_Index;
      Transform_Res113 :
            Bare_Attr_Last
               := No_Bare_R_F_L_X_Node;
      Transform_Diags113 :
            Ada.Containers.Count_Type;
      Row_Pos133 :
            Token_Index
               := No_Token_Index;
      Token_Pos198 :
            Token_Index
               := No_Token_Index;
      Token_Res198 :
            Token_Index
               := No_Token_Index;
      Transform_Res114 :
            Bare_Attr_Valid_Checksum
               := No_Bare_R_F_L_X_Node;
      Transform_Diags114 :
            Ada.Containers.Count_Type;
      Or_Pos42 :
            Token_Index
               := No_Token_Index;
      Or_Res42 :
            Bare_Attr
               := No_Bare_R_F_L_X_Node;
      Transform_Res115 :
            Bare_Attribute
               := No_Bare_R_F_L_X_Node;
      Transform_Diags115 :
            Ada.Containers.Count_Type;
      Defer_Pos181 :
            Token_Index
               := No_Token_Index;
      Defer_Res181 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos43 :
            Token_Index
               := No_Token_Index;
      Or_Res43 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Suffix_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res43 := M.Instance;
      return Or_Res43;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res43;
   end if;

       Set (Parser.Private_Part.Suffix_Or_Parse1_Memo, False, Or_Res43, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos43 := No_Token_Index;
Or_Res43 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags115 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos129 := Pos;



Defer_Res180 :=
   Suffix_Or_Parse1 (Parser, Row_Pos129);
Defer_Pos180 := Parser.Current_Pos;




if Defer_Pos180 /= No_Token_Index then

   Row_Pos129 := Defer_Pos180;

else
   Row_Pos129 := No_Token_Index;
   goto Exit_Row129_0;

end if;


--  Start tok_code

Token_Res194 := Row_Pos129;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res194));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Tick)
   then
       Token_Pos194 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos129 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos129,
             Expected_Token_Id => Rflx_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos194 := Row_Pos129 + 1;
   end if;
end;

--  End tok_code




if Token_Pos194 /= No_Token_Index then

   Row_Pos129 := Token_Pos194;

else
   Row_Pos129 := No_Token_Index;
   goto Exit_Row129_0;

end if;


--  Start or_code

Or_Pos42 := No_Token_Index;
Or_Res42 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags111 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos130 := Row_Pos129;



--  Start tok_code

Token_Res195 := Row_Pos130;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res195));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_First)
   then
       Token_Pos195 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos130 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos130,
             Expected_Token_Id => Rflx_First,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos195 := Row_Pos130 + 1;
   end if;
end;

--  End tok_code




if Token_Pos195 /= No_Token_Index then

   Row_Pos130 := Token_Pos195;

else
   Row_Pos130 := No_Token_Index;
   goto Exit_Row130_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row130_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos130 /= No_Token_Index then

   Transform_Res111 := Allocate_Attr_First (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res111,
      Kind => Rflx_Attr_First,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos129,
      Token_End_Index   => (if Row_Pos130 = Row_Pos129
                            then No_Token_Index
                            else Row_Pos130 - 1));




elsif Row_Pos130 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags111);
end if;

--  End transform_code

    if Row_Pos130 /= No_Token_Index then
        Or_Pos42 := Row_Pos130;
        Or_Res42 := Transform_Res111;
        goto Exit_Or43;
    end if;
    
--  Start transform_code

Transform_Diags112 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos131 := Row_Pos129;



--  Start tok_code

Token_Res196 := Row_Pos131;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res196));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Size)
   then
       Token_Pos196 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos131 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos131,
             Expected_Token_Id => Rflx_Size,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos196 := Row_Pos131 + 1;
   end if;
end;

--  End tok_code




if Token_Pos196 /= No_Token_Index then

   Row_Pos131 := Token_Pos196;

else
   Row_Pos131 := No_Token_Index;
   goto Exit_Row131_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row131_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos131 /= No_Token_Index then

   Transform_Res112 := Allocate_Attr_Size (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res112,
      Kind => Rflx_Attr_Size,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos129,
      Token_End_Index   => (if Row_Pos131 = Row_Pos129
                            then No_Token_Index
                            else Row_Pos131 - 1));




elsif Row_Pos131 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags112);
end if;

--  End transform_code

    if Row_Pos131 /= No_Token_Index then
        Or_Pos42 := Row_Pos131;
        Or_Res42 := Transform_Res112;
        goto Exit_Or43;
    end if;
    
--  Start transform_code

Transform_Diags113 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos132 := Row_Pos129;



--  Start tok_code

Token_Res197 := Row_Pos132;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res197));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Last)
   then
       Token_Pos197 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos132 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos132,
             Expected_Token_Id => Rflx_Last,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos197 := Row_Pos132 + 1;
   end if;
end;

--  End tok_code




if Token_Pos197 /= No_Token_Index then

   Row_Pos132 := Token_Pos197;

else
   Row_Pos132 := No_Token_Index;
   goto Exit_Row132_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row132_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos132 /= No_Token_Index then

   Transform_Res113 := Allocate_Attr_Last (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res113,
      Kind => Rflx_Attr_Last,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos129,
      Token_End_Index   => (if Row_Pos132 = Row_Pos129
                            then No_Token_Index
                            else Row_Pos132 - 1));




elsif Row_Pos132 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags113);
end if;

--  End transform_code

    if Row_Pos132 /= No_Token_Index then
        Or_Pos42 := Row_Pos132;
        Or_Res42 := Transform_Res113;
        goto Exit_Or43;
    end if;
    
--  Start transform_code

Transform_Diags114 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos133 := Row_Pos129;



--  Start tok_code

Token_Res198 := Row_Pos133;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res198));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Valid_Checksum)
   then
       Token_Pos198 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos133 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos133,
             Expected_Token_Id => Rflx_Valid_Checksum,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos198 := Row_Pos133 + 1;
   end if;
end;

--  End tok_code




if Token_Pos198 /= No_Token_Index then

   Row_Pos133 := Token_Pos198;

else
   Row_Pos133 := No_Token_Index;
   goto Exit_Row133_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row133_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos133 /= No_Token_Index then

   Transform_Res114 := Allocate_Attr_Valid_Checksum (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res114,
      Kind => Rflx_Attr_Valid_Checksum,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos129,
      Token_End_Index   => (if Row_Pos133 = Row_Pos129
                            then No_Token_Index
                            else Row_Pos133 - 1));




elsif Row_Pos133 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags114);
end if;

--  End transform_code

    if Row_Pos133 /= No_Token_Index then
        Or_Pos42 := Row_Pos133;
        Or_Res42 := Transform_Res114;
        goto Exit_Or43;
    end if;
<<Exit_Or43>>

--  End or_code




if Or_Pos42 /= No_Token_Index then

   Row_Pos129 := Or_Pos42;

else
   Row_Pos129 := No_Token_Index;
   goto Exit_Row129_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row129_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos129 /= No_Token_Index then

   Transform_Res115 := Allocate_Attribute (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res115,
      Kind => Rflx_Attribute,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos129 = Pos
                            then No_Token_Index
                            else Row_Pos129 - 1));

      Initialize_Fields_For_Attribute
        (Self => Transform_Res115, Attribute_F_Expression => Defer_Res180, Attribute_F_Kind => Or_Res42);

         if Defer_Res180 /= null and then Is_Incomplete (Defer_Res180) then
            Transform_Res115.Last_Attempted_Child := 0;
         elsif Defer_Res180 /= null and then not Is_Ghost (Defer_Res180) then
            Transform_Res115.Last_Attempted_Child := -1;
         end if;
         if Or_Res42 /= null and then Is_Incomplete (Or_Res42) then
            Transform_Res115.Last_Attempted_Child := 0;
         elsif Or_Res42 /= null and then not Is_Ghost (Or_Res42) then
            Transform_Res115.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos129 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags115);
end if;

--  End transform_code

    if Row_Pos129 /= No_Token_Index then
        Or_Pos43 := Row_Pos129;
        Or_Res43 := Transform_Res115;
        goto Exit_Or42;
    end if;
    
Defer_Res181 :=
   Primary_Or_Parse0 (Parser, Pos);
Defer_Pos181 := Parser.Current_Pos;

    if Defer_Pos181 /= No_Token_Index then
        Or_Pos43 := Defer_Pos181;
        Or_Res43 := Defer_Res181;
        goto Exit_Or42;
    end if;
<<Exit_Or42>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos43 > Mem_Pos then
         Mem_Pos := Or_Pos43;
         Mem_Res := Or_Res43;
         Set
           (Parser.Private_Part.Suffix_Or_Parse1_Memo,
            Or_Pos43 /= No_Token_Index,
            Or_Res43,
            Pos,
            Or_Pos43);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res43 := Mem_Res;
         Or_Pos43 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Suffix_Or_Parse1_Memo,
      Or_Pos43 /= No_Token_Index,
      Or_Res43,
      Pos,
      Or_Pos43);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos43;

   return Or_Res43;
end Suffix_Or_Parse1;

   


function Term_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt12 :
            Boolean
               := False;
      Row_Pos134 :
            Token_Index
               := No_Token_Index;
      Defer_Pos182 :
            Token_Index
               := No_Token_Index;
      Defer_Res182 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Pos135 :
            Token_Index
               := No_Token_Index;
      Token_Pos199 :
            Token_Index
               := No_Token_Index;
      Token_Res199 :
            Token_Index
               := No_Token_Index;
      Transform_Res116 :
            Bare_Op_Mul
               := No_Bare_R_F_L_X_Node;
      Transform_Diags116 :
            Ada.Containers.Count_Type;
      Row_Pos136 :
            Token_Index
               := No_Token_Index;
      Token_Pos200 :
            Token_Index
               := No_Token_Index;
      Token_Res200 :
            Token_Index
               := No_Token_Index;
      Transform_Res117 :
            Bare_Op_Div
               := No_Bare_R_F_L_X_Node;
      Transform_Diags117 :
            Ada.Containers.Count_Type;
      Row_Pos137 :
            Token_Index
               := No_Token_Index;
      Token_Pos201 :
            Token_Index
               := No_Token_Index;
      Token_Res201 :
            Token_Index
               := No_Token_Index;
      Transform_Res118 :
            Bare_Op_Mod
               := No_Bare_R_F_L_X_Node;
      Transform_Diags118 :
            Ada.Containers.Count_Type;
      Or_Pos44 :
            Token_Index
               := No_Token_Index;
      Or_Res44 :
            Bare_Op
               := No_Bare_R_F_L_X_Node;
      Defer_Pos183 :
            Token_Index
               := No_Token_Index;
      Defer_Res183 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Progress12 :
            Integer
               := 0;
      Transform_Res119 :
            Bare_Bin_Op
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed12 :
            Boolean
               := False;
      Transform_Diags119 :
            Ada.Containers.Count_Type;
      Defer_Pos184 :
            Token_Index
               := No_Token_Index;
      Defer_Res184 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos45 :
            Token_Index
               := No_Token_Index;
      Or_Res45 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_R_F_L_X_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Term_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res45 := M.Instance;
      return Or_Res45;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res45;
   end if;

       Set (Parser.Private_Part.Term_Or_Parse1_Memo, False, Or_Res45, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt12 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos45 := No_Token_Index;
Or_Res45 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags119 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos134 := Pos;



Defer_Res182 :=
   Term_Or_Parse1 (Parser, Row_Pos134);
Defer_Pos182 := Parser.Current_Pos;



Row_Progress12 := 1;

if Defer_Pos182 /= No_Token_Index then

   Row_Pos134 := Defer_Pos182;

else
   Row_Pos134 := No_Token_Index;
   goto Exit_Row134_0;

end if;


--  Start or_code

Or_Pos44 := No_Token_Index;
Or_Res44 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags116 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos135 := Row_Pos134;



--  Start tok_code

Token_Res199 := Row_Pos135;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res199));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Mul)
   then
       Token_Pos199 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos135 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos135,
             Expected_Token_Id => Rflx_Mul,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos199 := Row_Pos135 + 1;
   end if;
end;

--  End tok_code




if Token_Pos199 /= No_Token_Index then

   Row_Pos135 := Token_Pos199;

else
   Row_Pos135 := No_Token_Index;
   goto Exit_Row135_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row135_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos135 /= No_Token_Index then

   Transform_Res116 := Allocate_Op_Mul (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res116,
      Kind => Rflx_Op_Mul,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos134,
      Token_End_Index   => (if Row_Pos135 = Row_Pos134
                            then No_Token_Index
                            else Row_Pos135 - 1));




elsif Row_Pos135 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags116);
end if;

--  End transform_code

    if Row_Pos135 /= No_Token_Index then
        Or_Pos44 := Row_Pos135;
        Or_Res44 := Transform_Res116;
        goto Exit_Or45;
    end if;
    
--  Start transform_code

Transform_Diags117 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos136 := Row_Pos134;



--  Start tok_code

Token_Res200 := Row_Pos136;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res200));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Div)
   then
       Token_Pos200 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos136 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos136,
             Expected_Token_Id => Rflx_Div,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos200 := Row_Pos136 + 1;
   end if;
end;

--  End tok_code




if Token_Pos200 /= No_Token_Index then

   Row_Pos136 := Token_Pos200;

else
   Row_Pos136 := No_Token_Index;
   goto Exit_Row136_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row136_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos136 /= No_Token_Index then

   Transform_Res117 := Allocate_Op_Div (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res117,
      Kind => Rflx_Op_Div,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos134,
      Token_End_Index   => (if Row_Pos136 = Row_Pos134
                            then No_Token_Index
                            else Row_Pos136 - 1));




elsif Row_Pos136 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags117);
end if;

--  End transform_code

    if Row_Pos136 /= No_Token_Index then
        Or_Pos44 := Row_Pos136;
        Or_Res44 := Transform_Res117;
        goto Exit_Or45;
    end if;
    
--  Start transform_code

Transform_Diags118 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos137 := Row_Pos134;



--  Start tok_code

Token_Res201 := Row_Pos137;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res201));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Mod)
   then
       Token_Pos201 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos137 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos137,
             Expected_Token_Id => Rflx_Mod,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos201 := Row_Pos137 + 1;
   end if;
end;

--  End tok_code




if Token_Pos201 /= No_Token_Index then

   Row_Pos137 := Token_Pos201;

else
   Row_Pos137 := No_Token_Index;
   goto Exit_Row137_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row137_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos137 /= No_Token_Index then

   Transform_Res118 := Allocate_Op_Mod (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res118,
      Kind => Rflx_Op_Mod,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos134,
      Token_End_Index   => (if Row_Pos137 = Row_Pos134
                            then No_Token_Index
                            else Row_Pos137 - 1));




elsif Row_Pos137 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags118);
end if;

--  End transform_code

    if Row_Pos137 /= No_Token_Index then
        Or_Pos44 := Row_Pos137;
        Or_Res44 := Transform_Res118;
        goto Exit_Or45;
    end if;
<<Exit_Or45>>

--  End or_code



Row_Progress12 := 2;

if Or_Pos44 /= No_Token_Index then

   Row_Pos134 := Or_Pos44;

else
   Row_Pos134 := No_Token_Index;
   goto Exit_Row134_0;

end if;

Nobt12 := True;

   Nobt12 := Nobt12;

Row_Progress12 := 3;

if Row_Pos134 /= No_Token_Index then

   Row_Pos134 := Row_Pos134;

else
   Row_Pos134 := No_Token_Index;
   goto Exit_Row134_0;

end if;


Defer_Res183 :=
   Factor_Or_Parse0 (Parser, Row_Pos134);
Defer_Pos183 := Parser.Current_Pos;



Row_Progress12 := 4;

if Defer_Pos183 /= No_Token_Index then

   Row_Pos134 := Defer_Pos183;

else
   Row_Pos134 := No_Token_Index;
   goto Exit_Row134_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row134_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos134 = No_Token_Index and then Nobt12 then

   Row_Pos134 := Parser.Last_Fail.Pos;

   Transform_Has_Failed12 := True;
end if;

if Row_Pos134 /= No_Token_Index then

   Transform_Res119 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res119,
      Kind => Rflx_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos134 = Pos
                            then No_Token_Index
                            else Row_Pos134 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res119, Bin_Op_F_Left => Defer_Res182, Bin_Op_F_Op => Or_Res44, Bin_Op_F_Right => Defer_Res183);

         if Defer_Res182 /= null and then Is_Incomplete (Defer_Res182) then
            Transform_Res119.Last_Attempted_Child := 0;
         elsif Defer_Res182 /= null and then not Is_Ghost (Defer_Res182) then
            Transform_Res119.Last_Attempted_Child := -1;
         end if;
         if Or_Res44 /= null and then Is_Incomplete (Or_Res44) then
            Transform_Res119.Last_Attempted_Child := 0;
         elsif Or_Res44 /= null and then not Is_Ghost (Or_Res44) then
            Transform_Res119.Last_Attempted_Child := -1;
         end if;
         if Defer_Res183 /= null and then Is_Incomplete (Defer_Res183) then
            Transform_Res119.Last_Attempted_Child := 0;
         elsif Defer_Res183 /= null and then not Is_Ghost (Defer_Res183) then
            Transform_Res119.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed12 then
      Transform_Res119.Last_Attempted_Child :=
         Row_Progress12;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <term>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos134 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags119);
end if;

--  End transform_code

    if Row_Pos134 /= No_Token_Index then
        Or_Pos45 := Row_Pos134;
        Or_Res45 := Transform_Res119;
        goto Exit_Or44;
    end if;
    
Defer_Res184 :=
   Factor_Or_Parse0 (Parser, Pos);
Defer_Pos184 := Parser.Current_Pos;

    if Defer_Pos184 /= No_Token_Index then
        Or_Pos45 := Defer_Pos184;
        Or_Res45 := Defer_Res184;
        goto Exit_Or44;
    end if;
<<Exit_Or44>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos45 > Mem_Pos then
         Mem_Pos := Or_Pos45;
         Mem_Res := Or_Res45;
         Set
           (Parser.Private_Part.Term_Or_Parse1_Memo,
            Or_Pos45 /= No_Token_Index,
            Or_Res45,
            Pos,
            Or_Pos45);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res45 := Mem_Res;
         Or_Pos45 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Term_Or_Parse1_Memo,
      Or_Pos45 /= No_Token_Index,
      Or_Res45,
      Pos,
      Or_Pos45);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos45;

   return Or_Res45;
end Term_Or_Parse1;

   


function Then_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Then_Node
is
   use Bare_Then_Node_Memos;

      Row_Pos138 :
            Token_Index
               := No_Token_Index;
      Token_Pos202 :
            Token_Index
               := No_Token_Index;
      Token_Res202 :
            Token_Index
               := No_Token_Index;
      Defer_Pos185 :
            Token_Index
               := No_Token_Index;
      Defer_Res185 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Row_Pos139 :
            Token_Index
               := No_Token_Index;
      Token_Pos203 :
            Token_Index
               := No_Token_Index;
      Token_Res203 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos27 :
            Token_Index
               := No_Token_Index;
      Tmp_List27 :
            Free_Parse_List;
      Defer_Pos186 :
            Token_Index
               := No_Token_Index;
      Defer_Res186 :
            Bare_Aspect
               := No_Bare_R_F_L_X_Node;
      Token_Pos204 :
            Token_Index
               := No_Token_Index;
      Token_Res204 :
            Token_Index
               := No_Token_Index;
      List_Pos27 :
            Token_Index
               := No_Token_Index;
      List_Res27 :
            Bare_Aspect_List
               := No_Bare_R_F_L_X_Node;
      Defer_Pos187 :
            Token_Index
               := No_Token_Index;
      Defer_Res187 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res120 :
            Bare_Then_Node
               := No_Bare_R_F_L_X_Node;
      Transform_Diags120 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Then_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res120 := M.Instance;
      return Transform_Res120;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res120;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags120 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos138 := Pos;



--  Start tok_code

Token_Res202 := Row_Pos138;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res202));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Then)
   then
       Token_Pos202 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos138 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos138,
             Expected_Token_Id => Rflx_Then,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos202 := Row_Pos138 + 1;
   end if;
end;

--  End tok_code




if Token_Pos202 /= No_Token_Index then

   Row_Pos138 := Token_Pos202;

else
   Row_Pos138 := No_Token_Index;
   goto Exit_Row138_0;

end if;


Defer_Res185 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos138);
Defer_Pos185 := Parser.Current_Pos;




if Defer_Pos185 /= No_Token_Index then

   Row_Pos138 := Defer_Pos185;

else
   Row_Pos138 := No_Token_Index;
   goto Exit_Row138_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos139 := Row_Pos138;



--  Start tok_code

Token_Res203 := Row_Pos139;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res203));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_With)
   then
       Token_Pos203 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos139 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos139,
             Expected_Token_Id => Rflx_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos203 := Row_Pos139 + 1;
   end if;
end;

--  End tok_code




if Token_Pos203 /= No_Token_Index then

   Row_Pos139 := Token_Pos203;

else
   Row_Pos139 := No_Token_Index;
   goto Exit_Row139_0;

end if;


--  Start list_code

    List_Pos27 := No_Token_Index;



Lst_Cpos27 := Row_Pos139;
Tmp_List27 := Get_Parse_List (Parser);

loop
   
Defer_Res186 :=
   Aspect_Transform_Parse0 (Parser, Lst_Cpos27);
Defer_Pos186 := Parser.Current_Pos;


   exit when Defer_Pos186 = No_Token_Index;

   List_Pos27 := Defer_Pos186;
   Lst_Cpos27 := List_Pos27;

   Tmp_List27.Nodes.Append (Defer_Res186);

      
--  Start tok_code

Token_Res204 := Lst_Cpos27;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res204));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Comma)
   then
       Token_Pos204 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos27 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos27,
             Expected_Token_Id => Rflx_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos204 := Lst_Cpos27 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos204 /= No_Token_Index then
          Lst_Cpos27 := Token_Pos204;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List27.Nodes.Length;
begin
   List_Res27 :=
      Allocate_Aspect_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos139;
      Token_End := (if Lst_Cpos27 = Row_Pos139
                    then Row_Pos139
                    else Lst_Cpos27 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos139, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res27,
      Kind              => Rflx_Aspect_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res27,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_R_F_L_X_Node_Vectors.Vector renames
         Tmp_List27.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res27.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List27);

--  End list_code




if List_Pos27 /= No_Token_Index then

   Row_Pos139 := List_Pos27;

else
   Row_Pos139 := No_Token_Index;
   goto Exit_Row139_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row139_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos139 = No_Token_Index then

         
   List_Res27 :=
     Allocate_Aspect_List (Parser.Mem_Pool);
   Initialize
     (Self              => List_Res27,
      Kind              => Rflx_Aspect_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos138 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => List_Res27,
      Parser => Parser,
      Count  => 0);



       
   Row_Pos139 := Row_Pos138;



end if;

--  End opt_code




if Row_Pos139 /= No_Token_Index then

   Row_Pos138 := Row_Pos139;

else
   Row_Pos138 := No_Token_Index;
   goto Exit_Row138_0;

end if;


--  Start opt_code












Defer_Res187 :=
   If_Condition_Extract_Parse0 (Parser, Row_Pos138);
Defer_Pos187 := Parser.Current_Pos;


if Defer_Pos187 = No_Token_Index then

         
   Defer_Res187 := No_Bare_R_F_L_X_Node;



       
   Defer_Pos187 := Row_Pos138;



end if;

--  End opt_code




if Defer_Pos187 /= No_Token_Index then

   Row_Pos138 := Defer_Pos187;

else
   Row_Pos138 := No_Token_Index;
   goto Exit_Row138_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row138_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos138 /= No_Token_Index then

   Transform_Res120 := Allocate_Then_Node (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res120,
      Kind => Rflx_Then_Node,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos138 = Pos
                            then No_Token_Index
                            else Row_Pos138 - 1));

      Initialize_Fields_For_Then_Node
        (Self => Transform_Res120, Then_Node_F_Target => Defer_Res185, Then_Node_F_Aspects => List_Res27, Then_Node_F_Condition => Defer_Res187);

         if Defer_Res185 /= null and then Is_Incomplete (Defer_Res185) then
            Transform_Res120.Last_Attempted_Child := 0;
         elsif Defer_Res185 /= null and then not Is_Ghost (Defer_Res185) then
            Transform_Res120.Last_Attempted_Child := -1;
         end if;
         if List_Res27 /= null and then Is_Incomplete (List_Res27) then
            Transform_Res120.Last_Attempted_Child := 0;
         elsif List_Res27 /= null and then not Is_Ghost (List_Res27) then
            Transform_Res120.Last_Attempted_Child := -1;
         end if;
         if Defer_Res187 /= null and then Is_Incomplete (Defer_Res187) then
            Transform_Res120.Last_Attempted_Child := 0;
         elsif Defer_Res187 /= null and then not Is_Ghost (Defer_Res187) then
            Transform_Res120.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos138 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags120);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Then_Transform_Parse0_Memo,
      Row_Pos138 /= No_Token_Index,
      Transform_Res120,
      Pos,
      Row_Pos138);


   Parser.Current_Pos := Row_Pos138;

   return Transform_Res120;
end Then_Transform_Parse0;

   


function Transition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Transition
is
   use Bare_Transition_Memos;

      Row_Pos140 :
            Token_Index
               := No_Token_Index;
      Token_Pos205 :
            Token_Index
               := No_Token_Index;
      Token_Res205 :
            Token_Index
               := No_Token_Index;
      Defer_Pos188 :
            Token_Index
               := No_Token_Index;
      Defer_Res188 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Row_Pos141 :
            Token_Index
               := No_Token_Index;
      Token_Pos206 :
            Token_Index
               := No_Token_Index;
      Token_Res206 :
            Token_Index
               := No_Token_Index;
      Defer_Pos189 :
            Token_Index
               := No_Token_Index;
      Defer_Res189 :
            Bare_Description
               := No_Bare_R_F_L_X_Node;
      Transform_Res121 :
            Bare_Transition
               := No_Bare_R_F_L_X_Node;
      Transform_Diags121 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Transition_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res121 := M.Instance;
      return Transform_Res121;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res121;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags121 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos140 := Pos;



--  Start tok_code

Token_Res205 := Row_Pos140;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res205));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Goto)
   then
       Token_Pos205 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos140 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos140,
             Expected_Token_Id => Rflx_Goto,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos205 := Row_Pos140 + 1;
   end if;
end;

--  End tok_code




if Token_Pos205 /= No_Token_Index then

   Row_Pos140 := Token_Pos205;

else
   Row_Pos140 := No_Token_Index;
   goto Exit_Row140_0;

end if;


Defer_Res188 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos140);
Defer_Pos188 := Parser.Current_Pos;




if Defer_Pos188 /= No_Token_Index then

   Row_Pos140 := Defer_Pos188;

else
   Row_Pos140 := No_Token_Index;
   goto Exit_Row140_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos141 := Row_Pos140;



--  Start tok_code

Token_Res206 := Row_Pos141;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res206));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_With)
   then
       Token_Pos206 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos141 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos141,
             Expected_Token_Id => Rflx_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos206 := Row_Pos141 + 1;
   end if;
end;

--  End tok_code




if Token_Pos206 /= No_Token_Index then

   Row_Pos141 := Token_Pos206;

else
   Row_Pos141 := No_Token_Index;
   goto Exit_Row141_0;

end if;


Defer_Res189 :=
   Description_Aspect_Transform_Parse0 (Parser, Row_Pos141);
Defer_Pos189 := Parser.Current_Pos;




if Defer_Pos189 /= No_Token_Index then

   Row_Pos141 := Defer_Pos189;

else
   Row_Pos141 := No_Token_Index;
   goto Exit_Row141_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row141_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos141 = No_Token_Index then

         
   Defer_Res189 := No_Bare_R_F_L_X_Node;



       
   Row_Pos141 := Row_Pos140;



end if;

--  End opt_code




if Row_Pos141 /= No_Token_Index then

   Row_Pos140 := Row_Pos141;

else
   Row_Pos140 := No_Token_Index;
   goto Exit_Row140_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row140_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos140 /= No_Token_Index then

   Transform_Res121 := Allocate_Transition (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res121,
      Kind => Rflx_Transition,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos140 = Pos
                            then No_Token_Index
                            else Row_Pos140 - 1));

      Initialize_Fields_For_Transition
        (Self => Transform_Res121, Transition_F_Target => Defer_Res188, Transition_F_Description => Defer_Res189);

         if Defer_Res188 /= null and then Is_Incomplete (Defer_Res188) then
            Transform_Res121.Last_Attempted_Child := 0;
         elsif Defer_Res188 /= null and then not Is_Ghost (Defer_Res188) then
            Transform_Res121.Last_Attempted_Child := -1;
         end if;
         if Defer_Res189 /= null and then Is_Incomplete (Defer_Res189) then
            Transform_Res121.Last_Attempted_Child := 0;
         elsif Defer_Res189 /= null and then not Is_Ghost (Defer_Res189) then
            Transform_Res121.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos140 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags121);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Transition_Transform_Parse0_Memo,
      Row_Pos140 /= No_Token_Index,
      Transform_Res121,
      Pos,
      Row_Pos140);


   Parser.Current_Pos := Row_Pos140;

   return Transform_Res121;
end Transition_Transform_Parse0;

   


function Type_Argument_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Argument
is
   use Bare_Type_Argument_Memos;

      Row_Pos142 :
            Token_Index
               := No_Token_Index;
      Defer_Pos190 :
            Token_Index
               := No_Token_Index;
      Defer_Res190 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos207 :
            Token_Index
               := No_Token_Index;
      Token_Res207 :
            Token_Index
               := No_Token_Index;
      Defer_Pos191 :
            Token_Index
               := No_Token_Index;
      Defer_Res191 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res122 :
            Bare_Type_Argument
               := No_Bare_R_F_L_X_Node;
      Transform_Diags122 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Type_Argument_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res122 := M.Instance;
      return Transform_Res122;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res122;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags122 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos142 := Pos;



Defer_Res190 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos142);
Defer_Pos190 := Parser.Current_Pos;




if Defer_Pos190 /= No_Token_Index then

   Row_Pos142 := Defer_Pos190;

else
   Row_Pos142 := No_Token_Index;
   goto Exit_Row142_0;

end if;


--  Start tok_code

Token_Res207 := Row_Pos142;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res207));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Arrow)
   then
       Token_Pos207 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos142 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos142,
             Expected_Token_Id => Rflx_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos207 := Row_Pos142 + 1;
   end if;
end;

--  End tok_code




if Token_Pos207 /= No_Token_Index then

   Row_Pos142 := Token_Pos207;

else
   Row_Pos142 := No_Token_Index;
   goto Exit_Row142_0;

end if;


Defer_Res191 :=
   Expression_Or_Parse1 (Parser, Row_Pos142);
Defer_Pos191 := Parser.Current_Pos;




if Defer_Pos191 /= No_Token_Index then

   Row_Pos142 := Defer_Pos191;

else
   Row_Pos142 := No_Token_Index;
   goto Exit_Row142_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row142_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos142 /= No_Token_Index then

   Transform_Res122 := Allocate_Type_Argument (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res122,
      Kind => Rflx_Type_Argument,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos142 = Pos
                            then No_Token_Index
                            else Row_Pos142 - 1));

      Initialize_Fields_For_Type_Argument
        (Self => Transform_Res122, Type_Argument_F_Identifier => Defer_Res190, Type_Argument_F_Expression => Defer_Res191);

         if Defer_Res190 /= null and then Is_Incomplete (Defer_Res190) then
            Transform_Res122.Last_Attempted_Child := 0;
         elsif Defer_Res190 /= null and then not Is_Ghost (Defer_Res190) then
            Transform_Res122.Last_Attempted_Child := -1;
         end if;
         if Defer_Res191 /= null and then Is_Incomplete (Defer_Res191) then
            Transform_Res122.Last_Attempted_Child := 0;
         elsif Defer_Res191 /= null and then not Is_Ghost (Defer_Res191) then
            Transform_Res122.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos142 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags122);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Type_Argument_Transform_Parse0_Memo,
      Row_Pos142 /= No_Token_Index,
      Transform_Res122,
      Pos,
      Row_Pos142);


   Parser.Current_Pos := Row_Pos142;

   return Transform_Res122;
end Type_Argument_Transform_Parse0;

   


function Type_Declaration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Decl
is
   use Bare_Type_Decl_Memos;

      Row_Pos143 :
            Token_Index
               := No_Token_Index;
      Token_Pos208 :
            Token_Index
               := No_Token_Index;
      Token_Res208 :
            Token_Index
               := No_Token_Index;
      Defer_Pos192 :
            Token_Index
               := No_Token_Index;
      Defer_Res192 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Defer_Pos193 :
            Token_Index
               := No_Token_Index;
      Defer_Res193 :
            Bare_Parameters
               := No_Bare_R_F_L_X_Node;
      Token_Pos209 :
            Token_Index
               := No_Token_Index;
      Token_Res209 :
            Token_Index
               := No_Token_Index;
      Defer_Pos194 :
            Token_Index
               := No_Token_Index;
      Defer_Res194 :
            Bare_Enumeration_Type_Def
               := No_Bare_R_F_L_X_Node;
      Defer_Pos195 :
            Token_Index
               := No_Token_Index;
      Defer_Res195 :
            Bare_Integer_Type_Def
               := No_Bare_R_F_L_X_Node;
      Defer_Pos196 :
            Token_Index
               := No_Token_Index;
      Defer_Res196 :
            Bare_Abstract_Message_Type_Def
               := No_Bare_R_F_L_X_Node;
      Defer_Pos197 :
            Token_Index
               := No_Token_Index;
      Defer_Res197 :
            Bare_Type_Derivation_Def
               := No_Bare_R_F_L_X_Node;
      Defer_Pos198 :
            Token_Index
               := No_Token_Index;
      Defer_Res198 :
            Bare_Sequence_Type_Def
               := No_Bare_R_F_L_X_Node;
      Or_Pos46 :
            Token_Index
               := No_Token_Index;
      Or_Res46 :
            Bare_Type_Def
               := No_Bare_R_F_L_X_Node;
      Transform_Res123 :
            Bare_Type_Decl
               := No_Bare_R_F_L_X_Node;
      Transform_Diags123 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Type_Declaration_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res123 := M.Instance;
      return Transform_Res123;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res123;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags123 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos143 := Pos;



--  Start tok_code

Token_Res208 := Row_Pos143;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res208));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Type)
   then
       Token_Pos208 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos143 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos143,
             Expected_Token_Id => Rflx_Type,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos208 := Row_Pos143 + 1;
   end if;
end;

--  End tok_code




if Token_Pos208 /= No_Token_Index then

   Row_Pos143 := Token_Pos208;

else
   Row_Pos143 := No_Token_Index;
   goto Exit_Row143_0;

end if;


Defer_Res192 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos143);
Defer_Pos192 := Parser.Current_Pos;




if Defer_Pos192 /= No_Token_Index then

   Row_Pos143 := Defer_Pos192;

else
   Row_Pos143 := No_Token_Index;
   goto Exit_Row143_0;

end if;


--  Start opt_code












Defer_Res193 :=
   Parameter_List_Transform_Parse0 (Parser, Row_Pos143);
Defer_Pos193 := Parser.Current_Pos;


if Defer_Pos193 = No_Token_Index then

         
   Defer_Res193 := No_Bare_R_F_L_X_Node;



       
   Defer_Pos193 := Row_Pos143;



end if;

--  End opt_code




if Defer_Pos193 /= No_Token_Index then

   Row_Pos143 := Defer_Pos193;

else
   Row_Pos143 := No_Token_Index;
   goto Exit_Row143_0;

end if;


--  Start tok_code

Token_Res209 := Row_Pos143;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res209));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Is)
   then
       Token_Pos209 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos143 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos143,
             Expected_Token_Id => Rflx_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos209 := Row_Pos143 + 1;
   end if;
end;

--  End tok_code




if Token_Pos209 /= No_Token_Index then

   Row_Pos143 := Token_Pos209;

else
   Row_Pos143 := No_Token_Index;
   goto Exit_Row143_0;

end if;


--  Start or_code

Or_Pos46 := No_Token_Index;
Or_Res46 := No_Bare_R_F_L_X_Node;
    
Defer_Res194 :=
   Enumeration_Type_Definition_Transform_Parse0 (Parser, Row_Pos143);
Defer_Pos194 := Parser.Current_Pos;

    if Defer_Pos194 /= No_Token_Index then
        Or_Pos46 := Defer_Pos194;
        Or_Res46 := Defer_Res194;
        goto Exit_Or46;
    end if;
    
Defer_Res195 :=
   Integer_Type_Definition_Or_Parse0 (Parser, Row_Pos143);
Defer_Pos195 := Parser.Current_Pos;

    if Defer_Pos195 /= No_Token_Index then
        Or_Pos46 := Defer_Pos195;
        Or_Res46 := Defer_Res195;
        goto Exit_Or46;
    end if;
    
Defer_Res196 :=
   Message_Type_Definition_Or_Parse0 (Parser, Row_Pos143);
Defer_Pos196 := Parser.Current_Pos;

    if Defer_Pos196 /= No_Token_Index then
        Or_Pos46 := Defer_Pos196;
        Or_Res46 := Defer_Res196;
        goto Exit_Or46;
    end if;
    
Defer_Res197 :=
   Type_Derivation_Definition_Transform_Parse0 (Parser, Row_Pos143);
Defer_Pos197 := Parser.Current_Pos;

    if Defer_Pos197 /= No_Token_Index then
        Or_Pos46 := Defer_Pos197;
        Or_Res46 := Defer_Res197;
        goto Exit_Or46;
    end if;
    
Defer_Res198 :=
   Sequence_Type_Definition_Transform_Parse0 (Parser, Row_Pos143);
Defer_Pos198 := Parser.Current_Pos;

    if Defer_Pos198 /= No_Token_Index then
        Or_Pos46 := Defer_Pos198;
        Or_Res46 := Defer_Res198;
        goto Exit_Or46;
    end if;
<<Exit_Or46>>

--  End or_code




if Or_Pos46 /= No_Token_Index then

   Row_Pos143 := Or_Pos46;

else
   Row_Pos143 := No_Token_Index;
   goto Exit_Row143_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row143_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos143 /= No_Token_Index then

   Transform_Res123 := Allocate_Type_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res123,
      Kind => Rflx_Type_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos143 = Pos
                            then No_Token_Index
                            else Row_Pos143 - 1));

      Initialize_Fields_For_Type_Decl
        (Self => Transform_Res123, Type_Decl_F_Identifier => Defer_Res192, Type_Decl_F_Parameters => Defer_Res193, Type_Decl_F_Definition => Or_Res46);

         if Defer_Res192 /= null and then Is_Incomplete (Defer_Res192) then
            Transform_Res123.Last_Attempted_Child := 0;
         elsif Defer_Res192 /= null and then not Is_Ghost (Defer_Res192) then
            Transform_Res123.Last_Attempted_Child := -1;
         end if;
         if Defer_Res193 /= null and then Is_Incomplete (Defer_Res193) then
            Transform_Res123.Last_Attempted_Child := 0;
         elsif Defer_Res193 /= null and then not Is_Ghost (Defer_Res193) then
            Transform_Res123.Last_Attempted_Child := -1;
         end if;
         if Or_Res46 /= null and then Is_Incomplete (Or_Res46) then
            Transform_Res123.Last_Attempted_Child := 0;
         elsif Or_Res46 /= null and then not Is_Ghost (Or_Res46) then
            Transform_Res123.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos143 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags123);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Type_Declaration_Transform_Parse0_Memo,
      Row_Pos143 /= No_Token_Index,
      Transform_Res123,
      Pos,
      Row_Pos143);


   Parser.Current_Pos := Row_Pos143;

   return Transform_Res123;
end Type_Declaration_Transform_Parse0;

   


function Type_Derivation_Definition_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Derivation_Def
is
   use Bare_Type_Derivation_Def_Memos;

      Row_Pos144 :
            Token_Index
               := No_Token_Index;
      Token_Pos210 :
            Token_Index
               := No_Token_Index;
      Token_Res210 :
            Token_Index
               := No_Token_Index;
      Defer_Pos199 :
            Token_Index
               := No_Token_Index;
      Defer_Res199 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Transform_Res124 :
            Bare_Type_Derivation_Def
               := No_Bare_R_F_L_X_Node;
      Transform_Diags124 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Type_Derivation_Definition_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res124 := M.Instance;
      return Transform_Res124;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res124;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags124 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos144 := Pos;



--  Start tok_code

Token_Res210 := Row_Pos144;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res210));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_New)
   then
       Token_Pos210 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos144 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos144,
             Expected_Token_Id => Rflx_New,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos210 := Row_Pos144 + 1;
   end if;
end;

--  End tok_code




if Token_Pos210 /= No_Token_Index then

   Row_Pos144 := Token_Pos210;

else
   Row_Pos144 := No_Token_Index;
   goto Exit_Row144_0;

end if;


Defer_Res199 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Row_Pos144);
Defer_Pos199 := Parser.Current_Pos;




if Defer_Pos199 /= No_Token_Index then

   Row_Pos144 := Defer_Pos199;

else
   Row_Pos144 := No_Token_Index;
   goto Exit_Row144_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row144_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos144 /= No_Token_Index then

   Transform_Res124 := Allocate_Type_Derivation_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res124,
      Kind => Rflx_Type_Derivation_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos144 = Pos
                            then No_Token_Index
                            else Row_Pos144 - 1));

      Initialize_Fields_For_Type_Derivation_Def
        (Self => Transform_Res124, Type_Derivation_Def_F_Base => Defer_Res199);

         if Defer_Res199 /= null and then Is_Incomplete (Defer_Res199) then
            Transform_Res124.Last_Attempted_Child := 0;
         elsif Defer_Res199 /= null and then not Is_Ghost (Defer_Res199) then
            Transform_Res124.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos144 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags124);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Type_Derivation_Definition_Transform_Parse0_Memo,
      Row_Pos144 /= No_Token_Index,
      Transform_Res124,
      Pos,
      Row_Pos144);


   Parser.Current_Pos := Row_Pos144;

   return Transform_Res124;
end Type_Derivation_Definition_Transform_Parse0;

   


function Type_Refinement_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Refinement_Decl
is
   use Bare_Refinement_Decl_Memos;

      Row_Pos145 :
            Token_Index
               := No_Token_Index;
      Token_Pos211 :
            Token_Index
               := No_Token_Index;
      Token_Res211 :
            Token_Index
               := No_Token_Index;
      Defer_Pos200 :
            Token_Index
               := No_Token_Index;
      Defer_Res200 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos212 :
            Token_Index
               := No_Token_Index;
      Token_Res212 :
            Token_Index
               := No_Token_Index;
      Token_Pos213 :
            Token_Index
               := No_Token_Index;
      Token_Res213 :
            Token_Index
               := No_Token_Index;
      Defer_Pos201 :
            Token_Index
               := No_Token_Index;
      Defer_Res201 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos214 :
            Token_Index
               := No_Token_Index;
      Token_Res214 :
            Token_Index
               := No_Token_Index;
      Defer_Pos202 :
            Token_Index
               := No_Token_Index;
      Defer_Res202 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos215 :
            Token_Index
               := No_Token_Index;
      Token_Res215 :
            Token_Index
               := No_Token_Index;
      Defer_Pos203 :
            Token_Index
               := No_Token_Index;
      Defer_Res203 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res125 :
            Bare_Refinement_Decl
               := No_Bare_R_F_L_X_Node;
      Transform_Diags125 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Type_Refinement_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res125 := M.Instance;
      return Transform_Res125;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res125;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags125 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos145 := Pos;



--  Start tok_code

Token_Res211 := Row_Pos145;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res211));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_For)
   then
       Token_Pos211 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos145 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos145,
             Expected_Token_Id => Rflx_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos211 := Row_Pos145 + 1;
   end if;
end;

--  End tok_code




if Token_Pos211 /= No_Token_Index then

   Row_Pos145 := Token_Pos211;

else
   Row_Pos145 := No_Token_Index;
   goto Exit_Row145_0;

end if;


Defer_Res200 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Row_Pos145);
Defer_Pos200 := Parser.Current_Pos;




if Defer_Pos200 /= No_Token_Index then

   Row_Pos145 := Defer_Pos200;

else
   Row_Pos145 := No_Token_Index;
   goto Exit_Row145_0;

end if;


--  Start tok_code

Token_Res212 := Row_Pos145;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res212));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Use)
   then
       Token_Pos212 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos145 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos145,
             Expected_Token_Id => Rflx_Use,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos212 := Row_Pos145 + 1;
   end if;
end;

--  End tok_code




if Token_Pos212 /= No_Token_Index then

   Row_Pos145 := Token_Pos212;

else
   Row_Pos145 := No_Token_Index;
   goto Exit_Row145_0;

end if;


--  Start tok_code

Token_Res213 := Row_Pos145;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res213));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_L_Par)
   then
       Token_Pos213 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos145 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos145,
             Expected_Token_Id => Rflx_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos213 := Row_Pos145 + 1;
   end if;
end;

--  End tok_code




if Token_Pos213 /= No_Token_Index then

   Row_Pos145 := Token_Pos213;

else
   Row_Pos145 := No_Token_Index;
   goto Exit_Row145_0;

end if;


Defer_Res201 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos145);
Defer_Pos201 := Parser.Current_Pos;




if Defer_Pos201 /= No_Token_Index then

   Row_Pos145 := Defer_Pos201;

else
   Row_Pos145 := No_Token_Index;
   goto Exit_Row145_0;

end if;


--  Start tok_code

Token_Res214 := Row_Pos145;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res214));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Arrow)
   then
       Token_Pos214 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos145 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos145,
             Expected_Token_Id => Rflx_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos214 := Row_Pos145 + 1;
   end if;
end;

--  End tok_code




if Token_Pos214 /= No_Token_Index then

   Row_Pos145 := Token_Pos214;

else
   Row_Pos145 := No_Token_Index;
   goto Exit_Row145_0;

end if;


Defer_Res202 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Row_Pos145);
Defer_Pos202 := Parser.Current_Pos;




if Defer_Pos202 /= No_Token_Index then

   Row_Pos145 := Defer_Pos202;

else
   Row_Pos145 := No_Token_Index;
   goto Exit_Row145_0;

end if;


--  Start tok_code

Token_Res215 := Row_Pos145;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res215));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_R_Par)
   then
       Token_Pos215 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos145 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos145,
             Expected_Token_Id => Rflx_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos215 := Row_Pos145 + 1;
   end if;
end;

--  End tok_code




if Token_Pos215 /= No_Token_Index then

   Row_Pos145 := Token_Pos215;

else
   Row_Pos145 := No_Token_Index;
   goto Exit_Row145_0;

end if;


--  Start opt_code












Defer_Res203 :=
   If_Condition_Extract_Parse0 (Parser, Row_Pos145);
Defer_Pos203 := Parser.Current_Pos;


if Defer_Pos203 = No_Token_Index then

         
   Defer_Res203 := No_Bare_R_F_L_X_Node;



       
   Defer_Pos203 := Row_Pos145;



end if;

--  End opt_code




if Defer_Pos203 /= No_Token_Index then

   Row_Pos145 := Defer_Pos203;

else
   Row_Pos145 := No_Token_Index;
   goto Exit_Row145_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row145_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos145 /= No_Token_Index then

   Transform_Res125 := Allocate_Refinement_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res125,
      Kind => Rflx_Refinement_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos145 = Pos
                            then No_Token_Index
                            else Row_Pos145 - 1));

      Initialize_Fields_For_Refinement_Decl
        (Self => Transform_Res125, Refinement_Decl_F_Pdu => Defer_Res200, Refinement_Decl_F_Field => Defer_Res201, Refinement_Decl_F_Sdu => Defer_Res202, Refinement_Decl_F_Condition => Defer_Res203);

         if Defer_Res200 /= null and then Is_Incomplete (Defer_Res200) then
            Transform_Res125.Last_Attempted_Child := 0;
         elsif Defer_Res200 /= null and then not Is_Ghost (Defer_Res200) then
            Transform_Res125.Last_Attempted_Child := -1;
         end if;
         if Defer_Res201 /= null and then Is_Incomplete (Defer_Res201) then
            Transform_Res125.Last_Attempted_Child := 0;
         elsif Defer_Res201 /= null and then not Is_Ghost (Defer_Res201) then
            Transform_Res125.Last_Attempted_Child := -1;
         end if;
         if Defer_Res202 /= null and then Is_Incomplete (Defer_Res202) then
            Transform_Res125.Last_Attempted_Child := 0;
         elsif Defer_Res202 /= null and then not Is_Ghost (Defer_Res202) then
            Transform_Res125.Last_Attempted_Child := -1;
         end if;
         if Defer_Res203 /= null and then Is_Incomplete (Defer_Res203) then
            Transform_Res125.Last_Attempted_Child := 0;
         elsif Defer_Res203 /= null and then not Is_Ghost (Defer_Res203) then
            Transform_Res125.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos145 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags125);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Type_Refinement_Transform_Parse0_Memo,
      Row_Pos145 /= No_Token_Index,
      Transform_Res125,
      Pos,
      Row_Pos145);


   Parser.Current_Pos := Row_Pos145;

   return Transform_Res125;
end Type_Refinement_Transform_Parse0;

   


function Unop_Term_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt13 :
            Boolean
               := False;
      Row_Pos146 :
            Token_Index
               := No_Token_Index;
      Token_Pos216 :
            Token_Index
               := No_Token_Index;
      Token_Res216 :
            Token_Index
               := No_Token_Index;
      Defer_Pos204 :
            Token_Index
               := No_Token_Index;
      Defer_Res204 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Row_Progress13 :
            Integer
               := 0;
      Transform_Res126 :
            Bare_Negation
               := No_Bare_R_F_L_X_Node;
      Transform_Has_Failed13 :
            Boolean
               := False;
      Transform_Diags126 :
            Ada.Containers.Count_Type;
      Defer_Pos205 :
            Token_Index
               := No_Token_Index;
      Defer_Res205 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Or_Pos47 :
            Token_Index
               := No_Token_Index;
      Or_Res47 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Unop_Term_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res47 := M.Instance;
      return Or_Res47;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res47;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos47 := No_Token_Index;
Or_Res47 := No_Bare_R_F_L_X_Node;
    
--  Start transform_code

Transform_Diags126 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos146 := Pos;



--  Start tok_code

Token_Res216 := Row_Pos146;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res216));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Sub)
   then
       Token_Pos216 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos146 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos146,
             Expected_Token_Id => Rflx_Sub,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos216 := Row_Pos146 + 1;
   end if;
end;

--  End tok_code



Row_Progress13 := 1;

if Token_Pos216 /= No_Token_Index then

   Row_Pos146 := Token_Pos216;

else
   Row_Pos146 := No_Token_Index;
   goto Exit_Row146_0;

end if;

Nobt13 := True;

   Nobt13 := Nobt13;

Row_Progress13 := 2;

if Row_Pos146 /= No_Token_Index then

   Row_Pos146 := Row_Pos146;

else
   Row_Pos146 := No_Token_Index;
   goto Exit_Row146_0;

end if;


Defer_Res204 :=
   Term_Or_Parse1 (Parser, Row_Pos146);
Defer_Pos204 := Parser.Current_Pos;



Row_Progress13 := 3;

if Defer_Pos204 /= No_Token_Index then

   Row_Pos146 := Defer_Pos204;

else
   Row_Pos146 := No_Token_Index;
   goto Exit_Row146_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row146_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos146 = No_Token_Index and then Nobt13 then

   Row_Pos146 := Parser.Last_Fail.Pos;

   Transform_Has_Failed13 := True;
end if;

if Row_Pos146 /= No_Token_Index then

   Transform_Res126 := Allocate_Negation (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res126,
      Kind => Rflx_Negation,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos146 = Pos
                            then No_Token_Index
                            else Row_Pos146 - 1));

      Initialize_Fields_For_Negation
        (Self => Transform_Res126, Negation_F_Data => Defer_Res204);

         if Defer_Res204 /= null and then Is_Incomplete (Defer_Res204) then
            Transform_Res126.Last_Attempted_Child := 0;
         elsif Defer_Res204 /= null and then not Is_Ghost (Defer_Res204) then
            Transform_Res126.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed13 then
      Transform_Res126.Last_Attempted_Child :=
         Row_Progress13;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <unop_term>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos146 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags126);
end if;

--  End transform_code

    if Row_Pos146 /= No_Token_Index then
        Or_Pos47 := Row_Pos146;
        Or_Res47 := Transform_Res126;
        goto Exit_Or47;
    end if;
    
Defer_Res205 :=
   Term_Or_Parse1 (Parser, Pos);
Defer_Pos205 := Parser.Current_Pos;

    if Defer_Pos205 /= No_Token_Index then
        Or_Pos47 := Defer_Pos205;
        Or_Res47 := Defer_Res205;
        goto Exit_Or47;
    end if;
<<Exit_Or47>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Unop_Term_Or_Parse0_Memo,
      Or_Pos47 /= No_Token_Index,
      Or_Res47,
      Pos,
      Or_Pos47);


   Parser.Current_Pos := Or_Pos47;

   return Or_Res47;
end Unop_Term_Or_Parse0;

   


function Unqualified_Identifier_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Unqualified_I_D
is
   use Bare_Unqualified_I_D_Memos;

      Row_Pos147 :
            Token_Index
               := No_Token_Index;
      Token_Pos217 :
            Token_Index
               := No_Token_Index;
      Token_Res217 :
            Token_Index
               := No_Token_Index;
      Token_Pos218 :
            Token_Index
               := No_Token_Index;
      Token_Res218 :
            Token_Index
               := No_Token_Index;
      Token_Pos219 :
            Token_Index
               := No_Token_Index;
      Token_Res219 :
            Token_Index
               := No_Token_Index;
      Token_Pos220 :
            Token_Index
               := No_Token_Index;
      Token_Res220 :
            Token_Index
               := No_Token_Index;
      Token_Pos221 :
            Token_Index
               := No_Token_Index;
      Token_Res221 :
            Token_Index
               := No_Token_Index;
      Token_Pos222 :
            Token_Index
               := No_Token_Index;
      Token_Res222 :
            Token_Index
               := No_Token_Index;
      Token_Pos223 :
            Token_Index
               := No_Token_Index;
      Token_Res223 :
            Token_Index
               := No_Token_Index;
      Token_Pos224 :
            Token_Index
               := No_Token_Index;
      Token_Res224 :
            Token_Index
               := No_Token_Index;
      Token_Pos225 :
            Token_Index
               := No_Token_Index;
      Token_Res225 :
            Token_Index
               := No_Token_Index;
      Token_Pos226 :
            Token_Index
               := No_Token_Index;
      Token_Res226 :
            Token_Index
               := No_Token_Index;
      Token_Pos227 :
            Token_Index
               := No_Token_Index;
      Token_Res227 :
            Token_Index
               := No_Token_Index;
      Token_Pos228 :
            Token_Index
               := No_Token_Index;
      Token_Res228 :
            Token_Index
               := No_Token_Index;
      Token_Pos229 :
            Token_Index
               := No_Token_Index;
      Token_Res229 :
            Token_Index
               := No_Token_Index;
      Token_Pos230 :
            Token_Index
               := No_Token_Index;
      Token_Res230 :
            Token_Index
               := No_Token_Index;
      Token_Pos231 :
            Token_Index
               := No_Token_Index;
      Token_Res231 :
            Token_Index
               := No_Token_Index;
      Token_Pos232 :
            Token_Index
               := No_Token_Index;
      Token_Res232 :
            Token_Index
               := No_Token_Index;
      Token_Pos233 :
            Token_Index
               := No_Token_Index;
      Token_Res233 :
            Token_Index
               := No_Token_Index;
      Token_Pos234 :
            Token_Index
               := No_Token_Index;
      Token_Res234 :
            Token_Index
               := No_Token_Index;
      Token_Pos235 :
            Token_Index
               := No_Token_Index;
      Token_Res235 :
            Token_Index
               := No_Token_Index;
      Token_Pos236 :
            Token_Index
               := No_Token_Index;
      Token_Res236 :
            Token_Index
               := No_Token_Index;
      Token_Pos237 :
            Token_Index
               := No_Token_Index;
      Token_Res237 :
            Token_Index
               := No_Token_Index;
      Token_Pos238 :
            Token_Index
               := No_Token_Index;
      Token_Res238 :
            Token_Index
               := No_Token_Index;
      Token_Pos239 :
            Token_Index
               := No_Token_Index;
      Token_Res239 :
            Token_Index
               := No_Token_Index;
      Token_Pos240 :
            Token_Index
               := No_Token_Index;
      Token_Res240 :
            Token_Index
               := No_Token_Index;
      Token_Pos241 :
            Token_Index
               := No_Token_Index;
      Token_Res241 :
            Token_Index
               := No_Token_Index;
      Token_Pos242 :
            Token_Index
               := No_Token_Index;
      Token_Res242 :
            Token_Index
               := No_Token_Index;
      Token_Pos243 :
            Token_Index
               := No_Token_Index;
      Token_Res243 :
            Token_Index
               := No_Token_Index;
      Token_Pos244 :
            Token_Index
               := No_Token_Index;
      Token_Res244 :
            Token_Index
               := No_Token_Index;
      Token_Pos245 :
            Token_Index
               := No_Token_Index;
      Token_Res245 :
            Token_Index
               := No_Token_Index;
      Token_Pos246 :
            Token_Index
               := No_Token_Index;
      Token_Res246 :
            Token_Index
               := No_Token_Index;
      Token_Pos247 :
            Token_Index
               := No_Token_Index;
      Token_Res247 :
            Token_Index
               := No_Token_Index;
      Token_Pos248 :
            Token_Index
               := No_Token_Index;
      Token_Res248 :
            Token_Index
               := No_Token_Index;
      Token_Pos249 :
            Token_Index
               := No_Token_Index;
      Token_Res249 :
            Token_Index
               := No_Token_Index;
      Token_Pos250 :
            Token_Index
               := No_Token_Index;
      Token_Res250 :
            Token_Index
               := No_Token_Index;
      Token_Pos251 :
            Token_Index
               := No_Token_Index;
      Token_Res251 :
            Token_Index
               := No_Token_Index;
      Token_Pos252 :
            Token_Index
               := No_Token_Index;
      Token_Res252 :
            Token_Index
               := No_Token_Index;
      Token_Pos253 :
            Token_Index
               := No_Token_Index;
      Token_Res253 :
            Token_Index
               := No_Token_Index;
      Token_Pos254 :
            Token_Index
               := No_Token_Index;
      Token_Res254 :
            Token_Index
               := No_Token_Index;
      Token_Pos255 :
            Token_Index
               := No_Token_Index;
      Token_Res255 :
            Token_Index
               := No_Token_Index;
      Token_Pos256 :
            Token_Index
               := No_Token_Index;
      Token_Res256 :
            Token_Index
               := No_Token_Index;
      Token_Pos257 :
            Token_Index
               := No_Token_Index;
      Token_Res257 :
            Token_Index
               := No_Token_Index;
      Token_Pos258 :
            Token_Index
               := No_Token_Index;
      Token_Res258 :
            Token_Index
               := No_Token_Index;
      Token_Pos259 :
            Token_Index
               := No_Token_Index;
      Token_Res259 :
            Token_Index
               := No_Token_Index;
      Token_Pos260 :
            Token_Index
               := No_Token_Index;
      Token_Res260 :
            Token_Index
               := No_Token_Index;
      Token_Pos261 :
            Token_Index
               := No_Token_Index;
      Token_Res261 :
            Token_Index
               := No_Token_Index;
      Token_Pos262 :
            Token_Index
               := No_Token_Index;
      Token_Res262 :
            Token_Index
               := No_Token_Index;
      Token_Pos263 :
            Token_Index
               := No_Token_Index;
      Token_Res263 :
            Token_Index
               := No_Token_Index;
      Token_Pos264 :
            Token_Index
               := No_Token_Index;
      Token_Res264 :
            Token_Index
               := No_Token_Index;
      Token_Pos265 :
            Token_Index
               := No_Token_Index;
      Token_Res265 :
            Token_Index
               := No_Token_Index;
      Token_Pos266 :
            Token_Index
               := No_Token_Index;
      Token_Res266 :
            Token_Index
               := No_Token_Index;
      Token_Pos267 :
            Token_Index
               := No_Token_Index;
      Token_Res267 :
            Token_Index
               := No_Token_Index;
      Token_Pos268 :
            Token_Index
               := No_Token_Index;
      Token_Res268 :
            Token_Index
               := No_Token_Index;
      Or_Pos48 :
            Token_Index
               := No_Token_Index;
      Or_Res48 :
            Token_Index
               := No_Token_Index;
      Transform_Res127 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Transform_Diags127 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Unqualified_Identifier_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res127 := M.Instance;
      return Transform_Res127;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res127;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags127 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos147 := Pos;



--  Start or_code

Or_Pos48 := No_Token_Index;
Or_Res48 := No_Token_Index;
    
--  Start tok_code

Token_Res217 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res217));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Package)
   then
       Token_Pos217 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Package,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos217 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos217 /= No_Token_Index then
        Or_Pos48 := Token_Pos217;
        Or_Res48 := Token_Res217;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res218 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res218));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Is)
   then
       Token_Pos218 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos218 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos218 /= No_Token_Index then
        Or_Pos48 := Token_Pos218;
        Or_Res48 := Token_Res218;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res219 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res219));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_If)
   then
       Token_Pos219 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_If,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos219 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos219 /= No_Token_Index then
        Or_Pos48 := Token_Pos219;
        Or_Res48 := Token_Res219;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res220 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res220));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_End)
   then
       Token_Pos220 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos220 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos220 /= No_Token_Index then
        Or_Pos48 := Token_Pos220;
        Or_Res48 := Token_Res220;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res221 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res221));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Null)
   then
       Token_Pos221 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos221 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos221 /= No_Token_Index then
        Or_Pos48 := Token_Pos221;
        Or_Res48 := Token_Res221;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res222 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res222));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Type)
   then
       Token_Pos222 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Type,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos222 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos222 /= No_Token_Index then
        Or_Pos48 := Token_Pos222;
        Or_Res48 := Token_Res222;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res223 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res223));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Range)
   then
       Token_Pos223 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Range,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos223 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos223 /= No_Token_Index then
        Or_Pos48 := Token_Pos223;
        Or_Res48 := Token_Res223;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res224 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res224));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_With)
   then
       Token_Pos224 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos224 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos224 /= No_Token_Index then
        Or_Pos48 := Token_Pos224;
        Or_Res48 := Token_Res224;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res225 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res225));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Mod)
   then
       Token_Pos225 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Mod,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos225 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos225 /= No_Token_Index then
        Or_Pos48 := Token_Pos225;
        Or_Res48 := Token_Res225;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res226 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res226));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Message)
   then
       Token_Pos226 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Message,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos226 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos226 /= No_Token_Index then
        Or_Pos48 := Token_Pos226;
        Or_Res48 := Token_Res226;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res227 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res227));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Then)
   then
       Token_Pos227 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Then,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos227 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos227 /= No_Token_Index then
        Or_Pos48 := Token_Pos227;
        Or_Res48 := Token_Res227;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res228 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res228));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Sequence)
   then
       Token_Pos228 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Sequence,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos228 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos228 /= No_Token_Index then
        Or_Pos48 := Token_Pos228;
        Or_Res48 := Token_Res228;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res229 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res229));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Of)
   then
       Token_Pos229 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Of,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos229 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos229 /= No_Token_Index then
        Or_Pos48 := Token_Pos229;
        Or_Res48 := Token_Res229;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res230 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res230));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_In)
   then
       Token_Pos230 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos230 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos230 /= No_Token_Index then
        Or_Pos48 := Token_Pos230;
        Or_Res48 := Token_Res230;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res231 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res231));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Not)
   then
       Token_Pos231 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Not,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos231 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos231 /= No_Token_Index then
        Or_Pos48 := Token_Pos231;
        Or_Res48 := Token_Res231;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res232 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res232));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_New)
   then
       Token_Pos232 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_New,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos232 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos232 /= No_Token_Index then
        Or_Pos48 := Token_Pos232;
        Or_Res48 := Token_Res232;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res233 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res233));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_For)
   then
       Token_Pos233 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos233 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos233 /= No_Token_Index then
        Or_Pos48 := Token_Pos233;
        Or_Res48 := Token_Res233;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res234 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res234));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_When)
   then
       Token_Pos234 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_When,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos234 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos234 /= No_Token_Index then
        Or_Pos48 := Token_Pos234;
        Or_Res48 := Token_Res234;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res235 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res235));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Where)
   then
       Token_Pos235 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Where,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos235 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos235 /= No_Token_Index then
        Or_Pos48 := Token_Pos235;
        Or_Res48 := Token_Res235;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res236 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res236));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Use)
   then
       Token_Pos236 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Use,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos236 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos236 /= No_Token_Index then
        Or_Pos48 := Token_Pos236;
        Or_Res48 := Token_Res236;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res237 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res237));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_All)
   then
       Token_Pos237 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_All,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos237 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos237 /= No_Token_Index then
        Or_Pos48 := Token_Pos237;
        Or_Res48 := Token_Res237;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res238 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res238));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Some)
   then
       Token_Pos238 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Some,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos238 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos238 /= No_Token_Index then
        Or_Pos48 := Token_Pos238;
        Or_Res48 := Token_Res238;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res239 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res239));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Generic)
   then
       Token_Pos239 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Generic,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos239 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos239 /= No_Token_Index then
        Or_Pos48 := Token_Pos239;
        Or_Res48 := Token_Res239;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res240 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res240));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Session)
   then
       Token_Pos240 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Session,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos240 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos240 /= No_Token_Index then
        Or_Pos48 := Token_Pos240;
        Or_Res48 := Token_Res240;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res241 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res241));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Begin)
   then
       Token_Pos241 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Begin,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos241 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos241 /= No_Token_Index then
        Or_Pos48 := Token_Pos241;
        Or_Res48 := Token_Res241;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res242 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res242));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Return)
   then
       Token_Pos242 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Return,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos242 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos242 /= No_Token_Index then
        Or_Pos48 := Token_Pos242;
        Or_Res48 := Token_Res242;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res243 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res243));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Function)
   then
       Token_Pos243 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Function,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos243 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos243 /= No_Token_Index then
        Or_Pos48 := Token_Pos243;
        Or_Res48 := Token_Res243;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res244 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res244));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_State)
   then
       Token_Pos244 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_State,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos244 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos244 /= No_Token_Index then
        Or_Pos48 := Token_Pos244;
        Or_Res48 := Token_Res244;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res245 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res245));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Transition)
   then
       Token_Pos245 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Transition,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos245 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos245 /= No_Token_Index then
        Or_Pos48 := Token_Pos245;
        Or_Res48 := Token_Res245;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res246 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res246));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Goto)
   then
       Token_Pos246 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Goto,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos246 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos246 /= No_Token_Index then
        Or_Pos48 := Token_Pos246;
        Or_Res48 := Token_Res246;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res247 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res247));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Exception)
   then
       Token_Pos247 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Exception,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos247 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos247 /= No_Token_Index then
        Or_Pos48 := Token_Pos247;
        Or_Res48 := Token_Res247;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res248 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res248));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Renames)
   then
       Token_Pos248 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Renames,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos248 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos248 /= No_Token_Index then
        Or_Pos48 := Token_Pos248;
        Or_Res48 := Token_Res248;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res249 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res249));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Channel)
   then
       Token_Pos249 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Channel,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos249 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos249 /= No_Token_Index then
        Or_Pos48 := Token_Pos249;
        Or_Res48 := Token_Res249;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res250 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res250));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Readable)
   then
       Token_Pos250 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Readable,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos250 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos250 /= No_Token_Index then
        Or_Pos48 := Token_Pos250;
        Or_Res48 := Token_Res250;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res251 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res251));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Writable)
   then
       Token_Pos251 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Writable,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos251 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos251 /= No_Token_Index then
        Or_Pos48 := Token_Pos251;
        Or_Res48 := Token_Res251;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res252 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res252));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Desc)
   then
       Token_Pos252 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Desc,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos252 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos252 /= No_Token_Index then
        Or_Pos48 := Token_Pos252;
        Or_Res48 := Token_Res252;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res253 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res253));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Append)
   then
       Token_Pos253 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Append,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos253 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos253 /= No_Token_Index then
        Or_Pos48 := Token_Pos253;
        Or_Res48 := Token_Res253;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res254 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res254));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Extend)
   then
       Token_Pos254 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Extend,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos254 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos254 /= No_Token_Index then
        Or_Pos48 := Token_Pos254;
        Or_Res48 := Token_Res254;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res255 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res255));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Read)
   then
       Token_Pos255 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Read,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos255 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos255 /= No_Token_Index then
        Or_Pos48 := Token_Pos255;
        Or_Res48 := Token_Res255;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res256 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res256));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Write)
   then
       Token_Pos256 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Write,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos256 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos256 /= No_Token_Index then
        Or_Pos48 := Token_Pos256;
        Or_Res48 := Token_Res256;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res257 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res257));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Reset)
   then
       Token_Pos257 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Reset,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos257 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos257 /= No_Token_Index then
        Or_Pos48 := Token_Pos257;
        Or_Res48 := Token_Res257;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res258 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res258));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Checksum)
   then
       Token_Pos258 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Checksum,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos258 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos258 /= No_Token_Index then
        Or_Pos48 := Token_Pos258;
        Or_Res48 := Token_Res258;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res259 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res259));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Valid_Checksum)
   then
       Token_Pos259 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Valid_Checksum,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos259 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos259 /= No_Token_Index then
        Or_Pos48 := Token_Pos259;
        Or_Res48 := Token_Res259;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res260 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res260));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Has_Data)
   then
       Token_Pos260 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Has_Data,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos260 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos260 /= No_Token_Index then
        Or_Pos48 := Token_Pos260;
        Or_Res48 := Token_Res260;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res261 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res261));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Head)
   then
       Token_Pos261 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Head,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos261 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos261 /= No_Token_Index then
        Or_Pos48 := Token_Pos261;
        Or_Res48 := Token_Res261;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res262 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res262));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Opaque)
   then
       Token_Pos262 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Opaque,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos262 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos262 /= No_Token_Index then
        Or_Pos48 := Token_Pos262;
        Or_Res48 := Token_Res262;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res263 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res263));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Present)
   then
       Token_Pos263 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Present,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos263 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos263 /= No_Token_Index then
        Or_Pos48 := Token_Pos263;
        Or_Res48 := Token_Res263;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res264 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res264));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Valid)
   then
       Token_Pos264 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Valid,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos264 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos264 /= No_Token_Index then
        Or_Pos48 := Token_Pos264;
        Or_Res48 := Token_Res264;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res265 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res265));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_And)
   then
       Token_Pos265 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_And,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos265 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos265 /= No_Token_Index then
        Or_Pos48 := Token_Pos265;
        Or_Res48 := Token_Res265;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res266 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res266));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Or)
   then
       Token_Pos266 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Or,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos266 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos266 /= No_Token_Index then
        Or_Pos48 := Token_Pos266;
        Or_Res48 := Token_Res266;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res267 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res267));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Case)
   then
       Token_Pos267 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Case,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos267 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos267 /= No_Token_Index then
        Or_Pos48 := Token_Pos267;
        Or_Res48 := Token_Res267;
        goto Exit_Or48;
    end if;
    
--  Start tok_code

Token_Res268 := Row_Pos147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res268));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Unqualified_Identifier)
   then
       Token_Pos268 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos147,
             Expected_Token_Id => Rflx_Unqualified_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos268 := Row_Pos147 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos268 /= No_Token_Index then
        Or_Pos48 := Token_Pos268;
        Or_Res48 := Token_Res268;
        goto Exit_Or48;
    end if;
<<Exit_Or48>>

--  End or_code




if Or_Pos48 /= No_Token_Index then

   Row_Pos147 := Or_Pos48;

else
   Row_Pos147 := No_Token_Index;
   goto Exit_Row147_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row147_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos147 /= No_Token_Index then

   Transform_Res127 := Allocate_Unqualified_I_D (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res127,
      Kind => Rflx_Unqualified_I_D,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos147 = Pos
                            then No_Token_Index
                            else Row_Pos147 - 1));




elsif Row_Pos147 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags127);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Unqualified_Identifier_Transform_Parse0_Memo,
      Row_Pos147 /= No_Token_Index,
      Transform_Res127,
      Pos,
      Row_Pos147);


   Parser.Current_Pos := Row_Pos147;

   return Transform_Res127;
end Unqualified_Identifier_Transform_Parse0;

   


function Value_Range_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Checksum_Value_Range
is
   use Bare_Checksum_Value_Range_Memos;

      Row_Pos148 :
            Token_Index
               := No_Token_Index;
      Defer_Pos206 :
            Token_Index
               := No_Token_Index;
      Defer_Res206 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Token_Pos269 :
            Token_Index
               := No_Token_Index;
      Token_Res269 :
            Token_Index
               := No_Token_Index;
      Defer_Pos207 :
            Token_Index
               := No_Token_Index;
      Defer_Res207 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res128 :
            Bare_Checksum_Value_Range
               := No_Bare_R_F_L_X_Node;
      Transform_Diags128 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Value_Range_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res128 := M.Instance;
      return Transform_Res128;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res128;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags128 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos148 := Pos;



Defer_Res206 :=
   Expression_Or_Parse1 (Parser, Row_Pos148);
Defer_Pos206 := Parser.Current_Pos;




if Defer_Pos206 /= No_Token_Index then

   Row_Pos148 := Defer_Pos206;

else
   Row_Pos148 := No_Token_Index;
   goto Exit_Row148_0;

end if;


--  Start tok_code

Token_Res269 := Row_Pos148;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res269));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Double_Dot)
   then
       Token_Pos269 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos148 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos148,
             Expected_Token_Id => Rflx_Double_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos269 := Row_Pos148 + 1;
   end if;
end;

--  End tok_code




if Token_Pos269 /= No_Token_Index then

   Row_Pos148 := Token_Pos269;

else
   Row_Pos148 := No_Token_Index;
   goto Exit_Row148_0;

end if;


Defer_Res207 :=
   Expression_Or_Parse1 (Parser, Row_Pos148);
Defer_Pos207 := Parser.Current_Pos;




if Defer_Pos207 /= No_Token_Index then

   Row_Pos148 := Defer_Pos207;

else
   Row_Pos148 := No_Token_Index;
   goto Exit_Row148_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row148_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos148 /= No_Token_Index then

   Transform_Res128 := Allocate_Checksum_Value_Range (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res128,
      Kind => Rflx_Checksum_Value_Range,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos148 = Pos
                            then No_Token_Index
                            else Row_Pos148 - 1));

      Initialize_Fields_For_Checksum_Value_Range
        (Self => Transform_Res128, Checksum_Value_Range_F_First => Defer_Res206, Checksum_Value_Range_F_Last => Defer_Res207);

         if Defer_Res206 /= null and then Is_Incomplete (Defer_Res206) then
            Transform_Res128.Last_Attempted_Child := 0;
         elsif Defer_Res206 /= null and then not Is_Ghost (Defer_Res206) then
            Transform_Res128.Last_Attempted_Child := -1;
         end if;
         if Defer_Res207 /= null and then Is_Incomplete (Defer_Res207) then
            Transform_Res128.Last_Attempted_Child := 0;
         elsif Defer_Res207 /= null and then not Is_Ghost (Defer_Res207) then
            Transform_Res128.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos148 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags128);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Value_Range_Transform_Parse0_Memo,
      Row_Pos148 /= No_Token_Index,
      Transform_Res128,
      Pos,
      Row_Pos148);


   Parser.Current_Pos := Row_Pos148;

   return Transform_Res128;
end Value_Range_Transform_Parse0;

   


function Variable_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Variable
is
   use Bare_Variable_Memos;

      Row_Pos149 :
            Token_Index
               := No_Token_Index;
      Defer_Pos208 :
            Token_Index
               := No_Token_Index;
      Defer_Res208 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Transform_Res129 :
            Bare_Variable
               := No_Bare_R_F_L_X_Node;
      Transform_Diags129 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Variable_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res129 := M.Instance;
      return Transform_Res129;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res129;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags129 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos149 := Pos;



Defer_Res208 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Row_Pos149);
Defer_Pos208 := Parser.Current_Pos;




if Defer_Pos208 /= No_Token_Index then

   Row_Pos149 := Defer_Pos208;

else
   Row_Pos149 := No_Token_Index;
   goto Exit_Row149_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row149_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos149 /= No_Token_Index then

   Transform_Res129 := Allocate_Variable (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res129,
      Kind => Rflx_Variable,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos149 = Pos
                            then No_Token_Index
                            else Row_Pos149 - 1));

      Initialize_Fields_For_Variable
        (Self => Transform_Res129, Variable_F_Identifier => Defer_Res208);

         if Defer_Res208 /= null and then Is_Incomplete (Defer_Res208) then
            Transform_Res129.Last_Attempted_Child := 0;
         elsif Defer_Res208 /= null and then not Is_Ghost (Defer_Res208) then
            Transform_Res129.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos149 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags129);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Variable_Transform_Parse0_Memo,
      Row_Pos149 /= No_Token_Index,
      Transform_Res129,
      Pos,
      Row_Pos149);


   Parser.Current_Pos := Row_Pos149;

   return Transform_Res129;
end Variable_Transform_Parse0;

   


function Variable_Declaration_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Variable_Decl
is
   use Bare_Variable_Decl_Memos;

      Row_Pos150 :
            Token_Index
               := No_Token_Index;
      Defer_Pos209 :
            Token_Index
               := No_Token_Index;
      Defer_Res209 :
            Bare_Unqualified_I_D
               := No_Bare_R_F_L_X_Node;
      Token_Pos270 :
            Token_Index
               := No_Token_Index;
      Token_Res270 :
            Token_Index
               := No_Token_Index;
      Defer_Pos210 :
            Token_Index
               := No_Token_Index;
      Defer_Res210 :
            Bare_I_D
               := No_Bare_R_F_L_X_Node;
      Row_Pos151 :
            Token_Index
               := No_Token_Index;
      Token_Pos271 :
            Token_Index
               := No_Token_Index;
      Token_Res271 :
            Token_Index
               := No_Token_Index;
      Defer_Pos211 :
            Token_Index
               := No_Token_Index;
      Defer_Res211 :
            Bare_Expr
               := No_Bare_R_F_L_X_Node;
      Transform_Res130 :
            Bare_Variable_Decl
               := No_Bare_R_F_L_X_Node;
      Transform_Diags130 :
            Ada.Containers.Count_Type;


   M : Memo_Entry := Get (Parser.Private_Part.Variable_Declaration_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res130 := M.Instance;
      return Transform_Res130;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res130;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code

Transform_Diags130 := Parser.Diagnostics.Length;


--  Start row_code

Row_Pos150 := Pos;



Defer_Res209 :=
   Unqualified_Identifier_Transform_Parse0 (Parser, Row_Pos150);
Defer_Pos209 := Parser.Current_Pos;




if Defer_Pos209 /= No_Token_Index then

   Row_Pos150 := Defer_Pos209;

else
   Row_Pos150 := No_Token_Index;
   goto Exit_Row150_0;

end if;


--  Start tok_code

Token_Res270 := Row_Pos150;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res270));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Colon)
   then
       Token_Pos270 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos150 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos150,
             Expected_Token_Id => Rflx_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos270 := Row_Pos150 + 1;
   end if;
end;

--  End tok_code




if Token_Pos270 /= No_Token_Index then

   Row_Pos150 := Token_Pos270;

else
   Row_Pos150 := No_Token_Index;
   goto Exit_Row150_0;

end if;


Defer_Res210 :=
   Qualified_Identifier_Transform_Parse0 (Parser, Row_Pos150);
Defer_Pos210 := Parser.Current_Pos;




if Defer_Pos210 /= No_Token_Index then

   Row_Pos150 := Defer_Pos210;

else
   Row_Pos150 := No_Token_Index;
   goto Exit_Row150_0;

end if;


--  Start opt_code












--  Start row_code

Row_Pos151 := Row_Pos150;



--  Start tok_code

Token_Res271 := Row_Pos151;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res271));
begin
   if
      T.Kind /= From_Token_Kind (Rflx_Assignment)
   then
       Token_Pos271 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos151 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos151,
             Expected_Token_Id => Rflx_Assignment,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos271 := Row_Pos151 + 1;
   end if;
end;

--  End tok_code




if Token_Pos271 /= No_Token_Index then

   Row_Pos151 := Token_Pos271;

else
   Row_Pos151 := No_Token_Index;
   goto Exit_Row151_0;

end if;


Defer_Res211 :=
   Extended_Expression_Or_Parse1 (Parser, Row_Pos151);
Defer_Pos211 := Parser.Current_Pos;




if Defer_Pos211 /= No_Token_Index then

   Row_Pos151 := Defer_Pos211;

else
   Row_Pos151 := No_Token_Index;
   goto Exit_Row151_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row151_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos151 = No_Token_Index then

         
   Defer_Res211 := No_Bare_R_F_L_X_Node;



       
   Row_Pos151 := Row_Pos150;



end if;

--  End opt_code




if Row_Pos151 /= No_Token_Index then

   Row_Pos150 := Row_Pos151;

else
   Row_Pos150 := No_Token_Index;
   goto Exit_Row150_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row150_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos150 /= No_Token_Index then

   Transform_Res130 := Allocate_Variable_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res130,
      Kind => Rflx_Variable_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos150 = Pos
                            then No_Token_Index
                            else Row_Pos150 - 1));

      Initialize_Fields_For_Variable_Decl
        (Self => Transform_Res130, Variable_Decl_F_Identifier => Defer_Res209, Variable_Decl_F_Type_Identifier => Defer_Res210, Variable_Decl_F_Initializer => Defer_Res211);

         if Defer_Res209 /= null and then Is_Incomplete (Defer_Res209) then
            Transform_Res130.Last_Attempted_Child := 0;
         elsif Defer_Res209 /= null and then not Is_Ghost (Defer_Res209) then
            Transform_Res130.Last_Attempted_Child := -1;
         end if;
         if Defer_Res210 /= null and then Is_Incomplete (Defer_Res210) then
            Transform_Res130.Last_Attempted_Child := 0;
         elsif Defer_Res210 /= null and then not Is_Ghost (Defer_Res210) then
            Transform_Res130.Last_Attempted_Child := -1;
         end if;
         if Defer_Res211 /= null and then Is_Incomplete (Defer_Res211) then
            Transform_Res130.Last_Attempted_Child := 0;
         elsif Defer_Res211 /= null and then not Is_Ghost (Defer_Res211) then
            Transform_Res130.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos150 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags130);
end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Variable_Declaration_Transform_Parse0_Memo,
      Row_Pos150 /= No_Token_Index,
      Transform_Res130,
      Pos,
      Row_Pos150);


   Parser.Current_Pos := Row_Pos150;

   return Transform_Res130;
end Variable_Declaration_Transform_Parse0;


   -----------
   -- Reset --
   -----------

   procedure Reset (Parser : in out Parser_Type) is
      New_Parser : Parser_Type;
      --  We create this new parser instance to leverage creation of default
      --  values, so as to not repeat them.
   begin
      --  We just keep the private part, to not have to reallocate it
      New_Parser.Private_Part := Parser.Private_Part;

      --  And then reset everything else
      Parser := New_Parser;

      --  Reset the memo tables in the private part
         Bare_Statement_Memos.Clear
           (Parser.Private_Part.Action_Or_Parse0_Memo);
         Bare_Aspect_Memos.Clear
           (Parser.Private_Part.Aspect_Transform_Parse0_Memo);
         Bare_Assignment_Memos.Clear
           (Parser.Private_Part.Assignment_Statement_Transform_Parse0_Memo);
         Bare_Statement_Memos.Clear
           (Parser.Private_Part.Attribute_Statement_Or_Parse0_Memo);
         Bare_Declaration_Memos.Clear
           (Parser.Private_Part.Basic_Declaration_Or_Parse0_Memo);
         Bare_Declaration_List_Memos.Clear
           (Parser.Private_Part.Basic_Declarations_Extract_Parse0_Memo);
         Bare_Byte_Order_Aspect_Memos.Clear
           (Parser.Private_Part.Byte_Order_Aspect_Transform_Parse2_Memo);
         Bare_Call_Memos.Clear
           (Parser.Private_Part.Call_Transform_Parse0_Memo);
         Bare_Formal_Channel_Decl_Memos.Clear
           (Parser.Private_Part.Channel_Declaration_Transform_Parse2_Memo);
         Bare_Checksum_Aspect_Memos.Clear
           (Parser.Private_Part.Checksum_Aspect_Transform_Parse0_Memo);
         Bare_Checksum_Assoc_Memos.Clear
           (Parser.Private_Part.Checksum_Association_Transform_Parse1_Memo);
         Bare_Comprehension_Memos.Clear
           (Parser.Private_Part.Comprehension_Transform_Parse0_Memo);
         Bare_Sequence_Literal_Memos.Clear
           (Parser.Private_Part.Concatenation_Or_Parse2_Memo);
         Bare_Conditional_Transition_Memos.Clear
           (Parser.Private_Part.Conditional_Transition_Transform_Parse0_Memo);
         Bare_Context_Item_List_Memos.Clear
           (Parser.Private_Part.Context_Clause_List_Parse0_Memo);
         Bare_Context_Item_Memos.Clear
           (Parser.Private_Part.Context_Item_Transform_Parse0_Memo);
         Bare_Conversion_Memos.Clear
           (Parser.Private_Part.Conversion_Transform_Parse0_Memo);
         Bare_Local_Decl_Memos.Clear
           (Parser.Private_Part.Declaration_Or_Parse0_Memo);
         Bare_Description_Memos.Clear
           (Parser.Private_Part.Description_Aspect_Transform_Parse0_Memo);
         Bare_Element_Value_Assoc_Memos.Clear
           (Parser.Private_Part.Element_Value_Association_Transform_Parse0_Memo);
         Bare_Aspect_List_Memos.Clear
           (Parser.Private_Part.Enumeration_Aspects_List_Parse0_Memo);
         Bare_Enumeration_Type_Def_Memos.Clear
           (Parser.Private_Part.Enumeration_Type_Definition_Transform_Parse0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Expression_Or_Parse1_Memo);
         Bare_Case_Expression_Memos.Clear
           (Parser.Private_Part.Extended_Case_Expression_Transform_Parse0_Memo);
         Bare_R_F_L_X_Node_List_Memos.Clear
           (Parser.Private_Part.Extended_Choice_List_List_Parse0_Memo);
         Bare_Choice_Memos.Clear
           (Parser.Private_Part.Extended_Choices_Transform_Parse0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Expression_Or_Parse1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Factor_Or_Parse1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_If_Condition_Extract_Parse0_Memo);
         Bare_Paren_Expression_Memos.Clear
           (Parser.Private_Part.Extended_Paren_Expression_Transform_Parse0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Primary_Or_Parse0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Relation_Or_Parse1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Simple_Expr_Or_Parse1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Suffix_Or_Parse1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Term_Or_Parse1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Unop_Term_Or_Parse0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Factor_Or_Parse0_Memo);
         Bare_Formal_Function_Decl_Memos.Clear
           (Parser.Private_Part.Formal_Function_Declaration_Transform_Parse0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.If_Condition_Extract_Parse0_Memo);
         Bare_Integer_Type_Def_Memos.Clear
           (Parser.Private_Part.Integer_Type_Definition_Or_Parse0_Memo);
         Bare_Attribute_Statement_Memos.Clear
           (Parser.Private_Part.List_Attribute_Transform_Parse4_Memo);
         Bare_Specification_Memos.Clear
           (Parser.Private_Part.Main_Rule_Defer_Parse0_Memo);
         Bare_Message_Aggregate_Associations_Memos.Clear
           (Parser.Private_Part.Message_Aggregate_Association_List_Transform_Parse0_Memo);
         Bare_Message_Aggregate_Association_Memos.Clear
           (Parser.Private_Part.Message_Aggregate_Association_Transform_Parse0_Memo);
         Bare_Message_Aggregate_Memos.Clear
           (Parser.Private_Part.Message_Aggregate_Transform_Parse0_Memo);
         Bare_Message_Aspect_List_Memos.Clear
           (Parser.Private_Part.Message_Aspect_List_List_Parse0_Memo);
         Bare_Message_Field_Assignment_Memos.Clear
           (Parser.Private_Part.Message_Field_Assignment_Statement_Transform_Parse0_Memo);
         Bare_Message_Fields_Memos.Clear
           (Parser.Private_Part.Message_Field_List_Transform_Parse0_Memo);
         Bare_Message_Field_Memos.Clear
           (Parser.Private_Part.Message_Field_Transform_Parse0_Memo);
         Bare_Abstract_Message_Type_Def_Memos.Clear
           (Parser.Private_Part.Message_Type_Definition_Or_Parse0_Memo);
         Bare_Modular_Type_Def_Memos.Clear
           (Parser.Private_Part.Modular_Type_Definition_Transform_Parse0_Memo);
         Bare_Named_Enumeration_Def_Memos.Clear
           (Parser.Private_Part.Named_Enumeration_Transform_Parse0_Memo);
         Bare_Null_Message_Aggregate_Memos.Clear
           (Parser.Private_Part.Null_Message_Aggregate_Transform_Parse0_Memo);
         Bare_Null_Message_Field_Memos.Clear
           (Parser.Private_Part.Null_Message_Field_Transform_Parse0_Memo);
         Bare_Numeric_Literal_Memos.Clear
           (Parser.Private_Part.Numeric_Literal_Transform_Parse0_Memo);
         Bare_Package_Node_Memos.Clear
           (Parser.Private_Part.Package_Declaration_Transform_Parse0_Memo);
         Bare_Parameters_Memos.Clear
           (Parser.Private_Part.Parameter_List_Transform_Parse0_Memo);
         Bare_Parameter_Memos.Clear
           (Parser.Private_Part.Parameter_Transform_Parse0_Memo);
         Bare_Paren_Expression_Memos.Clear
           (Parser.Private_Part.Paren_Expression_Transform_Parse0_Memo);
         Bare_Positional_Enumeration_Def_Memos.Clear
           (Parser.Private_Part.Positional_Enumeration_Transform_Parse0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Primary_Or_Parse0_Memo);
         Bare_I_D_Memos.Clear
           (Parser.Private_Part.Qualified_Identifier_Transform_Parse0_Memo);
         Bare_Quantified_Expression_Memos.Clear
           (Parser.Private_Part.Quantified_Expression_Transform_Parse2_Memo);
         Bare_Range_Type_Def_Memos.Clear
           (Parser.Private_Part.Range_Type_Definition_Transform_Parse0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Relation_Or_Parse1_Memo);
         Bare_Renaming_Decl_Memos.Clear
           (Parser.Private_Part.Renaming_Declaration_Transform_Parse0_Memo);
         Bare_Reset_Memos.Clear
           (Parser.Private_Part.Reset_Transform_Parse0_Memo);
         Bare_Sequence_Aggregate_Memos.Clear
           (Parser.Private_Part.Sequence_Aggregate_Transform_Parse0_Memo);
         Bare_Sequence_Type_Def_Memos.Clear
           (Parser.Private_Part.Sequence_Type_Definition_Transform_Parse0_Memo);
         Bare_Session_Decl_Memos.Clear
           (Parser.Private_Part.Session_Declaration_Transform_Parse0_Memo);
         Bare_Formal_Decl_Memos.Clear
           (Parser.Private_Part.Session_Parameter_Or_Parse0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Simple_Expr_Or_Parse1_Memo);
         Bare_Specification_Memos.Clear
           (Parser.Private_Part.Specification_Transform_Parse0_Memo);
         Bare_State_Body_Memos.Clear
           (Parser.Private_Part.State_Body_Transform_Parse0_Memo);
         Bare_State_Memos.Clear
           (Parser.Private_Part.State_Transform_Parse0_Memo);
         Bare_String_Literal_Memos.Clear
           (Parser.Private_Part.String_Literal_Transform_Parse0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Suffix_Or_Parse1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Term_Or_Parse1_Memo);
         Bare_Then_Node_Memos.Clear
           (Parser.Private_Part.Then_Transform_Parse0_Memo);
         Bare_Transition_Memos.Clear
           (Parser.Private_Part.Transition_Transform_Parse0_Memo);
         Bare_Type_Argument_Memos.Clear
           (Parser.Private_Part.Type_Argument_Transform_Parse0_Memo);
         Bare_Type_Decl_Memos.Clear
           (Parser.Private_Part.Type_Declaration_Transform_Parse0_Memo);
         Bare_Type_Derivation_Def_Memos.Clear
           (Parser.Private_Part.Type_Derivation_Definition_Transform_Parse0_Memo);
         Bare_Refinement_Decl_Memos.Clear
           (Parser.Private_Part.Type_Refinement_Transform_Parse0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Unop_Term_Or_Parse0_Memo);
         Bare_Unqualified_I_D_Memos.Clear
           (Parser.Private_Part.Unqualified_Identifier_Transform_Parse0_Memo);
         Bare_Checksum_Value_Range_Memos.Clear
           (Parser.Private_Part.Value_Range_Transform_Parse0_Memo);
         Bare_Variable_Decl_Memos.Clear
           (Parser.Private_Part.Variable_Declaration_Transform_Parse0_Memo);
         Bare_Variable_Memos.Clear
           (Parser.Private_Part.Variable_Transform_Parse0_Memo);
   end Reset;

   -------------
   -- Destroy --
   -------------

   procedure Destroy (Parser : in out Parser_Type) is
      procedure Free is new Ada.Unchecked_Deallocation
        (Parser_Private_Part_Type, Parser_Private_Part);
      procedure Free is new Ada.Unchecked_Deallocation
        (Free_Parse_List_Record, Free_Parse_List);

      Cur : Free_Parse_List renames Parser.Private_Part.Parse_Lists;
   begin
      while Cur /= null loop
         declare
            Next : constant Free_Parse_List := Cur.Next;
         begin
            Cur.Nodes.Destroy;
            Free (Cur);
            Cur := Next;
         end;
      end loop;
      Free (Parser.Private_Part);
   end Destroy;

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize (Parser : in out Parser_Type) is
   begin
      Parser.Private_Part := new Parser_Private_Part_Type'(others => <>);
   end Initialize;

   --------------------
   -- Get_Parse_List --
   --------------------

   function Get_Parse_List (Parser : Parser_Type) return Free_Parse_List is
      Lists  : Free_Parse_List renames Parser.Private_Part.Parse_Lists;
      Result : Free_Parse_List;
   begin
      if Lists = null then
         Result := new Free_Parse_List_Record;

      else
         Result := Lists;
         Lists := Lists.Next;
      end if;

      return Result;
   end Get_Parse_List;

   ------------------------
   -- Release_Parse_List --
   ------------------------

   procedure Release_Parse_List
     (Parser : Parser_Type; List : in out Free_Parse_List)
   is
      Lists  : Free_Parse_List renames Parser.Private_Part.Parse_Lists;
   begin
      List.Nodes.Clear;
      List.Next := Lists;
      Lists := List;
      List := null;
   end Release_Parse_List;

end Librflxlang.Parsers;
