
with Ada.Unchecked_Deallocation;

with Langkit_Support.Generic_API; use Langkit_Support.Generic_API;
pragma Warnings (Off, "referenced");
with Langkit_Support.Generic_API.Analysis;
use Langkit_Support.Generic_API.Analysis;
pragma Warnings (On, "referenced");
with Langkit_Support.Generic_API.Introspection;
use Langkit_Support.Generic_API.Introspection;
with Langkit_Support.Internal.Introspection;
use Langkit_Support.Internal.Introspection;
with Langkit_Support.Text;        use Langkit_Support.Text;

with Librflxlang.Analysis; use Librflxlang.Analysis;
with Librflxlang.Common;   use Librflxlang.Common;

--  This package provides description tables to enable the generic
--  introspection API in Langkit_Support to work with this Langkit-generated
--  library.

private package Librflxlang.Generic_Introspection is

   

   --------------------------
   -- Type index constants --
   --------------------------

      Type_Index_For_Analysis_Unit : constant Type_Index := 1;
      Type_Index_For_Big_Int : constant Type_Index := 2;
      Type_Index_For_Bool : constant Type_Index := 3;
      Type_Index_For_Character : constant Type_Index := 4;
      Type_Index_For_Int : constant Type_Index := 5;
      Type_Index_For_Source_Location_Range : constant Type_Index := 6;
      Type_Index_For_String : constant Type_Index := 7;
      Type_Index_For_Token : constant Type_Index := 8;
      Type_Index_For_Symbol : constant Type_Index := 9;
      Type_Index_For_Analysis_Unit_Kind : constant Type_Index := 10;
      Type_Index_For_Lookup_Kind : constant Type_Index := 11;
      Type_Index_For_Designated_Env_Kind : constant Type_Index := 12;
      Type_Index_For_Grammar_Rule : constant Type_Index := 13;
      Type_Index_For_R_F_L_X_Node_Array : constant Type_Index := 14;
      Type_Index_For_R_F_L_X_Node : constant Type_Index := 15;
      Type_Index_For_Abstract_I_D : constant Type_Index := 16;
      Type_Index_For_I_D : constant Type_Index := 17;
      Type_Index_For_Unqualified_I_D : constant Type_Index := 18;
      Type_Index_For_Aspect : constant Type_Index := 19;
      Type_Index_For_Attr : constant Type_Index := 20;
      Type_Index_For_Attr_First : constant Type_Index := 21;
      Type_Index_For_Attr_Has_Data : constant Type_Index := 22;
      Type_Index_For_Attr_Head : constant Type_Index := 23;
      Type_Index_For_Attr_Last : constant Type_Index := 24;
      Type_Index_For_Attr_Opaque : constant Type_Index := 25;
      Type_Index_For_Attr_Present : constant Type_Index := 26;
      Type_Index_For_Attr_Size : constant Type_Index := 27;
      Type_Index_For_Attr_Valid : constant Type_Index := 28;
      Type_Index_For_Attr_Valid_Checksum : constant Type_Index := 29;
      Type_Index_For_Attr_Stmt : constant Type_Index := 30;
      Type_Index_For_Attr_Stmt_Append : constant Type_Index := 31;
      Type_Index_For_Attr_Stmt_Extend : constant Type_Index := 32;
      Type_Index_For_Attr_Stmt_Read : constant Type_Index := 33;
      Type_Index_For_Attr_Stmt_Write : constant Type_Index := 34;
      Type_Index_For_Base_Aggregate : constant Type_Index := 35;
      Type_Index_For_Message_Aggregate_Associations : constant Type_Index := 36;
      Type_Index_For_Null_Message_Aggregate : constant Type_Index := 37;
      Type_Index_For_Base_Checksum_Val : constant Type_Index := 38;
      Type_Index_For_Checksum_Val : constant Type_Index := 39;
      Type_Index_For_Checksum_Value_Range : constant Type_Index := 40;
      Type_Index_For_Byte_Order_Type : constant Type_Index := 41;
      Type_Index_For_Byte_Order_Type_Highorderfirst : constant Type_Index := 42;
      Type_Index_For_Byte_Order_Type_Loworderfirst : constant Type_Index := 43;
      Type_Index_For_Channel_Attribute : constant Type_Index := 44;
      Type_Index_For_Readable : constant Type_Index := 45;
      Type_Index_For_Writable : constant Type_Index := 46;
      Type_Index_For_Checksum_Assoc : constant Type_Index := 47;
      Type_Index_For_Declaration : constant Type_Index := 48;
      Type_Index_For_Refinement_Decl : constant Type_Index := 49;
      Type_Index_For_Session_Decl : constant Type_Index := 50;
      Type_Index_For_Type_Decl : constant Type_Index := 51;
      Type_Index_For_Description : constant Type_Index := 52;
      Type_Index_For_Element_Value_Assoc : constant Type_Index := 53;
      Type_Index_For_Expr : constant Type_Index := 54;
      Type_Index_For_Attribute : constant Type_Index := 55;
      Type_Index_For_Bin_Op : constant Type_Index := 56;
      Type_Index_For_Binding : constant Type_Index := 57;
      Type_Index_For_Call : constant Type_Index := 58;
      Type_Index_For_Case_Expression : constant Type_Index := 59;
      Type_Index_For_Choice : constant Type_Index := 60;
      Type_Index_For_Comprehension : constant Type_Index := 61;
      Type_Index_For_Context_Item : constant Type_Index := 62;
      Type_Index_For_Conversion : constant Type_Index := 63;
      Type_Index_For_Message_Aggregate : constant Type_Index := 64;
      Type_Index_For_Negation : constant Type_Index := 65;
      Type_Index_For_Numeric_Literal : constant Type_Index := 66;
      Type_Index_For_Paren_Expression : constant Type_Index := 67;
      Type_Index_For_Quantified_Expression : constant Type_Index := 68;
      Type_Index_For_Select : constant Type_Index := 69;
      Type_Index_For_Sequence_Literal : constant Type_Index := 70;
      Type_Index_For_Concatenation : constant Type_Index := 71;
      Type_Index_For_Sequence_Aggregate : constant Type_Index := 72;
      Type_Index_For_String_Literal : constant Type_Index := 73;
      Type_Index_For_Variable : constant Type_Index := 74;
      Type_Index_For_Formal_Decl : constant Type_Index := 75;
      Type_Index_For_Formal_Channel_Decl : constant Type_Index := 76;
      Type_Index_For_Formal_Function_Decl : constant Type_Index := 77;
      Type_Index_For_Local_Decl : constant Type_Index := 78;
      Type_Index_For_Renaming_Decl : constant Type_Index := 79;
      Type_Index_For_Variable_Decl : constant Type_Index := 80;
      Type_Index_For_Message_Aggregate_Association : constant Type_Index := 81;
      Type_Index_For_Message_Aspect : constant Type_Index := 82;
      Type_Index_For_Byte_Order_Aspect : constant Type_Index := 83;
      Type_Index_For_Checksum_Aspect : constant Type_Index := 84;
      Type_Index_For_Message_Field : constant Type_Index := 85;
      Type_Index_For_Message_Fields : constant Type_Index := 86;
      Type_Index_For_Null_Message_Field : constant Type_Index := 87;
      Type_Index_For_Op : constant Type_Index := 88;
      Type_Index_For_Op_Add : constant Type_Index := 89;
      Type_Index_For_Op_And : constant Type_Index := 90;
      Type_Index_For_Op_Div : constant Type_Index := 91;
      Type_Index_For_Op_Eq : constant Type_Index := 92;
      Type_Index_For_Op_Ge : constant Type_Index := 93;
      Type_Index_For_Op_Gt : constant Type_Index := 94;
      Type_Index_For_Op_In : constant Type_Index := 95;
      Type_Index_For_Op_Le : constant Type_Index := 96;
      Type_Index_For_Op_Lt : constant Type_Index := 97;
      Type_Index_For_Op_Mod : constant Type_Index := 98;
      Type_Index_For_Op_Mul : constant Type_Index := 99;
      Type_Index_For_Op_Neq : constant Type_Index := 100;
      Type_Index_For_Op_Notin : constant Type_Index := 101;
      Type_Index_For_Op_Or : constant Type_Index := 102;
      Type_Index_For_Op_Pow : constant Type_Index := 103;
      Type_Index_For_Op_Sub : constant Type_Index := 104;
      Type_Index_For_Package : constant Type_Index := 105;
      Type_Index_For_Parameter : constant Type_Index := 106;
      Type_Index_For_Parameters : constant Type_Index := 107;
      Type_Index_For_Quantifier : constant Type_Index := 108;
      Type_Index_For_Quantifier_All : constant Type_Index := 109;
      Type_Index_For_Quantifier_Some : constant Type_Index := 110;
      Type_Index_For_R_F_L_X_Node_Base_List : constant Type_Index := 111;
      Type_Index_For_Aspect_List : constant Type_Index := 112;
      Type_Index_For_Base_Checksum_Val_List : constant Type_Index := 113;
      Type_Index_For_Channel_Attribute_List : constant Type_Index := 114;
      Type_Index_For_Checksum_Assoc_List : constant Type_Index := 115;
      Type_Index_For_Choice_List : constant Type_Index := 116;
      Type_Index_For_Conditional_Transition_List : constant Type_Index := 117;
      Type_Index_For_Context_Item_List : constant Type_Index := 118;
      Type_Index_For_Declaration_List : constant Type_Index := 119;
      Type_Index_For_Element_Value_Assoc_List : constant Type_Index := 120;
      Type_Index_For_Expr_List : constant Type_Index := 121;
      Type_Index_For_Formal_Decl_List : constant Type_Index := 122;
      Type_Index_For_Local_Decl_List : constant Type_Index := 123;
      Type_Index_For_Message_Aggregate_Association_List : constant Type_Index := 124;
      Type_Index_For_Message_Aspect_List : constant Type_Index := 125;
      Type_Index_For_Message_Field_List : constant Type_Index := 126;
      Type_Index_For_Numeric_Literal_List : constant Type_Index := 127;
      Type_Index_For_Parameter_List : constant Type_Index := 128;
      Type_Index_For_R_F_L_X_Node_List : constant Type_Index := 129;
      Type_Index_For_State_List : constant Type_Index := 130;
      Type_Index_For_Statement_List : constant Type_Index := 131;
      Type_Index_For_Term_Assoc_List : constant Type_Index := 132;
      Type_Index_For_Then_Node_List : constant Type_Index := 133;
      Type_Index_For_Type_Argument_List : constant Type_Index := 134;
      Type_Index_For_Unqualified_I_D_List : constant Type_Index := 135;
      Type_Index_For_Specification : constant Type_Index := 136;
      Type_Index_For_State : constant Type_Index := 137;
      Type_Index_For_State_Body : constant Type_Index := 138;
      Type_Index_For_Statement : constant Type_Index := 139;
      Type_Index_For_Assignment : constant Type_Index := 140;
      Type_Index_For_Attribute_Statement : constant Type_Index := 141;
      Type_Index_For_Message_Field_Assignment : constant Type_Index := 142;
      Type_Index_For_Reset : constant Type_Index := 143;
      Type_Index_For_Term_Assoc : constant Type_Index := 144;
      Type_Index_For_Then : constant Type_Index := 145;
      Type_Index_For_Transition : constant Type_Index := 146;
      Type_Index_For_Conditional_Transition : constant Type_Index := 147;
      Type_Index_For_Type_Argument : constant Type_Index := 148;
      Type_Index_For_Type_Def : constant Type_Index := 149;
      Type_Index_For_Abstract_Message_Type_Def : constant Type_Index := 150;
      Type_Index_For_Message_Type_Def : constant Type_Index := 151;
      Type_Index_For_Null_Message_Type_Def : constant Type_Index := 152;
      Type_Index_For_Enumeration_Def : constant Type_Index := 153;
      Type_Index_For_Named_Enumeration_Def : constant Type_Index := 154;
      Type_Index_For_Positional_Enumeration_Def : constant Type_Index := 155;
      Type_Index_For_Enumeration_Type_Def : constant Type_Index := 156;
      Type_Index_For_Integer_Type_Def : constant Type_Index := 157;
      Type_Index_For_Modular_Type_Def : constant Type_Index := 158;
      Type_Index_For_Range_Type_Def : constant Type_Index := 159;
      Type_Index_For_Sequence_Type_Def : constant Type_Index := 160;
      Type_Index_For_Type_Derivation_Def : constant Type_Index := 161;

   ----------------------------
   -- Member index constants --
   ----------------------------

      Member_Index_For_I_D_F_Package : constant Struct_Member_Index := 1;
      Member_Index_For_I_D_F_Name : constant Struct_Member_Index := 2;
      Member_Index_For_Aspect_F_Identifier : constant Struct_Member_Index := 3;
      Member_Index_For_Aspect_F_Value : constant Struct_Member_Index := 4;
      Member_Index_For_Message_Aggregate_Associations_F_Associations : constant Struct_Member_Index := 5;
      Member_Index_For_Checksum_Val_F_Data : constant Struct_Member_Index := 6;
      Member_Index_For_Checksum_Value_Range_F_First : constant Struct_Member_Index := 7;
      Member_Index_For_Checksum_Value_Range_F_Last : constant Struct_Member_Index := 8;
      Member_Index_For_Checksum_Assoc_F_Identifier : constant Struct_Member_Index := 9;
      Member_Index_For_Checksum_Assoc_F_Covered_Fields : constant Struct_Member_Index := 10;
      Member_Index_For_Refinement_Decl_F_Pdu : constant Struct_Member_Index := 11;
      Member_Index_For_Refinement_Decl_F_Field : constant Struct_Member_Index := 12;
      Member_Index_For_Refinement_Decl_F_Sdu : constant Struct_Member_Index := 13;
      Member_Index_For_Refinement_Decl_F_Condition : constant Struct_Member_Index := 14;
      Member_Index_For_Session_Decl_F_Parameters : constant Struct_Member_Index := 15;
      Member_Index_For_Session_Decl_F_Identifier : constant Struct_Member_Index := 16;
      Member_Index_For_Session_Decl_F_Declarations : constant Struct_Member_Index := 17;
      Member_Index_For_Session_Decl_F_States : constant Struct_Member_Index := 18;
      Member_Index_For_Session_Decl_F_End_Identifier : constant Struct_Member_Index := 19;
      Member_Index_For_Type_Decl_F_Identifier : constant Struct_Member_Index := 20;
      Member_Index_For_Type_Decl_F_Parameters : constant Struct_Member_Index := 21;
      Member_Index_For_Type_Decl_F_Definition : constant Struct_Member_Index := 22;
      Member_Index_For_Description_F_Content : constant Struct_Member_Index := 23;
      Member_Index_For_Element_Value_Assoc_F_Identifier : constant Struct_Member_Index := 24;
      Member_Index_For_Element_Value_Assoc_F_Literal : constant Struct_Member_Index := 25;
      Member_Index_For_Attribute_F_Expression : constant Struct_Member_Index := 26;
      Member_Index_For_Attribute_F_Kind : constant Struct_Member_Index := 27;
      Member_Index_For_Bin_Op_F_Left : constant Struct_Member_Index := 28;
      Member_Index_For_Bin_Op_F_Op : constant Struct_Member_Index := 29;
      Member_Index_For_Bin_Op_F_Right : constant Struct_Member_Index := 30;
      Member_Index_For_Binding_F_Expression : constant Struct_Member_Index := 31;
      Member_Index_For_Binding_F_Bindings : constant Struct_Member_Index := 32;
      Member_Index_For_Call_F_Identifier : constant Struct_Member_Index := 33;
      Member_Index_For_Call_F_Arguments : constant Struct_Member_Index := 34;
      Member_Index_For_Case_Expression_F_Expression : constant Struct_Member_Index := 35;
      Member_Index_For_Case_Expression_F_Choices : constant Struct_Member_Index := 36;
      Member_Index_For_Choice_F_Selectors : constant Struct_Member_Index := 37;
      Member_Index_For_Choice_F_Expression : constant Struct_Member_Index := 38;
      Member_Index_For_Comprehension_F_Iterator : constant Struct_Member_Index := 39;
      Member_Index_For_Comprehension_F_Sequence : constant Struct_Member_Index := 40;
      Member_Index_For_Comprehension_F_Condition : constant Struct_Member_Index := 41;
      Member_Index_For_Comprehension_F_Selector : constant Struct_Member_Index := 42;
      Member_Index_For_Context_Item_F_Item : constant Struct_Member_Index := 43;
      Member_Index_For_Conversion_F_Target_Identifier : constant Struct_Member_Index := 44;
      Member_Index_For_Conversion_F_Argument : constant Struct_Member_Index := 45;
      Member_Index_For_Message_Aggregate_F_Identifier : constant Struct_Member_Index := 46;
      Member_Index_For_Message_Aggregate_F_Values : constant Struct_Member_Index := 47;
      Member_Index_For_Negation_F_Data : constant Struct_Member_Index := 48;
      Member_Index_For_Paren_Expression_F_Data : constant Struct_Member_Index := 49;
      Member_Index_For_Quantified_Expression_F_Operation : constant Struct_Member_Index := 50;
      Member_Index_For_Quantified_Expression_F_Parameter_Identifier : constant Struct_Member_Index := 51;
      Member_Index_For_Quantified_Expression_F_Iterable : constant Struct_Member_Index := 52;
      Member_Index_For_Quantified_Expression_F_Predicate : constant Struct_Member_Index := 53;
      Member_Index_For_Select_Node_F_Expression : constant Struct_Member_Index := 54;
      Member_Index_For_Select_Node_F_Selector : constant Struct_Member_Index := 55;
      Member_Index_For_Concatenation_F_Left : constant Struct_Member_Index := 56;
      Member_Index_For_Concatenation_F_Right : constant Struct_Member_Index := 57;
      Member_Index_For_Sequence_Aggregate_F_Values : constant Struct_Member_Index := 58;
      Member_Index_For_Variable_F_Identifier : constant Struct_Member_Index := 59;
      Member_Index_For_Formal_Channel_Decl_F_Identifier : constant Struct_Member_Index := 60;
      Member_Index_For_Formal_Channel_Decl_F_Parameters : constant Struct_Member_Index := 61;
      Member_Index_For_Formal_Function_Decl_F_Identifier : constant Struct_Member_Index := 62;
      Member_Index_For_Formal_Function_Decl_F_Parameters : constant Struct_Member_Index := 63;
      Member_Index_For_Formal_Function_Decl_F_Return_Type_Identifier : constant Struct_Member_Index := 64;
      Member_Index_For_Renaming_Decl_F_Identifier : constant Struct_Member_Index := 65;
      Member_Index_For_Renaming_Decl_F_Type_Identifier : constant Struct_Member_Index := 66;
      Member_Index_For_Renaming_Decl_F_Expression : constant Struct_Member_Index := 67;
      Member_Index_For_Variable_Decl_F_Identifier : constant Struct_Member_Index := 68;
      Member_Index_For_Variable_Decl_F_Type_Identifier : constant Struct_Member_Index := 69;
      Member_Index_For_Variable_Decl_F_Initializer : constant Struct_Member_Index := 70;
      Member_Index_For_Message_Aggregate_Association_F_Identifier : constant Struct_Member_Index := 71;
      Member_Index_For_Message_Aggregate_Association_F_Expression : constant Struct_Member_Index := 72;
      Member_Index_For_Byte_Order_Aspect_F_Byte_Order : constant Struct_Member_Index := 73;
      Member_Index_For_Checksum_Aspect_F_Associations : constant Struct_Member_Index := 74;
      Member_Index_For_Message_Field_F_Identifier : constant Struct_Member_Index := 75;
      Member_Index_For_Message_Field_F_Type_Identifier : constant Struct_Member_Index := 76;
      Member_Index_For_Message_Field_F_Type_Arguments : constant Struct_Member_Index := 77;
      Member_Index_For_Message_Field_F_Aspects : constant Struct_Member_Index := 78;
      Member_Index_For_Message_Field_F_Condition : constant Struct_Member_Index := 79;
      Member_Index_For_Message_Field_F_Thens : constant Struct_Member_Index := 80;
      Member_Index_For_Message_Fields_F_Initial_Field : constant Struct_Member_Index := 81;
      Member_Index_For_Message_Fields_F_Fields : constant Struct_Member_Index := 82;
      Member_Index_For_Null_Message_Field_F_Then : constant Struct_Member_Index := 83;
      Member_Index_For_Package_Node_F_Identifier : constant Struct_Member_Index := 84;
      Member_Index_For_Package_Node_F_Declarations : constant Struct_Member_Index := 85;
      Member_Index_For_Package_Node_F_End_Identifier : constant Struct_Member_Index := 86;
      Member_Index_For_Parameter_F_Identifier : constant Struct_Member_Index := 87;
      Member_Index_For_Parameter_F_Type_Identifier : constant Struct_Member_Index := 88;
      Member_Index_For_Parameters_F_Parameters : constant Struct_Member_Index := 89;
      Member_Index_For_Specification_F_Context_Clause : constant Struct_Member_Index := 90;
      Member_Index_For_Specification_F_Package_Declaration : constant Struct_Member_Index := 91;
      Member_Index_For_State_F_Identifier : constant Struct_Member_Index := 92;
      Member_Index_For_State_F_Description : constant Struct_Member_Index := 93;
      Member_Index_For_State_F_Body : constant Struct_Member_Index := 94;
      Member_Index_For_State_Body_F_Declarations : constant Struct_Member_Index := 95;
      Member_Index_For_State_Body_F_Actions : constant Struct_Member_Index := 96;
      Member_Index_For_State_Body_F_Conditional_Transitions : constant Struct_Member_Index := 97;
      Member_Index_For_State_Body_F_Final_Transition : constant Struct_Member_Index := 98;
      Member_Index_For_State_Body_F_Exception_Transition : constant Struct_Member_Index := 99;
      Member_Index_For_State_Body_F_End_Identifier : constant Struct_Member_Index := 100;
      Member_Index_For_Assignment_F_Identifier : constant Struct_Member_Index := 101;
      Member_Index_For_Assignment_F_Expression : constant Struct_Member_Index := 102;
      Member_Index_For_Attribute_Statement_F_Identifier : constant Struct_Member_Index := 103;
      Member_Index_For_Attribute_Statement_F_Attr : constant Struct_Member_Index := 104;
      Member_Index_For_Attribute_Statement_F_Expression : constant Struct_Member_Index := 105;
      Member_Index_For_Message_Field_Assignment_F_Message : constant Struct_Member_Index := 106;
      Member_Index_For_Message_Field_Assignment_F_Field : constant Struct_Member_Index := 107;
      Member_Index_For_Message_Field_Assignment_F_Expression : constant Struct_Member_Index := 108;
      Member_Index_For_Reset_F_Identifier : constant Struct_Member_Index := 109;
      Member_Index_For_Reset_F_Associations : constant Struct_Member_Index := 110;
      Member_Index_For_Term_Assoc_F_Identifier : constant Struct_Member_Index := 111;
      Member_Index_For_Term_Assoc_F_Expression : constant Struct_Member_Index := 112;
      Member_Index_For_Then_Node_F_Target : constant Struct_Member_Index := 113;
      Member_Index_For_Then_Node_F_Aspects : constant Struct_Member_Index := 114;
      Member_Index_For_Then_Node_F_Condition : constant Struct_Member_Index := 115;
      Member_Index_For_Transition_F_Target : constant Struct_Member_Index := 116;
      Member_Index_For_Transition_F_Description : constant Struct_Member_Index := 117;
      Member_Index_For_Conditional_Transition_F_Condition : constant Struct_Member_Index := 118;
      Member_Index_For_Type_Argument_F_Identifier : constant Struct_Member_Index := 119;
      Member_Index_For_Type_Argument_F_Expression : constant Struct_Member_Index := 120;
      Member_Index_For_Message_Type_Def_F_Message_Fields : constant Struct_Member_Index := 121;
      Member_Index_For_Message_Type_Def_F_Aspects : constant Struct_Member_Index := 122;
      Member_Index_For_Named_Enumeration_Def_F_Elements : constant Struct_Member_Index := 123;
      Member_Index_For_Positional_Enumeration_Def_F_Elements : constant Struct_Member_Index := 124;
      Member_Index_For_Enumeration_Type_Def_F_Elements : constant Struct_Member_Index := 125;
      Member_Index_For_Enumeration_Type_Def_F_Aspects : constant Struct_Member_Index := 126;
      Member_Index_For_Modular_Type_Def_F_Mod : constant Struct_Member_Index := 127;
      Member_Index_For_Range_Type_Def_F_First : constant Struct_Member_Index := 128;
      Member_Index_For_Range_Type_Def_F_Last : constant Struct_Member_Index := 129;
      Member_Index_For_Range_Type_Def_F_Size : constant Struct_Member_Index := 130;
      Member_Index_For_Sequence_Type_Def_F_Element_Type : constant Struct_Member_Index := 131;
      Member_Index_For_Type_Derivation_Def_F_Base : constant Struct_Member_Index := 132;
      Member_Index_For_Parent : constant Struct_Member_Index := 133;
      Member_Index_For_Parents : constant Struct_Member_Index := 134;
      Member_Index_For_Children : constant Struct_Member_Index := 135;
      Member_Index_For_Token_Start : constant Struct_Member_Index := 136;
      Member_Index_For_Token_End : constant Struct_Member_Index := 137;
      Member_Index_For_Child_Index : constant Struct_Member_Index := 138;
      Member_Index_For_Previous_Sibling : constant Struct_Member_Index := 139;
      Member_Index_For_Next_Sibling : constant Struct_Member_Index := 140;
      Member_Index_For_Unit : constant Struct_Member_Index := 141;
      Member_Index_For_Is_Ghost : constant Struct_Member_Index := 142;
      Member_Index_For_Full_Sloc_Image : constant Struct_Member_Index := 143;

   ------------------------------
   -- Grammar rule descriptors --
   ------------------------------

   
      
      Rule_Name_1 : aliased constant Text_Type :=
        "Main_Rule";
      Rule_Doc_1 : aliased constant Text_Type :=
        "";
      Rule_Desc_1 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_1'Access,
         Is_Public   => True,
         Doc         => Rule_Doc_1'Access,
         Return_Type => Type_Index_For_Specification);
      
      Rule_Name_2 : aliased constant Text_Type :=
        "Unqualified_Identifier";
      Rule_Doc_2 : aliased constant Text_Type :=
        "";
      Rule_Desc_2 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_2'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_2'Access,
         Return_Type => Type_Index_For_Unqualified_I_D);
      
      Rule_Name_3 : aliased constant Text_Type :=
        "Qualified_Identifier";
      Rule_Doc_3 : aliased constant Text_Type :=
        "";
      Rule_Desc_3 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_3'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_3'Access,
         Return_Type => Type_Index_For_I_D);
      
      Rule_Name_4 : aliased constant Text_Type :=
        "Numeric_Literal";
      Rule_Doc_4 : aliased constant Text_Type :=
        "";
      Rule_Desc_4 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_4'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_4'Access,
         Return_Type => Type_Index_For_Numeric_Literal);
      
      Rule_Name_5 : aliased constant Text_Type :=
        "Variable";
      Rule_Doc_5 : aliased constant Text_Type :=
        "";
      Rule_Desc_5 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_5'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_5'Access,
         Return_Type => Type_Index_For_Variable);
      
      Rule_Name_6 : aliased constant Text_Type :=
        "Sequence_Aggregate";
      Rule_Doc_6 : aliased constant Text_Type :=
        "";
      Rule_Desc_6 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_6'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_6'Access,
         Return_Type => Type_Index_For_Sequence_Aggregate);
      
      Rule_Name_7 : aliased constant Text_Type :=
        "String_Literal";
      Rule_Doc_7 : aliased constant Text_Type :=
        "";
      Rule_Desc_7 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_7'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_7'Access,
         Return_Type => Type_Index_For_String_Literal);
      
      Rule_Name_8 : aliased constant Text_Type :=
        "Concatenation";
      Rule_Doc_8 : aliased constant Text_Type :=
        "";
      Rule_Desc_8 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_8'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_8'Access,
         Return_Type => Type_Index_For_Sequence_Literal);
      
      Rule_Name_9 : aliased constant Text_Type :=
        "Primary";
      Rule_Doc_9 : aliased constant Text_Type :=
        "";
      Rule_Desc_9 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_9'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_9'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_10 : aliased constant Text_Type :=
        "Paren_Expression";
      Rule_Doc_10 : aliased constant Text_Type :=
        "";
      Rule_Desc_10 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_10'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_10'Access,
         Return_Type => Type_Index_For_Paren_Expression);
      
      Rule_Name_11 : aliased constant Text_Type :=
        "Suffix";
      Rule_Doc_11 : aliased constant Text_Type :=
        "";
      Rule_Desc_11 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_11'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_11'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_12 : aliased constant Text_Type :=
        "Factor";
      Rule_Doc_12 : aliased constant Text_Type :=
        "";
      Rule_Desc_12 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_12'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_12'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_13 : aliased constant Text_Type :=
        "Term";
      Rule_Doc_13 : aliased constant Text_Type :=
        "";
      Rule_Desc_13 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_13'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_13'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_14 : aliased constant Text_Type :=
        "Unop_Term";
      Rule_Doc_14 : aliased constant Text_Type :=
        "";
      Rule_Desc_14 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_14'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_14'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_15 : aliased constant Text_Type :=
        "Simple_Expr";
      Rule_Doc_15 : aliased constant Text_Type :=
        "";
      Rule_Desc_15 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_15'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_15'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_16 : aliased constant Text_Type :=
        "Relation";
      Rule_Doc_16 : aliased constant Text_Type :=
        "";
      Rule_Desc_16 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_16'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_16'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_17 : aliased constant Text_Type :=
        "Expression";
      Rule_Doc_17 : aliased constant Text_Type :=
        "";
      Rule_Desc_17 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_17'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_17'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_18 : aliased constant Text_Type :=
        "Quantified_Expression";
      Rule_Doc_18 : aliased constant Text_Type :=
        "";
      Rule_Desc_18 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_18'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_18'Access,
         Return_Type => Type_Index_For_Quantified_Expression);
      
      Rule_Name_19 : aliased constant Text_Type :=
        "Comprehension";
      Rule_Doc_19 : aliased constant Text_Type :=
        "";
      Rule_Desc_19 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_19'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_19'Access,
         Return_Type => Type_Index_For_Comprehension);
      
      Rule_Name_20 : aliased constant Text_Type :=
        "Call";
      Rule_Doc_20 : aliased constant Text_Type :=
        "";
      Rule_Desc_20 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_20'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_20'Access,
         Return_Type => Type_Index_For_Call);
      
      Rule_Name_21 : aliased constant Text_Type :=
        "Conversion";
      Rule_Doc_21 : aliased constant Text_Type :=
        "";
      Rule_Desc_21 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_21'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_21'Access,
         Return_Type => Type_Index_For_Conversion);
      
      Rule_Name_22 : aliased constant Text_Type :=
        "Null_Message_Aggregate";
      Rule_Doc_22 : aliased constant Text_Type :=
        "";
      Rule_Desc_22 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_22'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_22'Access,
         Return_Type => Type_Index_For_Null_Message_Aggregate);
      
      Rule_Name_23 : aliased constant Text_Type :=
        "Message_Aggregate_Association";
      Rule_Doc_23 : aliased constant Text_Type :=
        "";
      Rule_Desc_23 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_23'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_23'Access,
         Return_Type => Type_Index_For_Message_Aggregate_Association);
      
      Rule_Name_24 : aliased constant Text_Type :=
        "Message_Aggregate_Association_List";
      Rule_Doc_24 : aliased constant Text_Type :=
        "";
      Rule_Desc_24 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_24'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_24'Access,
         Return_Type => Type_Index_For_Message_Aggregate_Associations);
      
      Rule_Name_25 : aliased constant Text_Type :=
        "Message_Aggregate";
      Rule_Doc_25 : aliased constant Text_Type :=
        "";
      Rule_Desc_25 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_25'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_25'Access,
         Return_Type => Type_Index_For_Message_Aggregate);
      
      Rule_Name_26 : aliased constant Text_Type :=
        "Extended_Primary";
      Rule_Doc_26 : aliased constant Text_Type :=
        "";
      Rule_Desc_26 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_26'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_26'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_27 : aliased constant Text_Type :=
        "Extended_Paren_Expression";
      Rule_Doc_27 : aliased constant Text_Type :=
        "";
      Rule_Desc_27 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_27'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_27'Access,
         Return_Type => Type_Index_For_Paren_Expression);
      
      Rule_Name_28 : aliased constant Text_Type :=
        "Extended_Choice_List";
      Rule_Doc_28 : aliased constant Text_Type :=
        "";
      Rule_Desc_28 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_28'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_28'Access,
         Return_Type => Type_Index_For_R_F_L_X_Node_List);
      
      Rule_Name_29 : aliased constant Text_Type :=
        "Extended_Choices";
      Rule_Doc_29 : aliased constant Text_Type :=
        "";
      Rule_Desc_29 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_29'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_29'Access,
         Return_Type => Type_Index_For_Choice);
      
      Rule_Name_30 : aliased constant Text_Type :=
        "Extended_Case_Expression";
      Rule_Doc_30 : aliased constant Text_Type :=
        "";
      Rule_Desc_30 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_30'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_30'Access,
         Return_Type => Type_Index_For_Case_Expression);
      
      Rule_Name_31 : aliased constant Text_Type :=
        "Extended_Suffix";
      Rule_Doc_31 : aliased constant Text_Type :=
        "";
      Rule_Desc_31 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_31'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_31'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_32 : aliased constant Text_Type :=
        "Extended_Factor";
      Rule_Doc_32 : aliased constant Text_Type :=
        "";
      Rule_Desc_32 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_32'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_32'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_33 : aliased constant Text_Type :=
        "Extended_Term";
      Rule_Doc_33 : aliased constant Text_Type :=
        "";
      Rule_Desc_33 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_33'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_33'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_34 : aliased constant Text_Type :=
        "Extended_Unop_Term";
      Rule_Doc_34 : aliased constant Text_Type :=
        "";
      Rule_Desc_34 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_34'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_34'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_35 : aliased constant Text_Type :=
        "Extended_Simple_Expr";
      Rule_Doc_35 : aliased constant Text_Type :=
        "";
      Rule_Desc_35 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_35'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_35'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_36 : aliased constant Text_Type :=
        "Extended_Relation";
      Rule_Doc_36 : aliased constant Text_Type :=
        "";
      Rule_Desc_36 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_36'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_36'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_37 : aliased constant Text_Type :=
        "Extended_Expression";
      Rule_Doc_37 : aliased constant Text_Type :=
        "";
      Rule_Desc_37 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_37'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_37'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_38 : aliased constant Text_Type :=
        "Aspect";
      Rule_Doc_38 : aliased constant Text_Type :=
        "";
      Rule_Desc_38 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_38'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_38'Access,
         Return_Type => Type_Index_For_Aspect);
      
      Rule_Name_39 : aliased constant Text_Type :=
        "Range_Type_Definition";
      Rule_Doc_39 : aliased constant Text_Type :=
        "";
      Rule_Desc_39 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_39'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_39'Access,
         Return_Type => Type_Index_For_Range_Type_Def);
      
      Rule_Name_40 : aliased constant Text_Type :=
        "Modular_Type_Definition";
      Rule_Doc_40 : aliased constant Text_Type :=
        "";
      Rule_Desc_40 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_40'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_40'Access,
         Return_Type => Type_Index_For_Modular_Type_Def);
      
      Rule_Name_41 : aliased constant Text_Type :=
        "Integer_Type_Definition";
      Rule_Doc_41 : aliased constant Text_Type :=
        "";
      Rule_Desc_41 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_41'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_41'Access,
         Return_Type => Type_Index_For_Integer_Type_Def);
      
      Rule_Name_42 : aliased constant Text_Type :=
        "If_Condition";
      Rule_Doc_42 : aliased constant Text_Type :=
        "";
      Rule_Desc_42 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_42'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_42'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_43 : aliased constant Text_Type :=
        "Extended_If_Condition";
      Rule_Doc_43 : aliased constant Text_Type :=
        "";
      Rule_Desc_43 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_43'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_43'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_44 : aliased constant Text_Type :=
        "Then";
      Rule_Doc_44 : aliased constant Text_Type :=
        "";
      Rule_Desc_44 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_44'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_44'Access,
         Return_Type => Type_Index_For_Then);
      
      Rule_Name_45 : aliased constant Text_Type :=
        "Type_Argument";
      Rule_Doc_45 : aliased constant Text_Type :=
        "";
      Rule_Desc_45 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_45'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_45'Access,
         Return_Type => Type_Index_For_Type_Argument);
      
      Rule_Name_46 : aliased constant Text_Type :=
        "Null_Message_Field";
      Rule_Doc_46 : aliased constant Text_Type :=
        "";
      Rule_Desc_46 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_46'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_46'Access,
         Return_Type => Type_Index_For_Null_Message_Field);
      
      Rule_Name_47 : aliased constant Text_Type :=
        "Message_Field";
      Rule_Doc_47 : aliased constant Text_Type :=
        "";
      Rule_Desc_47 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_47'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_47'Access,
         Return_Type => Type_Index_For_Message_Field);
      
      Rule_Name_48 : aliased constant Text_Type :=
        "Message_Field_List";
      Rule_Doc_48 : aliased constant Text_Type :=
        "";
      Rule_Desc_48 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_48'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_48'Access,
         Return_Type => Type_Index_For_Message_Fields);
      
      Rule_Name_49 : aliased constant Text_Type :=
        "Value_Range";
      Rule_Doc_49 : aliased constant Text_Type :=
        "";
      Rule_Desc_49 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_49'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_49'Access,
         Return_Type => Type_Index_For_Checksum_Value_Range);
      
      Rule_Name_50 : aliased constant Text_Type :=
        "Checksum_Association";
      Rule_Doc_50 : aliased constant Text_Type :=
        "";
      Rule_Desc_50 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_50'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_50'Access,
         Return_Type => Type_Index_For_Checksum_Assoc);
      
      Rule_Name_51 : aliased constant Text_Type :=
        "Checksum_Aspect";
      Rule_Doc_51 : aliased constant Text_Type :=
        "";
      Rule_Desc_51 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_51'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_51'Access,
         Return_Type => Type_Index_For_Checksum_Aspect);
      
      Rule_Name_52 : aliased constant Text_Type :=
        "Byte_Order_Aspect";
      Rule_Doc_52 : aliased constant Text_Type :=
        "";
      Rule_Desc_52 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_52'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_52'Access,
         Return_Type => Type_Index_For_Byte_Order_Aspect);
      
      Rule_Name_53 : aliased constant Text_Type :=
        "Message_Aspect_List";
      Rule_Doc_53 : aliased constant Text_Type :=
        "";
      Rule_Desc_53 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_53'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_53'Access,
         Return_Type => Type_Index_For_Message_Aspect_List);
      
      Rule_Name_54 : aliased constant Text_Type :=
        "Message_Type_Definition";
      Rule_Doc_54 : aliased constant Text_Type :=
        "";
      Rule_Desc_54 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_54'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_54'Access,
         Return_Type => Type_Index_For_Abstract_Message_Type_Def);
      
      Rule_Name_55 : aliased constant Text_Type :=
        "Positional_Enumeration";
      Rule_Doc_55 : aliased constant Text_Type :=
        "";
      Rule_Desc_55 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_55'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_55'Access,
         Return_Type => Type_Index_For_Positional_Enumeration_Def);
      
      Rule_Name_56 : aliased constant Text_Type :=
        "Element_Value_Association";
      Rule_Doc_56 : aliased constant Text_Type :=
        "";
      Rule_Desc_56 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_56'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_56'Access,
         Return_Type => Type_Index_For_Element_Value_Assoc);
      
      Rule_Name_57 : aliased constant Text_Type :=
        "Named_Enumeration";
      Rule_Doc_57 : aliased constant Text_Type :=
        "";
      Rule_Desc_57 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_57'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_57'Access,
         Return_Type => Type_Index_For_Named_Enumeration_Def);
      
      Rule_Name_58 : aliased constant Text_Type :=
        "Enumeration_Aspects";
      Rule_Doc_58 : aliased constant Text_Type :=
        "";
      Rule_Desc_58 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_58'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_58'Access,
         Return_Type => Type_Index_For_Aspect_List);
      
      Rule_Name_59 : aliased constant Text_Type :=
        "Enumeration_Type_Definition";
      Rule_Doc_59 : aliased constant Text_Type :=
        "";
      Rule_Desc_59 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_59'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_59'Access,
         Return_Type => Type_Index_For_Enumeration_Type_Def);
      
      Rule_Name_60 : aliased constant Text_Type :=
        "Type_Derivation_Definition";
      Rule_Doc_60 : aliased constant Text_Type :=
        "";
      Rule_Desc_60 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_60'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_60'Access,
         Return_Type => Type_Index_For_Type_Derivation_Def);
      
      Rule_Name_61 : aliased constant Text_Type :=
        "Sequence_Type_Definition";
      Rule_Doc_61 : aliased constant Text_Type :=
        "";
      Rule_Desc_61 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_61'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_61'Access,
         Return_Type => Type_Index_For_Sequence_Type_Def);
      
      Rule_Name_62 : aliased constant Text_Type :=
        "Type_Declaration";
      Rule_Doc_62 : aliased constant Text_Type :=
        "";
      Rule_Desc_62 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_62'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_62'Access,
         Return_Type => Type_Index_For_Type_Decl);
      
      Rule_Name_63 : aliased constant Text_Type :=
        "Type_Refinement";
      Rule_Doc_63 : aliased constant Text_Type :=
        "";
      Rule_Desc_63 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_63'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_63'Access,
         Return_Type => Type_Index_For_Refinement_Decl);
      
      Rule_Name_64 : aliased constant Text_Type :=
        "Parameter";
      Rule_Doc_64 : aliased constant Text_Type :=
        "";
      Rule_Desc_64 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_64'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_64'Access,
         Return_Type => Type_Index_For_Parameter);
      
      Rule_Name_65 : aliased constant Text_Type :=
        "Parameter_List";
      Rule_Doc_65 : aliased constant Text_Type :=
        "";
      Rule_Desc_65 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_65'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_65'Access,
         Return_Type => Type_Index_For_Parameters);
      
      Rule_Name_66 : aliased constant Text_Type :=
        "Formal_Function_Declaration";
      Rule_Doc_66 : aliased constant Text_Type :=
        "";
      Rule_Desc_66 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_66'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_66'Access,
         Return_Type => Type_Index_For_Formal_Function_Decl);
      
      Rule_Name_67 : aliased constant Text_Type :=
        "Channel_Declaration";
      Rule_Doc_67 : aliased constant Text_Type :=
        "";
      Rule_Desc_67 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_67'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_67'Access,
         Return_Type => Type_Index_For_Formal_Channel_Decl);
      
      Rule_Name_68 : aliased constant Text_Type :=
        "Session_Parameter";
      Rule_Doc_68 : aliased constant Text_Type :=
        "";
      Rule_Desc_68 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_68'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_68'Access,
         Return_Type => Type_Index_For_Formal_Decl);
      
      Rule_Name_69 : aliased constant Text_Type :=
        "Renaming_Declaration";
      Rule_Doc_69 : aliased constant Text_Type :=
        "";
      Rule_Desc_69 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_69'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_69'Access,
         Return_Type => Type_Index_For_Renaming_Decl);
      
      Rule_Name_70 : aliased constant Text_Type :=
        "Variable_Declaration";
      Rule_Doc_70 : aliased constant Text_Type :=
        "";
      Rule_Desc_70 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_70'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_70'Access,
         Return_Type => Type_Index_For_Variable_Decl);
      
      Rule_Name_71 : aliased constant Text_Type :=
        "Declaration";
      Rule_Doc_71 : aliased constant Text_Type :=
        "";
      Rule_Desc_71 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_71'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_71'Access,
         Return_Type => Type_Index_For_Local_Decl);
      
      Rule_Name_72 : aliased constant Text_Type :=
        "Description_Aspect";
      Rule_Doc_72 : aliased constant Text_Type :=
        "";
      Rule_Desc_72 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_72'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_72'Access,
         Return_Type => Type_Index_For_Description);
      
      Rule_Name_73 : aliased constant Text_Type :=
        "Assignment_Statement";
      Rule_Doc_73 : aliased constant Text_Type :=
        "";
      Rule_Desc_73 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_73'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_73'Access,
         Return_Type => Type_Index_For_Assignment);
      
      Rule_Name_74 : aliased constant Text_Type :=
        "Message_Field_Assignment_Statement";
      Rule_Doc_74 : aliased constant Text_Type :=
        "";
      Rule_Desc_74 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_74'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_74'Access,
         Return_Type => Type_Index_For_Message_Field_Assignment);
      
      Rule_Name_75 : aliased constant Text_Type :=
        "List_Attribute";
      Rule_Doc_75 : aliased constant Text_Type :=
        "";
      Rule_Desc_75 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_75'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_75'Access,
         Return_Type => Type_Index_For_Attribute_Statement);
      
      Rule_Name_76 : aliased constant Text_Type :=
        "Reset";
      Rule_Doc_76 : aliased constant Text_Type :=
        "";
      Rule_Desc_76 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_76'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_76'Access,
         Return_Type => Type_Index_For_Reset);
      
      Rule_Name_77 : aliased constant Text_Type :=
        "Attribute_Statement";
      Rule_Doc_77 : aliased constant Text_Type :=
        "";
      Rule_Desc_77 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_77'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_77'Access,
         Return_Type => Type_Index_For_Statement);
      
      Rule_Name_78 : aliased constant Text_Type :=
        "Action";
      Rule_Doc_78 : aliased constant Text_Type :=
        "";
      Rule_Desc_78 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_78'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_78'Access,
         Return_Type => Type_Index_For_Statement);
      
      Rule_Name_79 : aliased constant Text_Type :=
        "Conditional_Transition";
      Rule_Doc_79 : aliased constant Text_Type :=
        "";
      Rule_Desc_79 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_79'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_79'Access,
         Return_Type => Type_Index_For_Conditional_Transition);
      
      Rule_Name_80 : aliased constant Text_Type :=
        "Transition";
      Rule_Doc_80 : aliased constant Text_Type :=
        "";
      Rule_Desc_80 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_80'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_80'Access,
         Return_Type => Type_Index_For_Transition);
      
      Rule_Name_81 : aliased constant Text_Type :=
        "State_Body";
      Rule_Doc_81 : aliased constant Text_Type :=
        "";
      Rule_Desc_81 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_81'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_81'Access,
         Return_Type => Type_Index_For_State_Body);
      
      Rule_Name_82 : aliased constant Text_Type :=
        "State";
      Rule_Doc_82 : aliased constant Text_Type :=
        "";
      Rule_Desc_82 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_82'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_82'Access,
         Return_Type => Type_Index_For_State);
      
      Rule_Name_83 : aliased constant Text_Type :=
        "Session_Declaration";
      Rule_Doc_83 : aliased constant Text_Type :=
        "";
      Rule_Desc_83 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_83'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_83'Access,
         Return_Type => Type_Index_For_Session_Decl);
      
      Rule_Name_84 : aliased constant Text_Type :=
        "Basic_Declaration";
      Rule_Doc_84 : aliased constant Text_Type :=
        "";
      Rule_Desc_84 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_84'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_84'Access,
         Return_Type => Type_Index_For_Declaration);
      
      Rule_Name_85 : aliased constant Text_Type :=
        "Basic_Declarations";
      Rule_Doc_85 : aliased constant Text_Type :=
        "";
      Rule_Desc_85 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_85'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_85'Access,
         Return_Type => Type_Index_For_Declaration_List);
      
      Rule_Name_86 : aliased constant Text_Type :=
        "Package_Declaration";
      Rule_Doc_86 : aliased constant Text_Type :=
        "";
      Rule_Desc_86 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_86'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_86'Access,
         Return_Type => Type_Index_For_Package);
      
      Rule_Name_87 : aliased constant Text_Type :=
        "Context_Item";
      Rule_Doc_87 : aliased constant Text_Type :=
        "";
      Rule_Desc_87 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_87'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_87'Access,
         Return_Type => Type_Index_For_Context_Item);
      
      Rule_Name_88 : aliased constant Text_Type :=
        "Context_Clause";
      Rule_Doc_88 : aliased constant Text_Type :=
        "";
      Rule_Desc_88 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_88'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_88'Access,
         Return_Type => Type_Index_For_Context_Item_List);
      
      Rule_Name_89 : aliased constant Text_Type :=
        "Specification";
      Rule_Doc_89 : aliased constant Text_Type :=
        "";
      Rule_Desc_89 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_89'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_89'Access,
         Return_Type => Type_Index_For_Specification);

   Grammar_Rules : aliased constant Grammar_Rule_Descriptor_Array := (
      1 => Rule_Desc_1'Access,
2 => Rule_Desc_2'Access,
3 => Rule_Desc_3'Access,
4 => Rule_Desc_4'Access,
5 => Rule_Desc_5'Access,
6 => Rule_Desc_6'Access,
7 => Rule_Desc_7'Access,
8 => Rule_Desc_8'Access,
9 => Rule_Desc_9'Access,
10 => Rule_Desc_10'Access,
11 => Rule_Desc_11'Access,
12 => Rule_Desc_12'Access,
13 => Rule_Desc_13'Access,
14 => Rule_Desc_14'Access,
15 => Rule_Desc_15'Access,
16 => Rule_Desc_16'Access,
17 => Rule_Desc_17'Access,
18 => Rule_Desc_18'Access,
19 => Rule_Desc_19'Access,
20 => Rule_Desc_20'Access,
21 => Rule_Desc_21'Access,
22 => Rule_Desc_22'Access,
23 => Rule_Desc_23'Access,
24 => Rule_Desc_24'Access,
25 => Rule_Desc_25'Access,
26 => Rule_Desc_26'Access,
27 => Rule_Desc_27'Access,
28 => Rule_Desc_28'Access,
29 => Rule_Desc_29'Access,
30 => Rule_Desc_30'Access,
31 => Rule_Desc_31'Access,
32 => Rule_Desc_32'Access,
33 => Rule_Desc_33'Access,
34 => Rule_Desc_34'Access,
35 => Rule_Desc_35'Access,
36 => Rule_Desc_36'Access,
37 => Rule_Desc_37'Access,
38 => Rule_Desc_38'Access,
39 => Rule_Desc_39'Access,
40 => Rule_Desc_40'Access,
41 => Rule_Desc_41'Access,
42 => Rule_Desc_42'Access,
43 => Rule_Desc_43'Access,
44 => Rule_Desc_44'Access,
45 => Rule_Desc_45'Access,
46 => Rule_Desc_46'Access,
47 => Rule_Desc_47'Access,
48 => Rule_Desc_48'Access,
49 => Rule_Desc_49'Access,
50 => Rule_Desc_50'Access,
51 => Rule_Desc_51'Access,
52 => Rule_Desc_52'Access,
53 => Rule_Desc_53'Access,
54 => Rule_Desc_54'Access,
55 => Rule_Desc_55'Access,
56 => Rule_Desc_56'Access,
57 => Rule_Desc_57'Access,
58 => Rule_Desc_58'Access,
59 => Rule_Desc_59'Access,
60 => Rule_Desc_60'Access,
61 => Rule_Desc_61'Access,
62 => Rule_Desc_62'Access,
63 => Rule_Desc_63'Access,
64 => Rule_Desc_64'Access,
65 => Rule_Desc_65'Access,
66 => Rule_Desc_66'Access,
67 => Rule_Desc_67'Access,
68 => Rule_Desc_68'Access,
69 => Rule_Desc_69'Access,
70 => Rule_Desc_70'Access,
71 => Rule_Desc_71'Access,
72 => Rule_Desc_72'Access,
73 => Rule_Desc_73'Access,
74 => Rule_Desc_74'Access,
75 => Rule_Desc_75'Access,
76 => Rule_Desc_76'Access,
77 => Rule_Desc_77'Access,
78 => Rule_Desc_78'Access,
79 => Rule_Desc_79'Access,
80 => Rule_Desc_80'Access,
81 => Rule_Desc_81'Access,
82 => Rule_Desc_82'Access,
83 => Rule_Desc_83'Access,
84 => Rule_Desc_84'Access,
85 => Rule_Desc_85'Access,
86 => Rule_Desc_86'Access,
87 => Rule_Desc_87'Access,
88 => Rule_Desc_88'Access,
89 => Rule_Desc_89'Access
   );

   ------------------------------------
   -- General value type descriptors --
   ------------------------------------

   
      
      Debug_Name_For_Internal_Unit : aliased constant String :=
        "AnalysisUnit";
      Desc_For_Internal_Unit : aliased constant Type_Descriptor :=
        (Category   => Analysis_Unit_Category,
         Debug_Name => Debug_Name_For_Internal_Unit'Access);
      
      Debug_Name_For_Big_Integer_Type : aliased constant String :=
        "BigInt";
      Desc_For_Big_Integer_Type : aliased constant Type_Descriptor :=
        (Category   => Big_Int_Category,
         Debug_Name => Debug_Name_For_Big_Integer_Type'Access);
      
      Debug_Name_For_Boolean : aliased constant String :=
        "Bool";
      Desc_For_Boolean : aliased constant Type_Descriptor :=
        (Category   => Bool_Category,
         Debug_Name => Debug_Name_For_Boolean'Access);
      
      Debug_Name_For_Character_Type : aliased constant String :=
        "Character";
      Desc_For_Character_Type : aliased constant Type_Descriptor :=
        (Category   => Char_Category,
         Debug_Name => Debug_Name_For_Character_Type'Access);
      
      Debug_Name_For_Integer : aliased constant String :=
        "Int";
      Desc_For_Integer : aliased constant Type_Descriptor :=
        (Category   => Int_Category,
         Debug_Name => Debug_Name_For_Integer'Access);
      
      Debug_Name_For_Source_Location_Range : aliased constant String :=
        "SourceLocationRange";
      Desc_For_Source_Location_Range : aliased constant Type_Descriptor :=
        (Category   => Source_Location_Range_Category,
         Debug_Name => Debug_Name_For_Source_Location_Range'Access);
      
      Debug_Name_For_String_Type : aliased constant String :=
        "String";
      Desc_For_String_Type : aliased constant Type_Descriptor :=
        (Category   => String_Category,
         Debug_Name => Debug_Name_For_String_Type'Access);
      
      Debug_Name_For_Token_Reference : aliased constant String :=
        "Token";
      Desc_For_Token_Reference : aliased constant Type_Descriptor :=
        (Category   => Token_Category,
         Debug_Name => Debug_Name_For_Token_Reference'Access);
      
      Debug_Name_For_Symbol_Type : aliased constant String :=
        "Symbol";
      Desc_For_Symbol_Type : aliased constant Type_Descriptor :=
        (Category   => Symbol_Category,
         Debug_Name => Debug_Name_For_Symbol_Type'Access);
      
      Debug_Name_For_Analysis_Unit_Kind : aliased constant String :=
        "AnalysisUnitKind";
      Desc_For_Analysis_Unit_Kind : aliased constant Type_Descriptor :=
        (Category   => Enum_Category,
         Debug_Name => Debug_Name_For_Analysis_Unit_Kind'Access);
      
      Debug_Name_For_Lookup_Kind : aliased constant String :=
        "LookupKind";
      Desc_For_Lookup_Kind : aliased constant Type_Descriptor :=
        (Category   => Enum_Category,
         Debug_Name => Debug_Name_For_Lookup_Kind'Access);
      
      Debug_Name_For_Designated_Env_Kind : aliased constant String :=
        "DesignatedEnvKind";
      Desc_For_Designated_Env_Kind : aliased constant Type_Descriptor :=
        (Category   => Enum_Category,
         Debug_Name => Debug_Name_For_Designated_Env_Kind'Access);
      
      Debug_Name_For_Grammar_Rule : aliased constant String :=
        "GrammarRule";
      Desc_For_Grammar_Rule : aliased constant Type_Descriptor :=
        (Category   => Enum_Category,
         Debug_Name => Debug_Name_For_Grammar_Rule'Access);
      
      Debug_Name_For_Internal_Entity_Array_Access : aliased constant String :=
        "RFLXNode.array";
      Desc_For_Internal_Entity_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity : aliased constant String :=
        "RFLXNode";
      Desc_For_Internal_Entity : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity'Access);
      
      Debug_Name_For_Internal_Entity_Abstract_I_D : aliased constant String :=
        "AbstractID";
      Desc_For_Internal_Entity_Abstract_I_D : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abstract_I_D'Access);
      
      Debug_Name_For_Internal_Entity_I_D : aliased constant String :=
        "ID";
      Desc_For_Internal_Entity_I_D : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_I_D'Access);
      
      Debug_Name_For_Internal_Entity_Unqualified_I_D : aliased constant String :=
        "UnqualifiedID";
      Desc_For_Internal_Entity_Unqualified_I_D : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Unqualified_I_D'Access);
      
      Debug_Name_For_Internal_Entity_Aspect : aliased constant String :=
        "Aspect";
      Desc_For_Internal_Entity_Aspect : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Aspect'Access);
      
      Debug_Name_For_Internal_Entity_Attr : aliased constant String :=
        "Attr";
      Desc_For_Internal_Entity_Attr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr'Access);
      
      Debug_Name_For_Internal_Entity_Attr_First : aliased constant String :=
        "Attr.First";
      Desc_For_Internal_Entity_Attr_First : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_First'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Has_Data : aliased constant String :=
        "Attr.HasData";
      Desc_For_Internal_Entity_Attr_Has_Data : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Has_Data'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Head : aliased constant String :=
        "Attr.Head";
      Desc_For_Internal_Entity_Attr_Head : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Head'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Last : aliased constant String :=
        "Attr.Last";
      Desc_For_Internal_Entity_Attr_Last : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Last'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Opaque : aliased constant String :=
        "Attr.Opaque";
      Desc_For_Internal_Entity_Attr_Opaque : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Opaque'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Present : aliased constant String :=
        "Attr.Present";
      Desc_For_Internal_Entity_Attr_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Present'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Size : aliased constant String :=
        "Attr.Size";
      Desc_For_Internal_Entity_Attr_Size : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Size'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Valid : aliased constant String :=
        "Attr.Valid";
      Desc_For_Internal_Entity_Attr_Valid : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Valid'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Valid_Checksum : aliased constant String :=
        "Attr.ValidChecksum";
      Desc_For_Internal_Entity_Attr_Valid_Checksum : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Valid_Checksum'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Stmt : aliased constant String :=
        "AttrStmt";
      Desc_For_Internal_Entity_Attr_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Stmt_Append : aliased constant String :=
        "AttrStmt.Append";
      Desc_For_Internal_Entity_Attr_Stmt_Append : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Stmt_Append'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Stmt_Extend : aliased constant String :=
        "AttrStmt.Extend";
      Desc_For_Internal_Entity_Attr_Stmt_Extend : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Stmt_Extend'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Stmt_Read : aliased constant String :=
        "AttrStmt.Read";
      Desc_For_Internal_Entity_Attr_Stmt_Read : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Stmt_Read'Access);
      
      Debug_Name_For_Internal_Entity_Attr_Stmt_Write : aliased constant String :=
        "AttrStmt.Write";
      Desc_For_Internal_Entity_Attr_Stmt_Write : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attr_Stmt_Write'Access);
      
      Debug_Name_For_Internal_Entity_Base_Aggregate : aliased constant String :=
        "BaseAggregate";
      Desc_For_Internal_Entity_Base_Aggregate : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Aggregate'Access);
      
      Debug_Name_For_Internal_Entity_Message_Aggregate_Associations : aliased constant String :=
        "MessageAggregateAssociations";
      Desc_For_Internal_Entity_Message_Aggregate_Associations : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Message_Aggregate_Associations'Access);
      
      Debug_Name_For_Internal_Entity_Null_Message_Aggregate : aliased constant String :=
        "NullMessageAggregate";
      Desc_For_Internal_Entity_Null_Message_Aggregate : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Null_Message_Aggregate'Access);
      
      Debug_Name_For_Internal_Entity_Base_Checksum_Val : aliased constant String :=
        "BaseChecksumVal";
      Desc_For_Internal_Entity_Base_Checksum_Val : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Checksum_Val'Access);
      
      Debug_Name_For_Internal_Entity_Checksum_Val : aliased constant String :=
        "ChecksumVal";
      Desc_For_Internal_Entity_Checksum_Val : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Checksum_Val'Access);
      
      Debug_Name_For_Internal_Entity_Checksum_Value_Range : aliased constant String :=
        "ChecksumValueRange";
      Desc_For_Internal_Entity_Checksum_Value_Range : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Checksum_Value_Range'Access);
      
      Debug_Name_For_Internal_Entity_Byte_Order_Type : aliased constant String :=
        "ByteOrderType";
      Desc_For_Internal_Entity_Byte_Order_Type : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Byte_Order_Type'Access);
      
      Debug_Name_For_Internal_Entity_Byte_Order_Type_Highorderfirst : aliased constant String :=
        "ByteOrderType.Highorderfirst";
      Desc_For_Internal_Entity_Byte_Order_Type_Highorderfirst : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Byte_Order_Type_Highorderfirst'Access);
      
      Debug_Name_For_Internal_Entity_Byte_Order_Type_Loworderfirst : aliased constant String :=
        "ByteOrderType.Loworderfirst";
      Desc_For_Internal_Entity_Byte_Order_Type_Loworderfirst : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Byte_Order_Type_Loworderfirst'Access);
      
      Debug_Name_For_Internal_Entity_Channel_Attribute : aliased constant String :=
        "ChannelAttribute";
      Desc_For_Internal_Entity_Channel_Attribute : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Channel_Attribute'Access);
      
      Debug_Name_For_Internal_Entity_Readable : aliased constant String :=
        "Readable";
      Desc_For_Internal_Entity_Readable : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Readable'Access);
      
      Debug_Name_For_Internal_Entity_Writable : aliased constant String :=
        "Writable";
      Desc_For_Internal_Entity_Writable : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Writable'Access);
      
      Debug_Name_For_Internal_Entity_Checksum_Assoc : aliased constant String :=
        "ChecksumAssoc";
      Desc_For_Internal_Entity_Checksum_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Checksum_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Declaration : aliased constant String :=
        "Declaration";
      Desc_For_Internal_Entity_Declaration : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Declaration'Access);
      
      Debug_Name_For_Internal_Entity_Refinement_Decl : aliased constant String :=
        "RefinementDecl";
      Desc_For_Internal_Entity_Refinement_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Refinement_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Session_Decl : aliased constant String :=
        "SessionDecl";
      Desc_For_Internal_Entity_Session_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Session_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Type_Decl : aliased constant String :=
        "TypeDecl";
      Desc_For_Internal_Entity_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Description : aliased constant String :=
        "Description";
      Desc_For_Internal_Entity_Description : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Description'Access);
      
      Debug_Name_For_Internal_Entity_Element_Value_Assoc : aliased constant String :=
        "ElementValueAssoc";
      Desc_For_Internal_Entity_Element_Value_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Element_Value_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Expr : aliased constant String :=
        "Expr";
      Desc_For_Internal_Entity_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Attribute : aliased constant String :=
        "Attribute";
      Desc_For_Internal_Entity_Attribute : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attribute'Access);
      
      Debug_Name_For_Internal_Entity_Bin_Op : aliased constant String :=
        "BinOp";
      Desc_For_Internal_Entity_Bin_Op : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Bin_Op'Access);
      
      Debug_Name_For_Internal_Entity_Binding : aliased constant String :=
        "Binding";
      Desc_For_Internal_Entity_Binding : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Binding'Access);
      
      Debug_Name_For_Internal_Entity_Call : aliased constant String :=
        "Call";
      Desc_For_Internal_Entity_Call : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Call'Access);
      
      Debug_Name_For_Internal_Entity_Case_Expression : aliased constant String :=
        "CaseExpression";
      Desc_For_Internal_Entity_Case_Expression : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Case_Expression'Access);
      
      Debug_Name_For_Internal_Entity_Choice : aliased constant String :=
        "Choice";
      Desc_For_Internal_Entity_Choice : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Choice'Access);
      
      Debug_Name_For_Internal_Entity_Comprehension : aliased constant String :=
        "Comprehension";
      Desc_For_Internal_Entity_Comprehension : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Comprehension'Access);
      
      Debug_Name_For_Internal_Entity_Context_Item : aliased constant String :=
        "ContextItem";
      Desc_For_Internal_Entity_Context_Item : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Context_Item'Access);
      
      Debug_Name_For_Internal_Entity_Conversion : aliased constant String :=
        "Conversion";
      Desc_For_Internal_Entity_Conversion : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Conversion'Access);
      
      Debug_Name_For_Internal_Entity_Message_Aggregate : aliased constant String :=
        "MessageAggregate";
      Desc_For_Internal_Entity_Message_Aggregate : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Message_Aggregate'Access);
      
      Debug_Name_For_Internal_Entity_Negation : aliased constant String :=
        "Negation";
      Desc_For_Internal_Entity_Negation : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Negation'Access);
      
      Debug_Name_For_Internal_Entity_Numeric_Literal : aliased constant String :=
        "NumericLiteral";
      Desc_For_Internal_Entity_Numeric_Literal : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Numeric_Literal'Access);
      
      Debug_Name_For_Internal_Entity_Paren_Expression : aliased constant String :=
        "ParenExpression";
      Desc_For_Internal_Entity_Paren_Expression : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Paren_Expression'Access);
      
      Debug_Name_For_Internal_Entity_Quantified_Expression : aliased constant String :=
        "QuantifiedExpression";
      Desc_For_Internal_Entity_Quantified_Expression : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Quantified_Expression'Access);
      
      Debug_Name_For_Internal_Entity_Select_Node : aliased constant String :=
        "Select";
      Desc_For_Internal_Entity_Select_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Select_Node'Access);
      
      Debug_Name_For_Internal_Entity_Sequence_Literal : aliased constant String :=
        "SequenceLiteral";
      Desc_For_Internal_Entity_Sequence_Literal : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Sequence_Literal'Access);
      
      Debug_Name_For_Internal_Entity_Concatenation : aliased constant String :=
        "Concatenation";
      Desc_For_Internal_Entity_Concatenation : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Concatenation'Access);
      
      Debug_Name_For_Internal_Entity_Sequence_Aggregate : aliased constant String :=
        "SequenceAggregate";
      Desc_For_Internal_Entity_Sequence_Aggregate : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Sequence_Aggregate'Access);
      
      Debug_Name_For_Internal_Entity_String_Literal : aliased constant String :=
        "StringLiteral";
      Desc_For_Internal_Entity_String_Literal : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_String_Literal'Access);
      
      Debug_Name_For_Internal_Entity_Variable : aliased constant String :=
        "Variable";
      Desc_For_Internal_Entity_Variable : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Variable'Access);
      
      Debug_Name_For_Internal_Entity_Formal_Decl : aliased constant String :=
        "FormalDecl";
      Desc_For_Internal_Entity_Formal_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Formal_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Formal_Channel_Decl : aliased constant String :=
        "FormalChannelDecl";
      Desc_For_Internal_Entity_Formal_Channel_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Formal_Channel_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Formal_Function_Decl : aliased constant String :=
        "FormalFunctionDecl";
      Desc_For_Internal_Entity_Formal_Function_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Formal_Function_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Local_Decl : aliased constant String :=
        "LocalDecl";
      Desc_For_Internal_Entity_Local_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Local_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Renaming_Decl : aliased constant String :=
        "RenamingDecl";
      Desc_For_Internal_Entity_Renaming_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Renaming_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Variable_Decl : aliased constant String :=
        "VariableDecl";
      Desc_For_Internal_Entity_Variable_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Variable_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Message_Aggregate_Association : aliased constant String :=
        "MessageAggregateAssociation";
      Desc_For_Internal_Entity_Message_Aggregate_Association : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Message_Aggregate_Association'Access);
      
      Debug_Name_For_Internal_Entity_Message_Aspect : aliased constant String :=
        "MessageAspect";
      Desc_For_Internal_Entity_Message_Aspect : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Message_Aspect'Access);
      
      Debug_Name_For_Internal_Entity_Byte_Order_Aspect : aliased constant String :=
        "ByteOrderAspect";
      Desc_For_Internal_Entity_Byte_Order_Aspect : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Byte_Order_Aspect'Access);
      
      Debug_Name_For_Internal_Entity_Checksum_Aspect : aliased constant String :=
        "ChecksumAspect";
      Desc_For_Internal_Entity_Checksum_Aspect : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Checksum_Aspect'Access);
      
      Debug_Name_For_Internal_Entity_Message_Field : aliased constant String :=
        "MessageField";
      Desc_For_Internal_Entity_Message_Field : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Message_Field'Access);
      
      Debug_Name_For_Internal_Entity_Message_Fields : aliased constant String :=
        "MessageFields";
      Desc_For_Internal_Entity_Message_Fields : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Message_Fields'Access);
      
      Debug_Name_For_Internal_Entity_Null_Message_Field : aliased constant String :=
        "NullMessageField";
      Desc_For_Internal_Entity_Null_Message_Field : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Null_Message_Field'Access);
      
      Debug_Name_For_Internal_Entity_Op : aliased constant String :=
        "Op";
      Desc_For_Internal_Entity_Op : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op'Access);
      
      Debug_Name_For_Internal_Entity_Op_Add : aliased constant String :=
        "Op.Add";
      Desc_For_Internal_Entity_Op_Add : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Add'Access);
      
      Debug_Name_For_Internal_Entity_Op_And : aliased constant String :=
        "Op.And";
      Desc_For_Internal_Entity_Op_And : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_And'Access);
      
      Debug_Name_For_Internal_Entity_Op_Div : aliased constant String :=
        "Op.Div";
      Desc_For_Internal_Entity_Op_Div : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Div'Access);
      
      Debug_Name_For_Internal_Entity_Op_Eq : aliased constant String :=
        "Op.Eq";
      Desc_For_Internal_Entity_Op_Eq : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Eq'Access);
      
      Debug_Name_For_Internal_Entity_Op_Ge : aliased constant String :=
        "Op.Ge";
      Desc_For_Internal_Entity_Op_Ge : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Ge'Access);
      
      Debug_Name_For_Internal_Entity_Op_Gt : aliased constant String :=
        "Op.Gt";
      Desc_For_Internal_Entity_Op_Gt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Gt'Access);
      
      Debug_Name_For_Internal_Entity_Op_In : aliased constant String :=
        "Op.In";
      Desc_For_Internal_Entity_Op_In : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_In'Access);
      
      Debug_Name_For_Internal_Entity_Op_Le : aliased constant String :=
        "Op.Le";
      Desc_For_Internal_Entity_Op_Le : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Le'Access);
      
      Debug_Name_For_Internal_Entity_Op_Lt : aliased constant String :=
        "Op.Lt";
      Desc_For_Internal_Entity_Op_Lt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Lt'Access);
      
      Debug_Name_For_Internal_Entity_Op_Mod : aliased constant String :=
        "Op.Mod";
      Desc_For_Internal_Entity_Op_Mod : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Mod'Access);
      
      Debug_Name_For_Internal_Entity_Op_Mul : aliased constant String :=
        "Op.Mul";
      Desc_For_Internal_Entity_Op_Mul : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Mul'Access);
      
      Debug_Name_For_Internal_Entity_Op_Neq : aliased constant String :=
        "Op.Neq";
      Desc_For_Internal_Entity_Op_Neq : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Neq'Access);
      
      Debug_Name_For_Internal_Entity_Op_Notin : aliased constant String :=
        "Op.Notin";
      Desc_For_Internal_Entity_Op_Notin : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Notin'Access);
      
      Debug_Name_For_Internal_Entity_Op_Or : aliased constant String :=
        "Op.Or";
      Desc_For_Internal_Entity_Op_Or : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Or'Access);
      
      Debug_Name_For_Internal_Entity_Op_Pow : aliased constant String :=
        "Op.Pow";
      Desc_For_Internal_Entity_Op_Pow : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Pow'Access);
      
      Debug_Name_For_Internal_Entity_Op_Sub : aliased constant String :=
        "Op.Sub";
      Desc_For_Internal_Entity_Op_Sub : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Sub'Access);
      
      Debug_Name_For_Internal_Entity_Package_Node : aliased constant String :=
        "Package";
      Desc_For_Internal_Entity_Package_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Package_Node'Access);
      
      Debug_Name_For_Internal_Entity_Parameter : aliased constant String :=
        "Parameter";
      Desc_For_Internal_Entity_Parameter : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Parameter'Access);
      
      Debug_Name_For_Internal_Entity_Parameters : aliased constant String :=
        "Parameters";
      Desc_For_Internal_Entity_Parameters : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Parameters'Access);
      
      Debug_Name_For_Internal_Entity_Quantifier : aliased constant String :=
        "Quantifier";
      Desc_For_Internal_Entity_Quantifier : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Quantifier'Access);
      
      Debug_Name_For_Internal_Entity_Quantifier_All : aliased constant String :=
        "Quantifier.All";
      Desc_For_Internal_Entity_Quantifier_All : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Quantifier_All'Access);
      
      Debug_Name_For_Internal_Entity_Quantifier_Some : aliased constant String :=
        "Quantifier.Some";
      Desc_For_Internal_Entity_Quantifier_Some : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Quantifier_Some'Access);
      
      Debug_Name_For_Internal_Entity_R_F_L_X_Node_Base_List : aliased constant String :=
        "RFLXNodeBaseList";
      Desc_For_Internal_Entity_R_F_L_X_Node_Base_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_R_F_L_X_Node_Base_List'Access);
      
      Debug_Name_For_Internal_Entity_Aspect_List : aliased constant String :=
        "Aspect.list";
      Desc_For_Internal_Entity_Aspect_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Aspect_List'Access);
      
      Debug_Name_For_Internal_Entity_Base_Checksum_Val_List : aliased constant String :=
        "BaseChecksumVal.list";
      Desc_For_Internal_Entity_Base_Checksum_Val_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Checksum_Val_List'Access);
      
      Debug_Name_For_Internal_Entity_Channel_Attribute_List : aliased constant String :=
        "ChannelAttribute.list";
      Desc_For_Internal_Entity_Channel_Attribute_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Channel_Attribute_List'Access);
      
      Debug_Name_For_Internal_Entity_Checksum_Assoc_List : aliased constant String :=
        "ChecksumAssoc.list";
      Desc_For_Internal_Entity_Checksum_Assoc_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Checksum_Assoc_List'Access);
      
      Debug_Name_For_Internal_Entity_Choice_List : aliased constant String :=
        "Choice.list";
      Desc_For_Internal_Entity_Choice_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Choice_List'Access);
      
      Debug_Name_For_Internal_Entity_Conditional_Transition_List : aliased constant String :=
        "ConditionalTransition.list";
      Desc_For_Internal_Entity_Conditional_Transition_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Conditional_Transition_List'Access);
      
      Debug_Name_For_Internal_Entity_Context_Item_List : aliased constant String :=
        "ContextItem.list";
      Desc_For_Internal_Entity_Context_Item_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Context_Item_List'Access);
      
      Debug_Name_For_Internal_Entity_Declaration_List : aliased constant String :=
        "Declaration.list";
      Desc_For_Internal_Entity_Declaration_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Declaration_List'Access);
      
      Debug_Name_For_Internal_Entity_Element_Value_Assoc_List : aliased constant String :=
        "ElementValueAssoc.list";
      Desc_For_Internal_Entity_Element_Value_Assoc_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Element_Value_Assoc_List'Access);
      
      Debug_Name_For_Internal_Entity_Expr_List : aliased constant String :=
        "Expr.list";
      Desc_For_Internal_Entity_Expr_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Expr_List'Access);
      
      Debug_Name_For_Internal_Entity_Formal_Decl_List : aliased constant String :=
        "FormalDecl.list";
      Desc_For_Internal_Entity_Formal_Decl_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Formal_Decl_List'Access);
      
      Debug_Name_For_Internal_Entity_Local_Decl_List : aliased constant String :=
        "LocalDecl.list";
      Desc_For_Internal_Entity_Local_Decl_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Local_Decl_List'Access);
      
      Debug_Name_For_Internal_Entity_Message_Aggregate_Association_List : aliased constant String :=
        "MessageAggregateAssociation.list";
      Desc_For_Internal_Entity_Message_Aggregate_Association_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Message_Aggregate_Association_List'Access);
      
      Debug_Name_For_Internal_Entity_Message_Aspect_List : aliased constant String :=
        "MessageAspect.list";
      Desc_For_Internal_Entity_Message_Aspect_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Message_Aspect_List'Access);
      
      Debug_Name_For_Internal_Entity_Message_Field_List : aliased constant String :=
        "MessageField.list";
      Desc_For_Internal_Entity_Message_Field_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Message_Field_List'Access);
      
      Debug_Name_For_Internal_Entity_Numeric_Literal_List : aliased constant String :=
        "NumericLiteral.list";
      Desc_For_Internal_Entity_Numeric_Literal_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Numeric_Literal_List'Access);
      
      Debug_Name_For_Internal_Entity_Parameter_List : aliased constant String :=
        "Parameter.list";
      Desc_For_Internal_Entity_Parameter_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Parameter_List'Access);
      
      Debug_Name_For_Internal_Entity_R_F_L_X_Node_List : aliased constant String :=
        "RFLXNode.list";
      Desc_For_Internal_Entity_R_F_L_X_Node_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_R_F_L_X_Node_List'Access);
      
      Debug_Name_For_Internal_Entity_State_List : aliased constant String :=
        "State.list";
      Desc_For_Internal_Entity_State_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_State_List'Access);
      
      Debug_Name_For_Internal_Entity_Statement_List : aliased constant String :=
        "Statement.list";
      Desc_For_Internal_Entity_Statement_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Statement_List'Access);
      
      Debug_Name_For_Internal_Entity_Term_Assoc_List : aliased constant String :=
        "TermAssoc.list";
      Desc_For_Internal_Entity_Term_Assoc_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Term_Assoc_List'Access);
      
      Debug_Name_For_Internal_Entity_Then_Node_List : aliased constant String :=
        "Then.list";
      Desc_For_Internal_Entity_Then_Node_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Then_Node_List'Access);
      
      Debug_Name_For_Internal_Entity_Type_Argument_List : aliased constant String :=
        "TypeArgument.list";
      Desc_For_Internal_Entity_Type_Argument_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Type_Argument_List'Access);
      
      Debug_Name_For_Internal_Entity_Unqualified_I_D_List : aliased constant String :=
        "UnqualifiedID.list";
      Desc_For_Internal_Entity_Unqualified_I_D_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Unqualified_I_D_List'Access);
      
      Debug_Name_For_Internal_Entity_Specification : aliased constant String :=
        "Specification";
      Desc_For_Internal_Entity_Specification : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Specification'Access);
      
      Debug_Name_For_Internal_Entity_State : aliased constant String :=
        "State";
      Desc_For_Internal_Entity_State : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_State'Access);
      
      Debug_Name_For_Internal_Entity_State_Body : aliased constant String :=
        "StateBody";
      Desc_For_Internal_Entity_State_Body : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_State_Body'Access);
      
      Debug_Name_For_Internal_Entity_Statement : aliased constant String :=
        "Statement";
      Desc_For_Internal_Entity_Statement : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Statement'Access);
      
      Debug_Name_For_Internal_Entity_Assignment : aliased constant String :=
        "Assignment";
      Desc_For_Internal_Entity_Assignment : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Assignment'Access);
      
      Debug_Name_For_Internal_Entity_Attribute_Statement : aliased constant String :=
        "AttributeStatement";
      Desc_For_Internal_Entity_Attribute_Statement : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attribute_Statement'Access);
      
      Debug_Name_For_Internal_Entity_Message_Field_Assignment : aliased constant String :=
        "MessageFieldAssignment";
      Desc_For_Internal_Entity_Message_Field_Assignment : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Message_Field_Assignment'Access);
      
      Debug_Name_For_Internal_Entity_Reset : aliased constant String :=
        "Reset";
      Desc_For_Internal_Entity_Reset : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Reset'Access);
      
      Debug_Name_For_Internal_Entity_Term_Assoc : aliased constant String :=
        "TermAssoc";
      Desc_For_Internal_Entity_Term_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Term_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Then_Node : aliased constant String :=
        "Then";
      Desc_For_Internal_Entity_Then_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Then_Node'Access);
      
      Debug_Name_For_Internal_Entity_Transition : aliased constant String :=
        "Transition";
      Desc_For_Internal_Entity_Transition : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Transition'Access);
      
      Debug_Name_For_Internal_Entity_Conditional_Transition : aliased constant String :=
        "ConditionalTransition";
      Desc_For_Internal_Entity_Conditional_Transition : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Conditional_Transition'Access);
      
      Debug_Name_For_Internal_Entity_Type_Argument : aliased constant String :=
        "TypeArgument";
      Desc_For_Internal_Entity_Type_Argument : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Type_Argument'Access);
      
      Debug_Name_For_Internal_Entity_Type_Def : aliased constant String :=
        "TypeDef";
      Desc_For_Internal_Entity_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Abstract_Message_Type_Def : aliased constant String :=
        "AbstractMessageTypeDef";
      Desc_For_Internal_Entity_Abstract_Message_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abstract_Message_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Message_Type_Def : aliased constant String :=
        "MessageTypeDef";
      Desc_For_Internal_Entity_Message_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Message_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Null_Message_Type_Def : aliased constant String :=
        "NullMessageTypeDef";
      Desc_For_Internal_Entity_Null_Message_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Null_Message_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Enumeration_Def : aliased constant String :=
        "EnumerationDef";
      Desc_For_Internal_Entity_Enumeration_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Enumeration_Def'Access);
      
      Debug_Name_For_Internal_Entity_Named_Enumeration_Def : aliased constant String :=
        "NamedEnumerationDef";
      Desc_For_Internal_Entity_Named_Enumeration_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Named_Enumeration_Def'Access);
      
      Debug_Name_For_Internal_Entity_Positional_Enumeration_Def : aliased constant String :=
        "PositionalEnumerationDef";
      Desc_For_Internal_Entity_Positional_Enumeration_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Positional_Enumeration_Def'Access);
      
      Debug_Name_For_Internal_Entity_Enumeration_Type_Def : aliased constant String :=
        "EnumerationTypeDef";
      Desc_For_Internal_Entity_Enumeration_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Enumeration_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Integer_Type_Def : aliased constant String :=
        "IntegerTypeDef";
      Desc_For_Internal_Entity_Integer_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Integer_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Modular_Type_Def : aliased constant String :=
        "ModularTypeDef";
      Desc_For_Internal_Entity_Modular_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Modular_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Range_Type_Def : aliased constant String :=
        "RangeTypeDef";
      Desc_For_Internal_Entity_Range_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Range_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Sequence_Type_Def : aliased constant String :=
        "SequenceTypeDef";
      Desc_For_Internal_Entity_Sequence_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Sequence_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Type_Derivation_Def : aliased constant String :=
        "TypeDerivationDef";
      Desc_For_Internal_Entity_Type_Derivation_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Type_Derivation_Def'Access);

   Types : aliased constant Type_Descriptor_Array := (
      Desc_For_Internal_Unit'Access,
Desc_For_Big_Integer_Type'Access,
Desc_For_Boolean'Access,
Desc_For_Character_Type'Access,
Desc_For_Integer'Access,
Desc_For_Source_Location_Range'Access,
Desc_For_String_Type'Access,
Desc_For_Token_Reference'Access,
Desc_For_Symbol_Type'Access,
Desc_For_Analysis_Unit_Kind'Access,
Desc_For_Lookup_Kind'Access,
Desc_For_Designated_Env_Kind'Access,
Desc_For_Grammar_Rule'Access,
Desc_For_Internal_Entity_Array_Access'Access,
Desc_For_Internal_Entity'Access,
Desc_For_Internal_Entity_Abstract_I_D'Access,
Desc_For_Internal_Entity_I_D'Access,
Desc_For_Internal_Entity_Unqualified_I_D'Access,
Desc_For_Internal_Entity_Aspect'Access,
Desc_For_Internal_Entity_Attr'Access,
Desc_For_Internal_Entity_Attr_First'Access,
Desc_For_Internal_Entity_Attr_Has_Data'Access,
Desc_For_Internal_Entity_Attr_Head'Access,
Desc_For_Internal_Entity_Attr_Last'Access,
Desc_For_Internal_Entity_Attr_Opaque'Access,
Desc_For_Internal_Entity_Attr_Present'Access,
Desc_For_Internal_Entity_Attr_Size'Access,
Desc_For_Internal_Entity_Attr_Valid'Access,
Desc_For_Internal_Entity_Attr_Valid_Checksum'Access,
Desc_For_Internal_Entity_Attr_Stmt'Access,
Desc_For_Internal_Entity_Attr_Stmt_Append'Access,
Desc_For_Internal_Entity_Attr_Stmt_Extend'Access,
Desc_For_Internal_Entity_Attr_Stmt_Read'Access,
Desc_For_Internal_Entity_Attr_Stmt_Write'Access,
Desc_For_Internal_Entity_Base_Aggregate'Access,
Desc_For_Internal_Entity_Message_Aggregate_Associations'Access,
Desc_For_Internal_Entity_Null_Message_Aggregate'Access,
Desc_For_Internal_Entity_Base_Checksum_Val'Access,
Desc_For_Internal_Entity_Checksum_Val'Access,
Desc_For_Internal_Entity_Checksum_Value_Range'Access,
Desc_For_Internal_Entity_Byte_Order_Type'Access,
Desc_For_Internal_Entity_Byte_Order_Type_Highorderfirst'Access,
Desc_For_Internal_Entity_Byte_Order_Type_Loworderfirst'Access,
Desc_For_Internal_Entity_Channel_Attribute'Access,
Desc_For_Internal_Entity_Readable'Access,
Desc_For_Internal_Entity_Writable'Access,
Desc_For_Internal_Entity_Checksum_Assoc'Access,
Desc_For_Internal_Entity_Declaration'Access,
Desc_For_Internal_Entity_Refinement_Decl'Access,
Desc_For_Internal_Entity_Session_Decl'Access,
Desc_For_Internal_Entity_Type_Decl'Access,
Desc_For_Internal_Entity_Description'Access,
Desc_For_Internal_Entity_Element_Value_Assoc'Access,
Desc_For_Internal_Entity_Expr'Access,
Desc_For_Internal_Entity_Attribute'Access,
Desc_For_Internal_Entity_Bin_Op'Access,
Desc_For_Internal_Entity_Binding'Access,
Desc_For_Internal_Entity_Call'Access,
Desc_For_Internal_Entity_Case_Expression'Access,
Desc_For_Internal_Entity_Choice'Access,
Desc_For_Internal_Entity_Comprehension'Access,
Desc_For_Internal_Entity_Context_Item'Access,
Desc_For_Internal_Entity_Conversion'Access,
Desc_For_Internal_Entity_Message_Aggregate'Access,
Desc_For_Internal_Entity_Negation'Access,
Desc_For_Internal_Entity_Numeric_Literal'Access,
Desc_For_Internal_Entity_Paren_Expression'Access,
Desc_For_Internal_Entity_Quantified_Expression'Access,
Desc_For_Internal_Entity_Select_Node'Access,
Desc_For_Internal_Entity_Sequence_Literal'Access,
Desc_For_Internal_Entity_Concatenation'Access,
Desc_For_Internal_Entity_Sequence_Aggregate'Access,
Desc_For_Internal_Entity_String_Literal'Access,
Desc_For_Internal_Entity_Variable'Access,
Desc_For_Internal_Entity_Formal_Decl'Access,
Desc_For_Internal_Entity_Formal_Channel_Decl'Access,
Desc_For_Internal_Entity_Formal_Function_Decl'Access,
Desc_For_Internal_Entity_Local_Decl'Access,
Desc_For_Internal_Entity_Renaming_Decl'Access,
Desc_For_Internal_Entity_Variable_Decl'Access,
Desc_For_Internal_Entity_Message_Aggregate_Association'Access,
Desc_For_Internal_Entity_Message_Aspect'Access,
Desc_For_Internal_Entity_Byte_Order_Aspect'Access,
Desc_For_Internal_Entity_Checksum_Aspect'Access,
Desc_For_Internal_Entity_Message_Field'Access,
Desc_For_Internal_Entity_Message_Fields'Access,
Desc_For_Internal_Entity_Null_Message_Field'Access,
Desc_For_Internal_Entity_Op'Access,
Desc_For_Internal_Entity_Op_Add'Access,
Desc_For_Internal_Entity_Op_And'Access,
Desc_For_Internal_Entity_Op_Div'Access,
Desc_For_Internal_Entity_Op_Eq'Access,
Desc_For_Internal_Entity_Op_Ge'Access,
Desc_For_Internal_Entity_Op_Gt'Access,
Desc_For_Internal_Entity_Op_In'Access,
Desc_For_Internal_Entity_Op_Le'Access,
Desc_For_Internal_Entity_Op_Lt'Access,
Desc_For_Internal_Entity_Op_Mod'Access,
Desc_For_Internal_Entity_Op_Mul'Access,
Desc_For_Internal_Entity_Op_Neq'Access,
Desc_For_Internal_Entity_Op_Notin'Access,
Desc_For_Internal_Entity_Op_Or'Access,
Desc_For_Internal_Entity_Op_Pow'Access,
Desc_For_Internal_Entity_Op_Sub'Access,
Desc_For_Internal_Entity_Package_Node'Access,
Desc_For_Internal_Entity_Parameter'Access,
Desc_For_Internal_Entity_Parameters'Access,
Desc_For_Internal_Entity_Quantifier'Access,
Desc_For_Internal_Entity_Quantifier_All'Access,
Desc_For_Internal_Entity_Quantifier_Some'Access,
Desc_For_Internal_Entity_R_F_L_X_Node_Base_List'Access,
Desc_For_Internal_Entity_Aspect_List'Access,
Desc_For_Internal_Entity_Base_Checksum_Val_List'Access,
Desc_For_Internal_Entity_Channel_Attribute_List'Access,
Desc_For_Internal_Entity_Checksum_Assoc_List'Access,
Desc_For_Internal_Entity_Choice_List'Access,
Desc_For_Internal_Entity_Conditional_Transition_List'Access,
Desc_For_Internal_Entity_Context_Item_List'Access,
Desc_For_Internal_Entity_Declaration_List'Access,
Desc_For_Internal_Entity_Element_Value_Assoc_List'Access,
Desc_For_Internal_Entity_Expr_List'Access,
Desc_For_Internal_Entity_Formal_Decl_List'Access,
Desc_For_Internal_Entity_Local_Decl_List'Access,
Desc_For_Internal_Entity_Message_Aggregate_Association_List'Access,
Desc_For_Internal_Entity_Message_Aspect_List'Access,
Desc_For_Internal_Entity_Message_Field_List'Access,
Desc_For_Internal_Entity_Numeric_Literal_List'Access,
Desc_For_Internal_Entity_Parameter_List'Access,
Desc_For_Internal_Entity_R_F_L_X_Node_List'Access,
Desc_For_Internal_Entity_State_List'Access,
Desc_For_Internal_Entity_Statement_List'Access,
Desc_For_Internal_Entity_Term_Assoc_List'Access,
Desc_For_Internal_Entity_Then_Node_List'Access,
Desc_For_Internal_Entity_Type_Argument_List'Access,
Desc_For_Internal_Entity_Unqualified_I_D_List'Access,
Desc_For_Internal_Entity_Specification'Access,
Desc_For_Internal_Entity_State'Access,
Desc_For_Internal_Entity_State_Body'Access,
Desc_For_Internal_Entity_Statement'Access,
Desc_For_Internal_Entity_Assignment'Access,
Desc_For_Internal_Entity_Attribute_Statement'Access,
Desc_For_Internal_Entity_Message_Field_Assignment'Access,
Desc_For_Internal_Entity_Reset'Access,
Desc_For_Internal_Entity_Term_Assoc'Access,
Desc_For_Internal_Entity_Then_Node'Access,
Desc_For_Internal_Entity_Transition'Access,
Desc_For_Internal_Entity_Conditional_Transition'Access,
Desc_For_Internal_Entity_Type_Argument'Access,
Desc_For_Internal_Entity_Type_Def'Access,
Desc_For_Internal_Entity_Abstract_Message_Type_Def'Access,
Desc_For_Internal_Entity_Message_Type_Def'Access,
Desc_For_Internal_Entity_Null_Message_Type_Def'Access,
Desc_For_Internal_Entity_Enumeration_Def'Access,
Desc_For_Internal_Entity_Named_Enumeration_Def'Access,
Desc_For_Internal_Entity_Positional_Enumeration_Def'Access,
Desc_For_Internal_Entity_Enumeration_Type_Def'Access,
Desc_For_Internal_Entity_Integer_Type_Def'Access,
Desc_For_Internal_Entity_Modular_Type_Def'Access,
Desc_For_Internal_Entity_Range_Type_Def'Access,
Desc_For_Internal_Entity_Sequence_Type_Def'Access,
Desc_For_Internal_Entity_Type_Derivation_Def'Access
   );

   ---------------------------
   -- Enum type descriptors --
   ---------------------------

   
      

         Enum_Name_For_Analysis_Unit_Kind_1 : aliased constant Text_Type :=
           "Unit_Specification";
         Enum_Name_For_Analysis_Unit_Kind_2 : aliased constant Text_Type :=
           "Unit_Body";

      Enum_Name_For_Analysis_Unit_Kind : aliased constant Text_Type :=
        "Analysis_Unit_Kind";
      Enum_Desc_For_Analysis_Unit_Kind : aliased constant Enum_Type_Descriptor := (
         Last_Value    => 2,
         Name          => Enum_Name_For_Analysis_Unit_Kind'Access,
         Default_Value => 0,
         Value_Names   => (
            1 => Enum_Name_For_Analysis_Unit_Kind_1'Access,
2 => Enum_Name_For_Analysis_Unit_Kind_2'Access
         )
      );
      

         Enum_Name_For_Lookup_Kind_1 : aliased constant Text_Type :=
           "Recursive";
         Enum_Name_For_Lookup_Kind_2 : aliased constant Text_Type :=
           "Flat";
         Enum_Name_For_Lookup_Kind_3 : aliased constant Text_Type :=
           "Minimal";

      Enum_Name_For_Lookup_Kind : aliased constant Text_Type :=
        "Lookup_Kind";
      Enum_Desc_For_Lookup_Kind : aliased constant Enum_Type_Descriptor := (
         Last_Value    => 3,
         Name          => Enum_Name_For_Lookup_Kind'Access,
         Default_Value => 0,
         Value_Names   => (
            1 => Enum_Name_For_Lookup_Kind_1'Access,
2 => Enum_Name_For_Lookup_Kind_2'Access,
3 => Enum_Name_For_Lookup_Kind_3'Access
         )
      );
      

         Enum_Name_For_Designated_Env_Kind_1 : aliased constant Text_Type :=
           "None";
         Enum_Name_For_Designated_Env_Kind_2 : aliased constant Text_Type :=
           "Current_Env";
         Enum_Name_For_Designated_Env_Kind_3 : aliased constant Text_Type :=
           "Named_Env";
         Enum_Name_For_Designated_Env_Kind_4 : aliased constant Text_Type :=
           "Direct_Env";

      Enum_Name_For_Designated_Env_Kind : aliased constant Text_Type :=
        "Designated_Env_Kind";
      Enum_Desc_For_Designated_Env_Kind : aliased constant Enum_Type_Descriptor := (
         Last_Value    => 4,
         Name          => Enum_Name_For_Designated_Env_Kind'Access,
         Default_Value => 1,
         Value_Names   => (
            1 => Enum_Name_For_Designated_Env_Kind_1'Access,
2 => Enum_Name_For_Designated_Env_Kind_2'Access,
3 => Enum_Name_For_Designated_Env_Kind_3'Access,
4 => Enum_Name_For_Designated_Env_Kind_4'Access
         )
      );
      

         Enum_Name_For_Grammar_Rule_1 : aliased constant Text_Type :=
           "Main_Rule_Rule";
         Enum_Name_For_Grammar_Rule_2 : aliased constant Text_Type :=
           "Unqualified_Identifier_Rule";
         Enum_Name_For_Grammar_Rule_3 : aliased constant Text_Type :=
           "Qualified_Identifier_Rule";
         Enum_Name_For_Grammar_Rule_4 : aliased constant Text_Type :=
           "Numeric_Literal_Rule";
         Enum_Name_For_Grammar_Rule_5 : aliased constant Text_Type :=
           "Variable_Rule";
         Enum_Name_For_Grammar_Rule_6 : aliased constant Text_Type :=
           "Sequence_Aggregate_Rule";
         Enum_Name_For_Grammar_Rule_7 : aliased constant Text_Type :=
           "String_Literal_Rule";
         Enum_Name_For_Grammar_Rule_8 : aliased constant Text_Type :=
           "Concatenation_Rule";
         Enum_Name_For_Grammar_Rule_9 : aliased constant Text_Type :=
           "Primary_Rule";
         Enum_Name_For_Grammar_Rule_10 : aliased constant Text_Type :=
           "Paren_Expression_Rule";
         Enum_Name_For_Grammar_Rule_11 : aliased constant Text_Type :=
           "Suffix_Rule";
         Enum_Name_For_Grammar_Rule_12 : aliased constant Text_Type :=
           "Factor_Rule";
         Enum_Name_For_Grammar_Rule_13 : aliased constant Text_Type :=
           "Term_Rule";
         Enum_Name_For_Grammar_Rule_14 : aliased constant Text_Type :=
           "Unop_Term_Rule";
         Enum_Name_For_Grammar_Rule_15 : aliased constant Text_Type :=
           "Simple_Expr_Rule";
         Enum_Name_For_Grammar_Rule_16 : aliased constant Text_Type :=
           "Relation_Rule";
         Enum_Name_For_Grammar_Rule_17 : aliased constant Text_Type :=
           "Expression_Rule";
         Enum_Name_For_Grammar_Rule_18 : aliased constant Text_Type :=
           "Quantified_Expression_Rule";
         Enum_Name_For_Grammar_Rule_19 : aliased constant Text_Type :=
           "Comprehension_Rule";
         Enum_Name_For_Grammar_Rule_20 : aliased constant Text_Type :=
           "Call_Rule";
         Enum_Name_For_Grammar_Rule_21 : aliased constant Text_Type :=
           "Conversion_Rule";
         Enum_Name_For_Grammar_Rule_22 : aliased constant Text_Type :=
           "Null_Message_Aggregate_Rule";
         Enum_Name_For_Grammar_Rule_23 : aliased constant Text_Type :=
           "Message_Aggregate_Association_Rule";
         Enum_Name_For_Grammar_Rule_24 : aliased constant Text_Type :=
           "Message_Aggregate_Association_List_Rule";
         Enum_Name_For_Grammar_Rule_25 : aliased constant Text_Type :=
           "Message_Aggregate_Rule";
         Enum_Name_For_Grammar_Rule_26 : aliased constant Text_Type :=
           "Extended_Primary_Rule";
         Enum_Name_For_Grammar_Rule_27 : aliased constant Text_Type :=
           "Extended_Paren_Expression_Rule";
         Enum_Name_For_Grammar_Rule_28 : aliased constant Text_Type :=
           "Extended_Choice_List_Rule";
         Enum_Name_For_Grammar_Rule_29 : aliased constant Text_Type :=
           "Extended_Choices_Rule";
         Enum_Name_For_Grammar_Rule_30 : aliased constant Text_Type :=
           "Extended_Case_Expression_Rule";
         Enum_Name_For_Grammar_Rule_31 : aliased constant Text_Type :=
           "Extended_Suffix_Rule";
         Enum_Name_For_Grammar_Rule_32 : aliased constant Text_Type :=
           "Extended_Factor_Rule";
         Enum_Name_For_Grammar_Rule_33 : aliased constant Text_Type :=
           "Extended_Term_Rule";
         Enum_Name_For_Grammar_Rule_34 : aliased constant Text_Type :=
           "Extended_Unop_Term_Rule";
         Enum_Name_For_Grammar_Rule_35 : aliased constant Text_Type :=
           "Extended_Simple_Expr_Rule";
         Enum_Name_For_Grammar_Rule_36 : aliased constant Text_Type :=
           "Extended_Relation_Rule";
         Enum_Name_For_Grammar_Rule_37 : aliased constant Text_Type :=
           "Extended_Expression_Rule";
         Enum_Name_For_Grammar_Rule_38 : aliased constant Text_Type :=
           "Aspect_Rule";
         Enum_Name_For_Grammar_Rule_39 : aliased constant Text_Type :=
           "Range_Type_Definition_Rule";
         Enum_Name_For_Grammar_Rule_40 : aliased constant Text_Type :=
           "Modular_Type_Definition_Rule";
         Enum_Name_For_Grammar_Rule_41 : aliased constant Text_Type :=
           "Integer_Type_Definition_Rule";
         Enum_Name_For_Grammar_Rule_42 : aliased constant Text_Type :=
           "If_Condition_Rule";
         Enum_Name_For_Grammar_Rule_43 : aliased constant Text_Type :=
           "Extended_If_Condition_Rule";
         Enum_Name_For_Grammar_Rule_44 : aliased constant Text_Type :=
           "Then_Rule";
         Enum_Name_For_Grammar_Rule_45 : aliased constant Text_Type :=
           "Type_Argument_Rule";
         Enum_Name_For_Grammar_Rule_46 : aliased constant Text_Type :=
           "Null_Message_Field_Rule";
         Enum_Name_For_Grammar_Rule_47 : aliased constant Text_Type :=
           "Message_Field_Rule";
         Enum_Name_For_Grammar_Rule_48 : aliased constant Text_Type :=
           "Message_Field_List_Rule";
         Enum_Name_For_Grammar_Rule_49 : aliased constant Text_Type :=
           "Value_Range_Rule";
         Enum_Name_For_Grammar_Rule_50 : aliased constant Text_Type :=
           "Checksum_Association_Rule";
         Enum_Name_For_Grammar_Rule_51 : aliased constant Text_Type :=
           "Checksum_Aspect_Rule";
         Enum_Name_For_Grammar_Rule_52 : aliased constant Text_Type :=
           "Byte_Order_Aspect_Rule";
         Enum_Name_For_Grammar_Rule_53 : aliased constant Text_Type :=
           "Message_Aspect_List_Rule";
         Enum_Name_For_Grammar_Rule_54 : aliased constant Text_Type :=
           "Message_Type_Definition_Rule";
         Enum_Name_For_Grammar_Rule_55 : aliased constant Text_Type :=
           "Positional_Enumeration_Rule";
         Enum_Name_For_Grammar_Rule_56 : aliased constant Text_Type :=
           "Element_Value_Association_Rule";
         Enum_Name_For_Grammar_Rule_57 : aliased constant Text_Type :=
           "Named_Enumeration_Rule";
         Enum_Name_For_Grammar_Rule_58 : aliased constant Text_Type :=
           "Enumeration_Aspects_Rule";
         Enum_Name_For_Grammar_Rule_59 : aliased constant Text_Type :=
           "Enumeration_Type_Definition_Rule";
         Enum_Name_For_Grammar_Rule_60 : aliased constant Text_Type :=
           "Type_Derivation_Definition_Rule";
         Enum_Name_For_Grammar_Rule_61 : aliased constant Text_Type :=
           "Sequence_Type_Definition_Rule";
         Enum_Name_For_Grammar_Rule_62 : aliased constant Text_Type :=
           "Type_Declaration_Rule";
         Enum_Name_For_Grammar_Rule_63 : aliased constant Text_Type :=
           "Type_Refinement_Rule";
         Enum_Name_For_Grammar_Rule_64 : aliased constant Text_Type :=
           "Parameter_Rule";
         Enum_Name_For_Grammar_Rule_65 : aliased constant Text_Type :=
           "Parameter_List_Rule";
         Enum_Name_For_Grammar_Rule_66 : aliased constant Text_Type :=
           "Formal_Function_Declaration_Rule";
         Enum_Name_For_Grammar_Rule_67 : aliased constant Text_Type :=
           "Channel_Declaration_Rule";
         Enum_Name_For_Grammar_Rule_68 : aliased constant Text_Type :=
           "Session_Parameter_Rule";
         Enum_Name_For_Grammar_Rule_69 : aliased constant Text_Type :=
           "Renaming_Declaration_Rule";
         Enum_Name_For_Grammar_Rule_70 : aliased constant Text_Type :=
           "Variable_Declaration_Rule";
         Enum_Name_For_Grammar_Rule_71 : aliased constant Text_Type :=
           "Declaration_Rule";
         Enum_Name_For_Grammar_Rule_72 : aliased constant Text_Type :=
           "Description_Aspect_Rule";
         Enum_Name_For_Grammar_Rule_73 : aliased constant Text_Type :=
           "Assignment_Statement_Rule";
         Enum_Name_For_Grammar_Rule_74 : aliased constant Text_Type :=
           "Message_Field_Assignment_Statement_Rule";
         Enum_Name_For_Grammar_Rule_75 : aliased constant Text_Type :=
           "List_Attribute_Rule";
         Enum_Name_For_Grammar_Rule_76 : aliased constant Text_Type :=
           "Reset_Rule";
         Enum_Name_For_Grammar_Rule_77 : aliased constant Text_Type :=
           "Attribute_Statement_Rule";
         Enum_Name_For_Grammar_Rule_78 : aliased constant Text_Type :=
           "Action_Rule";
         Enum_Name_For_Grammar_Rule_79 : aliased constant Text_Type :=
           "Conditional_Transition_Rule";
         Enum_Name_For_Grammar_Rule_80 : aliased constant Text_Type :=
           "Transition_Rule";
         Enum_Name_For_Grammar_Rule_81 : aliased constant Text_Type :=
           "State_Body_Rule";
         Enum_Name_For_Grammar_Rule_82 : aliased constant Text_Type :=
           "State_Rule";
         Enum_Name_For_Grammar_Rule_83 : aliased constant Text_Type :=
           "Session_Declaration_Rule";
         Enum_Name_For_Grammar_Rule_84 : aliased constant Text_Type :=
           "Basic_Declaration_Rule";
         Enum_Name_For_Grammar_Rule_85 : aliased constant Text_Type :=
           "Basic_Declarations_Rule";
         Enum_Name_For_Grammar_Rule_86 : aliased constant Text_Type :=
           "Package_Declaration_Rule";
         Enum_Name_For_Grammar_Rule_87 : aliased constant Text_Type :=
           "Context_Item_Rule";
         Enum_Name_For_Grammar_Rule_88 : aliased constant Text_Type :=
           "Context_Clause_Rule";
         Enum_Name_For_Grammar_Rule_89 : aliased constant Text_Type :=
           "Specification_Rule";

      Enum_Name_For_Grammar_Rule : aliased constant Text_Type :=
        "Grammar_Rule";
      Enum_Desc_For_Grammar_Rule : aliased constant Enum_Type_Descriptor := (
         Last_Value    => 89,
         Name          => Enum_Name_For_Grammar_Rule'Access,
         Default_Value => 0,
         Value_Names   => (
            1 => Enum_Name_For_Grammar_Rule_1'Access,
2 => Enum_Name_For_Grammar_Rule_2'Access,
3 => Enum_Name_For_Grammar_Rule_3'Access,
4 => Enum_Name_For_Grammar_Rule_4'Access,
5 => Enum_Name_For_Grammar_Rule_5'Access,
6 => Enum_Name_For_Grammar_Rule_6'Access,
7 => Enum_Name_For_Grammar_Rule_7'Access,
8 => Enum_Name_For_Grammar_Rule_8'Access,
9 => Enum_Name_For_Grammar_Rule_9'Access,
10 => Enum_Name_For_Grammar_Rule_10'Access,
11 => Enum_Name_For_Grammar_Rule_11'Access,
12 => Enum_Name_For_Grammar_Rule_12'Access,
13 => Enum_Name_For_Grammar_Rule_13'Access,
14 => Enum_Name_For_Grammar_Rule_14'Access,
15 => Enum_Name_For_Grammar_Rule_15'Access,
16 => Enum_Name_For_Grammar_Rule_16'Access,
17 => Enum_Name_For_Grammar_Rule_17'Access,
18 => Enum_Name_For_Grammar_Rule_18'Access,
19 => Enum_Name_For_Grammar_Rule_19'Access,
20 => Enum_Name_For_Grammar_Rule_20'Access,
21 => Enum_Name_For_Grammar_Rule_21'Access,
22 => Enum_Name_For_Grammar_Rule_22'Access,
23 => Enum_Name_For_Grammar_Rule_23'Access,
24 => Enum_Name_For_Grammar_Rule_24'Access,
25 => Enum_Name_For_Grammar_Rule_25'Access,
26 => Enum_Name_For_Grammar_Rule_26'Access,
27 => Enum_Name_For_Grammar_Rule_27'Access,
28 => Enum_Name_For_Grammar_Rule_28'Access,
29 => Enum_Name_For_Grammar_Rule_29'Access,
30 => Enum_Name_For_Grammar_Rule_30'Access,
31 => Enum_Name_For_Grammar_Rule_31'Access,
32 => Enum_Name_For_Grammar_Rule_32'Access,
33 => Enum_Name_For_Grammar_Rule_33'Access,
34 => Enum_Name_For_Grammar_Rule_34'Access,
35 => Enum_Name_For_Grammar_Rule_35'Access,
36 => Enum_Name_For_Grammar_Rule_36'Access,
37 => Enum_Name_For_Grammar_Rule_37'Access,
38 => Enum_Name_For_Grammar_Rule_38'Access,
39 => Enum_Name_For_Grammar_Rule_39'Access,
40 => Enum_Name_For_Grammar_Rule_40'Access,
41 => Enum_Name_For_Grammar_Rule_41'Access,
42 => Enum_Name_For_Grammar_Rule_42'Access,
43 => Enum_Name_For_Grammar_Rule_43'Access,
44 => Enum_Name_For_Grammar_Rule_44'Access,
45 => Enum_Name_For_Grammar_Rule_45'Access,
46 => Enum_Name_For_Grammar_Rule_46'Access,
47 => Enum_Name_For_Grammar_Rule_47'Access,
48 => Enum_Name_For_Grammar_Rule_48'Access,
49 => Enum_Name_For_Grammar_Rule_49'Access,
50 => Enum_Name_For_Grammar_Rule_50'Access,
51 => Enum_Name_For_Grammar_Rule_51'Access,
52 => Enum_Name_For_Grammar_Rule_52'Access,
53 => Enum_Name_For_Grammar_Rule_53'Access,
54 => Enum_Name_For_Grammar_Rule_54'Access,
55 => Enum_Name_For_Grammar_Rule_55'Access,
56 => Enum_Name_For_Grammar_Rule_56'Access,
57 => Enum_Name_For_Grammar_Rule_57'Access,
58 => Enum_Name_For_Grammar_Rule_58'Access,
59 => Enum_Name_For_Grammar_Rule_59'Access,
60 => Enum_Name_For_Grammar_Rule_60'Access,
61 => Enum_Name_For_Grammar_Rule_61'Access,
62 => Enum_Name_For_Grammar_Rule_62'Access,
63 => Enum_Name_For_Grammar_Rule_63'Access,
64 => Enum_Name_For_Grammar_Rule_64'Access,
65 => Enum_Name_For_Grammar_Rule_65'Access,
66 => Enum_Name_For_Grammar_Rule_66'Access,
67 => Enum_Name_For_Grammar_Rule_67'Access,
68 => Enum_Name_For_Grammar_Rule_68'Access,
69 => Enum_Name_For_Grammar_Rule_69'Access,
70 => Enum_Name_For_Grammar_Rule_70'Access,
71 => Enum_Name_For_Grammar_Rule_71'Access,
72 => Enum_Name_For_Grammar_Rule_72'Access,
73 => Enum_Name_For_Grammar_Rule_73'Access,
74 => Enum_Name_For_Grammar_Rule_74'Access,
75 => Enum_Name_For_Grammar_Rule_75'Access,
76 => Enum_Name_For_Grammar_Rule_76'Access,
77 => Enum_Name_For_Grammar_Rule_77'Access,
78 => Enum_Name_For_Grammar_Rule_78'Access,
79 => Enum_Name_For_Grammar_Rule_79'Access,
80 => Enum_Name_For_Grammar_Rule_80'Access,
81 => Enum_Name_For_Grammar_Rule_81'Access,
82 => Enum_Name_For_Grammar_Rule_82'Access,
83 => Enum_Name_For_Grammar_Rule_83'Access,
84 => Enum_Name_For_Grammar_Rule_84'Access,
85 => Enum_Name_For_Grammar_Rule_85'Access,
86 => Enum_Name_For_Grammar_Rule_86'Access,
87 => Enum_Name_For_Grammar_Rule_87'Access,
88 => Enum_Name_For_Grammar_Rule_88'Access,
89 => Enum_Name_For_Grammar_Rule_89'Access
         )
      );
   Enum_Types : aliased constant Enum_Type_Descriptor_Array := (
      Type_Index_For_Analysis_Unit_Kind => Enum_Desc_For_Analysis_Unit_Kind'Access,
Type_Index_For_Lookup_Kind => Enum_Desc_For_Lookup_Kind'Access,
Type_Index_For_Designated_Env_Kind => Enum_Desc_For_Designated_Env_Kind'Access,
Type_Index_For_Grammar_Rule => Enum_Desc_For_Grammar_Rule'Access
   );

   ------------------------------------
   -- Introspection values for enums --
   ------------------------------------

      
      type Internal_Rec_Analysis_Unit_Kind is new Base_Internal_Enum_Value with record
         Value : Analysis_Unit_Kind;
      end record;
      type Internal_Acc_Analysis_Unit_Kind is access all Internal_Rec_Analysis_Unit_Kind;

      overriding function "=" (Left, Right : Internal_Rec_Analysis_Unit_Kind) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Analysis_Unit_Kind) return Type_Index;
      overriding function Image (Value : Internal_Rec_Analysis_Unit_Kind) return String;
      overriding function Value_Index (Value : Internal_Rec_Analysis_Unit_Kind) return Enum_Value_Index;
      
      type Internal_Rec_Lookup_Kind is new Base_Internal_Enum_Value with record
         Value : Lookup_Kind;
      end record;
      type Internal_Acc_Lookup_Kind is access all Internal_Rec_Lookup_Kind;

      overriding function "=" (Left, Right : Internal_Rec_Lookup_Kind) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Lookup_Kind) return Type_Index;
      overriding function Image (Value : Internal_Rec_Lookup_Kind) return String;
      overriding function Value_Index (Value : Internal_Rec_Lookup_Kind) return Enum_Value_Index;
      
      type Internal_Rec_Designated_Env_Kind is new Base_Internal_Enum_Value with record
         Value : Designated_Env_Kind;
      end record;
      type Internal_Acc_Designated_Env_Kind is access all Internal_Rec_Designated_Env_Kind;

      overriding function "=" (Left, Right : Internal_Rec_Designated_Env_Kind) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Designated_Env_Kind) return Type_Index;
      overriding function Image (Value : Internal_Rec_Designated_Env_Kind) return String;
      overriding function Value_Index (Value : Internal_Rec_Designated_Env_Kind) return Enum_Value_Index;
      
      type Internal_Rec_Grammar_Rule is new Base_Internal_Enum_Value with record
         Value : Grammar_Rule;
      end record;
      type Internal_Acc_Grammar_Rule is access all Internal_Rec_Grammar_Rule;

      overriding function "=" (Left, Right : Internal_Rec_Grammar_Rule) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Grammar_Rule) return Type_Index;
      overriding function Image (Value : Internal_Rec_Grammar_Rule) return String;
      overriding function Value_Index (Value : Internal_Rec_Grammar_Rule) return Enum_Value_Index;

   function Create_Enum
     (Enum_Type   : Type_Index;
      Value_Index : Enum_Value_Index) return Internal_Value_Access;
   --  Implementation of the Create_Enum operation in the lanugage descriptor

   ----------------------------
   -- Array type descriptors --
   ----------------------------

   
   Array_Types : aliased constant Array_Type_Descriptor_Array := (
      Type_Index_For_R_F_L_X_Node_Array => (Element_Type => Type_Index_For_R_F_L_X_Node)
   );

   -------------------------------------
   -- Introspection values for arrays --
   -------------------------------------

      

      type Internal_Stored_R_F_L_X_Node_Array is access all R_F_L_X_Node_Array;
      procedure Free is new Ada.Unchecked_Deallocation (R_F_L_X_Node_Array, Internal_Stored_R_F_L_X_Node_Array);

      type Internal_Rec_R_F_L_X_Node_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_R_F_L_X_Node_Array;
      end record;
      type Internal_Acc_R_F_L_X_Node_Array is access all Internal_Rec_R_F_L_X_Node_Array;

      overriding function "=" (Left, Right : Internal_Rec_R_F_L_X_Node_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_R_F_L_X_Node_Array);
      overriding function Type_Of (Value : Internal_Rec_R_F_L_X_Node_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_R_F_L_X_Node_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_R_F_L_X_Node_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_R_F_L_X_Node_Array;

   function Create_Array
     (Array_Type : Type_Index;
      Values     : Internal_Value_Array) return Internal_Value_Access;
   --  Implementation of the Create_Array operation in the language descriptor

   -------------------------------
   -- Iterator type descriptors --
   -------------------------------

   
   Iterator_Types : aliased constant Iterator_Type_Descriptor_Array := (
         1 .. 0 => <>
   );


   --------------------------------------
   -- Introspection values for structs --
   --------------------------------------


   function Create_Struct
     (Struct_Type : Type_Index;
      Values      : Internal_Value_Array) return Internal_Value_Access;
   --  Implementation for the Create_Struct operation in the language
   --  descriptor.

   -------------------------------
   -- Struct member descriptors --
   -------------------------------

   
      


      

      
         Indexes_For_I_D_F_Package : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_I_D => 1);

      Member_Name_For_I_D_F_Package : aliased constant Text_Type :=
        "F_Package";
      Member_Desc_For_I_D_F_Package : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_I_D_F_Package'Access,
         Owner         => Type_Index_For_I_D,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_I_D_F_Package'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_I_D_F_Name : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_I_D => 2);

      Member_Name_For_I_D_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_I_D_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_I_D_F_Name'Access,
         Owner         => Type_Index_For_I_D,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_I_D_F_Name'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Aspect_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Aspect => 1);

      Member_Name_For_Aspect_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Aspect_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Aspect_F_Identifier'Access,
         Owner         => Type_Index_For_Aspect,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Aspect_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Aspect_F_Value : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Aspect => 2);

      Member_Name_For_Aspect_F_Value : aliased constant Text_Type :=
        "F_Value";
      Member_Desc_For_Aspect_F_Value : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Aspect_F_Value'Access,
         Owner         => Type_Index_For_Aspect,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Aspect_F_Value'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Aggregate_Associations_F_Associations : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Aggregate_Associations => 1);

      Member_Name_For_Message_Aggregate_Associations_F_Associations : aliased constant Text_Type :=
        "F_Associations";
      Member_Desc_For_Message_Aggregate_Associations_F_Associations : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Aggregate_Associations_F_Associations'Access,
         Owner         => Type_Index_For_Message_Aggregate_Associations,
         Member_Type   => Type_Index_For_Message_Aggregate_Association_List,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Aggregate_Associations_F_Associations'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Checksum_Val_F_Data : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Checksum_Val => 1);

      Member_Name_For_Checksum_Val_F_Data : aliased constant Text_Type :=
        "F_Data";
      Member_Desc_For_Checksum_Val_F_Data : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Checksum_Val_F_Data'Access,
         Owner         => Type_Index_For_Checksum_Val,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Checksum_Val_F_Data'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Checksum_Value_Range_F_First : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Checksum_Value_Range => 1);

      Member_Name_For_Checksum_Value_Range_F_First : aliased constant Text_Type :=
        "F_First";
      Member_Desc_For_Checksum_Value_Range_F_First : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Checksum_Value_Range_F_First'Access,
         Owner         => Type_Index_For_Checksum_Value_Range,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Checksum_Value_Range_F_First'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Checksum_Value_Range_F_Last : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Checksum_Value_Range => 2);

      Member_Name_For_Checksum_Value_Range_F_Last : aliased constant Text_Type :=
        "F_Last";
      Member_Desc_For_Checksum_Value_Range_F_Last : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Checksum_Value_Range_F_Last'Access,
         Owner         => Type_Index_For_Checksum_Value_Range,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Checksum_Value_Range_F_Last'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Checksum_Assoc_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Checksum_Assoc => 1);

      Member_Name_For_Checksum_Assoc_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Checksum_Assoc_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Checksum_Assoc_F_Identifier'Access,
         Owner         => Type_Index_For_Checksum_Assoc,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Checksum_Assoc_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Checksum_Assoc_F_Covered_Fields : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Checksum_Assoc => 2);

      Member_Name_For_Checksum_Assoc_F_Covered_Fields : aliased constant Text_Type :=
        "F_Covered_Fields";
      Member_Desc_For_Checksum_Assoc_F_Covered_Fields : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Checksum_Assoc_F_Covered_Fields'Access,
         Owner         => Type_Index_For_Checksum_Assoc,
         Member_Type   => Type_Index_For_Base_Checksum_Val_List,
         Null_For      => null,
         Indexes       => Indexes_For_Checksum_Assoc_F_Covered_Fields'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Refinement_Decl_F_Pdu : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Refinement_Decl => 1);

      Member_Name_For_Refinement_Decl_F_Pdu : aliased constant Text_Type :=
        "F_Pdu";
      Member_Desc_For_Refinement_Decl_F_Pdu : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Refinement_Decl_F_Pdu'Access,
         Owner         => Type_Index_For_Refinement_Decl,
         Member_Type   => Type_Index_For_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Refinement_Decl_F_Pdu'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Refinement_Decl_F_Field : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Refinement_Decl => 2);

      Member_Name_For_Refinement_Decl_F_Field : aliased constant Text_Type :=
        "F_Field";
      Member_Desc_For_Refinement_Decl_F_Field : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Refinement_Decl_F_Field'Access,
         Owner         => Type_Index_For_Refinement_Decl,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Refinement_Decl_F_Field'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Refinement_Decl_F_Sdu : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Refinement_Decl => 3);

      Member_Name_For_Refinement_Decl_F_Sdu : aliased constant Text_Type :=
        "F_Sdu";
      Member_Desc_For_Refinement_Decl_F_Sdu : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Refinement_Decl_F_Sdu'Access,
         Owner         => Type_Index_For_Refinement_Decl,
         Member_Type   => Type_Index_For_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Refinement_Decl_F_Sdu'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Refinement_Decl_F_Condition : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Refinement_Decl => 4);

      Member_Name_For_Refinement_Decl_F_Condition : aliased constant Text_Type :=
        "F_Condition";
      Member_Desc_For_Refinement_Decl_F_Condition : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Refinement_Decl_F_Condition'Access,
         Owner         => Type_Index_For_Refinement_Decl,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Refinement_Decl_F_Condition'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Session_Decl_F_Parameters : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Session_Decl => 1);

      Member_Name_For_Session_Decl_F_Parameters : aliased constant Text_Type :=
        "F_Parameters";
      Member_Desc_For_Session_Decl_F_Parameters : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Session_Decl_F_Parameters'Access,
         Owner         => Type_Index_For_Session_Decl,
         Member_Type   => Type_Index_For_Formal_Decl_List,
         Null_For      => null,
         Indexes       => Indexes_For_Session_Decl_F_Parameters'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Session_Decl_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Session_Decl => 2);

      Member_Name_For_Session_Decl_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Session_Decl_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Session_Decl_F_Identifier'Access,
         Owner         => Type_Index_For_Session_Decl,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Session_Decl_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Session_Decl_F_Declarations : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Session_Decl => 3);

      Member_Name_For_Session_Decl_F_Declarations : aliased constant Text_Type :=
        "F_Declarations";
      Member_Desc_For_Session_Decl_F_Declarations : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Session_Decl_F_Declarations'Access,
         Owner         => Type_Index_For_Session_Decl,
         Member_Type   => Type_Index_For_Local_Decl_List,
         Null_For      => null,
         Indexes       => Indexes_For_Session_Decl_F_Declarations'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Session_Decl_F_States : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Session_Decl => 4);

      Member_Name_For_Session_Decl_F_States : aliased constant Text_Type :=
        "F_States";
      Member_Desc_For_Session_Decl_F_States : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Session_Decl_F_States'Access,
         Owner         => Type_Index_For_Session_Decl,
         Member_Type   => Type_Index_For_State_List,
         Null_For      => null,
         Indexes       => Indexes_For_Session_Decl_F_States'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Session_Decl_F_End_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Session_Decl => 5);

      Member_Name_For_Session_Decl_F_End_Identifier : aliased constant Text_Type :=
        "F_End_Identifier";
      Member_Desc_For_Session_Decl_F_End_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Session_Decl_F_End_Identifier'Access,
         Owner         => Type_Index_For_Session_Decl,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Session_Decl_F_End_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Type_Decl_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Type_Decl => 1);

      Member_Name_For_Type_Decl_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Type_Decl_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Decl_F_Identifier'Access,
         Owner         => Type_Index_For_Type_Decl,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Type_Decl_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Type_Decl_F_Parameters : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Type_Decl => 2);

      Member_Name_For_Type_Decl_F_Parameters : aliased constant Text_Type :=
        "F_Parameters";
      Member_Desc_For_Type_Decl_F_Parameters : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Decl_F_Parameters'Access,
         Owner         => Type_Index_For_Type_Decl,
         Member_Type   => Type_Index_For_Parameters,
         Null_For      => null,
         Indexes       => Indexes_For_Type_Decl_F_Parameters'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Type_Decl_F_Definition : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Type_Decl => 3);

      Member_Name_For_Type_Decl_F_Definition : aliased constant Text_Type :=
        "F_Definition";
      Member_Desc_For_Type_Decl_F_Definition : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Decl_F_Definition'Access,
         Owner         => Type_Index_For_Type_Decl,
         Member_Type   => Type_Index_For_Type_Def,
         Null_For      => null,
         Indexes       => Indexes_For_Type_Decl_F_Definition'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Description_F_Content : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Description => 1);

      Member_Name_For_Description_F_Content : aliased constant Text_Type :=
        "F_Content";
      Member_Desc_For_Description_F_Content : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Description_F_Content'Access,
         Owner         => Type_Index_For_Description,
         Member_Type   => Type_Index_For_String_Literal,
         Null_For      => null,
         Indexes       => Indexes_For_Description_F_Content'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Element_Value_Assoc_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Element_Value_Assoc => 1);

      Member_Name_For_Element_Value_Assoc_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Element_Value_Assoc_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Element_Value_Assoc_F_Identifier'Access,
         Owner         => Type_Index_For_Element_Value_Assoc,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Element_Value_Assoc_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Element_Value_Assoc_F_Literal : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Element_Value_Assoc => 2);

      Member_Name_For_Element_Value_Assoc_F_Literal : aliased constant Text_Type :=
        "F_Literal";
      Member_Desc_For_Element_Value_Assoc_F_Literal : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Element_Value_Assoc_F_Literal'Access,
         Owner         => Type_Index_For_Element_Value_Assoc,
         Member_Type   => Type_Index_For_Numeric_Literal,
         Null_For      => null,
         Indexes       => Indexes_For_Element_Value_Assoc_F_Literal'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Attribute_F_Expression : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Attribute => 1);

      Member_Name_For_Attribute_F_Expression : aliased constant Text_Type :=
        "F_Expression";
      Member_Desc_For_Attribute_F_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Attribute_F_Expression'Access,
         Owner         => Type_Index_For_Attribute,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Attribute_F_Expression'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Attribute_F_Kind : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Attribute => 2);

      Member_Name_For_Attribute_F_Kind : aliased constant Text_Type :=
        "F_Kind";
      Member_Desc_For_Attribute_F_Kind : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Attribute_F_Kind'Access,
         Owner         => Type_Index_For_Attribute,
         Member_Type   => Type_Index_For_Attr,
         Null_For      => null,
         Indexes       => Indexes_For_Attribute_F_Kind'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Bin_Op_F_Left : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Bin_Op => 1);

      Member_Name_For_Bin_Op_F_Left : aliased constant Text_Type :=
        "F_Left";
      Member_Desc_For_Bin_Op_F_Left : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Bin_Op_F_Left'Access,
         Owner         => Type_Index_For_Bin_Op,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Bin_Op_F_Left'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Bin_Op_F_Op : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Bin_Op => 2);

      Member_Name_For_Bin_Op_F_Op : aliased constant Text_Type :=
        "F_Op";
      Member_Desc_For_Bin_Op_F_Op : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Bin_Op_F_Op'Access,
         Owner         => Type_Index_For_Bin_Op,
         Member_Type   => Type_Index_For_Op,
         Null_For      => null,
         Indexes       => Indexes_For_Bin_Op_F_Op'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Bin_Op_F_Right : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Bin_Op => 3);

      Member_Name_For_Bin_Op_F_Right : aliased constant Text_Type :=
        "F_Right";
      Member_Desc_For_Bin_Op_F_Right : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Bin_Op_F_Right'Access,
         Owner         => Type_Index_For_Bin_Op,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Bin_Op_F_Right'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Binding_F_Expression : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Binding => 1);

      Member_Name_For_Binding_F_Expression : aliased constant Text_Type :=
        "F_Expression";
      Member_Desc_For_Binding_F_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Binding_F_Expression'Access,
         Owner         => Type_Index_For_Binding,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Binding_F_Expression'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Binding_F_Bindings : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Binding => 2);

      Member_Name_For_Binding_F_Bindings : aliased constant Text_Type :=
        "F_Bindings";
      Member_Desc_For_Binding_F_Bindings : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Binding_F_Bindings'Access,
         Owner         => Type_Index_For_Binding,
         Member_Type   => Type_Index_For_Term_Assoc_List,
         Null_For      => null,
         Indexes       => Indexes_For_Binding_F_Bindings'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Call_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Call => 1);

      Member_Name_For_Call_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Call_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Call_F_Identifier'Access,
         Owner         => Type_Index_For_Call,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Call_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Call_F_Arguments : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Call => 2);

      Member_Name_For_Call_F_Arguments : aliased constant Text_Type :=
        "F_Arguments";
      Member_Desc_For_Call_F_Arguments : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Call_F_Arguments'Access,
         Owner         => Type_Index_For_Call,
         Member_Type   => Type_Index_For_Expr_List,
         Null_For      => null,
         Indexes       => Indexes_For_Call_F_Arguments'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Case_Expression_F_Expression : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Case_Expression => 1);

      Member_Name_For_Case_Expression_F_Expression : aliased constant Text_Type :=
        "F_Expression";
      Member_Desc_For_Case_Expression_F_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Case_Expression_F_Expression'Access,
         Owner         => Type_Index_For_Case_Expression,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Case_Expression_F_Expression'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Case_Expression_F_Choices : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Case_Expression => 2);

      Member_Name_For_Case_Expression_F_Choices : aliased constant Text_Type :=
        "F_Choices";
      Member_Desc_For_Case_Expression_F_Choices : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Case_Expression_F_Choices'Access,
         Owner         => Type_Index_For_Case_Expression,
         Member_Type   => Type_Index_For_Choice_List,
         Null_For      => null,
         Indexes       => Indexes_For_Case_Expression_F_Choices'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Choice_F_Selectors : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Choice => 1);

      Member_Name_For_Choice_F_Selectors : aliased constant Text_Type :=
        "F_Selectors";
      Member_Desc_For_Choice_F_Selectors : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Choice_F_Selectors'Access,
         Owner         => Type_Index_For_Choice,
         Member_Type   => Type_Index_For_R_F_L_X_Node_List,
         Null_For      => null,
         Indexes       => Indexes_For_Choice_F_Selectors'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Choice_F_Expression : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Choice => 2);

      Member_Name_For_Choice_F_Expression : aliased constant Text_Type :=
        "F_Expression";
      Member_Desc_For_Choice_F_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Choice_F_Expression'Access,
         Owner         => Type_Index_For_Choice,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Choice_F_Expression'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Comprehension_F_Iterator : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Comprehension => 1);

      Member_Name_For_Comprehension_F_Iterator : aliased constant Text_Type :=
        "F_Iterator";
      Member_Desc_For_Comprehension_F_Iterator : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Comprehension_F_Iterator'Access,
         Owner         => Type_Index_For_Comprehension,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Comprehension_F_Iterator'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Comprehension_F_Sequence : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Comprehension => 2);

      Member_Name_For_Comprehension_F_Sequence : aliased constant Text_Type :=
        "F_Sequence";
      Member_Desc_For_Comprehension_F_Sequence : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Comprehension_F_Sequence'Access,
         Owner         => Type_Index_For_Comprehension,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Comprehension_F_Sequence'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Comprehension_F_Condition : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Comprehension => 3);

      Member_Name_For_Comprehension_F_Condition : aliased constant Text_Type :=
        "F_Condition";
      Member_Desc_For_Comprehension_F_Condition : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Comprehension_F_Condition'Access,
         Owner         => Type_Index_For_Comprehension,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Comprehension_F_Condition'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Comprehension_F_Selector : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Comprehension => 4);

      Member_Name_For_Comprehension_F_Selector : aliased constant Text_Type :=
        "F_Selector";
      Member_Desc_For_Comprehension_F_Selector : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Comprehension_F_Selector'Access,
         Owner         => Type_Index_For_Comprehension,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Comprehension_F_Selector'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Context_Item_F_Item : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Context_Item => 1);

      Member_Name_For_Context_Item_F_Item : aliased constant Text_Type :=
        "F_Item";
      Member_Desc_For_Context_Item_F_Item : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Context_Item_F_Item'Access,
         Owner         => Type_Index_For_Context_Item,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Context_Item_F_Item'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Conversion_F_Target_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Conversion => 1);

      Member_Name_For_Conversion_F_Target_Identifier : aliased constant Text_Type :=
        "F_Target_Identifier";
      Member_Desc_For_Conversion_F_Target_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Conversion_F_Target_Identifier'Access,
         Owner         => Type_Index_For_Conversion,
         Member_Type   => Type_Index_For_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Conversion_F_Target_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Conversion_F_Argument : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Conversion => 2);

      Member_Name_For_Conversion_F_Argument : aliased constant Text_Type :=
        "F_Argument";
      Member_Desc_For_Conversion_F_Argument : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Conversion_F_Argument'Access,
         Owner         => Type_Index_For_Conversion,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Conversion_F_Argument'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Aggregate_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Aggregate => 1);

      Member_Name_For_Message_Aggregate_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Message_Aggregate_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Aggregate_F_Identifier'Access,
         Owner         => Type_Index_For_Message_Aggregate,
         Member_Type   => Type_Index_For_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Aggregate_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Aggregate_F_Values : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Aggregate => 2);

      Member_Name_For_Message_Aggregate_F_Values : aliased constant Text_Type :=
        "F_Values";
      Member_Desc_For_Message_Aggregate_F_Values : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Aggregate_F_Values'Access,
         Owner         => Type_Index_For_Message_Aggregate,
         Member_Type   => Type_Index_For_Base_Aggregate,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Aggregate_F_Values'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Negation_F_Data : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Negation => 1);

      Member_Name_For_Negation_F_Data : aliased constant Text_Type :=
        "F_Data";
      Member_Desc_For_Negation_F_Data : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Negation_F_Data'Access,
         Owner         => Type_Index_For_Negation,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Negation_F_Data'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Paren_Expression_F_Data : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Paren_Expression => 1);

      Member_Name_For_Paren_Expression_F_Data : aliased constant Text_Type :=
        "F_Data";
      Member_Desc_For_Paren_Expression_F_Data : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Paren_Expression_F_Data'Access,
         Owner         => Type_Index_For_Paren_Expression,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Paren_Expression_F_Data'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Quantified_Expression_F_Operation : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Quantified_Expression => 1);

      Member_Name_For_Quantified_Expression_F_Operation : aliased constant Text_Type :=
        "F_Operation";
      Member_Desc_For_Quantified_Expression_F_Operation : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Quantified_Expression_F_Operation'Access,
         Owner         => Type_Index_For_Quantified_Expression,
         Member_Type   => Type_Index_For_Quantifier,
         Null_For      => null,
         Indexes       => Indexes_For_Quantified_Expression_F_Operation'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Quantified_Expression_F_Parameter_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Quantified_Expression => 2);

      Member_Name_For_Quantified_Expression_F_Parameter_Identifier : aliased constant Text_Type :=
        "F_Parameter_Identifier";
      Member_Desc_For_Quantified_Expression_F_Parameter_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Quantified_Expression_F_Parameter_Identifier'Access,
         Owner         => Type_Index_For_Quantified_Expression,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Quantified_Expression_F_Parameter_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Quantified_Expression_F_Iterable : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Quantified_Expression => 3);

      Member_Name_For_Quantified_Expression_F_Iterable : aliased constant Text_Type :=
        "F_Iterable";
      Member_Desc_For_Quantified_Expression_F_Iterable : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Quantified_Expression_F_Iterable'Access,
         Owner         => Type_Index_For_Quantified_Expression,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Quantified_Expression_F_Iterable'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Quantified_Expression_F_Predicate : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Quantified_Expression => 4);

      Member_Name_For_Quantified_Expression_F_Predicate : aliased constant Text_Type :=
        "F_Predicate";
      Member_Desc_For_Quantified_Expression_F_Predicate : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Quantified_Expression_F_Predicate'Access,
         Owner         => Type_Index_For_Quantified_Expression,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Quantified_Expression_F_Predicate'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Select_Node_F_Expression : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Select => 1);

      Member_Name_For_Select_Node_F_Expression : aliased constant Text_Type :=
        "F_Expression";
      Member_Desc_For_Select_Node_F_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Select_Node_F_Expression'Access,
         Owner         => Type_Index_For_Select,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Select_Node_F_Expression'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Select_Node_F_Selector : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Select => 2);

      Member_Name_For_Select_Node_F_Selector : aliased constant Text_Type :=
        "F_Selector";
      Member_Desc_For_Select_Node_F_Selector : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Select_Node_F_Selector'Access,
         Owner         => Type_Index_For_Select,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Select_Node_F_Selector'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Concatenation_F_Left : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Concatenation => 1);

      Member_Name_For_Concatenation_F_Left : aliased constant Text_Type :=
        "F_Left";
      Member_Desc_For_Concatenation_F_Left : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Concatenation_F_Left'Access,
         Owner         => Type_Index_For_Concatenation,
         Member_Type   => Type_Index_For_Sequence_Literal,
         Null_For      => null,
         Indexes       => Indexes_For_Concatenation_F_Left'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Concatenation_F_Right : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Concatenation => 2);

      Member_Name_For_Concatenation_F_Right : aliased constant Text_Type :=
        "F_Right";
      Member_Desc_For_Concatenation_F_Right : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Concatenation_F_Right'Access,
         Owner         => Type_Index_For_Concatenation,
         Member_Type   => Type_Index_For_Sequence_Literal,
         Null_For      => null,
         Indexes       => Indexes_For_Concatenation_F_Right'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Sequence_Aggregate_F_Values : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Sequence_Aggregate => 1);

      Member_Name_For_Sequence_Aggregate_F_Values : aliased constant Text_Type :=
        "F_Values";
      Member_Desc_For_Sequence_Aggregate_F_Values : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Sequence_Aggregate_F_Values'Access,
         Owner         => Type_Index_For_Sequence_Aggregate,
         Member_Type   => Type_Index_For_Numeric_Literal_List,
         Null_For      => null,
         Indexes       => Indexes_For_Sequence_Aggregate_F_Values'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Variable_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Variable => 1);

      Member_Name_For_Variable_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Variable_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Variable_F_Identifier'Access,
         Owner         => Type_Index_For_Variable,
         Member_Type   => Type_Index_For_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Variable_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Formal_Channel_Decl_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Formal_Channel_Decl => 1);

      Member_Name_For_Formal_Channel_Decl_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Formal_Channel_Decl_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Formal_Channel_Decl_F_Identifier'Access,
         Owner         => Type_Index_For_Formal_Channel_Decl,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Formal_Channel_Decl_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Formal_Channel_Decl_F_Parameters : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Formal_Channel_Decl => 2);

      Member_Name_For_Formal_Channel_Decl_F_Parameters : aliased constant Text_Type :=
        "F_Parameters";
      Member_Desc_For_Formal_Channel_Decl_F_Parameters : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Formal_Channel_Decl_F_Parameters'Access,
         Owner         => Type_Index_For_Formal_Channel_Decl,
         Member_Type   => Type_Index_For_Channel_Attribute_List,
         Null_For      => null,
         Indexes       => Indexes_For_Formal_Channel_Decl_F_Parameters'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Formal_Function_Decl_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Formal_Function_Decl => 1);

      Member_Name_For_Formal_Function_Decl_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Formal_Function_Decl_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Formal_Function_Decl_F_Identifier'Access,
         Owner         => Type_Index_For_Formal_Function_Decl,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Formal_Function_Decl_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Formal_Function_Decl_F_Parameters : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Formal_Function_Decl => 2);

      Member_Name_For_Formal_Function_Decl_F_Parameters : aliased constant Text_Type :=
        "F_Parameters";
      Member_Desc_For_Formal_Function_Decl_F_Parameters : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Formal_Function_Decl_F_Parameters'Access,
         Owner         => Type_Index_For_Formal_Function_Decl,
         Member_Type   => Type_Index_For_Parameters,
         Null_For      => null,
         Indexes       => Indexes_For_Formal_Function_Decl_F_Parameters'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Formal_Function_Decl_F_Return_Type_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Formal_Function_Decl => 3);

      Member_Name_For_Formal_Function_Decl_F_Return_Type_Identifier : aliased constant Text_Type :=
        "F_Return_Type_Identifier";
      Member_Desc_For_Formal_Function_Decl_F_Return_Type_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Formal_Function_Decl_F_Return_Type_Identifier'Access,
         Owner         => Type_Index_For_Formal_Function_Decl,
         Member_Type   => Type_Index_For_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Formal_Function_Decl_F_Return_Type_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Renaming_Decl_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Renaming_Decl => 1);

      Member_Name_For_Renaming_Decl_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Renaming_Decl_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Renaming_Decl_F_Identifier'Access,
         Owner         => Type_Index_For_Renaming_Decl,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Renaming_Decl_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Renaming_Decl_F_Type_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Renaming_Decl => 2);

      Member_Name_For_Renaming_Decl_F_Type_Identifier : aliased constant Text_Type :=
        "F_Type_Identifier";
      Member_Desc_For_Renaming_Decl_F_Type_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Renaming_Decl_F_Type_Identifier'Access,
         Owner         => Type_Index_For_Renaming_Decl,
         Member_Type   => Type_Index_For_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Renaming_Decl_F_Type_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Renaming_Decl_F_Expression : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Renaming_Decl => 3);

      Member_Name_For_Renaming_Decl_F_Expression : aliased constant Text_Type :=
        "F_Expression";
      Member_Desc_For_Renaming_Decl_F_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Renaming_Decl_F_Expression'Access,
         Owner         => Type_Index_For_Renaming_Decl,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Renaming_Decl_F_Expression'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Variable_Decl_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Variable_Decl => 1);

      Member_Name_For_Variable_Decl_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Variable_Decl_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Variable_Decl_F_Identifier'Access,
         Owner         => Type_Index_For_Variable_Decl,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Variable_Decl_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Variable_Decl_F_Type_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Variable_Decl => 2);

      Member_Name_For_Variable_Decl_F_Type_Identifier : aliased constant Text_Type :=
        "F_Type_Identifier";
      Member_Desc_For_Variable_Decl_F_Type_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Variable_Decl_F_Type_Identifier'Access,
         Owner         => Type_Index_For_Variable_Decl,
         Member_Type   => Type_Index_For_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Variable_Decl_F_Type_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Variable_Decl_F_Initializer : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Variable_Decl => 3);

      Member_Name_For_Variable_Decl_F_Initializer : aliased constant Text_Type :=
        "F_Initializer";
      Member_Desc_For_Variable_Decl_F_Initializer : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Variable_Decl_F_Initializer'Access,
         Owner         => Type_Index_For_Variable_Decl,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Variable_Decl_F_Initializer'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Aggregate_Association_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Aggregate_Association => 1);

      Member_Name_For_Message_Aggregate_Association_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Message_Aggregate_Association_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Aggregate_Association_F_Identifier'Access,
         Owner         => Type_Index_For_Message_Aggregate_Association,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Aggregate_Association_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Aggregate_Association_F_Expression : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Aggregate_Association => 2);

      Member_Name_For_Message_Aggregate_Association_F_Expression : aliased constant Text_Type :=
        "F_Expression";
      Member_Desc_For_Message_Aggregate_Association_F_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Aggregate_Association_F_Expression'Access,
         Owner         => Type_Index_For_Message_Aggregate_Association,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Aggregate_Association_F_Expression'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Byte_Order_Aspect_F_Byte_Order : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Byte_Order_Aspect => 1);

      Member_Name_For_Byte_Order_Aspect_F_Byte_Order : aliased constant Text_Type :=
        "F_Byte_Order";
      Member_Desc_For_Byte_Order_Aspect_F_Byte_Order : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Byte_Order_Aspect_F_Byte_Order'Access,
         Owner         => Type_Index_For_Byte_Order_Aspect,
         Member_Type   => Type_Index_For_Byte_Order_Type,
         Null_For      => null,
         Indexes       => Indexes_For_Byte_Order_Aspect_F_Byte_Order'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Checksum_Aspect_F_Associations : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Checksum_Aspect => 1);

      Member_Name_For_Checksum_Aspect_F_Associations : aliased constant Text_Type :=
        "F_Associations";
      Member_Desc_For_Checksum_Aspect_F_Associations : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Checksum_Aspect_F_Associations'Access,
         Owner         => Type_Index_For_Checksum_Aspect,
         Member_Type   => Type_Index_For_Checksum_Assoc_List,
         Null_For      => null,
         Indexes       => Indexes_For_Checksum_Aspect_F_Associations'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Field_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Field => 1);

      Member_Name_For_Message_Field_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Message_Field_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Field_F_Identifier'Access,
         Owner         => Type_Index_For_Message_Field,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Field_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Field_F_Type_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Field => 2);

      Member_Name_For_Message_Field_F_Type_Identifier : aliased constant Text_Type :=
        "F_Type_Identifier";
      Member_Desc_For_Message_Field_F_Type_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Field_F_Type_Identifier'Access,
         Owner         => Type_Index_For_Message_Field,
         Member_Type   => Type_Index_For_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Field_F_Type_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Field_F_Type_Arguments : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Field => 3);

      Member_Name_For_Message_Field_F_Type_Arguments : aliased constant Text_Type :=
        "F_Type_Arguments";
      Member_Desc_For_Message_Field_F_Type_Arguments : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Field_F_Type_Arguments'Access,
         Owner         => Type_Index_For_Message_Field,
         Member_Type   => Type_Index_For_Type_Argument_List,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Field_F_Type_Arguments'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Field_F_Aspects : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Field => 4);

      Member_Name_For_Message_Field_F_Aspects : aliased constant Text_Type :=
        "F_Aspects";
      Member_Desc_For_Message_Field_F_Aspects : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Field_F_Aspects'Access,
         Owner         => Type_Index_For_Message_Field,
         Member_Type   => Type_Index_For_Aspect_List,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Field_F_Aspects'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Field_F_Condition : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Field => 5);

      Member_Name_For_Message_Field_F_Condition : aliased constant Text_Type :=
        "F_Condition";
      Member_Desc_For_Message_Field_F_Condition : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Field_F_Condition'Access,
         Owner         => Type_Index_For_Message_Field,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Field_F_Condition'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Field_F_Thens : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Field => 6);

      Member_Name_For_Message_Field_F_Thens : aliased constant Text_Type :=
        "F_Thens";
      Member_Desc_For_Message_Field_F_Thens : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Field_F_Thens'Access,
         Owner         => Type_Index_For_Message_Field,
         Member_Type   => Type_Index_For_Then_Node_List,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Field_F_Thens'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Fields_F_Initial_Field : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Fields => 1);

      Member_Name_For_Message_Fields_F_Initial_Field : aliased constant Text_Type :=
        "F_Initial_Field";
      Member_Desc_For_Message_Fields_F_Initial_Field : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Fields_F_Initial_Field'Access,
         Owner         => Type_Index_For_Message_Fields,
         Member_Type   => Type_Index_For_Null_Message_Field,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Fields_F_Initial_Field'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Fields_F_Fields : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Fields => 2);

      Member_Name_For_Message_Fields_F_Fields : aliased constant Text_Type :=
        "F_Fields";
      Member_Desc_For_Message_Fields_F_Fields : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Fields_F_Fields'Access,
         Owner         => Type_Index_For_Message_Fields,
         Member_Type   => Type_Index_For_Message_Field_List,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Fields_F_Fields'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Null_Message_Field_F_Then : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Null_Message_Field => 1);

      Member_Name_For_Null_Message_Field_F_Then : aliased constant Text_Type :=
        "F_Then";
      Member_Desc_For_Null_Message_Field_F_Then : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Null_Message_Field_F_Then'Access,
         Owner         => Type_Index_For_Null_Message_Field,
         Member_Type   => Type_Index_For_Then,
         Null_For      => null,
         Indexes       => Indexes_For_Null_Message_Field_F_Then'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Package_Node_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Package => 1);

      Member_Name_For_Package_Node_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Package_Node_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Package_Node_F_Identifier'Access,
         Owner         => Type_Index_For_Package,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Package_Node_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Package_Node_F_Declarations : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Package => 2);

      Member_Name_For_Package_Node_F_Declarations : aliased constant Text_Type :=
        "F_Declarations";
      Member_Desc_For_Package_Node_F_Declarations : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Package_Node_F_Declarations'Access,
         Owner         => Type_Index_For_Package,
         Member_Type   => Type_Index_For_Declaration_List,
         Null_For      => null,
         Indexes       => Indexes_For_Package_Node_F_Declarations'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Package_Node_F_End_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Package => 3);

      Member_Name_For_Package_Node_F_End_Identifier : aliased constant Text_Type :=
        "F_End_Identifier";
      Member_Desc_For_Package_Node_F_End_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Package_Node_F_End_Identifier'Access,
         Owner         => Type_Index_For_Package,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Package_Node_F_End_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Parameter_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Parameter => 1);

      Member_Name_For_Parameter_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Parameter_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Parameter_F_Identifier'Access,
         Owner         => Type_Index_For_Parameter,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Parameter_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Parameter_F_Type_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Parameter => 2);

      Member_Name_For_Parameter_F_Type_Identifier : aliased constant Text_Type :=
        "F_Type_Identifier";
      Member_Desc_For_Parameter_F_Type_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Parameter_F_Type_Identifier'Access,
         Owner         => Type_Index_For_Parameter,
         Member_Type   => Type_Index_For_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Parameter_F_Type_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Parameters_F_Parameters : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Parameters => 1);

      Member_Name_For_Parameters_F_Parameters : aliased constant Text_Type :=
        "F_Parameters";
      Member_Desc_For_Parameters_F_Parameters : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Parameters_F_Parameters'Access,
         Owner         => Type_Index_For_Parameters,
         Member_Type   => Type_Index_For_Parameter_List,
         Null_For      => null,
         Indexes       => Indexes_For_Parameters_F_Parameters'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Specification_F_Context_Clause : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Specification => 1);

      Member_Name_For_Specification_F_Context_Clause : aliased constant Text_Type :=
        "F_Context_Clause";
      Member_Desc_For_Specification_F_Context_Clause : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Specification_F_Context_Clause'Access,
         Owner         => Type_Index_For_Specification,
         Member_Type   => Type_Index_For_Context_Item_List,
         Null_For      => null,
         Indexes       => Indexes_For_Specification_F_Context_Clause'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Specification_F_Package_Declaration : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Specification => 2);

      Member_Name_For_Specification_F_Package_Declaration : aliased constant Text_Type :=
        "F_Package_Declaration";
      Member_Desc_For_Specification_F_Package_Declaration : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Specification_F_Package_Declaration'Access,
         Owner         => Type_Index_For_Specification,
         Member_Type   => Type_Index_For_Package,
         Null_For      => null,
         Indexes       => Indexes_For_Specification_F_Package_Declaration'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_State_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_State => 1);

      Member_Name_For_State_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_State_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_State_F_Identifier'Access,
         Owner         => Type_Index_For_State,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_State_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_State_F_Description : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_State => 2);

      Member_Name_For_State_F_Description : aliased constant Text_Type :=
        "F_Description";
      Member_Desc_For_State_F_Description : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_State_F_Description'Access,
         Owner         => Type_Index_For_State,
         Member_Type   => Type_Index_For_Description,
         Null_For      => null,
         Indexes       => Indexes_For_State_F_Description'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_State_F_Body : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_State => 3);

      Member_Name_For_State_F_Body : aliased constant Text_Type :=
        "F_Body";
      Member_Desc_For_State_F_Body : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_State_F_Body'Access,
         Owner         => Type_Index_For_State,
         Member_Type   => Type_Index_For_State_Body,
         Null_For      => null,
         Indexes       => Indexes_For_State_F_Body'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_State_Body_F_Declarations : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_State_Body => 1);

      Member_Name_For_State_Body_F_Declarations : aliased constant Text_Type :=
        "F_Declarations";
      Member_Desc_For_State_Body_F_Declarations : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_State_Body_F_Declarations'Access,
         Owner         => Type_Index_For_State_Body,
         Member_Type   => Type_Index_For_Local_Decl_List,
         Null_For      => null,
         Indexes       => Indexes_For_State_Body_F_Declarations'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_State_Body_F_Actions : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_State_Body => 2);

      Member_Name_For_State_Body_F_Actions : aliased constant Text_Type :=
        "F_Actions";
      Member_Desc_For_State_Body_F_Actions : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_State_Body_F_Actions'Access,
         Owner         => Type_Index_For_State_Body,
         Member_Type   => Type_Index_For_Statement_List,
         Null_For      => null,
         Indexes       => Indexes_For_State_Body_F_Actions'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_State_Body_F_Conditional_Transitions : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_State_Body => 3);

      Member_Name_For_State_Body_F_Conditional_Transitions : aliased constant Text_Type :=
        "F_Conditional_Transitions";
      Member_Desc_For_State_Body_F_Conditional_Transitions : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_State_Body_F_Conditional_Transitions'Access,
         Owner         => Type_Index_For_State_Body,
         Member_Type   => Type_Index_For_Conditional_Transition_List,
         Null_For      => null,
         Indexes       => Indexes_For_State_Body_F_Conditional_Transitions'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_State_Body_F_Final_Transition : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_State_Body => 4);

      Member_Name_For_State_Body_F_Final_Transition : aliased constant Text_Type :=
        "F_Final_Transition";
      Member_Desc_For_State_Body_F_Final_Transition : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_State_Body_F_Final_Transition'Access,
         Owner         => Type_Index_For_State_Body,
         Member_Type   => Type_Index_For_Transition,
         Null_For      => null,
         Indexes       => Indexes_For_State_Body_F_Final_Transition'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_State_Body_F_Exception_Transition : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_State_Body => 5);

      Member_Name_For_State_Body_F_Exception_Transition : aliased constant Text_Type :=
        "F_Exception_Transition";
      Member_Desc_For_State_Body_F_Exception_Transition : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_State_Body_F_Exception_Transition'Access,
         Owner         => Type_Index_For_State_Body,
         Member_Type   => Type_Index_For_Transition,
         Null_For      => null,
         Indexes       => Indexes_For_State_Body_F_Exception_Transition'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_State_Body_F_End_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_State_Body => 6);

      Member_Name_For_State_Body_F_End_Identifier : aliased constant Text_Type :=
        "F_End_Identifier";
      Member_Desc_For_State_Body_F_End_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_State_Body_F_End_Identifier'Access,
         Owner         => Type_Index_For_State_Body,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_State_Body_F_End_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Assignment_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Assignment => 1);

      Member_Name_For_Assignment_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Assignment_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Assignment_F_Identifier'Access,
         Owner         => Type_Index_For_Assignment,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Assignment_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Assignment_F_Expression : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Assignment => 2);

      Member_Name_For_Assignment_F_Expression : aliased constant Text_Type :=
        "F_Expression";
      Member_Desc_For_Assignment_F_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Assignment_F_Expression'Access,
         Owner         => Type_Index_For_Assignment,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Assignment_F_Expression'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Attribute_Statement_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Attribute_Statement => 1);

      Member_Name_For_Attribute_Statement_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Attribute_Statement_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Attribute_Statement_F_Identifier'Access,
         Owner         => Type_Index_For_Attribute_Statement,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Attribute_Statement_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Attribute_Statement_F_Attr : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Attribute_Statement => 2);

      Member_Name_For_Attribute_Statement_F_Attr : aliased constant Text_Type :=
        "F_Attr";
      Member_Desc_For_Attribute_Statement_F_Attr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Attribute_Statement_F_Attr'Access,
         Owner         => Type_Index_For_Attribute_Statement,
         Member_Type   => Type_Index_For_Attr_Stmt,
         Null_For      => null,
         Indexes       => Indexes_For_Attribute_Statement_F_Attr'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Attribute_Statement_F_Expression : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Attribute_Statement => 3);

      Member_Name_For_Attribute_Statement_F_Expression : aliased constant Text_Type :=
        "F_Expression";
      Member_Desc_For_Attribute_Statement_F_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Attribute_Statement_F_Expression'Access,
         Owner         => Type_Index_For_Attribute_Statement,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Attribute_Statement_F_Expression'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Field_Assignment_F_Message : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Field_Assignment => 1);

      Member_Name_For_Message_Field_Assignment_F_Message : aliased constant Text_Type :=
        "F_Message";
      Member_Desc_For_Message_Field_Assignment_F_Message : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Field_Assignment_F_Message'Access,
         Owner         => Type_Index_For_Message_Field_Assignment,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Field_Assignment_F_Message'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Field_Assignment_F_Field : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Field_Assignment => 2);

      Member_Name_For_Message_Field_Assignment_F_Field : aliased constant Text_Type :=
        "F_Field";
      Member_Desc_For_Message_Field_Assignment_F_Field : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Field_Assignment_F_Field'Access,
         Owner         => Type_Index_For_Message_Field_Assignment,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Field_Assignment_F_Field'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Field_Assignment_F_Expression : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Field_Assignment => 3);

      Member_Name_For_Message_Field_Assignment_F_Expression : aliased constant Text_Type :=
        "F_Expression";
      Member_Desc_For_Message_Field_Assignment_F_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Field_Assignment_F_Expression'Access,
         Owner         => Type_Index_For_Message_Field_Assignment,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Field_Assignment_F_Expression'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Reset_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Reset => 1);

      Member_Name_For_Reset_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Reset_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Reset_F_Identifier'Access,
         Owner         => Type_Index_For_Reset,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Reset_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Reset_F_Associations : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Reset => 2);

      Member_Name_For_Reset_F_Associations : aliased constant Text_Type :=
        "F_Associations";
      Member_Desc_For_Reset_F_Associations : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Reset_F_Associations'Access,
         Owner         => Type_Index_For_Reset,
         Member_Type   => Type_Index_For_Message_Aggregate_Association_List,
         Null_For      => null,
         Indexes       => Indexes_For_Reset_F_Associations'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Term_Assoc_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Term_Assoc => 1);

      Member_Name_For_Term_Assoc_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Term_Assoc_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Term_Assoc_F_Identifier'Access,
         Owner         => Type_Index_For_Term_Assoc,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Term_Assoc_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Term_Assoc_F_Expression : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Term_Assoc => 2);

      Member_Name_For_Term_Assoc_F_Expression : aliased constant Text_Type :=
        "F_Expression";
      Member_Desc_For_Term_Assoc_F_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Term_Assoc_F_Expression'Access,
         Owner         => Type_Index_For_Term_Assoc,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Term_Assoc_F_Expression'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Then_Node_F_Target : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Then => 1);

      Member_Name_For_Then_Node_F_Target : aliased constant Text_Type :=
        "F_Target";
      Member_Desc_For_Then_Node_F_Target : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Then_Node_F_Target'Access,
         Owner         => Type_Index_For_Then,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Then_Node_F_Target'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Then_Node_F_Aspects : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Then => 2);

      Member_Name_For_Then_Node_F_Aspects : aliased constant Text_Type :=
        "F_Aspects";
      Member_Desc_For_Then_Node_F_Aspects : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Then_Node_F_Aspects'Access,
         Owner         => Type_Index_For_Then,
         Member_Type   => Type_Index_For_Aspect_List,
         Null_For      => null,
         Indexes       => Indexes_For_Then_Node_F_Aspects'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Then_Node_F_Condition : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Then => 3);

      Member_Name_For_Then_Node_F_Condition : aliased constant Text_Type :=
        "F_Condition";
      Member_Desc_For_Then_Node_F_Condition : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Then_Node_F_Condition'Access,
         Owner         => Type_Index_For_Then,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Then_Node_F_Condition'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Transition_F_Target : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Transition => 1,
Type_Index_For_Conditional_Transition => 1);

      Member_Name_For_Transition_F_Target : aliased constant Text_Type :=
        "F_Target";
      Member_Desc_For_Transition_F_Target : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Transition_F_Target'Access,
         Owner         => Type_Index_For_Transition,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Transition_F_Target'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Transition_F_Description : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Transition => 2,
Type_Index_For_Conditional_Transition => 2);

      Member_Name_For_Transition_F_Description : aliased constant Text_Type :=
        "F_Description";
      Member_Desc_For_Transition_F_Description : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Transition_F_Description'Access,
         Owner         => Type_Index_For_Transition,
         Member_Type   => Type_Index_For_Description,
         Null_For      => null,
         Indexes       => Indexes_For_Transition_F_Description'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Conditional_Transition_F_Condition : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Conditional_Transition => 3);

      Member_Name_For_Conditional_Transition_F_Condition : aliased constant Text_Type :=
        "F_Condition";
      Member_Desc_For_Conditional_Transition_F_Condition : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Conditional_Transition_F_Condition'Access,
         Owner         => Type_Index_For_Conditional_Transition,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Conditional_Transition_F_Condition'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Type_Argument_F_Identifier : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Type_Argument => 1);

      Member_Name_For_Type_Argument_F_Identifier : aliased constant Text_Type :=
        "F_Identifier";
      Member_Desc_For_Type_Argument_F_Identifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Argument_F_Identifier'Access,
         Owner         => Type_Index_For_Type_Argument,
         Member_Type   => Type_Index_For_Unqualified_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Type_Argument_F_Identifier'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Type_Argument_F_Expression : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Type_Argument => 2);

      Member_Name_For_Type_Argument_F_Expression : aliased constant Text_Type :=
        "F_Expression";
      Member_Desc_For_Type_Argument_F_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Argument_F_Expression'Access,
         Owner         => Type_Index_For_Type_Argument,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Type_Argument_F_Expression'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Type_Def_F_Message_Fields : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Type_Def => 1);

      Member_Name_For_Message_Type_Def_F_Message_Fields : aliased constant Text_Type :=
        "F_Message_Fields";
      Member_Desc_For_Message_Type_Def_F_Message_Fields : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Type_Def_F_Message_Fields'Access,
         Owner         => Type_Index_For_Message_Type_Def,
         Member_Type   => Type_Index_For_Message_Fields,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Type_Def_F_Message_Fields'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Message_Type_Def_F_Aspects : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Message_Type_Def => 2);

      Member_Name_For_Message_Type_Def_F_Aspects : aliased constant Text_Type :=
        "F_Aspects";
      Member_Desc_For_Message_Type_Def_F_Aspects : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Message_Type_Def_F_Aspects'Access,
         Owner         => Type_Index_For_Message_Type_Def,
         Member_Type   => Type_Index_For_Message_Aspect_List,
         Null_For      => null,
         Indexes       => Indexes_For_Message_Type_Def_F_Aspects'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Named_Enumeration_Def_F_Elements : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Named_Enumeration_Def => 1);

      Member_Name_For_Named_Enumeration_Def_F_Elements : aliased constant Text_Type :=
        "F_Elements";
      Member_Desc_For_Named_Enumeration_Def_F_Elements : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Named_Enumeration_Def_F_Elements'Access,
         Owner         => Type_Index_For_Named_Enumeration_Def,
         Member_Type   => Type_Index_For_Element_Value_Assoc_List,
         Null_For      => null,
         Indexes       => Indexes_For_Named_Enumeration_Def_F_Elements'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Positional_Enumeration_Def_F_Elements : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Positional_Enumeration_Def => 1);

      Member_Name_For_Positional_Enumeration_Def_F_Elements : aliased constant Text_Type :=
        "F_Elements";
      Member_Desc_For_Positional_Enumeration_Def_F_Elements : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Positional_Enumeration_Def_F_Elements'Access,
         Owner         => Type_Index_For_Positional_Enumeration_Def,
         Member_Type   => Type_Index_For_Unqualified_I_D_List,
         Null_For      => null,
         Indexes       => Indexes_For_Positional_Enumeration_Def_F_Elements'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Enumeration_Type_Def_F_Elements : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Enumeration_Type_Def => 1);

      Member_Name_For_Enumeration_Type_Def_F_Elements : aliased constant Text_Type :=
        "F_Elements";
      Member_Desc_For_Enumeration_Type_Def_F_Elements : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Enumeration_Type_Def_F_Elements'Access,
         Owner         => Type_Index_For_Enumeration_Type_Def,
         Member_Type   => Type_Index_For_Enumeration_Def,
         Null_For      => null,
         Indexes       => Indexes_For_Enumeration_Type_Def_F_Elements'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Enumeration_Type_Def_F_Aspects : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Enumeration_Type_Def => 2);

      Member_Name_For_Enumeration_Type_Def_F_Aspects : aliased constant Text_Type :=
        "F_Aspects";
      Member_Desc_For_Enumeration_Type_Def_F_Aspects : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Enumeration_Type_Def_F_Aspects'Access,
         Owner         => Type_Index_For_Enumeration_Type_Def,
         Member_Type   => Type_Index_For_Aspect_List,
         Null_For      => null,
         Indexes       => Indexes_For_Enumeration_Type_Def_F_Aspects'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Modular_Type_Def_F_Mod : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Modular_Type_Def => 1);

      Member_Name_For_Modular_Type_Def_F_Mod : aliased constant Text_Type :=
        "F_Mod";
      Member_Desc_For_Modular_Type_Def_F_Mod : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Modular_Type_Def_F_Mod'Access,
         Owner         => Type_Index_For_Modular_Type_Def,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Modular_Type_Def_F_Mod'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Range_Type_Def_F_First : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Range_Type_Def => 1);

      Member_Name_For_Range_Type_Def_F_First : aliased constant Text_Type :=
        "F_First";
      Member_Desc_For_Range_Type_Def_F_First : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Range_Type_Def_F_First'Access,
         Owner         => Type_Index_For_Range_Type_Def,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Range_Type_Def_F_First'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Range_Type_Def_F_Last : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Range_Type_Def => 2);

      Member_Name_For_Range_Type_Def_F_Last : aliased constant Text_Type :=
        "F_Last";
      Member_Desc_For_Range_Type_Def_F_Last : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Range_Type_Def_F_Last'Access,
         Owner         => Type_Index_For_Range_Type_Def,
         Member_Type   => Type_Index_For_Expr,
         Null_For      => null,
         Indexes       => Indexes_For_Range_Type_Def_F_Last'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Range_Type_Def_F_Size : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Range_Type_Def => 3);

      Member_Name_For_Range_Type_Def_F_Size : aliased constant Text_Type :=
        "F_Size";
      Member_Desc_For_Range_Type_Def_F_Size : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Range_Type_Def_F_Size'Access,
         Owner         => Type_Index_For_Range_Type_Def,
         Member_Type   => Type_Index_For_Aspect,
         Null_For      => null,
         Indexes       => Indexes_For_Range_Type_Def_F_Size'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Sequence_Type_Def_F_Element_Type : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Sequence_Type_Def => 1);

      Member_Name_For_Sequence_Type_Def_F_Element_Type : aliased constant Text_Type :=
        "F_Element_Type";
      Member_Desc_For_Sequence_Type_Def_F_Element_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Sequence_Type_Def_F_Element_Type'Access,
         Owner         => Type_Index_For_Sequence_Type_Def,
         Member_Type   => Type_Index_For_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Sequence_Type_Def_F_Element_Type'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      
         Indexes_For_Type_Derivation_Def_F_Base : aliased constant Syntax_Field_Indexes :=
           (Type_Index_For_Type_Derivation_Def => 1);

      Member_Name_For_Type_Derivation_Def_F_Base : aliased constant Text_Type :=
        "F_Base";
      Member_Desc_For_Type_Derivation_Def_F_Base : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Derivation_Def_F_Base'Access,
         Owner         => Type_Index_For_Type_Derivation_Def,
         Member_Type   => Type_Index_For_I_D,
         Null_For      => null,
         Indexes       => Indexes_For_Type_Derivation_Def_F_Base'Access,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      

      Member_Name_For_Parent : aliased constant Text_Type :=
        "Parent";
      Member_Desc_For_Parent : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Parent'Access,
         Owner         => Type_Index_For_R_F_L_X_Node,
         Member_Type   => Type_Index_For_R_F_L_X_Node,
         Null_For      => null,
         Indexes       => null,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_1 : aliased constant Text_Type :=
           "With_Self";
         

      

      

      Member_Name_For_Parents : aliased constant Text_Type :=
        "Parents";
      Member_Desc_For_Parents : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Parents'Access,
         Owner         => Type_Index_For_R_F_L_X_Node,
         Member_Type   => Type_Index_For_R_F_L_X_Node_Array,
         Null_For      => null,
         Indexes       => null,
         Arguments     => (
               1 => (Name          => Arg_Name_1'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => True))
        ));

      


      

      

      Member_Name_For_Children : aliased constant Text_Type :=
        "Children";
      Member_Desc_For_Children : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Children'Access,
         Owner         => Type_Index_For_R_F_L_X_Node,
         Member_Type   => Type_Index_For_R_F_L_X_Node_Array,
         Null_For      => null,
         Indexes       => null,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      

      Member_Name_For_Token_Start : aliased constant Text_Type :=
        "Token_Start";
      Member_Desc_For_Token_Start : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Token_Start'Access,
         Owner         => Type_Index_For_R_F_L_X_Node,
         Member_Type   => Type_Index_For_Token,
         Null_For      => null,
         Indexes       => null,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      

      Member_Name_For_Token_End : aliased constant Text_Type :=
        "Token_End";
      Member_Desc_For_Token_End : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Token_End'Access,
         Owner         => Type_Index_For_R_F_L_X_Node,
         Member_Type   => Type_Index_For_Token,
         Null_For      => null,
         Indexes       => null,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      

      Member_Name_For_Child_Index : aliased constant Text_Type :=
        "Child_Index";
      Member_Desc_For_Child_Index : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Child_Index'Access,
         Owner         => Type_Index_For_R_F_L_X_Node,
         Member_Type   => Type_Index_For_Int,
         Null_For      => null,
         Indexes       => null,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      

      Member_Name_For_Previous_Sibling : aliased constant Text_Type :=
        "Previous_Sibling";
      Member_Desc_For_Previous_Sibling : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Previous_Sibling'Access,
         Owner         => Type_Index_For_R_F_L_X_Node,
         Member_Type   => Type_Index_For_R_F_L_X_Node,
         Null_For      => null,
         Indexes       => null,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      

      Member_Name_For_Next_Sibling : aliased constant Text_Type :=
        "Next_Sibling";
      Member_Desc_For_Next_Sibling : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Next_Sibling'Access,
         Owner         => Type_Index_For_R_F_L_X_Node,
         Member_Type   => Type_Index_For_R_F_L_X_Node,
         Null_For      => null,
         Indexes       => null,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      

      Member_Name_For_Unit : aliased constant Text_Type :=
        "Unit";
      Member_Desc_For_Unit : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Unit'Access,
         Owner         => Type_Index_For_R_F_L_X_Node,
         Member_Type   => Type_Index_For_Analysis_Unit,
         Null_For      => null,
         Indexes       => null,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      

      Member_Name_For_Is_Ghost : aliased constant Text_Type :=
        "Is_Ghost";
      Member_Desc_For_Is_Ghost : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Is_Ghost'Access,
         Owner         => Type_Index_For_R_F_L_X_Node,
         Member_Type   => Type_Index_For_Bool,
         Null_For      => null,
         Indexes       => null,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      

      

      Member_Name_For_Full_Sloc_Image : aliased constant Text_Type :=
        "Full_Sloc_Image";
      Member_Desc_For_Full_Sloc_Image : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Full_Sloc_Image'Access,
         Owner         => Type_Index_For_R_F_L_X_Node,
         Member_Type   => Type_Index_For_String,
         Null_For      => null,
         Indexes       => null,
         Arguments     => (
               1 .. 0 => <>
        ));


   Struct_Members : aliased constant Struct_Member_Descriptor_Array := (
      Member_Index_For_I_D_F_Package => Member_Desc_For_I_D_F_Package'Access,
Member_Index_For_I_D_F_Name => Member_Desc_For_I_D_F_Name'Access,
Member_Index_For_Aspect_F_Identifier => Member_Desc_For_Aspect_F_Identifier'Access,
Member_Index_For_Aspect_F_Value => Member_Desc_For_Aspect_F_Value'Access,
Member_Index_For_Message_Aggregate_Associations_F_Associations => Member_Desc_For_Message_Aggregate_Associations_F_Associations'Access,
Member_Index_For_Checksum_Val_F_Data => Member_Desc_For_Checksum_Val_F_Data'Access,
Member_Index_For_Checksum_Value_Range_F_First => Member_Desc_For_Checksum_Value_Range_F_First'Access,
Member_Index_For_Checksum_Value_Range_F_Last => Member_Desc_For_Checksum_Value_Range_F_Last'Access,
Member_Index_For_Checksum_Assoc_F_Identifier => Member_Desc_For_Checksum_Assoc_F_Identifier'Access,
Member_Index_For_Checksum_Assoc_F_Covered_Fields => Member_Desc_For_Checksum_Assoc_F_Covered_Fields'Access,
Member_Index_For_Refinement_Decl_F_Pdu => Member_Desc_For_Refinement_Decl_F_Pdu'Access,
Member_Index_For_Refinement_Decl_F_Field => Member_Desc_For_Refinement_Decl_F_Field'Access,
Member_Index_For_Refinement_Decl_F_Sdu => Member_Desc_For_Refinement_Decl_F_Sdu'Access,
Member_Index_For_Refinement_Decl_F_Condition => Member_Desc_For_Refinement_Decl_F_Condition'Access,
Member_Index_For_Session_Decl_F_Parameters => Member_Desc_For_Session_Decl_F_Parameters'Access,
Member_Index_For_Session_Decl_F_Identifier => Member_Desc_For_Session_Decl_F_Identifier'Access,
Member_Index_For_Session_Decl_F_Declarations => Member_Desc_For_Session_Decl_F_Declarations'Access,
Member_Index_For_Session_Decl_F_States => Member_Desc_For_Session_Decl_F_States'Access,
Member_Index_For_Session_Decl_F_End_Identifier => Member_Desc_For_Session_Decl_F_End_Identifier'Access,
Member_Index_For_Type_Decl_F_Identifier => Member_Desc_For_Type_Decl_F_Identifier'Access,
Member_Index_For_Type_Decl_F_Parameters => Member_Desc_For_Type_Decl_F_Parameters'Access,
Member_Index_For_Type_Decl_F_Definition => Member_Desc_For_Type_Decl_F_Definition'Access,
Member_Index_For_Description_F_Content => Member_Desc_For_Description_F_Content'Access,
Member_Index_For_Element_Value_Assoc_F_Identifier => Member_Desc_For_Element_Value_Assoc_F_Identifier'Access,
Member_Index_For_Element_Value_Assoc_F_Literal => Member_Desc_For_Element_Value_Assoc_F_Literal'Access,
Member_Index_For_Attribute_F_Expression => Member_Desc_For_Attribute_F_Expression'Access,
Member_Index_For_Attribute_F_Kind => Member_Desc_For_Attribute_F_Kind'Access,
Member_Index_For_Bin_Op_F_Left => Member_Desc_For_Bin_Op_F_Left'Access,
Member_Index_For_Bin_Op_F_Op => Member_Desc_For_Bin_Op_F_Op'Access,
Member_Index_For_Bin_Op_F_Right => Member_Desc_For_Bin_Op_F_Right'Access,
Member_Index_For_Binding_F_Expression => Member_Desc_For_Binding_F_Expression'Access,
Member_Index_For_Binding_F_Bindings => Member_Desc_For_Binding_F_Bindings'Access,
Member_Index_For_Call_F_Identifier => Member_Desc_For_Call_F_Identifier'Access,
Member_Index_For_Call_F_Arguments => Member_Desc_For_Call_F_Arguments'Access,
Member_Index_For_Case_Expression_F_Expression => Member_Desc_For_Case_Expression_F_Expression'Access,
Member_Index_For_Case_Expression_F_Choices => Member_Desc_For_Case_Expression_F_Choices'Access,
Member_Index_For_Choice_F_Selectors => Member_Desc_For_Choice_F_Selectors'Access,
Member_Index_For_Choice_F_Expression => Member_Desc_For_Choice_F_Expression'Access,
Member_Index_For_Comprehension_F_Iterator => Member_Desc_For_Comprehension_F_Iterator'Access,
Member_Index_For_Comprehension_F_Sequence => Member_Desc_For_Comprehension_F_Sequence'Access,
Member_Index_For_Comprehension_F_Condition => Member_Desc_For_Comprehension_F_Condition'Access,
Member_Index_For_Comprehension_F_Selector => Member_Desc_For_Comprehension_F_Selector'Access,
Member_Index_For_Context_Item_F_Item => Member_Desc_For_Context_Item_F_Item'Access,
Member_Index_For_Conversion_F_Target_Identifier => Member_Desc_For_Conversion_F_Target_Identifier'Access,
Member_Index_For_Conversion_F_Argument => Member_Desc_For_Conversion_F_Argument'Access,
Member_Index_For_Message_Aggregate_F_Identifier => Member_Desc_For_Message_Aggregate_F_Identifier'Access,
Member_Index_For_Message_Aggregate_F_Values => Member_Desc_For_Message_Aggregate_F_Values'Access,
Member_Index_For_Negation_F_Data => Member_Desc_For_Negation_F_Data'Access,
Member_Index_For_Paren_Expression_F_Data => Member_Desc_For_Paren_Expression_F_Data'Access,
Member_Index_For_Quantified_Expression_F_Operation => Member_Desc_For_Quantified_Expression_F_Operation'Access,
Member_Index_For_Quantified_Expression_F_Parameter_Identifier => Member_Desc_For_Quantified_Expression_F_Parameter_Identifier'Access,
Member_Index_For_Quantified_Expression_F_Iterable => Member_Desc_For_Quantified_Expression_F_Iterable'Access,
Member_Index_For_Quantified_Expression_F_Predicate => Member_Desc_For_Quantified_Expression_F_Predicate'Access,
Member_Index_For_Select_Node_F_Expression => Member_Desc_For_Select_Node_F_Expression'Access,
Member_Index_For_Select_Node_F_Selector => Member_Desc_For_Select_Node_F_Selector'Access,
Member_Index_For_Concatenation_F_Left => Member_Desc_For_Concatenation_F_Left'Access,
Member_Index_For_Concatenation_F_Right => Member_Desc_For_Concatenation_F_Right'Access,
Member_Index_For_Sequence_Aggregate_F_Values => Member_Desc_For_Sequence_Aggregate_F_Values'Access,
Member_Index_For_Variable_F_Identifier => Member_Desc_For_Variable_F_Identifier'Access,
Member_Index_For_Formal_Channel_Decl_F_Identifier => Member_Desc_For_Formal_Channel_Decl_F_Identifier'Access,
Member_Index_For_Formal_Channel_Decl_F_Parameters => Member_Desc_For_Formal_Channel_Decl_F_Parameters'Access,
Member_Index_For_Formal_Function_Decl_F_Identifier => Member_Desc_For_Formal_Function_Decl_F_Identifier'Access,
Member_Index_For_Formal_Function_Decl_F_Parameters => Member_Desc_For_Formal_Function_Decl_F_Parameters'Access,
Member_Index_For_Formal_Function_Decl_F_Return_Type_Identifier => Member_Desc_For_Formal_Function_Decl_F_Return_Type_Identifier'Access,
Member_Index_For_Renaming_Decl_F_Identifier => Member_Desc_For_Renaming_Decl_F_Identifier'Access,
Member_Index_For_Renaming_Decl_F_Type_Identifier => Member_Desc_For_Renaming_Decl_F_Type_Identifier'Access,
Member_Index_For_Renaming_Decl_F_Expression => Member_Desc_For_Renaming_Decl_F_Expression'Access,
Member_Index_For_Variable_Decl_F_Identifier => Member_Desc_For_Variable_Decl_F_Identifier'Access,
Member_Index_For_Variable_Decl_F_Type_Identifier => Member_Desc_For_Variable_Decl_F_Type_Identifier'Access,
Member_Index_For_Variable_Decl_F_Initializer => Member_Desc_For_Variable_Decl_F_Initializer'Access,
Member_Index_For_Message_Aggregate_Association_F_Identifier => Member_Desc_For_Message_Aggregate_Association_F_Identifier'Access,
Member_Index_For_Message_Aggregate_Association_F_Expression => Member_Desc_For_Message_Aggregate_Association_F_Expression'Access,
Member_Index_For_Byte_Order_Aspect_F_Byte_Order => Member_Desc_For_Byte_Order_Aspect_F_Byte_Order'Access,
Member_Index_For_Checksum_Aspect_F_Associations => Member_Desc_For_Checksum_Aspect_F_Associations'Access,
Member_Index_For_Message_Field_F_Identifier => Member_Desc_For_Message_Field_F_Identifier'Access,
Member_Index_For_Message_Field_F_Type_Identifier => Member_Desc_For_Message_Field_F_Type_Identifier'Access,
Member_Index_For_Message_Field_F_Type_Arguments => Member_Desc_For_Message_Field_F_Type_Arguments'Access,
Member_Index_For_Message_Field_F_Aspects => Member_Desc_For_Message_Field_F_Aspects'Access,
Member_Index_For_Message_Field_F_Condition => Member_Desc_For_Message_Field_F_Condition'Access,
Member_Index_For_Message_Field_F_Thens => Member_Desc_For_Message_Field_F_Thens'Access,
Member_Index_For_Message_Fields_F_Initial_Field => Member_Desc_For_Message_Fields_F_Initial_Field'Access,
Member_Index_For_Message_Fields_F_Fields => Member_Desc_For_Message_Fields_F_Fields'Access,
Member_Index_For_Null_Message_Field_F_Then => Member_Desc_For_Null_Message_Field_F_Then'Access,
Member_Index_For_Package_Node_F_Identifier => Member_Desc_For_Package_Node_F_Identifier'Access,
Member_Index_For_Package_Node_F_Declarations => Member_Desc_For_Package_Node_F_Declarations'Access,
Member_Index_For_Package_Node_F_End_Identifier => Member_Desc_For_Package_Node_F_End_Identifier'Access,
Member_Index_For_Parameter_F_Identifier => Member_Desc_For_Parameter_F_Identifier'Access,
Member_Index_For_Parameter_F_Type_Identifier => Member_Desc_For_Parameter_F_Type_Identifier'Access,
Member_Index_For_Parameters_F_Parameters => Member_Desc_For_Parameters_F_Parameters'Access,
Member_Index_For_Specification_F_Context_Clause => Member_Desc_For_Specification_F_Context_Clause'Access,
Member_Index_For_Specification_F_Package_Declaration => Member_Desc_For_Specification_F_Package_Declaration'Access,
Member_Index_For_State_F_Identifier => Member_Desc_For_State_F_Identifier'Access,
Member_Index_For_State_F_Description => Member_Desc_For_State_F_Description'Access,
Member_Index_For_State_F_Body => Member_Desc_For_State_F_Body'Access,
Member_Index_For_State_Body_F_Declarations => Member_Desc_For_State_Body_F_Declarations'Access,
Member_Index_For_State_Body_F_Actions => Member_Desc_For_State_Body_F_Actions'Access,
Member_Index_For_State_Body_F_Conditional_Transitions => Member_Desc_For_State_Body_F_Conditional_Transitions'Access,
Member_Index_For_State_Body_F_Final_Transition => Member_Desc_For_State_Body_F_Final_Transition'Access,
Member_Index_For_State_Body_F_Exception_Transition => Member_Desc_For_State_Body_F_Exception_Transition'Access,
Member_Index_For_State_Body_F_End_Identifier => Member_Desc_For_State_Body_F_End_Identifier'Access,
Member_Index_For_Assignment_F_Identifier => Member_Desc_For_Assignment_F_Identifier'Access,
Member_Index_For_Assignment_F_Expression => Member_Desc_For_Assignment_F_Expression'Access,
Member_Index_For_Attribute_Statement_F_Identifier => Member_Desc_For_Attribute_Statement_F_Identifier'Access,
Member_Index_For_Attribute_Statement_F_Attr => Member_Desc_For_Attribute_Statement_F_Attr'Access,
Member_Index_For_Attribute_Statement_F_Expression => Member_Desc_For_Attribute_Statement_F_Expression'Access,
Member_Index_For_Message_Field_Assignment_F_Message => Member_Desc_For_Message_Field_Assignment_F_Message'Access,
Member_Index_For_Message_Field_Assignment_F_Field => Member_Desc_For_Message_Field_Assignment_F_Field'Access,
Member_Index_For_Message_Field_Assignment_F_Expression => Member_Desc_For_Message_Field_Assignment_F_Expression'Access,
Member_Index_For_Reset_F_Identifier => Member_Desc_For_Reset_F_Identifier'Access,
Member_Index_For_Reset_F_Associations => Member_Desc_For_Reset_F_Associations'Access,
Member_Index_For_Term_Assoc_F_Identifier => Member_Desc_For_Term_Assoc_F_Identifier'Access,
Member_Index_For_Term_Assoc_F_Expression => Member_Desc_For_Term_Assoc_F_Expression'Access,
Member_Index_For_Then_Node_F_Target => Member_Desc_For_Then_Node_F_Target'Access,
Member_Index_For_Then_Node_F_Aspects => Member_Desc_For_Then_Node_F_Aspects'Access,
Member_Index_For_Then_Node_F_Condition => Member_Desc_For_Then_Node_F_Condition'Access,
Member_Index_For_Transition_F_Target => Member_Desc_For_Transition_F_Target'Access,
Member_Index_For_Transition_F_Description => Member_Desc_For_Transition_F_Description'Access,
Member_Index_For_Conditional_Transition_F_Condition => Member_Desc_For_Conditional_Transition_F_Condition'Access,
Member_Index_For_Type_Argument_F_Identifier => Member_Desc_For_Type_Argument_F_Identifier'Access,
Member_Index_For_Type_Argument_F_Expression => Member_Desc_For_Type_Argument_F_Expression'Access,
Member_Index_For_Message_Type_Def_F_Message_Fields => Member_Desc_For_Message_Type_Def_F_Message_Fields'Access,
Member_Index_For_Message_Type_Def_F_Aspects => Member_Desc_For_Message_Type_Def_F_Aspects'Access,
Member_Index_For_Named_Enumeration_Def_F_Elements => Member_Desc_For_Named_Enumeration_Def_F_Elements'Access,
Member_Index_For_Positional_Enumeration_Def_F_Elements => Member_Desc_For_Positional_Enumeration_Def_F_Elements'Access,
Member_Index_For_Enumeration_Type_Def_F_Elements => Member_Desc_For_Enumeration_Type_Def_F_Elements'Access,
Member_Index_For_Enumeration_Type_Def_F_Aspects => Member_Desc_For_Enumeration_Type_Def_F_Aspects'Access,
Member_Index_For_Modular_Type_Def_F_Mod => Member_Desc_For_Modular_Type_Def_F_Mod'Access,
Member_Index_For_Range_Type_Def_F_First => Member_Desc_For_Range_Type_Def_F_First'Access,
Member_Index_For_Range_Type_Def_F_Last => Member_Desc_For_Range_Type_Def_F_Last'Access,
Member_Index_For_Range_Type_Def_F_Size => Member_Desc_For_Range_Type_Def_F_Size'Access,
Member_Index_For_Sequence_Type_Def_F_Element_Type => Member_Desc_For_Sequence_Type_Def_F_Element_Type'Access,
Member_Index_For_Type_Derivation_Def_F_Base => Member_Desc_For_Type_Derivation_Def_F_Base'Access,
Member_Index_For_Parent => Member_Desc_For_Parent'Access,
Member_Index_For_Parents => Member_Desc_For_Parents'Access,
Member_Index_For_Children => Member_Desc_For_Children'Access,
Member_Index_For_Token_Start => Member_Desc_For_Token_Start'Access,
Member_Index_For_Token_End => Member_Desc_For_Token_End'Access,
Member_Index_For_Child_Index => Member_Desc_For_Child_Index'Access,
Member_Index_For_Previous_Sibling => Member_Desc_For_Previous_Sibling'Access,
Member_Index_For_Next_Sibling => Member_Desc_For_Next_Sibling'Access,
Member_Index_For_Unit => Member_Desc_For_Unit'Access,
Member_Index_For_Is_Ghost => Member_Desc_For_Is_Ghost'Access,
Member_Index_For_Full_Sloc_Image => Member_Desc_For_Full_Sloc_Image'Access
   );

   -----------------------------
   -- Struct type descriptors --
   -----------------------------

   
      
      Node_Name_For_R_F_L_X_Node : aliased constant Text_Type :=
        "R_F_L_X_Node";
         Node_Repr_Name_For_R_F_L_X_Node : aliased constant Text_Type :=
           "RFLXNode";
      Node_Desc_For_R_F_L_X_Node : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 35,
         Member_Count      => 11,
         Base_Type         => No_Type_Index,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_R_F_L_X_Node'Access,
         Repr_Name         => Node_Repr_Name_For_R_F_L_X_Node'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Abstract_I_D,
2 => Type_Index_For_Aspect,
3 => Type_Index_For_Attr,
4 => Type_Index_For_Attr_Stmt,
5 => Type_Index_For_Base_Aggregate,
6 => Type_Index_For_Base_Checksum_Val,
7 => Type_Index_For_Byte_Order_Type,
8 => Type_Index_For_Channel_Attribute,
9 => Type_Index_For_Checksum_Assoc,
10 => Type_Index_For_Declaration,
11 => Type_Index_For_Description,
12 => Type_Index_For_Element_Value_Assoc,
13 => Type_Index_For_Expr,
14 => Type_Index_For_Formal_Decl,
15 => Type_Index_For_Local_Decl,
16 => Type_Index_For_Message_Aggregate_Association,
17 => Type_Index_For_Message_Aspect,
18 => Type_Index_For_Message_Field,
19 => Type_Index_For_Message_Fields,
20 => Type_Index_For_Null_Message_Field,
21 => Type_Index_For_Op,
22 => Type_Index_For_Package,
23 => Type_Index_For_Parameter,
24 => Type_Index_For_Parameters,
25 => Type_Index_For_Quantifier,
26 => Type_Index_For_R_F_L_X_Node_Base_List,
27 => Type_Index_For_Specification,
28 => Type_Index_For_State,
29 => Type_Index_For_State_Body,
30 => Type_Index_For_Statement,
31 => Type_Index_For_Term_Assoc,
32 => Type_Index_For_Then,
33 => Type_Index_For_Transition,
34 => Type_Index_For_Type_Argument,
35 => Type_Index_For_Type_Def
         ),
         Members           => (
              1 => Member_Index_For_Parent,
2 => Member_Index_For_Parents,
3 => Member_Index_For_Children,
4 => Member_Index_For_Token_Start,
5 => Member_Index_For_Token_End,
6 => Member_Index_For_Child_Index,
7 => Member_Index_For_Previous_Sibling,
8 => Member_Index_For_Next_Sibling,
9 => Member_Index_For_Unit,
10 => Member_Index_For_Is_Ghost,
11 => Member_Index_For_Full_Sloc_Image
         ));
      
      Node_Name_For_Abstract_I_D : aliased constant Text_Type :=
        "Abstract_I_D";
         Node_Repr_Name_For_Abstract_I_D : aliased constant Text_Type :=
           "AbstractID";
      Node_Desc_For_Abstract_I_D : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Abstract_I_D'Access,
         Repr_Name         => Node_Repr_Name_For_Abstract_I_D'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_I_D,
2 => Type_Index_For_Unqualified_I_D
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_I_D : aliased constant Text_Type :=
        "I_D";
         Node_Repr_Name_For_I_D : aliased constant Text_Type :=
           "ID";
      Node_Desc_For_I_D : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Abstract_I_D,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_I_D'Access,
         Repr_Name         => Node_Repr_Name_For_I_D'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_I_D_F_Package,
2 => Member_Index_For_I_D_F_Name
         ));
      
      Node_Name_For_Unqualified_I_D : aliased constant Text_Type :=
        "Unqualified_I_D";
         Node_Repr_Name_For_Unqualified_I_D : aliased constant Text_Type :=
           "UnqualifiedID";
      Node_Desc_For_Unqualified_I_D : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Abstract_I_D,
         Is_Abstract       => False,
         Is_Token_Node     => True,
         Is_List_Node      => False,
         Name              => Node_Name_For_Unqualified_I_D'Access,
         Repr_Name         => Node_Repr_Name_For_Unqualified_I_D'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Aspect : aliased constant Text_Type :=
        "Aspect";
         Node_Repr_Name_For_Aspect : aliased constant Text_Type :=
           "Aspect";
      Node_Desc_For_Aspect : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Aspect'Access,
         Repr_Name         => Node_Repr_Name_For_Aspect'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Aspect_F_Identifier,
2 => Member_Index_For_Aspect_F_Value
         ));
      
      Node_Name_For_Attr : aliased constant Text_Type :=
        "Attr";
         Node_Repr_Name_For_Attr : aliased constant Text_Type :=
           "Attr";
      Node_Desc_For_Attr : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 9,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr'Access,
         Repr_Name         => Node_Repr_Name_For_Attr'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Attr_First,
2 => Type_Index_For_Attr_Has_Data,
3 => Type_Index_For_Attr_Head,
4 => Type_Index_For_Attr_Last,
5 => Type_Index_For_Attr_Opaque,
6 => Type_Index_For_Attr_Present,
7 => Type_Index_For_Attr_Size,
8 => Type_Index_For_Attr_Valid,
9 => Type_Index_For_Attr_Valid_Checksum
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_First : aliased constant Text_Type :=
        "Attr_First";
         Node_Repr_Name_For_Attr_First : aliased constant Text_Type :=
           "AttrFirst";
      Node_Desc_For_Attr_First : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_First'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_First'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Has_Data : aliased constant Text_Type :=
        "Attr_Has_Data";
         Node_Repr_Name_For_Attr_Has_Data : aliased constant Text_Type :=
           "AttrHasData";
      Node_Desc_For_Attr_Has_Data : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Has_Data'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Has_Data'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Head : aliased constant Text_Type :=
        "Attr_Head";
         Node_Repr_Name_For_Attr_Head : aliased constant Text_Type :=
           "AttrHead";
      Node_Desc_For_Attr_Head : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Head'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Head'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Last : aliased constant Text_Type :=
        "Attr_Last";
         Node_Repr_Name_For_Attr_Last : aliased constant Text_Type :=
           "AttrLast";
      Node_Desc_For_Attr_Last : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Last'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Last'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Opaque : aliased constant Text_Type :=
        "Attr_Opaque";
         Node_Repr_Name_For_Attr_Opaque : aliased constant Text_Type :=
           "AttrOpaque";
      Node_Desc_For_Attr_Opaque : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Opaque'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Opaque'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Present : aliased constant Text_Type :=
        "Attr_Present";
         Node_Repr_Name_For_Attr_Present : aliased constant Text_Type :=
           "AttrPresent";
      Node_Desc_For_Attr_Present : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Present'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Present'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Size : aliased constant Text_Type :=
        "Attr_Size";
         Node_Repr_Name_For_Attr_Size : aliased constant Text_Type :=
           "AttrSize";
      Node_Desc_For_Attr_Size : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Size'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Size'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Valid : aliased constant Text_Type :=
        "Attr_Valid";
         Node_Repr_Name_For_Attr_Valid : aliased constant Text_Type :=
           "AttrValid";
      Node_Desc_For_Attr_Valid : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Valid'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Valid'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Valid_Checksum : aliased constant Text_Type :=
        "Attr_Valid_Checksum";
         Node_Repr_Name_For_Attr_Valid_Checksum : aliased constant Text_Type :=
           "AttrValidChecksum";
      Node_Desc_For_Attr_Valid_Checksum : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Valid_Checksum'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Valid_Checksum'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Stmt : aliased constant Text_Type :=
        "Attr_Stmt";
         Node_Repr_Name_For_Attr_Stmt : aliased constant Text_Type :=
           "AttrStmt";
      Node_Desc_For_Attr_Stmt : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 4,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Stmt'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Stmt'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Attr_Stmt_Append,
2 => Type_Index_For_Attr_Stmt_Extend,
3 => Type_Index_For_Attr_Stmt_Read,
4 => Type_Index_For_Attr_Stmt_Write
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Stmt_Append : aliased constant Text_Type :=
        "Attr_Stmt_Append";
         Node_Repr_Name_For_Attr_Stmt_Append : aliased constant Text_Type :=
           "AttrStmtAppend";
      Node_Desc_For_Attr_Stmt_Append : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr_Stmt,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Stmt_Append'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Stmt_Append'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Stmt_Extend : aliased constant Text_Type :=
        "Attr_Stmt_Extend";
         Node_Repr_Name_For_Attr_Stmt_Extend : aliased constant Text_Type :=
           "AttrStmtExtend";
      Node_Desc_For_Attr_Stmt_Extend : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr_Stmt,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Stmt_Extend'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Stmt_Extend'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Stmt_Read : aliased constant Text_Type :=
        "Attr_Stmt_Read";
         Node_Repr_Name_For_Attr_Stmt_Read : aliased constant Text_Type :=
           "AttrStmtRead";
      Node_Desc_For_Attr_Stmt_Read : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr_Stmt,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Stmt_Read'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Stmt_Read'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attr_Stmt_Write : aliased constant Text_Type :=
        "Attr_Stmt_Write";
         Node_Repr_Name_For_Attr_Stmt_Write : aliased constant Text_Type :=
           "AttrStmtWrite";
      Node_Desc_For_Attr_Stmt_Write : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Attr_Stmt,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attr_Stmt_Write'Access,
         Repr_Name         => Node_Repr_Name_For_Attr_Stmt_Write'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Base_Aggregate : aliased constant Text_Type :=
        "Base_Aggregate";
         Node_Repr_Name_For_Base_Aggregate : aliased constant Text_Type :=
           "BaseAggregate";
      Node_Desc_For_Base_Aggregate : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Aggregate'Access,
         Repr_Name         => Node_Repr_Name_For_Base_Aggregate'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Message_Aggregate_Associations,
2 => Type_Index_For_Null_Message_Aggregate
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Message_Aggregate_Associations : aliased constant Text_Type :=
        "Message_Aggregate_Associations";
         Node_Repr_Name_For_Message_Aggregate_Associations : aliased constant Text_Type :=
           "MessageAggregateAssociations";
      Node_Desc_For_Message_Aggregate_Associations : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Base_Aggregate,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Message_Aggregate_Associations'Access,
         Repr_Name         => Node_Repr_Name_For_Message_Aggregate_Associations'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Message_Aggregate_Associations_F_Associations
         ));
      
      Node_Name_For_Null_Message_Aggregate : aliased constant Text_Type :=
        "Null_Message_Aggregate";
         Node_Repr_Name_For_Null_Message_Aggregate : aliased constant Text_Type :=
           "NullMessageAggregate";
      Node_Desc_For_Null_Message_Aggregate : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Base_Aggregate,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Null_Message_Aggregate'Access,
         Repr_Name         => Node_Repr_Name_For_Null_Message_Aggregate'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Base_Checksum_Val : aliased constant Text_Type :=
        "Base_Checksum_Val";
         Node_Repr_Name_For_Base_Checksum_Val : aliased constant Text_Type :=
           "BaseChecksumVal";
      Node_Desc_For_Base_Checksum_Val : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Checksum_Val'Access,
         Repr_Name         => Node_Repr_Name_For_Base_Checksum_Val'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Checksum_Val,
2 => Type_Index_For_Checksum_Value_Range
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Checksum_Val : aliased constant Text_Type :=
        "Checksum_Val";
         Node_Repr_Name_For_Checksum_Val : aliased constant Text_Type :=
           "ChecksumVal";
      Node_Desc_For_Checksum_Val : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Base_Checksum_Val,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Checksum_Val'Access,
         Repr_Name         => Node_Repr_Name_For_Checksum_Val'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Checksum_Val_F_Data
         ));
      
      Node_Name_For_Checksum_Value_Range : aliased constant Text_Type :=
        "Checksum_Value_Range";
         Node_Repr_Name_For_Checksum_Value_Range : aliased constant Text_Type :=
           "ChecksumValueRange";
      Node_Desc_For_Checksum_Value_Range : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Base_Checksum_Val,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Checksum_Value_Range'Access,
         Repr_Name         => Node_Repr_Name_For_Checksum_Value_Range'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Checksum_Value_Range_F_First,
2 => Member_Index_For_Checksum_Value_Range_F_Last
         ));
      
      Node_Name_For_Byte_Order_Type : aliased constant Text_Type :=
        "Byte_Order_Type";
         Node_Repr_Name_For_Byte_Order_Type : aliased constant Text_Type :=
           "ByteOrderType";
      Node_Desc_For_Byte_Order_Type : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Byte_Order_Type'Access,
         Repr_Name         => Node_Repr_Name_For_Byte_Order_Type'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Byte_Order_Type_Highorderfirst,
2 => Type_Index_For_Byte_Order_Type_Loworderfirst
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Byte_Order_Type_Highorderfirst : aliased constant Text_Type :=
        "Byte_Order_Type_Highorderfirst";
         Node_Repr_Name_For_Byte_Order_Type_Highorderfirst : aliased constant Text_Type :=
           "ByteOrderTypeHighorderfirst";
      Node_Desc_For_Byte_Order_Type_Highorderfirst : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Byte_Order_Type,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Byte_Order_Type_Highorderfirst'Access,
         Repr_Name         => Node_Repr_Name_For_Byte_Order_Type_Highorderfirst'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Byte_Order_Type_Loworderfirst : aliased constant Text_Type :=
        "Byte_Order_Type_Loworderfirst";
         Node_Repr_Name_For_Byte_Order_Type_Loworderfirst : aliased constant Text_Type :=
           "ByteOrderTypeLoworderfirst";
      Node_Desc_For_Byte_Order_Type_Loworderfirst : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Byte_Order_Type,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Byte_Order_Type_Loworderfirst'Access,
         Repr_Name         => Node_Repr_Name_For_Byte_Order_Type_Loworderfirst'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Channel_Attribute : aliased constant Text_Type :=
        "Channel_Attribute";
         Node_Repr_Name_For_Channel_Attribute : aliased constant Text_Type :=
           "ChannelAttribute";
      Node_Desc_For_Channel_Attribute : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Channel_Attribute'Access,
         Repr_Name         => Node_Repr_Name_For_Channel_Attribute'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Readable,
2 => Type_Index_For_Writable
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Readable : aliased constant Text_Type :=
        "Readable";
         Node_Repr_Name_For_Readable : aliased constant Text_Type :=
           "Readable";
      Node_Desc_For_Readable : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Channel_Attribute,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Readable'Access,
         Repr_Name         => Node_Repr_Name_For_Readable'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Writable : aliased constant Text_Type :=
        "Writable";
         Node_Repr_Name_For_Writable : aliased constant Text_Type :=
           "Writable";
      Node_Desc_For_Writable : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Channel_Attribute,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Writable'Access,
         Repr_Name         => Node_Repr_Name_For_Writable'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Checksum_Assoc : aliased constant Text_Type :=
        "Checksum_Assoc";
         Node_Repr_Name_For_Checksum_Assoc : aliased constant Text_Type :=
           "ChecksumAssoc";
      Node_Desc_For_Checksum_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Checksum_Assoc'Access,
         Repr_Name         => Node_Repr_Name_For_Checksum_Assoc'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Checksum_Assoc_F_Identifier,
2 => Member_Index_For_Checksum_Assoc_F_Covered_Fields
         ));
      
      Node_Name_For_Declaration : aliased constant Text_Type :=
        "Declaration";
         Node_Repr_Name_For_Declaration : aliased constant Text_Type :=
           "Declaration";
      Node_Desc_For_Declaration : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 3,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Declaration'Access,
         Repr_Name         => Node_Repr_Name_For_Declaration'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Refinement_Decl,
2 => Type_Index_For_Session_Decl,
3 => Type_Index_For_Type_Decl
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Refinement_Decl : aliased constant Text_Type :=
        "Refinement_Decl";
         Node_Repr_Name_For_Refinement_Decl : aliased constant Text_Type :=
           "RefinementDecl";
      Node_Desc_For_Refinement_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Declaration,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Refinement_Decl'Access,
         Repr_Name         => Node_Repr_Name_For_Refinement_Decl'Access,
         Inherited_Members => 15,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Refinement_Decl_F_Pdu,
2 => Member_Index_For_Refinement_Decl_F_Field,
3 => Member_Index_For_Refinement_Decl_F_Sdu,
4 => Member_Index_For_Refinement_Decl_F_Condition
         ));
      
      Node_Name_For_Session_Decl : aliased constant Text_Type :=
        "Session_Decl";
         Node_Repr_Name_For_Session_Decl : aliased constant Text_Type :=
           "SessionDecl";
      Node_Desc_For_Session_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 5,
         Base_Type         => Type_Index_For_Declaration,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Session_Decl'Access,
         Repr_Name         => Node_Repr_Name_For_Session_Decl'Access,
         Inherited_Members => 16,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Session_Decl_F_Parameters,
2 => Member_Index_For_Session_Decl_F_Identifier,
3 => Member_Index_For_Session_Decl_F_Declarations,
4 => Member_Index_For_Session_Decl_F_States,
5 => Member_Index_For_Session_Decl_F_End_Identifier
         ));
      
      Node_Name_For_Type_Decl : aliased constant Text_Type :=
        "Type_Decl";
         Node_Repr_Name_For_Type_Decl : aliased constant Text_Type :=
           "TypeDecl";
      Node_Desc_For_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Declaration,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Type_Decl'Access,
         Repr_Name         => Node_Repr_Name_For_Type_Decl'Access,
         Inherited_Members => 14,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Type_Decl_F_Identifier,
2 => Member_Index_For_Type_Decl_F_Parameters,
3 => Member_Index_For_Type_Decl_F_Definition
         ));
      
      Node_Name_For_Description : aliased constant Text_Type :=
        "Description";
         Node_Repr_Name_For_Description : aliased constant Text_Type :=
           "Description";
      Node_Desc_For_Description : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Description'Access,
         Repr_Name         => Node_Repr_Name_For_Description'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Description_F_Content
         ));
      
      Node_Name_For_Element_Value_Assoc : aliased constant Text_Type :=
        "Element_Value_Assoc";
         Node_Repr_Name_For_Element_Value_Assoc : aliased constant Text_Type :=
           "ElementValueAssoc";
      Node_Desc_For_Element_Value_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Element_Value_Assoc'Access,
         Repr_Name         => Node_Repr_Name_For_Element_Value_Assoc'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Element_Value_Assoc_F_Identifier,
2 => Member_Index_For_Element_Value_Assoc_F_Literal
         ));
      
      Node_Name_For_Expr : aliased constant Text_Type :=
        "Expr";
         Node_Repr_Name_For_Expr : aliased constant Text_Type :=
           "Expr";
      Node_Desc_For_Expr : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 17,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Expr'Access,
         Repr_Name         => Node_Repr_Name_For_Expr'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Attribute,
2 => Type_Index_For_Bin_Op,
3 => Type_Index_For_Binding,
4 => Type_Index_For_Call,
5 => Type_Index_For_Case_Expression,
6 => Type_Index_For_Choice,
7 => Type_Index_For_Comprehension,
8 => Type_Index_For_Context_Item,
9 => Type_Index_For_Conversion,
10 => Type_Index_For_Message_Aggregate,
11 => Type_Index_For_Negation,
12 => Type_Index_For_Numeric_Literal,
13 => Type_Index_For_Paren_Expression,
14 => Type_Index_For_Quantified_Expression,
15 => Type_Index_For_Select,
16 => Type_Index_For_Sequence_Literal,
17 => Type_Index_For_Variable
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Attribute : aliased constant Text_Type :=
        "Attribute";
         Node_Repr_Name_For_Attribute : aliased constant Text_Type :=
           "Attribute";
      Node_Desc_For_Attribute : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attribute'Access,
         Repr_Name         => Node_Repr_Name_For_Attribute'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Attribute_F_Expression,
2 => Member_Index_For_Attribute_F_Kind
         ));
      
      Node_Name_For_Bin_Op : aliased constant Text_Type :=
        "Bin_Op";
         Node_Repr_Name_For_Bin_Op : aliased constant Text_Type :=
           "BinOp";
      Node_Desc_For_Bin_Op : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Bin_Op'Access,
         Repr_Name         => Node_Repr_Name_For_Bin_Op'Access,
         Inherited_Members => 14,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Bin_Op_F_Left,
2 => Member_Index_For_Bin_Op_F_Op,
3 => Member_Index_For_Bin_Op_F_Right
         ));
      
      Node_Name_For_Binding : aliased constant Text_Type :=
        "Binding";
         Node_Repr_Name_For_Binding : aliased constant Text_Type :=
           "Binding";
      Node_Desc_For_Binding : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Binding'Access,
         Repr_Name         => Node_Repr_Name_For_Binding'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Binding_F_Expression,
2 => Member_Index_For_Binding_F_Bindings
         ));
      
      Node_Name_For_Call : aliased constant Text_Type :=
        "Call";
         Node_Repr_Name_For_Call : aliased constant Text_Type :=
           "Call";
      Node_Desc_For_Call : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Call'Access,
         Repr_Name         => Node_Repr_Name_For_Call'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Call_F_Identifier,
2 => Member_Index_For_Call_F_Arguments
         ));
      
      Node_Name_For_Case_Expression : aliased constant Text_Type :=
        "Case_Expression";
         Node_Repr_Name_For_Case_Expression : aliased constant Text_Type :=
           "CaseExpression";
      Node_Desc_For_Case_Expression : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Case_Expression'Access,
         Repr_Name         => Node_Repr_Name_For_Case_Expression'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Case_Expression_F_Expression,
2 => Member_Index_For_Case_Expression_F_Choices
         ));
      
      Node_Name_For_Choice : aliased constant Text_Type :=
        "Choice";
         Node_Repr_Name_For_Choice : aliased constant Text_Type :=
           "Choice";
      Node_Desc_For_Choice : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Choice'Access,
         Repr_Name         => Node_Repr_Name_For_Choice'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Choice_F_Selectors,
2 => Member_Index_For_Choice_F_Expression
         ));
      
      Node_Name_For_Comprehension : aliased constant Text_Type :=
        "Comprehension";
         Node_Repr_Name_For_Comprehension : aliased constant Text_Type :=
           "Comprehension";
      Node_Desc_For_Comprehension : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Comprehension'Access,
         Repr_Name         => Node_Repr_Name_For_Comprehension'Access,
         Inherited_Members => 15,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Comprehension_F_Iterator,
2 => Member_Index_For_Comprehension_F_Sequence,
3 => Member_Index_For_Comprehension_F_Condition,
4 => Member_Index_For_Comprehension_F_Selector
         ));
      
      Node_Name_For_Context_Item : aliased constant Text_Type :=
        "Context_Item";
         Node_Repr_Name_For_Context_Item : aliased constant Text_Type :=
           "ContextItem";
      Node_Desc_For_Context_Item : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Context_Item'Access,
         Repr_Name         => Node_Repr_Name_For_Context_Item'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Context_Item_F_Item
         ));
      
      Node_Name_For_Conversion : aliased constant Text_Type :=
        "Conversion";
         Node_Repr_Name_For_Conversion : aliased constant Text_Type :=
           "Conversion";
      Node_Desc_For_Conversion : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Conversion'Access,
         Repr_Name         => Node_Repr_Name_For_Conversion'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Conversion_F_Target_Identifier,
2 => Member_Index_For_Conversion_F_Argument
         ));
      
      Node_Name_For_Message_Aggregate : aliased constant Text_Type :=
        "Message_Aggregate";
         Node_Repr_Name_For_Message_Aggregate : aliased constant Text_Type :=
           "MessageAggregate";
      Node_Desc_For_Message_Aggregate : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Message_Aggregate'Access,
         Repr_Name         => Node_Repr_Name_For_Message_Aggregate'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Message_Aggregate_F_Identifier,
2 => Member_Index_For_Message_Aggregate_F_Values
         ));
      
      Node_Name_For_Negation : aliased constant Text_Type :=
        "Negation";
         Node_Repr_Name_For_Negation : aliased constant Text_Type :=
           "Negation";
      Node_Desc_For_Negation : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Negation'Access,
         Repr_Name         => Node_Repr_Name_For_Negation'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Negation_F_Data
         ));
      
      Node_Name_For_Numeric_Literal : aliased constant Text_Type :=
        "Numeric_Literal";
         Node_Repr_Name_For_Numeric_Literal : aliased constant Text_Type :=
           "NumericLiteral";
      Node_Desc_For_Numeric_Literal : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => True,
         Is_List_Node      => False,
         Name              => Node_Name_For_Numeric_Literal'Access,
         Repr_Name         => Node_Repr_Name_For_Numeric_Literal'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Paren_Expression : aliased constant Text_Type :=
        "Paren_Expression";
         Node_Repr_Name_For_Paren_Expression : aliased constant Text_Type :=
           "ParenExpression";
      Node_Desc_For_Paren_Expression : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Paren_Expression'Access,
         Repr_Name         => Node_Repr_Name_For_Paren_Expression'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Paren_Expression_F_Data
         ));
      
      Node_Name_For_Quantified_Expression : aliased constant Text_Type :=
        "Quantified_Expression";
         Node_Repr_Name_For_Quantified_Expression : aliased constant Text_Type :=
           "QuantifiedExpression";
      Node_Desc_For_Quantified_Expression : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Quantified_Expression'Access,
         Repr_Name         => Node_Repr_Name_For_Quantified_Expression'Access,
         Inherited_Members => 15,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Quantified_Expression_F_Operation,
2 => Member_Index_For_Quantified_Expression_F_Parameter_Identifier,
3 => Member_Index_For_Quantified_Expression_F_Iterable,
4 => Member_Index_For_Quantified_Expression_F_Predicate
         ));
      
      Node_Name_For_Select_Node : aliased constant Text_Type :=
        "Select_Node";
         Node_Repr_Name_For_Select_Node : aliased constant Text_Type :=
           "SelectNode";
      Node_Desc_For_Select_Node : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Select_Node'Access,
         Repr_Name         => Node_Repr_Name_For_Select_Node'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Select_Node_F_Expression,
2 => Member_Index_For_Select_Node_F_Selector
         ));
      
      Node_Name_For_Sequence_Literal : aliased constant Text_Type :=
        "Sequence_Literal";
         Node_Repr_Name_For_Sequence_Literal : aliased constant Text_Type :=
           "SequenceLiteral";
      Node_Desc_For_Sequence_Literal : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 3,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Sequence_Literal'Access,
         Repr_Name         => Node_Repr_Name_For_Sequence_Literal'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Concatenation,
2 => Type_Index_For_Sequence_Aggregate,
3 => Type_Index_For_String_Literal
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Concatenation : aliased constant Text_Type :=
        "Concatenation";
         Node_Repr_Name_For_Concatenation : aliased constant Text_Type :=
           "Concatenation";
      Node_Desc_For_Concatenation : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Sequence_Literal,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Concatenation'Access,
         Repr_Name         => Node_Repr_Name_For_Concatenation'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Concatenation_F_Left,
2 => Member_Index_For_Concatenation_F_Right
         ));
      
      Node_Name_For_Sequence_Aggregate : aliased constant Text_Type :=
        "Sequence_Aggregate";
         Node_Repr_Name_For_Sequence_Aggregate : aliased constant Text_Type :=
           "SequenceAggregate";
      Node_Desc_For_Sequence_Aggregate : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Sequence_Literal,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Sequence_Aggregate'Access,
         Repr_Name         => Node_Repr_Name_For_Sequence_Aggregate'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Sequence_Aggregate_F_Values
         ));
      
      Node_Name_For_String_Literal : aliased constant Text_Type :=
        "String_Literal";
         Node_Repr_Name_For_String_Literal : aliased constant Text_Type :=
           "StringLiteral";
      Node_Desc_For_String_Literal : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Sequence_Literal,
         Is_Abstract       => False,
         Is_Token_Node     => True,
         Is_List_Node      => False,
         Name              => Node_Name_For_String_Literal'Access,
         Repr_Name         => Node_Repr_Name_For_String_Literal'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Variable : aliased constant Text_Type :=
        "Variable";
         Node_Repr_Name_For_Variable : aliased constant Text_Type :=
           "Variable";
      Node_Desc_For_Variable : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Variable'Access,
         Repr_Name         => Node_Repr_Name_For_Variable'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Variable_F_Identifier
         ));
      
      Node_Name_For_Formal_Decl : aliased constant Text_Type :=
        "Formal_Decl";
         Node_Repr_Name_For_Formal_Decl : aliased constant Text_Type :=
           "FormalDecl";
      Node_Desc_For_Formal_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Formal_Decl'Access,
         Repr_Name         => Node_Repr_Name_For_Formal_Decl'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Formal_Channel_Decl,
2 => Type_Index_For_Formal_Function_Decl
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Formal_Channel_Decl : aliased constant Text_Type :=
        "Formal_Channel_Decl";
         Node_Repr_Name_For_Formal_Channel_Decl : aliased constant Text_Type :=
           "FormalChannelDecl";
      Node_Desc_For_Formal_Channel_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Formal_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Formal_Channel_Decl'Access,
         Repr_Name         => Node_Repr_Name_For_Formal_Channel_Decl'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Formal_Channel_Decl_F_Identifier,
2 => Member_Index_For_Formal_Channel_Decl_F_Parameters
         ));
      
      Node_Name_For_Formal_Function_Decl : aliased constant Text_Type :=
        "Formal_Function_Decl";
         Node_Repr_Name_For_Formal_Function_Decl : aliased constant Text_Type :=
           "FormalFunctionDecl";
      Node_Desc_For_Formal_Function_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Formal_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Formal_Function_Decl'Access,
         Repr_Name         => Node_Repr_Name_For_Formal_Function_Decl'Access,
         Inherited_Members => 14,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Formal_Function_Decl_F_Identifier,
2 => Member_Index_For_Formal_Function_Decl_F_Parameters,
3 => Member_Index_For_Formal_Function_Decl_F_Return_Type_Identifier
         ));
      
      Node_Name_For_Local_Decl : aliased constant Text_Type :=
        "Local_Decl";
         Node_Repr_Name_For_Local_Decl : aliased constant Text_Type :=
           "LocalDecl";
      Node_Desc_For_Local_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Local_Decl'Access,
         Repr_Name         => Node_Repr_Name_For_Local_Decl'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Renaming_Decl,
2 => Type_Index_For_Variable_Decl
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Renaming_Decl : aliased constant Text_Type :=
        "Renaming_Decl";
         Node_Repr_Name_For_Renaming_Decl : aliased constant Text_Type :=
           "RenamingDecl";
      Node_Desc_For_Renaming_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Local_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Renaming_Decl'Access,
         Repr_Name         => Node_Repr_Name_For_Renaming_Decl'Access,
         Inherited_Members => 14,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Renaming_Decl_F_Identifier,
2 => Member_Index_For_Renaming_Decl_F_Type_Identifier,
3 => Member_Index_For_Renaming_Decl_F_Expression
         ));
      
      Node_Name_For_Variable_Decl : aliased constant Text_Type :=
        "Variable_Decl";
         Node_Repr_Name_For_Variable_Decl : aliased constant Text_Type :=
           "VariableDecl";
      Node_Desc_For_Variable_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Local_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Variable_Decl'Access,
         Repr_Name         => Node_Repr_Name_For_Variable_Decl'Access,
         Inherited_Members => 14,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Variable_Decl_F_Identifier,
2 => Member_Index_For_Variable_Decl_F_Type_Identifier,
3 => Member_Index_For_Variable_Decl_F_Initializer
         ));
      
      Node_Name_For_Message_Aggregate_Association : aliased constant Text_Type :=
        "Message_Aggregate_Association";
         Node_Repr_Name_For_Message_Aggregate_Association : aliased constant Text_Type :=
           "MessageAggregateAssociation";
      Node_Desc_For_Message_Aggregate_Association : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Message_Aggregate_Association'Access,
         Repr_Name         => Node_Repr_Name_For_Message_Aggregate_Association'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Message_Aggregate_Association_F_Identifier,
2 => Member_Index_For_Message_Aggregate_Association_F_Expression
         ));
      
      Node_Name_For_Message_Aspect : aliased constant Text_Type :=
        "Message_Aspect";
         Node_Repr_Name_For_Message_Aspect : aliased constant Text_Type :=
           "MessageAspect";
      Node_Desc_For_Message_Aspect : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Message_Aspect'Access,
         Repr_Name         => Node_Repr_Name_For_Message_Aspect'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Byte_Order_Aspect,
2 => Type_Index_For_Checksum_Aspect
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Byte_Order_Aspect : aliased constant Text_Type :=
        "Byte_Order_Aspect";
         Node_Repr_Name_For_Byte_Order_Aspect : aliased constant Text_Type :=
           "ByteOrderAspect";
      Node_Desc_For_Byte_Order_Aspect : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Message_Aspect,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Byte_Order_Aspect'Access,
         Repr_Name         => Node_Repr_Name_For_Byte_Order_Aspect'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Byte_Order_Aspect_F_Byte_Order
         ));
      
      Node_Name_For_Checksum_Aspect : aliased constant Text_Type :=
        "Checksum_Aspect";
         Node_Repr_Name_For_Checksum_Aspect : aliased constant Text_Type :=
           "ChecksumAspect";
      Node_Desc_For_Checksum_Aspect : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Message_Aspect,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Checksum_Aspect'Access,
         Repr_Name         => Node_Repr_Name_For_Checksum_Aspect'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Checksum_Aspect_F_Associations
         ));
      
      Node_Name_For_Message_Field : aliased constant Text_Type :=
        "Message_Field";
         Node_Repr_Name_For_Message_Field : aliased constant Text_Type :=
           "MessageField";
      Node_Desc_For_Message_Field : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 6,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Message_Field'Access,
         Repr_Name         => Node_Repr_Name_For_Message_Field'Access,
         Inherited_Members => 17,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Message_Field_F_Identifier,
2 => Member_Index_For_Message_Field_F_Type_Identifier,
3 => Member_Index_For_Message_Field_F_Type_Arguments,
4 => Member_Index_For_Message_Field_F_Aspects,
5 => Member_Index_For_Message_Field_F_Condition,
6 => Member_Index_For_Message_Field_F_Thens
         ));
      
      Node_Name_For_Message_Fields : aliased constant Text_Type :=
        "Message_Fields";
         Node_Repr_Name_For_Message_Fields : aliased constant Text_Type :=
           "MessageFields";
      Node_Desc_For_Message_Fields : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Message_Fields'Access,
         Repr_Name         => Node_Repr_Name_For_Message_Fields'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Message_Fields_F_Initial_Field,
2 => Member_Index_For_Message_Fields_F_Fields
         ));
      
      Node_Name_For_Null_Message_Field : aliased constant Text_Type :=
        "Null_Message_Field";
         Node_Repr_Name_For_Null_Message_Field : aliased constant Text_Type :=
           "NullMessageField";
      Node_Desc_For_Null_Message_Field : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Null_Message_Field'Access,
         Repr_Name         => Node_Repr_Name_For_Null_Message_Field'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Null_Message_Field_F_Then
         ));
      
      Node_Name_For_Op : aliased constant Text_Type :=
        "Op";
         Node_Repr_Name_For_Op : aliased constant Text_Type :=
           "Op";
      Node_Desc_For_Op : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 16,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op'Access,
         Repr_Name         => Node_Repr_Name_For_Op'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Op_Add,
2 => Type_Index_For_Op_And,
3 => Type_Index_For_Op_Div,
4 => Type_Index_For_Op_Eq,
5 => Type_Index_For_Op_Ge,
6 => Type_Index_For_Op_Gt,
7 => Type_Index_For_Op_In,
8 => Type_Index_For_Op_Le,
9 => Type_Index_For_Op_Lt,
10 => Type_Index_For_Op_Mod,
11 => Type_Index_For_Op_Mul,
12 => Type_Index_For_Op_Neq,
13 => Type_Index_For_Op_Notin,
14 => Type_Index_For_Op_Or,
15 => Type_Index_For_Op_Pow,
16 => Type_Index_For_Op_Sub
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Add : aliased constant Text_Type :=
        "Op_Add";
         Node_Repr_Name_For_Op_Add : aliased constant Text_Type :=
           "OpAdd";
      Node_Desc_For_Op_Add : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Add'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Add'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_And : aliased constant Text_Type :=
        "Op_And";
         Node_Repr_Name_For_Op_And : aliased constant Text_Type :=
           "OpAnd";
      Node_Desc_For_Op_And : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_And'Access,
         Repr_Name         => Node_Repr_Name_For_Op_And'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Div : aliased constant Text_Type :=
        "Op_Div";
         Node_Repr_Name_For_Op_Div : aliased constant Text_Type :=
           "OpDiv";
      Node_Desc_For_Op_Div : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Div'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Div'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Eq : aliased constant Text_Type :=
        "Op_Eq";
         Node_Repr_Name_For_Op_Eq : aliased constant Text_Type :=
           "OpEq";
      Node_Desc_For_Op_Eq : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Eq'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Eq'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Ge : aliased constant Text_Type :=
        "Op_Ge";
         Node_Repr_Name_For_Op_Ge : aliased constant Text_Type :=
           "OpGe";
      Node_Desc_For_Op_Ge : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Ge'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Ge'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Gt : aliased constant Text_Type :=
        "Op_Gt";
         Node_Repr_Name_For_Op_Gt : aliased constant Text_Type :=
           "OpGt";
      Node_Desc_For_Op_Gt : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Gt'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Gt'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_In : aliased constant Text_Type :=
        "Op_In";
         Node_Repr_Name_For_Op_In : aliased constant Text_Type :=
           "OpIn";
      Node_Desc_For_Op_In : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_In'Access,
         Repr_Name         => Node_Repr_Name_For_Op_In'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Le : aliased constant Text_Type :=
        "Op_Le";
         Node_Repr_Name_For_Op_Le : aliased constant Text_Type :=
           "OpLe";
      Node_Desc_For_Op_Le : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Le'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Le'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Lt : aliased constant Text_Type :=
        "Op_Lt";
         Node_Repr_Name_For_Op_Lt : aliased constant Text_Type :=
           "OpLt";
      Node_Desc_For_Op_Lt : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Lt'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Lt'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Mod : aliased constant Text_Type :=
        "Op_Mod";
         Node_Repr_Name_For_Op_Mod : aliased constant Text_Type :=
           "OpMod";
      Node_Desc_For_Op_Mod : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Mod'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Mod'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Mul : aliased constant Text_Type :=
        "Op_Mul";
         Node_Repr_Name_For_Op_Mul : aliased constant Text_Type :=
           "OpMul";
      Node_Desc_For_Op_Mul : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Mul'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Mul'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Neq : aliased constant Text_Type :=
        "Op_Neq";
         Node_Repr_Name_For_Op_Neq : aliased constant Text_Type :=
           "OpNeq";
      Node_Desc_For_Op_Neq : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Neq'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Neq'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Notin : aliased constant Text_Type :=
        "Op_Notin";
         Node_Repr_Name_For_Op_Notin : aliased constant Text_Type :=
           "OpNotin";
      Node_Desc_For_Op_Notin : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Notin'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Notin'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Or : aliased constant Text_Type :=
        "Op_Or";
         Node_Repr_Name_For_Op_Or : aliased constant Text_Type :=
           "OpOr";
      Node_Desc_For_Op_Or : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Or'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Or'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Pow : aliased constant Text_Type :=
        "Op_Pow";
         Node_Repr_Name_For_Op_Pow : aliased constant Text_Type :=
           "OpPow";
      Node_Desc_For_Op_Pow : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Pow'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Pow'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Sub : aliased constant Text_Type :=
        "Op_Sub";
         Node_Repr_Name_For_Op_Sub : aliased constant Text_Type :=
           "OpSub";
      Node_Desc_For_Op_Sub : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op_Sub'Access,
         Repr_Name         => Node_Repr_Name_For_Op_Sub'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Package_Node : aliased constant Text_Type :=
        "Package_Node";
         Node_Repr_Name_For_Package_Node : aliased constant Text_Type :=
           "PackageNode";
      Node_Desc_For_Package_Node : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Package_Node'Access,
         Repr_Name         => Node_Repr_Name_For_Package_Node'Access,
         Inherited_Members => 14,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Package_Node_F_Identifier,
2 => Member_Index_For_Package_Node_F_Declarations,
3 => Member_Index_For_Package_Node_F_End_Identifier
         ));
      
      Node_Name_For_Parameter : aliased constant Text_Type :=
        "Parameter";
         Node_Repr_Name_For_Parameter : aliased constant Text_Type :=
           "Parameter";
      Node_Desc_For_Parameter : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Parameter'Access,
         Repr_Name         => Node_Repr_Name_For_Parameter'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Parameter_F_Identifier,
2 => Member_Index_For_Parameter_F_Type_Identifier
         ));
      
      Node_Name_For_Parameters : aliased constant Text_Type :=
        "Parameters";
         Node_Repr_Name_For_Parameters : aliased constant Text_Type :=
           "Parameters";
      Node_Desc_For_Parameters : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Parameters'Access,
         Repr_Name         => Node_Repr_Name_For_Parameters'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Parameters_F_Parameters
         ));
      
      Node_Name_For_Quantifier : aliased constant Text_Type :=
        "Quantifier";
         Node_Repr_Name_For_Quantifier : aliased constant Text_Type :=
           "Quantifier";
      Node_Desc_For_Quantifier : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Quantifier'Access,
         Repr_Name         => Node_Repr_Name_For_Quantifier'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Quantifier_All,
2 => Type_Index_For_Quantifier_Some
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Quantifier_All : aliased constant Text_Type :=
        "Quantifier_All";
         Node_Repr_Name_For_Quantifier_All : aliased constant Text_Type :=
           "QuantifierAll";
      Node_Desc_For_Quantifier_All : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Quantifier,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Quantifier_All'Access,
         Repr_Name         => Node_Repr_Name_For_Quantifier_All'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Quantifier_Some : aliased constant Text_Type :=
        "Quantifier_Some";
         Node_Repr_Name_For_Quantifier_Some : aliased constant Text_Type :=
           "QuantifierSome";
      Node_Desc_For_Quantifier_Some : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Quantifier,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Quantifier_Some'Access,
         Repr_Name         => Node_Repr_Name_For_Quantifier_Some'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_R_F_L_X_Node_Base_List : aliased constant Text_Type :=
        "R_F_L_X_Node_Base_List";
         Node_Repr_Name_For_R_F_L_X_Node_Base_List : aliased constant Text_Type :=
           "RFLXNodeBaseList";
      Node_Desc_For_R_F_L_X_Node_Base_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 24,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_R_F_L_X_Node_Base_List'Access,
         Repr_Name         => Node_Repr_Name_For_R_F_L_X_Node_Base_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Aspect_List,
2 => Type_Index_For_Base_Checksum_Val_List,
3 => Type_Index_For_Channel_Attribute_List,
4 => Type_Index_For_Checksum_Assoc_List,
5 => Type_Index_For_Choice_List,
6 => Type_Index_For_Conditional_Transition_List,
7 => Type_Index_For_Context_Item_List,
8 => Type_Index_For_Declaration_List,
9 => Type_Index_For_Element_Value_Assoc_List,
10 => Type_Index_For_Expr_List,
11 => Type_Index_For_Formal_Decl_List,
12 => Type_Index_For_Local_Decl_List,
13 => Type_Index_For_Message_Aggregate_Association_List,
14 => Type_Index_For_Message_Aspect_List,
15 => Type_Index_For_Message_Field_List,
16 => Type_Index_For_Numeric_Literal_List,
17 => Type_Index_For_Parameter_List,
18 => Type_Index_For_R_F_L_X_Node_List,
19 => Type_Index_For_State_List,
20 => Type_Index_For_Statement_List,
21 => Type_Index_For_Term_Assoc_List,
22 => Type_Index_For_Then_Node_List,
23 => Type_Index_For_Type_Argument_List,
24 => Type_Index_For_Unqualified_I_D_List
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Aspect_List : aliased constant Text_Type :=
        "Aspect_List";
         Node_Repr_Name_For_Aspect_List : aliased constant Text_Type :=
           "AspectList";
      Node_Desc_For_Aspect_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Aspect_List'Access,
         Repr_Name         => Node_Repr_Name_For_Aspect_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Base_Checksum_Val_List : aliased constant Text_Type :=
        "Base_Checksum_Val_List";
         Node_Repr_Name_For_Base_Checksum_Val_List : aliased constant Text_Type :=
           "BaseChecksumValList";
      Node_Desc_For_Base_Checksum_Val_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Base_Checksum_Val_List'Access,
         Repr_Name         => Node_Repr_Name_For_Base_Checksum_Val_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Channel_Attribute_List : aliased constant Text_Type :=
        "Channel_Attribute_List";
         Node_Repr_Name_For_Channel_Attribute_List : aliased constant Text_Type :=
           "ChannelAttributeList";
      Node_Desc_For_Channel_Attribute_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Channel_Attribute_List'Access,
         Repr_Name         => Node_Repr_Name_For_Channel_Attribute_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Checksum_Assoc_List : aliased constant Text_Type :=
        "Checksum_Assoc_List";
         Node_Repr_Name_For_Checksum_Assoc_List : aliased constant Text_Type :=
           "ChecksumAssocList";
      Node_Desc_For_Checksum_Assoc_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Checksum_Assoc_List'Access,
         Repr_Name         => Node_Repr_Name_For_Checksum_Assoc_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Choice_List : aliased constant Text_Type :=
        "Choice_List";
         Node_Repr_Name_For_Choice_List : aliased constant Text_Type :=
           "ChoiceList";
      Node_Desc_For_Choice_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Choice_List'Access,
         Repr_Name         => Node_Repr_Name_For_Choice_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Conditional_Transition_List : aliased constant Text_Type :=
        "Conditional_Transition_List";
         Node_Repr_Name_For_Conditional_Transition_List : aliased constant Text_Type :=
           "ConditionalTransitionList";
      Node_Desc_For_Conditional_Transition_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Conditional_Transition_List'Access,
         Repr_Name         => Node_Repr_Name_For_Conditional_Transition_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Context_Item_List : aliased constant Text_Type :=
        "Context_Item_List";
         Node_Repr_Name_For_Context_Item_List : aliased constant Text_Type :=
           "ContextItemList";
      Node_Desc_For_Context_Item_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Context_Item_List'Access,
         Repr_Name         => Node_Repr_Name_For_Context_Item_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Declaration_List : aliased constant Text_Type :=
        "Declaration_List";
         Node_Repr_Name_For_Declaration_List : aliased constant Text_Type :=
           "DeclarationList";
      Node_Desc_For_Declaration_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Declaration_List'Access,
         Repr_Name         => Node_Repr_Name_For_Declaration_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Element_Value_Assoc_List : aliased constant Text_Type :=
        "Element_Value_Assoc_List";
         Node_Repr_Name_For_Element_Value_Assoc_List : aliased constant Text_Type :=
           "ElementValueAssocList";
      Node_Desc_For_Element_Value_Assoc_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Element_Value_Assoc_List'Access,
         Repr_Name         => Node_Repr_Name_For_Element_Value_Assoc_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Expr_List : aliased constant Text_Type :=
        "Expr_List";
         Node_Repr_Name_For_Expr_List : aliased constant Text_Type :=
           "ExprList";
      Node_Desc_For_Expr_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Expr_List'Access,
         Repr_Name         => Node_Repr_Name_For_Expr_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Formal_Decl_List : aliased constant Text_Type :=
        "Formal_Decl_List";
         Node_Repr_Name_For_Formal_Decl_List : aliased constant Text_Type :=
           "FormalDeclList";
      Node_Desc_For_Formal_Decl_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Formal_Decl_List'Access,
         Repr_Name         => Node_Repr_Name_For_Formal_Decl_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Local_Decl_List : aliased constant Text_Type :=
        "Local_Decl_List";
         Node_Repr_Name_For_Local_Decl_List : aliased constant Text_Type :=
           "LocalDeclList";
      Node_Desc_For_Local_Decl_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Local_Decl_List'Access,
         Repr_Name         => Node_Repr_Name_For_Local_Decl_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Message_Aggregate_Association_List : aliased constant Text_Type :=
        "Message_Aggregate_Association_List";
         Node_Repr_Name_For_Message_Aggregate_Association_List : aliased constant Text_Type :=
           "MessageAggregateAssociationList";
      Node_Desc_For_Message_Aggregate_Association_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Message_Aggregate_Association_List'Access,
         Repr_Name         => Node_Repr_Name_For_Message_Aggregate_Association_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Message_Aspect_List : aliased constant Text_Type :=
        "Message_Aspect_List";
         Node_Repr_Name_For_Message_Aspect_List : aliased constant Text_Type :=
           "MessageAspectList";
      Node_Desc_For_Message_Aspect_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Message_Aspect_List'Access,
         Repr_Name         => Node_Repr_Name_For_Message_Aspect_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Message_Field_List : aliased constant Text_Type :=
        "Message_Field_List";
         Node_Repr_Name_For_Message_Field_List : aliased constant Text_Type :=
           "MessageFieldList";
      Node_Desc_For_Message_Field_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Message_Field_List'Access,
         Repr_Name         => Node_Repr_Name_For_Message_Field_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Numeric_Literal_List : aliased constant Text_Type :=
        "Numeric_Literal_List";
         Node_Repr_Name_For_Numeric_Literal_List : aliased constant Text_Type :=
           "NumericLiteralList";
      Node_Desc_For_Numeric_Literal_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Numeric_Literal_List'Access,
         Repr_Name         => Node_Repr_Name_For_Numeric_Literal_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Parameter_List : aliased constant Text_Type :=
        "Parameter_List";
         Node_Repr_Name_For_Parameter_List : aliased constant Text_Type :=
           "ParameterList";
      Node_Desc_For_Parameter_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Parameter_List'Access,
         Repr_Name         => Node_Repr_Name_For_Parameter_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_R_F_L_X_Node_List : aliased constant Text_Type :=
        "R_F_L_X_Node_List";
         Node_Repr_Name_For_R_F_L_X_Node_List : aliased constant Text_Type :=
           "RFLXNodeList";
      Node_Desc_For_R_F_L_X_Node_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_R_F_L_X_Node_List'Access,
         Repr_Name         => Node_Repr_Name_For_R_F_L_X_Node_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_State_List : aliased constant Text_Type :=
        "State_List";
         Node_Repr_Name_For_State_List : aliased constant Text_Type :=
           "StateList";
      Node_Desc_For_State_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_State_List'Access,
         Repr_Name         => Node_Repr_Name_For_State_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Statement_List : aliased constant Text_Type :=
        "Statement_List";
         Node_Repr_Name_For_Statement_List : aliased constant Text_Type :=
           "StatementList";
      Node_Desc_For_Statement_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Statement_List'Access,
         Repr_Name         => Node_Repr_Name_For_Statement_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Term_Assoc_List : aliased constant Text_Type :=
        "Term_Assoc_List";
         Node_Repr_Name_For_Term_Assoc_List : aliased constant Text_Type :=
           "TermAssocList";
      Node_Desc_For_Term_Assoc_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Term_Assoc_List'Access,
         Repr_Name         => Node_Repr_Name_For_Term_Assoc_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Then_Node_List : aliased constant Text_Type :=
        "Then_Node_List";
         Node_Repr_Name_For_Then_Node_List : aliased constant Text_Type :=
           "ThenNodeList";
      Node_Desc_For_Then_Node_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Then_Node_List'Access,
         Repr_Name         => Node_Repr_Name_For_Then_Node_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Type_Argument_List : aliased constant Text_Type :=
        "Type_Argument_List";
         Node_Repr_Name_For_Type_Argument_List : aliased constant Text_Type :=
           "TypeArgumentList";
      Node_Desc_For_Type_Argument_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Type_Argument_List'Access,
         Repr_Name         => Node_Repr_Name_For_Type_Argument_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Unqualified_I_D_List : aliased constant Text_Type :=
        "Unqualified_I_D_List";
         Node_Repr_Name_For_Unqualified_I_D_List : aliased constant Text_Type :=
           "UnqualifiedIDList";
      Node_Desc_For_Unqualified_I_D_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node_Base_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Unqualified_I_D_List'Access,
         Repr_Name         => Node_Repr_Name_For_Unqualified_I_D_List'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Specification : aliased constant Text_Type :=
        "Specification";
         Node_Repr_Name_For_Specification : aliased constant Text_Type :=
           "Specification";
      Node_Desc_For_Specification : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Specification'Access,
         Repr_Name         => Node_Repr_Name_For_Specification'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Specification_F_Context_Clause,
2 => Member_Index_For_Specification_F_Package_Declaration
         ));
      
      Node_Name_For_State : aliased constant Text_Type :=
        "State";
         Node_Repr_Name_For_State : aliased constant Text_Type :=
           "State";
      Node_Desc_For_State : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_State'Access,
         Repr_Name         => Node_Repr_Name_For_State'Access,
         Inherited_Members => 14,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_State_F_Identifier,
2 => Member_Index_For_State_F_Description,
3 => Member_Index_For_State_F_Body
         ));
      
      Node_Name_For_State_Body : aliased constant Text_Type :=
        "State_Body";
         Node_Repr_Name_For_State_Body : aliased constant Text_Type :=
           "StateBody";
      Node_Desc_For_State_Body : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 6,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_State_Body'Access,
         Repr_Name         => Node_Repr_Name_For_State_Body'Access,
         Inherited_Members => 17,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_State_Body_F_Declarations,
2 => Member_Index_For_State_Body_F_Actions,
3 => Member_Index_For_State_Body_F_Conditional_Transitions,
4 => Member_Index_For_State_Body_F_Final_Transition,
5 => Member_Index_For_State_Body_F_Exception_Transition,
6 => Member_Index_For_State_Body_F_End_Identifier
         ));
      
      Node_Name_For_Statement : aliased constant Text_Type :=
        "Statement";
         Node_Repr_Name_For_Statement : aliased constant Text_Type :=
           "Statement";
      Node_Desc_For_Statement : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 4,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Statement'Access,
         Repr_Name         => Node_Repr_Name_For_Statement'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Assignment,
2 => Type_Index_For_Attribute_Statement,
3 => Type_Index_For_Message_Field_Assignment,
4 => Type_Index_For_Reset
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Assignment : aliased constant Text_Type :=
        "Assignment";
         Node_Repr_Name_For_Assignment : aliased constant Text_Type :=
           "Assignment";
      Node_Desc_For_Assignment : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Statement,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Assignment'Access,
         Repr_Name         => Node_Repr_Name_For_Assignment'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Assignment_F_Identifier,
2 => Member_Index_For_Assignment_F_Expression
         ));
      
      Node_Name_For_Attribute_Statement : aliased constant Text_Type :=
        "Attribute_Statement";
         Node_Repr_Name_For_Attribute_Statement : aliased constant Text_Type :=
           "AttributeStatement";
      Node_Desc_For_Attribute_Statement : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Statement,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attribute_Statement'Access,
         Repr_Name         => Node_Repr_Name_For_Attribute_Statement'Access,
         Inherited_Members => 14,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Attribute_Statement_F_Identifier,
2 => Member_Index_For_Attribute_Statement_F_Attr,
3 => Member_Index_For_Attribute_Statement_F_Expression
         ));
      
      Node_Name_For_Message_Field_Assignment : aliased constant Text_Type :=
        "Message_Field_Assignment";
         Node_Repr_Name_For_Message_Field_Assignment : aliased constant Text_Type :=
           "MessageFieldAssignment";
      Node_Desc_For_Message_Field_Assignment : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Statement,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Message_Field_Assignment'Access,
         Repr_Name         => Node_Repr_Name_For_Message_Field_Assignment'Access,
         Inherited_Members => 14,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Message_Field_Assignment_F_Message,
2 => Member_Index_For_Message_Field_Assignment_F_Field,
3 => Member_Index_For_Message_Field_Assignment_F_Expression
         ));
      
      Node_Name_For_Reset : aliased constant Text_Type :=
        "Reset";
         Node_Repr_Name_For_Reset : aliased constant Text_Type :=
           "Reset";
      Node_Desc_For_Reset : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Statement,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Reset'Access,
         Repr_Name         => Node_Repr_Name_For_Reset'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Reset_F_Identifier,
2 => Member_Index_For_Reset_F_Associations
         ));
      
      Node_Name_For_Term_Assoc : aliased constant Text_Type :=
        "Term_Assoc";
         Node_Repr_Name_For_Term_Assoc : aliased constant Text_Type :=
           "TermAssoc";
      Node_Desc_For_Term_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Term_Assoc'Access,
         Repr_Name         => Node_Repr_Name_For_Term_Assoc'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Term_Assoc_F_Identifier,
2 => Member_Index_For_Term_Assoc_F_Expression
         ));
      
      Node_Name_For_Then_Node : aliased constant Text_Type :=
        "Then_Node";
         Node_Repr_Name_For_Then_Node : aliased constant Text_Type :=
           "ThenNode";
      Node_Desc_For_Then_Node : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Then_Node'Access,
         Repr_Name         => Node_Repr_Name_For_Then_Node'Access,
         Inherited_Members => 14,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Then_Node_F_Target,
2 => Member_Index_For_Then_Node_F_Aspects,
3 => Member_Index_For_Then_Node_F_Condition
         ));
      
      Node_Name_For_Transition : aliased constant Text_Type :=
        "Transition";
         Node_Repr_Name_For_Transition : aliased constant Text_Type :=
           "Transition";
      Node_Desc_For_Transition : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Transition'Access,
         Repr_Name         => Node_Repr_Name_For_Transition'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 => Type_Index_For_Conditional_Transition
         ),
         Members           => (
              1 => Member_Index_For_Transition_F_Target,
2 => Member_Index_For_Transition_F_Description
         ));
      
      Node_Name_For_Conditional_Transition : aliased constant Text_Type :=
        "Conditional_Transition";
         Node_Repr_Name_For_Conditional_Transition : aliased constant Text_Type :=
           "ConditionalTransition";
      Node_Desc_For_Conditional_Transition : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Transition,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Conditional_Transition'Access,
         Repr_Name         => Node_Repr_Name_For_Conditional_Transition'Access,
         Inherited_Members => 14,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Conditional_Transition_F_Condition
         ));
      
      Node_Name_For_Type_Argument : aliased constant Text_Type :=
        "Type_Argument";
         Node_Repr_Name_For_Type_Argument : aliased constant Text_Type :=
           "TypeArgument";
      Node_Desc_For_Type_Argument : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Type_Argument'Access,
         Repr_Name         => Node_Repr_Name_For_Type_Argument'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Type_Argument_F_Identifier,
2 => Member_Index_For_Type_Argument_F_Expression
         ));
      
      Node_Name_For_Type_Def : aliased constant Text_Type :=
        "Type_Def";
         Node_Repr_Name_For_Type_Def : aliased constant Text_Type :=
           "TypeDef";
      Node_Desc_For_Type_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 6,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_R_F_L_X_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Type_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Type_Def'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Abstract_Message_Type_Def,
2 => Type_Index_For_Enumeration_Def,
3 => Type_Index_For_Enumeration_Type_Def,
4 => Type_Index_For_Integer_Type_Def,
5 => Type_Index_For_Sequence_Type_Def,
6 => Type_Index_For_Type_Derivation_Def
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Abstract_Message_Type_Def : aliased constant Text_Type :=
        "Abstract_Message_Type_Def";
         Node_Repr_Name_For_Abstract_Message_Type_Def : aliased constant Text_Type :=
           "AbstractMessageTypeDef";
      Node_Desc_For_Abstract_Message_Type_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Type_Def,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Abstract_Message_Type_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Abstract_Message_Type_Def'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Message_Type_Def,
2 => Type_Index_For_Null_Message_Type_Def
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Message_Type_Def : aliased constant Text_Type :=
        "Message_Type_Def";
         Node_Repr_Name_For_Message_Type_Def : aliased constant Text_Type :=
           "MessageTypeDef";
      Node_Desc_For_Message_Type_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Abstract_Message_Type_Def,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Message_Type_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Message_Type_Def'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Message_Type_Def_F_Message_Fields,
2 => Member_Index_For_Message_Type_Def_F_Aspects
         ));
      
      Node_Name_For_Null_Message_Type_Def : aliased constant Text_Type :=
        "Null_Message_Type_Def";
         Node_Repr_Name_For_Null_Message_Type_Def : aliased constant Text_Type :=
           "NullMessageTypeDef";
      Node_Desc_For_Null_Message_Type_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Abstract_Message_Type_Def,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Null_Message_Type_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Null_Message_Type_Def'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Enumeration_Def : aliased constant Text_Type :=
        "Enumeration_Def";
         Node_Repr_Name_For_Enumeration_Def : aliased constant Text_Type :=
           "EnumerationDef";
      Node_Desc_For_Enumeration_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Type_Def,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Enumeration_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Enumeration_Def'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Named_Enumeration_Def,
2 => Type_Index_For_Positional_Enumeration_Def
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Named_Enumeration_Def : aliased constant Text_Type :=
        "Named_Enumeration_Def";
         Node_Repr_Name_For_Named_Enumeration_Def : aliased constant Text_Type :=
           "NamedEnumerationDef";
      Node_Desc_For_Named_Enumeration_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Enumeration_Def,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Named_Enumeration_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Named_Enumeration_Def'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Named_Enumeration_Def_F_Elements
         ));
      
      Node_Name_For_Positional_Enumeration_Def : aliased constant Text_Type :=
        "Positional_Enumeration_Def";
         Node_Repr_Name_For_Positional_Enumeration_Def : aliased constant Text_Type :=
           "PositionalEnumerationDef";
      Node_Desc_For_Positional_Enumeration_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Enumeration_Def,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Positional_Enumeration_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Positional_Enumeration_Def'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Positional_Enumeration_Def_F_Elements
         ));
      
      Node_Name_For_Enumeration_Type_Def : aliased constant Text_Type :=
        "Enumeration_Type_Def";
         Node_Repr_Name_For_Enumeration_Type_Def : aliased constant Text_Type :=
           "EnumerationTypeDef";
      Node_Desc_For_Enumeration_Type_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Type_Def,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Enumeration_Type_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Enumeration_Type_Def'Access,
         Inherited_Members => 13,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Enumeration_Type_Def_F_Elements,
2 => Member_Index_For_Enumeration_Type_Def_F_Aspects
         ));
      
      Node_Name_For_Integer_Type_Def : aliased constant Text_Type :=
        "Integer_Type_Def";
         Node_Repr_Name_For_Integer_Type_Def : aliased constant Text_Type :=
           "IntegerTypeDef";
      Node_Desc_For_Integer_Type_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Type_Def,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Integer_Type_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Integer_Type_Def'Access,
         Inherited_Members => 11,
         Derivations       => (
             1 => Type_Index_For_Modular_Type_Def,
2 => Type_Index_For_Range_Type_Def
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Modular_Type_Def : aliased constant Text_Type :=
        "Modular_Type_Def";
         Node_Repr_Name_For_Modular_Type_Def : aliased constant Text_Type :=
           "ModularTypeDef";
      Node_Desc_For_Modular_Type_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Integer_Type_Def,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Modular_Type_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Modular_Type_Def'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Modular_Type_Def_F_Mod
         ));
      
      Node_Name_For_Range_Type_Def : aliased constant Text_Type :=
        "Range_Type_Def";
         Node_Repr_Name_For_Range_Type_Def : aliased constant Text_Type :=
           "RangeTypeDef";
      Node_Desc_For_Range_Type_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Integer_Type_Def,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Range_Type_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Range_Type_Def'Access,
         Inherited_Members => 14,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Range_Type_Def_F_First,
2 => Member_Index_For_Range_Type_Def_F_Last,
3 => Member_Index_For_Range_Type_Def_F_Size
         ));
      
      Node_Name_For_Sequence_Type_Def : aliased constant Text_Type :=
        "Sequence_Type_Def";
         Node_Repr_Name_For_Sequence_Type_Def : aliased constant Text_Type :=
           "SequenceTypeDef";
      Node_Desc_For_Sequence_Type_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Type_Def,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Sequence_Type_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Sequence_Type_Def'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Sequence_Type_Def_F_Element_Type
         ));
      
      Node_Name_For_Type_Derivation_Def : aliased constant Text_Type :=
        "Type_Derivation_Def";
         Node_Repr_Name_For_Type_Derivation_Def : aliased constant Text_Type :=
           "TypeDerivationDef";
      Node_Desc_For_Type_Derivation_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Type_Def,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Type_Derivation_Def'Access,
         Repr_Name         => Node_Repr_Name_For_Type_Derivation_Def'Access,
         Inherited_Members => 12,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Type_Derivation_Def_F_Base
         ));

   Struct_Types : aliased constant Struct_Type_Descriptor_Array := (
      Type_Index_For_R_F_L_X_Node => Node_Desc_For_R_F_L_X_Node'Access,
Type_Index_For_Abstract_I_D => Node_Desc_For_Abstract_I_D'Access,
Type_Index_For_I_D => Node_Desc_For_I_D'Access,
Type_Index_For_Unqualified_I_D => Node_Desc_For_Unqualified_I_D'Access,
Type_Index_For_Aspect => Node_Desc_For_Aspect'Access,
Type_Index_For_Attr => Node_Desc_For_Attr'Access,
Type_Index_For_Attr_First => Node_Desc_For_Attr_First'Access,
Type_Index_For_Attr_Has_Data => Node_Desc_For_Attr_Has_Data'Access,
Type_Index_For_Attr_Head => Node_Desc_For_Attr_Head'Access,
Type_Index_For_Attr_Last => Node_Desc_For_Attr_Last'Access,
Type_Index_For_Attr_Opaque => Node_Desc_For_Attr_Opaque'Access,
Type_Index_For_Attr_Present => Node_Desc_For_Attr_Present'Access,
Type_Index_For_Attr_Size => Node_Desc_For_Attr_Size'Access,
Type_Index_For_Attr_Valid => Node_Desc_For_Attr_Valid'Access,
Type_Index_For_Attr_Valid_Checksum => Node_Desc_For_Attr_Valid_Checksum'Access,
Type_Index_For_Attr_Stmt => Node_Desc_For_Attr_Stmt'Access,
Type_Index_For_Attr_Stmt_Append => Node_Desc_For_Attr_Stmt_Append'Access,
Type_Index_For_Attr_Stmt_Extend => Node_Desc_For_Attr_Stmt_Extend'Access,
Type_Index_For_Attr_Stmt_Read => Node_Desc_For_Attr_Stmt_Read'Access,
Type_Index_For_Attr_Stmt_Write => Node_Desc_For_Attr_Stmt_Write'Access,
Type_Index_For_Base_Aggregate => Node_Desc_For_Base_Aggregate'Access,
Type_Index_For_Message_Aggregate_Associations => Node_Desc_For_Message_Aggregate_Associations'Access,
Type_Index_For_Null_Message_Aggregate => Node_Desc_For_Null_Message_Aggregate'Access,
Type_Index_For_Base_Checksum_Val => Node_Desc_For_Base_Checksum_Val'Access,
Type_Index_For_Checksum_Val => Node_Desc_For_Checksum_Val'Access,
Type_Index_For_Checksum_Value_Range => Node_Desc_For_Checksum_Value_Range'Access,
Type_Index_For_Byte_Order_Type => Node_Desc_For_Byte_Order_Type'Access,
Type_Index_For_Byte_Order_Type_Highorderfirst => Node_Desc_For_Byte_Order_Type_Highorderfirst'Access,
Type_Index_For_Byte_Order_Type_Loworderfirst => Node_Desc_For_Byte_Order_Type_Loworderfirst'Access,
Type_Index_For_Channel_Attribute => Node_Desc_For_Channel_Attribute'Access,
Type_Index_For_Readable => Node_Desc_For_Readable'Access,
Type_Index_For_Writable => Node_Desc_For_Writable'Access,
Type_Index_For_Checksum_Assoc => Node_Desc_For_Checksum_Assoc'Access,
Type_Index_For_Declaration => Node_Desc_For_Declaration'Access,
Type_Index_For_Refinement_Decl => Node_Desc_For_Refinement_Decl'Access,
Type_Index_For_Session_Decl => Node_Desc_For_Session_Decl'Access,
Type_Index_For_Type_Decl => Node_Desc_For_Type_Decl'Access,
Type_Index_For_Description => Node_Desc_For_Description'Access,
Type_Index_For_Element_Value_Assoc => Node_Desc_For_Element_Value_Assoc'Access,
Type_Index_For_Expr => Node_Desc_For_Expr'Access,
Type_Index_For_Attribute => Node_Desc_For_Attribute'Access,
Type_Index_For_Bin_Op => Node_Desc_For_Bin_Op'Access,
Type_Index_For_Binding => Node_Desc_For_Binding'Access,
Type_Index_For_Call => Node_Desc_For_Call'Access,
Type_Index_For_Case_Expression => Node_Desc_For_Case_Expression'Access,
Type_Index_For_Choice => Node_Desc_For_Choice'Access,
Type_Index_For_Comprehension => Node_Desc_For_Comprehension'Access,
Type_Index_For_Context_Item => Node_Desc_For_Context_Item'Access,
Type_Index_For_Conversion => Node_Desc_For_Conversion'Access,
Type_Index_For_Message_Aggregate => Node_Desc_For_Message_Aggregate'Access,
Type_Index_For_Negation => Node_Desc_For_Negation'Access,
Type_Index_For_Numeric_Literal => Node_Desc_For_Numeric_Literal'Access,
Type_Index_For_Paren_Expression => Node_Desc_For_Paren_Expression'Access,
Type_Index_For_Quantified_Expression => Node_Desc_For_Quantified_Expression'Access,
Type_Index_For_Select => Node_Desc_For_Select_Node'Access,
Type_Index_For_Sequence_Literal => Node_Desc_For_Sequence_Literal'Access,
Type_Index_For_Concatenation => Node_Desc_For_Concatenation'Access,
Type_Index_For_Sequence_Aggregate => Node_Desc_For_Sequence_Aggregate'Access,
Type_Index_For_String_Literal => Node_Desc_For_String_Literal'Access,
Type_Index_For_Variable => Node_Desc_For_Variable'Access,
Type_Index_For_Formal_Decl => Node_Desc_For_Formal_Decl'Access,
Type_Index_For_Formal_Channel_Decl => Node_Desc_For_Formal_Channel_Decl'Access,
Type_Index_For_Formal_Function_Decl => Node_Desc_For_Formal_Function_Decl'Access,
Type_Index_For_Local_Decl => Node_Desc_For_Local_Decl'Access,
Type_Index_For_Renaming_Decl => Node_Desc_For_Renaming_Decl'Access,
Type_Index_For_Variable_Decl => Node_Desc_For_Variable_Decl'Access,
Type_Index_For_Message_Aggregate_Association => Node_Desc_For_Message_Aggregate_Association'Access,
Type_Index_For_Message_Aspect => Node_Desc_For_Message_Aspect'Access,
Type_Index_For_Byte_Order_Aspect => Node_Desc_For_Byte_Order_Aspect'Access,
Type_Index_For_Checksum_Aspect => Node_Desc_For_Checksum_Aspect'Access,
Type_Index_For_Message_Field => Node_Desc_For_Message_Field'Access,
Type_Index_For_Message_Fields => Node_Desc_For_Message_Fields'Access,
Type_Index_For_Null_Message_Field => Node_Desc_For_Null_Message_Field'Access,
Type_Index_For_Op => Node_Desc_For_Op'Access,
Type_Index_For_Op_Add => Node_Desc_For_Op_Add'Access,
Type_Index_For_Op_And => Node_Desc_For_Op_And'Access,
Type_Index_For_Op_Div => Node_Desc_For_Op_Div'Access,
Type_Index_For_Op_Eq => Node_Desc_For_Op_Eq'Access,
Type_Index_For_Op_Ge => Node_Desc_For_Op_Ge'Access,
Type_Index_For_Op_Gt => Node_Desc_For_Op_Gt'Access,
Type_Index_For_Op_In => Node_Desc_For_Op_In'Access,
Type_Index_For_Op_Le => Node_Desc_For_Op_Le'Access,
Type_Index_For_Op_Lt => Node_Desc_For_Op_Lt'Access,
Type_Index_For_Op_Mod => Node_Desc_For_Op_Mod'Access,
Type_Index_For_Op_Mul => Node_Desc_For_Op_Mul'Access,
Type_Index_For_Op_Neq => Node_Desc_For_Op_Neq'Access,
Type_Index_For_Op_Notin => Node_Desc_For_Op_Notin'Access,
Type_Index_For_Op_Or => Node_Desc_For_Op_Or'Access,
Type_Index_For_Op_Pow => Node_Desc_For_Op_Pow'Access,
Type_Index_For_Op_Sub => Node_Desc_For_Op_Sub'Access,
Type_Index_For_Package => Node_Desc_For_Package_Node'Access,
Type_Index_For_Parameter => Node_Desc_For_Parameter'Access,
Type_Index_For_Parameters => Node_Desc_For_Parameters'Access,
Type_Index_For_Quantifier => Node_Desc_For_Quantifier'Access,
Type_Index_For_Quantifier_All => Node_Desc_For_Quantifier_All'Access,
Type_Index_For_Quantifier_Some => Node_Desc_For_Quantifier_Some'Access,
Type_Index_For_R_F_L_X_Node_Base_List => Node_Desc_For_R_F_L_X_Node_Base_List'Access,
Type_Index_For_Aspect_List => Node_Desc_For_Aspect_List'Access,
Type_Index_For_Base_Checksum_Val_List => Node_Desc_For_Base_Checksum_Val_List'Access,
Type_Index_For_Channel_Attribute_List => Node_Desc_For_Channel_Attribute_List'Access,
Type_Index_For_Checksum_Assoc_List => Node_Desc_For_Checksum_Assoc_List'Access,
Type_Index_For_Choice_List => Node_Desc_For_Choice_List'Access,
Type_Index_For_Conditional_Transition_List => Node_Desc_For_Conditional_Transition_List'Access,
Type_Index_For_Context_Item_List => Node_Desc_For_Context_Item_List'Access,
Type_Index_For_Declaration_List => Node_Desc_For_Declaration_List'Access,
Type_Index_For_Element_Value_Assoc_List => Node_Desc_For_Element_Value_Assoc_List'Access,
Type_Index_For_Expr_List => Node_Desc_For_Expr_List'Access,
Type_Index_For_Formal_Decl_List => Node_Desc_For_Formal_Decl_List'Access,
Type_Index_For_Local_Decl_List => Node_Desc_For_Local_Decl_List'Access,
Type_Index_For_Message_Aggregate_Association_List => Node_Desc_For_Message_Aggregate_Association_List'Access,
Type_Index_For_Message_Aspect_List => Node_Desc_For_Message_Aspect_List'Access,
Type_Index_For_Message_Field_List => Node_Desc_For_Message_Field_List'Access,
Type_Index_For_Numeric_Literal_List => Node_Desc_For_Numeric_Literal_List'Access,
Type_Index_For_Parameter_List => Node_Desc_For_Parameter_List'Access,
Type_Index_For_R_F_L_X_Node_List => Node_Desc_For_R_F_L_X_Node_List'Access,
Type_Index_For_State_List => Node_Desc_For_State_List'Access,
Type_Index_For_Statement_List => Node_Desc_For_Statement_List'Access,
Type_Index_For_Term_Assoc_List => Node_Desc_For_Term_Assoc_List'Access,
Type_Index_For_Then_Node_List => Node_Desc_For_Then_Node_List'Access,
Type_Index_For_Type_Argument_List => Node_Desc_For_Type_Argument_List'Access,
Type_Index_For_Unqualified_I_D_List => Node_Desc_For_Unqualified_I_D_List'Access,
Type_Index_For_Specification => Node_Desc_For_Specification'Access,
Type_Index_For_State => Node_Desc_For_State'Access,
Type_Index_For_State_Body => Node_Desc_For_State_Body'Access,
Type_Index_For_Statement => Node_Desc_For_Statement'Access,
Type_Index_For_Assignment => Node_Desc_For_Assignment'Access,
Type_Index_For_Attribute_Statement => Node_Desc_For_Attribute_Statement'Access,
Type_Index_For_Message_Field_Assignment => Node_Desc_For_Message_Field_Assignment'Access,
Type_Index_For_Reset => Node_Desc_For_Reset'Access,
Type_Index_For_Term_Assoc => Node_Desc_For_Term_Assoc'Access,
Type_Index_For_Then => Node_Desc_For_Then_Node'Access,
Type_Index_For_Transition => Node_Desc_For_Transition'Access,
Type_Index_For_Conditional_Transition => Node_Desc_For_Conditional_Transition'Access,
Type_Index_For_Type_Argument => Node_Desc_For_Type_Argument'Access,
Type_Index_For_Type_Def => Node_Desc_For_Type_Def'Access,
Type_Index_For_Abstract_Message_Type_Def => Node_Desc_For_Abstract_Message_Type_Def'Access,
Type_Index_For_Message_Type_Def => Node_Desc_For_Message_Type_Def'Access,
Type_Index_For_Null_Message_Type_Def => Node_Desc_For_Null_Message_Type_Def'Access,
Type_Index_For_Enumeration_Def => Node_Desc_For_Enumeration_Def'Access,
Type_Index_For_Named_Enumeration_Def => Node_Desc_For_Named_Enumeration_Def'Access,
Type_Index_For_Positional_Enumeration_Def => Node_Desc_For_Positional_Enumeration_Def'Access,
Type_Index_For_Enumeration_Type_Def => Node_Desc_For_Enumeration_Type_Def'Access,
Type_Index_For_Integer_Type_Def => Node_Desc_For_Integer_Type_Def'Access,
Type_Index_For_Modular_Type_Def => Node_Desc_For_Modular_Type_Def'Access,
Type_Index_For_Range_Type_Def => Node_Desc_For_Range_Type_Def'Access,
Type_Index_For_Sequence_Type_Def => Node_Desc_For_Sequence_Type_Def'Access,
Type_Index_For_Type_Derivation_Def => Node_Desc_For_Type_Derivation_Def'Access
   );

   First_Node     : constant Type_Index := Type_Index_For_R_F_L_X_Node;
   First_Property : constant Struct_Member_Index :=
     Member_Index_For_Parent;

   function Eval_Node_Member
     (Node      : Internal_Acc_Node;
      Member    : Struct_Member_Index;
      Arguments : Internal_Value_Array) return Internal_Value_Access;
   --  Implementation for the Eval_Node_Member operation in the language
   --  descriptor.

   Builtin_Types : aliased constant Builtin_Types_Record :=
     (Analysis_Unit         => Type_Index_For_Analysis_Unit,
      Big_Int               => Type_Index_For_Big_Int,
      Bool                  => Type_Index_For_Bool,
      Char                  => Type_Index_For_Character,
      Int                   => Type_Index_For_Int,
      Source_Location_Range => Type_Index_For_Source_Location_Range,
      String                => Type_Index_For_String,
      Token                 => Type_Index_For_Token,
      Symbol                => Type_Index_For_Symbol);

   Node_Kinds : constant array (R_F_L_X_Node_Kind_Type) of Type_Index :=
     (Rflx_I_D => Type_Index_For_I_D, Rflx_Unqualified_I_D => Type_Index_For_Unqualified_I_D, Rflx_Aspect => Type_Index_For_Aspect, Rflx_Attr_First => Type_Index_For_Attr_First, Rflx_Attr_Has_Data => Type_Index_For_Attr_Has_Data, Rflx_Attr_Head => Type_Index_For_Attr_Head, Rflx_Attr_Last => Type_Index_For_Attr_Last, Rflx_Attr_Opaque => Type_Index_For_Attr_Opaque, Rflx_Attr_Present => Type_Index_For_Attr_Present, Rflx_Attr_Size => Type_Index_For_Attr_Size, Rflx_Attr_Valid => Type_Index_For_Attr_Valid, Rflx_Attr_Valid_Checksum => Type_Index_For_Attr_Valid_Checksum, Rflx_Attr_Stmt_Append => Type_Index_For_Attr_Stmt_Append, Rflx_Attr_Stmt_Extend => Type_Index_For_Attr_Stmt_Extend, Rflx_Attr_Stmt_Read => Type_Index_For_Attr_Stmt_Read, Rflx_Attr_Stmt_Write => Type_Index_For_Attr_Stmt_Write, Rflx_Message_Aggregate_Associations => Type_Index_For_Message_Aggregate_Associations, Rflx_Null_Message_Aggregate => Type_Index_For_Null_Message_Aggregate, Rflx_Checksum_Val => Type_Index_For_Checksum_Val, Rflx_Checksum_Value_Range => Type_Index_For_Checksum_Value_Range, Rflx_Byte_Order_Type_Highorderfirst => Type_Index_For_Byte_Order_Type_Highorderfirst, Rflx_Byte_Order_Type_Loworderfirst => Type_Index_For_Byte_Order_Type_Loworderfirst, Rflx_Readable => Type_Index_For_Readable, Rflx_Writable => Type_Index_For_Writable, Rflx_Checksum_Assoc => Type_Index_For_Checksum_Assoc, Rflx_Refinement_Decl => Type_Index_For_Refinement_Decl, Rflx_Session_Decl => Type_Index_For_Session_Decl, Rflx_Type_Decl => Type_Index_For_Type_Decl, Rflx_Description => Type_Index_For_Description, Rflx_Element_Value_Assoc => Type_Index_For_Element_Value_Assoc, Rflx_Attribute => Type_Index_For_Attribute, Rflx_Bin_Op => Type_Index_For_Bin_Op, Rflx_Binding => Type_Index_For_Binding, Rflx_Call => Type_Index_For_Call, Rflx_Case_Expression => Type_Index_For_Case_Expression, Rflx_Choice => Type_Index_For_Choice, Rflx_Comprehension => Type_Index_For_Comprehension, Rflx_Context_Item => Type_Index_For_Context_Item, Rflx_Conversion => Type_Index_For_Conversion, Rflx_Message_Aggregate => Type_Index_For_Message_Aggregate, Rflx_Negation => Type_Index_For_Negation, Rflx_Numeric_Literal => Type_Index_For_Numeric_Literal, Rflx_Paren_Expression => Type_Index_For_Paren_Expression, Rflx_Quantified_Expression => Type_Index_For_Quantified_Expression, Rflx_Select_Node => Type_Index_For_Select, Rflx_Concatenation => Type_Index_For_Concatenation, Rflx_Sequence_Aggregate => Type_Index_For_Sequence_Aggregate, Rflx_String_Literal => Type_Index_For_String_Literal, Rflx_Variable => Type_Index_For_Variable, Rflx_Formal_Channel_Decl => Type_Index_For_Formal_Channel_Decl, Rflx_Formal_Function_Decl => Type_Index_For_Formal_Function_Decl, Rflx_Renaming_Decl => Type_Index_For_Renaming_Decl, Rflx_Variable_Decl => Type_Index_For_Variable_Decl, Rflx_Message_Aggregate_Association => Type_Index_For_Message_Aggregate_Association, Rflx_Byte_Order_Aspect => Type_Index_For_Byte_Order_Aspect, Rflx_Checksum_Aspect => Type_Index_For_Checksum_Aspect, Rflx_Message_Field => Type_Index_For_Message_Field, Rflx_Message_Fields => Type_Index_For_Message_Fields, Rflx_Null_Message_Field => Type_Index_For_Null_Message_Field, Rflx_Op_Add => Type_Index_For_Op_Add, Rflx_Op_And => Type_Index_For_Op_And, Rflx_Op_Div => Type_Index_For_Op_Div, Rflx_Op_Eq => Type_Index_For_Op_Eq, Rflx_Op_Ge => Type_Index_For_Op_Ge, Rflx_Op_Gt => Type_Index_For_Op_Gt, Rflx_Op_In => Type_Index_For_Op_In, Rflx_Op_Le => Type_Index_For_Op_Le, Rflx_Op_Lt => Type_Index_For_Op_Lt, Rflx_Op_Mod => Type_Index_For_Op_Mod, Rflx_Op_Mul => Type_Index_For_Op_Mul, Rflx_Op_Neq => Type_Index_For_Op_Neq, Rflx_Op_Notin => Type_Index_For_Op_Notin, Rflx_Op_Or => Type_Index_For_Op_Or, Rflx_Op_Pow => Type_Index_For_Op_Pow, Rflx_Op_Sub => Type_Index_For_Op_Sub, Rflx_Package_Node => Type_Index_For_Package, Rflx_Parameter => Type_Index_For_Parameter, Rflx_Parameters => Type_Index_For_Parameters, Rflx_Quantifier_All => Type_Index_For_Quantifier_All, Rflx_Quantifier_Some => Type_Index_For_Quantifier_Some, Rflx_Aspect_List => Type_Index_For_Aspect_List, Rflx_Base_Checksum_Val_List => Type_Index_For_Base_Checksum_Val_List, Rflx_Channel_Attribute_List => Type_Index_For_Channel_Attribute_List, Rflx_Checksum_Assoc_List => Type_Index_For_Checksum_Assoc_List, Rflx_Choice_List => Type_Index_For_Choice_List, Rflx_Conditional_Transition_List => Type_Index_For_Conditional_Transition_List, Rflx_Context_Item_List => Type_Index_For_Context_Item_List, Rflx_Declaration_List => Type_Index_For_Declaration_List, Rflx_Element_Value_Assoc_List => Type_Index_For_Element_Value_Assoc_List, Rflx_Expr_List => Type_Index_For_Expr_List, Rflx_Formal_Decl_List => Type_Index_For_Formal_Decl_List, Rflx_Local_Decl_List => Type_Index_For_Local_Decl_List, Rflx_Message_Aggregate_Association_List => Type_Index_For_Message_Aggregate_Association_List, Rflx_Message_Aspect_List => Type_Index_For_Message_Aspect_List, Rflx_Message_Field_List => Type_Index_For_Message_Field_List, Rflx_Numeric_Literal_List => Type_Index_For_Numeric_Literal_List, Rflx_Parameter_List => Type_Index_For_Parameter_List, Rflx_R_F_L_X_Node_List => Type_Index_For_R_F_L_X_Node_List, Rflx_State_List => Type_Index_For_State_List, Rflx_Statement_List => Type_Index_For_Statement_List, Rflx_Term_Assoc_List => Type_Index_For_Term_Assoc_List, Rflx_Then_Node_List => Type_Index_For_Then_Node_List, Rflx_Type_Argument_List => Type_Index_For_Type_Argument_List, Rflx_Unqualified_I_D_List => Type_Index_For_Unqualified_I_D_List, Rflx_Specification => Type_Index_For_Specification, Rflx_State => Type_Index_For_State, Rflx_State_Body => Type_Index_For_State_Body, Rflx_Assignment => Type_Index_For_Assignment, Rflx_Attribute_Statement => Type_Index_For_Attribute_Statement, Rflx_Message_Field_Assignment => Type_Index_For_Message_Field_Assignment, Rflx_Reset => Type_Index_For_Reset, Rflx_Term_Assoc => Type_Index_For_Term_Assoc, Rflx_Then_Node => Type_Index_For_Then, Rflx_Transition => Type_Index_For_Transition, Rflx_Conditional_Transition => Type_Index_For_Conditional_Transition, Rflx_Type_Argument => Type_Index_For_Type_Argument, Rflx_Message_Type_Def => Type_Index_For_Message_Type_Def, Rflx_Null_Message_Type_Def => Type_Index_For_Null_Message_Type_Def, Rflx_Named_Enumeration_Def => Type_Index_For_Named_Enumeration_Def, Rflx_Positional_Enumeration_Def => Type_Index_For_Positional_Enumeration_Def, Rflx_Enumeration_Type_Def => Type_Index_For_Enumeration_Type_Def, Rflx_Modular_Type_Def => Type_Index_For_Modular_Type_Def, Rflx_Range_Type_Def => Type_Index_For_Range_Type_Def, Rflx_Sequence_Type_Def => Type_Index_For_Sequence_Type_Def, Rflx_Type_Derivation_Def => Type_Index_For_Type_Derivation_Def);
   --  Associate a type index to each concrete node

   -----------------------------------------------------
   --  Getter/setter helpers for introspection values --
   -----------------------------------------------------

   --  These helpers factorize common code needed in array/struct generic
   --  access/construction operations.

   procedure Set_Unit
     (Intr_Value   : Internal_Acc_Analysis_Unit;
      Actual_Value : Analysis_Unit);

   function Get_Unit
     (Intr_Value : Internal_Rec_Analysis_Unit)
      return Analysis_Unit;

   procedure Set_Big_Int
     (Intr_Value   : Internal_Acc_Big_Int;
      Actual_Value : Big_Integer);

   procedure Get_Big_Int
     (Intr_Value   : Internal_Rec_Big_Int;
      Actual_Value : out Big_Integer);

   procedure Set_Node
     (Intr_Value   : Internal_Acc_Node;
      Actual_Value : R_F_L_X_Node'Class);

   function Get_Node
     (Intr_Value : Internal_Rec_Node)
      return R_F_L_X_Node;

end Librflxlang.Generic_Introspection;
