# Security

Analytics in Motion takes the security of this python package seriously. If you believe you have found a security vulnerability in this repository, please report it to us as described below.

## Responsible Disclosure
We are strongly committed to the responsible disclosure of security vulnerabilities. Please follow these guidelines when reporting security issues:
- Please send an email to [pi@analyticsinmotion.com](mailto:pi@analyticsinmotion.com) and include the words \"SECURITY - werpy package\" in the subject line. 
- Provide details of the potential vulnerability, including information such as:
  - a description of the vulnerability and how it can be exploited;
  - the affected version of the python package;
  - steps to reproduce the issue;
  - any other relevant information that could help us fix the vulnerability.
- Please do not report security vulnerabilities through public GitHub issues.


## Supported Versions
This security policy applies to the following versions of the package:
| Package Version | Supported            |
|:---------------:|:--------------------:|
| 0.0.x           | :white_check_mark:   |
| 1.x.x           | :white_check_mark:   |


## Security Best Practices for Users
In order to ensure the security of your application, please follow these security best practices when using this package:
- Keep your dependencies up to date regularly
- Only install packages from trustworthy sources
- Enable two-factor authentication (2FA) on the application or service you are using
- Use strong and unique passwords for all services, accounts, and systems
- Implement proper authentication and authorization controls in your application
- Follow the principle of 'least privilege' when setting up permissions and access controls.

By following these best practices and working together with the development team, we can ensure that our applications remain secure and protected.


## Acknowledgments
Thank you! Your help in keeping our users secure is appreciated.

## Contact
If you have any security questions, please contact [pi@analyticsinmotion.com](mailto:pi@analyticsinmotion.com).
