# Welcome to the werpy Contribution Guide

Thank you for investing your time in contributing to our project! We welcome all sorts of different contributions.

Before making any type of contribution, please read our <a href="https://github.com/analyticsinmotion/werpy/blob/main/CODE_OF_CONDUCT.md">Code of Conduct</a> to keep our community approachable and respectable.

In this guide you will get an overview of the contribution workflow from opening an issue and creating a Pull Request (PR).


## New contributor resources
To get a good overview of the project, please first read the <a href="https://github.com/analyticsinmotion/werpy/blob/main/README.md">README</a> document. In addition, here are some great general resources to help you get started with open-source contributions:

- <a href="https://docs.github.com/en/get-started/exploring-projects-on-github/finding-ways-to-contribute-to-open-source-on-github">Finding ways to contribute to open source on GitHub</a>
- <a href="https://docs.github.com/en/pull-requests/collaborating-with-pull-requests">Collaborating with pull requests</a>

## Ways to contribute
There are multiple ways in which you can contribute to this project including:

- Reporting a Bug
- Analyzing the current code base
- Submitting a fix
- Suggest new features or improvements
- Becoming a maintainer
- Add or update documentation
- Anything else we may have forgotten

## Getting started

### Reporting a Bug
We utilize GitHub Issues to raise, track and manage bugs. All open, pending, and closed cases for this project can be found at [werpy Issue Tracking](https://github.com/analyticsinmotion/werpy/issues).

Should you identify a bug in this project, please search if the issue already exists in the <a href="https://github.com/analyticsinmotion/werpy/issues">GitHub Issues</a> page. You may be able to add more information or your own experience to an existing issue.

If a related issue doesn't exist, you can open a new issue using the [werpy issues form](https://github.com/analyticsinmotion/werpy/issues/new).

To assist in fixing any issues raised more rapidly, please ensure that any bug reports include the following components (where necessary):
- A quick summary and/or background
- Any steps helpful to reproduce the bug
- Code or sample codes that were used
- What you expected to happen vs. what happened
- Exact error messages received (you can upload de-identified screenshots as well)
 
### Proposing Codebase changes

We welcome contributions to the codebase of this project from everyone who is interested in making the project better. If you want to propose a codebase change, please follow these steps:
1. Fork this repository to your own account and clone it to your local machine.
2. Create a new branch from the `main` branch for your changes. Give the branch a descriptive name that reflects the changes you plan to make.
3. Make your changes to the codebase in your local repository.
4. Test your changes thoroughly.
5. Commit your changes to your local branch with a clear and descriptive commit message.
6. Push your branch to your forked repository.
7. Open a pull request (PR) against the original repository's `main` branch. Ensure that you have included a description of your changes in your PR, highlighting the reasons for the changes and the benefits they provide to the project.

Our team will review your PR and provide feedback as soon as possible. We may ask you to make additional changes, so please be prepared to iterate on your changes until they are ready to be merged.

We appreciate your contributions to the project and thank you for your time in submitting a pull request.


## License

By contributing to this repository, you agree to license your contributions under the [BSD 3-Clause License](https://github.com/analyticsinmotion/werpy/blob/main/LICENSE).

Any contributed code or content must be your original work, and you warrant that you have the right to license it under the terms of the BSD 3-Clause License. 

By contributing, you also acknowledge that your contribution will be included in the project under the same license as the rest of the repository.

