from enum import Enum


class Permission(str, Enum):
    MANAGE_USERS = "MANAGE_USERS"
    MANAGE_STAFF = "MANAGE_STAFF"
    IMPERSONATE_USER = "IMPERSONATE_USER"
    MANAGE_APPS = "MANAGE_APPS"
    MANAGE_OBSERVABILITY = "MANAGE_OBSERVABILITY"
    MANAGE_CHECKOUTS = "MANAGE_CHECKOUTS"
    HANDLE_CHECKOUTS = "HANDLE_CHECKOUTS"
    HANDLE_TAXES = "HANDLE_TAXES"
    MANAGE_TAXES = "MANAGE_TAXES"
    MANAGE_CHANNELS = "MANAGE_CHANNELS"
    MANAGE_DISCOUNTS = "MANAGE_DISCOUNTS"
    MANAGE_GIFT_CARD = "MANAGE_GIFT_CARD"
    MANAGE_MENUS = "MANAGE_MENUS"
    MANAGE_ORDERS = "MANAGE_ORDERS"
    MANAGE_PAGES = "MANAGE_PAGES"
    MANAGE_PAGE_TYPES_AND_ATTRIBUTES = "MANAGE_PAGE_TYPES_AND_ATTRIBUTES"
    HANDLE_PAYMENTS = "HANDLE_PAYMENTS"
    MANAGE_PLUGINS = "MANAGE_PLUGINS"
    MANAGE_PRODUCTS = "MANAGE_PRODUCTS"
    MANAGE_PRODUCT_TYPES_AND_ATTRIBUTES = "MANAGE_PRODUCT_TYPES_AND_ATTRIBUTES"
    MANAGE_SHIPPING = "MANAGE_SHIPPING"
    MANAGE_SETTINGS = "MANAGE_SETTINGS"
    MANAGE_TRANSLATIONS = "MANAGE_TRANSLATIONS"


class TargetType(str, Enum):
    POPUP = "POPUP"
    APP_PAGE = "APP_PAGE"


class MountType(str, Enum):
    PRODUCT_DETAILS_MORE_ACTIONS = "PRODUCT_DETAILS_MORE_ACTIONS"
    PRODUCT_OVERVIEW_CREATE = "PRODUCT_OVERVIEW_CREATE"
    PRODUCT_OVERVIEW_MORE_ACTIONS = "PRODUCT_OVERVIEW_MORE_ACTIONS"
    NAVIGATION_CATALOG = "NAVIGATION_CATALOG"
    NAVIGATION_ORDERS = "NAVIGATION_ORDERS"
    NAVIGATION_CUSTOMERS = "NAVIGATION_CUSTOMERS"
    NAVIGATION_DISCOUNTS = "NAVIGATION_DISCOUNTS"
    NAVIGATION_TRANSLATIONS = "NAVIGATION_TRANSLATIONS"
    NAVIGATION_PAGES = "NAVIGATION_PAGES"
    ORDER_DETAILS_MORE_ACTIONS = "ORDER_DETAILS_MORE_ACTIONS"
    ORDER_OVERVIEW_CREATE = "ORDER_OVERVIEW_CREATE"
    ORDER_OVERVIEW_MORE_ACTIONS = "ORDER_OVERVIEW_MORE_ACTIONS"


class WebhookAsyncEvents(str, Enum):
    ANY_EVENTS = "ANY_EVENTS"
    ADDRESS_CREATED = "ADDRESS_CREATED"
    ADDRESS_UPDATED = "ADDRESS_UPDATED"
    ADDRESS_DELETED = "ADDRESS_DELETED"
    APP_INSTALLED = "APP_INSTALLED"
    APP_UPDATED = "APP_UPDATED"
    APP_DELETED = "APP_DELETED"
    APP_STATUS_CHANGED = "APP_STATUS_CHANGED"
    ATTRIBUTE_CREATED = "ATTRIBUTE_CREATED"
    ATTRIBUTE_UPDATED = "ATTRIBUTE_UPDATED"
    ATTRIBUTE_DELETED = "ATTRIBUTE_DELETED"
    CATEGORY_CREATED = "CATEGORY_CREATED"
    CATEGORY_UPDATED = "CATEGORY_UPDATED"
    CATEGORY_DELETED = "CATEGORY_DELETED"
    CHANNEL_CREATED = "CHANNEL_CREATED"
    CHANNEL_UPDATED = "CHANNEL_UPDATED"
    CHANNEL_DELETED = "CHANNEL_DELETED"
    CHANNEL_STATUS_CHANGED = "CHANNEL_STATUS_CHANGED"
    GIFT_CARD_CREATED = "GIFT_CARD_CREATED"
    GIFT_CARD_UPDATED = "GIFT_CARD_UPDATED"
    GIFT_CARD_DELETED = "GIFT_CARD_DELETED"
    GIFT_CARD_STATUS_CHANGED = "GIFT_CARD_STATUS_CHANGED"
    CHECKOUT_CREATED = "CHECKOUT_CREATED"
    CHECKOUT_UPDATED = "CHECKOUT_UPDATED"
    CUSTOMER_CREATED = "CUSTOMER_CREATED"
    CUSTOMER_UPDATED = "CUSTOMER_UPDATED"
    CUSTOMER_DELETED = "CUSTOMER_DELETED"
    FULFILLMENT_CREATED = "FULFILLMENT_CREATED"
    INVOICE_DELETED = "INVOICE_DELETED"
    INVOICE_REQUESTED = "INVOICE_REQUESTED"
    INVOICE_SENT = "INVOICE_SENT"
    MENU_CREATED = "MENU_CREATED"
    MENU_UPDATED = "MENU_UPDATED"
    MENU_DELETED = "MENU_DELETED"
    MENU_ITEM_CREATED = "MENU_ITEM_CREATED"
    MENU_ITEM_UPDATED = "MENU_ITEM_UPDATED"
    MENU_ITEM_DELETED = "MENU_ITEM_DELETED"
    ORDER_CANCELLED = "ORDER_CANCELLED"
    ORDER_CONFIRMED = "ORDER_CONFIRMED"
    ORDER_CREATED = "ORDER_CREATED"
    ORDER_FULFILLED = "ORDER_FULFILLED"
    ORDER_FULLY_PAID = "ORDER_FULLY_PAID"
    ORDER_UPDATED = "ORDER_UPDATED"
    SALE_CREATED = "SALE_CREATED"
    SALE_UPDATED = "SALE_UPDATED"
    SALE_DELETED = "SALE_DELETED"
    SALE_TOGGLE = "SALE_TOGGLE"
    PAGE_CREATED = "PAGE_CREATED"
    PAGE_DELETED = "PAGE_DELETED"
    PAGE_UPDATED = "PAGE_UPDATED"
    PAGE_TYPE_CREATED = "PAGE_TYPE_CREATED"
    PAGE_TYPE_UPDATED = "PAGE_TYPE_UPDATED"
    PAGE_TYPE_DELETED = "PAGE_TYPE_DELETED"
    COLLECTION_CREATED = "COLLECTION_CREATED"
    COLLECTION_DELETED = "COLLECTION_DELETED"
    COLLECTION_UPDATED = "COLLECTION_UPDATED"
    PRODUCT_CREATED = "PRODUCT_CREATED"
    PRODUCT_DELETED = "PRODUCT_DELETED"
    PRODUCT_UPDATED = "PRODUCT_UPDATED"
    PRODUCT_VARIANT_CREATED = "PRODUCT_VARIANT_CREATED"
    PRODUCT_VARIANT_DELETED = "PRODUCT_VARIANT_DELETED"
    PRODUCT_VARIANT_UPDATED = "PRODUCT_VARIANT_UPDATED"
    NOTIFY = "NOTIFY"
    TRANSACTION_ACTION_REQUEST = "TRANSACTION_ACTION_REQUEST"
    TRANSLATION_CREATED = "TRANSLATION_CREATED"
    TRANSLATION_UPDATED = "TRANSLATION_UPDATED"
    PRODUCT_VARIANT_OUT_OF_STOCK = "PRODUCT_VARIANT_OUT_OF_STOCK"
    PRODUCT_VARIANT_BACK_IN_STOCK = "PRODUCT_VARIANT_BACK_IN_STOCK"
    SHIPPING_PRICE_CREATED = "SHIPPING_PRICE_CREATED"
    SHIPPING_PRICE_UPDATED = "SHIPPING_PRICE_UPDATED"
    SHIPPING_PRICE_DELETED = "SHIPPING_PRICE_DELETED"
    SHIPPING_ZONE_CREATED = "SHIPPING_ZONE_CREATED"
    SHIPPING_ZONE_UPDATED = "SHIPPING_ZONE_UPDATED"
    SHIPPING_ZONE_DELETED = "SHIPPING_ZONE_DELETED"
    STAFF_CREATED = "STAFF_CREATED"
    STAFF_UPDATED = "STAFF_UPDATED"
    STAFF_DELETED = "STAFF_DELETED"
    VOUCHER_CREATED = "VOUCHER_CREATED"
    VOUCHER_UPDATED = "VOUCHER_UPDATED"
    VOUCHER_DELETED = "VOUCHER_DELETED"
    WAREHOUSE_CRATED = "WAREHOUSE_CRATED"
    WAREHOUSE_UPDATED = "WAREHOUSE_UPDATED"
    WAREHOUSE_DELETED = "WAREHOUSE_DELETED"


class WebhookSyncEvents(str, Enum):
    PAYMENT_AUTHORIZE = "PAYMENT_AUTHORIZE"
    PAYMENT_CAPTURE = "PAYMENT_CAPTURE"
    PAYMENT_CONFIRM = "PAYMENT_CONFIRM"
    PAYMENT_LIST_GATEWAYS = "PAYMENT_LIST_GATEWAYS"
    PAYMENT_PROCESS = "PAYMENT_PROCESS"
    PAYMENT_REFUND = "PAYMENT_REFUND"
    PAYMENT_VOID = "PAYMENT_VOID"
    CHECKOUT_CALCULATE_TAXES = "CHECKOUT_CALCULATE_TAXES"
    ORDER_CALCULATE_TAXES = "ORDER_CALCULATE_TAXES"
    SHIPPING_LIST_METHODS_FOR_CHECKOUT = "SHIPPING_LIST_METHODS_FOR_CHECKOUT"
    ORDER_FILTER_SHIPPING_METHODS = "ORDER_FILTER_SHIPPING_METHODS"
    CHECKOUT_FILTER_SHIPPING_METHODS = "CHECKOUT_FILTER_SHIPPING_METHODS"
