#!/usr/bin/env python
# -*- coding: utf-8 -*-
import re
from setuptools import setup, find_packages

REQUIREMENTS = [
    'nltk>=3.1; python_version >= "3"',
    'nltk>=3.1,<3.5; python_version < "3"',
]
def find_version(fname):
    """Attempts to find the version number in the file names fname.
    Raises RuntimeError if not found.
    """
    version = ''
    with open(fname, 'r') as fp:
        reg = re.compile(r'__version__ = [\'"]([^\'"]*)[\'"]')
        for line in fp:
            m = reg.match(line)
            if m:
                version = m.group(1)
                break
    if not version:
        raise RuntimeError('Cannot find version information')
    return version


__version__ = find_version('textblob/__init__.py')


def read(fname):
    with open(fname) as fp:
        content = fp.read()
    return content


setup(
    name='pjdtextblob',
    version=__version__,
    description='Simple, Pythonic text processing. Sentiment analysis, '
                'part-of-speech tagging, noun phrase parsing, and more.',
    long_description=read("README.rst"),
    license='MIT',
    author='Prakash Dale',
    author_email='prakashdale@gmail.com',
    url='https://github.com/prakashdale/TextBlob',
    install_requires=REQUIREMENTS,
    packages=find_packages(exclude=('test*', )),
    include_package_data=True,
    zip_safe=False,
    package_data={
        "textblob.en": ["*.txt", "*.xml"]
    },
    classifiers=(
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy',
        "Topic :: Text Processing :: Linguistic",
    ),
    keywords=["textblob", "nlp", 'linguistics', 'nltk', 'pattern']
)
