# -*- coding: utf-8 -*-

"""File containing all constant required for the package."""

import os

"""File paths."""
HERE = os.path.dirname(os.path.realpath(__file__))
DATA_DIR = os.path.join(HERE, "../../data")
PATENT_DIR = os.path.join(DATA_DIR, "patent_dumps")
MAPPER_DIR = os.path.join(DATA_DIR, "mapper")

"""Valid IPC codes."""
VALID_CODES = {
    "A61B",
    "A61C",
    "A61D",
    "A61P",
    "A61Q",
    "A23B",
    "A23C",
    "A23D",
    "A23F",
    "A23G",
    "A23J",
    "A23L",
    "A23N",
    "A23P",
    "C01B",
    "C01C",
    "C01G",
    "C12P",
    "C12Q",
    "C07B",
    "C07C",
    "C07D",
    "C07F",
    "C07G",
    "C07H",
    "C07J",
    "C07K",
    "C08B",
    "C08C",
    "C08F",
    "C08G",
    "C08H",
    "C08J",
    "C08K",
    "C08L",
}

"""Country code to country name mapper from EPO."""
COUNTRY_MAPPER = {
    "AL": "Albania",
    "AP": "African Regional Industrial Property Organization",
    "AR": "Argentina",
    "AT": "Austria",
    "AU": "Australia",
    "BA": "Bosnia and Herzegovina",
    "BE": "Belgium",
    "BG": "Bulgaria",
    "BR": "Brazil",
    "CA": "Canada",
    "CH": "Switzerland",
    "CL": "Chile",
    "CN": "China",
    "CO": "Colombia",
    "CR": "Costa Rica",
    "CS": "Czechoslovakia",
    "CU": "Cuba",
    "CY": "Cyprus",
    "CZ": "Czech Republic",
    "DD": "Germany",
    "DE": "Germany",
    "DK": "Denmark",
    "DZ": "Algeria",
    "EA": "Eurasian Patent Organisation",
    "EC": "Ecuador",
    "EE": "Estonia",
    "EG": "Egypt",
    "EP": "European Patent Office",
    "ES": "Spain",
    "FI": "Finland",
    "FR": "France",
    "GB": "United Kingdom",
    "GC": "Gulf Cooperation Council",
    "GE": "Georgia",
    "GR": "Greece",
    "GT": "Guatemala",
    "HK": "Hong Kong (China)",
    "HR": "Croatia",
    "HU": "Hungary",
    "ID": "Indonesia",
    "IE": "Ireland",
    "IL": "Israel",
    "IN": "India",
    "IS": "Iceland",
    "IT": "Italy",
    "JP": "Japan",
    "KE": "Kenya",
    "KR": "Republic of Korea",
    "LI": "Liechtenstein",
    "LT": "Lithuania",
    "LU": "Luxembourg",
    "LV": "Latvia",
    "MA": "Morocco",
    "MC": "Monaco",
    "MD": "Republic of Moldova",
    "MK": "Republic of North Macedonia",
    "MN": "Mongolia",
    "MT": "Malta",
    "MW": "Malawi",
    "MX": "Mexico",
    "MY": "Malaysia",
    "NC": "New Caledonia",
    "NI": "Nicaragua",
    "NL": "Netherlands",
    "NO": "Norway",
    "NZ": "New Zealand",
    "OA": "African Intellectual Property Organization",
    "PA": "Panama",
    "PE": "Peru",
    "PH": "Philippines",
    "PL": "Poland",
    "PT": "Portugal",
    "RO": "Romania",
    "RU": "Russian Federation",
    "SE": "Sweden",
    "SG": "Singapore",
    "SI": "Slovenia",
    "SK": "Slovakia",
    "SU": "Union of Soviet Socialist Republics (USSR)",
    "SV": "El Salvador",
    "TJ": "Tajikistan",
    "TR": "Turkey",
    "TT": "Trinidad and Tobago",
    "TW": "Chinese Taipei",
    "UA": "Ukraine",
    "US": "United States of America",
    "UY": "Uruguay",
    "VN": "Vietnam",
    "WO": "World Intellectual Property Organisation (WIPO)",
    "YU": "Yugoslavia (Serbia and Montenegro)",
    "ZA": "South Africa",
    "ZM": "Zambia",
    "ZW": "Zimbabwe",
}
