"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cloudformation_1 = require("@aws-cdk/aws-cloudformation");
const core_1 = require("@aws-cdk/core");
const kubectl_provider_1 = require("./kubectl-provider");
/**
 * A CloudFormation resource which applies/restores a JSON patch into a
 * Kubernetes resource.
 */
class KubernetesPatch extends core_1.Construct {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(stack);
        new aws_cloudformation_1.CustomResource(this, 'Resource', {
            provider: provider.provider,
            resourceType: 'Custom::AWSCDK-EKS-KubernetesPatch',
            properties: {
                ResourceName: props.resourceName,
                ResourceNamespace: (_a = props.resourceNamespace, (_a !== null && _a !== void 0 ? _a : 'default')),
                ApplyPatchJson: stack.toJsonString(props.applyPatch),
                RestorePatchJson: stack.toJsonString(props.restorePatch),
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._getKubectlCreationRoleArn(provider.role)
            }
        });
    }
}
exports.KubernetesPatch = KubernetesPatch;
//# sourceMappingURL=data:application/json;base64,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