"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamKey = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("@aws-cdk/core");
const ivs_generated_1 = require("./ivs.generated");
/**
  A new IVS Stream Key
*/
class StreamKey extends core.Resource {
    constructor(scope, id, props) {
        super(scope, id, {});
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ivs_StreamKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const resource = new ivs_generated_1.CfnStreamKey(this, 'Resource', {
            channelArn: props.channel.channelArn,
        });
        this.streamKeyArn = resource.attrArn;
        this.streamKeyValue = resource.attrValue;
    }
}
exports.StreamKey = StreamKey;
_a = JSII_RTTI_SYMBOL_1;
StreamKey[_a] = { fqn: "@aws-cdk/aws-ivs.StreamKey", version: "1.156.0" };
//# sourceMappingURL=data:application/json;base64,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