The examples are:

- `variable_substitution.py`: rename variables that a BDD depends on

- `reachability.py`: compute the states reachable from some
  starting set of states.

- `queens.py`: solve the [N-queens problem](
    https://en.wikipedia.org/wiki/Eight_queens_puzzle).

- `reordering.py`: activate dynamic variable reordering for the Python
  implementation, invoke reordering explicitly, and permute variables to
  a desired order.

- `cudd_configure_reordering.py`: how to turn reordering off when using CUDD

- `cudd_statistics.py`: see CUDD's activity in numbers.

- `cudd_memory_limits.py`: bound how much memory CUDD is
  allowed to use.

- `cudd_zdd.py`: how to use ZDDs with CUDD.
