"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniRunner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const index_1 = require("./index");
class AttiniRunner extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        let copy = { ...props };
        if (props.awsVpcConfiguration?.subnets) {
            copy.awsVpcConfiguration.subnets = props.awsVpcConfiguration.subnets.join(',');
        }
        if (props.awsVpcConfiguration?.securityGroups) {
            copy.awsVpcConfiguration.securityGroups = props.awsVpcConfiguration.securityGroups.join(',');
        }
        if (props.awsVpcConfiguration?.assignPublicIp) {
            copy.awsVpcConfiguration.assignPublicIp = props.awsVpcConfiguration?.assignPublicIp ? 'ENABLED' : 'DISABLED';
        }
        if (props.awsVpcConfiguration) {
            copy.awsVpcConfiguration = index_1.PropsUtil.fixCase(copy.awsVpcConfiguration);
        }
        if (props.runnerConfiguration) {
            copy.runnerConfiguration = index_1.PropsUtil.fixCase(copy.runnerConfiguration);
        }
        if (props.startup) {
            copy.startup = index_1.PropsUtil.fixCase(props.startup);
        }
        let cfnResource = new aws_cdk_lib_1.CfnResource(this, id, {
            type: 'Attini::Deploy::Runner',
            properties: index_1.PropsUtil.fixCase(copy),
        });
        this.runnerName = cfnResource.logicalId;
    }
}
exports.AttiniRunner = AttiniRunner;
_a = JSII_RTTI_SYMBOL_1;
AttiniRunner[_a] = { fqn: "@attini/cdk.AttiniRunner", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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