"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniImport = exports.SourceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const attini_task_1 = require("./attini-task");
const index_1 = require("./index");
var SourceType;
(function (SourceType) {
    SourceType[SourceType["S3_SOURCE"] = 0] = "S3_SOURCE";
    SourceType[SourceType["DISTRIBUTION_SOURCE"] = 1] = "DISTRIBUTION_SOURCE";
})(SourceType = exports.SourceType || (exports.SourceType = {}));
class AttiniImport extends attini_task_1.AttiniTask {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.type = 'AttiniImport';
        if (this.props.sourceType.valueOf() === SourceType.S3_SOURCE.valueOf() && !this.props.s3Source) {
            throw new Error('S3 source is set as type for Attini import step but no S3 source is configured, id =' + id);
        }
        if (this.props.sourceType.valueOf() === SourceType.DISTRIBUTION_SOURCE.valueOf() && !this.props.distributionSource) {
            throw new Error('Distribution source is set as type for Attini import step but no distribution source is configured, id: ' + id);
        }
    }
    renderProps() {
        let properties = {};
        if (this.props.sourceType.valueOf() === SourceType.S3_SOURCE.valueOf()) {
            properties.SourceType = 'S3';
            properties.Source = index_1.PropsUtil.fixCase(this.props.s3Source);
        }
        else {
            properties.SourceType = 'Distribution';
            properties.Source = index_1.PropsUtil.fixCase(this.props.distributionSource);
        }
        if (this.props.mapping) {
            properties.Mapping = this.props.mapping;
        }
        if (this.props.executionRoleArn) {
            properties.ExecutionRoleArn = this.props.executionRoleArn;
        }
        return {
            Properties: aws_stepfunctions_1.FieldUtils.renderObject(properties),
        };
    }
}
exports.AttiniImport = AttiniImport;
_a = JSII_RTTI_SYMBOL_1;
AttiniImport[_a] = { fqn: "@attini/cdk.AttiniImport", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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