# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['alteia_cli', 'alteia_cli.custom_analytics', 'alteia_cli.plugins']

package_data = \
{'': ['*'], 'alteia_cli.custom_analytics': ['share/*']}

install_requires = \
['alteia>=2.7.0,<3.0.0',
 'click_spinner>=0.1.8,<0.2.0',
 'jsonschema>=3.0.0,<5.0.0',
 'pyinquirer>=1.0.3,<2.0.0',
 'pyyaml>=5.0.0,<7.0.0',
 'semver>=2.13.0,<3.0.0',
 'tabulate>=0.8.9',
 'typer>=0.6.1,<0.7.0']

entry_points = \
{'console_scripts': ['alteia = alteia_cli.main:app']}

setup_kwargs = {
    'name': 'alteia-cli',
    'version': '1.5.0',
    'description': 'CLI for Alteia',
    'long_description': '# `alteia`\n\nCLI for Alteia Platform.\n\n**Usage**:\n\n```console\n$ alteia [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `-p, --profile TEXT`: Alteia CLI Profile  [env var: ALTEIA_CLI_PROFILE; default: default]\n* `--version`: Display the CLI version and exit\n* `--verbose`: Display more info during the run\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `analytic-configurations`: Interact with configurations of analytics.\n* `analytics`: Interact with analytics.\n* `configure`: Configure platform credentials.\n* `credentials`: Interact with Docker registry credentials.\n* `products`: Interact with products.\n\n## `alteia analytic-configurations`\n\nInteract with configurations of analytics.\n\n**Usage**:\n\n```console\n$ alteia analytic-configurations [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `assign`: Assign an analytic configuration set to a...\n* `create`: Create a new configuration set for an...\n* `delete`: Delete one or many analytic configuration...\n* `export`: Export one configuration of a configuration...\n* `list`: List the analytic configuration sets and...\n* `unassign`: Unassign an analytic configuration set from a...\n* `update`: Update a configuration set.\n\n### `alteia analytic-configurations assign`\n\nAssign an analytic configuration set to a company.\n\nAll analytic configurations that are currently part of this\nanalytic configuration set (and the potential future ones),\nare assigned to the company.\n\n**Usage**:\n\n```console\n$ alteia analytic-configurations assign [OPTIONS] CONFIG_SET_ID\n```\n\n**Arguments**:\n\n* `CONFIG_SET_ID`: Identifier of the configuration set to assign  [required]\n\n**Options**:\n\n* `-c, --company TEXT`: Identifier of the company the configuration set will be assigned to  [required]\n* `--help`: Show this message and exit.\n\n### `alteia analytic-configurations create`\n\nCreate a new configuration set for an analytic.\n\nA configuration set is composed of configurations, each being applied to\na different version range of the associated analytic.\n\n**Usage**:\n\n```console\n$ alteia analytic-configurations create [OPTIONS]\n```\n\n**Options**:\n\n* `-c, --config-path PATH`: Path to the Configuration file (YAML or JSON file)  [required]\n* `-n, --name TEXT`: Configuration set name (will be prompt if not provided)\n* `-a, --analytic TEXT`: Analytic name (will be prompt if not provided)\n* `-v, --version-range TEXT`: Version range of the analytic on which this first configuration can be applied\n* `-d, --description TEXT`: Configuration set description text\n* `--help`: Show this message and exit.\n\n### `alteia analytic-configurations delete`\n\nDelete one or many analytic configuration set(s)\nand the associated configuration(s).\n\n**Usage**:\n\n```console\n$ alteia analytic-configurations delete [OPTIONS] IDS\n```\n\n**Arguments**:\n\n* `IDS`: Identifier of the configuration set to delete, or comma-separated list of configuration set identifiers  [required]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `alteia analytic-configurations export`\n\nExport one configuration of a configuration set.\nOutput can be a JSON or YAML format.\n\n**Usage**:\n\n```console\n$ alteia analytic-configurations export [OPTIONS] CONFIG_SET_ID\n```\n\n**Arguments**:\n\n* `CONFIG_SET_ID`: Identifier of the configuration set to export value  [required]\n\n**Options**:\n\n* `-v, --version-range TEXT`: Specify the exact version range from the applicable analytic version ranges. Optional if only one configuration exists in the configuration set\n* `-f, --format [json|yaml]`: Optional output format  [default: json]\n* `-o, --output-path PATH`: Optional output filepath to export the configuration. If the filepath already exists, it will be replaced. If not specified, configuration will be displayed in stdout\n* `--help`: Show this message and exit.\n\n### `alteia analytic-configurations list`\n\nList the analytic configuration sets and their configurations.\n\n**Usage**:\n\n```console\n$ alteia analytic-configurations list [OPTIONS]\n```\n\n**Options**:\n\n* `-n, --limit INTEGER RANGE`: Max number of configuration sets returned.  [default: 100]\n* `--name TEXT`: Configuration set name (or a part of) to match\n* `--analytic TEXT`: Exact analytic name to match\n* `--desc`: Print description rather than configurations  [default: False]\n* `--help`: Show this message and exit.\n\n### `alteia analytic-configurations unassign`\n\nUnassign an analytic configuration set from a company.\n\nAll configurations currently part of this analytic configuration set,\nare unassigned from the company.\n\n**Usage**:\n\n```console\n$ alteia analytic-configurations unassign [OPTIONS] CONFIG_SET_ID\n```\n\n**Arguments**:\n\n* `CONFIG_SET_ID`: Identifier of the configuration set to unassign  [required]\n\n**Options**:\n\n* `-c, --company TEXT`: Identifier of the company the configuration set is assigned to  [required]\n* `--help`: Show this message and exit.\n\n### `alteia analytic-configurations update`\n\nUpdate a configuration set.\nA configuration set is composed of configurations, each being applied\nto a different version range of the associated analytic.\n\nTo add a new configuration (file), use --add-config with the path to the new\nconfiguration file (YAML or JSON file) and --version-range with the version range\nof the analytic you want this new configuration to be applied.\n\nTo replace an existing configuration (file), use --replace-config with the path\nto the new configuration file (YAML or JSON file) and --version-range with the\nexact version range attached to the configuration to replace.\n\nTo remove a configuration from a configuration set, use --remove-config\nand --version-range with the exact version range attached to the configuration\nto remove.\n\nTo change the version range for an existing configuration, do an "add" and then\na "remove" (an export may be necessary to do the "add" with the same\nconfiguration file).\n\n**Usage**:\n\n```console\n$ alteia analytic-configurations update [OPTIONS] CONFIG_SET_ID\n```\n\n**Arguments**:\n\n* `CONFIG_SET_ID`: Identifier of the configuration set to update  [required]\n\n**Options**:\n\n* `-n, --name TEXT`: New configuration set name\n* `-d, --description TEXT`: New configuration set description\n* `-a, --add-config PATH`: Add new configuration. Specify the path to the new configuration file, and --version-range option with the version range of the analytic you want this new configuration to be applied. Do not use with --replace-config\n* `-u, --replace-config PATH`: Replace a configuration. Specify the path to the new configuration file, and --version-range option with the exact version range from the applicable analytic version ranges. Do not use with --add-config\n* `-v, --version-range TEXT`: Version range of the analytic on which a configuration can be applied. Must be used with one of --add-config, --replace-config or --remove-config\n* `-r, --remove-config TEXT`: Remove a configuration. Specify the exact version range from the applicable analytic version ranges\n* `--help`: Show this message and exit.\n\n## `alteia analytics`\n\nInteract with analytics.\n\n**Usage**:\n\n```console\n$ alteia analytics [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `create`: Create a new analytic.\n* `delete`: Delete an analytic.\n* `disable`: Disable an analytic on companies\n* `enable`: Enable an analytic on companies\n* `expose`: Expose an analytic\n* `list`: List the analytics.\n* `list-exposed`: List exposed analytics\n* `share`: Share an analytic (DEPRECATED: use expose...\n* `unexpose`: Unexpose an analytic\n* `unshare`: Unshare an analytic (DEPRECATED: use unexpose...\n\n### `alteia analytics create`\n\nCreate a new analytic.\n\n**Usage**:\n\n```console\n$ alteia analytics create [OPTIONS]\n```\n\n**Options**:\n\n* `--description PATH`: Path of the Analytic description (YAML file).  [required]\n* `--company TEXT`: Company identifier.\n* `--help`: Show this message and exit.\n\n### `alteia analytics delete`\n\nDelete an analytic.\n\n**Usage**:\n\n```console\n$ alteia analytics delete [OPTIONS] ANALYTIC_NAME\n```\n\n**Arguments**:\n\n* `ANALYTIC_NAME`: [required]\n\n**Options**:\n\n* `--version TEXT`: Version range of the analytic in SemVer format. If not provided, all the versions will be deleted.\n* `--help`: Show this message and exit.\n\n### `alteia analytics disable`\n\nDisable an analytic on companies\n\n**Usage**:\n\n```console\n$ alteia analytics disable [OPTIONS] ANALYTIC_NAME\n```\n\n**Arguments**:\n\n* `ANALYTIC_NAME`: [required]\n\n**Options**:\n\n* `--company TEXT`: Identifier of the company to disable the analytic, or list of such identifiers (comma separated values).\n\nWhen providing the identifier of the root company of your domain, the analytic is disabled by default for all the companies of the domain (equivalent to using the --domain option).\n* `--domain TEXT`: Use this option to make the analytic disabled by default for all companies of the specified domains (comma separated values) (equivalent to using the --company option providing the root company identifier(s) of these domains).\n\nApart from this default behavior on domain, the analytic can be enabled or disabled separately on each company of the domain.\n* `--help`: Show this message and exit.\n\n### `alteia analytics enable`\n\nEnable an analytic on companies\n\n**Usage**:\n\n```console\n$ alteia analytics enable [OPTIONS] ANALYTIC_NAME\n```\n\n**Arguments**:\n\n* `ANALYTIC_NAME`: [required]\n\n**Options**:\n\n* `--company TEXT`: Identifier of the company to enable the analytic, or list of such identifiers (comma separated values).\n\nWhen providing the identifier of the root company of your domain, the analytic is enabled by default for all the companies of the domain (equivalent to using the --domain option).\n* `--domain TEXT`: Use this option to make the analytic enabled by default for all companies of the specified domains (comma separated values) (equivalent to using the --company option providing the root company identifier(s) of these domains).\n\nApart from this default behavior on domain, the analytic can be enabled or disabled separately on each company of the domain.\n* `--help`: Show this message and exit.\n\n### `alteia analytics expose`\n\nExpose an analytic\n\n**Usage**:\n\n```console\n$ alteia analytics expose [OPTIONS] ANALYTIC_NAME\n```\n\n**Arguments**:\n\n* `ANALYTIC_NAME`: [required]\n\n**Options**:\n\n* `--domain TEXT`: To expose the analytic on the specified domains (comma separated values) if you have the right permissions on these domains.\n\nBy default, without providing this option, the analytic will be exposed on your domain if you have the right permissions on it.\n* `--help`: Show this message and exit.\n\n### `alteia analytics list`\n\nList the analytics.\n\n**Usage**:\n\n```console\n$ alteia analytics list [OPTIONS]\n```\n\n**Options**:\n\n* `-n, --limit INTEGER RANGE`: Max number of analytics returned.  [default: 100]\n* `--all`: If set, display all kinds of analytics (otherwise only custom analytics are displayed).  [default: False]\n* `--help`: Show this message and exit.\n\n### `alteia analytics list-exposed`\n\nList exposed analytics\n\n**Usage**:\n\n```console\n$ alteia analytics list-exposed [OPTIONS]\n```\n\n**Options**:\n\n* `--all`: If set, display all kinds of analytics (otherwise only custom analytics are displayed).  [default: False]\n* `--domain TEXT`: If set, filters exposed analytics on the specified domains (comma separated values) if you have the right permissions on these domains.\n\nBy default, without providing this option, it filters on your domain.\n* `--help`: Show this message and exit.\n\n### `alteia analytics share`\n\nShare an analytic (DEPRECATED: use expose instead) \n\n**Usage**:\n\n```console\n$ alteia analytics share [OPTIONS] ANALYTIC_NAME\n```\n\n**Arguments**:\n\n* `ANALYTIC_NAME`: [required]\n\n**Options**:\n\n* `--version TEXT`: Range of versions in SemVer format. If not provided, all the versions will be shared.\n* `--company TEXT`: Identifier of the company to share the analytic with.\n\nWhen providing the identifier of the root company of your domain,\nthe analytic is shared with all the companies of the domain\n(equivalent to using the --domain option)\n* `--domain / --no-domain`: To share the analytic with the root company of your domain.\n\nThis has the effect to share the analytic with all the\ncompanies of your domain and is equivalent to using the\n--company option providing the id of the root company.  [default: False]\n* `--help`: Show this message and exit.\n\n### `alteia analytics unexpose`\n\nUnexpose an analytic\n\n**Usage**:\n\n```console\n$ alteia analytics unexpose [OPTIONS] ANALYTIC_NAME\n```\n\n**Arguments**:\n\n* `ANALYTIC_NAME`: [required]\n\n**Options**:\n\n* `--domain TEXT`: To unexpose the analytic from the specified domains (comma separated values) if you have the right permissions on these domains.\n\nBy default, without providing this option, the analytic will be unexposed from your domain if you have the right permissions on it.\n* `--help`: Show this message and exit.\n\n### `alteia analytics unshare`\n\nUnshare an analytic (DEPRECATED: use unexpose instead) \n\n**Usage**:\n\n```console\n$ alteia analytics unshare [OPTIONS] ANALYTIC_NAME\n```\n\n**Arguments**:\n\n* `ANALYTIC_NAME`: [required]\n\n**Options**:\n\n* `--version TEXT`: Range of versions in SemVer format. If not provided, all the versions will be unshared.\n* `--company TEXT`: Identifier of the company to unshare the analytic with.\n* `--domain / --no-domain`: To unshare the analytic with the root company of your domain.\n\nThis is equivalent to using the --company option providing\nthe id of the root company.\nNote that if you specifically shared the analytic with a company\nof your domain, the analytic will still be shared with that company.  [default: False]\n* `--help`: Show this message and exit.\n\n## `alteia configure`\n\nConfigure platform credentials.\n\nYou can configure multiples credential profiles by specifying\na different profile name for each one.\n\n**Usage**:\n\n```console\n$ alteia configure [OPTIONS] [PROFILE]\n```\n\n**Arguments**:\n\n* `[PROFILE]`: Alteia CLI Profile to configure  [env var: ALTEIA_CLI_PROFILE;default: default]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n## `alteia credentials`\n\nInteract with Docker registry credentials.\n\n**Usage**:\n\n```console\n$ alteia credentials [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `create`: Create a new credential entry.\n* `delete`: Delete a credential entry by its name.\n* `list`: List the existing credentials.\n\n### `alteia credentials create`\n\nCreate a new credential entry.\n\n**Usage**:\n\n```console\n$ alteia credentials create [OPTIONS]\n```\n\n**Options**:\n\n* `--filepath PATH`: Path of the Credential JSON file.  [required]\n* `--company TEXT`: Company identifier.\n* `--help`: Show this message and exit.\n\n### `alteia credentials delete`\n\nDelete a credential entry by its name.\n\n**Usage**:\n\n```console\n$ alteia credentials delete [OPTIONS] NAME\n```\n\n**Arguments**:\n\n* `NAME`: [required]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `alteia credentials list`\n\nList the existing credentials.\n\n**Usage**:\n\n```console\n$ alteia credentials list [OPTIONS]\n```\n\n**Options**:\n\n* `--company TEXT`: Company identifier.\n* `--help`: Show this message and exit.\n\n## `alteia products`\n\nInteract with products.\n\n**Usage**:\n\n```console\n$ alteia products [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `cancel`: Cancel a running product.\n* `list`: List the products\n* `logs`: Retrieve the logs of a product.\n\n### `alteia products cancel`\n\nCancel a running product.\n\n**Usage**:\n\n```console\n$ alteia products cancel [OPTIONS] PRODUCT_ID\n```\n\n**Arguments**:\n\n* `PRODUCT_ID`: [required]\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n### `alteia products list`\n\nList the products \n\n**Usage**:\n\n```console\n$ alteia products list [OPTIONS]\n```\n\n**Options**:\n\n* `-n, --limit INTEGER RANGE`: Max number of products returned  [default: 10]\n* `--analytic TEXT`: Analytic name\n* `--company TEXT`: Company identifier\n* `--status [pending|processing|available|rejected|failed]`: Product status\n* `--all`: If set, display also the products from platform analytics (otherwise only products from custom analytics are displayed).  [default: False]\n* `--help`: Show this message and exit.\n\n### `alteia products logs`\n\nRetrieve the logs of a product.\n\n**Usage**:\n\n```console\n$ alteia products logs [OPTIONS] PRODUCT_ID\n```\n\n**Arguments**:\n\n* `PRODUCT_ID`: [required]\n\n**Options**:\n\n* `-f, --follow`: Follow logs.  [default: False]\n* `--help`: Show this message and exit.\n\n\n----\n*Generated with `python -m typer_cli alteia_cli/main.py utils docs --name alteia`*\n',
    'author': 'Alteia Backend Team',
    'author_email': 'backend-team@alteia.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
