
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: ContribPlugin(BuildFileAddress(contrib/scalajs/src/python/pants/contrib/scalajs/BUILD, plugin))

from setuptools import setup

setup(**
{   'classifiers': [   'Intended Audience :: Developers',
                       'License :: OSI Approved :: Apache Software License',
                       'Operating System :: MacOS :: MacOS X',
                       'Operating System :: POSIX :: Linux',
                       'Programming Language :: Python',
                       'Topic :: Software Development :: Build Tools'],
    'description': 'scala.js support for pants.',
    'entry_points': {   'pantsbuild.plugin': [   'build_file_aliases = pants.contrib.scalajs.register:build_file_aliases',
                                                 'register_goals = pants.contrib.scalajs.register:register_goals',
                                                 'global_subsystems = pants.contrib.scalajs.register:global_subsystems']},
    'install_requires': [   'pantsbuild.pants.contrib.node==1.4.0',
                            'pantsbuild.pants==1.4.0'],
    'license': 'Apache License, Version 2.0',
    'long_description': 'Pants is an Apache2 licensed build tool written in Python.\n\nThe latest documentation can be found `here <http://pantsbuild.org/>`_.\n\n1.4.x Stable Releases\n=====================\n\nThis document describes releases leading up to the ``1.4.x`` ``stable`` series.\n\n1.4.0 (03/10/2018)\n------------------\n\nThe ``1.4.0`` stable release, with no additional changes since the ``rc5`` release. Thanks for\nyour patience!\n\nA quick summary of the changes since the ``1.3.x`` branch:\n\n* ``pantsd`` should be usable for almost all usecases, although it is not `quite`\n  ready to enable by default. Please try it out!\n* There are a few new contrib plugins: ``codeanalysis`` (aka: kythe), ``thrifty``, ``avro``,\n  ``mypy``, ``confluence``.\n* Both pytest and junit now have support for ``--chroot`` and a ``files(..)`` target was added\n  to support loose-file isolation in unit tests, and to improve the safety of test caching.\n* junit also gained support for ``--no-fast``, allowing running each ``junit_test`` target in\n  a separate VM.\n* Beta support for ``coursier`` for artifact resolving: expected to be stable in the\n  ``1.5.x`` release series.\n* PEX files support bringing interpreter constraints with them to their runtime\n  environment: see `PR #5160 <https://github.com/pantsbuild/pants/pull/5160>`_.\n* Improvements to the ``missing-dep-suggest`` task that runs when ``strict_deps`` is enabled\n  for a Java or Scala target.\n* The ``--cache-ignore`` option was added to support forcing a rebuild of any particular\n  task without requiring clean-all. Particularly helpful in these early days of test caching!\n* Pants reports per-target compile and test times to its stats URL via a general\n  "target-level metrics" API. Add per-target stats for your Tasks!\n* ``java_thrift_library`` now takes a ``compiler_args`` property, which deprecates ``rpc_style``\n  and ``language``.\n* "implicit sources" are now enabled by default! If you do not specify a ``sources`` argument\n  on your target, a default sources glob will be used.\n  See https://www.pantsbuild.org/build_files.html for more info.\n\nSee the rest of this page for the complete list of changes.\n\n1.4.0rc5 (03/07/2018)\n---------------------\n\nThe sixth release candidate for the ``1.4.x`` stable branch.\n\nBugfixes\n~~~~~~~~\n\n* Improve the performance of v2 changed. (#5571)\n  `PR #5571 <https://github.com/pantsbuild/pants/pull/5571>`_\n\n1.4.0rc4 (03/06/2018)\n---------------------\n\nThe fifth release candidate for the ``1.4.x`` stable branch.\n\nBugfixes\n~~~~~~~~\n\n* Set thrifty build_file_aliases (#5559) (#5562)\n  `PR #5559 <https://github.com/pantsbuild/pants/pull/5559>`_\n\n1.4.0rc3 (03/05/2018)\n---------------------\n\nThe fourth release candidate for the ``1.4.x`` stable branch.\n\nNew Features\n~~~~~~~~~~~~\n\n* Thrifty support for pants (#5531)\n  `PR #5531 <https://github.com/pantsbuild/pants/pull/5531>`_\n\nBugfixes\n~~~~~~~~\n\n* [pantsd] Repair end to end runtracker timing for pantsd runs. (#5526)\n  `PR #5526 <https://github.com/pantsbuild/pants/pull/5526>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* [pantsd] Repair pantsd integration tests for execution via pantsd. (#5387)\n  `PR #5387 <https://github.com/pantsbuild/pants/pull/5387>`_\n\n1.4.0rc2 (02/23/2018)\n---------------------\n\nThe third release candidate for the ``1.4.x`` stable branch; likely the last!\n\nNew Features\n~~~~~~~~~~~~\n\n* Add pantsd client profiling (#5434)\n  `PR #5434 <https://github.com/pantsbuild/pants/pull/5434>`_\n\n* Release script allows wheel listing (#5431)\n  `PR #5431 <https://github.com/pantsbuild/pants/pull/5431>`_\n\nBugfixes\n~~~~~~~~\n\n* [pantsd] Set the remote environment for pantsd-runner and child processes. (#5508)\n  `PR #5508 <https://github.com/pantsbuild/pants/pull/5508>`_\n\n* Bump release.sh to pex 1.2.16. (#5460)\n  `PR #5460 <https://github.com/pantsbuild/pants/pull/5460>`_\n\n* Get version from version file not by running pants (#5428)\n  `PR #5428 <https://github.com/pantsbuild/pants/pull/5428>`_\n\n* [pantsd] Don\'t invalidate on surface name changes to config/rc files. (#5408)\n  `PR #5408 <https://github.com/pantsbuild/pants/pull/5408>`_\n\n* Set the log level when capturing logs in tests. (#5418)\n  `PR #5418 <https://github.com/pantsbuild/pants/pull/5418>`_\n\n1.4.0rc1 (01/28/2018)\n---------------------\n\nThe second release candidate for the ``1.4.x`` stable branch.\n\nNew Features\n~~~~~~~~~~~~\n\n* [pantsd] Add pantsd graph warmth stats. (#5374)\n  `PR #5374 <https://github.com/pantsbuild/pants/pull/5374>`_\n\n* [contrib/scrooge] Add exports support to scrooge (#5357)\n  `PR #5357 <https://github.com/pantsbuild/pants/pull/5357>`_\n\n* add avro/java contrib plugin to the release process (#5346)\n  `PR #5346 <https://github.com/pantsbuild/pants/pull/5346>`_\n\n* An --eager option for BootstrapJvmTools. (#5336)\n  `PR #5336 <https://github.com/pantsbuild/pants/pull/5336>`_\n\n* Publish the codeanalysis contrib plugin. (#5322)\n  `PR #5322 <https://github.com/pantsbuild/pants/pull/5322>`_\n\n* Add the mypy contrib module to pants release process (#5335)\n  `PR #5335 <https://github.com/pantsbuild/pants/pull/5335>`_\n\nAPI Changes\n~~~~~~~~~~~\n\n* [pantsd] Bump to watchman 4.9.0-pants1. (#5386)\n  `PR #5386 <https://github.com/pantsbuild/pants/pull/5386>`_\n\n* Bump to pex==1.2.16. (#5355)\n  `PR #5355 <https://github.com/pantsbuild/pants/pull/5355>`_\n\n* Deprecate the v1 engine option. (#5338)\n  `PR #5338 <https://github.com/pantsbuild/pants/pull/5338>`_\n\nBugfixes\n~~~~~~~~\n\n* [pantsd] Repair console interactivity in pantsd runs. (#5352)\n  `PR #5352 <https://github.com/pantsbuild/pants/pull/5352>`_\n\n* Repoint the \'current\' symlink even for valid VTs. (#5375)\n  `PR #5375 <https://github.com/pantsbuild/pants/pull/5375>`_\n\n* Do not download node package multiple times (#5372)\n  `PR #5372 <https://github.com/pantsbuild/pants/pull/5372>`_\n\n* Ensure test report results are always exposed. (#5368)\n  `PR #5368 <https://github.com/pantsbuild/pants/pull/5368>`_\n\n* Fix a silly bug when computing indexable targets. (#5359)\n  `PR #5359 <https://github.com/pantsbuild/pants/pull/5359>`_\n\n* python2: do not resolve requirements if no python targets in targets closure (#5361)\n  `PR #5361 <https://github.com/pantsbuild/pants/pull/5361>`_\n\n* [pantsd] Repair daemon wedge on log rotation. (#5358)\n  `PR #5358 <https://github.com/pantsbuild/pants/pull/5358>`_\n\n* Reenable lighter contrib sanity checks (#5340)\n  `PR #5340 <https://github.com/pantsbuild/pants/pull/5340>`_\n\n* Remove wiki-related targets from contrib and back to docgen (#5319)\n  `PR #5319 <https://github.com/pantsbuild/pants/pull/5319>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Single resolve with coursier (#5362)\n  `Issue #743 <https://github.com/coursier/coursier/issues/743>`_\n  `PR #5362 <https://github.com/pantsbuild/pants/pull/5362>`_\n  `PR #735 <https://github.com/coursier/coursier/pull/735>`_\n\n* Port IsolatedProcess implementation from Python to Rust - Split 1  (#5239)\n  `PR #5239 <https://github.com/pantsbuild/pants/pull/5239>`_\n\n* Remove superfluous --dist flag from kythe indexer task. (#5344)\n  `PR #5344 <https://github.com/pantsbuild/pants/pull/5344>`_\n\n* add mypy to list of released plugins in docs (#5341)\n  `PR #5341 <https://github.com/pantsbuild/pants/pull/5341>`_\n\n* Add support for alternate packages in the pex that is built. (#5283)\n  `PR #5283 <https://github.com/pantsbuild/pants/pull/5283>`_\n\n* Update lockfile for fs_util (#5326)\n  `PR #5326 <https://github.com/pantsbuild/pants/pull/5326>`_\n\n1.4.0rc0 (01/12/2018)\n---------------------\n\nThe first release candidate for the ``1.4.x`` stable branch.\n\nIt\'s been many months since the ``1.3.x`` branch was cut: part of this was due to a decision\nto tie "enabling pantsd by default" to the ``1.4.0`` release. It\'s taken longer to stabilize\npantsd than we initially anticipated, and while we\'re very nearly comfortable with enabling it\nby default, we believe that we should be prioritizing frequent stable minor releases over\nreleases being tied to particular features. So let\'s do this thing!\n\nNew Features\n~~~~~~~~~~~~\n\n* Introduce a single-target mode to `JUnitRun`. (#5302)\n  `PR #5302 <https://github.com/pantsbuild/pants/pull/5302>`_\n\n* Remote ByteStore can write to a CAS (#5293)\n  `PR #5293 <https://github.com/pantsbuild/pants/pull/5293>`_\n\n* Improvements to the kythe extractor and indexer tasks. (#5297)\n  `PR #5297 <https://github.com/pantsbuild/pants/pull/5297>`_\n\nAPI Changes\n~~~~~~~~~~~\n\n* Rename the `kythe` package to `codeanalysis` (#5299)\n  `PR #5299 <https://github.com/pantsbuild/pants/pull/5299>`_\n\nBugfixes\n~~~~~~~~\n\n* Fix junit code coverage to be off by default. (#5306)\n  `PR #5306 <https://github.com/pantsbuild/pants/pull/5306>`_\n\n* Actually use the merge and report tool classpaths. (#5308)\n  `PR #5308 <https://github.com/pantsbuild/pants/pull/5308>`_\n\n* url quote classpath in MANIFEST.MF (#5301)\n  `PR #5301 <https://github.com/pantsbuild/pants/pull/5301>`_\n\n* Fix coursier resolve missing excludes for classpath product (#5298)\n  `PR #5298 <https://github.com/pantsbuild/pants/pull/5298>`_\n\n* Fix junit caching under coverage. (#5289)\n  `PR #5289 <https://github.com/pantsbuild/pants/pull/5289>`_\n\n* mypy plugin: add support for a mypy config file (#5296)\n  `PR #5296 <https://github.com/pantsbuild/pants/pull/5296>`_\n\n* Make the ivy resolution confs participate in the fingerprint. (#5270)\n  `PR #5270 <https://github.com/pantsbuild/pants/pull/5270>`_\n\n* Check in fs_util lockfile (#5275)\n  `PR #5275 <https://github.com/pantsbuild/pants/pull/5275>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* [pantsd] Add debug logging utils. (#5313)\n  `PR #5313 <https://github.com/pantsbuild/pants/pull/5313>`_\n\n* Move grpc mocks to their own crate (#5305)\n  `PR #5305 <https://github.com/pantsbuild/pants/pull/5305>`_\n\n* Move hashing utilities into their own crate (#5304)\n  `PR #5304 <https://github.com/pantsbuild/pants/pull/5304>`_\n\n* Merge coverage per-batch. (#5286)\n  `PR #5286 <https://github.com/pantsbuild/pants/pull/5286>`_\n\n* Update cargo lockfiles (#5291)\n  `PR #5291 <https://github.com/pantsbuild/pants/pull/5291>`_\n\n* Install packages required to build a pants release (#5292)\n  `PR #5292 <https://github.com/pantsbuild/pants/pull/5292>`_\n\n* travis_ci Dockerfile actually works not on travis (#5278)\n  `PR #5278 <https://github.com/pantsbuild/pants/pull/5278>`_\n\n* Update grpcio to 0.2.0 (#5269)\n  `PR #5269 <https://github.com/pantsbuild/pants/pull/5269>`_\n\n1.4.0.dev27 (01/05/2018)\n------------------------\n\nNew Features\n~~~~~~~~~~~~\n\n* Support for finding all the targets derived from a given target. (#5271)\n  `PR #5271 <https://github.com/pantsbuild/pants/pull/5271>`_\n\n* Support merging of junit xml in reports. (#5257)\n  `PR #5257 <https://github.com/pantsbuild/pants/pull/5257>`_\n\nBugfixes\n~~~~~~~~\n\n* [pantsd] Scrub PANTS_ENTRYPOINT env var upon use. (#5262)\n  `PR #5262 <https://github.com/pantsbuild/pants/pull/5262>`_\n\n* Fix junit report data loss under batching. (#5259)\n  `PR #5259 <https://github.com/pantsbuild/pants/pull/5259>`_\n\n* add safe extract for archivers (#5248)\n  `PR #5248 <https://github.com/pantsbuild/pants/pull/5248>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Bump rust version. (#5274)\n  `PR #5274 <https://github.com/pantsbuild/pants/pull/5274>`_\n\n* Deprecate legacy junit "public" workdir reports. (#5267)\n  `PR #5267 <https://github.com/pantsbuild/pants/pull/5267>`_\n\n* Upgrade to jacoco 0.8.0. (#5268)\n  `PR #5268 <https://github.com/pantsbuild/pants/pull/5268>`_\n\n* [pantsd] Kill dead method. (#5263)\n  `PR #5263 <https://github.com/pantsbuild/pants/pull/5263>`_\n\n* Give travis just the AWS permissions it needs. (#5261)\n  `PR #5261 <https://github.com/pantsbuild/pants/pull/5261>`_\n\n* Relocate stable_json_sha1 to hash_utils. (#5258)\n  `PR #5258 <https://github.com/pantsbuild/pants/pull/5258>`_\n\n1.4.0.dev26 (12/30/2017)\n------------------------\n\nNew Features\n~~~~~~~~~~~~\n\n* Add [resolve.coursier] as an experimental task (#5133)\n  `PR #5133 <https://github.com/pantsbuild/pants/pull/5133>`_\n\n* mypy contrib plugin (#5172)\n  `PR #5172 <https://github.com/pantsbuild/pants/pull/5172>`_\n\nBugfixes\n~~~~~~~~\n\n* Swap stdio file descriptors at the os level (#5247)\n  `PR #5247 <https://github.com/pantsbuild/pants/pull/5247>`_\n\n* Don\'t render cancelled nodes in trace (#5252)\n  `PR #5252 <https://github.com/pantsbuild/pants/pull/5252>`_\n\n* Correction on ensure_resolver (#5250)\n  `PR #5250 <https://github.com/pantsbuild/pants/pull/5250>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Support fetching sources and javadoc in export using coursier (#5254)\n  `PR #5254 <https://github.com/pantsbuild/pants/pull/5254>`_\n\n1.4.0.dev25 (12/22/2017)\n------------------------\n\nNew Features\n~~~~~~~~~~~~\n* Integrate PEX interpreter selection based on target-level interpreter compatibility constraints (#5160)\n  `PR #5160 <https://github.com/pantsbuild/pants/pull/5160>`_\n\n* Import statements can be banned in BUILD files (#5180)\n  `PR #5180 <https://github.com/pantsbuild/pants/pull/5180>`_\n\nBugfixes\n~~~~~~~~\n\n* revert log statement edits from #5170 that break console logging (#5233)\n  `PR #5233 <https://github.com/pantsbuild/pants/pull/5233>`_\n\n* [pantsd] Repair daemon lifecycle options fingerprinting. (#5232)\n  `PR #5232 <https://github.com/pantsbuild/pants/pull/5232>`_\n\n* use task fingerprint for build invalidation to avoid `results_dir` clashes (#5170)\n  `PR #5170 <https://github.com/pantsbuild/pants/pull/5170>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n* [pantsd] Bump watchman version. (#5238)\n  `PR #5238 <https://github.com/pantsbuild/pants/pull/5238>`_\n\n* [pantsd] Improve stream latency by disabling Nagle\'s algorithm. (#5237)\n  `PR #5237 <https://github.com/pantsbuild/pants/pull/5237>`_\n\n* Log and increase pantsd startup timeout (#5231)\n  `PR #5231 <https://github.com/pantsbuild/pants/pull/5231>`_\n\n* [pantsd] Improve artifact cache progress output when daemon is enabled. (#5236)\n  `PR #5236 <https://github.com/pantsbuild/pants/pull/5236>`_\n\n* download_binary.sh takes hostname as a parameter (#5234)\n  `PR #5234 <https://github.com/pantsbuild/pants/pull/5234>`_\n\n* Kill noisy NodeModule.__init__() debug logging. (#5215)\n  `PR #5215 <https://github.com/pantsbuild/pants/pull/5215>`_\n\n* TargetRoots always requires options (#5217)\n  `PR #5217 <https://github.com/pantsbuild/pants/pull/5217>`_\n\n\n1.4.0.dev24 (12/16/2017)\n------------------------\n\nAPI Changes\n~~~~~~~~~~~\n* Add --ignore-optional commandline flag for yarn install process. (#5209)\n  `PR #5209 <https://github.com/pantsbuild/pants/pull/5209>`_\n\nNew Features\n~~~~~~~~~~~~\n* contrib plugin for Avro/Java code generation (#5144)\n  `PR #5144 <https://github.com/pantsbuild/pants/pull/5144>`_\n\n* Release fs_util as part of the regular release (#5196)\n  `PR #5196 <https://github.com/pantsbuild/pants/pull/5196>`_\n\nBugfixes\n~~~~~~~~\n* Cross-compiling Go binaries works (#5197)\n  `PR #5197 <https://github.com/pantsbuild/pants/pull/5197>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n* Log if artifact downloads are slow (#5208)\n  `PR #5208 <https://github.com/pantsbuild/pants/pull/5208>`_\n\n* [pantsd] Improve service locking. (#5201)\n  `PR #5201 <https://github.com/pantsbuild/pants/pull/5201>`_\n\n* Fix RunTracker re-initialization with pantsd (#5211)\n  `PR #5211 <https://github.com/pantsbuild/pants/pull/5211>`_\n\n* [pantsd] Catch ESRCH on os.kill of pantsd-runner. (#5213)\n  `PR #5213 <https://github.com/pantsbuild/pants/pull/5213>`_\n\n* Update junit-runner to 1.0.23 (#5206)\n  `PR #5206 <https://github.com/pantsbuild/pants/pull/5206>`_\n\n* Reset swappable streams in JUnit runner before closing the TeeOutputStreams to the log files and close XML Files after use (#5204)\n  `PR #5204 <https://github.com/pantsbuild/pants/pull/5204>`_\n\n* Use centos6 in travis, and remove the wheezy image. (#5202)\n  `PR #5202 <https://github.com/pantsbuild/pants/pull/5202>`_\n\n* Add a centos6 Dockerfile (#5167)\n  `PR #5167 <https://github.com/pantsbuild/pants/pull/5167>`_\n\n* Add integration test to cover the fix for #5169. (#5192)\n  `PR #5192 <https://github.com/pantsbuild/pants/pull/5192>`_\n\n* [pantsd] Repair stdio truncation. (#5156)\n  `PR #5156 <https://github.com/pantsbuild/pants/pull/5156>`_\n\n\n1.4.0.dev23 (12/08/2017)\n------------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Relativize the classpaths that are recorded during a JVM compile (#5139)\n  `PR #5139 <https://github.com/pantsbuild/pants/pull/5139>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* fs_util backfills from remote CAS if --server-address is set (#5179)\n  `PR #5179 <https://github.com/pantsbuild/pants/pull/5179>`_\n\n* Store backfills from a remote CAS (#5166)\n  `PR #5166 <https://github.com/pantsbuild/pants/pull/5166>`_\n\n* ByteStore impl for reading from the gRPC ContentAddressableStorage service (#5155)\n  `PR #5155 <https://github.com/pantsbuild/pants/pull/5155>`_\n\n* Add the ability to build a pex to the release script (#5159)\n  `PR #5159 <https://github.com/pantsbuild/pants/pull/5159>`_\n\nBugfixes\n~~~~~~~~\n\n* Installing a duplicate task into a goal should not throw error if replace=True (#5188)\n  `PR #5188 <https://github.com/pantsbuild/pants/pull/5188>`_\n\n* Close suiteCaptures after all tests are finished instead of after each test (#5173)\n  `PR #5173 <https://github.com/pantsbuild/pants/pull/5173>`_\n\n* Fix thrift handling in the new python pipeline. (#5168)\n  `PR #5168 <https://github.com/pantsbuild/pants/pull/5168>`_\n\n* [pantsd] Improve SIGQUIT handling in the thin client. (#5177)\n  `PR #5177 <https://github.com/pantsbuild/pants/pull/5177>`_\n\n* Fix showing test output that happens after the tests are finished (#5165)\n  `PR #5165 <https://github.com/pantsbuild/pants/pull/5165>`_\n\n* Post suffixed-wheel release fixups (#5152)\n  `PR #5152 <https://github.com/pantsbuild/pants/pull/5152>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Remove scheduler lock (#5178)\n  `PR #5178 <https://github.com/pantsbuild/pants/pull/5178>`_\n\n* Kill obsolete `ThritNamespacePackagesTest`. (#5183)\n  `PR #5183 <https://github.com/pantsbuild/pants/pull/5183>`_\n\n* Prefactor Store wrapper (#5154)\n  `PR #5154 <https://github.com/pantsbuild/pants/pull/5154>`_\n\n1.4.0.dev22 (12/01/2017)\n------------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Refer to Buildozer 0.6.0.dce8b3c287652cbcaf43c8dd076b3f48c92ab44c (#5107)\n  `PR #5107 <https://github.com/pantsbuild/pants/pull/5107>`_\n  `PR #154 <https://github.com/bazelbuild/buildtools/pull/154>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* go fetching handles multiple meta tags (#5119)\n  `PR #5119 <https://github.com/pantsbuild/pants/pull/5119>`_\n\n* Snapshots can be captured as store-backed Directories as well as tar files. (#5105)\n  `PR #5105 <https://github.com/pantsbuild/pants/pull/5105>`_\n\nBugfixes\n~~~~~~~~\n\n* Re-generate protos if the proto compiler changes (#5138)\n  `PR #5138 <https://github.com/pantsbuild/pants/pull/5138>`_\n\n* Update gRPC to fix OSX compile issues (#5135)\n  `Issue #4975 <https://github.com/pantsbuild/pants/issues/4975>`_\n  `PR #5135 <https://github.com/pantsbuild/pants/pull/5135>`_\n\n* Use a particular git SHA to stabilize binary fetching. (#5137)\n  `PR #5137 <https://github.com/pantsbuild/pants/pull/5137>`_\n\n* Remove requirement for root build file in `changed` (#5134)\n  `PR #5134 <https://github.com/pantsbuild/pants/pull/5134>`_\n\n* Kill background cargo fetch on ^C (#5128)\n  `Issue #5125 <https://github.com/pantsbuild/pants/issues/5125>`_\n  `PR #5128 <https://github.com/pantsbuild/pants/pull/5128>`_\n\n* Expose `jax_ws_library` target in `jax_ws` plugin. (#5122)\n  `PR #5122 <https://github.com/pantsbuild/pants/pull/5122>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Build suffixed pants wheels for non-releases (#5118)\n  `PR #5118 <https://github.com/pantsbuild/pants/pull/5118>`_\n\n* Change meta-rename options to non-advanced (#5124)\n  `PR #5124 <https://github.com/pantsbuild/pants/pull/5124>`_\n\n* Remove GetNode trait (#5123)\n  `PR #5123 <https://github.com/pantsbuild/pants/pull/5123>`_\n\n* Async Store (#5117)\n  `PR #5117 <https://github.com/pantsbuild/pants/pull/5117>`_\n\n* Fix references to missing content (copied from internal doc). (#5015)\n  `PR #5015 <https://github.com/pantsbuild/pants/pull/5015>`_\n\n1.4.0.dev21 (11/17/2017)\n------------------------\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Extract resettable pool logic for reuse (#5110)\n  `PR #5110 <https://github.com/pantsbuild/pants/pull/5110>`_\n\n* Update rust to 1.21.0 (#5113)\n  `PR #5113 <https://github.com/pantsbuild/pants/pull/5113>`_\n\n* Make SelectTransitive a Node in the graph again.  (#5109)\n  `PR #5109 <https://github.com/pantsbuild/pants/pull/5109>`_\n\n* is_ignored takes a Stat, not a Path and bool (#5112)\n  `PR #5112 <https://github.com/pantsbuild/pants/pull/5112>`_\n\n* Allow file content digests to be computed and memoized in the graph (#5104)\n  `PR #5104 <https://github.com/pantsbuild/pants/pull/5104>`_\n\n* Remove inlining in favor of executing directly (#5095)\n  `PR #5095 <https://github.com/pantsbuild/pants/pull/5095>`_\n\n* Introduce a Digest type (#5103)\n  `PR #5103 <https://github.com/pantsbuild/pants/pull/5103>`_\n\n* Move snapshot to its own file (#5102)\n  `PR #5102 <https://github.com/pantsbuild/pants/pull/5102>`_\n\n* Use (git)ignore to implement excludes (#5097)\n  `PR #5097 <https://github.com/pantsbuild/pants/pull/5097>`_\n\n* Include mode in engine cache key (#5096)\n  `PR #5096 <https://github.com/pantsbuild/pants/pull/5096>`_\n\n* Update hex to 0.3.1 (#5094)\n  `PR #5094 <https://github.com/pantsbuild/pants/pull/5094>`_\n\n* Rename local_store_path arg to local-store-path (#5092)\n  `PR #5092 <https://github.com/pantsbuild/pants/pull/5092>`_\n\n* `fs_util directory save` takes root (#5074)\n  `PR #5074 <https://github.com/pantsbuild/pants/pull/5074>`_\n\nDocumentation Updates\n~~~~~~~~~~~~~~~~~~~~~\n\n* Update confluence deprecation warning (#5098)\n  `PR #5098 <https://github.com/pantsbuild/pants/pull/5098>`_\n\n* Add scalac strict_dep error regexes and update logic to compare partial classnames to target closure\'s classes (#5093)\n  `PR #5093 <https://github.com/pantsbuild/pants/pull/5093>`_\n\n\n1.4.0.dev20 (11/11/2017)\n------------------------\n\nNew Features\n~~~~~~~~~~~~\n\n* Allow custom definition of Python PEX shebang (#3630) (#4514)\n  `PR #3630 <https://github.com/pantsbuild/pants/pull/3630>`_\n\n* Support running python tests in the pex chroot. (#5033)\n  `PR #5033 <https://github.com/pantsbuild/pants/pull/5033>`_\n\nAPI Changes\n~~~~~~~~~~~\n\n* Bump to jarjar 1.6.5 to pull in https://github.com/pantsbuild/jarjar/pull/30 (#5087)\n  `PR #5087 <https://github.com/pantsbuild/pants/pull/5087>`_\n  `PR #30 <https://github.com/pantsbuild/jarjar/pull/30>`_\n\n* Update cmake to 3.9.5 (#5072)\n  `Issue #4975#issuecomment-342562504 <https://github.com/pantsbuild/pants/issues/4975#issuecomment-342562504>`_\n  `PR #5072 <https://github.com/pantsbuild/pants/pull/5072>`_\n\nBugfixes\n~~~~~~~~\n\n* Fix `PythonInterpreterCache`. (#5089)\n  `PR #5089 <https://github.com/pantsbuild/pants/pull/5089>`_\n\n* Call wsimport script instead of using tools.jar so jax-ws will work on java 9 (#5078)\n  `PR #5078 <https://github.com/pantsbuild/pants/pull/5078>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Prepare the second release candidate. (#5088)\n  `PR #5088 <https://github.com/pantsbuild/pants/pull/5088>`_\n\n* Inline mis-documented `select_interpreter` method. (#5085)\n  `PR #5085 <https://github.com/pantsbuild/pants/pull/5085>`_\n\n* fs_util cat <fingerprint> (#5066)\n  `PR #5066 <https://github.com/pantsbuild/pants/pull/5066>`_\n\n* Add support for proxying stdin with pantsd (#5040)\n  `PR #5040 <https://github.com/pantsbuild/pants/pull/5040>`_\n\n* `fs_util directory cat-proto` supports text format output (#5083)\n  `PR #5083 <https://github.com/pantsbuild/pants/pull/5083>`_\n\n* Add a VFS impl for PosixFS. (#5079)\n  `PR #5079 <https://github.com/pantsbuild/pants/pull/5079>`_\n\n* `fs_util directory materialize` (#5075)\n  `PR #5075 <https://github.com/pantsbuild/pants/pull/5075>`_\n\n* Fix broken test due to changed git cmd line (#5076)\n  `PR #5076 <https://github.com/pantsbuild/pants/pull/5076>`_\n\n* Canonicalize path before taking its parent (#5052)\n  `PR #5052 <https://github.com/pantsbuild/pants/pull/5052>`_\n\n* Fix test compile (#5069)\n  `PR #5069 <https://github.com/pantsbuild/pants/pull/5069>`_\n  `PR #5065 <https://github.com/pantsbuild/pants/pull/5065>`_\n\n* fs_util directory cat-proto <fingerprint> (#5065)\n  `PR #5065 <https://github.com/pantsbuild/pants/pull/5065>`_\n\n* fs_util exits 2 for ENOENT (#5064)\n  `PR #5064 <https://github.com/pantsbuild/pants/pull/5064>`_\n\n* Fixup sdist release. (#5067)\n  `PR #5067 <https://github.com/pantsbuild/pants/pull/5067>`_\n\n* Fixup `./build-support/bin/release.sh -t`. (#5062)\n  `PR #5062 <https://github.com/pantsbuild/pants/pull/5062>`_\n\n\n1.4.0.dev19 (11/04/2017)\n------------------------\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Pass the `color` option through to the report factory. (#5055)\n  `PR #5055 <https://github.com/pantsbuild/pants/pull/5055>`_\n\n* Output size as well as fingerprint (#5053)\n  `PR #5053 <https://github.com/pantsbuild/pants/pull/5053>`_\n\n* [pantsd] Daemon lifecycle for options changes. (#5045)\n  `PR #5045 <https://github.com/pantsbuild/pants/pull/5045>`_\n\n* Convert fs_util to use futures (#5048)\n  `PR #5048 <https://github.com/pantsbuild/pants/pull/5048>`_\n\n* PosixFS can create a Stat from a Path (#5047)\n  `PR #5047 <https://github.com/pantsbuild/pants/pull/5047>`_\n\n* PosixFS can read file contents (#5043)\n  `PR #5043 <https://github.com/pantsbuild/pants/pull/5043>`_\n\n* Bump to zinc 1.0.3. (#5049)\n  `Issue #389, <https://github.com/sbt/zinc/issues/389,>`_\n  `PR #5049 <https://github.com/pantsbuild/pants/pull/5049>`_\n\n* fs::Stat::File includes whether a file is executable (#5042)\n  `PR #5042 <https://github.com/pantsbuild/pants/pull/5042>`_\n\n* Add configurable message when missing-deps-suggest doesn\'t have suggestions (#5036)\n  `PR #5036 <https://github.com/pantsbuild/pants/pull/5036>`_\n\n* Use split_whitespace for parsing of cflags. (#5038)\n  `PR #5038 <https://github.com/pantsbuild/pants/pull/5038>`_\n\nBugfixes\n~~~~~~~~\n\n* [pantsd] Set sys.argv correctly on pantsd-runner fork. (#5051)\n  `PR #5051 <https://github.com/pantsbuild/pants/pull/5051>`_\n\n* Fix JarCreate invalidation in the presence of changing resources. (#5030)\n  `PR #5030 <https://github.com/pantsbuild/pants/pull/5030>`_\n\nDocumentation Updates\n~~~~~~~~~~~~~~~~~~~~~\n\n* Minor improvement on dep-usage doc (#5041)\n  `PR #5041 <https://github.com/pantsbuild/pants/pull/5041>`_\n\n* Add documentation about strict deps (#5025)\n  `PR #5025 <https://github.com/pantsbuild/pants/pull/5025>`_\n\n\n1.4.0.dev18 (10/29/2017)\n------------------------\n\nNew Features\n~~~~~~~~~~~~\n* Dedup dependencies output (#5029)\n  `PR #5029 <https://github.com/pantsbuild/pants/pull/5029>`_\n\n* [simple-code-gen] extension point for injecting extra exports (#4976)\n  `PR #4976 <https://github.com/pantsbuild/pants/pull/4976>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n* Use the script verified identity when signing. (#5032)\n  `PR #5032 <https://github.com/pantsbuild/pants/pull/5032>`_\n\n* Have twine use the previously established pgp key during release. (#5031)\n  `PR #5031 <https://github.com/pantsbuild/pants/pull/5031>`_\n\n1.4.0.dev17 (10/27/2017)\n------------------------\n\nNew Features\n~~~~~~~~~~~~\n* Move confluence related things to contrib (#4986)\n  `PR #4986 <https://github.com/pantsbuild/pants/pull/4986>`_\n\n* Add custom commands to the `buildozer` goal (#4998)\n  `PR #4998 <https://github.com/pantsbuild/pants/pull/4998>`_\n  `PR #4921 <https://github.com/pantsbuild/pants/pull/4921>`_\n  `PR #4882 <https://github.com/pantsbuild/pants/pull/4882>`_\n\n* Working implementation of jacoco. (#4978)\n  `PR #4978 <https://github.com/pantsbuild/pants/pull/4978>`_\n\nAPI Changes\n~~~~~~~~~~~\n* [pantsd] Launch the daemon via a subprocess call. (#5021)\n  `PR #5021 <https://github.com/pantsbuild/pants/pull/5021>`_\n\n* Fix support for custom javac definitions (#5024)\n  `PR #5024 <https://github.com/pantsbuild/pants/pull/5024>`_\n\n* Transform scopes in pants.ini that have been subsumed by global options. (#5007)\n  `PR #5007 <https://github.com/pantsbuild/pants/pull/5007>`_\n\n* Coverage isn\'t enabled by default (#5009)\n  `PR #5009 <https://github.com/pantsbuild/pants/pull/5009>`_\n  `PR #4881 <https://github.com/pantsbuild/pants/pull/4881>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n* Content-addressable {file,directory} store and utility (#5012)\n  `PR #5012 <https://github.com/pantsbuild/pants/pull/5012>`_\n\n* Use the service deps if the target declares an exception. (#5017)\n  `PR #5017 <https://github.com/pantsbuild/pants/pull/5017>`_\n\n* Pass references to Paths (#5022)\n  `PR #5022 <https://github.com/pantsbuild/pants/pull/5022>`_\n\n* Replace Blake2 with Sha256 (#5014)\n  `PR #5014 <https://github.com/pantsbuild/pants/pull/5014>`_\n\n* Revert pytest successful test caching in CI. (#5016)\n  `PR #5016 <https://github.com/pantsbuild/pants/pull/5016>`_\n\n* Fingerprint has from_hex_string, as_bytes, Display, and Debug (#5013)\n  `PR #5013 <https://github.com/pantsbuild/pants/pull/5013>`_\n\n* Fix memory leak in `./pants changed` (#5011)\n  `PR #5011 <https://github.com/pantsbuild/pants/pull/5011>`_\n\n* Prune travis cache (#5006)\n  `PR #5006 <https://github.com/pantsbuild/pants/pull/5006>`_\n\n* Utility to tee subprocess output to sys.std{out,err} and a buffer (#4967)\n  `PR #4967 <https://github.com/pantsbuild/pants/pull/4967>`_\n\n\n1.4.0.dev16 (10/20/2017)\n------------------------\n\nNew Features\n~~~~~~~~~~~~\n\n* Add `buildrefactor` to `contrib` and buildozer goal (#4921)\n  `PR #4921 <https://github.com/pantsbuild/pants/pull/4921>`_\n\n* Allow in-repo scalac plugins to have in-repo deps. (#4987)\n  `PR #4987 <https://github.com/pantsbuild/pants/pull/4987>`_\n\n* Add plugin for scalafix (#4635)\n  `PR #4635 <https://github.com/pantsbuild/pants/pull/4635>`_\n\nDocumentation Updates\n~~~~~~~~~~~~~~~~~~~~~\n\n* Remove outdated doc (#4989)\n  `PR #4989 <https://github.com/pantsbuild/pants/pull/4989>`_\n\nBugfixes\n~~~~~~~~\n\n* Invalidate parent directories (#5000)\n  `PR #5000 <https://github.com/pantsbuild/pants/pull/5000>`_\n\n* Enforce quiet option if not hardcoded (#4974)\n  `PR #4974 <https://github.com/pantsbuild/pants/pull/4974>`_\n\n* Refer to correct location of variable (#4994)\n  `PR #4994 <https://github.com/pantsbuild/pants/pull/4994>`_\n\n* Fix setting of PEX_PATH in ./pants run (v2 backend)  (#4969)\n  `PR #4969 <https://github.com/pantsbuild/pants/pull/4969>`_\n\n* Repair pytest timeout tests. (#4972)\n  `PR #4972 <https://github.com/pantsbuild/pants/pull/4972>`_\n\n* Add node_module .bin path to node / npm / yarnpkg execution path. (#4932)\n  `Issue #18233 <https://github.com/npm/npm/issues/18233>`_\n  `PR #4932 <https://github.com/pantsbuild/pants/pull/4932>`_\n  `PR #15900 <https://github.com/npm/npm/pull/15900>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Reduce time/package requirements on binary-builder shards (#4992)\n  `PR #4992 <https://github.com/pantsbuild/pants/pull/4992>`_\n\n* [pantsd] Launch the daemon via the thin client. (#4931)\n  `PR #4931 <https://github.com/pantsbuild/pants/pull/4931>`_\n\n* Extract fs and boxfuture crates (#4985)\n  `PR #4985 <https://github.com/pantsbuild/pants/pull/4985>`_\n\n* process_executor binary can do remote execution (#4980)\n  `PR #4980 <https://github.com/pantsbuild/pants/pull/4980>`_\n\n* Fix some minor textual and shell nits (#4841)\n  `PR #4841 <https://github.com/pantsbuild/pants/pull/4841>`_\n\n* Use more generic portion of `requests` exception message in tests. (#4981)\n  `PR #4981 <https://github.com/pantsbuild/pants/pull/4981>`_\n\n* Include target addresses which trigger deprecation warnings (#4979)\n  `PR #4979 <https://github.com/pantsbuild/pants/pull/4979>`_\n\n* Remote process execution works more generally (#4937)\n  `PR #4937 <https://github.com/pantsbuild/pants/pull/4937>`_\n\n* Extend timeout for cargo fetching git repos (#4971)\n  `PR #4971 <https://github.com/pantsbuild/pants/pull/4971>`_\n\n* Ignore Cargo.lock files for libraries (#4968)\n  `PR #4968 <https://github.com/pantsbuild/pants/pull/4968>`_\n\n* rm unused strategy concept from simple code gen tests (#4964)\n  `PR #4964 <https://github.com/pantsbuild/pants/pull/4964>`_\n\n* Fetch go and cmake as part of bootstrap (#4962)\n  `PR #4962 <https://github.com/pantsbuild/pants/pull/4962>`_\n  `PR #45 <https://github.com/pantsbuild/binaries/pull/45>`_\n\n* Make sure .cargo/config is respected for all cargo invocations (#4965)\n  `PR #4965 <https://github.com/pantsbuild/pants/pull/4965>`_\n\n* Restore to specifying /travis/home as a volume (#4960)\n  `PR #4960 <https://github.com/pantsbuild/pants/pull/4960>`_\n\n* Engine can request process execution via gRPC (#4929)\n  `PR #4929 <https://github.com/pantsbuild/pants/pull/4929>`_\n\n* Add back sdist generation and deployment. (#4957)\n  `PR #4957 <https://github.com/pantsbuild/pants/pull/4957>`_\n\n1.4.0.dev15 (10/7/2017)\n-----------------------\n\nNew Features\n~~~~~~~~~~~~\n\n* Send timing/cache report to stderr (#4946)\n  `PR #4946 <https://github.com/pantsbuild/pants/pull/4946>`_\n\n* Allow users to tell pants where to look for python interpreters (#4930)\n  `PR #4930 <https://github.com/pantsbuild/pants/pull/4930>`_\n\nBugfixes\n~~~~~~~~\n\n* Fix `BundleIntegrationTest`. (#4953)\n  `PR #4953 <https://github.com/pantsbuild/pants/pull/4953>`_\n\n* Pin Rust version to 1.20.0 (#4941)\n  `PR #4941 <https://github.com/pantsbuild/pants/pull/4941>`_\n\n* Remove bad string (#4942)\n  `PR #4942 <https://github.com/pantsbuild/pants/pull/4942>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Load the native engine lib from a pkg_resource. (#4914)\n  `PR #4914 <https://github.com/pantsbuild/pants/pull/4914>`_\n\n* Switch from rust-crypto to sha2 (#4951)\n  `PR #4951 <https://github.com/pantsbuild/pants/pull/4951>`_\n\n* Exclude target directories from rustfmt (#4950)\n  `PR #4950 <https://github.com/pantsbuild/pants/pull/4950>`_\n\n* Update tar to a released version (#4949)\n  `PR #4949 <https://github.com/pantsbuild/pants/pull/4949>`_\n\n* Mention name of binary we can\'t find (#4947)\n  `PR #4947 <https://github.com/pantsbuild/pants/pull/4947>`_\n\n* Reformat rust files (#4948)\n  `PR #4948 <https://github.com/pantsbuild/pants/pull/4948>`_\n\n* Bump cffi dep to latest (1.11.1). (#4944)\n  `PR #4944 <https://github.com/pantsbuild/pants/pull/4944>`_\n\n* Upgrade gcc to cc 1.0 (#4945)\n  `PR #4945 <https://github.com/pantsbuild/pants/pull/4945>`_\n\n* Preserve soft excludes bug while removing duplicates (#4940)\n  `PR #4940 <https://github.com/pantsbuild/pants/pull/4940>`_\n\n* Move --open-with under idea-plugin to regular options (#4939)\n  `PR #4939 <https://github.com/pantsbuild/pants/pull/4939>`_\n\n* Memoize strict deps and exports (#4934)\n  `PR #4934 <https://github.com/pantsbuild/pants/pull/4934>`_\n\n* Use `uname` in place of `arch`. (#4928)\n  `PR #4928 <https://github.com/pantsbuild/pants/pull/4928>`_\n\n* Update futures to 0.1.16 and futures-cpupool to 0.1.6 (#4925)\n  `PR #4925 <https://github.com/pantsbuild/pants/pull/4925>`_\n\n1.4.0.dev14 (10/2/2017)\n-----------------------\n\nNew Features\n~~~~~~~~~~~~\n\n* Engine can work with Bazel Remote Execution API (#4910)\n  `PR #4910 <https://github.com/pantsbuild/pants/pull/4910>`_\n\n* Add lint and fmt goal for javascript style rules checking (#4785)\n  `PR #4785 <https://github.com/pantsbuild/pants/pull/4785>`_\n\nAPI Changes\n~~~~~~~~~~~\n\n* managed_jar_dependencies: allow target()\'s with jar_library dependencies (#4742)\n  `PR #4742 <https://github.com/pantsbuild/pants/pull/4742>`_\n\nBugfixes\n~~~~~~~~\n\n* Error if the wrong subprocess is imported (#4922)\n  `PR #4922 <https://github.com/pantsbuild/pants/pull/4922>`_\n\n* Avoid os.fork() prior to stats upload. (#4919)\n  `PR #4919 <https://github.com/pantsbuild/pants/pull/4919>`_\n\n* Repair requests range pin to include higher versions. (#4916)\n  `PR #4916 <https://github.com/pantsbuild/pants/pull/4916>`_\n\n* Use Jessie not Weezy for docker image on travis (#4912)\n  `PR #4912 <https://github.com/pantsbuild/pants/pull/4912>`_\n\n* Fixup build script to rebuild only when needed. (#4908)\n  `PR #4908 <https://github.com/pantsbuild/pants/pull/4908>`_\n\n* Fix -Wstrict-prototypes warnings (#4902)\n  `PR #4902 <https://github.com/pantsbuild/pants/pull/4902>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Install cmake on travis (#4923)\n  `PR #4923 <https://github.com/pantsbuild/pants/pull/4923>`_\n\n* Use newer protoc and older debian (#4918)\n  `PR #4918 <https://github.com/pantsbuild/pants/pull/4918>`_\n  `PR #40 <https://github.com/pantsbuild/binaries/pull/40>`_\n\n* Refactor code coverage in preparation for adding a new coverage engine (jacoco) (#4881)\n  `PR #4881 <https://github.com/pantsbuild/pants/pull/4881>`_\n\n* Improve performance of simple codegen. (#4907)\n  `PR #4907 <https://github.com/pantsbuild/pants/pull/4907>`_\n\n* Implement local process execution in rust (#4901)\n  `PR #4901 <https://github.com/pantsbuild/pants/pull/4901>`_\n\n* Improve `--cache-ignore` performance. (#4905)\n  `PR #4905 <https://github.com/pantsbuild/pants/pull/4905>`_\n\n* Script to run sub-crate tests (#4900)\n  `PR #4900 <https://github.com/pantsbuild/pants/pull/4900>`_\n\n* Run rust tests on travis (#4899)\n  `PR #4899 <https://github.com/pantsbuild/pants/pull/4899>`_\n\n* Remove obsolete target-specific scripts (#4903)\n  `PR #4903 <https://github.com/pantsbuild/pants/pull/4903>`_\n\n* Re-build Bazel gRPC if the build script changes (#4924)\n  `PR #4924 <https://github.com/pantsbuild/pants/pull/4924>`_\n\n1.4.0.dev13 (9/25/2017)\n-----------------------\n\nNew Features\n~~~~~~~~~~~~\n\n* Support wheels when loading plugins. (#4887)\n  `PR #4887 <https://github.com/pantsbuild/pants/pull/4887>`_\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove python 2.6 support completely. (#4871)\n  `PR #4871 <https://github.com/pantsbuild/pants/pull/4871>`_\n\n* Bump pyopenssl==17.3.0 (#4872)\n  `PR #4872 <https://github.com/pantsbuild/pants/pull/4872>`_\n\n* Error on task name reuse for a particular goal (#4863)\n  `PR #4863 <https://github.com/pantsbuild/pants/pull/4863>`_\n\nBugfixes\n~~~~~~~~\n\n* Release native engine binaries for OSX 10.13. (#4898)\n  `PR #4898 <https://github.com/pantsbuild/pants/pull/4898>`_\n\n* Add default routing for OSX High Sierra binaries. (#4894)\n  `PR #4894 <https://github.com/pantsbuild/pants/pull/4894>`_\n\n* Reduce BUILD file parse pollution (#4892)\n  `PR #4892 <https://github.com/pantsbuild/pants/pull/4892>`_\n\n* Exit with error on error bootstrapping cffi (#4891)\n  `PR #4891 <https://github.com/pantsbuild/pants/pull/4891>`_\n\n* Only generate Android resource deps when needed. (#4888)\n  `PR #4888 <https://github.com/pantsbuild/pants/pull/4888>`_\n\n* Re-pin to 2017Q2 TravisCI image. (#4869)\n  `PR #4869 <https://github.com/pantsbuild/pants/pull/4869>`_\n\nDocumentation Updates\n~~~~~~~~~~~~~~~~~~~~~\n\n* Update the committer docs. (#4889)\n  `PR #4889 <https://github.com/pantsbuild/pants/pull/4889>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Refactor test partitioning. (#4879)\n  `PR #4879 <https://github.com/pantsbuild/pants/pull/4879>`_\n\n* Leverage `subprocess32` subprocess backports. (#4851)\n  `PR #4851 <https://github.com/pantsbuild/pants/pull/4851>`_\n\n* Customize native engine build through code (#4876)\n  `PR #4876 <https://github.com/pantsbuild/pants/pull/4876>`_\n\n* Move to SymbolTable/Parser instances (#4864)\n  `PR #4864 <https://github.com/pantsbuild/pants/pull/4864>`_\n\n1.4.0.dev12 (9/13/2017) [UNRELEASED]\n------------------------------------\n\nNB: 1.4.0.dev12 was never released to pypi due to technical difficulties; its changes were rolled\nup into 1.4.0.dev13 and released with it.\n\nAPI Changes\n~~~~~~~~~~~\n* Use @files for javadoc so it runs with a longer command line and add doc exclude patterns option (#4842)\n  `PR #4842 <https://github.com/pantsbuild/pants/pull/4842>`_\n\n* Migrate BinaryUtil options to bootstrap options. (#4846)\n  `PR #4846 <https://github.com/pantsbuild/pants/pull/4846>`_\n\nBugfixes\n~~~~~~~~\n* Clean up stray pantsd-runner processes (#4835)\n  `PR #4835 <https://github.com/pantsbuild/pants/pull/4835>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n* Re-add requests[security] and pin pyOpenSSL==17.1.0 to avoid deprecation warning. (#4865)\n  `PR #4865 <https://github.com/pantsbuild/pants/pull/4865>`_\n\n* Repair `BinaryNotFound` due to `sslv3 alert handshake failure`. (#4853)\n  `PR #4853 <https://github.com/pantsbuild/pants/pull/4853>`_\n\n* [pantsd] Improve locking. (#4847)\n  `PR #4847 <https://github.com/pantsbuild/pants/pull/4847>`_\n\n* Upgrade pex to latest. (#4843)\n  `PR #4843 <https://github.com/pantsbuild/pants/pull/4843>`_\n\n1.4.0.dev11 (9/1/2017)\n----------------------\n\nBugfixes\n~~~~~~~~\n\n* Centralize options tracking in the Parser. (#4832)\n  `PR #4832 <https://github.com/pantsbuild/pants/pull/4832>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Bump petgraph to 0.4.5 (#4836)\n  `PR #4836 <https://github.com/pantsbuild/pants/pull/4836>`_\n\n1.4.0.dev10 (8/25/2017)\n-----------------------\n\nNew Features\n~~~~~~~~~~~~\n\n* Add optional chrooting for junit tests. (#4823)\n  `PR #4823 <https://github.com/pantsbuild/pants/pull/4823>`_\n\nBugfixes\n~~~~~~~~\n\n* Always return a bool from SetupPy.has_provides().\n  `PR #4826 <https://github.com/pantsbuild/pants/pull/4826>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Point binary URLs off to CNAMES we own. (#4829)\n  `PR #4829 <https://github.com/pantsbuild/pants/pull/4829>`_\n\n* Stop dual-publishing the docsite. (#4828)\n  `PR #4828 <https://github.com/pantsbuild/pants/pull/4828>`_\n\n1.4.0.dev9 (8/18/2017)\n----------------------\n\nBugfixes\n~~~~~~~~\n\n* Ensure setup-py runs with all interpreter extras. (#4822)\n  `PR #4822 <https://github.com/pantsbuild/pants/pull/4822>`_\n\n* Fixup erroneous `exc` attribute access. (#4818)\n  `PR #4818 <https://github.com/pantsbuild/pants/pull/4818>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Turn on pytest successful test caching in CI. (#4819)\n  `PR #4819 <https://github.com/pantsbuild/pants/pull/4819>`_\n\n* Only attempt deploys on appropriate shards. (#4816)\n  `PR #4816 <https://github.com/pantsbuild/pants/pull/4816>`_\n\n* Fix s3 deploy to use copies instead of a symlink. (#4814)\n  `PR #4814 <https://github.com/pantsbuild/pants/pull/4814>`_\n\n* Fix the S3 upload in the travis deploy. (#4813)\n  `PR #4813 <https://github.com/pantsbuild/pants/pull/4813>`_\n\n1.4.0.dev8 (8/11/2017)\n----------------------\n\nNew Features\n~~~~~~~~~~~~\n\n* Add support for junit (successful) test caching. (#4771)\n  `PR #4771 <https://github.com/pantsbuild/pants/pull/4771>`_\n\nAPI Changes\n~~~~~~~~~~~\n\n* Kill custom binaries.baseurls. (#4809)\n  `PR #4809 <https://github.com/pantsbuild/pants/pull/4809>`_\n\n* Partition and pass JVM options to scalafmt (#4774)\n  `PR #4774 <https://github.com/pantsbuild/pants/pull/4774>`_\n\nBugfixes\n~~~~~~~~\n\n* [python-repl] pass env through to repl (#4808)\n  `PR #4808 <https://github.com/pantsbuild/pants/pull/4808>`_\n\n* Switch default binary-baseurls to s3 (#4806)\n  `PR #4806 <https://github.com/pantsbuild/pants/pull/4806>`_\n\n* Work around bintray outage. (#4801)\n  `PR #4801 <https://github.com/pantsbuild/pants/pull/4801>`_\n\n* Fix has_sources. (#4792)\n  `PR #4792 <https://github.com/pantsbuild/pants/pull/4792>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Zinc 1.0.0-RC3 memory and output improvements (#4807)\n  `PR #4807 <https://github.com/pantsbuild/pants/pull/4807>`_\n\n* Improve performance by not re-fingerprinting codegen\'d sources. (#4789)\n  `PR #4789 <https://github.com/pantsbuild/pants/pull/4789>`_\n\n* Add per-target zinc compile stats (#4790)\n  `PR #4790 <https://github.com/pantsbuild/pants/pull/4790>`_\n\n* Add support for publishing native-engine to s3. (#4804)\n  `PR #4804 <https://github.com/pantsbuild/pants/pull/4804>`_\n\n* Introduce a loose `Files` target. (#4798)\n  `PR #4798 <https://github.com/pantsbuild/pants/pull/4798>`_\n\n* Upgrade default go to 1.8.3. (#4799)\n  `PR #4799 <https://github.com/pantsbuild/pants/pull/4799>`_\n\n* Deprecate unused `go_thrift_library.import_path`. (#4794)\n  `PR #4794 <https://github.com/pantsbuild/pants/pull/4794>`_\n\n* Cleanup cpp targets. (#4793)\n  `PR #4793 <https://github.com/pantsbuild/pants/pull/4793>`_\n\n* Simplify `_validate_target_representation_args`. (#4791)\n  `PR #4791 <https://github.com/pantsbuild/pants/pull/4791>`_\n\n* Init the native engine from bootstrap options. (#4787)\n  `PR #4787 <https://github.com/pantsbuild/pants/pull/4787>`_\n\n* [pantsd] Add faulthandler support for stacktrace dumps. (#4784)\n  `PR #4784 <https://github.com/pantsbuild/pants/pull/4784>`_\n\n* Cleanup CI deprecation warnings. (#4781)\n  `PR #4781 <https://github.com/pantsbuild/pants/pull/4781>`_\n\n* Kill `-XX:-UseSplitVerifier`. (#4777)\n  `PR #4777 <https://github.com/pantsbuild/pants/pull/4777>`_\n\n\n1.4.0.dev7 (7/28/2017)\n----------------------\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Update to zinc 1.0.0-RC3 (#4775)\n  `Issue #355, <https://github.com/sbt/zinc/issues/355,>`_\n  `Issue #355 <https://github.com/sbt/zinc/issues/355>`_\n  `PR #4775 <https://github.com/pantsbuild/pants/pull/4775>`_\n\n* Don\'t require an scm for local publishes. (#4773)\n  `PR #4773 <https://github.com/pantsbuild/pants/pull/4773>`_\n\n* Simplify `argutil::ensure_arg`. (#4768)\n  `PR #4768 <https://github.com/pantsbuild/pants/pull/4768>`_\n\n* Small cleanups in the `JunitRun` codebase. (#4767)\n  `PR #4767 <https://github.com/pantsbuild/pants/pull/4767>`_\n\n* Add support for compiling thrift split across multiple files in go. (#4766)\n  `PR #4766 <https://github.com/pantsbuild/pants/pull/4766>`_\n\n\n1.4.0.dev6 (7/21/2017)\n----------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Conditionally support multiple thrift files for go_thrift_gen (#4759)\n  `PR #4759 <https://github.com/pantsbuild/pants/pull/4759>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Introduce `dirutil.mergetree`. (#4757)\n  `PR #4757 <https://github.com/pantsbuild/pants/pull/4757>`_\n\n* Zinc 1.0.0-X20 upgrade: JVM portion (#4728)\n  `Issue #355), <https://github.com/sbt/zinc/issues/355),>`_\n  `PR #4728 <https://github.com/pantsbuild/pants/pull/4728>`_\n\n* Ensure setuptools version when running setup.py. (#4753)\n  `PR #4753 <https://github.com/pantsbuild/pants/pull/4753>`_\n\n* Kill deprecated explicit register.\n  `Commit 5583dd1 <https://github.com/pantsbuild/pants/commit/5583dd1>`_\n\n\n1.4.0.dev5 (7/14/2017)\n----------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* ScroogeGen passes through fatal_warnings argument (#4739)\n  `PR #4739 <https://github.com/pantsbuild/pants/pull/4739>`_\n\n* Bump pex version to 1.2.8. (#4735)\n  `PR #4735 <https://github.com/pantsbuild/pants/pull/4735>`_\n\n* Deprecate the `--config-override` option. (#4715)\n  `PR #4715 <https://github.com/pantsbuild/pants/pull/4715>`_\n\nBugfixes\n~~~~~~~~\n\n* Improve pytest result summaries. (#4747)\n  `PR #4747 <https://github.com/pantsbuild/pants/pull/4747>`_\n\n* Include passthru args in task option fingerprints. (#4745)\n  `PR #4745 <https://github.com/pantsbuild/pants/pull/4745>`_\n\n* Fingerprint a bunch of go options. (#4743)\n  `PR #4743 <https://github.com/pantsbuild/pants/pull/4743>`_\n\n* Fix rpc style in compiler_args check. (#4730)\n  `PR #4730 <https://github.com/pantsbuild/pants/pull/4730>`_\n\n* Revert "Alias `--pants-config-files` to `-c`." (#4718)\n  `PR #4718 <https://github.com/pantsbuild/pants/pull/4718>`_\n\n* Ensure that invalidation works correctly when state is reverted. (#4709)\n  `PR #4709 <https://github.com/pantsbuild/pants/pull/4709>`_\n\n* Fixup `PytestRun` error handling. (#4716)\n  `PR #4716 <https://github.com/pantsbuild/pants/pull/4716>`_\n\n* Fix option bootstrapping config application order. (#4714)\n  `PR #4714 <https://github.com/pantsbuild/pants/pull/4714>`_\n\n* Ensure that target root order is preserved (#4708)\n  `PR #4708 <https://github.com/pantsbuild/pants/pull/4708>`_\n\nDocumentation Updates\n~~~~~~~~~~~~~~~~~~~~~\n\n* Remove Download Stats (#4724)\n  `Issue #716 <https://github.com/badges/shields/issues/716>`_\n  `PR #4724 <https://github.com/pantsbuild/pants/pull/4724>`_\n\n* Fix roundtrip example in JVM documentation (#4706)\n  `PR #4706 <https://github.com/pantsbuild/pants/pull/4706>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Improve transitive resolve package checking in tests. (#4738)\n  `PR #4738 <https://github.com/pantsbuild/pants/pull/4738>`_\n\n* Extract a zinc subsystem to allow for more entrypoints (#4720)\n  `PR #4720 <https://github.com/pantsbuild/pants/pull/4720>`_\n\n* Format suggested deps for easy cut & paste into BUILD file (#4711)\n  `PR #4711 <https://github.com/pantsbuild/pants/pull/4711>`_\n\n* Re-enable lint checks in CI (#4704)\n  `PR #4704 <https://github.com/pantsbuild/pants/pull/4704>`_\n\n\n1.4.0.dev4 (6/23/2017)\n----------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Replace the `invalidate` goal with `--cache-ignore`. (#4686)\n  `PR #4686 <https://github.com/pantsbuild/pants/pull/4686>`_\n\nBugfixes\n~~~~~~~~\n\n* Fix pythonstyle warnings and some python-eval warnings (#4698)\n  `PR #4698 <https://github.com/pantsbuild/pants/pull/4698>`_\n\n* Add debug logging to prepare_resources and junit_run and fix payload asserts (#4694)\n  `PR #4694 <https://github.com/pantsbuild/pants/pull/4694>`_\n\n* Improve safe_concurrent_creation contextmanager. (#4690)\n  `PR #4690 <https://github.com/pantsbuild/pants/pull/4690>`_\n\n* Fix pytest result summary colors. (#4685)\n  `PR #4685 <https://github.com/pantsbuild/pants/pull/4685>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Use ElementTree to parse JUnit XML files because it is much faster than minidom (#4693)\n  `PR #4693 <https://github.com/pantsbuild/pants/pull/4693>`_\n\n* Use link.checkstyle target for checkstyle integration (#4699)\n  `PR #4699 <https://github.com/pantsbuild/pants/pull/4699>`_\n\n* Stabilize sharding test. (#4687)\n  `PR #4687 <https://github.com/pantsbuild/pants/pull/4687>`_\n\nDocumentation Updates\n~~~~~~~~~~~~~~~~~~~~~\n\n* Fixup explain options json output. (#4696)\n  `PR #4696 <https://github.com/pantsbuild/pants/pull/4696>`_\n\n\n1.4.0.dev3 (6/16/2017)\n----------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Add compiler_args property to JavaThriftLibrary target.  (#4669)\n  `PR #4669 <https://github.com/pantsbuild/pants/pull/4669>`_\n\nBugfixes\n~~~~~~~~\n\n* Add classname to target data reported by pytest (#4675)\n  `PR #4675 <https://github.com/pantsbuild/pants/pull/4675>`_\n\n* Support options fingerprinting in `Task` tests. (#4666)\n  `PR #4666 <https://github.com/pantsbuild/pants/pull/4666>`_\n\n* Simplify `UnsetBool` fingerprint encoding. (#4667)\n  `PR #4667 <https://github.com/pantsbuild/pants/pull/4667>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Remove engine.engine.Engine and add RootRule (#4679)\n  `PR #4679 <https://github.com/pantsbuild/pants/pull/4679>`_\n\n* Ensure `Task.workdir` is available when needed. (#4672)\n  `PR #4672 <https://github.com/pantsbuild/pants/pull/4672>`_\n\n* Add support for local test caching. (#4660)\n  `PR #4660 <https://github.com/pantsbuild/pants/pull/4660>`_\n\nDocumentation Updates\n~~~~~~~~~~~~~~~~~~~~~\n\n* Link the HTML report image in the docs to the page describing it. (#4671)\n  `PR #4671 <https://github.com/pantsbuild/pants/pull/4671>`_\n\n* Document that the release script now requires Bash 4. (#4670)\n  `PR #4670 <https://github.com/pantsbuild/pants/pull/4670>`_\n\n\n1.4.0.dev2 (6/10/2017)\n----------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Enable implicit_sources by default, and improve its docs. (#4661)\n  `PR #4661 <https://github.com/pantsbuild/pants/pull/4661>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Support registering product data from one task. (#4663)\n  `PR #4663 <https://github.com/pantsbuild/pants/pull/4663>`_\n\n* Expose pex invocation cmdlines. (#4659)\n  `PR #4659 <https://github.com/pantsbuild/pants/pull/4659>`_\n\n* Audit engine struct `repr` values. (#4658)\n  `PR #4658 <https://github.com/pantsbuild/pants/pull/4658>`_\n\n* Break `py.test` execution into two stages. (#4656)\n  `PR #4656 <https://github.com/pantsbuild/pants/pull/4656>`_\n\n* Skip a test that assumes the current version is a pre-release version. (#4654)\n  `PR #4654 <https://github.com/pantsbuild/pants/pull/4654>`_\n\n* Shard contrib tests. (#4650)\n  `PR #4650 <https://github.com/pantsbuild/pants/pull/4650>`_\n\n* Fix new `PytestRun` task deselction handling. (#4648)\n  `PR #4648 <https://github.com/pantsbuild/pants/pull/4648>`_\n\n* Simplify `TaskBase.invalidated`. (#4642)\n  `PR #4642 <https://github.com/pantsbuild/pants/pull/4642>`_\n\n* Eliminate obsolete OSX ci support. (#4636)\n  `PR #4636 <https://github.com/pantsbuild/pants/pull/4636>`_\n\n* Temporarily restore recursive behaviour for bundle filesets (#4630)\n  `PR #4630 <https://github.com/pantsbuild/pants/pull/4630>`_\n\n* Fix ownership check to be case-insensitive. (#4629)\n  `PR #4629 <https://github.com/pantsbuild/pants/pull/4629>`_\n\nBugfixes\n~~~~~~~~\n\n* Support fingerprinting of `UnsetBool` options. (#4665)\n  `PR #4665 <https://github.com/pantsbuild/pants/pull/4665>`_\n\nDocumentation Updates\n~~~~~~~~~~~~~~~~~~~~~\n\n* Kill dead dangling num_sources docs. (#4655)\n  `PR #4655 <https://github.com/pantsbuild/pants/pull/4655>`_\n\n* Add notes for 1.3.0, and a section explaining the daemon. (#4651)\n  `PR #4651 <https://github.com/pantsbuild/pants/pull/4651>`_\n\n* Rename and expand usage of the needs-cherrypick label (#4652)\n  `PR #4652 <https://github.com/pantsbuild/pants/pull/4652>`_\n\n* Generalize fmt msg (#4649)\n  `PR #4649 <https://github.com/pantsbuild/pants/pull/4649>`_\n\n* Fixup VersionedTarget class doc. (#4643)\n  `PR #4643 <https://github.com/pantsbuild/pants/pull/4643>`_\n\n* Fixes docs around bundle-jvm-archive. (#4637)\n  `PR #4637 <https://github.com/pantsbuild/pants/pull/4637>`_\n\n\n1.4.0.dev1 (5/26/2017)\n----------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Change method of reporting target data (#4593)\n  `PR #4593 <https://github.com/pantsbuild/pants/pull/4593>`_\n\nBugfixes\n~~~~~~~~\n\n* Check that test case attribute exists in junit xml file before converting it (#4623)\n  `Issue #4619 <https://github.com/pantsbuild/pants/issues/4619>`_\n  `PR #4623 <https://github.com/pantsbuild/pants/pull/4623>`_\n\n* [engine] Check for duplicate deps in v2 graph construction. (#4616)\n  `PR #4616 <https://github.com/pantsbuild/pants/pull/4616>`_\n\n* Improve Snapshot determinism (#4614)\n  `PR #4614 <https://github.com/pantsbuild/pants/pull/4614>`_\n\n* Revert "Enable --compile-zinc-use-classpath-jars by default" (#4607)\n  `PR #4607 <https://github.com/pantsbuild/pants/pull/4607>`_\n\n* Pass env vars through in ./pants run for python (#4606)\n  `PR #4606 <https://github.com/pantsbuild/pants/pull/4606>`_\n\n* Fix broken export-classpath (#4603)\n  `PR #4603 <https://github.com/pantsbuild/pants/pull/4603>`_\n\n* Switch to a conditional deprecation for the list-targets behaviour change. (#4600)\n  `PR #4600 <https://github.com/pantsbuild/pants/pull/4600>`_\n\n* Fix export-classpaths exclude behavior (#4592)\n  `PR #4592 <https://github.com/pantsbuild/pants/pull/4592>`_\n\n* Fix splitting of the build_flags. (#4580)\n  `PR #4580 <https://github.com/pantsbuild/pants/pull/4580>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* [pantsd] Add an alternate entrypoint loader. (#4620)\n  `PR #4620 <https://github.com/pantsbuild/pants/pull/4620>`_\n\n* Remove Oracle Java6, which is now 404ing. (#4615)\n  `PR #4615 <https://github.com/pantsbuild/pants/pull/4615>`_\n\n* Don\'t register newpython tasks in the oldpython backend (#4602)\n  `PR #4602 <https://github.com/pantsbuild/pants/pull/4602>`_\n\nDocumentation Updates\n~~~~~~~~~~~~~~~~~~~~~\n\n* Prepare notes for 1.3.0rc3 (#4617)\n  `PR #4617 <https://github.com/pantsbuild/pants/pull/4617>`_\n\n* Prepare the release notes for 1.3.0rc2 (#4609)\n  `PR #4609 <https://github.com/pantsbuild/pants/pull/4609>`_\n\n1.4.0.dev0 (5/12/2017)\n----------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Support "exports" for thrift targets (#4564)\n  `PR #4564 <https://github.com/pantsbuild/pants/pull/4564>`_\n\n* Make setup_py tasks provide \'python_dists\' product. (#4498)\n  `PR #4498 <https://github.com/pantsbuild/pants/pull/4498>`_\n\n* Include API that will store target info in run_tracker (#4561)\n  `PR #4561 <https://github.com/pantsbuild/pants/pull/4561>`_\n\nBugfixes\n~~~~~~~~\n\n* Fix built-in macros for the mutable ParseContext (#4583)\n  `PR #4583 <https://github.com/pantsbuild/pants/pull/4583>`_\n\n* Exclude only roots for exclude-target-regexp in v2 (#4578)\n  `PR #4578 <https://github.com/pantsbuild/pants/pull/4578>`_\n  `PR #451) <https://github.com/twitter/commons/pull/451)>`_\n\n* Fix a pytest path mangling bug. (#4565)\n  `PR #4565 <https://github.com/pantsbuild/pants/pull/4565>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Specify a workunit for node.js test and run. (#4572)\n  `PR #4572 <https://github.com/pantsbuild/pants/pull/4572>`_\n\n* Include transitive Resources targets in PrepareResources. (#4569)\n  `PR #4569 <https://github.com/pantsbuild/pants/pull/4569>`_\n\n* [engine] Don\'t recreate a graph just for validation (#4566)\n  `PR #4566 <https://github.com/pantsbuild/pants/pull/4566>`_\n\nDocumentation Updates\n~~~~~~~~~~~~~~~~~~~~~\n\n* Update release docs to use a label instead of a spreadsheet for backports. (#4574)\n  `PR #4574 <https://github.com/pantsbuild/pants/pull/4574>`_\n\n',
    'name': 'pantsbuild.pants.contrib.scalajs',
    'namespace_packages': ['pants', 'pants.contrib'],
    'package_data': {   },
    'package_dir': {   '': 'src'},
    'packages': [   'pants',
                    'pants.contrib',
                    'pants.contrib.scalajs',
                    'pants.contrib.scalajs.subsystems',
                    'pants.contrib.scalajs.targets',
                    'pants.contrib.scalajs.tasks'],
    'url': 'https://github.com/pantsbuild/pants',
    'version': '1.4.0',
    'zip_safe': True}
)
