# React Widget

> Create a React.js Widget in JupyterLab.

This extension shows how to use the `ReactWidget` wrapper from `@jupyterlab/apputils` to use React in a JupyterLab extension.

![react-widget](preview2.gif)

## Install

```bash
jlpm
jlpm build
jupyter labextension install .

# Rebuild Typescript source after making changes
jlpm build
# Rebuild JupyterLab after making any changes
jupyter lab build
```

You can watch the source directory and run JupyterLab in watch mode to watch for changes in the extension's source and automatically rebuild the extension and application.

```bash
# Watch the source directory in another terminal tab
jlpm watch
# Run jupyterlab in watch mode in one terminal tab
jupyter lab --watch
```

## React Developer Tools

It is possible to use the [React Developer Tools](https://chrome.google.com/webstore/detail/react-developer-tools/fmkadmapgofadopljbjfkapdkoienihi?hl=de) Chrome extension to inspect React components.

![react-dev-tools](preview.gif)

1. 환경 설정
   ```bash
   > curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.39.1/install.sh | bash
   > source ~/.bashrc
   > nvm install node
   ```
1. miniconda 설치
   [미니콘다 설치 파일 다운로드](https://docs.conda.io/en/latest/miniconda.html#linux-installers)
   ```bash
   > wget https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-x86_64.sh
   > chmod +x Miniconda3-latest-Linux-x86_64.sh
   > ./Miniconda3-latest-Linux-x86_64.sh
   # miniconda 설정 후
   > > conda install cookiecutter
   ```
   환경 설정이 .bashrc에 적용되므로 이걸 .zshrc로 복사해서 적용해야 함.
1. 주피터 환경 생성
   ```bash
   > conda create -n jupyterlab-ext --override-channels --strict-channel-priority -c conda-forge -c nodefaults jupyterlab=3 cookiecutter nodejs jupyter-packaging git python=3.9
   ```
1. 주피터 환경 활성화
   ```bash
   > conda activate jupyterlab-ext
   ```
   (비활성화는 conda deactivate)
1. cookiecutter로 확장 프로젝트 생성

   ```bash
   > cookiecutter https://github.com/jupyterlab/extension-cookiecutter-ts

   Select kind:
   1 - frontend
   2 - server
   3 - theme
   Choose from 1, 2, 3 [1]: 1
   author_name []: Your Name
   author_email []: your@name.org
   labextension_name [myextension]: jupyterlab_apod
   python_name [myextension]: jupyterlab_apod
   project_short_description [A JupyterLab extension.]: Show a random NASA Astronomy Picture of the Day in a JupyterLab panel
   has_settings [n]: n
   has_binder [n]: y
   repository [https://github.com/github_username/myextension]: https://github.com/github_username/jupyterlab_apod
   ```

1. 소스 symbolic link 설정하기(소스가 변경되었을 때 자동으로 반영되게)
   ```bash
   > jupyter labextension develop --overwrite .
   ```
1. 다른 탭에서 주피터 랩 실행하기
   ```bash
   > jupyter lab --no-browser
   ```
1. 코드 변경 반영하기
   ```bash
   > jlpm run build
   ```
   (또는 다른 탭에서 jlpm run watch 실행)
1. 필요한 라이브러리 설치
   ```bash
   > conda install tensorflow matplotlib scikit-learn
   ```
