# Contributing

Thank you for your interest in contributing to this project! 💖 All types of
contributions are encouraged and valued. If you haven't done so already, please take a
couple of minutes to read through our [code of conduct](CODE_OF_CONDUCT.md).

## Issues

If you'd like to ask a question, report a bug, suggest a feature, or provide any other
kind of feedback, feel free to open an issue in this repository. While filing issue(s),
please keep the following guidelines in mind:

- Provide as much context and relevant information as you can. Be descriptive, and
  include screenshots if applicable.
- For **bug reports**, include detailed instructions that someone else can follow to
  reproduce the bug or error.
- For **feature requests**, try and be clear about why existing features and
  alternatives do not work for you.
- Before opening a new issue, do a cursory search through the
  [existing ones](https://github.com/nuztalgia/botstrap/issues?q=is%3Aissue) to make
  sure you aren't duplicating any of them.
  - If you find an issue similar to the one you have, there's no need to create a new
    one! You can react to the existing issue with 👍 to indicate your interest, and/or
    comment on it if there's any extra information you'd like to add.

## Pull Requests

Want to contribute some code and/or documentation to this project? That's awesome! Feel
free to fork this repo and open a PR with any changes you'd like to propose. And don't
worry about your potential contributions being "too small", even if you're just fixing a
typo or rewording a sentence to be more clear. Any improvements are welcome and very
much appreciated - so **thank you** in advance!

### After you open a PR

The [pre-commit](https://pre-commit.com/) CI service will run some checks to ensure that
your changes keep this project
[clean, green, and healthy](https://results.pre-commit.ci/latest/github/nuztalgia/botstrap/main).

- Some failing checks may be automatically fixed by the service, and the resulting
  changes will be added to your PR as a subsequent commit.
- Some things may require manual fixing. You can make the requested changes in your
  local copy of the repo, then commit and push to your PR branch again. This will update
  the PR and trigger a re-run of all the checks.

Once your PR passes **all pre-commit checks**, a project maintainer will review it.

- If the maintainer asks for any changes: make the necessary edits, commit and push to
  your PR branch, and then ask for another review. This back-and-forth may happen more
  than once, especially if your changes are non-trivial.
- If the maintainer decides to pass on your PR, they will thank you for the contribution
  and explain why they won't be accepting those particular changes. That's okay! We
  still really appreciate you devoting your time to help improve this project, and hope
  to see other contributions from you in the future. 💗
- If the maintainer accepts your PR, it will be merged into the repository's `main`
  branch. This means that your contribution has officially become part of this project
  and will be distributed to our users soon! 🎉

### Licensing

This project is licensed under [Apache-2.0](http://www.apache.org/licenses/LICENSE-2.0).
All contributions to this project's codebase **must** adhere to that license, as
stipulated by the [`LICENSE`](/LICENSE) file in this repository.

Furthermore, by submitting a pull request to this repo, you certify that you authored or
otherwise have the necessary rights to submit **all** of the code included in that PR to
this project. Essentially, your contributions must comply with the
[Developer Certificate of Origin](https://developercertificate.org/), which protects
this project and all of its contributors. For more information, please see our
[`DEVELOPER_CERTIFICATE`](DEVELOPER_CERTIFICATE.md) file.
