"Main interface for mediatailor type defs"
from __future__ import annotations

from typing import Dict, List
from typing_extensions import TypedDict


__all__ = (
    "ClientGetPlaybackConfigurationResponseCdnConfigurationTypeDef",
    "ClientGetPlaybackConfigurationResponseDashConfigurationTypeDef",
    "ClientGetPlaybackConfigurationResponseHlsConfigurationTypeDef",
    "ClientGetPlaybackConfigurationResponseTypeDef",
    "ClientListPlaybackConfigurationsResponseItemsCdnConfigurationTypeDef",
    "ClientListPlaybackConfigurationsResponseItemsDashConfigurationTypeDef",
    "ClientListPlaybackConfigurationsResponseItemsHlsConfigurationTypeDef",
    "ClientListPlaybackConfigurationsResponseItemsTypeDef",
    "ClientListPlaybackConfigurationsResponseTypeDef",
    "ClientListTagsForResourceResponseTypeDef",
    "ClientPutPlaybackConfigurationCdnConfigurationTypeDef",
    "ClientPutPlaybackConfigurationDashConfigurationTypeDef",
    "ClientPutPlaybackConfigurationResponseCdnConfigurationTypeDef",
    "ClientPutPlaybackConfigurationResponseDashConfigurationTypeDef",
    "ClientPutPlaybackConfigurationResponseHlsConfigurationTypeDef",
    "ClientPutPlaybackConfigurationResponseTypeDef",
    "ListPlaybackConfigurationsPaginatePaginationConfigTypeDef",
    "ListPlaybackConfigurationsPaginateResponseItemsCdnConfigurationTypeDef",
    "ListPlaybackConfigurationsPaginateResponseItemsDashConfigurationTypeDef",
    "ListPlaybackConfigurationsPaginateResponseItemsHlsConfigurationTypeDef",
    "ListPlaybackConfigurationsPaginateResponseItemsTypeDef",
    "ListPlaybackConfigurationsPaginateResponseTypeDef",
)


_ClientGetPlaybackConfigurationResponseCdnConfigurationTypeDef = TypedDict(
    "_ClientGetPlaybackConfigurationResponseCdnConfigurationTypeDef",
    {"AdSegmentUrlPrefix": str, "ContentSegmentUrlPrefix": str},
    total=False,
)


class ClientGetPlaybackConfigurationResponseCdnConfigurationTypeDef(
    _ClientGetPlaybackConfigurationResponseCdnConfigurationTypeDef
):
    """
    Type definition for `ClientGetPlaybackConfigurationResponse` `CdnConfiguration`

    The configuration for using a content delivery network (CDN), like Amazon CloudFront, for
    content and ad segment management.

    - **AdSegmentUrlPrefix** *(string) --*

      A non-default content delivery network (CDN) to serve ad segments. By default, AWS
      Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad
      segments. To set up an alternate CDN, create a rule in your CDN for the following origin:
      ads.mediatailor.<region>.amazonaws.com. Then specify the rule's name in this
      AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN
      as the source for ad segments.

    - **ContentSegmentUrlPrefix** *(string) --*

      A content delivery network (CDN) to cache content segments, so that content requests don’t
      always have to go to the origin server. First, create a rule in your CDN for the content
      segment origin server. Then specify the rule's name in this ContentSegmentUrlPrefix. When
      AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content
      segments.
    """


_ClientGetPlaybackConfigurationResponseDashConfigurationTypeDef = TypedDict(
    "_ClientGetPlaybackConfigurationResponseDashConfigurationTypeDef",
    {"ManifestEndpointPrefix": str, "MpdLocation": str, "OriginManifestType": str},
    total=False,
)


class ClientGetPlaybackConfigurationResponseDashConfigurationTypeDef(
    _ClientGetPlaybackConfigurationResponseDashConfigurationTypeDef
):
    """
    Type definition for `ClientGetPlaybackConfigurationResponse` `DashConfiguration`

    The configuration for DASH content.

    - **ManifestEndpointPrefix** *(string) --*

      The URL generated by MediaTailor to initiate a playback session. The session uses
      server-side reporting. This setting is ignored in PUT operations.

    - **MpdLocation** *(string) --*

      The setting that controls whether MediaTailor includes the Location tag in DASH manifests.
      MediaTailor populates the Location tag with the URL for manifest update requests, to be
      used by players that don't support sticky redirects. Disable this if you have CDN routing
      rules set up for accessing MediaTailor manifests, and you are either using client-side
      reporting or your players support sticky HTTP redirects. Valid values are DISABLED and
      EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of the tag and is the default
      value.

    - **OriginManifestType** *(string) --*

      The setting that controls whether MediaTailor handles manifests from the origin server as
      multi-period manifests or single-period manifests. If your origin server produces
      single-period manifests, set this to SINGLE_PERIOD. The default setting is MULTI_PERIOD.
      For multi-period manifests, omit this setting or set it to MULTI_PERIOD.
    """


_ClientGetPlaybackConfigurationResponseHlsConfigurationTypeDef = TypedDict(
    "_ClientGetPlaybackConfigurationResponseHlsConfigurationTypeDef",
    {"ManifestEndpointPrefix": str},
    total=False,
)


class ClientGetPlaybackConfigurationResponseHlsConfigurationTypeDef(
    _ClientGetPlaybackConfigurationResponseHlsConfigurationTypeDef
):
    """
    Type definition for `ClientGetPlaybackConfigurationResponse` `HlsConfiguration`

    The configuration for HLS content.

    - **ManifestEndpointPrefix** *(string) --*

      The URL that is used to initiate a playback session for devices that support Apple HLS. The
      session uses server-side reporting.
    """


_ClientGetPlaybackConfigurationResponseTypeDef = TypedDict(
    "_ClientGetPlaybackConfigurationResponseTypeDef",
    {
        "AdDecisionServerUrl": str,
        "CdnConfiguration": ClientGetPlaybackConfigurationResponseCdnConfigurationTypeDef,
        "DashConfiguration": ClientGetPlaybackConfigurationResponseDashConfigurationTypeDef,
        "HlsConfiguration": ClientGetPlaybackConfigurationResponseHlsConfigurationTypeDef,
        "Name": str,
        "PlaybackConfigurationArn": str,
        "PlaybackEndpointPrefix": str,
        "SessionInitializationEndpointPrefix": str,
        "SlateAdUrl": str,
        "Tags": Dict[str, str],
        "TranscodeProfileName": str,
        "VideoContentSourceUrl": str,
    },
    total=False,
)


class ClientGetPlaybackConfigurationResponseTypeDef(
    _ClientGetPlaybackConfigurationResponseTypeDef
):
    """
    Type definition for `ClientGetPlaybackConfiguration` `Response`

    Success.

    - **AdDecisionServerUrl** *(string) --*

      The URL for the ad decision server (ADS). This includes the specification of static
      parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes
      player-specific and session-specific parameters as needed when calling the ADS. Alternately,
      for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.

    - **CdnConfiguration** *(dict) --*

      The configuration for using a content delivery network (CDN), like Amazon CloudFront, for
      content and ad segment management.

      - **AdSegmentUrlPrefix** *(string) --*

        A non-default content delivery network (CDN) to serve ad segments. By default, AWS
        Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad
        segments. To set up an alternate CDN, create a rule in your CDN for the following origin:
        ads.mediatailor.<region>.amazonaws.com. Then specify the rule's name in this
        AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN
        as the source for ad segments.

      - **ContentSegmentUrlPrefix** *(string) --*

        A content delivery network (CDN) to cache content segments, so that content requests don’t
        always have to go to the origin server. First, create a rule in your CDN for the content
        segment origin server. Then specify the rule's name in this ContentSegmentUrlPrefix. When
        AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content
        segments.

    - **DashConfiguration** *(dict) --*

      The configuration for DASH content.

      - **ManifestEndpointPrefix** *(string) --*

        The URL generated by MediaTailor to initiate a playback session. The session uses
        server-side reporting. This setting is ignored in PUT operations.

      - **MpdLocation** *(string) --*

        The setting that controls whether MediaTailor includes the Location tag in DASH manifests.
        MediaTailor populates the Location tag with the URL for manifest update requests, to be
        used by players that don't support sticky redirects. Disable this if you have CDN routing
        rules set up for accessing MediaTailor manifests, and you are either using client-side
        reporting or your players support sticky HTTP redirects. Valid values are DISABLED and
        EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of the tag and is the default
        value.

      - **OriginManifestType** *(string) --*

        The setting that controls whether MediaTailor handles manifests from the origin server as
        multi-period manifests or single-period manifests. If your origin server produces
        single-period manifests, set this to SINGLE_PERIOD. The default setting is MULTI_PERIOD.
        For multi-period manifests, omit this setting or set it to MULTI_PERIOD.

    - **HlsConfiguration** *(dict) --*

      The configuration for HLS content.

      - **ManifestEndpointPrefix** *(string) --*

        The URL that is used to initiate a playback session for devices that support Apple HLS. The
        session uses server-side reporting.

    - **Name** *(string) --*

      The identifier for the playback configuration.

    - **PlaybackConfigurationArn** *(string) --*

      The Amazon Resource Name (ARN) for the playback configuration.

    - **PlaybackEndpointPrefix** *(string) --*

      The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This
      session will use server-side reporting.

    - **SessionInitializationEndpointPrefix** *(string) --*

      The URL that the player uses to initialize a session that uses client-side reporting.

    - **SlateAdUrl** *(string) --*

      The URL for a high-quality video asset to transcode and use to fill in time that's not used
      by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content.
      Configuring the slate is optional for non-VPAID playback configurations. For VPAID, the slate
      is required because MediaTailor provides it in the slots designated for dynamic ad content.
      The slate must be a high-quality asset that contains both audio and video.

    - **Tags** *(dict) --*

      The tags assigned to the playback configuration.

      - *(string) --*

        - *(string) --*

    - **TranscodeProfileName** *(string) --*

      The name that is used to associate this playback configuration with a custom transcode
      profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if you
      have already set up custom profiles with the help of AWS Support.

    - **VideoContentSourceUrl** *(string) --*

      The URL prefix for the master playlist for the stream, minus the asset ID. The maximum length
      is 512 characters.
    """


_ClientListPlaybackConfigurationsResponseItemsCdnConfigurationTypeDef = TypedDict(
    "_ClientListPlaybackConfigurationsResponseItemsCdnConfigurationTypeDef",
    {"AdSegmentUrlPrefix": str, "ContentSegmentUrlPrefix": str},
    total=False,
)


class ClientListPlaybackConfigurationsResponseItemsCdnConfigurationTypeDef(
    _ClientListPlaybackConfigurationsResponseItemsCdnConfigurationTypeDef
):
    """
    Type definition for `ClientListPlaybackConfigurationsResponseItems` `CdnConfiguration`

    The configuration for using a content delivery network (CDN), like Amazon CloudFront, for
    content and ad segment management.

    - **AdSegmentUrlPrefix** *(string) --*

      A non-default content delivery network (CDN) to serve ad segments. By default, AWS
      Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for
      ad segments. To set up an alternate CDN, create a rule in your CDN for the following
      origin: ads.mediatailor.<region>.amazonaws.com. Then specify the rule's name in this
      AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your
      CDN as the source for ad segments.

    - **ContentSegmentUrlPrefix** *(string) --*

      A content delivery network (CDN) to cache content segments, so that content requests
      don’t always have to go to the origin server. First, create a rule in your CDN for the
      content segment origin server. Then specify the rule's name in this
      ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports
      your CDN as the source for content segments.
    """


_ClientListPlaybackConfigurationsResponseItemsDashConfigurationTypeDef = TypedDict(
    "_ClientListPlaybackConfigurationsResponseItemsDashConfigurationTypeDef",
    {"ManifestEndpointPrefix": str, "MpdLocation": str, "OriginManifestType": str},
    total=False,
)


class ClientListPlaybackConfigurationsResponseItemsDashConfigurationTypeDef(
    _ClientListPlaybackConfigurationsResponseItemsDashConfigurationTypeDef
):
    """
    Type definition for `ClientListPlaybackConfigurationsResponseItems` `DashConfiguration`

    The configuration for DASH content.

    - **ManifestEndpointPrefix** *(string) --*

      The URL generated by MediaTailor to initiate a playback session. The session uses
      server-side reporting. This setting is ignored in PUT operations.

    - **MpdLocation** *(string) --*

      The setting that controls whether MediaTailor includes the Location tag in DASH
      manifests. MediaTailor populates the Location tag with the URL for manifest update
      requests, to be used by players that don't support sticky redirects. Disable this if
      you have CDN routing rules set up for accessing MediaTailor manifests, and you are
      either using client-side reporting or your players support sticky HTTP redirects. Valid
      values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of
      the tag and is the default value.

    - **OriginManifestType** *(string) --*

      The setting that controls whether MediaTailor handles manifests from the origin server
      as multi-period manifests or single-period manifests. If your origin server produces
      single-period manifests, set this to SINGLE_PERIOD. The default setting is
      MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.
    """


_ClientListPlaybackConfigurationsResponseItemsHlsConfigurationTypeDef = TypedDict(
    "_ClientListPlaybackConfigurationsResponseItemsHlsConfigurationTypeDef",
    {"ManifestEndpointPrefix": str},
    total=False,
)


class ClientListPlaybackConfigurationsResponseItemsHlsConfigurationTypeDef(
    _ClientListPlaybackConfigurationsResponseItemsHlsConfigurationTypeDef
):
    """
    Type definition for `ClientListPlaybackConfigurationsResponseItems` `HlsConfiguration`

    The configuration for HLS content.

    - **ManifestEndpointPrefix** *(string) --*

      The URL that is used to initiate a playback session for devices that support Apple HLS.
      The session uses server-side reporting.
    """


_ClientListPlaybackConfigurationsResponseItemsTypeDef = TypedDict(
    "_ClientListPlaybackConfigurationsResponseItemsTypeDef",
    {
        "AdDecisionServerUrl": str,
        "CdnConfiguration": ClientListPlaybackConfigurationsResponseItemsCdnConfigurationTypeDef,
        "DashConfiguration": ClientListPlaybackConfigurationsResponseItemsDashConfigurationTypeDef,
        "HlsConfiguration": ClientListPlaybackConfigurationsResponseItemsHlsConfigurationTypeDef,
        "Name": str,
        "PlaybackConfigurationArn": str,
        "PlaybackEndpointPrefix": str,
        "SessionInitializationEndpointPrefix": str,
        "SlateAdUrl": str,
        "Tags": Dict[str, str],
        "TranscodeProfileName": str,
        "VideoContentSourceUrl": str,
    },
    total=False,
)


class ClientListPlaybackConfigurationsResponseItemsTypeDef(
    _ClientListPlaybackConfigurationsResponseItemsTypeDef
):
    """
    Type definition for `ClientListPlaybackConfigurationsResponse` `Items`

    The AWSMediaTailor configuration.

    - **AdDecisionServerUrl** *(string) --*

      The URL for the ad decision server (ADS). This includes the specification of static
      parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes
      player-specific and session-specific parameters as needed when calling the ADS.
      Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000
      characters.

    - **CdnConfiguration** *(dict) --*

      The configuration for using a content delivery network (CDN), like Amazon CloudFront, for
      content and ad segment management.

      - **AdSegmentUrlPrefix** *(string) --*

        A non-default content delivery network (CDN) to serve ad segments. By default, AWS
        Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for
        ad segments. To set up an alternate CDN, create a rule in your CDN for the following
        origin: ads.mediatailor.<region>.amazonaws.com. Then specify the rule's name in this
        AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your
        CDN as the source for ad segments.

      - **ContentSegmentUrlPrefix** *(string) --*

        A content delivery network (CDN) to cache content segments, so that content requests
        don’t always have to go to the origin server. First, create a rule in your CDN for the
        content segment origin server. Then specify the rule's name in this
        ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports
        your CDN as the source for content segments.

    - **DashConfiguration** *(dict) --*

      The configuration for DASH content.

      - **ManifestEndpointPrefix** *(string) --*

        The URL generated by MediaTailor to initiate a playback session. The session uses
        server-side reporting. This setting is ignored in PUT operations.

      - **MpdLocation** *(string) --*

        The setting that controls whether MediaTailor includes the Location tag in DASH
        manifests. MediaTailor populates the Location tag with the URL for manifest update
        requests, to be used by players that don't support sticky redirects. Disable this if
        you have CDN routing rules set up for accessing MediaTailor manifests, and you are
        either using client-side reporting or your players support sticky HTTP redirects. Valid
        values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of
        the tag and is the default value.

      - **OriginManifestType** *(string) --*

        The setting that controls whether MediaTailor handles manifests from the origin server
        as multi-period manifests or single-period manifests. If your origin server produces
        single-period manifests, set this to SINGLE_PERIOD. The default setting is
        MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.

    - **HlsConfiguration** *(dict) --*

      The configuration for HLS content.

      - **ManifestEndpointPrefix** *(string) --*

        The URL that is used to initiate a playback session for devices that support Apple HLS.
        The session uses server-side reporting.

    - **Name** *(string) --*

      The identifier for the playback configuration.

    - **PlaybackConfigurationArn** *(string) --*

      The Amazon Resource Name (ARN) for the playback configuration.

    - **PlaybackEndpointPrefix** *(string) --*

      The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This
      session will use server-side reporting.

    - **SessionInitializationEndpointPrefix** *(string) --*

      The URL that the player uses to initialize a session that uses client-side reporting.

    - **SlateAdUrl** *(string) --*

      The URL for a high-quality video asset to transcode and use to fill in time that's not
      used by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content.
      Configuring the slate is optional for non-VPAID playback configurations. For VPAID, the
      slate is required because MediaTailor provides it in the slots designated for dynamic ad
      content. The slate must be a high-quality asset that contains both audio and video.

    - **Tags** *(dict) --*

      The tags assigned to the playback configuration.

      - *(string) --*

        - *(string) --*

    - **TranscodeProfileName** *(string) --*

      The name that is used to associate this playback configuration with a custom transcode
      profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if
      you have already set up custom profiles with the help of AWS Support.

    - **VideoContentSourceUrl** *(string) --*

      The URL prefix for the master playlist for the stream, minus the asset ID. The maximum
      length is 512 characters.
    """


_ClientListPlaybackConfigurationsResponseTypeDef = TypedDict(
    "_ClientListPlaybackConfigurationsResponseTypeDef",
    {
        "Items": List[ClientListPlaybackConfigurationsResponseItemsTypeDef],
        "NextToken": str,
    },
    total=False,
)


class ClientListPlaybackConfigurationsResponseTypeDef(
    _ClientListPlaybackConfigurationsResponseTypeDef
):
    """
    Type definition for `ClientListPlaybackConfigurations` `Response`

    Success.

    - **Items** *(list) --*

      Array of playback configurations. This might be all the available configurations or a subset,
      depending on the settings that you provide and the total number of configurations stored.

      - *(dict) --*

        The AWSMediaTailor configuration.

        - **AdDecisionServerUrl** *(string) --*

          The URL for the ad decision server (ADS). This includes the specification of static
          parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes
          player-specific and session-specific parameters as needed when calling the ADS.
          Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000
          characters.

        - **CdnConfiguration** *(dict) --*

          The configuration for using a content delivery network (CDN), like Amazon CloudFront, for
          content and ad segment management.

          - **AdSegmentUrlPrefix** *(string) --*

            A non-default content delivery network (CDN) to serve ad segments. By default, AWS
            Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for
            ad segments. To set up an alternate CDN, create a rule in your CDN for the following
            origin: ads.mediatailor.<region>.amazonaws.com. Then specify the rule's name in this
            AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your
            CDN as the source for ad segments.

          - **ContentSegmentUrlPrefix** *(string) --*

            A content delivery network (CDN) to cache content segments, so that content requests
            don’t always have to go to the origin server. First, create a rule in your CDN for the
            content segment origin server. Then specify the rule's name in this
            ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports
            your CDN as the source for content segments.

        - **DashConfiguration** *(dict) --*

          The configuration for DASH content.

          - **ManifestEndpointPrefix** *(string) --*

            The URL generated by MediaTailor to initiate a playback session. The session uses
            server-side reporting. This setting is ignored in PUT operations.

          - **MpdLocation** *(string) --*

            The setting that controls whether MediaTailor includes the Location tag in DASH
            manifests. MediaTailor populates the Location tag with the URL for manifest update
            requests, to be used by players that don't support sticky redirects. Disable this if
            you have CDN routing rules set up for accessing MediaTailor manifests, and you are
            either using client-side reporting or your players support sticky HTTP redirects. Valid
            values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of
            the tag and is the default value.

          - **OriginManifestType** *(string) --*

            The setting that controls whether MediaTailor handles manifests from the origin server
            as multi-period manifests or single-period manifests. If your origin server produces
            single-period manifests, set this to SINGLE_PERIOD. The default setting is
            MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.

        - **HlsConfiguration** *(dict) --*

          The configuration for HLS content.

          - **ManifestEndpointPrefix** *(string) --*

            The URL that is used to initiate a playback session for devices that support Apple HLS.
            The session uses server-side reporting.

        - **Name** *(string) --*

          The identifier for the playback configuration.

        - **PlaybackConfigurationArn** *(string) --*

          The Amazon Resource Name (ARN) for the playback configuration.

        - **PlaybackEndpointPrefix** *(string) --*

          The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This
          session will use server-side reporting.

        - **SessionInitializationEndpointPrefix** *(string) --*

          The URL that the player uses to initialize a session that uses client-side reporting.

        - **SlateAdUrl** *(string) --*

          The URL for a high-quality video asset to transcode and use to fill in time that's not
          used by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content.
          Configuring the slate is optional for non-VPAID playback configurations. For VPAID, the
          slate is required because MediaTailor provides it in the slots designated for dynamic ad
          content. The slate must be a high-quality asset that contains both audio and video.

        - **Tags** *(dict) --*

          The tags assigned to the playback configuration.

          - *(string) --*

            - *(string) --*

        - **TranscodeProfileName** *(string) --*

          The name that is used to associate this playback configuration with a custom transcode
          profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if
          you have already set up custom profiles with the help of AWS Support.

        - **VideoContentSourceUrl** *(string) --*

          The URL prefix for the master playlist for the stream, minus the asset ID. The maximum
          length is 512 characters.

    - **NextToken** *(string) --*

      Pagination token returned by the GET list request when results exceed the maximum allowed.
      Use the token to fetch the next page of results.
    """


_ClientListTagsForResourceResponseTypeDef = TypedDict(
    "_ClientListTagsForResourceResponseTypeDef", {"Tags": Dict[str, str]}, total=False
)


class ClientListTagsForResourceResponseTypeDef(
    _ClientListTagsForResourceResponseTypeDef
):
    """
    Type definition for `ClientListTagsForResource` `Response`

    Success.

    - **Tags** *(dict) --*

      A comma-separated list of tag key:value pairs. For example: { "Key1": "Value1", "Key2":
      "Value2" }

      - *(string) --*

        - *(string) --*
    """


_ClientPutPlaybackConfigurationCdnConfigurationTypeDef = TypedDict(
    "_ClientPutPlaybackConfigurationCdnConfigurationTypeDef",
    {"AdSegmentUrlPrefix": str, "ContentSegmentUrlPrefix": str},
    total=False,
)


class ClientPutPlaybackConfigurationCdnConfigurationTypeDef(
    _ClientPutPlaybackConfigurationCdnConfigurationTypeDef
):
    """
    Type definition for `ClientPutPlaybackConfiguration` `CdnConfiguration`

    The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content
    and ad segment management.

    - **AdSegmentUrlPrefix** *(string) --*

      A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental
      MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad segments. To
      set up an alternate CDN, create a rule in your CDN for the following origin:
      ads.mediatailor.<region>.amazonaws.com. Then specify the rule's name in this
      AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as
      the source for ad segments.

    - **ContentSegmentUrlPrefix** *(string) --*

      A content delivery network (CDN) to cache content segments, so that content requests don’t
      always have to go to the origin server. First, create a rule in your CDN for the content
      segment origin server. Then specify the rule's name in this ContentSegmentUrlPrefix. When AWS
      Elemental MediaTailor serves a manifest, it reports your CDN as the source for content segments.
    """


_ClientPutPlaybackConfigurationDashConfigurationTypeDef = TypedDict(
    "_ClientPutPlaybackConfigurationDashConfigurationTypeDef",
    {"MpdLocation": str, "OriginManifestType": str},
    total=False,
)


class ClientPutPlaybackConfigurationDashConfigurationTypeDef(
    _ClientPutPlaybackConfigurationDashConfigurationTypeDef
):
    """
    Type definition for `ClientPutPlaybackConfiguration` `DashConfiguration`

    The configuration for DASH content.

    - **MpdLocation** *(string) --*

      The setting that controls whether MediaTailor includes the Location tag in DASH manifests.
      MediaTailor populates the Location tag with the URL for manifest update requests, to be used by
      players that don't support sticky redirects. Disable this if you have CDN routing rules set up
      for accessing MediaTailor manifests, and you are either using client-side reporting or your
      players support sticky HTTP redirects. Valid values are DISABLED and EMT_DEFAULT. The
      EMT_DEFAULT setting enables the inclusion of the tag and is the default value.

    - **OriginManifestType** *(string) --*

      The setting that controls whether MediaTailor handles manifests from the origin server as
      multi-period manifests or single-period manifests. If your origin server produces single-period
      manifests, set this to SINGLE_PERIOD. The default setting is MULTI_PERIOD. For multi-period
      manifests, omit this setting or set it to MULTI_PERIOD.
    """


_ClientPutPlaybackConfigurationResponseCdnConfigurationTypeDef = TypedDict(
    "_ClientPutPlaybackConfigurationResponseCdnConfigurationTypeDef",
    {"AdSegmentUrlPrefix": str, "ContentSegmentUrlPrefix": str},
    total=False,
)


class ClientPutPlaybackConfigurationResponseCdnConfigurationTypeDef(
    _ClientPutPlaybackConfigurationResponseCdnConfigurationTypeDef
):
    """
    Type definition for `ClientPutPlaybackConfigurationResponse` `CdnConfiguration`

    The configuration for using a content delivery network (CDN), like Amazon CloudFront, for
    content and ad segment management.

    - **AdSegmentUrlPrefix** *(string) --*

      A non-default content delivery network (CDN) to serve ad segments. By default, AWS
      Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad
      segments. To set up an alternate CDN, create a rule in your CDN for the following origin:
      ads.mediatailor.<region>.amazonaws.com. Then specify the rule's name in this
      AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN
      as the source for ad segments.

    - **ContentSegmentUrlPrefix** *(string) --*

      A content delivery network (CDN) to cache content segments, so that content requests don’t
      always have to go to the origin server. First, create a rule in your CDN for the content
      segment origin server. Then specify the rule's name in this ContentSegmentUrlPrefix. When
      AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content
      segments.
    """


_ClientPutPlaybackConfigurationResponseDashConfigurationTypeDef = TypedDict(
    "_ClientPutPlaybackConfigurationResponseDashConfigurationTypeDef",
    {"ManifestEndpointPrefix": str, "MpdLocation": str, "OriginManifestType": str},
    total=False,
)


class ClientPutPlaybackConfigurationResponseDashConfigurationTypeDef(
    _ClientPutPlaybackConfigurationResponseDashConfigurationTypeDef
):
    """
    Type definition for `ClientPutPlaybackConfigurationResponse` `DashConfiguration`

    The configuration for DASH content.

    - **ManifestEndpointPrefix** *(string) --*

      The URL generated by MediaTailor to initiate a playback session. The session uses
      server-side reporting. This setting is ignored in PUT operations.

    - **MpdLocation** *(string) --*

      The setting that controls whether MediaTailor includes the Location tag in DASH manifests.
      MediaTailor populates the Location tag with the URL for manifest update requests, to be
      used by players that don't support sticky redirects. Disable this if you have CDN routing
      rules set up for accessing MediaTailor manifests, and you are either using client-side
      reporting or your players support sticky HTTP redirects. Valid values are DISABLED and
      EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of the tag and is the default
      value.

    - **OriginManifestType** *(string) --*

      The setting that controls whether MediaTailor handles manifests from the origin server as
      multi-period manifests or single-period manifests. If your origin server produces
      single-period manifests, set this to SINGLE_PERIOD. The default setting is MULTI_PERIOD.
      For multi-period manifests, omit this setting or set it to MULTI_PERIOD.
    """


_ClientPutPlaybackConfigurationResponseHlsConfigurationTypeDef = TypedDict(
    "_ClientPutPlaybackConfigurationResponseHlsConfigurationTypeDef",
    {"ManifestEndpointPrefix": str},
    total=False,
)


class ClientPutPlaybackConfigurationResponseHlsConfigurationTypeDef(
    _ClientPutPlaybackConfigurationResponseHlsConfigurationTypeDef
):
    """
    Type definition for `ClientPutPlaybackConfigurationResponse` `HlsConfiguration`

    The configuration for HLS content.

    - **ManifestEndpointPrefix** *(string) --*

      The URL that is used to initiate a playback session for devices that support Apple HLS. The
      session uses server-side reporting.
    """


_ClientPutPlaybackConfigurationResponseTypeDef = TypedDict(
    "_ClientPutPlaybackConfigurationResponseTypeDef",
    {
        "AdDecisionServerUrl": str,
        "CdnConfiguration": ClientPutPlaybackConfigurationResponseCdnConfigurationTypeDef,
        "DashConfiguration": ClientPutPlaybackConfigurationResponseDashConfigurationTypeDef,
        "HlsConfiguration": ClientPutPlaybackConfigurationResponseHlsConfigurationTypeDef,
        "Name": str,
        "PlaybackConfigurationArn": str,
        "PlaybackEndpointPrefix": str,
        "SessionInitializationEndpointPrefix": str,
        "SlateAdUrl": str,
        "Tags": Dict[str, str],
        "TranscodeProfileName": str,
        "VideoContentSourceUrl": str,
    },
    total=False,
)


class ClientPutPlaybackConfigurationResponseTypeDef(
    _ClientPutPlaybackConfigurationResponseTypeDef
):
    """
    Type definition for `ClientPutPlaybackConfiguration` `Response`

    Success.

    - **AdDecisionServerUrl** *(string) --*

      The URL for the ad decision server (ADS). This includes the specification of static
      parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes
      player-specific and session-specific parameters as needed when calling the ADS. Alternately,
      for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.

    - **CdnConfiguration** *(dict) --*

      The configuration for using a content delivery network (CDN), like Amazon CloudFront, for
      content and ad segment management.

      - **AdSegmentUrlPrefix** *(string) --*

        A non-default content delivery network (CDN) to serve ad segments. By default, AWS
        Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad
        segments. To set up an alternate CDN, create a rule in your CDN for the following origin:
        ads.mediatailor.<region>.amazonaws.com. Then specify the rule's name in this
        AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN
        as the source for ad segments.

      - **ContentSegmentUrlPrefix** *(string) --*

        A content delivery network (CDN) to cache content segments, so that content requests don’t
        always have to go to the origin server. First, create a rule in your CDN for the content
        segment origin server. Then specify the rule's name in this ContentSegmentUrlPrefix. When
        AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content
        segments.

    - **DashConfiguration** *(dict) --*

      The configuration for DASH content.

      - **ManifestEndpointPrefix** *(string) --*

        The URL generated by MediaTailor to initiate a playback session. The session uses
        server-side reporting. This setting is ignored in PUT operations.

      - **MpdLocation** *(string) --*

        The setting that controls whether MediaTailor includes the Location tag in DASH manifests.
        MediaTailor populates the Location tag with the URL for manifest update requests, to be
        used by players that don't support sticky redirects. Disable this if you have CDN routing
        rules set up for accessing MediaTailor manifests, and you are either using client-side
        reporting or your players support sticky HTTP redirects. Valid values are DISABLED and
        EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of the tag and is the default
        value.

      - **OriginManifestType** *(string) --*

        The setting that controls whether MediaTailor handles manifests from the origin server as
        multi-period manifests or single-period manifests. If your origin server produces
        single-period manifests, set this to SINGLE_PERIOD. The default setting is MULTI_PERIOD.
        For multi-period manifests, omit this setting or set it to MULTI_PERIOD.

    - **HlsConfiguration** *(dict) --*

      The configuration for HLS content.

      - **ManifestEndpointPrefix** *(string) --*

        The URL that is used to initiate a playback session for devices that support Apple HLS. The
        session uses server-side reporting.

    - **Name** *(string) --*

      The identifier for the playback configuration.

    - **PlaybackConfigurationArn** *(string) --*

      The Amazon Resource Name (ARN) for the playback configuration.

    - **PlaybackEndpointPrefix** *(string) --*

      The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This
      session will use server-side reporting.

    - **SessionInitializationEndpointPrefix** *(string) --*

      The URL that the player uses to initialize a session that uses client-side reporting.

    - **SlateAdUrl** *(string) --*

      The URL for a high-quality video asset to transcode and use to fill in time that's not used
      by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content.
      Configuring the slate is optional for non-VPAID playback configurations. For VPAID, the slate
      is required because MediaTailor provides it in the slots designated for dynamic ad content.
      The slate must be a high-quality asset that contains both audio and video.

    - **Tags** *(dict) --*

      The tags assigned to the playback configuration.

      - *(string) --*

        - *(string) --*

    - **TranscodeProfileName** *(string) --*

      The name that is used to associate this playback configuration with a custom transcode
      profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if you
      have already set up custom profiles with the help of AWS Support.

    - **VideoContentSourceUrl** *(string) --*

      The URL prefix for the master playlist for the stream, minus the asset ID. The maximum length
      is 512 characters.
    """


_ListPlaybackConfigurationsPaginatePaginationConfigTypeDef = TypedDict(
    "_ListPlaybackConfigurationsPaginatePaginationConfigTypeDef",
    {"MaxItems": int, "PageSize": int, "StartingToken": str},
    total=False,
)


class ListPlaybackConfigurationsPaginatePaginationConfigTypeDef(
    _ListPlaybackConfigurationsPaginatePaginationConfigTypeDef
):
    """
    Type definition for `ListPlaybackConfigurationsPaginate` `PaginationConfig`

    A dictionary that provides parameters to control pagination.

    - **MaxItems** *(integer) --*

      The total number of items to return. If the total number of items available is more than the
      value specified in max-items then a ``NextToken`` will be provided in the output that you can
      use to resume pagination.

    - **PageSize** *(integer) --*

      The size of each page.

    - **StartingToken** *(string) --*

      A token to specify where to start paginating. This is the ``NextToken`` from a previous
      response.
    """


_ListPlaybackConfigurationsPaginateResponseItemsCdnConfigurationTypeDef = TypedDict(
    "_ListPlaybackConfigurationsPaginateResponseItemsCdnConfigurationTypeDef",
    {"AdSegmentUrlPrefix": str, "ContentSegmentUrlPrefix": str},
    total=False,
)


class ListPlaybackConfigurationsPaginateResponseItemsCdnConfigurationTypeDef(
    _ListPlaybackConfigurationsPaginateResponseItemsCdnConfigurationTypeDef
):
    """
    Type definition for `ListPlaybackConfigurationsPaginateResponseItems` `CdnConfiguration`

    The configuration for using a content delivery network (CDN), like Amazon CloudFront, for
    content and ad segment management.

    - **AdSegmentUrlPrefix** *(string) --*

      A non-default content delivery network (CDN) to serve ad segments. By default, AWS
      Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for
      ad segments. To set up an alternate CDN, create a rule in your CDN for the following
      origin: ads.mediatailor.<region>.amazonaws.com. Then specify the rule's name in this
      AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your
      CDN as the source for ad segments.

    - **ContentSegmentUrlPrefix** *(string) --*

      A content delivery network (CDN) to cache content segments, so that content requests
      don’t always have to go to the origin server. First, create a rule in your CDN for the
      content segment origin server. Then specify the rule's name in this
      ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports
      your CDN as the source for content segments.
    """


_ListPlaybackConfigurationsPaginateResponseItemsDashConfigurationTypeDef = TypedDict(
    "_ListPlaybackConfigurationsPaginateResponseItemsDashConfigurationTypeDef",
    {"ManifestEndpointPrefix": str, "MpdLocation": str, "OriginManifestType": str},
    total=False,
)


class ListPlaybackConfigurationsPaginateResponseItemsDashConfigurationTypeDef(
    _ListPlaybackConfigurationsPaginateResponseItemsDashConfigurationTypeDef
):
    """
    Type definition for `ListPlaybackConfigurationsPaginateResponseItems` `DashConfiguration`

    The configuration for DASH content.

    - **ManifestEndpointPrefix** *(string) --*

      The URL generated by MediaTailor to initiate a playback session. The session uses
      server-side reporting. This setting is ignored in PUT operations.

    - **MpdLocation** *(string) --*

      The setting that controls whether MediaTailor includes the Location tag in DASH
      manifests. MediaTailor populates the Location tag with the URL for manifest update
      requests, to be used by players that don't support sticky redirects. Disable this if
      you have CDN routing rules set up for accessing MediaTailor manifests, and you are
      either using client-side reporting or your players support sticky HTTP redirects. Valid
      values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of
      the tag and is the default value.

    - **OriginManifestType** *(string) --*

      The setting that controls whether MediaTailor handles manifests from the origin server
      as multi-period manifests or single-period manifests. If your origin server produces
      single-period manifests, set this to SINGLE_PERIOD. The default setting is
      MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.
    """


_ListPlaybackConfigurationsPaginateResponseItemsHlsConfigurationTypeDef = TypedDict(
    "_ListPlaybackConfigurationsPaginateResponseItemsHlsConfigurationTypeDef",
    {"ManifestEndpointPrefix": str},
    total=False,
)


class ListPlaybackConfigurationsPaginateResponseItemsHlsConfigurationTypeDef(
    _ListPlaybackConfigurationsPaginateResponseItemsHlsConfigurationTypeDef
):
    """
    Type definition for `ListPlaybackConfigurationsPaginateResponseItems` `HlsConfiguration`

    The configuration for HLS content.

    - **ManifestEndpointPrefix** *(string) --*

      The URL that is used to initiate a playback session for devices that support Apple HLS.
      The session uses server-side reporting.
    """


_ListPlaybackConfigurationsPaginateResponseItemsTypeDef = TypedDict(
    "_ListPlaybackConfigurationsPaginateResponseItemsTypeDef",
    {
        "AdDecisionServerUrl": str,
        "CdnConfiguration": ListPlaybackConfigurationsPaginateResponseItemsCdnConfigurationTypeDef,
        "DashConfiguration": ListPlaybackConfigurationsPaginateResponseItemsDashConfigurationTypeDef,
        "HlsConfiguration": ListPlaybackConfigurationsPaginateResponseItemsHlsConfigurationTypeDef,
        "Name": str,
        "PlaybackConfigurationArn": str,
        "PlaybackEndpointPrefix": str,
        "SessionInitializationEndpointPrefix": str,
        "SlateAdUrl": str,
        "Tags": Dict[str, str],
        "TranscodeProfileName": str,
        "VideoContentSourceUrl": str,
    },
    total=False,
)


class ListPlaybackConfigurationsPaginateResponseItemsTypeDef(
    _ListPlaybackConfigurationsPaginateResponseItemsTypeDef
):
    """
    Type definition for `ListPlaybackConfigurationsPaginateResponse` `Items`

    The AWSMediaTailor configuration.

    - **AdDecisionServerUrl** *(string) --*

      The URL for the ad decision server (ADS). This includes the specification of static
      parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes
      player-specific and session-specific parameters as needed when calling the ADS.
      Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000
      characters.

    - **CdnConfiguration** *(dict) --*

      The configuration for using a content delivery network (CDN), like Amazon CloudFront, for
      content and ad segment management.

      - **AdSegmentUrlPrefix** *(string) --*

        A non-default content delivery network (CDN) to serve ad segments. By default, AWS
        Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for
        ad segments. To set up an alternate CDN, create a rule in your CDN for the following
        origin: ads.mediatailor.<region>.amazonaws.com. Then specify the rule's name in this
        AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your
        CDN as the source for ad segments.

      - **ContentSegmentUrlPrefix** *(string) --*

        A content delivery network (CDN) to cache content segments, so that content requests
        don’t always have to go to the origin server. First, create a rule in your CDN for the
        content segment origin server. Then specify the rule's name in this
        ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports
        your CDN as the source for content segments.

    - **DashConfiguration** *(dict) --*

      The configuration for DASH content.

      - **ManifestEndpointPrefix** *(string) --*

        The URL generated by MediaTailor to initiate a playback session. The session uses
        server-side reporting. This setting is ignored in PUT operations.

      - **MpdLocation** *(string) --*

        The setting that controls whether MediaTailor includes the Location tag in DASH
        manifests. MediaTailor populates the Location tag with the URL for manifest update
        requests, to be used by players that don't support sticky redirects. Disable this if
        you have CDN routing rules set up for accessing MediaTailor manifests, and you are
        either using client-side reporting or your players support sticky HTTP redirects. Valid
        values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of
        the tag and is the default value.

      - **OriginManifestType** *(string) --*

        The setting that controls whether MediaTailor handles manifests from the origin server
        as multi-period manifests or single-period manifests. If your origin server produces
        single-period manifests, set this to SINGLE_PERIOD. The default setting is
        MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.

    - **HlsConfiguration** *(dict) --*

      The configuration for HLS content.

      - **ManifestEndpointPrefix** *(string) --*

        The URL that is used to initiate a playback session for devices that support Apple HLS.
        The session uses server-side reporting.

    - **Name** *(string) --*

      The identifier for the playback configuration.

    - **PlaybackConfigurationArn** *(string) --*

      The Amazon Resource Name (ARN) for the playback configuration.

    - **PlaybackEndpointPrefix** *(string) --*

      The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This
      session will use server-side reporting.

    - **SessionInitializationEndpointPrefix** *(string) --*

      The URL that the player uses to initialize a session that uses client-side reporting.

    - **SlateAdUrl** *(string) --*

      The URL for a high-quality video asset to transcode and use to fill in time that's not
      used by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content.
      Configuring the slate is optional for non-VPAID playback configurations. For VPAID, the
      slate is required because MediaTailor provides it in the slots designated for dynamic ad
      content. The slate must be a high-quality asset that contains both audio and video.

    - **Tags** *(dict) --*

      The tags assigned to the playback configuration.

      - *(string) --*

        - *(string) --*

    - **TranscodeProfileName** *(string) --*

      The name that is used to associate this playback configuration with a custom transcode
      profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if
      you have already set up custom profiles with the help of AWS Support.

    - **VideoContentSourceUrl** *(string) --*

      The URL prefix for the master playlist for the stream, minus the asset ID. The maximum
      length is 512 characters.
    """


_ListPlaybackConfigurationsPaginateResponseTypeDef = TypedDict(
    "_ListPlaybackConfigurationsPaginateResponseTypeDef",
    {"Items": List[ListPlaybackConfigurationsPaginateResponseItemsTypeDef]},
    total=False,
)


class ListPlaybackConfigurationsPaginateResponseTypeDef(
    _ListPlaybackConfigurationsPaginateResponseTypeDef
):
    """
    Type definition for `ListPlaybackConfigurationsPaginate` `Response`

    Success.

    - **Items** *(list) --*

      Array of playback configurations. This might be all the available configurations or a subset,
      depending on the settings that you provide and the total number of configurations stored.

      - *(dict) --*

        The AWSMediaTailor configuration.

        - **AdDecisionServerUrl** *(string) --*

          The URL for the ad decision server (ADS). This includes the specification of static
          parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes
          player-specific and session-specific parameters as needed when calling the ADS.
          Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000
          characters.

        - **CdnConfiguration** *(dict) --*

          The configuration for using a content delivery network (CDN), like Amazon CloudFront, for
          content and ad segment management.

          - **AdSegmentUrlPrefix** *(string) --*

            A non-default content delivery network (CDN) to serve ad segments. By default, AWS
            Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for
            ad segments. To set up an alternate CDN, create a rule in your CDN for the following
            origin: ads.mediatailor.<region>.amazonaws.com. Then specify the rule's name in this
            AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your
            CDN as the source for ad segments.

          - **ContentSegmentUrlPrefix** *(string) --*

            A content delivery network (CDN) to cache content segments, so that content requests
            don’t always have to go to the origin server. First, create a rule in your CDN for the
            content segment origin server. Then specify the rule's name in this
            ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports
            your CDN as the source for content segments.

        - **DashConfiguration** *(dict) --*

          The configuration for DASH content.

          - **ManifestEndpointPrefix** *(string) --*

            The URL generated by MediaTailor to initiate a playback session. The session uses
            server-side reporting. This setting is ignored in PUT operations.

          - **MpdLocation** *(string) --*

            The setting that controls whether MediaTailor includes the Location tag in DASH
            manifests. MediaTailor populates the Location tag with the URL for manifest update
            requests, to be used by players that don't support sticky redirects. Disable this if
            you have CDN routing rules set up for accessing MediaTailor manifests, and you are
            either using client-side reporting or your players support sticky HTTP redirects. Valid
            values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of
            the tag and is the default value.

          - **OriginManifestType** *(string) --*

            The setting that controls whether MediaTailor handles manifests from the origin server
            as multi-period manifests or single-period manifests. If your origin server produces
            single-period manifests, set this to SINGLE_PERIOD. The default setting is
            MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.

        - **HlsConfiguration** *(dict) --*

          The configuration for HLS content.

          - **ManifestEndpointPrefix** *(string) --*

            The URL that is used to initiate a playback session for devices that support Apple HLS.
            The session uses server-side reporting.

        - **Name** *(string) --*

          The identifier for the playback configuration.

        - **PlaybackConfigurationArn** *(string) --*

          The Amazon Resource Name (ARN) for the playback configuration.

        - **PlaybackEndpointPrefix** *(string) --*

          The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This
          session will use server-side reporting.

        - **SessionInitializationEndpointPrefix** *(string) --*

          The URL that the player uses to initialize a session that uses client-side reporting.

        - **SlateAdUrl** *(string) --*

          The URL for a high-quality video asset to transcode and use to fill in time that's not
          used by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content.
          Configuring the slate is optional for non-VPAID playback configurations. For VPAID, the
          slate is required because MediaTailor provides it in the slots designated for dynamic ad
          content. The slate must be a high-quality asset that contains both audio and video.

        - **Tags** *(dict) --*

          The tags assigned to the playback configuration.

          - *(string) --*

            - *(string) --*

        - **TranscodeProfileName** *(string) --*

          The name that is used to associate this playback configuration with a custom transcode
          profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if
          you have already set up custom profiles with the help of AWS Support.

        - **VideoContentSourceUrl** *(string) --*

          The URL prefix for the master playlist for the stream, minus the asset ID. The maximum
          length is 512 characters.
    """
