"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
/**
 * An EC2 instance that is the target for load balancing
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can connect to the instance.
 */
class InstanceIdTarget {
    /**
     * Create a new Instance target
     *
     * @param instanceId Instance ID of the instance to register to
     * @param port Override the default port for the target group
     */
    constructor(instanceId, port) {
        this.instanceId = instanceId;
        this.port = port;
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToApplicationTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.INSTANCE,
            targetJson: { id: this.instanceId, port: this.port }
        };
    }
}
exports.InstanceIdTarget = InstanceIdTarget;
class InstanceTarget extends InstanceIdTarget {
    /**
     * Create a new Instance target
     *
     * @param instance Instance to register to
     * @param port Override the default port for the target group
     */
    constructor(instance, port) {
        super(instance.instanceId, port);
    }
}
exports.InstanceTarget = InstanceTarget;
//# sourceMappingURL=data:application/json;base64,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