"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcEndpointService = exports.VpcEndpointServiceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const privatelink_generated_1 = require("./privatelink.generated");
Object.defineProperty(exports, "VpcEndpointServiceProperty", { enumerable: true, get: function () { return privatelink_generated_1.RosVpcEndpointService; } });
/**
 * A ROS resource type:  `ALIYUN::PrivateLink::VpcEndpointService`
 */
class VpcEndpointService extends ros.Resource {
    /**
     * Create a new `ALIYUN::PrivateLink::VpcEndpointService`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosVpcEndpointService = new privatelink_generated_1.RosVpcEndpointService(this, id, {
            payer: props.payer,
            user: props.user,
            serviceDescription: props.serviceDescription,
            resource: props.resource,
            connectBandwidth: props.connectBandwidth,
            serviceResourceType: props.serviceResourceType,
            zoneAffinityEnabled: props.zoneAffinityEnabled,
            autoAcceptEnabled: props.autoAcceptEnabled,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosVpcEndpointService;
        this.attrMaxBandwidth = rosVpcEndpointService.attrMaxBandwidth;
        this.attrMinBandwidth = rosVpcEndpointService.attrMinBandwidth;
        this.attrServiceDescription = rosVpcEndpointService.attrServiceDescription;
        this.attrServiceDomain = rosVpcEndpointService.attrServiceDomain;
        this.attrServiceId = rosVpcEndpointService.attrServiceId;
        this.attrServiceName = rosVpcEndpointService.attrServiceName;
    }
}
exports.VpcEndpointService = VpcEndpointService;
//# sourceMappingURL=data:application/json;base64,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