import traceback

TWITTER_ERRORS = {0: 'DefaultApiError', 3: 'InvalidCoordinates', 4: 'InvalidGranularity', 5: 'InvalidAccuracy', 6: 'NoDataForPoint', 7: 'NoDataForPointRadius', 8: 'InvalidId', 9: 'InvalidMaxResults', 10: 'RockdoveError', 11: 'InvalidIp', 12: 'MustProvideCoordinatesIpQueryOrAttributes', 13: 'NoLocationForIp', 14: 'OverlimitAddressBookApi', 15: 'AddressBookDarkmoded', 16: 'AddressBookPermissionsError', 17: 'AddressBookLookupNotFound', 18: 'TooManyTerms', 19: 'RetweetDarkmoded', 20: 'NoScreenNameProvided', 21: 'ContributorsNotEnabled', 22: 'NotAuthorizedToViewUser', 23: 'BulkLookupDarkmoded', 24: 'UnsupportedProfileImageSize', 25: 'MissingQuery', 26: 'AutocompleteMustBeTrueOrFalse', 27: 'AccountLocked', 28: 'GenericDarkmode', 29: 'TimeOut', 30: 'WoeidDataUnavailable', 31: 'InvalidTimescale', 32: 'InvalidCredentials', 33: 'OverLimit', 34: 'GenericNotFound', 35: 'TrendDataUnavailable', 36: 'CantReportYourselfAsSpam', 37: 'GenericAccessDenied', 38: 'MissingParameter', 39: 'InvalidCreationToken', 41: 'RockdoveInvalidArgumentError', 42: 'InvalidAttribute', 43: 'AttributeAccessDenied', 44: 'InvalidParameter', 46: 'InvalidPlaceJson', 47: 'InvalidRequestUrl', 48: 'TimeoutRequestRainbird', 49: 'NoFollowRequest', 50: 'GenericUserNotFound', 51: 'PromotedContentOfflineError', 52: 'PromotedSearchNoQuery', 53: 'BasicAuthDisabled', 54: 'CassowaryError', 55: 'ResourceNotFound', 56: 'InvalidEmailAddress', 57: 'PasswordResetPermissionsError', 58: 'PasswordResetExpiredToken', 59: 'PasswordResetInvalidHash', 60: 'PasswordResetMismatchedEntries', 61: 'ClientNotPermitted', 62: 'CustomSaveErrors', 63: 'OtherUserSuspended', 64: 'CurrentUserSuspended', 65: 'StrictMustBeTrueOrFalse', 66: 'RequireActivityMustBeTrueOrFalse', 67: 'BackendServiceUnavailable', 68: 'EndpointDeprecated', 69: 'TalonUrlMalware', 70: 'InvalidPromotedContentLogEvent', 71: 'EmailDeliveryError', 72: 'ApplicationNotFound', 73: 'ApplicationNotDeleted', 74: 'ApplicationDomainNotRevoked', 75: 'ApplicationKeysNotReset', 76: 'ApplicationImageNotProcessed', 77: 'ApplicationNoManageRight', 78: 'ApplicationNoAdminRight', 79: 'InvalidTrimPlace', 80: 'CurationDarkmoded', 81: 'ContributorsAccessLevelNotValid', 82: 'ContributorsTargetUserNotSpecified', 83: 'ContributorsTargetUserNotValid', 84: 'TalonUrlUnrenderable', 85: 'ValidationFailure', 86: 'WrongHttpMethod', 87: 'ClientNotPrivileged', 88: 'RateLimitExceeded', 89: 'BadOauthToken', 90: 'ContributionNotPermitted', 91: 'InvalidUtf8', 92: 'SslRequired', 93: 'DmAccessRequired', 94: 'PageIsForbidden', 95: 'InvalidLanguage', 96: 'InvalidIds', 97: 'EndpointFeatureDeprecated', 98: 'FlagPossiblySensitiveScribeError', 99: 'AuthenticityTokenError', 100: 'GenericThriftException', 101: 'InvalidReverseAuthCredentials', 102: 'DarkmodedFeature', 103: 'TrendsAvailableTransientException', 104: 'ListAdminRightsError', 105: 'MaximumMembersExceeded', 106: 'AddBlockedUserError', 107: 'NoTargetUser', 108: 'TargetUserNotFound', 109: 'TargetUserNotRelatedToList', 110: 'ListNotAMemberError', 111: 'TargetUserSuspended', 112: 'InsufficientListParameters', 113: 'InsufficientTargetUserParameters', 114: 'InvalidCurrentPassword', 115: 'ListUnauthorizedSubscriptionError', 116: 'PasswordSmsResetPwSeedNotExist', 117: 'PasswordSmsResetOptOut', 118: 'ArgumentTooLarge', 119: 'NarrowcastNotSupported', 120: 'AccountUpdateFailure', 121: 'InvalidHexColor', 122: 'UpdateProfileColorsError', 123: 'ImageUpdateError', 124: 'AttributeUpdateError', 125: 'GeolocationError', 126: 'LoggedOut', 127: 'ArchiveDeprecated', 128: 'LocationUpdateFailure', 129: 'EmailRateLimitExceeded', 130: 'OverCapacity', 131: 'InternalError', 132: 'UnusedBackgroundUploadError', 133: 'NoSelectedBackgroundError', 134: 'TooManyDevices', 135: 'OauthTimestampException', 136: 'BlockedUserError', 137: 'PushForbidden', 138: 'FollowingInformationUnavailable', 139: 'DuplicateFavorite', 140: 'FollowingStatusUnauthorized', 141: 'InactiveUser', 142: 'ProtectedStatusFavoriteError', 143: 'FavoriteRateLimitExceeded', 144: 'StatusNotFound', 145: 'RecordInvalid', 146: 'OtherUserNotBlocked', 147: 'SelfBlockError', 148: 'UnsupportedDevice', 149: 'InvalidEnabledFor', 150: 'DirectMessageOtherUserNotFollowing', 151: 'MessageSendError', 152: 'DirectMessageDestroyPermissionsError', 153: 'DirectMessageDeleteError', 154: 'DirectMessageNotFound', 155: 'MessageSendUnknownError', 156: 'DowntimeAlert', 157: 'VerifiedDeviceNotFound', 158: 'SelfFollowError', 159: 'GenericSuspended', 160: 'DuplicateFollowRequest', 161: 'FollowRateLimitExceeded', 162: 'FollowBlockedUserError', 163: 'IndeterminateSource', 164: 'TargetUserNotSpecified', 165: 'MultipleMissingParameters', 166: 'MultipleUserNotFound', 167: 'FollowError', 168: 'StatusNotFoundForbidden', 169: 'StatusRelatedResultsForbidden', 170: 'ForbiddenMissingParameter', 171: 'SearchDeletionError', 172: 'SearchCreationError', 173: 'ConfirmEmailExpiredCode', 174: 'ConfirmEmailInvalidCode', 175: 'ConfirmEmailInvalidStateChange', 176: 'ConfirmEmailAlreadyConfirmed', 177: 'ConfirmEmailSuccessChanged', 178: 'ConfirmEmailSuccessNew', 179: 'StatusViewForbidden', 180: 'GenericEndpointOffline', 181: 'TimeParameterOrderError', 182: 'ParameterDeprecated', 183: 'StatusActionPermissionError', 184: 'StatusUpdateError', 185: 'OverStatusUpdateLimit', 186: 'StatusTooLongError', 187: 'DuplicateStatusError', 188: 'StatusMalwareError', 189: 'StatusCreationError', 190: 'UnknownInterpreterError', 191: 'OverPhotoLimit', 192: 'OverMediaEntitiesPerUpdateLimit', 193: 'MediaTooLarge', 194: 'StatusUpdateForbidden', 195: 'InvalidRequestUrlForbidden', 196: 'TimelineAuthorizationRequired', 197: 'CategoryNotFound', 198: 'ContactLoadError', 199: 'IdsOfContactsError', 200: 'GenericForbidden', 201: 'GetRequired', 202: 'InternalApplicationAuthenticationDenied', 203: 'DeviceError', 204: 'DestinationError', 205: 'SpamRateLimitExceeded', 206: 'InvalidDeviceRelationship', 207: 'AlreadyActivated', 208: 'FormatNotSupported', 209: 'DirectMessageMustFollowFirst', 210: 'TokenLimitExceeded', 211: 'InvalidBrandBanner', 212: 'ProfileBannerUploadsDisabled', 213: 'ProcessingInProgress', 214: 'GenericBadRequest', 215: 'BadAuthenticationData', 216: 'ShareViaEmailRateLimitExceeded', 217: 'ProtectedStatusShareViaEmailError', 218: 'RestrictedAccessShareViaEmailError', 219: 'ShareViaEmailIpRateLimitExceeded', 220: 'RestrictedAuthToken', 221: 'CursorInvalid', 222: 'TieredActionSignupSpammer', 223: 'EmailTweetSendingError', 224: 'MissingEmailAddress', 225: 'TieredActionFollowSpammer', 226: 'TieredActionTweetSpammer', 227: 'TieredActionFollowCreeper', 228: 'TieredActionTweetCreeper', 229: 'AmbiguousCredentials', 230: 'UserSleeping', 231: 'RequiresLoginVerification', 232: 'CannotEnableLoginVerificationPhone', 233: 'CannotEnableLoginVerificationAlreadyEnabled', 234: 'CannotEnableLoginVerificationUnconfirmedEmail', 235: 'ExpiredLoginVerificationRequest', 236: 'IncorrectChallengeResponse', 237: 'MissingLoginVerificationRequest', 238: 'NewPasswordWeak', 239: 'BadGuestToken', 240: 'TieredActionSignupSpammerPhoneVerify', 241: 'RejectedLoginVerificationRequest', 242: 'DeactivatedUser', 243: 'OverLimitLogin', 244: 'ForcePasswordReset', 245: 'OverLimitLoginVerificationStart', 246: 'OverLimitLoginVerificationAttempt', 247: 'CannotEnableLoginVerificationPush', 248: 'LoginVerificationAlreadyEnabled', 249: 'CloudIpRestricted', 250: 'UserMustBeAlcoholAgeScreened', 251: 'EndpointRetired', 252: 'DmSpamTimeout', 253: 'NotYetApprovedLoginVerification', 254: 'OfflineCodeSync', 255: 'RequiresTemporaryPassword', 256: 'CannotFollowFromCountry', 257: 'BadDeviceToken', 258: 'AppsCreateRequiresConfirmedEmail', 259: 'AppsCreateRequiresVerifiedPhone', 260: 'AppsCreateRejectedForAbuse', 261: 'AppInReadOnlyMode', 262: 'CurrentUserNeedsPhoneVerification', 263: 'TieredActionChallengeCaptcha', 264: 'TargetUserNotFollowing', 265: 'TargetUserNotFavoriteFollowing', 266: 'FailureSendingLoginVerificationRequest', 267: 'InvalidCredentialsOneFactorEligible', 268: 'MissingOneFactorLoginVerificationParams', 269: 'UserIsNotSdkUser', 270: 'AppsUpdateSettingsRequiresVerifiedPhone', 271: 'SelfMuteError', 272: 'NotMutingTargetUser', 273: 'ScheduledInPast', 274: 'ScheduledTooFarInFuture', 275: 'TooLateToEdit', 276: 'ScheduleInvalid', 277: 'DirectMessageRecipientDoesNotFollowSenderWithUnverifiedPhoneNumber', 278: 'DirectMessageUserNotInConversation', 279: 'DirectMessageConversationNotFound', 280: 'DirectMessageTooManyParticipants', 281: 'DirectMessageTooFewParticipants', 282: 'DirectMessageRecipientBlocksSender', 283: 'TieredActionFavoriteSpammer', 284: 'DeviceRegistrationGeneralError', 285: 'DeviceAlreadyRegistered', 286: 'DeviceOperatorUnsupported', 287: 'UserAlreadyHasVerifiedPhone', 288: 'CannotReuseCurrentPassword', 289: 'DevicePinInvalid', 290: 'DevicePinRequired', 291: 'UnexpectedDeviceProvided', 292: 'TieredActionConversationSpammer', 293: 'SmsVerifyGeneralError', 294: 'SmsVerifyInvalidPin', 295: 'SmsVerifyRateLimitExceeded', 296: 'DtabOverrideDarkmoded', 297: 'DirectMessageCannotHaveBothTweetAndMedia', 298: 'DirectMessageTweetNotFound', 299: 'DeviceRegistrationRateExceeded', 300: 'DeviceRegistrationInvalidInput', 301: 'DeviceRegistrationPending', 302: 'DeviceRegistrationOperationFailed', 303: 'DeviceRegistrationPhoneNormalizationFailed', 304: 'DeviceRegistrationPhoneCountryDetectionFailed', 305: 'CannotIdentifyByEmail', 306: 'TieredActionAccessTokenGrantSpam', 307: 'TieredActionAccessTokenRevokeSpam', 308: 'NoSmsVerifyExists', 309: 'DeviceNotVerified', 310: 'ExpiredPin', 311: 'DirectMessageDuplicate', 312: 'LocationNameMustBeSpecified', 313: 'EULANotAccepted', 314: 'VideoTranscodingError', 315: 'ClientCaptchaRequired', 316: 'CannotContributeToYourself', 317: 'AccountHasTooManyContributors', 318: 'AccountHasTooManyContributees', 319: 'CannotChangePassword', 320: 'ContributorsAccessLevelInsufficient', 321: 'DirectMessageConversationNameTooLong', 322: 'DirectMessageGenericUserCouldNotBeAdded', 323: 'AnimatedGifMultipleImages', 324: 'InvalidMediaId', 325: 'MediaNotFound', 326: 'AccessDeniedByBouncer', 327: 'AlreadyRetweeted', 328: 'InvalidRetweetForStatus', 329: 'NonsupportingClientRequiresLoginVerification', 330: 'ContributorsGenericUserCouldNotBeAdded', 331: 'MobileSettingsUserNotFound', 332: 'MobileSettingsTemplateNotFound', 333: 'MobileSettingsFileNotFound', 334: 'MobileSettingsUnsupportedTransport', 335: 'MobileSettingsSettingNotFound', 336: 'MobileSettingsInvalidValueFound', 337: 'MobileSettingsSettingObjectNotFound', 338: 'MobileSettingsEnabledForMissing', 339: 'MobileSettingsNoDevicesFound', 340: 'MobileSettingsNoIncomingPushSettings', 341: 'MobileSettingsNoIncomingSmsSettings', 342: 'MobileSettingsIncorrectApplicationId', 343: 'MobileSettingsNoIncomingSettings', 344: 'UserActionRateLimitExceeded', 345: 'OneFactorMethodIsNotSupported', 346: 'UserIsNotOneFactorEligible', 347: 'InvalidRequestToken', 348: 'ClientApplicationNotPermitted', 349: 'DirectMessageCannotDmOtherUser', 350: 'OauthException', 351: 'MobileSettingsCouldNotUpdateSleep', 352: 'ParameterLimitExceeded', 353: 'DeniedByApiCsrfProtection', 354: 'DirectMessageTooLongError', 355: 'GenericConflict', 356: 'GenericValidationFailure', 357: 'RequiredFieldMissing', 358: 'JsonProcessingError', 359: 'ValueTooLarge', 360: 'ValueTooSmall', 361: 'ValueCannotBeEmpty', 362: 'TimeNotFuture', 363: 'InvalidCountryCodes', 364: 'InvalidTimeGranularity', 365: 'InvalidUUID', 366: 'InvalidValues', 367: 'SizeOutOfRange', 368: 'TimeNotPast', 369: 'InvalidJsonSyntax', 370: 'DigitsCannotReuseCurrentEmail', 371: 'MentionLimitInTweetExceeded', 372: 'UrlLimitInTweetExceeded', 373: 'HashtagLimitInTweetExceeded', 374: 'ExpiredQrCode', 375: 'InvalidQrCode', 376: 'MissingCredentials', 377: 'TokenRetrievalException', 378: 'TokenMissing', 379: 'DataminrUserNotLinked', 380: 'ABLiveSyncIsDisabled', 381: 'SoftUserCreationSpamDenied', 382: 'SoftUserActionSpamDenied', 383: 'CashtagLimitInTweetExceeded', 384: 'HashtagLengthLimitInTweetExceeded', 385: 'InReplyToTweetNotFound', 386: 'AttachmentTypesLimitInTweetExceeded', 387: 'NotEnoughFollowers', 388: 'FeatureAccessLimited', 389: 'DirectMessagesSenderBlocksRecipient', 390: 'SearchRecordingNotFound', 391: 'MaximumSearchRecordingsExceeded', 392: 'SessionNotFound', 393: 'SessionModificationNotAuthorized', 394: 'SessionModificationFailed', 395: 'VoiceVerifyRateLimitExceeded', 396: 'BlockUserFailed', 397: 'InvalidMetricsJson', 398: 'OnboardingFlowFailure', 399: 'OnboardingFlowRetriableFailure', 400: 'NoTwoFactorAuthMethodFound', 401: 'MomentCapsuleAccessError', 402: 'CannotEnrollLoginVerificationNotYetEnabled', 403: 'IneligibleFor2faAfterModification', 404: 'CookiesRequired', 405: 'DuplicateBookmark', 406: 'ProtectedTweetBookmarkError', 407: 'DirectMessageInactiveDevice', 408: 'InvalidUrl', 409: 'BirthdateRequired', 410: 'PasswordVerificationRequired', 411: 'DirectMessageSenderInSecretDmsDisabledCountry', 412: 'DirectMessageRecipientInSecretDmsDisabledCountry', 413: 'DirectMessageSenderDeviceIsNotActiveForSecretDms', 414: 'DirectMessageRecipientDeviceIsNotActiveForSecretDms', 415: 'CallbackUrlLocked', 416: 'InvalidOrSuspendedApp', 417: 'InvalidDesktopCallback', 418: 'DirectMessageSenderIsNotRegisteredForSecretDms', 419: 'DirectMessageRecipientIsNotRegisteredForSecretDms', 420: 'ReservedErrorCode', 421: 'TweetIsBounced', 422: 'TweetIsBounceDeleted', 423: 'InvalidHeaders', 424: 'MomentUnavailableForNewsCamera', 425: 'TweetEngagementsLimited', 426: 'InvalidRequestIpv6Token', 427: 'IpResolverNotAvailable', 428: 'ValidIpv6TokenRequired', 429: 'HarmfulLink', 430: 'ConversationControlNotAllowed', 431: 'ConversationControlNotSupported', 432: 'ConversationControlNotAuthorized', 433: 'ConversationControlReplyRestricted', 434: 'NotMutingTargetList', 435: 'ConversationControlInvalidParameter', 436: 'PassswordRequiredForEmailUpdate', 437: 'NewPasswordShort', 438: 'NewPasswordLong', 439: 'NudgeReceived', 440: 'CommunityUserNotAuthorized', 441: 'CommunityNotFound', 442: 'CommunityRetweetNotAllowed', 443: 'CommunityInvalidParams', 444: 'CommunityReplyTweetNotAllowed', 445: 'RestrictedSession', 446: 'TokenSecurityLevelAgreementPolicyFailure', 447: 'SuperFollowsCreateNotAuthorized', 448: 'SuperFollowsInvalidParams', 449: 'TOOMomentsList', 450: 'CommunityProtectedUserCannotTweet', 451: 'ExclusiveTweetEngagementNotAllowed', 452: 'SteamCreationException', 453: 'V11Restricted', 454: 'SteamGetException', 455: 'TrustedFriendsInvalidParams', 456: 'TrustedFriendsRetweetNotAllowed'}


class UserNotFound(Exception):
    """Exception raised when user isn't found.

    Attributes:
        message -- explanation of the error
    """

    def __init__(self, error_code=50, error_name="GenericUserNotFound", response=None, message="The User Account wasn't Found", **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        super().__init__(self.message)


class GuestTokenNotFound(Exception):
    """
    Exception Raised when the guest token wasn't found after specific number of retires

    Attributes:
        message -- explanation of the error
    """

    def __init__(self, error_code, error_name, response, message="The Guest Token couldn't be obtained", **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        super().__init__(self.message)


class InvalidTweetIdentifier(Exception):
    """
        Exception Raised when the tweet identifier is invalid

        Attributes:
            message -- explanation of the error
    """

    def __init__(self, error_code=144, error_name="StatusNotFound", response=None, message="The Tweet Identifier is Invalid", **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        super().__init__(self.message)


class RateLimitReached(Exception):
    """
        Exception Raised when the tweet identifier is invalid

        Attributes:
            message -- explanation of the error
    """

    def __init__(self, error_code, error_name, response, message="You have exceeded the Twitter Rate Limit", **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        self.retry_after = kw.get('retry_after')  # Number of seconds required for rate limit to be reset
        super().__init__(self.message)


class ProxyParseError(Exception):
    """
    Exception Raised when an error occurs while parsing the provided proxy

    Attributes:
        message -- explanation of the error
    """

    def __init__(self, message="Error while parsing the Proxy, please make sure you are passing the right formatted proxy", **kw):
        self.message = message
        super().__init__(self.message)


class UserProtected(Exception):
    """
    Exception Raised when an error occurs when the queried User isn't available / Protected

    Attributes:
        message -- explanation of the error
    """

    def __init__(self, error_code=403, error_name="UserUnavailable", response=None, message="The User is Protected OR Unavailable, please make sure you are authenticated and authorized", **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        super().__init__(self.message)


class UnknownError(Exception):
    """
        Exception Raised when an unknown error occurs

        Attributes:
            message -- explanation of the error
        """

    def __init__(self, error_code, error_name, response, message, **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response

        if not self.response.json_() and self.response.text:
            self.message = self.response.text
        elif str(self.error_code) == "404":
            self.message = "Page not Found. Most likely you need elevated authorization to access this resource"

        super().__init__(self.message)


class DeniedLogin(Exception):
    """
        Exception Raised when the Twitter deny the login request ,
        could be due to multiple login attempts (or failed attempts)

        Attributes:
            message -- explanation of the error
    """

    def __init__(self, error_code=37, error_name="GenericAccessDenied", response=None, message=None, **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        super().__init__(self.message)


class ActionRequired(Exception):
    """
        Exception Raised when the Twitter Login Request require an additional step from the user

        Attributes:
            message -- explanation of the error
    """

    def __init__(self, error_code, error_name, response, message, **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        super().__init__(self.message)


class InvalidCredentials(Exception):
    """
        Exception Raised when cookies credentials are invalid

        Attributes:
            message -- explanation of the error
    """

    def __init__(self, error_code, error_name, response, message="The Cookies are Invalid", **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        super().__init__(self.message)

class InvalidBroadcast(Exception):
    """
        Exception Raised when cookies are required for making a specific request

        Attributes:
            message -- explanation of the error
    """

    def __init__(self, error_code, error_name, response, message="The Broadcast doesn't exists", **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        super().__init__(self.message)


class AuthenticationRequired(Exception):
    """
        Exception Raised when cookies are required for making a specific request

        Attributes:
            message -- explanation of the error
    """

    def __init__(self, error_code, error_name, response, message="You need to be authenticated and connected to make this request", **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        super().__init__(self.message)

class ListNotFound(Exception):
    """
        Exception Raised when queried list wasn't found

        Attributes:
            message -- explanation of the error
    """

    def __init__(self, error_code, error_name, response, message="List not Found", **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        super().__init__(self.message)


class AudioSpaceNotFound(Exception):
    """
        Exception Raised when queried Audio Space isn't found

        Attributes:
            message -- explanation of the error
    """

    def __init__(self, error_code, error_name, response, message="Audio Space not found", **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        super().__init__(self.message)


class ProtectedTweet(Exception):
    """
        Exception Raised when queried Tweet is protected, and you need authorization to access it

        Attributes:
            message -- explanation of the error
    """

    def __init__(self, error_code, error_name, response, message="Tweet is private/protected", **kw):
        self.message = message
        self.error_code = error_code
        self.error_name = error_name
        self.response = response
        super().__init__(self.message)