from collections.abc import Callable
from typing import Any
from typing_extensions import TypeAlias

MypyFile: TypeAlias = Any  # from mypy.nodes
AttributeContext: TypeAlias = Any  # from mypy.plugin
ClassDefContext: TypeAlias = Any  # from mypy.plugin
DynamicClassDefContext: TypeAlias = Any  # from mypy.plugin
Plugin: TypeAlias = Any  # from mypy.plugin
Type: TypeAlias = Any  # from mypy.types

class SQLAlchemyPlugin(Plugin):
    def get_dynamic_class_hook(self, fullname: str) -> Callable[[DynamicClassDefContext], None] | None: ...
    def get_customize_class_mro_hook(self, fullname: str) -> Callable[[ClassDefContext], None] | None: ...
    def get_class_decorator_hook(self, fullname: str) -> Callable[[ClassDefContext], None] | None: ...
    def get_metaclass_hook(self, fullname: str) -> Callable[[ClassDefContext], None] | None: ...
    def get_base_class_hook(self, fullname: str) -> Callable[[ClassDefContext], None] | None: ...
    def get_attribute_hook(self, fullname: str) -> Callable[[AttributeContext], Type] | None: ...
    def get_additional_deps(self, file: MypyFile) -> list[tuple[int, str, int]]: ...

def plugin(version: str) -> type[SQLAlchemyPlugin]: ...
