# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourceArgs', 'Resource']

@pulumi.input_type
class ResourceArgs:
    def __init__(__self__, *,
                 parent_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 body: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input['ResourceIdentityArgs']] = None,
                 ignore_casing: Optional[pulumi.Input[bool]] = None,
                 ignore_missing_property: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 response_export_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 schema_validation_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Resource resource.
        :param pulumi.Input[str] type: It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
               `<api-version>` is version of the API used to manage this azure resource.
        :param pulumi.Input[str] body: A JSON object that contains the request body used to create and update azure resource.
        :param pulumi.Input['ResourceIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[bool] ignore_casing: Whether ignore incorrect casing returned in `body` to suppress plan-diff. Defaults to `false`.
        :param pulumi.Input[bool] ignore_missing_property: Whether ignore not returned properties like credentials in `body` to suppress plan-diff. Defaults to `true`.
        :param pulumi.Input[str] location: The Azure Region where the azure resource should exist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locks: A list of ARM resource IDs which are used to avoid create/modify/delete azapi resources at the same time.
        :param pulumi.Input[str] name: Specifies the name of the azure resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_export_values: A list of path that needs to be exported from response body.
               Setting it to `["*"]` will export the full response body.
               Here's an example. If it sets to `["properties.loginServer", "properties.policies.quarantinePolicy.status"]`, it will set the following json to computed property `output`.
               ```python
               import pulumi
               ```
        :param pulumi.Input[bool] schema_validation_enabled: Whether enabled the validation on `type` and `body` with embedded schema. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags which should be assigned to the azure resource.
        """
        pulumi.set(__self__, "parent_id", parent_id)
        pulumi.set(__self__, "type", type)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if ignore_casing is not None:
            pulumi.set(__self__, "ignore_casing", ignore_casing)
        if ignore_missing_property is not None:
            pulumi.set(__self__, "ignore_missing_property", ignore_missing_property)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if response_export_values is not None:
            pulumi.set(__self__, "response_export_values", response_export_values)
        if schema_validation_enabled is not None:
            pulumi.set(__self__, "schema_validation_enabled", schema_validation_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
        `<api-version>` is version of the API used to manage this azure resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON object that contains the request body used to create and update azure resource.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="ignoreCasing")
    def ignore_casing(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether ignore incorrect casing returned in `body` to suppress plan-diff. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_casing")

    @ignore_casing.setter
    def ignore_casing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_casing", value)

    @property
    @pulumi.getter(name="ignoreMissingProperty")
    def ignore_missing_property(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether ignore not returned properties like credentials in `body` to suppress plan-diff. Defaults to `true`.
        """
        return pulumi.get(self, "ignore_missing_property")

    @ignore_missing_property.setter
    def ignore_missing_property(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_missing_property", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Region where the azure resource should exist.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of ARM resource IDs which are used to avoid create/modify/delete azapi resources at the same time.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the azure resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="responseExportValues")
    def response_export_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of path that needs to be exported from response body.
        Setting it to `["*"]` will export the full response body.
        Here's an example. If it sets to `["properties.loginServer", "properties.policies.quarantinePolicy.status"]`, it will set the following json to computed property `output`.
        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "response_export_values")

    @response_export_values.setter
    def response_export_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "response_export_values", value)

    @property
    @pulumi.getter(name="schemaValidationEnabled")
    def schema_validation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enabled the validation on `type` and `body` with embedded schema. Defaults to `true`.
        """
        return pulumi.get(self, "schema_validation_enabled")

    @schema_validation_enabled.setter
    def schema_validation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "schema_validation_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of tags which should be assigned to the azure resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ResourceState:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input['ResourceIdentityArgs']] = None,
                 ignore_casing: Optional[pulumi.Input[bool]] = None,
                 ignore_missing_property: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 response_export_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 schema_validation_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Resource resources.
        :param pulumi.Input[str] body: A JSON object that contains the request body used to create and update azure resource.
        :param pulumi.Input['ResourceIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[bool] ignore_casing: Whether ignore incorrect casing returned in `body` to suppress plan-diff. Defaults to `false`.
        :param pulumi.Input[bool] ignore_missing_property: Whether ignore not returned properties like credentials in `body` to suppress plan-diff. Defaults to `true`.
        :param pulumi.Input[str] location: The Azure Region where the azure resource should exist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locks: A list of ARM resource IDs which are used to avoid create/modify/delete azapi resources at the same time.
        :param pulumi.Input[str] name: Specifies the name of the azure resource. Changing this forces a new resource to be created.
        :param pulumi.Input[str] output: The output json containing the properties specified in `response_export_values`. Here're some examples to decode json and extract the value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_export_values: A list of path that needs to be exported from response body.
               Setting it to `["*"]` will export the full response body.
               Here's an example. If it sets to `["properties.loginServer", "properties.policies.quarantinePolicy.status"]`, it will set the following json to computed property `output`.
               ```python
               import pulumi
               ```
        :param pulumi.Input[bool] schema_validation_enabled: Whether enabled the validation on `type` and `body` with embedded schema. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags which should be assigned to the azure resource.
        :param pulumi.Input[str] type: It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
               `<api-version>` is version of the API used to manage this azure resource.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if ignore_casing is not None:
            pulumi.set(__self__, "ignore_casing", ignore_casing)
        if ignore_missing_property is not None:
            pulumi.set(__self__, "ignore_missing_property", ignore_missing_property)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if response_export_values is not None:
            pulumi.set(__self__, "response_export_values", response_export_values)
        if schema_validation_enabled is not None:
            pulumi.set(__self__, "schema_validation_enabled", schema_validation_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON object that contains the request body used to create and update azure resource.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="ignoreCasing")
    def ignore_casing(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether ignore incorrect casing returned in `body` to suppress plan-diff. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_casing")

    @ignore_casing.setter
    def ignore_casing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_casing", value)

    @property
    @pulumi.getter(name="ignoreMissingProperty")
    def ignore_missing_property(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether ignore not returned properties like credentials in `body` to suppress plan-diff. Defaults to `true`.
        """
        return pulumi.get(self, "ignore_missing_property")

    @ignore_missing_property.setter
    def ignore_missing_property(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_missing_property", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Region where the azure resource should exist.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of ARM resource IDs which are used to avoid create/modify/delete azapi resources at the same time.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the azure resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def output(self) -> Optional[pulumi.Input[str]]:
        """
        The output json containing the properties specified in `response_export_values`. Here're some examples to decode json and extract the value.
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter(name="responseExportValues")
    def response_export_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of path that needs to be exported from response body.
        Setting it to `["*"]` will export the full response body.
        Here's an example. If it sets to `["properties.loginServer", "properties.policies.quarantinePolicy.status"]`, it will set the following json to computed property `output`.
        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "response_export_values")

    @response_export_values.setter
    def response_export_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "response_export_values", value)

    @property
    @pulumi.getter(name="schemaValidationEnabled")
    def schema_validation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enabled the validation on `type` and `body` with embedded schema. Defaults to `true`.
        """
        return pulumi.get(self, "schema_validation_enabled")

    @schema_validation_enabled.setter
    def schema_validation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "schema_validation_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of tags which should be assigned to the azure resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
        `<api-version>` is version of the API used to manage this azure resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Resource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input[pulumi.InputType['ResourceIdentityArgs']]] = None,
                 ignore_casing: Optional[pulumi.Input[bool]] = None,
                 ignore_missing_property: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 response_export_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 schema_validation_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage any Azure resource manager resource.

        ## Import

        Azure resource can be imported using the `resource id`, e.g.

        ```sh
         $ pulumi import azapi:index/resource:Resource example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.MachineLearningServices/workspaces/workspace1/computes/cluster1
        ```

         It also supports specifying API version by using the `resource id` with `api-version` as a query parameter, e.g.

        ```sh
         $ pulumi import azapi:index/resource:Resource example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.MachineLearningServices/workspaces/workspace1/computes/cluster1?api-version=2021-07-01
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body: A JSON object that contains the request body used to create and update azure resource.
        :param pulumi.Input[pulumi.InputType['ResourceIdentityArgs']] identity: A `identity` block as defined below.
        :param pulumi.Input[bool] ignore_casing: Whether ignore incorrect casing returned in `body` to suppress plan-diff. Defaults to `false`.
        :param pulumi.Input[bool] ignore_missing_property: Whether ignore not returned properties like credentials in `body` to suppress plan-diff. Defaults to `true`.
        :param pulumi.Input[str] location: The Azure Region where the azure resource should exist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locks: A list of ARM resource IDs which are used to avoid create/modify/delete azapi resources at the same time.
        :param pulumi.Input[str] name: Specifies the name of the azure resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_export_values: A list of path that needs to be exported from response body.
               Setting it to `["*"]` will export the full response body.
               Here's an example. If it sets to `["properties.loginServer", "properties.policies.quarantinePolicy.status"]`, it will set the following json to computed property `output`.
               ```python
               import pulumi
               ```
        :param pulumi.Input[bool] schema_validation_enabled: Whether enabled the validation on `type` and `body` with embedded schema. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags which should be assigned to the azure resource.
        :param pulumi.Input[str] type: It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
               `<api-version>` is version of the API used to manage this azure resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage any Azure resource manager resource.

        ## Import

        Azure resource can be imported using the `resource id`, e.g.

        ```sh
         $ pulumi import azapi:index/resource:Resource example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.MachineLearningServices/workspaces/workspace1/computes/cluster1
        ```

         It also supports specifying API version by using the `resource id` with `api-version` as a query parameter, e.g.

        ```sh
         $ pulumi import azapi:index/resource:Resource example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.MachineLearningServices/workspaces/workspace1/computes/cluster1?api-version=2021-07-01
        ```

        :param str resource_name: The name of the resource.
        :param ResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input[pulumi.InputType['ResourceIdentityArgs']]] = None,
                 ignore_casing: Optional[pulumi.Input[bool]] = None,
                 ignore_missing_property: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 response_export_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 schema_validation_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceArgs.__new__(ResourceArgs)

            __props__.__dict__["body"] = body
            __props__.__dict__["identity"] = identity
            __props__.__dict__["ignore_casing"] = ignore_casing
            __props__.__dict__["ignore_missing_property"] = ignore_missing_property
            __props__.__dict__["location"] = location
            __props__.__dict__["locks"] = locks
            __props__.__dict__["name"] = name
            if parent_id is None and not opts.urn:
                raise TypeError("Missing required property 'parent_id'")
            __props__.__dict__["parent_id"] = parent_id
            __props__.__dict__["response_export_values"] = response_export_values
            __props__.__dict__["schema_validation_enabled"] = schema_validation_enabled
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["output"] = None
        super(Resource, __self__).__init__(
            'azapi:index/resource:Resource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body: Optional[pulumi.Input[str]] = None,
            identity: Optional[pulumi.Input[pulumi.InputType['ResourceIdentityArgs']]] = None,
            ignore_casing: Optional[pulumi.Input[bool]] = None,
            ignore_missing_property: Optional[pulumi.Input[bool]] = None,
            location: Optional[pulumi.Input[str]] = None,
            locks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            output: Optional[pulumi.Input[str]] = None,
            parent_id: Optional[pulumi.Input[str]] = None,
            response_export_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            schema_validation_enabled: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Resource':
        """
        Get an existing Resource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body: A JSON object that contains the request body used to create and update azure resource.
        :param pulumi.Input[pulumi.InputType['ResourceIdentityArgs']] identity: A `identity` block as defined below.
        :param pulumi.Input[bool] ignore_casing: Whether ignore incorrect casing returned in `body` to suppress plan-diff. Defaults to `false`.
        :param pulumi.Input[bool] ignore_missing_property: Whether ignore not returned properties like credentials in `body` to suppress plan-diff. Defaults to `true`.
        :param pulumi.Input[str] location: The Azure Region where the azure resource should exist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locks: A list of ARM resource IDs which are used to avoid create/modify/delete azapi resources at the same time.
        :param pulumi.Input[str] name: Specifies the name of the azure resource. Changing this forces a new resource to be created.
        :param pulumi.Input[str] output: The output json containing the properties specified in `response_export_values`. Here're some examples to decode json and extract the value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_export_values: A list of path that needs to be exported from response body.
               Setting it to `["*"]` will export the full response body.
               Here's an example. If it sets to `["properties.loginServer", "properties.policies.quarantinePolicy.status"]`, it will set the following json to computed property `output`.
               ```python
               import pulumi
               ```
        :param pulumi.Input[bool] schema_validation_enabled: Whether enabled the validation on `type` and `body` with embedded schema. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags which should be assigned to the azure resource.
        :param pulumi.Input[str] type: It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
               `<api-version>` is version of the API used to manage this azure resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceState.__new__(_ResourceState)

        __props__.__dict__["body"] = body
        __props__.__dict__["identity"] = identity
        __props__.__dict__["ignore_casing"] = ignore_casing
        __props__.__dict__["ignore_missing_property"] = ignore_missing_property
        __props__.__dict__["location"] = location
        __props__.__dict__["locks"] = locks
        __props__.__dict__["name"] = name
        __props__.__dict__["output"] = output
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["response_export_values"] = response_export_values
        __props__.__dict__["schema_validation_enabled"] = schema_validation_enabled
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return Resource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON object that contains the request body used to create and update azure resource.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.ResourceIdentity']:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="ignoreCasing")
    def ignore_casing(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether ignore incorrect casing returned in `body` to suppress plan-diff. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_casing")

    @property
    @pulumi.getter(name="ignoreMissingProperty")
    def ignore_missing_property(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether ignore not returned properties like credentials in `body` to suppress plan-diff. Defaults to `true`.
        """
        return pulumi.get(self, "ignore_missing_property")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The Azure Region where the azure resource should exist.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def locks(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of ARM resource IDs which are used to avoid create/modify/delete azapi resources at the same time.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the azure resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def output(self) -> pulumi.Output[str]:
        """
        The output json containing the properties specified in `response_export_values`. Here're some examples to decode json and extract the value.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="responseExportValues")
    def response_export_values(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of path that needs to be exported from response body.
        Setting it to `["*"]` will export the full response body.
        Here's an example. If it sets to `["properties.loginServer", "properties.policies.quarantinePolicy.status"]`, it will set the following json to computed property `output`.
        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "response_export_values")

    @property
    @pulumi.getter(name="schemaValidationEnabled")
    def schema_validation_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enabled the validation on `type` and `body` with embedded schema. Defaults to `true`.
        """
        return pulumi.get(self, "schema_validation_enabled")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A mapping of tags which should be assigned to the azure resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
        `<api-version>` is version of the API used to manage this azure resource.
        """
        return pulumi.get(self, "type")

