# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetResourceActionResult',
    'AwaitableGetResourceActionResult',
    'get_resource_action',
    'get_resource_action_output',
]

@pulumi.output_type
class GetResourceActionResult:
    """
    A collection of values returned by getResourceAction.
    """
    def __init__(__self__, action=None, body=None, id=None, method=None, output=None, resource_id=None, response_export_values=None, type=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        pulumi.set(__self__, "body", body)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if method and not isinstance(method, str):
            raise TypeError("Expected argument 'method' to be a str")
        pulumi.set(__self__, "method", method)
        if output and not isinstance(output, str):
            raise TypeError("Expected argument 'output' to be a str")
        pulumi.set(__self__, "output", output)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if response_export_values and not isinstance(response_export_values, list):
            raise TypeError("Expected argument 'response_export_values' to be a list")
        pulumi.set(__self__, "response_export_values", response_export_values)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def body(self) -> Optional[str]:
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def output(self) -> str:
        """
        The output json containing the properties specified in `response_export_values`. Here are some examples to decode json and extract the value.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="responseExportValues")
    def response_export_values(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "response_export_values")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


class AwaitableGetResourceActionResult(GetResourceActionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceActionResult(
            action=self.action,
            body=self.body,
            id=self.id,
            method=self.method,
            output=self.output,
            resource_id=self.resource_id,
            response_export_values=self.response_export_values,
            type=self.type)


def get_resource_action(action: Optional[str] = None,
                        body: Optional[str] = None,
                        method: Optional[str] = None,
                        resource_id: Optional[str] = None,
                        response_export_values: Optional[Sequence[str]] = None,
                        type: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceActionResult:
    """
    This resource can perform resource action which gets information from an existing resource.
    It's recommended to use `ResourceAction` data source to perform readonly action, please use `ResourceAction` resource,
    if user wants to perform actions which change a resource's state.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azapi as azapi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("exampleResourceGroup", location="west europe")
    example_account = azure.automation.Account("exampleAccount",
        resource_group_name=example_resource_group.name,
        location=example_resource_group.location,
        sku_name="Basic")
    example_resource_action = azapi.get_resource_action_output(type="Microsoft.Automation/automationAccounts@2021-06-22",
        resource_id=example_account.id,
        action="listKeys",
        response_export_values=["*"])
    ```


    :param str action: The name of the resource action. It's also possible to make Http requests towards the resource ID if leave this field empty.
    :param str body: A JSON object that contains the request body.
    :param str method: Specifies the Http method of the azure resource action. Allowed values are `POST` and `GET`. Defaults to `POST`.
    :param str resource_id: The ID of an existing azure source.
    :param Sequence[str] response_export_values: A list of path that needs to be exported from response body.
           Setting it to `["*"]` will export the full response body.
           Here's an example. If it sets to `["keys"]`, it will set the following json to computed property `output`.
           ```python
           import pulumi
           ```
    :param str type: It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
           `<api-version>` is version of the API used to manage this azure resource.
    """
    __args__ = dict()
    __args__['action'] = action
    __args__['body'] = body
    __args__['method'] = method
    __args__['resourceId'] = resource_id
    __args__['responseExportValues'] = response_export_values
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azapi:index/getResourceAction:getResourceAction', __args__, opts=opts, typ=GetResourceActionResult).value

    return AwaitableGetResourceActionResult(
        action=__ret__.action,
        body=__ret__.body,
        id=__ret__.id,
        method=__ret__.method,
        output=__ret__.output,
        resource_id=__ret__.resource_id,
        response_export_values=__ret__.response_export_values,
        type=__ret__.type)


@_utilities.lift_output_func(get_resource_action)
def get_resource_action_output(action: Optional[pulumi.Input[Optional[str]]] = None,
                               body: Optional[pulumi.Input[Optional[str]]] = None,
                               method: Optional[pulumi.Input[Optional[str]]] = None,
                               resource_id: Optional[pulumi.Input[Optional[str]]] = None,
                               response_export_values: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                               type: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetResourceActionResult]:
    """
    This resource can perform resource action which gets information from an existing resource.
    It's recommended to use `ResourceAction` data source to perform readonly action, please use `ResourceAction` resource,
    if user wants to perform actions which change a resource's state.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azapi as azapi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("exampleResourceGroup", location="west europe")
    example_account = azure.automation.Account("exampleAccount",
        resource_group_name=example_resource_group.name,
        location=example_resource_group.location,
        sku_name="Basic")
    example_resource_action = azapi.get_resource_action_output(type="Microsoft.Automation/automationAccounts@2021-06-22",
        resource_id=example_account.id,
        action="listKeys",
        response_export_values=["*"])
    ```


    :param str action: The name of the resource action. It's also possible to make Http requests towards the resource ID if leave this field empty.
    :param str body: A JSON object that contains the request body.
    :param str method: Specifies the Http method of the azure resource action. Allowed values are `POST` and `GET`. Defaults to `POST`.
    :param str resource_id: The ID of an existing azure source.
    :param Sequence[str] response_export_values: A list of path that needs to be exported from response body.
           Setting it to `["*"]` will export the full response body.
           Here's an example. If it sets to `["keys"]`, it will set the following json to computed property `output`.
           ```python
           import pulumi
           ```
    :param str type: It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
           `<api-version>` is version of the API used to manage this azure resource.
    """
    ...
