"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3_assets = require("@aws-cdk/aws-s3-assets");
/**
 * (experimental) Code configuration providing the location to a Flink application JAR file.
 *
 * @experimental
 */
class ApplicationCode {
    /**
     * (experimental) Reference code from an S3 bucket.
     *
     * @param bucket - an s3 bucket.
     * @param fileKey - a key pointing to a Flink JAR file.
     * @param objectVersion - an optional version string for the provided fileKey.
     * @experimental
     */
    static fromBucket(bucket, fileKey, objectVersion) {
        return new BucketApplicationCode({
            bucket,
            fileKey,
            objectVersion,
        });
    }
    /**
     * (experimental) Reference code from a local directory containing a Flink JAR file.
     *
     * @param path - a local directory path.
     * @experimental
     * @parm options - standard s3 AssetOptions
     */
    static fromAsset(path, options) {
        return new AssetApplicationCode(path, options);
    }
}
exports.ApplicationCode = ApplicationCode;
_a = JSII_RTTI_SYMBOL_1;
ApplicationCode[_a] = { fqn: "@aws-cdk/aws-kinesisanalytics-flink.ApplicationCode", version: "1.126.0" };
class BucketApplicationCode extends ApplicationCode {
    constructor(props) {
        super();
        this.bucket = props.bucket;
        this.fileKey = props.fileKey;
        this.objectVersion = props.objectVersion;
    }
    bind(_scope) {
        return {
            applicationCodeConfigurationProperty: {
                applicationCodeConfiguration: {
                    codeContent: {
                        s3ContentLocation: {
                            bucketArn: this.bucket.bucketArn,
                            fileKey: this.fileKey,
                            objectVersion: this.objectVersion,
                        },
                    },
                    codeContentType: 'ZIPFILE',
                },
            },
            bucket: this.bucket,
        };
    }
}
class AssetApplicationCode extends ApplicationCode {
    constructor(path, options) {
        super();
        this.path = path;
        this.options = options;
    }
    bind(scope) {
        this._asset = new s3_assets.Asset(scope, 'Code', {
            path: this.path,
            ...this.options,
        });
        if (!this._asset.isZipArchive) {
            throw new Error(`Asset must be a .zip file or a directory (${this.path})`);
        }
        return {
            applicationCodeConfigurationProperty: {
                applicationCodeConfiguration: {
                    codeContent: {
                        s3ContentLocation: {
                            bucketArn: this._asset.bucket.bucketArn,
                            fileKey: this._asset.s3ObjectKey,
                        },
                    },
                    codeContentType: 'ZIPFILE',
                },
            },
            bucket: this._asset.bucket,
        };
    }
    get asset() {
        return this._asset;
    }
    get bucket() {
        var _b;
        return (_b = this._asset) === null || _b === void 0 ? void 0 : _b.bucket;
    }
}
//# sourceMappingURL=data:application/json;base64,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