# Pulumi Provider for Proxmox

>Under development, not yet available

A Pulumi Provider which adds support for Proxmox solutions.

based on [danitso/terraform-provider-proxmox](2), read its docs for details.

TODO: 

- Add github actions and badgets.

### Build the provider:


In order to properly build the sdks, the following tools are expected:
- `pulumictl` (See the project's README for installation instructions: https://github.com/pulumi/pulumictl)


- Edit `provider/resources.go` to map each resource, and specify provider information
- `make build_sdks`

## Installing

This package is available in many languages in the standard packaging formats.

first, build and install resource plugin:

```shell
make install_resources
```

then install sdks...

### Node.js (Java/TypeScript)

Not yet supported, please install npm package from source:

```shell
make install_nodejs_sdk
```

### Python

```shell
make install_python_sdk
```

### Go

To use from Go, use `go get` to grab the latest version of the library

    $ go get github.com/ryan4yin/pulumi-proxmox/sdk/go/...

## Configuration & Reference

please read [danitso/terraform-provider-proxmox](2)'s docs for details.

### Provider Arguments Reference

>BUG: cannot read configuration from EnvVars `PROXMOX_VE_ENDPOINT` `PROXMOX_VE_USERNAME` etc.
I'm Working on it now.

In addition to [generic provider arguments](https://www.terraform.io/docs/configuration/providers.html) (e.g. `alias` and `version`), the following arguments are supported in the Proxmox `provider` block:

* `virtual_environment` - (Optional) The Proxmox Virtual Environment configuration.
    * `endpoint` - (Required) The endpoint for the Proxmox Virtual Environment API (can also be sourced from `PROXMOX_VE_ENDPOINT`).
    * `insecure` - (Optional) Whether to skip the TLS verification step (can also be sourced from `PROXMOX_VE_INSECURE`). If omitted, defaults to `false`.
    * `otp` - (Optional) The one-time password for the Proxmox Virtual Environment API (can also be sourced from `PROXMOX_VE_OTP`).
    * `password` - (Required) The password for the Proxmox Virtual Environment API (can also be sourced from `PROXMOX_VE_PASSWORD`).
    * `username` - (Required) The username and realm for the Proxmox Virtual Environment API (can also be sourced from `PROXMOX_VE_USERNAME`).



[2]: https://github.com/danitso/terraform-provider-proxmox
