from setuptools import find_packages, setup
import pathlib

# The directory containing this file
HERE = pathlib.Path(__file__).parent

# The text of the README file
README = (HERE / "README.md").read_text()


setup(
    name="prefect-cloud-manager",
    version="0.1.1",
    description="A convenient CLI for managing multiple Prefect accounts.",
    long_description=README,
    long_description_content_type="text/markdown",
    url="https://github.com/ngriffiths13/prefect-cloud-manager",
    author="Nelson Griffiths",
    author_email="nelsongriffiths123@gmail.com",
    license="MIT",
    classifiers=[
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
    ],
    package_dir={"": "src"},
    packages=find_packages(where="src"),
    install_requires=[
        "fire",
        "pyyaml",
        "toml",
    ],
    entry_points="""
        [console_scripts]
        prefect-manager=prefect_cloud_manager.prefect_account:main
    """
)
