# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['csv2notion', 'csv2notion.notion']

package_data = \
{'': ['*']}

install_requires = \
['bs4>=0.0.1,<0.0.2',
 'cached-property>=1.5.2,<2.0.0',
 'commonmark>=0.9.1,<0.10.0',
 'dictdiffer>=0.9.0,<0.10.0',
 'emoji>=1.7.0,<2.0.0',
 'python-dateutil>=2.8.2,<3.0.0',
 'python-slugify>=6.1.1,<7.0.0',
 'requests>=2.27.1,<3.0.0',
 'tqdm>=4.64.0,<5.0.0',
 'tzlocal>=4.2,<5.0']

entry_points = \
{'console_scripts': ['csv2notion = csv2notion.cli:main']}

setup_kwargs = {
    'name': 'csv2notion',
    'version': '0.1.3',
    'description': 'Import/Merge CSV files into Notion database',
    'long_description': "# csv2notion\n\n[![PyPI version](https://img.shields.io/pypi/v/csv2notion?label=version)](https://pypi.python.org/pypi/csv2notion)\n[![Python Version](https://img.shields.io/pypi/pyversions/csv2notion.svg)](https://pypi.org/project/csv2notion/)\n[![tests](https://github.com/vzhd1701/csv2notion/actions/workflows/test.yml/badge.svg)](https://github.com/vzhd1701/csv2notion/actions/workflows/test.yml)\n[![codecov](https://codecov.io/gh/vzhd1701/csv2notion/branch/master/graph/badge.svg)](https://codecov.io/gh/vzhd1701/csv2notion)\n\nAn alternative way to import `*.csv` files to [Notion.so](https://notion.so).\n\nDue to current limitations of the official Notion SDK this tool is using the unofficial SDK by **Jamie Alexandre** [notion-py](https://github.com/jamalex/notion-py).\n\n### Advantages over native import\n\n- Actually merge CSV with existing database rows (not just add new ones), first column will be used as a key\n- Manually set column types instead of relying on autodetection\n- Automatically link or create new entries in relation columns based on their value\n- Set icon for each row\n- Set cover or embed image for each row\n- Upload image file used for cover or icon\n- Options for validation of input data\n\n### Disadvantages over native import\n\n- Slower speed, since every row is imported separately\n  - this is mitigated by multithreaded upload\n\n## Installation\n\n[**Download the latest binary release**](https://github.com/vzhd1701/csv2notion/releases/latest) for your OS.\n\n### With PIP\n\n```bash\n$ pip install csv2notion\n```\n\n**Python 3.7 or later required.**\n\nOr, since **csv2notion** is a standalone tool, it might be more convenient to install it using [**pipx**](https://github.com/pipxproject/pipx):\n\n```shell\n$ pipx install csv2notion\n```\n\n### From source\n\nThis project uses [poetry](https://python-poetry.org/) for dependency management and packaging. You will have to install it first. See [poetry official documentation](https://python-poetry.org/docs/) for instructions.\n\n```shell\n$ git clone https://github.com/vzhd1701/csv2notion.git\n$ cd csv2notion/\n$ poetry install --no-dev\n$ poetry run csv2notion\n```\n\n## Usage\n\n```shell\n$ csv2notion --help\nusage: csv2notion [-h] --token TOKEN [--url URL] [--max-threads NUMBER] [--custom-types TYPES] [--image-column COLUMN] [--image-column-keep] [--image-column-mode {cover,block}] [--image-caption-column COLUMN]\n                  [--image-caption-column-keep] [--icon-column COLUMN] [--icon-column-keep] [--default-icon ICON] [--missing-columns-action {add,ignore,fail}] [--missing-relations-action {add,ignore,fail}]\n                  [--fail-on-relation-duplicates] [--fail-on-duplicates] [--fail-on-duplicate-csv-columns] [--fail-on-conversion-error] [--fail-on-inaccessible-relations] [--merge] [--merge-only-column COLUMN]\n                  [--mandatory-column COLUMN] [--log FILE] [--verbose] [--version]\n                  FILE\n\nImport/Merge CSV file into Notion database\n\npositional arguments:\n  FILE                  CSV file to upload\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --token TOKEN         Notion token, stored in token_v2 cookie for notion.so [NEEDED FOR UPLOAD]\n  --url URL             Notion database URL; if none is provided, will create a new database\n  --max-threads NUMBER  upload threads (default: 5)\n  --custom-types TYPES  comma-separated list of custom types to use for non-key columns; if none is provided, types will be guessed from CSV values (used when creating a new database or --missing-columns-action is set to 'add')\n  --image-column COLUMN\n                        CSV column that points to URL or image file that will be embedded for that row\n  --image-column-keep   keep image CSV column as a Notion DB column\n  --image-column-mode {cover,block}\n                        upload image as [cover] or insert it as [block] (default: block)\n  --image-caption-column COLUMN\n                        CSV column that points to text caption that will be added to the image block if --image-column-mode is set to 'block'\n  --image-caption-column-keep\n                        keep image caption CSV column as a Notion DB column\n  --icon-column COLUMN  CSV column that points to emoji, URL or image file that will be used as page icon for that row\n  --icon-column-keep    keep icon CSV column as a Notion DB column\n  --default-icon ICON   Emoji, URL or image file that will be used as page icon for every row by default\n  --missing-columns-action {add,ignore,fail}\n                        if columns are present in CSV but not in Notion DB, [add] them to Notion DB, [ignore] them or [fail] (default: ignore)\n  --missing-relations-action {add,ignore,fail}\n                        if entries are missing from linked Notion DB, [add] them to Notion DB, [ignore] them or [fail] (default: ignore)\n  --fail-on-relation-duplicates\n                        fail if any linked DBs in relation columns have duplicate entries; otherwise, first entry in alphabetical order will be treated as unique when looking up relations\n  --fail-on-duplicates  fail if Notion DB or CSV has duplicates in key column, useful when sanitizing before merge to avoid ambiguous mapping\n  --fail-on-duplicate-csv-columns\n                        fail if CSV has duplicate columns; otherwise last column will be used\n  --fail-on-conversion-error\n                        fail if any column type conversion error occurs; otherwise errors will be replaced with empty strings\n  --fail-on-inaccessible-relations\n                        fail if any relation column points to a Notion DB that is not accessible to the current user; otherwise those columns will be ignored\n  --merge               merge CSV with existing Notion DB rows, first column will be used as a key\n  --merge-only-column COLUMN\n                        CSV column that should be updated on merge; when provided, other columns will be ignored (define multiple times for multiple columns)\n  --mandatory-column COLUMN\n                        CSV column that cannot be empty (define multiple times for multiple columns)\n  --log FILE            file to store program log\n  --verbose             output debug information\n  --version             show program's version number and exit\n```\n\n### Input\n\nYou must pass a single `*.csv` file for upload. The CSV file must contain at least 2 rows. The first row will be used as a header.\n\nOptionally you can provide a URL to an existing Notion database with the `--url` option; if not provided, the tool will create a new database named after the CSV file. The URL must link [to a database view](https://github.com/vzhd1701/csv2notion/raw/master/examples/db_link.png), not a page.\n\nThe tool also requires you to provide a `token_v2` cookie for the Notion website through `--token` option. For information on how to get it, see [this article](https://vzhd1701.notion.site/Find-Your-Notion-Token-5f57951434c1414d84ac72f88226eede).\n\n### Upload speed\n\nDue to API limitations, the upload is performed one row at a time. To speed things up, this tool uses multiple parallel threads. Use the `--max-threads` option to control how fast it will go. Try not to set it too high to avoid rate limiting by the Notion server.\n\n### Duplicate CSV columns\n\nNotion does not allow the database to have multiple columns with the same name. Therefore CSV columns will be treated as unique. Only the **last** column will be used if CSV has multiple columns with the same name. If you want the program to stop if it finds duplicate columns, use the `--fail-on-duplicate-csv-columns` flag.\n\n### Missing columns\n\nIf a CSV file has columns not present in Notion DB, they will be ignored by default. You can change this by using the `--missing-columns-action` option. Set it to `add` if you want the tool to add missing columns into Notion DB. Set to `fail` if you want the program to stop if it finds a column mismatch.\n\n### Column types\n\nBy default, the tool will try to guess column types based on their content. Alternatively, you can provide a comma-separated list of column types with the `--custom-types` option when creating a new database or adding new columns with the `--missing-columns-action` option set to `add`. Since the first column in Notion DB is always text, the tool will use the list to set types for the rest of the columns.\n\nIf the tool cannot convert the column value type properly, it will replace it with an empty string. If you want to make sure all values are correctly converted, use the `--fail-on-conversion-error` flag, which will stop execution in case of a conversion error.\n\n### Merging\n\nBy default, the tool will add rows to the existing Notion DB. To merge CSV rows with the Notion database, use the `--merge` flag. The first column of CSV and Notion DB will be used as a key to update existing rows with new values. CSV rows that didn't have a match in Notion DB will be added as new.\n\nSince the tool treats rows as unique during merge based on the key column, it will use first found rows with a unique key. To avoid this ambiguity, you might want to validate duplicate row keys with the `--fail-on-duplicates` flag. It will check both CSV and target Notion DB before the merge.\n\nIf you want only select columns to be updated, use the `--merge-only-column` option.\n\n### Relation columns\n\nNotion database has a relation column type, which allows you to link together entries from different databases. The tool will try to match column data with keys from a linked database.\n\nBy default, it will match with the first found row; if it cannot find the match, it will add nothing. You can change this behavior with the `--missing-relations-action` option. Set it to `add` if you want the tool to create new entries in the linked DB if no match is found. Set it to `fail` if you want the program to stop if no match is found.\n\nSince the tool treats rows in the linked DB as unique you can prevent ambiguous matching with the `--fail-on-relation-duplicates` flag. It will check linked DB for duplicate keys and stop the executions if it finds any.\n\nIf linked DB is not accessible, columns that point to it will be ignored. If you prefer the program to stop in this case, use the `--fail-on-inaccessible-relations` flag.\n\n### Cover image / Embedded image\n\nThe tool allows you to add an image to each row with the `--image-column` option. It will use one column from CSV as a data source for the image. It can be either a URL or a file name. The file name must be either an absolute path or a path relative to the CSV file. The tool will upload the file to the Notion server.\n\nBy default, the tool will embed an image inside the row page. If you want it to use the image as a page cover, then set the `--image-column-mode` option to `cover`.\n\nColumn specified with the `--image-column` option will not be treated as a regular column by default. If you want it to appear in Notion DB, use the `--image-column-keep` flag.\n\nTo add custom caption to image block uploaded with `--image-column-mode` set to `block`, use `--image-caption-colum` option. To also keep the caption as a Notion DB column, use `--image-caption-column-keep` flag.\n\n### Icon\n\nThe tool allows you to add an icon to each row with the `--icon-column` option. The behavior is the same as with `--image-column`; the only difference is that you can use URL, file name, or single emoji.\n\nTo also treat `--icon-column` as a regular column, use `--icon-column-keep` flag, similar to `--image-column-keep`.\n\nIf you want to set the same icon for each row, use the `--default-icon` option. If both `--icon-column` and `--default-icon` are present, the default icon is used if the row doesn't have anything in the icon column.\n\n### Mandatory columns\n\nIf you want to ensure that specific columns always have value and are not allowed to be empty, then use the `--mandatory-column` option. The program execution will stop if validation fails.\n\n## Examples\n\n- [Importing CSV into new DB](https://github.com/vzhd1701/csv2notion/raw/master/examples/new_db.png)\n- [Using custom column types](https://github.com/vzhd1701/csv2notion/raw/master/examples/new_db_types.png)\n- [Importing CSV into existing DB](https://github.com/vzhd1701/csv2notion/raw/master/examples/add_new.png)\n- [Merging CSV with existing DB](https://github.com/vzhd1701/csv2notion/raw/master/examples/merge.png)\n- [Merging CSV with select columns in existing DB](https://github.com/vzhd1701/csv2notion/raw/master/examples/merge_only.png)\n- [Importing rows with images](https://github.com/vzhd1701/csv2notion/raw/master/examples/image_column.png)\n- [Importing rows with emoji icons](https://github.com/vzhd1701/csv2notion/raw/master/examples/icon_column.png)\n- [Updating emoji icon only for all rows](https://github.com/vzhd1701/csv2notion/raw/master/examples/default_icon_only.png)\n\n## Getting help\n\nIf you found a bug or have a feature request, please [open a new issue](https://github.com/vzhd1701/csv2notion/issues/new/choose).\n\nIf you have a question about the program or have difficulty using it, you are welcome to [the discussions page](https://github.com/vzhd1701/csv2notion/discussions). You can also mail me directly, I'm always happy to help.\n",
    'author': 'vzhd1701',
    'author_email': 'vzhd1701@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/vzhd1701/csv2notion',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
