# pyidw - All in one IDW package for python

![idw interpolated map using pyidw](https://user-images.githubusercontent.com/69247506/130098328-fe8f04ba-f815-4d29-85d8-cf015e13aaaa.png)


Inverse distance weighted interpolation is one of the simplest geospatial interpolations available in GIS. Although it is easy to produce an idw raster using conventional desktop GIS software (eg. ArcGIS, QGIS). It was never straightforward to create such a beautiful map image using python. This is why I have created the pyidw library where you can create beautiful idw maps of your desired location using your favourite programming language.  

---

**if you are facing trouble installing pyidw on your windows machine, try this command below on the windows command line.** 

    pip install wheel
    pip install pipwin
    pipwin refresh
    
    pipwin install numpy
    pipwin install pandas
    pipwin install shapely
    pipwin install gdal
    pipwin install fiona
    pipwin install pyproj
    pipwin install six
    pipwin install rtree
    pipwin install geopandas
    pipwin install rasterio
    pipwin refresh

---

> For example and tutorial, please visit [**pyidw.readthedocs.io**](https://pyidw.readthedocs.io/en/latest/)

---
