import os
from sys import platform
import mujoco_py
if platform == "linux" or platform == "linux2":
    os.environ["MUJOCO_PY_MUJOCO_PATH"] = os.path.join(mujoco_py.__path__[0], "binaries", "linux", "mujoco210")
    os.environ["LD_LIBRARY_PATH"] = os.path.join(mujoco_py.__path__[0], "binaries", "linux", "mujoco210", "bin")
elif platform == "darwin":
    os.environ["MUJOCO_PY_MUJOCO_PATH"] = os.path.join(mujoco_py.__path__[0], "binaries", "macos", "mujoco210")
    os.environ["LD_LIBRARY_PATH"] = os.path.join(mujoco_py.__path__[0], "binaries", "macos", "mujoco210", "bin")
elif platform == "win32":
    os.environ["MUJOCO_PY_MUJOCO_PATH"] = os.path.join(mujoco_py.__path__[0], "binaries", "windows", "mujoco210")
    os.environ["LD_LIBRARY_PATH"] = os.path.join(mujoco_py.__path__[0], "binaries", "windows", "mujoco210", "bin")

#!/usr/bin/env python
from mujoco_py.builder import cymj, ignore_mujoco_warnings, functions, MujocoException
from mujoco_py.generated import const
from mujoco_py.mjrenderpool import MjRenderPool
from mujoco_py.mjviewer import MjViewer, MjViewerBasic
from mujoco_py.version import __version__, get_version

load_model_from_path = cymj.load_model_from_path
load_model_from_xml = cymj.load_model_from_xml
load_model_from_mjb = cymj.load_model_from_mjb
MjSim = cymj.MjSim
MjSimState = cymj.MjSimState
MjRenderContext = cymj.MjRenderContext
MjRenderContextOffscreen = cymj.MjRenderContextOffscreen
MjRenderContextWindow = cymj.MjRenderContextWindow
MjBatchRenderer = cymj.MjBatchRenderer
GlfwContext = cymj.GlfwContext


# Public API:
__all__ = ['MjSim', 'MjSimState',
           'MjRenderContextOffscreen', 'MjRenderContextWindow',
           'MjRenderContext', 'MjViewer', 'MjViewerBasic',
           'MujocoException', 'MjRenderPool', 'MjBatchRenderer', 'GlfwContext',
           'load_model_from_path', 'load_model_from_xml',
           'load_model_from_mjb',
           'ignore_mujoco_warnings', 'const', "functions",
           "__version__", "get_version"]

